# Copyright 2014 the V8 project authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'gmock',
      'type': 'static_library',
      'dependencies': [
        'gtest.gyp:gtest',
      ],
      'sources': [
        # Sources based on files in r173 of gmock.
        'gmock/include/gmock/gmock-actions.h',
        'gmock/include/gmock/gmock-cardinalities.h',
        'gmock/include/gmock/gmock-generated-actions.h',
        'gmock/include/gmock/gmock-generated-function-mockers.h',
        'gmock/include/gmock/gmock-generated-matchers.h',
        'gmock/include/gmock/gmock-generated-nice-strict.h',
        'gmock/include/gmock/gmock-matchers.h',
        'gmock/include/gmock/gmock-spec-builders.h',
        'gmock/include/gmock/gmock.h',
        'gmock/include/gmock/internal/gmock-generated-internal-utils.h',
        'gmock/include/gmock/internal/gmock-internal-utils.h',
        'gmock/include/gmock/internal/gmock-port.h',
        'gmock/src/gmock-all.cc',
        'gmock/src/gmock-cardinalities.cc',
        'gmock/src/gmock-internal-utils.cc',
        'gmock/src/gmock-matchers.cc',
        'gmock/src/gmock-spec-builders.cc',
        'gmock/src/gmock.cc',
        'gmock-support.h',  # gMock helpers
        'gmock_custom/gmock/internal/custom/gmock-port.h',
      ],
      'sources!': [
        'gmock/src/gmock-all.cc',  # Not needed by our build.
      ],
      'include_dirs': [
        'gmock_custom',
        'gmock',
        'gmock/include',
      ],
      'all_dependent_settings': {
        'include_dirs': [
          'gmock_custom',
          'gmock/include',  # So that gmock headers can find themselves.
        ],
      },
      'export_dependent_settings': [
        'gtest.gyp:gtest',
      ],
      'conditions': [
        ['want_separate_host_toolset==1', {
          'toolsets': ['host', 'target'],
        }, {
          'toolsets': ['target'],
        }],
      ],
    },
    {
      'target_name': 'gmock_main',
      'type': 'static_library',
      'dependencies': [
        'gmock',
      ],
      'sources': [
        'gmock/src/gmock_main.cc',
      ],
    },
  ],
}
