#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1746
#define LARGE_STATE_COUNT 330
#define SYMBOL_COUNT 264
#define ALIAS_COUNT 4
#define TOKEN_COUNT 136
#define EXTERNAL_TOKEN_COUNT 8
#define FIELD_COUNT 38
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 113

enum ts_symbol_identifiers {
  sym_identifier = 1,
  sym_hash_bang_line = 2,
  anon_sym_export = 3,
  anon_sym_STAR = 4,
  anon_sym_default = 5,
  anon_sym_as = 6,
  anon_sym_LBRACE = 7,
  anon_sym_COMMA = 8,
  anon_sym_RBRACE = 9,
  anon_sym_import = 10,
  anon_sym_from = 11,
  anon_sym_with = 12,
  anon_sym_var = 13,
  anon_sym_let = 14,
  anon_sym_const = 15,
  anon_sym_else = 16,
  anon_sym_if = 17,
  anon_sym_switch = 18,
  anon_sym_for = 19,
  anon_sym_LPAREN = 20,
  anon_sym_SEMI = 21,
  anon_sym_RPAREN = 22,
  anon_sym_await = 23,
  anon_sym_in = 24,
  anon_sym_of = 25,
  anon_sym_while = 26,
  anon_sym_do = 27,
  anon_sym_try = 28,
  anon_sym_break = 29,
  anon_sym_continue = 30,
  anon_sym_debugger = 31,
  anon_sym_return = 32,
  anon_sym_throw = 33,
  anon_sym_COLON = 34,
  anon_sym_case = 35,
  anon_sym_catch = 36,
  anon_sym_finally = 37,
  anon_sym_yield = 38,
  anon_sym_EQ = 39,
  anon_sym_LBRACK = 40,
  anon_sym_RBRACK = 41,
  sym__glimmer_template_content = 42,
  sym_glimmer_opening_tag = 43,
  sym_glimmer_closing_tag = 44,
  sym_html_character_reference = 45,
  anon_sym_LT = 46,
  anon_sym_GT = 47,
  sym_jsx_identifier = 48,
  anon_sym_DOT = 49,
  anon_sym_LT_SLASH = 50,
  anon_sym_SLASH_GT = 51,
  anon_sym_DQUOTE = 52,
  anon_sym_SQUOTE = 53,
  sym_unescaped_double_jsx_string_fragment = 54,
  sym_unescaped_single_jsx_string_fragment = 55,
  anon_sym_class = 56,
  anon_sym_extends = 57,
  anon_sym_async = 58,
  anon_sym_function = 59,
  anon_sym_EQ_GT = 60,
  sym_optional_chain = 61,
  anon_sym_new = 62,
  anon_sym_PLUS_EQ = 63,
  anon_sym_DASH_EQ = 64,
  anon_sym_STAR_EQ = 65,
  anon_sym_SLASH_EQ = 66,
  anon_sym_PERCENT_EQ = 67,
  anon_sym_CARET_EQ = 68,
  anon_sym_AMP_EQ = 69,
  anon_sym_PIPE_EQ = 70,
  anon_sym_GT_GT_EQ = 71,
  anon_sym_GT_GT_GT_EQ = 72,
  anon_sym_LT_LT_EQ = 73,
  anon_sym_STAR_STAR_EQ = 74,
  anon_sym_AMP_AMP_EQ = 75,
  anon_sym_PIPE_PIPE_EQ = 76,
  anon_sym_QMARK_QMARK_EQ = 77,
  anon_sym_DOT_DOT_DOT = 78,
  anon_sym_AMP_AMP = 79,
  anon_sym_PIPE_PIPE = 80,
  anon_sym_GT_GT = 81,
  anon_sym_GT_GT_GT = 82,
  anon_sym_LT_LT = 83,
  anon_sym_AMP = 84,
  anon_sym_CARET = 85,
  anon_sym_PIPE = 86,
  anon_sym_PLUS = 87,
  anon_sym_DASH = 88,
  anon_sym_SLASH = 89,
  anon_sym_PERCENT = 90,
  anon_sym_STAR_STAR = 91,
  anon_sym_LT_EQ = 92,
  anon_sym_EQ_EQ = 93,
  anon_sym_EQ_EQ_EQ = 94,
  anon_sym_BANG_EQ = 95,
  anon_sym_BANG_EQ_EQ = 96,
  anon_sym_GT_EQ = 97,
  anon_sym_QMARK_QMARK = 98,
  anon_sym_instanceof = 99,
  anon_sym_BANG = 100,
  anon_sym_TILDE = 101,
  anon_sym_typeof = 102,
  anon_sym_void = 103,
  anon_sym_delete = 104,
  anon_sym_PLUS_PLUS = 105,
  anon_sym_DASH_DASH = 106,
  sym_unescaped_double_string_fragment = 107,
  sym_unescaped_single_string_fragment = 108,
  sym_escape_sequence = 109,
  sym_comment = 110,
  anon_sym_BQUOTE = 111,
  anon_sym_DOLLAR_LBRACE = 112,
  anon_sym_SLASH2 = 113,
  sym_regex_pattern = 114,
  sym_regex_flags = 115,
  sym_number = 116,
  sym_private_property_identifier = 117,
  anon_sym_target = 118,
  anon_sym_meta = 119,
  sym_this = 120,
  sym_super = 121,
  sym_true = 122,
  sym_false = 123,
  sym_null = 124,
  sym_undefined = 125,
  anon_sym_AT = 126,
  anon_sym_static = 127,
  aux_sym_method_definition_token1 = 128,
  anon_sym_get = 129,
  anon_sym_set = 130,
  sym__automatic_semicolon = 131,
  sym__template_chars = 132,
  sym__ternary_qmark = 133,
  sym_html_comment = 134,
  sym_jsx_text = 135,
  sym_program = 136,
  sym_export_statement = 137,
  sym_namespace_export = 138,
  sym_export_clause = 139,
  sym_export_specifier = 140,
  sym__module_export_name = 141,
  sym_declaration = 142,
  sym_import = 143,
  sym_import_statement = 144,
  sym_import_clause = 145,
  sym__from_clause = 146,
  sym_namespace_import = 147,
  sym_named_imports = 148,
  sym_import_specifier = 149,
  sym_import_attribute = 150,
  sym_statement = 151,
  sym_expression_statement = 152,
  sym_variable_declaration = 153,
  sym_lexical_declaration = 154,
  sym_variable_declarator = 155,
  sym_statement_block = 156,
  sym_else_clause = 157,
  sym_if_statement = 158,
  sym_switch_statement = 159,
  sym_for_statement = 160,
  sym_for_in_statement = 161,
  sym__for_header = 162,
  sym_while_statement = 163,
  sym_do_statement = 164,
  sym_try_statement = 165,
  sym_with_statement = 166,
  sym_break_statement = 167,
  sym_continue_statement = 168,
  sym_debugger_statement = 169,
  sym_return_statement = 170,
  sym_throw_statement = 171,
  sym_empty_statement = 172,
  sym_labeled_statement = 173,
  sym_switch_body = 174,
  sym_switch_case = 175,
  sym_switch_default = 176,
  sym_catch_clause = 177,
  sym_finally_clause = 178,
  sym_parenthesized_expression = 179,
  sym_expression = 180,
  sym_primary_expression = 181,
  sym_yield_expression = 182,
  sym_object = 183,
  sym_object_pattern = 184,
  sym_assignment_pattern = 185,
  sym_object_assignment_pattern = 186,
  sym_array = 187,
  sym_array_pattern = 188,
  sym_glimmer_template = 189,
  sym_jsx_element = 190,
  sym_jsx_expression = 191,
  sym_jsx_opening_element = 192,
  sym_nested_identifier = 193,
  sym_jsx_namespace_name = 194,
  sym_jsx_closing_element = 195,
  sym_jsx_self_closing_element = 196,
  sym_jsx_attribute = 197,
  sym__jsx_string = 198,
  sym_class = 199,
  sym_class_declaration = 200,
  sym_class_heritage = 201,
  sym_function_expression = 202,
  sym_function_declaration = 203,
  sym_generator_function = 204,
  sym_generator_function_declaration = 205,
  sym_arrow_function = 206,
  sym_call_expression = 207,
  sym_new_expression = 208,
  sym_await_expression = 209,
  sym_member_expression = 210,
  sym_subscript_expression = 211,
  sym_assignment_expression = 212,
  sym__augmented_assignment_lhs = 213,
  sym_augmented_assignment_expression = 214,
  sym__initializer = 215,
  sym__destructuring_pattern = 216,
  sym_spread_element = 217,
  sym_ternary_expression = 218,
  sym_binary_expression = 219,
  sym_unary_expression = 220,
  sym_update_expression = 221,
  sym_sequence_expression = 222,
  sym_string = 223,
  sym_template_string = 224,
  sym_template_substitution = 225,
  sym_regex = 226,
  sym_meta_property = 227,
  sym_arguments = 228,
  sym_decorator = 229,
  sym_decorator_member_expression = 230,
  sym_decorator_call_expression = 231,
  sym_class_body = 232,
  sym_field_definition = 233,
  sym_formal_parameters = 234,
  sym_class_static_block = 235,
  sym_pattern = 236,
  sym_rest_pattern = 237,
  sym_method_definition = 238,
  sym_pair = 239,
  sym_pair_pattern = 240,
  sym__property_name = 241,
  sym_computed_property_name = 242,
  aux_sym_program_repeat1 = 243,
  aux_sym_export_statement_repeat1 = 244,
  aux_sym_export_clause_repeat1 = 245,
  aux_sym_named_imports_repeat1 = 246,
  aux_sym_variable_declaration_repeat1 = 247,
  aux_sym_switch_body_repeat1 = 248,
  aux_sym_object_repeat1 = 249,
  aux_sym_object_pattern_repeat1 = 250,
  aux_sym_array_repeat1 = 251,
  aux_sym_array_pattern_repeat1 = 252,
  aux_sym_glimmer_template_repeat1 = 253,
  aux_sym_jsx_element_repeat1 = 254,
  aux_sym_jsx_opening_element_repeat1 = 255,
  aux_sym__jsx_string_repeat1 = 256,
  aux_sym__jsx_string_repeat2 = 257,
  aux_sym_sequence_expression_repeat1 = 258,
  aux_sym_string_repeat1 = 259,
  aux_sym_string_repeat2 = 260,
  aux_sym_template_string_repeat1 = 261,
  aux_sym_class_body_repeat1 = 262,
  aux_sym_formal_parameters_repeat1 = 263,
  alias_sym_property_identifier = 264,
  alias_sym_shorthand_property_identifier = 265,
  alias_sym_shorthand_property_identifier_pattern = 266,
  alias_sym_statement_identifier = 267,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_hash_bang_line] = "hash_bang_line",
  [anon_sym_export] = "export",
  [anon_sym_STAR] = "*",
  [anon_sym_default] = "default",
  [anon_sym_as] = "as",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_with] = "with",
  [anon_sym_var] = "var",
  [anon_sym_let] = "let",
  [anon_sym_const] = "const",
  [anon_sym_else] = "else",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_SEMI] = ";",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_in] = "in",
  [anon_sym_of] = "of",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_debugger] = "debugger",
  [anon_sym_return] = "return",
  [anon_sym_throw] = "throw",
  [anon_sym_COLON] = ":",
  [anon_sym_case] = "case",
  [anon_sym_catch] = "catch",
  [anon_sym_finally] = "finally",
  [anon_sym_yield] = "yield",
  [anon_sym_EQ] = "=",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [sym__glimmer_template_content] = "_glimmer_template_content",
  [sym_glimmer_opening_tag] = "glimmer_opening_tag",
  [sym_glimmer_closing_tag] = "glimmer_closing_tag",
  [sym_html_character_reference] = "html_character_reference",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [sym_jsx_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [sym_unescaped_double_jsx_string_fragment] = "string_fragment",
  [sym_unescaped_single_jsx_string_fragment] = "string_fragment",
  [anon_sym_class] = "class",
  [anon_sym_extends] = "extends",
  [anon_sym_async] = "async",
  [anon_sym_function] = "function",
  [anon_sym_EQ_GT] = "=>",
  [sym_optional_chain] = "optional_chain",
  [anon_sym_new] = "new",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_AMP_AMP_EQ] = "&&=",
  [anon_sym_PIPE_PIPE_EQ] = "||=",
  [anon_sym_QMARK_QMARK_EQ] = "\?\?=",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_AMP] = "&",
  [anon_sym_CARET] = "^",
  [anon_sym_PIPE] = "|",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ_EQ_EQ] = "===",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_BANG_EQ_EQ] = "!==",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_instanceof] = "instanceof",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_typeof] = "typeof",
  [anon_sym_void] = "void",
  [anon_sym_delete] = "delete",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [sym_comment] = "comment",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [anon_sym_SLASH2] = "/",
  [sym_regex_pattern] = "regex_pattern",
  [sym_regex_flags] = "regex_flags",
  [sym_number] = "number",
  [sym_private_property_identifier] = "private_property_identifier",
  [anon_sym_target] = "target",
  [anon_sym_meta] = "meta",
  [sym_this] = "this",
  [sym_super] = "super",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_undefined] = "undefined",
  [anon_sym_AT] = "@",
  [anon_sym_static] = "static",
  [aux_sym_method_definition_token1] = "static get",
  [anon_sym_get] = "get",
  [anon_sym_set] = "set",
  [sym__automatic_semicolon] = "_automatic_semicolon",
  [sym__template_chars] = "string_fragment",
  [sym__ternary_qmark] = "\?",
  [sym_html_comment] = "html_comment",
  [sym_jsx_text] = "jsx_text",
  [sym_program] = "program",
  [sym_export_statement] = "export_statement",
  [sym_namespace_export] = "namespace_export",
  [sym_export_clause] = "export_clause",
  [sym_export_specifier] = "export_specifier",
  [sym__module_export_name] = "_module_export_name",
  [sym_declaration] = "declaration",
  [sym_import] = "import",
  [sym_import_statement] = "import_statement",
  [sym_import_clause] = "import_clause",
  [sym__from_clause] = "_from_clause",
  [sym_namespace_import] = "namespace_import",
  [sym_named_imports] = "named_imports",
  [sym_import_specifier] = "import_specifier",
  [sym_import_attribute] = "import_attribute",
  [sym_statement] = "statement",
  [sym_expression_statement] = "expression_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_lexical_declaration] = "lexical_declaration",
  [sym_variable_declarator] = "variable_declarator",
  [sym_statement_block] = "statement_block",
  [sym_else_clause] = "else_clause",
  [sym_if_statement] = "if_statement",
  [sym_switch_statement] = "switch_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_in_statement] = "for_in_statement",
  [sym__for_header] = "_for_header",
  [sym_while_statement] = "while_statement",
  [sym_do_statement] = "do_statement",
  [sym_try_statement] = "try_statement",
  [sym_with_statement] = "with_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_debugger_statement] = "debugger_statement",
  [sym_return_statement] = "return_statement",
  [sym_throw_statement] = "throw_statement",
  [sym_empty_statement] = "empty_statement",
  [sym_labeled_statement] = "labeled_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_case] = "switch_case",
  [sym_switch_default] = "switch_default",
  [sym_catch_clause] = "catch_clause",
  [sym_finally_clause] = "finally_clause",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_expression] = "expression",
  [sym_primary_expression] = "primary_expression",
  [sym_yield_expression] = "yield_expression",
  [sym_object] = "object",
  [sym_object_pattern] = "object_pattern",
  [sym_assignment_pattern] = "assignment_pattern",
  [sym_object_assignment_pattern] = "object_assignment_pattern",
  [sym_array] = "array",
  [sym_array_pattern] = "array_pattern",
  [sym_glimmer_template] = "glimmer_template",
  [sym_jsx_element] = "jsx_element",
  [sym_jsx_expression] = "jsx_expression",
  [sym_jsx_opening_element] = "jsx_opening_element",
  [sym_nested_identifier] = "member_expression",
  [sym_jsx_namespace_name] = "jsx_namespace_name",
  [sym_jsx_closing_element] = "jsx_closing_element",
  [sym_jsx_self_closing_element] = "jsx_self_closing_element",
  [sym_jsx_attribute] = "jsx_attribute",
  [sym__jsx_string] = "string",
  [sym_class] = "class",
  [sym_class_declaration] = "class_declaration",
  [sym_class_heritage] = "class_heritage",
  [sym_function_expression] = "function_expression",
  [sym_function_declaration] = "function_declaration",
  [sym_generator_function] = "generator_function",
  [sym_generator_function_declaration] = "generator_function_declaration",
  [sym_arrow_function] = "arrow_function",
  [sym_call_expression] = "call_expression",
  [sym_new_expression] = "new_expression",
  [sym_await_expression] = "await_expression",
  [sym_member_expression] = "member_expression",
  [sym_subscript_expression] = "subscript_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym__augmented_assignment_lhs] = "_augmented_assignment_lhs",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym__initializer] = "_initializer",
  [sym__destructuring_pattern] = "_destructuring_pattern",
  [sym_spread_element] = "spread_element",
  [sym_ternary_expression] = "ternary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_sequence_expression] = "sequence_expression",
  [sym_string] = "string",
  [sym_template_string] = "template_string",
  [sym_template_substitution] = "template_substitution",
  [sym_regex] = "regex",
  [sym_meta_property] = "meta_property",
  [sym_arguments] = "arguments",
  [sym_decorator] = "decorator",
  [sym_decorator_member_expression] = "member_expression",
  [sym_decorator_call_expression] = "call_expression",
  [sym_class_body] = "class_body",
  [sym_field_definition] = "field_definition",
  [sym_formal_parameters] = "formal_parameters",
  [sym_class_static_block] = "class_static_block",
  [sym_pattern] = "pattern",
  [sym_rest_pattern] = "rest_pattern",
  [sym_method_definition] = "method_definition",
  [sym_pair] = "pair",
  [sym_pair_pattern] = "pair_pattern",
  [sym__property_name] = "_property_name",
  [sym_computed_property_name] = "computed_property_name",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_export_statement_repeat1] = "export_statement_repeat1",
  [aux_sym_export_clause_repeat1] = "export_clause_repeat1",
  [aux_sym_named_imports_repeat1] = "named_imports_repeat1",
  [aux_sym_variable_declaration_repeat1] = "variable_declaration_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym_object_repeat1] = "object_repeat1",
  [aux_sym_object_pattern_repeat1] = "object_pattern_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_array_pattern_repeat1] = "array_pattern_repeat1",
  [aux_sym_glimmer_template_repeat1] = "glimmer_template_repeat1",
  [aux_sym_jsx_element_repeat1] = "jsx_element_repeat1",
  [aux_sym_jsx_opening_element_repeat1] = "jsx_opening_element_repeat1",
  [aux_sym__jsx_string_repeat1] = "_jsx_string_repeat1",
  [aux_sym__jsx_string_repeat2] = "_jsx_string_repeat2",
  [aux_sym_sequence_expression_repeat1] = "sequence_expression_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_template_string_repeat1] = "template_string_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_formal_parameters_repeat1] = "formal_parameters_repeat1",
  [alias_sym_property_identifier] = "property_identifier",
  [alias_sym_shorthand_property_identifier] = "shorthand_property_identifier",
  [alias_sym_shorthand_property_identifier_pattern] = "shorthand_property_identifier_pattern",
  [alias_sym_statement_identifier] = "statement_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_hash_bang_line] = sym_hash_bang_line,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_debugger] = anon_sym_debugger,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_finally] = anon_sym_finally,
  [anon_sym_yield] = anon_sym_yield,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym__glimmer_template_content] = sym__glimmer_template_content,
  [sym_glimmer_opening_tag] = sym_glimmer_opening_tag,
  [sym_glimmer_closing_tag] = sym_glimmer_closing_tag,
  [sym_html_character_reference] = sym_html_character_reference,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [sym_jsx_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym_unescaped_double_jsx_string_fragment] = sym__template_chars,
  [sym_unescaped_single_jsx_string_fragment] = sym__template_chars,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [sym_optional_chain] = sym_optional_chain,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_AMP_AMP_EQ] = anon_sym_AMP_AMP_EQ,
  [anon_sym_PIPE_PIPE_EQ] = anon_sym_PIPE_PIPE_EQ,
  [anon_sym_QMARK_QMARK_EQ] = anon_sym_QMARK_QMARK_EQ,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_EQ_EQ_EQ] = anon_sym_EQ_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_BANG_EQ_EQ] = anon_sym_BANG_EQ_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_instanceof] = anon_sym_instanceof,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_typeof] = anon_sym_typeof,
  [anon_sym_void] = anon_sym_void,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [sym_unescaped_double_string_fragment] = sym__template_chars,
  [sym_unescaped_single_string_fragment] = sym__template_chars,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_comment] = sym_comment,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [anon_sym_SLASH2] = anon_sym_SLASH,
  [sym_regex_pattern] = sym_regex_pattern,
  [sym_regex_flags] = sym_regex_flags,
  [sym_number] = sym_number,
  [sym_private_property_identifier] = sym_private_property_identifier,
  [anon_sym_target] = anon_sym_target,
  [anon_sym_meta] = anon_sym_meta,
  [sym_this] = sym_this,
  [sym_super] = sym_super,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_undefined] = sym_undefined,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_static] = anon_sym_static,
  [aux_sym_method_definition_token1] = aux_sym_method_definition_token1,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_set] = anon_sym_set,
  [sym__automatic_semicolon] = sym__automatic_semicolon,
  [sym__template_chars] = sym__template_chars,
  [sym__ternary_qmark] = sym__ternary_qmark,
  [sym_html_comment] = sym_html_comment,
  [sym_jsx_text] = sym_jsx_text,
  [sym_program] = sym_program,
  [sym_export_statement] = sym_export_statement,
  [sym_namespace_export] = sym_namespace_export,
  [sym_export_clause] = sym_export_clause,
  [sym_export_specifier] = sym_export_specifier,
  [sym__module_export_name] = sym__module_export_name,
  [sym_declaration] = sym_declaration,
  [sym_import] = sym_import,
  [sym_import_statement] = sym_import_statement,
  [sym_import_clause] = sym_import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym_namespace_import] = sym_namespace_import,
  [sym_named_imports] = sym_named_imports,
  [sym_import_specifier] = sym_import_specifier,
  [sym_import_attribute] = sym_import_attribute,
  [sym_statement] = sym_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_lexical_declaration] = sym_lexical_declaration,
  [sym_variable_declarator] = sym_variable_declarator,
  [sym_statement_block] = sym_statement_block,
  [sym_else_clause] = sym_else_clause,
  [sym_if_statement] = sym_if_statement,
  [sym_switch_statement] = sym_switch_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_in_statement] = sym_for_in_statement,
  [sym__for_header] = sym__for_header,
  [sym_while_statement] = sym_while_statement,
  [sym_do_statement] = sym_do_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_with_statement] = sym_with_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_debugger_statement] = sym_debugger_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_throw_statement] = sym_throw_statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_case] = sym_switch_case,
  [sym_switch_default] = sym_switch_default,
  [sym_catch_clause] = sym_catch_clause,
  [sym_finally_clause] = sym_finally_clause,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_expression] = sym_expression,
  [sym_primary_expression] = sym_primary_expression,
  [sym_yield_expression] = sym_yield_expression,
  [sym_object] = sym_object,
  [sym_object_pattern] = sym_object_pattern,
  [sym_assignment_pattern] = sym_assignment_pattern,
  [sym_object_assignment_pattern] = sym_object_assignment_pattern,
  [sym_array] = sym_array,
  [sym_array_pattern] = sym_array_pattern,
  [sym_glimmer_template] = sym_glimmer_template,
  [sym_jsx_element] = sym_jsx_element,
  [sym_jsx_expression] = sym_jsx_expression,
  [sym_jsx_opening_element] = sym_jsx_opening_element,
  [sym_nested_identifier] = sym_member_expression,
  [sym_jsx_namespace_name] = sym_jsx_namespace_name,
  [sym_jsx_closing_element] = sym_jsx_closing_element,
  [sym_jsx_self_closing_element] = sym_jsx_self_closing_element,
  [sym_jsx_attribute] = sym_jsx_attribute,
  [sym__jsx_string] = sym_string,
  [sym_class] = sym_class,
  [sym_class_declaration] = sym_class_declaration,
  [sym_class_heritage] = sym_class_heritage,
  [sym_function_expression] = sym_function_expression,
  [sym_function_declaration] = sym_function_declaration,
  [sym_generator_function] = sym_generator_function,
  [sym_generator_function_declaration] = sym_generator_function_declaration,
  [sym_arrow_function] = sym_arrow_function,
  [sym_call_expression] = sym_call_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym__augmented_assignment_lhs] = sym__augmented_assignment_lhs,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym__initializer] = sym__initializer,
  [sym__destructuring_pattern] = sym__destructuring_pattern,
  [sym_spread_element] = sym_spread_element,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_sequence_expression] = sym_sequence_expression,
  [sym_string] = sym_string,
  [sym_template_string] = sym_template_string,
  [sym_template_substitution] = sym_template_substitution,
  [sym_regex] = sym_regex,
  [sym_meta_property] = sym_meta_property,
  [sym_arguments] = sym_arguments,
  [sym_decorator] = sym_decorator,
  [sym_decorator_member_expression] = sym_member_expression,
  [sym_decorator_call_expression] = sym_call_expression,
  [sym_class_body] = sym_class_body,
  [sym_field_definition] = sym_field_definition,
  [sym_formal_parameters] = sym_formal_parameters,
  [sym_class_static_block] = sym_class_static_block,
  [sym_pattern] = sym_pattern,
  [sym_rest_pattern] = sym_rest_pattern,
  [sym_method_definition] = sym_method_definition,
  [sym_pair] = sym_pair,
  [sym_pair_pattern] = sym_pair_pattern,
  [sym__property_name] = sym__property_name,
  [sym_computed_property_name] = sym_computed_property_name,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_export_statement_repeat1] = aux_sym_export_statement_repeat1,
  [aux_sym_export_clause_repeat1] = aux_sym_export_clause_repeat1,
  [aux_sym_named_imports_repeat1] = aux_sym_named_imports_repeat1,
  [aux_sym_variable_declaration_repeat1] = aux_sym_variable_declaration_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym_object_repeat1] = aux_sym_object_repeat1,
  [aux_sym_object_pattern_repeat1] = aux_sym_object_pattern_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_array_pattern_repeat1] = aux_sym_array_pattern_repeat1,
  [aux_sym_glimmer_template_repeat1] = aux_sym_glimmer_template_repeat1,
  [aux_sym_jsx_element_repeat1] = aux_sym_jsx_element_repeat1,
  [aux_sym_jsx_opening_element_repeat1] = aux_sym_jsx_opening_element_repeat1,
  [aux_sym__jsx_string_repeat1] = aux_sym__jsx_string_repeat1,
  [aux_sym__jsx_string_repeat2] = aux_sym__jsx_string_repeat2,
  [aux_sym_sequence_expression_repeat1] = aux_sym_sequence_expression_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_template_string_repeat1] = aux_sym_template_string_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_formal_parameters_repeat1] = aux_sym_formal_parameters_repeat1,
  [alias_sym_property_identifier] = alias_sym_property_identifier,
  [alias_sym_shorthand_property_identifier] = alias_sym_shorthand_property_identifier,
  [alias_sym_shorthand_property_identifier_pattern] = alias_sym_shorthand_property_identifier_pattern,
  [alias_sym_statement_identifier] = alias_sym_statement_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_hash_bang_line] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_debugger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finally] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yield] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym__glimmer_template_content] = {
    .visible = false,
    .named = true,
  },
  [sym_glimmer_opening_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_html_character_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_jsx_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_jsx_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_jsx_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [sym_optional_chain] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_instanceof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH2] = {
    .visible = true,
    .named = false,
  },
  [sym_regex_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_flags] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_private_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_target] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_meta] = {
    .visible = true,
    .named = false,
  },
  [sym_this] = {
    .visible = true,
    .named = true,
  },
  [sym_super] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_undefined] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_method_definition_token1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [sym__automatic_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__template_chars] = {
    .visible = true,
    .named = true,
  },
  [sym__ternary_qmark] = {
    .visible = true,
    .named = false,
  },
  [sym_html_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_text] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_export_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_export] = {
    .visible = true,
    .named = true,
  },
  [sym_export_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_export_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym__module_export_name] = {
    .visible = false,
    .named = true,
  },
  [sym_declaration] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym_namespace_import] = {
    .visible = true,
    .named = true,
  },
  [sym_named_imports] = {
    .visible = true,
    .named = true,
  },
  [sym_import_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_import_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_lexical_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declarator] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_block] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_in_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__for_header] = {
    .visible = false,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_with_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debugger_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_throw_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_default] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_finally_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_yield_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_object] = {
    .visible = true,
    .named = true,
  },
  [sym_object_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_object_assignment_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_array_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_glimmer_template] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_opening_element] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_self_closing_element] = {
    .visible = true,
    .named = true,
  },
  [sym_jsx_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__jsx_string] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_class_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_class_heritage] = {
    .visible = true,
    .named = true,
  },
  [sym_function_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function] = {
    .visible = true,
    .named = true,
  },
  [sym_generator_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_arrow_function] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__augmented_assignment_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__initializer] = {
    .visible = false,
    .named = true,
  },
  [sym__destructuring_pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_spread_element] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_string] = {
    .visible = true,
    .named = true,
  },
  [sym_template_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_property] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_decorator_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_class_static_block] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_rest_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_method_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_pair_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__property_name] = {
    .visible = false,
    .named = true,
  },
  [sym_computed_property_name] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_clause_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_imports_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_object_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_glimmer_template_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_jsx_opening_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__jsx_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_formal_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_shorthand_property_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_statement_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_argument = 3,
  field_arguments = 4,
  field_attribute = 5,
  field_body = 6,
  field_close_tag = 7,
  field_condition = 8,
  field_consequence = 9,
  field_constructor = 10,
  field_content = 11,
  field_declaration = 12,
  field_decorator = 13,
  field_finalizer = 14,
  field_flags = 15,
  field_function = 16,
  field_handler = 17,
  field_increment = 18,
  field_index = 19,
  field_initializer = 20,
  field_key = 21,
  field_kind = 22,
  field_label = 23,
  field_left = 24,
  field_member = 25,
  field_name = 26,
  field_object = 27,
  field_open_tag = 28,
  field_operator = 29,
  field_optional_chain = 30,
  field_parameter = 31,
  field_parameters = 32,
  field_pattern = 33,
  field_property = 34,
  field_right = 35,
  field_source = 36,
  field_template = 37,
  field_value = 38,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_attribute] = "attribute",
  [field_body] = "body",
  [field_close_tag] = "close_tag",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_constructor] = "constructor",
  [field_content] = "content",
  [field_declaration] = "declaration",
  [field_decorator] = "decorator",
  [field_finalizer] = "finalizer",
  [field_flags] = "flags",
  [field_function] = "function",
  [field_handler] = "handler",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_kind] = "kind",
  [field_label] = "label",
  [field_left] = "left",
  [field_member] = "member",
  [field_name] = "name",
  [field_object] = "object",
  [field_open_tag] = "open_tag",
  [field_operator] = "operator",
  [field_optional_chain] = "optional_chain",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_pattern] = "pattern",
  [field_property] = "property",
  [field_right] = "right",
  [field_source] = "source",
  [field_template] = "template",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 1},
  [7] = {.index = 4, .length = 2},
  [8] = {.index = 6, .length = 1},
  [9] = {.index = 7, .length = 2},
  [10] = {.index = 9, .length = 2},
  [11] = {.index = 11, .length = 2},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 1},
  [14] = {.index = 16, .length = 2},
  [15] = {.index = 18, .length = 2},
  [16] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 1},
  [21] = {.index = 23, .length = 2},
  [22] = {.index = 25, .length = 2},
  [23] = {.index = 27, .length = 1},
  [24] = {.index = 28, .length = 2},
  [25] = {.index = 30, .length = 2},
  [26] = {.index = 32, .length = 6},
  [27] = {.index = 38, .length = 2},
  [28] = {.index = 40, .length = 2},
  [29] = {.index = 42, .length = 2},
  [30] = {.index = 44, .length = 1},
  [31] = {.index = 45, .length = 3},
  [32] = {.index = 48, .length = 1},
  [33] = {.index = 49, .length = 1},
  [34] = {.index = 50, .length = 1},
  [35] = {.index = 51, .length = 1},
  [36] = {.index = 52, .length = 1},
  [37] = {.index = 53, .length = 2},
  [38] = {.index = 55, .length = 1},
  [39] = {.index = 56, .length = 2},
  [40] = {.index = 58, .length = 2},
  [41] = {.index = 60, .length = 1},
  [42] = {.index = 18, .length = 2},
  [43] = {.index = 20, .length = 2},
  [44] = {.index = 61, .length = 3},
  [45] = {.index = 64, .length = 2},
  [46] = {.index = 64, .length = 2},
  [47] = {.index = 66, .length = 3},
  [48] = {.index = 66, .length = 3},
  [49] = {.index = 69, .length = 3},
  [50] = {.index = 72, .length = 2},
  [51] = {.index = 74, .length = 2},
  [52] = {.index = 76, .length = 2},
  [53] = {.index = 78, .length = 2},
  [54] = {.index = 80, .length = 1},
  [55] = {.index = 81, .length = 1},
  [56] = {.index = 18, .length = 2},
  [57] = {.index = 82, .length = 2},
  [58] = {.index = 84, .length = 3},
  [59] = {.index = 87, .length = 1},
  [60] = {.index = 88, .length = 3},
  [61] = {.index = 91, .length = 6},
  [62] = {.index = 97, .length = 2},
  [63] = {.index = 99, .length = 3},
  [64] = {.index = 102, .length = 2},
  [65] = {.index = 104, .length = 2},
  [66] = {.index = 106, .length = 1},
  [67] = {.index = 107, .length = 2},
  [68] = {.index = 109, .length = 2},
  [69] = {.index = 111, .length = 2},
  [70] = {.index = 113, .length = 4},
  [71] = {.index = 117, .length = 2},
  [72] = {.index = 119, .length = 2},
  [73] = {.index = 121, .length = 2},
  [74] = {.index = 119, .length = 2},
  [75] = {.index = 123, .length = 2},
  [76] = {.index = 125, .length = 3},
  [77] = {.index = 128, .length = 2},
  [78] = {.index = 130, .length = 2},
  [79] = {.index = 132, .length = 2},
  [80] = {.index = 134, .length = 3},
  [81] = {.index = 137, .length = 2},
  [82] = {.index = 139, .length = 2},
  [83] = {.index = 141, .length = 4},
  [84] = {.index = 145, .length = 2},
  [85] = {.index = 147, .length = 2},
  [86] = {.index = 149, .length = 3},
  [87] = {.index = 152, .length = 2},
  [88] = {.index = 154, .length = 3},
  [89] = {.index = 157, .length = 3},
  [90] = {.index = 160, .length = 3},
  [91] = {.index = 163, .length = 2},
  [92] = {.index = 165, .length = 3},
  [93] = {.index = 168, .length = 4},
  [94] = {.index = 172, .length = 3},
  [95] = {.index = 172, .length = 3},
  [96] = {.index = 175, .length = 3},
  [97] = {.index = 178, .length = 3},
  [98] = {.index = 181, .length = 3},
  [99] = {.index = 184, .length = 4},
  [100] = {.index = 188, .length = 2},
  [101] = {.index = 190, .length = 4},
  [102] = {.index = 194, .length = 4},
  [103] = {.index = 198, .length = 4},
  [104] = {.index = 202, .length = 3},
  [105] = {.index = 205, .length = 2},
  [106] = {.index = 207, .length = 4},
  [107] = {.index = 211, .length = 5},
  [108] = {.index = 216, .length = 4},
  [109] = {.index = 220, .length = 5},
  [110] = {.index = 225, .length = 4},
  [111] = {.index = 229, .length = 4},
  [112] = {.index = 233, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_decorator, 0},
  [1] =
    {field_declaration, 1},
  [2] =
    {field_name, 0},
  [3] =
    {field_body, 1},
  [4] =
    {field_close_tag, 1},
    {field_open_tag, 0},
  [6] =
    {field_constructor, 1},
  [7] =
    {field_argument, 1},
    {field_operator, 0},
  [9] =
    {field_arguments, 1},
    {field_function, 0},
  [11] =
    {field_argument, 0},
    {field_operator, 1},
  [13] =
    {field_decorator, 0, .inherited = true},
    {field_decorator, 1, .inherited = true},
  [15] =
    {field_declaration, 2},
  [16] =
    {field_body, 2},
    {field_label, 0},
  [18] =
    {field_left, 0},
    {field_right, 2},
  [20] =
    {field_body, 2},
    {field_parameter, 0},
  [22] =
    {field_source, 1},
  [23] =
    {field_body, 2},
    {field_object, 1},
  [25] =
    {field_name, 0},
    {field_value, 1, .inherited = true},
  [27] =
    {field_kind, 0},
  [28] =
    {field_condition, 1},
    {field_consequence, 2},
  [30] =
    {field_body, 2},
    {field_value, 1},
  [32] =
    {field_body, 2},
    {field_kind, 1, .inherited = true},
    {field_left, 1, .inherited = true},
    {field_operator, 1, .inherited = true},
    {field_right, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [38] =
    {field_body, 2},
    {field_condition, 1},
  [40] =
    {field_body, 1},
    {field_handler, 2},
  [42] =
    {field_body, 1},
    {field_finalizer, 2},
  [44] =
    {field_label, 1},
  [45] =
    {field_close_tag, 2},
    {field_content, 1},
    {field_open_tag, 0},
  [48] =
    {field_name, 1},
  [49] =
    {field_attribute, 0},
  [50] =
    {field_template, 0},
  [51] =
    {field_member, 0},
  [52] =
    {field_property, 0},
  [53] =
    {field_body, 2},
    {field_name, 1},
  [55] =
    {field_body, 2},
  [56] =
    {field_body, 2},
    {field_parameters, 1},
  [58] =
    {field_arguments, 2},
    {field_constructor, 1},
  [60] =
    {field_pattern, 1},
  [61] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [64] =
    {field_object, 0},
    {field_property, 2},
  [66] =
    {field_object, 0},
    {field_optional_chain, 1},
    {field_property, 2},
  [69] =
    {field_arguments, 2},
    {field_function, 0},
    {field_optional_chain, 1},
  [72] =
    {field_close_tag, 2},
    {field_open_tag, 0},
  [74] =
    {field_body, 2},
    {field_parameters, 0},
  [76] =
    {field_declaration, 2},
    {field_decorator, 0, .inherited = true},
  [78] =
    {field_body, 2},
    {field_decorator, 0, .inherited = true},
  [80] =
    {field_source, 2, .inherited = true},
  [81] =
    {field_value, 2},
  [82] =
    {field_key, 0},
    {field_value, 2},
  [84] =
    {field_body, 2},
    {field_name, 0},
    {field_parameters, 1},
  [87] =
    {field_value, 1},
  [88] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [91] =
    {field_body, 3},
    {field_kind, 2, .inherited = true},
    {field_left, 2, .inherited = true},
    {field_operator, 2, .inherited = true},
    {field_right, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [97] =
    {field_body, 1},
    {field_condition, 3},
  [99] =
    {field_body, 1},
    {field_finalizer, 3},
    {field_handler, 2},
  [102] =
    {field_attribute, 2, .inherited = true},
    {field_name, 1},
  [104] =
    {field_attribute, 0, .inherited = true},
    {field_attribute, 1, .inherited = true},
  [106] =
    {field_property, 1},
  [107] =
    {field_property, 0},
    {field_value, 1, .inherited = true},
  [109] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
  [111] =
    {field_member, 1, .inherited = true},
    {field_template, 1, .inherited = true},
  [113] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
    {field_template, 0, .inherited = true},
    {field_template, 1, .inherited = true},
  [117] =
    {field_body, 3},
    {field_name, 1},
  [119] =
    {field_body, 3},
    {field_parameter, 1},
  [121] =
    {field_body, 3},
    {field_parameters, 2},
  [123] =
    {field_body, 3},
    {field_parameters, 1},
  [125] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [128] =
    {field_flags, 3},
    {field_pattern, 1},
  [130] =
    {field_index, 2},
    {field_object, 0},
  [132] =
    {field_declaration, 3},
    {field_decorator, 0, .inherited = true},
  [134] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [137] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
  [139] =
    {field_alias, 2},
    {field_name, 0},
  [141] =
    {field_body, 3},
    {field_decorator, 0, .inherited = true},
    {field_name, 1},
    {field_parameters, 2},
  [145] =
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [147] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
  [149] =
    {field_decorator, 0, .inherited = true},
    {field_property, 1},
    {field_value, 2, .inherited = true},
  [152] =
    {field_body, 4},
    {field_parameters, 3},
  [154] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [157] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [160] =
    {field_index, 3},
    {field_object, 0},
    {field_optional_chain, 1},
  [163] =
    {field_decorator, 0, .inherited = true},
    {field_value, 3},
  [165] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
  [168] =
    {field_body, 4},
    {field_decorator, 0, .inherited = true},
    {field_name, 2},
    {field_parameters, 3},
  [172] =
    {field_left, 1},
    {field_operator, 2},
    {field_right, 3},
  [175] =
    {field_body, 5},
    {field_condition, 3},
    {field_initializer, 2},
  [178] =
    {field_decorator, 0, .inherited = true},
    {field_property, 2},
    {field_value, 3, .inherited = true},
  [181] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [184] =
    {field_body, 5},
    {field_decorator, 0, .inherited = true},
    {field_name, 3},
    {field_parameters, 4},
  [188] =
    {field_body, 3},
    {field_value, 1},
  [190] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 3},
    {field_right, 4},
  [194] =
    {field_body, 6},
    {field_condition, 3},
    {field_increment, 4},
    {field_initializer, 2},
  [198] =
    {field_body, 6},
    {field_condition, 3},
    {field_condition, 4},
    {field_initializer, 2},
  [202] =
    {field_body, 6},
    {field_condition, 4},
    {field_initializer, 2},
  [205] =
    {field_body, 4},
    {field_parameter, 2},
  [207] =
    {field_body, 6},
    {field_decorator, 0, .inherited = true},
    {field_name, 4},
    {field_parameters, 5},
  [211] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
    {field_value, 3, .inherited = true},
  [216] =
    {field_kind, 1},
    {field_left, 2},
    {field_operator, 4},
    {field_right, 5},
  [220] =
    {field_body, 7},
    {field_condition, 3},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [225] =
    {field_body, 7},
    {field_condition, 4},
    {field_increment, 5},
    {field_initializer, 2},
  [229] =
    {field_body, 7},
    {field_condition, 4},
    {field_condition, 5},
    {field_initializer, 2},
  [233] =
    {field_body, 8},
    {field_condition, 4},
    {field_condition, 5},
    {field_increment, 6},
    {field_initializer, 2},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier,
  },
  [4] = {
    [0] = alias_sym_property_identifier,
  },
  [14] = {
    [0] = alias_sym_statement_identifier,
  },
  [15] = {
    [0] = sym_identifier,
  },
  [16] = {
    [0] = sym_identifier,
  },
  [17] = {
    [1] = alias_sym_shorthand_property_identifier,
  },
  [18] = {
    [1] = alias_sym_shorthand_property_identifier_pattern,
  },
  [19] = {
    [1] = sym_identifier,
  },
  [30] = {
    [1] = alias_sym_statement_identifier,
  },
  [45] = {
    [2] = alias_sym_property_identifier,
  },
  [47] = {
    [2] = alias_sym_property_identifier,
  },
  [56] = {
    [0] = alias_sym_shorthand_property_identifier_pattern,
  },
  [72] = {
    [1] = sym_identifier,
  },
  [94] = {
    [1] = sym_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 13,
  [18] = 16,
  [19] = 16,
  [20] = 13,
  [21] = 16,
  [22] = 13,
  [23] = 16,
  [24] = 13,
  [25] = 13,
  [26] = 16,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 27,
  [35] = 35,
  [36] = 36,
  [37] = 30,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 41,
  [45] = 28,
  [46] = 38,
  [47] = 36,
  [48] = 31,
  [49] = 39,
  [50] = 40,
  [51] = 32,
  [52] = 52,
  [53] = 29,
  [54] = 42,
  [55] = 43,
  [56] = 33,
  [57] = 52,
  [58] = 58,
  [59] = 58,
  [60] = 58,
  [61] = 58,
  [62] = 58,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 64,
  [75] = 75,
  [76] = 76,
  [77] = 64,
  [78] = 64,
  [79] = 79,
  [80] = 64,
  [81] = 81,
  [82] = 82,
  [83] = 64,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 86,
  [88] = 85,
  [89] = 89,
  [90] = 89,
  [91] = 91,
  [92] = 92,
  [93] = 92,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 96,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 98,
  [103] = 98,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 105,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 110,
  [113] = 113,
  [114] = 113,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 118,
  [120] = 115,
  [121] = 116,
  [122] = 122,
  [123] = 122,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 124,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 128,
  [137] = 137,
  [138] = 125,
  [139] = 139,
  [140] = 140,
  [141] = 135,
  [142] = 137,
  [143] = 143,
  [144] = 140,
  [145] = 145,
  [146] = 146,
  [147] = 135,
  [148] = 140,
  [149] = 137,
  [150] = 124,
  [151] = 134,
  [152] = 125,
  [153] = 143,
  [154] = 128,
  [155] = 155,
  [156] = 146,
  [157] = 140,
  [158] = 135,
  [159] = 125,
  [160] = 128,
  [161] = 137,
  [162] = 134,
  [163] = 124,
  [164] = 140,
  [165] = 135,
  [166] = 137,
  [167] = 124,
  [168] = 134,
  [169] = 125,
  [170] = 134,
  [171] = 128,
  [172] = 172,
  [173] = 139,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 181,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 187,
  [203] = 203,
  [204] = 188,
  [205] = 179,
  [206] = 206,
  [207] = 189,
  [208] = 190,
  [209] = 185,
  [210] = 191,
  [211] = 174,
  [212] = 192,
  [213] = 193,
  [214] = 194,
  [215] = 195,
  [216] = 196,
  [217] = 197,
  [218] = 198,
  [219] = 199,
  [220] = 200,
  [221] = 183,
  [222] = 203,
  [223] = 201,
  [224] = 183,
  [225] = 184,
  [226] = 185,
  [227] = 181,
  [228] = 187,
  [229] = 188,
  [230] = 189,
  [231] = 191,
  [232] = 192,
  [233] = 194,
  [234] = 195,
  [235] = 196,
  [236] = 197,
  [237] = 198,
  [238] = 199,
  [239] = 200,
  [240] = 201,
  [241] = 241,
  [242] = 242,
  [243] = 184,
  [244] = 179,
  [245] = 174,
  [246] = 246,
  [247] = 247,
  [248] = 203,
  [249] = 184,
  [250] = 185,
  [251] = 181,
  [252] = 187,
  [253] = 188,
  [254] = 206,
  [255] = 189,
  [256] = 191,
  [257] = 192,
  [258] = 193,
  [259] = 194,
  [260] = 195,
  [261] = 196,
  [262] = 197,
  [263] = 198,
  [264] = 199,
  [265] = 200,
  [266] = 201,
  [267] = 242,
  [268] = 268,
  [269] = 179,
  [270] = 206,
  [271] = 174,
  [272] = 183,
  [273] = 273,
  [274] = 183,
  [275] = 184,
  [276] = 185,
  [277] = 181,
  [278] = 187,
  [279] = 206,
  [280] = 188,
  [281] = 189,
  [282] = 191,
  [283] = 192,
  [284] = 193,
  [285] = 194,
  [286] = 195,
  [287] = 196,
  [288] = 197,
  [289] = 198,
  [290] = 199,
  [291] = 200,
  [292] = 201,
  [293] = 179,
  [294] = 174,
  [295] = 206,
  [296] = 193,
  [297] = 297,
  [298] = 297,
  [299] = 297,
  [300] = 300,
  [301] = 301,
  [302] = 300,
  [303] = 300,
  [304] = 301,
  [305] = 305,
  [306] = 305,
  [307] = 305,
  [308] = 308,
  [309] = 308,
  [310] = 308,
  [311] = 311,
  [312] = 311,
  [313] = 313,
  [314] = 72,
  [315] = 70,
  [316] = 316,
  [317] = 316,
  [318] = 311,
  [319] = 319,
  [320] = 311,
  [321] = 71,
  [322] = 73,
  [323] = 311,
  [324] = 324,
  [325] = 324,
  [326] = 319,
  [327] = 327,
  [328] = 311,
  [329] = 324,
  [330] = 327,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 71,
  [335] = 72,
  [336] = 73,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 319,
  [345] = 70,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 68,
  [350] = 69,
  [351] = 351,
  [352] = 311,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 355,
  [357] = 357,
  [358] = 311,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 332,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 401,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 311,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 432,
  [434] = 432,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 347,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 441,
  [443] = 440,
  [444] = 444,
  [445] = 430,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 347,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 440,
  [456] = 436,
  [457] = 435,
  [458] = 458,
  [459] = 431,
  [460] = 460,
  [461] = 441,
  [462] = 462,
  [463] = 429,
  [464] = 458,
  [465] = 441,
  [466] = 437,
  [467] = 441,
  [468] = 440,
  [469] = 469,
  [470] = 347,
  [471] = 430,
  [472] = 472,
  [473] = 440,
  [474] = 460,
  [475] = 475,
  [476] = 440,
  [477] = 439,
  [478] = 462,
  [479] = 475,
  [480] = 441,
  [481] = 469,
  [482] = 472,
  [483] = 483,
  [484] = 430,
  [485] = 485,
  [486] = 430,
  [487] = 483,
  [488] = 488,
  [489] = 489,
  [490] = 458,
  [491] = 485,
  [492] = 440,
  [493] = 441,
  [494] = 460,
  [495] = 495,
  [496] = 483,
  [497] = 489,
  [498] = 440,
  [499] = 488,
  [500] = 441,
  [501] = 440,
  [502] = 441,
  [503] = 495,
  [504] = 430,
  [505] = 63,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 70,
  [511] = 511,
  [512] = 512,
  [513] = 72,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 73,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 68,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 69,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 71,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 527,
  [579] = 579,
  [580] = 68,
  [581] = 581,
  [582] = 582,
  [583] = 71,
  [584] = 70,
  [585] = 72,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 73,
  [603] = 506,
  [604] = 507,
  [605] = 605,
  [606] = 69,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 509,
  [611] = 574,
  [612] = 523,
  [613] = 613,
  [614] = 517,
  [615] = 514,
  [616] = 574,
  [617] = 511,
  [618] = 508,
  [619] = 515,
  [620] = 63,
  [621] = 621,
  [622] = 564,
  [623] = 527,
  [624] = 63,
  [625] = 523,
  [626] = 512,
  [627] = 509,
  [628] = 559,
  [629] = 544,
  [630] = 595,
  [631] = 613,
  [632] = 509,
  [633] = 76,
  [634] = 575,
  [635] = 635,
  [636] = 596,
  [637] = 568,
  [638] = 597,
  [639] = 569,
  [640] = 598,
  [641] = 599,
  [642] = 519,
  [643] = 543,
  [644] = 609,
  [645] = 590,
  [646] = 570,
  [647] = 539,
  [648] = 541,
  [649] = 531,
  [650] = 566,
  [651] = 552,
  [652] = 548,
  [653] = 516,
  [654] = 530,
  [655] = 550,
  [656] = 549,
  [657] = 581,
  [658] = 521,
  [659] = 551,
  [660] = 558,
  [661] = 79,
  [662] = 545,
  [663] = 582,
  [664] = 571,
  [665] = 591,
  [666] = 600,
  [667] = 592,
  [668] = 561,
  [669] = 81,
  [670] = 605,
  [671] = 562,
  [672] = 572,
  [673] = 581,
  [674] = 582,
  [675] = 607,
  [676] = 82,
  [677] = 573,
  [678] = 533,
  [679] = 586,
  [680] = 534,
  [681] = 537,
  [682] = 587,
  [683] = 588,
  [684] = 589,
  [685] = 535,
  [686] = 686,
  [687] = 591,
  [688] = 592,
  [689] = 593,
  [690] = 594,
  [691] = 595,
  [692] = 613,
  [693] = 596,
  [694] = 597,
  [695] = 598,
  [696] = 599,
  [697] = 600,
  [698] = 601,
  [699] = 84,
  [700] = 605,
  [701] = 607,
  [702] = 608,
  [703] = 65,
  [704] = 608,
  [705] = 609,
  [706] = 520,
  [707] = 66,
  [708] = 525,
  [709] = 528,
  [710] = 529,
  [711] = 67,
  [712] = 563,
  [713] = 576,
  [714] = 593,
  [715] = 522,
  [716] = 509,
  [717] = 524,
  [718] = 601,
  [719] = 579,
  [720] = 553,
  [721] = 577,
  [722] = 532,
  [723] = 594,
  [724] = 536,
  [725] = 554,
  [726] = 540,
  [727] = 554,
  [728] = 567,
  [729] = 635,
  [730] = 538,
  [731] = 574,
  [732] = 527,
  [733] = 523,
  [734] = 555,
  [735] = 587,
  [736] = 556,
  [737] = 588,
  [738] = 526,
  [739] = 589,
  [740] = 586,
  [741] = 557,
  [742] = 546,
  [743] = 579,
  [744] = 542,
  [745] = 590,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 686,
  [757] = 757,
  [758] = 758,
  [759] = 574,
  [760] = 527,
  [761] = 523,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 595,
  [767] = 767,
  [768] = 599,
  [769] = 600,
  [770] = 601,
  [771] = 605,
  [772] = 767,
  [773] = 579,
  [774] = 607,
  [775] = 608,
  [776] = 776,
  [777] = 777,
  [778] = 609,
  [779] = 581,
  [780] = 635,
  [781] = 781,
  [782] = 582,
  [783] = 783,
  [784] = 764,
  [785] = 586,
  [786] = 613,
  [787] = 777,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 790,
  [792] = 792,
  [793] = 765,
  [794] = 789,
  [795] = 795,
  [796] = 762,
  [797] = 587,
  [798] = 749,
  [799] = 799,
  [800] = 789,
  [801] = 596,
  [802] = 802,
  [803] = 803,
  [804] = 763,
  [805] = 589,
  [806] = 597,
  [807] = 590,
  [808] = 598,
  [809] = 809,
  [810] = 591,
  [811] = 594,
  [812] = 763,
  [813] = 813,
  [814] = 574,
  [815] = 789,
  [816] = 527,
  [817] = 592,
  [818] = 818,
  [819] = 523,
  [820] = 802,
  [821] = 821,
  [822] = 813,
  [823] = 823,
  [824] = 621,
  [825] = 825,
  [826] = 593,
  [827] = 788,
  [828] = 809,
  [829] = 795,
  [830] = 588,
  [831] = 600,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 554,
  [836] = 832,
  [837] = 579,
  [838] = 838,
  [839] = 839,
  [840] = 832,
  [841] = 841,
  [842] = 832,
  [843] = 832,
  [844] = 832,
  [845] = 758,
  [846] = 581,
  [847] = 509,
  [848] = 586,
  [849] = 587,
  [850] = 588,
  [851] = 589,
  [852] = 590,
  [853] = 591,
  [854] = 592,
  [855] = 593,
  [856] = 594,
  [857] = 595,
  [858] = 613,
  [859] = 596,
  [860] = 597,
  [861] = 598,
  [862] = 599,
  [863] = 601,
  [864] = 605,
  [865] = 607,
  [866] = 608,
  [867] = 609,
  [868] = 582,
  [869] = 869,
  [870] = 869,
  [871] = 871,
  [872] = 749,
  [873] = 873,
  [874] = 871,
  [875] = 869,
  [876] = 869,
  [877] = 869,
  [878] = 878,
  [879] = 879,
  [880] = 879,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 881,
  [885] = 881,
  [886] = 882,
  [887] = 881,
  [888] = 882,
  [889] = 882,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 892,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 895,
  [898] = 896,
  [899] = 896,
  [900] = 895,
  [901] = 895,
  [902] = 896,
  [903] = 895,
  [904] = 896,
  [905] = 896,
  [906] = 895,
  [907] = 907,
  [908] = 908,
  [909] = 908,
  [910] = 908,
  [911] = 908,
  [912] = 908,
  [913] = 908,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 70,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 72,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 575,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 73,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 71,
  [978] = 545,
  [979] = 979,
  [980] = 929,
  [981] = 981,
  [982] = 982,
  [983] = 929,
  [984] = 984,
  [985] = 920,
  [986] = 982,
  [987] = 919,
  [988] = 988,
  [989] = 989,
  [990] = 543,
  [991] = 991,
  [992] = 992,
  [993] = 964,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 989,
  [1001] = 1001,
  [1002] = 933,
  [1003] = 934,
  [1004] = 1004,
  [1005] = 965,
  [1006] = 966,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 996,
  [1011] = 994,
  [1012] = 964,
  [1013] = 1004,
  [1014] = 557,
  [1015] = 995,
  [1016] = 999,
  [1017] = 1008,
  [1018] = 1009,
  [1019] = 997,
  [1020] = 998,
  [1021] = 1001,
  [1022] = 1022,
  [1023] = 524,
  [1024] = 1022,
  [1025] = 1025,
  [1026] = 1026,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 1029,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1028,
  [1033] = 1028,
  [1034] = 1028,
  [1035] = 1025,
  [1036] = 1027,
  [1037] = 1030,
  [1038] = 1038,
  [1039] = 1038,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1029,
  [1043] = 1031,
  [1044] = 1041,
  [1045] = 1026,
  [1046] = 1040,
  [1047] = 1028,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1049,
  [1051] = 1051,
  [1052] = 1051,
  [1053] = 1051,
  [1054] = 1049,
  [1055] = 1055,
  [1056] = 1055,
  [1057] = 1055,
  [1058] = 1055,
  [1059] = 1051,
  [1060] = 1049,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1061,
  [1065] = 1061,
  [1066] = 1063,
  [1067] = 1061,
  [1068] = 1063,
  [1069] = 1063,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1070,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1072,
  [1077] = 1074,
  [1078] = 1070,
  [1079] = 1075,
  [1080] = 1071,
  [1081] = 1072,
  [1082] = 1074,
  [1083] = 1075,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1072,
  [1088] = 1071,
  [1089] = 1070,
  [1090] = 1074,
  [1091] = 1075,
  [1092] = 1071,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1098,
  [1103] = 1103,
  [1104] = 1098,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1098,
  [1116] = 1098,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1098,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1106,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1110,
  [1132] = 1097,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1096,
  [1139] = 1139,
  [1140] = 1139,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1120,
  [1144] = 564,
  [1145] = 1145,
  [1146] = 517,
  [1147] = 1147,
  [1148] = 1111,
  [1149] = 1149,
  [1150] = 558,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 546,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1153,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 517,
  [1166] = 1151,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 516,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1168,
  [1174] = 1174,
  [1175] = 1164,
  [1176] = 1164,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 571,
  [1180] = 1178,
  [1181] = 549,
  [1182] = 551,
  [1183] = 570,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1164,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 536,
  [1191] = 1152,
  [1192] = 1192,
  [1193] = 570,
  [1194] = 1194,
  [1195] = 1155,
  [1196] = 1162,
  [1197] = 546,
  [1198] = 1155,
  [1199] = 1199,
  [1200] = 516,
  [1201] = 571,
  [1202] = 564,
  [1203] = 549,
  [1204] = 551,
  [1205] = 558,
  [1206] = 559,
  [1207] = 536,
  [1208] = 1189,
  [1209] = 1209,
  [1210] = 1156,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1169,
  [1214] = 1184,
  [1215] = 1155,
  [1216] = 559,
  [1217] = 1217,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1100,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 1223,
  [1224] = 1224,
  [1225] = 1223,
  [1226] = 1224,
  [1227] = 1227,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1147,
  [1231] = 1231,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1234,
  [1235] = 1235,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1159,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1239,
  [1242] = 1233,
  [1243] = 1243,
  [1244] = 1244,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1222,
  [1249] = 1239,
  [1250] = 1233,
  [1251] = 1251,
  [1252] = 1246,
  [1253] = 1247,
  [1254] = 1254,
  [1255] = 1246,
  [1256] = 1247,
  [1257] = 1257,
  [1258] = 1128,
  [1259] = 1129,
  [1260] = 1260,
  [1261] = 1236,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1245,
  [1265] = 1254,
  [1266] = 1266,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1269,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1262,
  [1275] = 1260,
  [1276] = 1239,
  [1277] = 1233,
  [1278] = 1227,
  [1279] = 1267,
  [1280] = 1280,
  [1281] = 1095,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1218,
  [1286] = 1286,
  [1287] = 1246,
  [1288] = 1247,
  [1289] = 1217,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1296,
  [1297] = 1297,
  [1298] = 1298,
  [1299] = 1299,
  [1300] = 1300,
  [1301] = 1301,
  [1302] = 1302,
  [1303] = 1303,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1296,
  [1307] = 1307,
  [1308] = 1308,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 1313,
  [1314] = 1314,
  [1315] = 1293,
  [1316] = 1316,
  [1317] = 1294,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1297,
  [1321] = 1321,
  [1322] = 1293,
  [1323] = 1323,
  [1324] = 1294,
  [1325] = 1301,
  [1326] = 1326,
  [1327] = 1302,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1330,
  [1331] = 1331,
  [1332] = 351,
  [1333] = 1333,
  [1334] = 1334,
  [1335] = 1335,
  [1336] = 1291,
  [1337] = 1326,
  [1338] = 1338,
  [1339] = 1339,
  [1340] = 1340,
  [1341] = 1341,
  [1342] = 1304,
  [1343] = 1343,
  [1344] = 1344,
  [1345] = 1345,
  [1346] = 1346,
  [1347] = 1347,
  [1348] = 1303,
  [1349] = 1349,
  [1350] = 1350,
  [1351] = 1351,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1354,
  [1355] = 1297,
  [1356] = 1356,
  [1357] = 1303,
  [1358] = 1308,
  [1359] = 1359,
  [1360] = 1360,
  [1361] = 1314,
  [1362] = 1356,
  [1363] = 1363,
  [1364] = 1364,
  [1365] = 1343,
  [1366] = 1363,
  [1367] = 1309,
  [1368] = 1314,
  [1369] = 1354,
  [1370] = 1360,
  [1371] = 1354,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 1338,
  [1378] = 1374,
  [1379] = 1312,
  [1380] = 1346,
  [1381] = 1381,
  [1382] = 1311,
  [1383] = 1372,
  [1384] = 1310,
  [1385] = 1385,
  [1386] = 1374,
  [1387] = 1372,
  [1388] = 1308,
  [1389] = 1373,
  [1390] = 1390,
  [1391] = 1296,
  [1392] = 1381,
  [1393] = 1335,
  [1394] = 1296,
  [1395] = 1395,
  [1396] = 1396,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1399,
  [1400] = 1400,
  [1401] = 1401,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 1404,
  [1405] = 1405,
  [1406] = 1406,
  [1407] = 1407,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1410,
  [1411] = 1411,
  [1412] = 1412,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 1427,
  [1428] = 1428,
  [1429] = 1429,
  [1430] = 539,
  [1431] = 1431,
  [1432] = 1432,
  [1433] = 1433,
  [1434] = 1434,
  [1435] = 1407,
  [1436] = 1436,
  [1437] = 1437,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1441,
  [1442] = 544,
  [1443] = 526,
  [1444] = 1444,
  [1445] = 1416,
  [1446] = 1446,
  [1447] = 1418,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 1450,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1453,
  [1454] = 1454,
  [1455] = 1433,
  [1456] = 1456,
  [1457] = 1457,
  [1458] = 1458,
  [1459] = 1459,
  [1460] = 1434,
  [1461] = 1461,
  [1462] = 1462,
  [1463] = 1463,
  [1464] = 1464,
  [1465] = 1465,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1468,
  [1469] = 1469,
  [1470] = 1470,
  [1471] = 1441,
  [1472] = 1472,
  [1473] = 1473,
  [1474] = 1474,
  [1475] = 1475,
  [1476] = 1476,
  [1477] = 1472,
  [1478] = 1478,
  [1479] = 1469,
  [1480] = 1480,
  [1481] = 1481,
  [1482] = 1482,
  [1483] = 1483,
  [1484] = 1484,
  [1485] = 1485,
  [1486] = 1486,
  [1487] = 1487,
  [1488] = 1488,
  [1489] = 1489,
  [1490] = 1490,
  [1491] = 1491,
  [1492] = 1488,
  [1493] = 1493,
  [1494] = 1494,
  [1495] = 1446,
  [1496] = 1409,
  [1497] = 1497,
  [1498] = 1498,
  [1499] = 1499,
  [1500] = 1500,
  [1501] = 1501,
  [1502] = 1502,
  [1503] = 1503,
  [1504] = 1406,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1398,
  [1508] = 1399,
  [1509] = 1449,
  [1510] = 1510,
  [1511] = 1400,
  [1512] = 1416,
  [1513] = 1513,
  [1514] = 1514,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1404,
  [1518] = 1408,
  [1519] = 1436,
  [1520] = 1437,
  [1521] = 1438,
  [1522] = 1522,
  [1523] = 1418,
  [1524] = 1524,
  [1525] = 1525,
  [1526] = 1526,
  [1527] = 1499,
  [1528] = 1402,
  [1529] = 1529,
  [1530] = 1401,
  [1531] = 1421,
  [1532] = 1422,
  [1533] = 1423,
  [1534] = 1428,
  [1535] = 1448,
  [1536] = 1450,
  [1537] = 1454,
  [1538] = 1457,
  [1539] = 1462,
  [1540] = 1463,
  [1541] = 1464,
  [1542] = 1542,
  [1543] = 1543,
  [1544] = 1506,
  [1545] = 1545,
  [1546] = 1546,
  [1547] = 1547,
  [1548] = 1548,
  [1549] = 1549,
  [1550] = 1550,
  [1551] = 1551,
  [1552] = 1552,
  [1553] = 1529,
  [1554] = 1554,
  [1555] = 1451,
  [1556] = 1552,
  [1557] = 1557,
  [1558] = 1558,
  [1559] = 1559,
  [1560] = 1560,
  [1561] = 1561,
  [1562] = 1403,
  [1563] = 1444,
  [1564] = 1405,
  [1565] = 1410,
  [1566] = 1411,
  [1567] = 1516,
  [1568] = 1568,
  [1569] = 1395,
  [1570] = 1413,
  [1571] = 1546,
  [1572] = 1572,
  [1573] = 1547,
  [1574] = 1574,
  [1575] = 1500,
  [1576] = 1576,
  [1577] = 1577,
  [1578] = 1548,
  [1579] = 1503,
  [1580] = 1580,
  [1581] = 1581,
  [1582] = 1582,
  [1583] = 1583,
  [1584] = 1584,
  [1585] = 1414,
  [1586] = 1415,
  [1587] = 1587,
  [1588] = 1513,
  [1589] = 1417,
  [1590] = 1590,
  [1591] = 1419,
  [1592] = 1549,
  [1593] = 1550,
  [1594] = 1551,
  [1595] = 1424,
  [1596] = 1425,
  [1597] = 1429,
  [1598] = 1577,
  [1599] = 1568,
  [1600] = 1600,
  [1601] = 1601,
  [1602] = 1461,
  [1603] = 1603,
  [1604] = 1604,
  [1605] = 1605,
  [1606] = 1606,
  [1607] = 1475,
  [1608] = 1524,
  [1609] = 1609,
  [1610] = 1525,
  [1611] = 1572,
  [1612] = 1612,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1240,
  [1616] = 1420,
  [1617] = 1426,
  [1618] = 1456,
  [1619] = 1619,
  [1620] = 1501,
  [1621] = 1458,
  [1622] = 1465,
  [1623] = 1502,
  [1624] = 1416,
  [1625] = 1432,
  [1626] = 1480,
  [1627] = 1396,
  [1628] = 1614,
  [1629] = 1418,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1440,
  [1633] = 1466,
  [1634] = 1467,
  [1635] = 1635,
  [1636] = 1487,
  [1637] = 1453,
  [1638] = 1459,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1642,
  [1643] = 1643,
  [1644] = 1644,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1650,
  [1651] = 1651,
  [1652] = 1652,
  [1653] = 1653,
  [1654] = 1651,
  [1655] = 1653,
  [1656] = 1656,
  [1657] = 1657,
  [1658] = 1658,
  [1659] = 1659,
  [1660] = 1660,
  [1661] = 1661,
  [1662] = 1657,
  [1663] = 1663,
  [1664] = 1648,
  [1665] = 1665,
  [1666] = 1666,
  [1667] = 1667,
  [1668] = 1650,
  [1669] = 1669,
  [1670] = 1646,
  [1671] = 1663,
  [1672] = 1672,
  [1673] = 1673,
  [1674] = 1674,
  [1675] = 1675,
  [1676] = 1251,
  [1677] = 1677,
  [1678] = 1643,
  [1679] = 1653,
  [1680] = 1680,
  [1681] = 1681,
  [1682] = 1682,
  [1683] = 1683,
  [1684] = 1643,
  [1685] = 1685,
  [1686] = 1686,
  [1687] = 1644,
  [1688] = 1688,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1651,
  [1692] = 1692,
  [1693] = 1652,
  [1694] = 1647,
  [1695] = 1648,
  [1696] = 1644,
  [1697] = 1697,
  [1698] = 1698,
  [1699] = 1699,
  [1700] = 1700,
  [1701] = 1652,
  [1702] = 1661,
  [1703] = 1642,
  [1704] = 1704,
  [1705] = 1705,
  [1706] = 1704,
  [1707] = 1707,
  [1708] = 1704,
  [1709] = 1709,
  [1710] = 1710,
  [1711] = 1642,
  [1712] = 1686,
  [1713] = 1713,
  [1714] = 1704,
  [1715] = 1715,
  [1716] = 1643,
  [1717] = 1717,
  [1718] = 1661,
  [1719] = 1644,
  [1720] = 1647,
  [1721] = 1685,
  [1722] = 1648,
  [1723] = 1643,
  [1724] = 1639,
  [1725] = 1652,
  [1726] = 1661,
  [1727] = 1647,
  [1728] = 1648,
  [1729] = 1666,
  [1730] = 1730,
  [1731] = 1688,
  [1732] = 1653,
  [1733] = 1651,
  [1734] = 1652,
  [1735] = 1642,
  [1736] = 1736,
  [1737] = 1737,
  [1738] = 1647,
  [1739] = 1739,
  [1740] = 1740,
  [1741] = 1661,
  [1742] = 1682,
  [1743] = 1739,
  [1744] = 1651,
  [1745] = 1710,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\r'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200b}, {0x2028, 0x2029}, {0x202f, 0x202f}, {0x205f, 0x2060},
  {0x3000, 0x3000}, {0xfeff, 0xfeff},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'$', '$'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f}, {0x1681, 0x1fff},
  {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'$', '$'}, {'0', '9'}, {'A', 'Z'}, {'\\', '\\'}, {'_', '_'}, {'a', 'z'}, {0x7f, 0x9f}, {0xa1, 0x167f},
  {0x1681, 0x1fff}, {0x200c, 0x2027}, {0x202a, 0x202e}, {0x2030, 0x205e}, {0x2061, 0x2fff}, {0x3001, 0xfefe}, {0xff00, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(145);
      ADVANCE_MAP(
        '!', 253,
        '"', 186,
        '#', 4,
        '$', 300,
        '%', 241,
        '&', 228,
        '\'', 187,
        '(', 153,
        ')', 155,
        '*', 148,
        '+', 235,
        ',', 151,
        '-', 237,
        '.', 182,
        '/', 280,
        '0', 285,
        ':', 156,
        ';', 154,
        '<', 172,
        '=', 159,
        '>', 178,
        '?', 31,
        '@', 304,
        '[', 161,
        '\\', 99,
        ']', 162,
        '^', 231,
        '`', 278,
        's', 298,
        '{', 150,
        '|', 232,
        '}', 152,
        '~', 254,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(142);
      if (lookahead > '@') ADVANCE(302);
      END_STATE();
    case 1:
      if (lookahead == '\n') ADVANCE(305);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(2);
      if (lookahead == '/') ADVANCE(164);
      if (lookahead == '<') ADVANCE(166);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(165);
      if (lookahead != 0) ADVANCE(163);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(35);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(141);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(281);
      if (lookahead != 0) ADVANCE(282);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(146);
      if (lookahead == '\\') ADVANCE(100);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(303);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 252,
        '"', 186,
        '#', 79,
        '\'', 187,
        '(', 153,
        '*', 147,
        '+', 234,
        ',', 151,
        '-', 236,
        '.', 30,
        '/', 238,
        '0', 285,
        ';', 154,
        '<', 176,
        '@', 304,
        '[', 161,
        '\\', 101,
        '`', 278,
        's', 298,
        '{', 150,
        '}', 152,
        '~', 254,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(5);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(302);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 252,
        '"', 186,
        '#', 79,
        '\'', 187,
        '(', 153,
        '+', 234,
        '-', 236,
        '.', 183,
        '/', 238,
        '0', 285,
        ':', 156,
        '<', 176,
        '>', 177,
        '@', 304,
        '[', 161,
        '\\', 101,
        '`', 278,
        '{', 150,
        '~', 254,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(6);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(302);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 75,
        '"', 186,
        '#', 79,
        '%', 241,
        '&', 228,
        '\'', 187,
        '(', 153,
        ')', 155,
        '*', 148,
        '+', 235,
        ',', 151,
        '-', 237,
        '.', 183,
        '/', 239,
        '0', 285,
        ':', 156,
        ';', 154,
        '<', 173,
        '=', 159,
        '>', 178,
        '?', 31,
        '@', 304,
        '[', 161,
        '\\', 101,
        ']', 162,
        '^', 231,
        '`', 278,
        '{', 150,
        '|', 232,
        '}', 152,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (lookahead > '#' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(302);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 75,
        '%', 240,
        '&', 229,
        '(', 153,
        ')', 155,
        '*', 149,
        '+', 234,
        ',', 151,
        '-', 236,
        '.', 181,
        '/', 238,
        ':', 156,
        ';', 154,
        '<', 174,
        '=', 158,
        '>', 179,
        '?', 32,
        '[', 161,
        '\\', 101,
        ']', 162,
        '^', 230,
        '`', 278,
        '{', 150,
        '|', 233,
        '}', 152,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(8);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(302);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 75,
        '%', 240,
        '&', 229,
        '(', 153,
        ')', 155,
        '*', 149,
        '+', 234,
        ',', 151,
        '-', 236,
        '.', 181,
        '/', 238,
        ':', 156,
        ';', 154,
        '<', 174,
        '=', 76,
        '>', 179,
        '?', 32,
        '[', 161,
        '\\', 101,
        ']', 162,
        '^', 230,
        '`', 278,
        '{', 150,
        '|', 233,
        '}', 152,
      );
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(283);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(10);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '`' || '~' < lookahead)) ADVANCE(302);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 75,
        '%', 240,
        '&', 229,
        '(', 153,
        ')', 155,
        '*', 149,
        '+', 234,
        ',', 151,
        '-', 236,
        '.', 181,
        '/', 238,
        ':', 156,
        ';', 154,
        '<', 174,
        '=', 76,
        '>', 179,
        '?', 32,
        '[', 161,
        '\\', 101,
        ']', 162,
        '^', 230,
        '`', 278,
        '{', 150,
        '|', 233,
        '}', 152,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(10);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(302);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '"', 186,
        '#', 79,
        '&', 16,
        '\'', 187,
        '(', 153,
        '*', 147,
        '.', 183,
        '/', 24,
        '0', 285,
        '<', 171,
        '@', 304,
        '[', 161,
        '\\', 101,
        's', 298,
        '{', 150,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(11);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          lookahead != '`' &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(302);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '&') ADVANCE(17);
      if (lookahead == '/') ADVANCE(189);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(188);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '"', 186,
        '\'', 187,
        '.', 181,
        '/', 25,
        ':', 156,
        '<', 170,
        '=', 157,
        '>', 177,
        '\\', 101,
        '{', 150,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(13);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(294);
      if (lookahead > '~') ADVANCE(302);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '/') ADVANCE(24);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(14);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(186);
      if (lookahead == '/') ADVANCE(257);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(14);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(260);
      if (lookahead != 0) ADVANCE(262);
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(113);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(113);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(190);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(113);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 19:
      if (lookahead == '$') ADVANCE(103);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead == '`') ADVANCE(278);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(20);
      END_STATE();
    case 20:
      if (lookahead == '$') ADVANCE(103);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '`') ADVANCE(278);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(20);
      END_STATE();
    case 21:
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '/') ADVANCE(195);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(194);
      if (lookahead != 0) ADVANCE(196);
      END_STATE();
    case 22:
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '/') ADVANCE(24);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(22);
      END_STATE();
    case 23:
      if (lookahead == '\'') ADVANCE(187);
      if (lookahead == '/') ADVANCE(263);
      if (lookahead == '\\') ADVANCE(102);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(22);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(266);
      if (lookahead != 0) ADVANCE(268);
      END_STATE();
    case 24:
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(277);
      END_STATE();
    case 25:
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(277);
      if (lookahead == '>') ADVANCE(185);
      END_STATE();
    case 26:
      if (lookahead == '*') ADVANCE(26);
      if (lookahead == '/') ADVANCE(274);
      if (lookahead != 0) ADVANCE(27);
      END_STATE();
    case 27:
      if (lookahead == '*') ADVANCE(26);
      if (lookahead != 0) ADVANCE(27);
      END_STATE();
    case 28:
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      if (lookahead != 0) ADVANCE(192);
      END_STATE();
    case 29:
      if (lookahead == '*') ADVANCE(197);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      if (lookahead != 0) ADVANCE(198);
      END_STATE();
    case 30:
      if (lookahead == '.') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      END_STATE();
    case 31:
      if (lookahead == '.') ADVANCE(201);
      if (lookahead == '?') ADVANCE(251);
      END_STATE();
    case 32:
      if (lookahead == '.') ADVANCE(201);
      if (lookahead == '?') ADVANCE(250);
      END_STATE();
    case 33:
      if (lookahead == '.') ADVANCE(217);
      END_STATE();
    case 34:
      if (lookahead == '/') ADVANCE(280);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(35);
      END_STATE();
    case 35:
      if (lookahead == '/') ADVANCE(24);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(35);
      END_STATE();
    case 36:
      if (lookahead == ';') ADVANCE(169);
      END_STATE();
    case 37:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 38:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      END_STATE();
    case 39:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(38);
      END_STATE();
    case 40:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(39);
      END_STATE();
    case 41:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 42:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 43:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 44:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (lookahead == ';') ADVANCE(169);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(36);
      END_STATE();
    case 47:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(46);
      END_STATE();
    case 48:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(47);
      END_STATE();
    case 49:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(48);
      END_STATE();
    case 50:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(49);
      END_STATE();
    case 51:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(50);
      END_STATE();
    case 52:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(51);
      END_STATE();
    case 53:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 54:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 55:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(54);
      END_STATE();
    case 56:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(55);
      END_STATE();
    case 57:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(56);
      END_STATE();
    case 58:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(57);
      END_STATE();
    case 59:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(58);
      END_STATE();
    case 60:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(59);
      END_STATE();
    case 61:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(60);
      END_STATE();
    case 62:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(61);
      END_STATE();
    case 63:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(62);
      END_STATE();
    case 64:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(63);
      END_STATE();
    case 65:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 66:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 67:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 68:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(67);
      END_STATE();
    case 69:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 70:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(69);
      END_STATE();
    case 71:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(70);
      END_STATE();
    case 72:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(71);
      END_STATE();
    case 73:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(72);
      END_STATE();
    case 74:
      if (lookahead == ';') ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(73);
      END_STATE();
    case 75:
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 76:
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 77:
      if (lookahead == '>') ADVANCE(167);
      END_STATE();
    case 78:
      if (lookahead == '>') ADVANCE(168);
      END_STATE();
    case 79:
      if (lookahead == '\\') ADVANCE(100);
      if (set_contains(sym_identifier_character_set_1, 14, lookahead)) ADVANCE(303);
      END_STATE();
    case 80:
      if (lookahead == '\\') ADVANCE(140);
      if (lookahead == ']') ADVANCE(282);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(80);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 82:
      if (lookahead == 'a') ADVANCE(97);
      END_STATE();
    case 83:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 84:
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 86:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 88:
      if (lookahead == 'g') ADVANCE(85);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(88);
      END_STATE();
    case 89:
      if (lookahead == 'l') ADVANCE(81);
      END_STATE();
    case 90:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 91:
      if (lookahead == 'm') ADVANCE(93);
      END_STATE();
    case 92:
      if (lookahead == 'm') ADVANCE(94);
      END_STATE();
    case 93:
      if (lookahead == 'p') ADVANCE(89);
      END_STATE();
    case 94:
      if (lookahead == 'p') ADVANCE(90);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(1);
      END_STATE();
    case 96:
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 97:
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 98:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 99:
      if (lookahead == 'u') ADVANCE(104);
      if (lookahead == 'x') ADVANCE(130);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(273);
      if (lookahead != 0) ADVANCE(269);
      END_STATE();
    case 100:
      if (lookahead == 'u') ADVANCE(105);
      END_STATE();
    case 101:
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 102:
      if (lookahead == 'u') ADVANCE(107);
      if (lookahead == 'x') ADVANCE(130);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(271);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(273);
      if (lookahead != 0) ADVANCE(269);
      END_STATE();
    case 103:
      if (lookahead == '{') ADVANCE(279);
      END_STATE();
    case 104:
      if (lookahead == '{') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(135);
      END_STATE();
    case 105:
      if (lookahead == '{') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 106:
      if (lookahead == '{') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(137);
      END_STATE();
    case 107:
      if (lookahead == '{') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(127);
      END_STATE();
    case 108:
      if (lookahead == '}') ADVANCE(302);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(108);
      END_STATE();
    case 109:
      if (lookahead == '}') ADVANCE(303);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(109);
      END_STATE();
    case 110:
      if (lookahead == '}') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(110);
      END_STATE();
    case 111:
      if (lookahead == '}') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 112:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(292);
      END_STATE();
    case 113:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 114:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(288);
      END_STATE();
    case 115:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(289);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(286);
      END_STATE();
    case 117:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      END_STATE();
    case 118:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 119:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(292);
      END_STATE();
    case 120:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(302);
      END_STATE();
    case 121:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(303);
      END_STATE();
    case 122:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(269);
      END_STATE();
    case 123:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(290);
      END_STATE();
    case 124:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 125:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(270);
      END_STATE();
    case 126:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 127:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(130);
      END_STATE();
    case 128:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(109);
      END_STATE();
    case 129:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(108);
      END_STATE();
    case 130:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(122);
      END_STATE();
    case 131:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(110);
      END_STATE();
    case 132:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(125);
      END_STATE();
    case 133:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(121);
      END_STATE();
    case 134:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(120);
      END_STATE();
    case 135:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(132);
      END_STATE();
    case 136:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(133);
      END_STATE();
    case 137:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(134);
      END_STATE();
    case 138:
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(190);
      END_STATE();
    case 139:
      if (lookahead != 0 &&
          lookahead != '#' &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(196);
      END_STATE();
    case 140:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(80);
      END_STATE();
    case 141:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(282);
      END_STATE();
    case 142:
      if (eof) ADVANCE(145);
      ADVANCE_MAP(
        '!', 253,
        '"', 186,
        '#', 4,
        '$', 300,
        '%', 241,
        '&', 228,
        '\'', 187,
        '(', 153,
        ')', 155,
        '*', 148,
        '+', 235,
        ',', 151,
        '-', 237,
        '.', 182,
        '/', 239,
        '0', 285,
        ':', 156,
        ';', 154,
        '<', 172,
        '=', 159,
        '>', 178,
        '?', 31,
        '@', 304,
        '[', 161,
        '\\', 101,
        ']', 162,
        '^', 231,
        '`', 278,
        's', 298,
        '{', 150,
        '|', 232,
        '}', 152,
        '~', 254,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(142);
      if (lookahead > '@') ADVANCE(302);
      END_STATE();
    case 143:
      if (eof) ADVANCE(145);
      ADVANCE_MAP(
        '!', 253,
        '"', 186,
        '#', 79,
        '%', 240,
        '&', 229,
        '\'', 187,
        '(', 153,
        ')', 155,
        '*', 149,
        '+', 234,
        ',', 151,
        '-', 236,
        '.', 183,
        '/', 238,
        '0', 285,
        ':', 156,
        ';', 154,
        '<', 175,
        '=', 158,
        '>', 179,
        '?', 32,
        '@', 304,
        '[', 161,
        '\\', 101,
        ']', 162,
        '^', 230,
        '`', 278,
        '{', 150,
        '|', 233,
        '}', 152,
        '~', 254,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(143);
      if (lookahead > '#') ADVANCE(302);
      END_STATE();
    case 144:
      if (eof) ADVANCE(145);
      ADVANCE_MAP(
        '!', 252,
        '"', 186,
        '#', 4,
        '\'', 187,
        '(', 153,
        ')', 155,
        '*', 147,
        '+', 234,
        ',', 151,
        '-', 236,
        '.', 30,
        '/', 238,
        '0', 285,
        ':', 156,
        ';', 154,
        '<', 176,
        '=', 160,
        '>', 177,
        '@', 304,
        '[', 161,
        '\\', 101,
        ']', 162,
        '`', 278,
        '{', 150,
        '}', 152,
        '~', 254,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(144);
      if (lookahead > '#' &&
          (lookahead < '%' || '@' < lookahead) &&
          (lookahead < '[' || '^' < lookahead) &&
          (lookahead < '{' || '~' < lookahead)) ADVANCE(302);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_hash_bang_line);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(146);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(243);
      if (lookahead == '=') ADVANCE(204);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(242);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(245);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(245);
      if (lookahead == '>') ADVANCE(200);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(200);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(277);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(164);
      if (lookahead == '<') ADVANCE(166);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n') ADVANCE(165);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(163);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym__glimmer_template_content);
      if (lookahead == '/') ADVANCE(98);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_glimmer_opening_tag);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_glimmer_closing_tag);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_html_character_reference);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(184);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead == '<') ADVANCE(227);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(227);
      if (lookahead == '=') ADVANCE(244);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(226);
      if (lookahead == '=') ADVANCE(244);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(226);
      if (lookahead == '=') ADVANCE(244);
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == 't') ADVANCE(83);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(249);
      if (lookahead == '>') ADVANCE(222);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(249);
      if (lookahead == '>') ADVANCE(223);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_jsx_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(17);
      if (lookahead == '/') ADVANCE(189);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(188);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(190);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '*') ADVANCE(192);
      if (lookahead == '/') ADVANCE(193);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(190);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(190);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(28);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead == '/') ADVANCE(190);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(192);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(28);
      if (lookahead == '*') ADVANCE(191);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(192);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_unescaped_double_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(275);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(190);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(193);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '/') ADVANCE(195);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(196);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '*') ADVANCE(198);
      if (lookahead == '/') ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(196);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(29);
      if (lookahead == '*') ADVANCE(197);
      if (lookahead == '/') ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(198);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(29);
      if (lookahead == '*') ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(198);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_unescaped_single_jsx_string_fragment);
      if (lookahead == '&') ADVANCE(276);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '&' &&
          lookahead != '\'') ADVANCE(199);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_optional_chain);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_AMP_AMP_EQ);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE_EQ);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK_EQ);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      if (lookahead == '=') ADVANCE(214);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(210);
      if (lookahead == '>') ADVANCE(225);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(224);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(211);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(212);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(219);
      if (lookahead == '=') ADVANCE(208);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(218);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(207);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(209);
      if (lookahead == '|') ADVANCE(221);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(220);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(255);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(255);
      if (lookahead == '=') ADVANCE(202);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(256);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(256);
      if (lookahead == '=') ADVANCE(203);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(277);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(27);
      if (lookahead == '/') ADVANCE(277);
      if (lookahead == '=') ADVANCE(205);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(206);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(213);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '=') ADVANCE(246);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_EQ);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      if (lookahead == '=') ADVANCE(248);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_BANG_EQ_EQ);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(259);
      if (lookahead == '/') ADVANCE(261);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(262);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(258);
      if (lookahead == '/') ADVANCE(262);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(259);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(258);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(259);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(257);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(260);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(262);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(262);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(261);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(262);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(265);
      if (lookahead == '/') ADVANCE(267);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(268);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(264);
      if (lookahead == '/') ADVANCE(268);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(265);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '*') ADVANCE(264);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(265);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '/') ADVANCE(263);
      if ((set_contains(extras_character_set_1, 10, lookahead)) &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(266);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(268);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(268);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(267);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(268);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(101);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(269);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(269);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(272);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(190);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      if (lookahead != 0) ADVANCE(193);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(196);
      if (lookahead == '#' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      if (lookahead != 0) ADVANCE(199);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(277);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_SLASH2);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '\n') SKIP(35);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(141);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(281);
      if (lookahead != 0) ADVANCE(282);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_regex_pattern);
      if (lookahead == '[') ADVANCE(80);
      if (lookahead == '\\') ADVANCE(141);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '/') ADVANCE(282);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_regex_flags);
      if (lookahead == '\\') ADVANCE(101);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(283);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_number);
      ADVANCE_MAP(
        '.', 293,
        '0', 287,
        '_', 118,
        'n', 284,
        'B', 114,
        'b', 114,
        'E', 112,
        'e', 112,
        'O', 115,
        'o', 115,
        'X', 123,
        'x', 123,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(286);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(293);
      if (lookahead == '_') ADVANCE(116);
      if (lookahead == 'n') ADVANCE(284);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(286);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(118);
      if (lookahead == 'n') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(287);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(114);
      if (lookahead == 'n') ADVANCE(284);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(288);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(115);
      if (lookahead == 'n') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(289);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(123);
      if (lookahead == 'n') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(117);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(292);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(291);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(180);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(294);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == 'a') ADVANCE(299);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == 'c') ADVANCE(301);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == 'i') ADVANCE(296);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == 't') ADVANCE(295);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == 't') ADVANCE(297);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(101);
      if (lookahead == '{') ADVANCE(279);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(88);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '\\') ADVANCE(101);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(302);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_private_property_identifier);
      if (lookahead == '\\') ADVANCE(100);
      if (set_contains(sym_identifier_character_set_2, 15, lookahead)) ADVANCE(303);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(aux_sym_method_definition_token1);
      if (lookahead == '\n') ADVANCE(305);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(1);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'i', 8,
        'l', 9,
        'm', 10,
        'n', 11,
        'o', 12,
        'r', 13,
        's', 14,
        't', 15,
        'u', 16,
        'v', 17,
        'w', 18,
        'y', 19,
      );
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 'w') ADVANCE(21);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(22);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(23);
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(28);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'i') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      if (lookahead == 'r') ADVANCE(33);
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 8:
      if (lookahead == 'f') ADVANCE(36);
      if (lookahead == 'm') ADVANCE(37);
      if (lookahead == 'n') ADVANCE(38);
      END_STATE();
    case 9:
      if (lookahead == 'e') ADVANCE(39);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(41);
      if (lookahead == 'u') ADVANCE(42);
      END_STATE();
    case 12:
      if (lookahead == 'f') ADVANCE(43);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 't') ADVANCE(46);
      if (lookahead == 'u') ADVANCE(47);
      if (lookahead == 'w') ADVANCE(48);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'h') ADVANCE(50);
      if (lookahead == 'r') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(52);
      END_STATE();
    case 16:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 'y') ADVANCE(59);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(60);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(62);
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(64);
      END_STATE();
    case 25:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 26:
      if (lookahead == 'b') ADVANCE(66);
      if (lookahead == 'f') ADVANCE(67);
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 28:
      if (lookahead == 's') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(70);
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(72);
      END_STATE();
    case 31:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 32:
      if (lookahead == 'r') ADVANCE(74);
      END_STATE();
    case 33:
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(76);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 37:
      if (lookahead == 'p') ADVANCE(78);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 41:
      if (lookahead == 'w') ADVANCE(82);
      END_STATE();
    case 42:
      if (lookahead == 'l') ADVANCE(83);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 47:
      if (lookahead == 'p') ADVANCE(87);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 49:
      if (lookahead == 'r') ADVANCE(89);
      END_STATE();
    case 50:
      if (lookahead == 'i') ADVANCE(90);
      if (lookahead == 'r') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == 'u') ADVANCE(92);
      if (lookahead == 'y') ADVANCE(93);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(94);
      END_STATE();
    case 53:
      if (lookahead == 'd') ADVANCE(95);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(99);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 60:
      if (lookahead == 'i') ADVANCE(102);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 63:
      if (lookahead == 'c') ADVANCE(105);
      END_STATE();
    case 64:
      if (lookahead == 's') ADVANCE(106);
      END_STATE();
    case 65:
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 66:
      if (lookahead == 'u') ADVANCE(109);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(110);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(111);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(112);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(113);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 75:
      if (lookahead == 'm') ADVANCE(117);
      END_STATE();
    case 76:
      if (lookahead == 'c') ADVANCE(118);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(119);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 81:
      if (lookahead == 'a') ADVANCE(121);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 83:
      if (lookahead == 'l') ADVANCE(122);
      END_STATE();
    case 84:
      if (lookahead == 'u') ADVANCE(123);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 86:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 87:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(126);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(127);
      END_STATE();
    case 90:
      if (lookahead == 's') ADVANCE(128);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(129);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 97:
      if (lookahead == 'd') ADVANCE(133);
      END_STATE();
    case 98:
      if (lookahead == 'l') ADVANCE(134);
      END_STATE();
    case 99:
      if (lookahead == 'h') ADVANCE(135);
      END_STATE();
    case 100:
      if (lookahead == 'l') ADVANCE(136);
      END_STATE();
    case 101:
      if (lookahead == 'c') ADVANCE(137);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 103:
      if (lookahead == 'k') ADVANCE(139);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 105:
      if (lookahead == 'h') ADVANCE(140);
      END_STATE();
    case 106:
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 108:
      if (lookahead == 'i') ADVANCE(143);
      END_STATE();
    case 109:
      if (lookahead == 'g') ADVANCE(144);
      END_STATE();
    case 110:
      if (lookahead == 'u') ADVANCE(145);
      END_STATE();
    case 111:
      if (lookahead == 't') ADVANCE(146);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(147);
      END_STATE();
    case 114:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(149);
      END_STATE();
    case 116:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(151);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(153);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_meta);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(155);
      END_STATE();
    case 125:
      if (lookahead == 'r') ADVANCE(156);
      END_STATE();
    case 126:
      if (lookahead == 'c') ADVANCE(157);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(158);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_this);
      END_STATE();
    case 129:
      if (lookahead == 'w') ADVANCE(159);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 131:
      if (lookahead == 'o') ADVANCE(160);
      END_STATE();
    case 132:
      if (lookahead == 'f') ADVANCE(161);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_void);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_with);
      END_STATE();
    case 136:
      if (lookahead == 'd') ADVANCE(163);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_async);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(164);
      END_STATE();
    case 144:
      if (lookahead == 'g') ADVANCE(165);
      END_STATE();
    case 145:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 147:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 148:
      if (lookahead == 'd') ADVANCE(169);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 150:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(171);
      END_STATE();
    case 152:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(173);
      END_STATE();
    case 154:
      if (lookahead == 'n') ADVANCE(174);
      END_STATE();
    case 155:
      if (lookahead == 'c') ADVANCE(175);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_super);
      END_STATE();
    case 157:
      if (lookahead == 'h') ADVANCE(176);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 160:
      if (lookahead == 'f') ADVANCE(178);
      END_STATE();
    case 161:
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_yield);
      END_STATE();
    case 164:
      if (lookahead == 'u') ADVANCE(180);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(181);
      END_STATE();
    case 166:
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 169:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 170:
      if (lookahead == 'y') ADVANCE(184);
      END_STATE();
    case 171:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 173:
      if (lookahead == 'c') ADVANCE(186);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_static);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_target);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_typeof);
      END_STATE();
    case 179:
      if (lookahead == 'n') ADVANCE(187);
      END_STATE();
    case 180:
      if (lookahead == 'e') ADVANCE(188);
      END_STATE();
    case 181:
      if (lookahead == 'r') ADVANCE(189);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_finally);
      END_STATE();
    case 185:
      if (lookahead == 'n') ADVANCE(190);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(191);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_debugger);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 191:
      if (lookahead == 'o') ADVANCE(193);
      END_STATE();
    case 192:
      if (lookahead == 'd') ADVANCE(194);
      END_STATE();
    case 193:
      if (lookahead == 'f') ADVANCE(195);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_undefined);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_instanceof);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 144, .external_lex_state = 2},
  [2] = {.lex_state = 5, .external_lex_state = 2},
  [3] = {.lex_state = 5, .external_lex_state = 2},
  [4] = {.lex_state = 5, .external_lex_state = 2},
  [5] = {.lex_state = 5, .external_lex_state = 2},
  [6] = {.lex_state = 5, .external_lex_state = 2},
  [7] = {.lex_state = 144, .external_lex_state = 2},
  [8] = {.lex_state = 144, .external_lex_state = 2},
  [9] = {.lex_state = 144, .external_lex_state = 2},
  [10] = {.lex_state = 144, .external_lex_state = 2},
  [11] = {.lex_state = 144, .external_lex_state = 2},
  [12] = {.lex_state = 144, .external_lex_state = 2},
  [13] = {.lex_state = 144, .external_lex_state = 2},
  [14] = {.lex_state = 144, .external_lex_state = 2},
  [15] = {.lex_state = 144, .external_lex_state = 2},
  [16] = {.lex_state = 144, .external_lex_state = 2},
  [17] = {.lex_state = 144, .external_lex_state = 2},
  [18] = {.lex_state = 144, .external_lex_state = 2},
  [19] = {.lex_state = 144, .external_lex_state = 2},
  [20] = {.lex_state = 144, .external_lex_state = 2},
  [21] = {.lex_state = 144, .external_lex_state = 2},
  [22] = {.lex_state = 144, .external_lex_state = 2},
  [23] = {.lex_state = 144, .external_lex_state = 2},
  [24] = {.lex_state = 144, .external_lex_state = 2},
  [25] = {.lex_state = 144, .external_lex_state = 2},
  [26] = {.lex_state = 144, .external_lex_state = 2},
  [27] = {.lex_state = 144, .external_lex_state = 2},
  [28] = {.lex_state = 144, .external_lex_state = 2},
  [29] = {.lex_state = 144, .external_lex_state = 2},
  [30] = {.lex_state = 144, .external_lex_state = 2},
  [31] = {.lex_state = 144, .external_lex_state = 2},
  [32] = {.lex_state = 144, .external_lex_state = 2},
  [33] = {.lex_state = 144, .external_lex_state = 2},
  [34] = {.lex_state = 144, .external_lex_state = 2},
  [35] = {.lex_state = 144, .external_lex_state = 2},
  [36] = {.lex_state = 144, .external_lex_state = 2},
  [37] = {.lex_state = 144, .external_lex_state = 2},
  [38] = {.lex_state = 144, .external_lex_state = 2},
  [39] = {.lex_state = 144, .external_lex_state = 2},
  [40] = {.lex_state = 144, .external_lex_state = 2},
  [41] = {.lex_state = 144, .external_lex_state = 2},
  [42] = {.lex_state = 144, .external_lex_state = 2},
  [43] = {.lex_state = 144, .external_lex_state = 2},
  [44] = {.lex_state = 144, .external_lex_state = 2},
  [45] = {.lex_state = 144, .external_lex_state = 2},
  [46] = {.lex_state = 144, .external_lex_state = 2},
  [47] = {.lex_state = 144, .external_lex_state = 2},
  [48] = {.lex_state = 144, .external_lex_state = 2},
  [49] = {.lex_state = 144, .external_lex_state = 2},
  [50] = {.lex_state = 144, .external_lex_state = 2},
  [51] = {.lex_state = 144, .external_lex_state = 2},
  [52] = {.lex_state = 144, .external_lex_state = 2},
  [53] = {.lex_state = 144, .external_lex_state = 2},
  [54] = {.lex_state = 144, .external_lex_state = 2},
  [55] = {.lex_state = 144, .external_lex_state = 2},
  [56] = {.lex_state = 144, .external_lex_state = 2},
  [57] = {.lex_state = 144, .external_lex_state = 2},
  [58] = {.lex_state = 143, .external_lex_state = 3},
  [59] = {.lex_state = 143, .external_lex_state = 4},
  [60] = {.lex_state = 143, .external_lex_state = 4},
  [61] = {.lex_state = 143, .external_lex_state = 3},
  [62] = {.lex_state = 143, .external_lex_state = 3},
  [63] = {.lex_state = 143, .external_lex_state = 4},
  [64] = {.lex_state = 144, .external_lex_state = 2},
  [65] = {.lex_state = 143, .external_lex_state = 4},
  [66] = {.lex_state = 143, .external_lex_state = 4},
  [67] = {.lex_state = 143, .external_lex_state = 4},
  [68] = {.lex_state = 143, .external_lex_state = 4},
  [69] = {.lex_state = 143, .external_lex_state = 4},
  [70] = {.lex_state = 143, .external_lex_state = 4},
  [71] = {.lex_state = 143, .external_lex_state = 4},
  [72] = {.lex_state = 143, .external_lex_state = 4},
  [73] = {.lex_state = 143, .external_lex_state = 4},
  [74] = {.lex_state = 144, .external_lex_state = 2},
  [75] = {.lex_state = 144, .external_lex_state = 2},
  [76] = {.lex_state = 143, .external_lex_state = 4},
  [77] = {.lex_state = 144, .external_lex_state = 2},
  [78] = {.lex_state = 144, .external_lex_state = 2},
  [79] = {.lex_state = 143, .external_lex_state = 4},
  [80] = {.lex_state = 144, .external_lex_state = 2},
  [81] = {.lex_state = 143, .external_lex_state = 4},
  [82] = {.lex_state = 143, .external_lex_state = 4},
  [83] = {.lex_state = 144, .external_lex_state = 2},
  [84] = {.lex_state = 143, .external_lex_state = 4},
  [85] = {.lex_state = 144, .external_lex_state = 2},
  [86] = {.lex_state = 144, .external_lex_state = 2},
  [87] = {.lex_state = 144, .external_lex_state = 2},
  [88] = {.lex_state = 144, .external_lex_state = 2},
  [89] = {.lex_state = 144, .external_lex_state = 2},
  [90] = {.lex_state = 144, .external_lex_state = 2},
  [91] = {.lex_state = 144, .external_lex_state = 2},
  [92] = {.lex_state = 144, .external_lex_state = 2},
  [93] = {.lex_state = 144, .external_lex_state = 2},
  [94] = {.lex_state = 144, .external_lex_state = 2},
  [95] = {.lex_state = 144, .external_lex_state = 2},
  [96] = {.lex_state = 144, .external_lex_state = 2},
  [97] = {.lex_state = 144, .external_lex_state = 2},
  [98] = {.lex_state = 144, .external_lex_state = 2},
  [99] = {.lex_state = 144, .external_lex_state = 2},
  [100] = {.lex_state = 144, .external_lex_state = 2},
  [101] = {.lex_state = 144, .external_lex_state = 2},
  [102] = {.lex_state = 144, .external_lex_state = 2},
  [103] = {.lex_state = 144, .external_lex_state = 2},
  [104] = {.lex_state = 144, .external_lex_state = 2},
  [105] = {.lex_state = 144, .external_lex_state = 2},
  [106] = {.lex_state = 144, .external_lex_state = 2},
  [107] = {.lex_state = 144, .external_lex_state = 2},
  [108] = {.lex_state = 144, .external_lex_state = 2},
  [109] = {.lex_state = 144, .external_lex_state = 2},
  [110] = {.lex_state = 144, .external_lex_state = 2},
  [111] = {.lex_state = 144, .external_lex_state = 5},
  [112] = {.lex_state = 144, .external_lex_state = 2},
  [113] = {.lex_state = 144, .external_lex_state = 2},
  [114] = {.lex_state = 144, .external_lex_state = 2},
  [115] = {.lex_state = 144, .external_lex_state = 2},
  [116] = {.lex_state = 144, .external_lex_state = 2},
  [117] = {.lex_state = 144, .external_lex_state = 2},
  [118] = {.lex_state = 144, .external_lex_state = 2},
  [119] = {.lex_state = 144, .external_lex_state = 2},
  [120] = {.lex_state = 144, .external_lex_state = 2},
  [121] = {.lex_state = 144, .external_lex_state = 2},
  [122] = {.lex_state = 144, .external_lex_state = 2},
  [123] = {.lex_state = 144, .external_lex_state = 2},
  [124] = {.lex_state = 144, .external_lex_state = 2},
  [125] = {.lex_state = 144, .external_lex_state = 2},
  [126] = {.lex_state = 144, .external_lex_state = 2},
  [127] = {.lex_state = 144, .external_lex_state = 2},
  [128] = {.lex_state = 6, .external_lex_state = 2},
  [129] = {.lex_state = 144, .external_lex_state = 2},
  [130] = {.lex_state = 144, .external_lex_state = 2},
  [131] = {.lex_state = 144, .external_lex_state = 2},
  [132] = {.lex_state = 144, .external_lex_state = 2},
  [133] = {.lex_state = 144, .external_lex_state = 2},
  [134] = {.lex_state = 144, .external_lex_state = 2},
  [135] = {.lex_state = 144, .external_lex_state = 2},
  [136] = {.lex_state = 6, .external_lex_state = 2},
  [137] = {.lex_state = 144, .external_lex_state = 2},
  [138] = {.lex_state = 144, .external_lex_state = 2},
  [139] = {.lex_state = 144, .external_lex_state = 2},
  [140] = {.lex_state = 144, .external_lex_state = 2},
  [141] = {.lex_state = 144, .external_lex_state = 2},
  [142] = {.lex_state = 144, .external_lex_state = 2},
  [143] = {.lex_state = 144, .external_lex_state = 2},
  [144] = {.lex_state = 144, .external_lex_state = 2},
  [145] = {.lex_state = 144, .external_lex_state = 2},
  [146] = {.lex_state = 144, .external_lex_state = 2},
  [147] = {.lex_state = 144, .external_lex_state = 2},
  [148] = {.lex_state = 144, .external_lex_state = 2},
  [149] = {.lex_state = 144, .external_lex_state = 2},
  [150] = {.lex_state = 144, .external_lex_state = 2},
  [151] = {.lex_state = 144, .external_lex_state = 2},
  [152] = {.lex_state = 144, .external_lex_state = 2},
  [153] = {.lex_state = 144, .external_lex_state = 2},
  [154] = {.lex_state = 6, .external_lex_state = 2},
  [155] = {.lex_state = 144, .external_lex_state = 2},
  [156] = {.lex_state = 144, .external_lex_state = 2},
  [157] = {.lex_state = 144, .external_lex_state = 2},
  [158] = {.lex_state = 144, .external_lex_state = 2},
  [159] = {.lex_state = 144, .external_lex_state = 2},
  [160] = {.lex_state = 6, .external_lex_state = 2},
  [161] = {.lex_state = 144, .external_lex_state = 2},
  [162] = {.lex_state = 144, .external_lex_state = 2},
  [163] = {.lex_state = 144, .external_lex_state = 2},
  [164] = {.lex_state = 144, .external_lex_state = 2},
  [165] = {.lex_state = 144, .external_lex_state = 2},
  [166] = {.lex_state = 144, .external_lex_state = 2},
  [167] = {.lex_state = 144, .external_lex_state = 2},
  [168] = {.lex_state = 144, .external_lex_state = 2},
  [169] = {.lex_state = 144, .external_lex_state = 2},
  [170] = {.lex_state = 144, .external_lex_state = 2},
  [171] = {.lex_state = 6, .external_lex_state = 2},
  [172] = {.lex_state = 144, .external_lex_state = 2},
  [173] = {.lex_state = 144, .external_lex_state = 2},
  [174] = {.lex_state = 144, .external_lex_state = 2},
  [175] = {.lex_state = 144, .external_lex_state = 2},
  [176] = {.lex_state = 144, .external_lex_state = 2},
  [177] = {.lex_state = 144, .external_lex_state = 2},
  [178] = {.lex_state = 144, .external_lex_state = 2},
  [179] = {.lex_state = 144, .external_lex_state = 2},
  [180] = {.lex_state = 144, .external_lex_state = 2},
  [181] = {.lex_state = 144, .external_lex_state = 2},
  [182] = {.lex_state = 144, .external_lex_state = 2},
  [183] = {.lex_state = 144, .external_lex_state = 2},
  [184] = {.lex_state = 144, .external_lex_state = 2},
  [185] = {.lex_state = 144, .external_lex_state = 2},
  [186] = {.lex_state = 144, .external_lex_state = 2},
  [187] = {.lex_state = 144, .external_lex_state = 2},
  [188] = {.lex_state = 144, .external_lex_state = 2},
  [189] = {.lex_state = 144, .external_lex_state = 2},
  [190] = {.lex_state = 144, .external_lex_state = 2},
  [191] = {.lex_state = 144, .external_lex_state = 2},
  [192] = {.lex_state = 144, .external_lex_state = 2},
  [193] = {.lex_state = 144, .external_lex_state = 2},
  [194] = {.lex_state = 144, .external_lex_state = 2},
  [195] = {.lex_state = 144, .external_lex_state = 2},
  [196] = {.lex_state = 144, .external_lex_state = 2},
  [197] = {.lex_state = 144, .external_lex_state = 2},
  [198] = {.lex_state = 144, .external_lex_state = 2},
  [199] = {.lex_state = 144, .external_lex_state = 2},
  [200] = {.lex_state = 144, .external_lex_state = 2},
  [201] = {.lex_state = 144, .external_lex_state = 2},
  [202] = {.lex_state = 144, .external_lex_state = 2},
  [203] = {.lex_state = 144, .external_lex_state = 2},
  [204] = {.lex_state = 144, .external_lex_state = 2},
  [205] = {.lex_state = 144, .external_lex_state = 2},
  [206] = {.lex_state = 144, .external_lex_state = 2},
  [207] = {.lex_state = 144, .external_lex_state = 2},
  [208] = {.lex_state = 144, .external_lex_state = 2},
  [209] = {.lex_state = 144, .external_lex_state = 2},
  [210] = {.lex_state = 144, .external_lex_state = 2},
  [211] = {.lex_state = 144, .external_lex_state = 2},
  [212] = {.lex_state = 144, .external_lex_state = 2},
  [213] = {.lex_state = 144, .external_lex_state = 2},
  [214] = {.lex_state = 144, .external_lex_state = 2},
  [215] = {.lex_state = 144, .external_lex_state = 2},
  [216] = {.lex_state = 144, .external_lex_state = 2},
  [217] = {.lex_state = 144, .external_lex_state = 2},
  [218] = {.lex_state = 144, .external_lex_state = 2},
  [219] = {.lex_state = 144, .external_lex_state = 2},
  [220] = {.lex_state = 144, .external_lex_state = 2},
  [221] = {.lex_state = 144, .external_lex_state = 2},
  [222] = {.lex_state = 144, .external_lex_state = 2},
  [223] = {.lex_state = 144, .external_lex_state = 2},
  [224] = {.lex_state = 144, .external_lex_state = 2},
  [225] = {.lex_state = 144, .external_lex_state = 2},
  [226] = {.lex_state = 144, .external_lex_state = 2},
  [227] = {.lex_state = 144, .external_lex_state = 2},
  [228] = {.lex_state = 144, .external_lex_state = 2},
  [229] = {.lex_state = 144, .external_lex_state = 2},
  [230] = {.lex_state = 144, .external_lex_state = 2},
  [231] = {.lex_state = 144, .external_lex_state = 2},
  [232] = {.lex_state = 144, .external_lex_state = 2},
  [233] = {.lex_state = 144, .external_lex_state = 2},
  [234] = {.lex_state = 144, .external_lex_state = 2},
  [235] = {.lex_state = 144, .external_lex_state = 2},
  [236] = {.lex_state = 144, .external_lex_state = 2},
  [237] = {.lex_state = 144, .external_lex_state = 2},
  [238] = {.lex_state = 144, .external_lex_state = 2},
  [239] = {.lex_state = 144, .external_lex_state = 2},
  [240] = {.lex_state = 144, .external_lex_state = 2},
  [241] = {.lex_state = 144, .external_lex_state = 2},
  [242] = {.lex_state = 144, .external_lex_state = 2},
  [243] = {.lex_state = 144, .external_lex_state = 2},
  [244] = {.lex_state = 144, .external_lex_state = 2},
  [245] = {.lex_state = 144, .external_lex_state = 2},
  [246] = {.lex_state = 144, .external_lex_state = 2},
  [247] = {.lex_state = 144, .external_lex_state = 2},
  [248] = {.lex_state = 144, .external_lex_state = 2},
  [249] = {.lex_state = 144, .external_lex_state = 2},
  [250] = {.lex_state = 144, .external_lex_state = 2},
  [251] = {.lex_state = 144, .external_lex_state = 2},
  [252] = {.lex_state = 144, .external_lex_state = 2},
  [253] = {.lex_state = 144, .external_lex_state = 2},
  [254] = {.lex_state = 144, .external_lex_state = 2},
  [255] = {.lex_state = 144, .external_lex_state = 2},
  [256] = {.lex_state = 144, .external_lex_state = 2},
  [257] = {.lex_state = 144, .external_lex_state = 2},
  [258] = {.lex_state = 144, .external_lex_state = 2},
  [259] = {.lex_state = 144, .external_lex_state = 2},
  [260] = {.lex_state = 144, .external_lex_state = 2},
  [261] = {.lex_state = 144, .external_lex_state = 2},
  [262] = {.lex_state = 144, .external_lex_state = 2},
  [263] = {.lex_state = 144, .external_lex_state = 2},
  [264] = {.lex_state = 144, .external_lex_state = 2},
  [265] = {.lex_state = 144, .external_lex_state = 2},
  [266] = {.lex_state = 144, .external_lex_state = 2},
  [267] = {.lex_state = 144, .external_lex_state = 2},
  [268] = {.lex_state = 144, .external_lex_state = 2},
  [269] = {.lex_state = 144, .external_lex_state = 2},
  [270] = {.lex_state = 144, .external_lex_state = 2},
  [271] = {.lex_state = 144, .external_lex_state = 2},
  [272] = {.lex_state = 144, .external_lex_state = 2},
  [273] = {.lex_state = 144, .external_lex_state = 2},
  [274] = {.lex_state = 144, .external_lex_state = 2},
  [275] = {.lex_state = 144, .external_lex_state = 2},
  [276] = {.lex_state = 144, .external_lex_state = 2},
  [277] = {.lex_state = 144, .external_lex_state = 2},
  [278] = {.lex_state = 144, .external_lex_state = 2},
  [279] = {.lex_state = 144, .external_lex_state = 2},
  [280] = {.lex_state = 144, .external_lex_state = 2},
  [281] = {.lex_state = 144, .external_lex_state = 2},
  [282] = {.lex_state = 144, .external_lex_state = 2},
  [283] = {.lex_state = 144, .external_lex_state = 2},
  [284] = {.lex_state = 144, .external_lex_state = 2},
  [285] = {.lex_state = 144, .external_lex_state = 2},
  [286] = {.lex_state = 144, .external_lex_state = 2},
  [287] = {.lex_state = 144, .external_lex_state = 2},
  [288] = {.lex_state = 144, .external_lex_state = 2},
  [289] = {.lex_state = 144, .external_lex_state = 2},
  [290] = {.lex_state = 144, .external_lex_state = 2},
  [291] = {.lex_state = 144, .external_lex_state = 2},
  [292] = {.lex_state = 144, .external_lex_state = 2},
  [293] = {.lex_state = 144, .external_lex_state = 2},
  [294] = {.lex_state = 144, .external_lex_state = 2},
  [295] = {.lex_state = 144, .external_lex_state = 2},
  [296] = {.lex_state = 144, .external_lex_state = 2},
  [297] = {.lex_state = 7, .external_lex_state = 4},
  [298] = {.lex_state = 7, .external_lex_state = 4},
  [299] = {.lex_state = 7, .external_lex_state = 4},
  [300] = {.lex_state = 7, .external_lex_state = 4},
  [301] = {.lex_state = 7, .external_lex_state = 4},
  [302] = {.lex_state = 7, .external_lex_state = 4},
  [303] = {.lex_state = 7, .external_lex_state = 4},
  [304] = {.lex_state = 7, .external_lex_state = 4},
  [305] = {.lex_state = 7, .external_lex_state = 4},
  [306] = {.lex_state = 7, .external_lex_state = 4},
  [307] = {.lex_state = 7, .external_lex_state = 4},
  [308] = {.lex_state = 7, .external_lex_state = 4},
  [309] = {.lex_state = 7, .external_lex_state = 4},
  [310] = {.lex_state = 7, .external_lex_state = 4},
  [311] = {.lex_state = 7, .external_lex_state = 3},
  [312] = {.lex_state = 7, .external_lex_state = 3},
  [313] = {.lex_state = 144, .external_lex_state = 2},
  [314] = {.lex_state = 144, .external_lex_state = 5},
  [315] = {.lex_state = 144, .external_lex_state = 5},
  [316] = {.lex_state = 7, .external_lex_state = 4},
  [317] = {.lex_state = 7, .external_lex_state = 4},
  [318] = {.lex_state = 7, .external_lex_state = 4},
  [319] = {.lex_state = 7, .external_lex_state = 3},
  [320] = {.lex_state = 7, .external_lex_state = 4},
  [321] = {.lex_state = 144, .external_lex_state = 2},
  [322] = {.lex_state = 144, .external_lex_state = 2},
  [323] = {.lex_state = 7, .external_lex_state = 4},
  [324] = {.lex_state = 7, .external_lex_state = 4},
  [325] = {.lex_state = 7, .external_lex_state = 4},
  [326] = {.lex_state = 7, .external_lex_state = 3},
  [327] = {.lex_state = 7, .external_lex_state = 3},
  [328] = {.lex_state = 7, .external_lex_state = 4},
  [329] = {.lex_state = 7, .external_lex_state = 4},
  [330] = {.lex_state = 7, .external_lex_state = 3},
  [331] = {.lex_state = 144, .external_lex_state = 2},
  [332] = {.lex_state = 7, .external_lex_state = 3},
  [333] = {.lex_state = 144, .external_lex_state = 5},
  [334] = {.lex_state = 144, .external_lex_state = 5},
  [335] = {.lex_state = 144, .external_lex_state = 5},
  [336] = {.lex_state = 144, .external_lex_state = 5},
  [337] = {.lex_state = 144, .external_lex_state = 2},
  [338] = {.lex_state = 144, .external_lex_state = 5},
  [339] = {.lex_state = 144, .external_lex_state = 5},
  [340] = {.lex_state = 144, .external_lex_state = 5},
  [341] = {.lex_state = 144, .external_lex_state = 5},
  [342] = {.lex_state = 144, .external_lex_state = 5},
  [343] = {.lex_state = 144, .external_lex_state = 5},
  [344] = {.lex_state = 7, .external_lex_state = 3},
  [345] = {.lex_state = 144, .external_lex_state = 5},
  [346] = {.lex_state = 144, .external_lex_state = 2},
  [347] = {.lex_state = 144, .external_lex_state = 5},
  [348] = {.lex_state = 144, .external_lex_state = 2},
  [349] = {.lex_state = 144, .external_lex_state = 5},
  [350] = {.lex_state = 144, .external_lex_state = 5},
  [351] = {.lex_state = 144, .external_lex_state = 2},
  [352] = {.lex_state = 7, .external_lex_state = 3},
  [353] = {.lex_state = 144, .external_lex_state = 5},
  [354] = {.lex_state = 144, .external_lex_state = 5},
  [355] = {.lex_state = 7, .external_lex_state = 4},
  [356] = {.lex_state = 7, .external_lex_state = 4},
  [357] = {.lex_state = 144, .external_lex_state = 2},
  [358] = {.lex_state = 7, .external_lex_state = 3},
  [359] = {.lex_state = 144, .external_lex_state = 2},
  [360] = {.lex_state = 144, .external_lex_state = 2},
  [361] = {.lex_state = 144, .external_lex_state = 2},
  [362] = {.lex_state = 144, .external_lex_state = 2},
  [363] = {.lex_state = 144, .external_lex_state = 2},
  [364] = {.lex_state = 144, .external_lex_state = 2},
  [365] = {.lex_state = 144, .external_lex_state = 2},
  [366] = {.lex_state = 144, .external_lex_state = 2},
  [367] = {.lex_state = 144, .external_lex_state = 2},
  [368] = {.lex_state = 144, .external_lex_state = 2},
  [369] = {.lex_state = 144, .external_lex_state = 2},
  [370] = {.lex_state = 144, .external_lex_state = 2},
  [371] = {.lex_state = 144, .external_lex_state = 2},
  [372] = {.lex_state = 144, .external_lex_state = 2},
  [373] = {.lex_state = 144, .external_lex_state = 2},
  [374] = {.lex_state = 144, .external_lex_state = 2},
  [375] = {.lex_state = 144, .external_lex_state = 2},
  [376] = {.lex_state = 144, .external_lex_state = 2},
  [377] = {.lex_state = 144, .external_lex_state = 2},
  [378] = {.lex_state = 144, .external_lex_state = 2},
  [379] = {.lex_state = 144, .external_lex_state = 2},
  [380] = {.lex_state = 144, .external_lex_state = 2},
  [381] = {.lex_state = 144, .external_lex_state = 2},
  [382] = {.lex_state = 144, .external_lex_state = 2},
  [383] = {.lex_state = 144, .external_lex_state = 2},
  [384] = {.lex_state = 144, .external_lex_state = 2},
  [385] = {.lex_state = 144, .external_lex_state = 2},
  [386] = {.lex_state = 144, .external_lex_state = 2},
  [387] = {.lex_state = 144, .external_lex_state = 2},
  [388] = {.lex_state = 144, .external_lex_state = 2},
  [389] = {.lex_state = 144, .external_lex_state = 2},
  [390] = {.lex_state = 144, .external_lex_state = 2},
  [391] = {.lex_state = 144, .external_lex_state = 2},
  [392] = {.lex_state = 144, .external_lex_state = 2},
  [393] = {.lex_state = 144, .external_lex_state = 2},
  [394] = {.lex_state = 144, .external_lex_state = 2},
  [395] = {.lex_state = 144, .external_lex_state = 2},
  [396] = {.lex_state = 144, .external_lex_state = 2},
  [397] = {.lex_state = 144, .external_lex_state = 2},
  [398] = {.lex_state = 144, .external_lex_state = 2},
  [399] = {.lex_state = 144, .external_lex_state = 2},
  [400] = {.lex_state = 144, .external_lex_state = 2},
  [401] = {.lex_state = 7, .external_lex_state = 4},
  [402] = {.lex_state = 144, .external_lex_state = 2},
  [403] = {.lex_state = 144, .external_lex_state = 2},
  [404] = {.lex_state = 144, .external_lex_state = 2},
  [405] = {.lex_state = 144, .external_lex_state = 2},
  [406] = {.lex_state = 144, .external_lex_state = 2},
  [407] = {.lex_state = 144, .external_lex_state = 2},
  [408] = {.lex_state = 144, .external_lex_state = 2},
  [409] = {.lex_state = 144, .external_lex_state = 2},
  [410] = {.lex_state = 144, .external_lex_state = 2},
  [411] = {.lex_state = 144, .external_lex_state = 2},
  [412] = {.lex_state = 7, .external_lex_state = 3},
  [413] = {.lex_state = 144, .external_lex_state = 2},
  [414] = {.lex_state = 144, .external_lex_state = 2},
  [415] = {.lex_state = 144, .external_lex_state = 2},
  [416] = {.lex_state = 144, .external_lex_state = 2},
  [417] = {.lex_state = 144, .external_lex_state = 2},
  [418] = {.lex_state = 144, .external_lex_state = 2},
  [419] = {.lex_state = 144, .external_lex_state = 2},
  [420] = {.lex_state = 7, .external_lex_state = 4},
  [421] = {.lex_state = 144, .external_lex_state = 2},
  [422] = {.lex_state = 144, .external_lex_state = 2},
  [423] = {.lex_state = 144, .external_lex_state = 2},
  [424] = {.lex_state = 144, .external_lex_state = 2},
  [425] = {.lex_state = 7, .external_lex_state = 3},
  [426] = {.lex_state = 144, .external_lex_state = 2},
  [427] = {.lex_state = 7, .external_lex_state = 3},
  [428] = {.lex_state = 7, .external_lex_state = 4},
  [429] = {.lex_state = 7, .external_lex_state = 3},
  [430] = {.lex_state = 7, .external_lex_state = 3},
  [431] = {.lex_state = 7, .external_lex_state = 3},
  [432] = {.lex_state = 7, .external_lex_state = 4},
  [433] = {.lex_state = 7, .external_lex_state = 4},
  [434] = {.lex_state = 7, .external_lex_state = 4},
  [435] = {.lex_state = 7, .external_lex_state = 3},
  [436] = {.lex_state = 7, .external_lex_state = 3},
  [437] = {.lex_state = 7, .external_lex_state = 3},
  [438] = {.lex_state = 7, .external_lex_state = 3},
  [439] = {.lex_state = 7, .external_lex_state = 3},
  [440] = {.lex_state = 7, .external_lex_state = 3},
  [441] = {.lex_state = 7, .external_lex_state = 3},
  [442] = {.lex_state = 7, .external_lex_state = 3},
  [443] = {.lex_state = 7, .external_lex_state = 3},
  [444] = {.lex_state = 7, .external_lex_state = 3},
  [445] = {.lex_state = 7, .external_lex_state = 3},
  [446] = {.lex_state = 144, .external_lex_state = 2},
  [447] = {.lex_state = 144, .external_lex_state = 2},
  [448] = {.lex_state = 144, .external_lex_state = 2},
  [449] = {.lex_state = 144, .external_lex_state = 2},
  [450] = {.lex_state = 144, .external_lex_state = 2},
  [451] = {.lex_state = 144, .external_lex_state = 2},
  [452] = {.lex_state = 144, .external_lex_state = 2},
  [453] = {.lex_state = 144, .external_lex_state = 2},
  [454] = {.lex_state = 144, .external_lex_state = 2},
  [455] = {.lex_state = 7, .external_lex_state = 4},
  [456] = {.lex_state = 7, .external_lex_state = 4},
  [457] = {.lex_state = 7, .external_lex_state = 4},
  [458] = {.lex_state = 7, .external_lex_state = 3},
  [459] = {.lex_state = 7, .external_lex_state = 4},
  [460] = {.lex_state = 7, .external_lex_state = 3},
  [461] = {.lex_state = 7, .external_lex_state = 4},
  [462] = {.lex_state = 7, .external_lex_state = 4},
  [463] = {.lex_state = 7, .external_lex_state = 4},
  [464] = {.lex_state = 7, .external_lex_state = 3},
  [465] = {.lex_state = 7, .external_lex_state = 4},
  [466] = {.lex_state = 7, .external_lex_state = 4},
  [467] = {.lex_state = 7, .external_lex_state = 4},
  [468] = {.lex_state = 7, .external_lex_state = 4},
  [469] = {.lex_state = 7, .external_lex_state = 3},
  [470] = {.lex_state = 7, .external_lex_state = 4},
  [471] = {.lex_state = 7, .external_lex_state = 4},
  [472] = {.lex_state = 7, .external_lex_state = 3},
  [473] = {.lex_state = 7, .external_lex_state = 4},
  [474] = {.lex_state = 7, .external_lex_state = 3},
  [475] = {.lex_state = 7, .external_lex_state = 4},
  [476] = {.lex_state = 7, .external_lex_state = 4},
  [477] = {.lex_state = 7, .external_lex_state = 4},
  [478] = {.lex_state = 7, .external_lex_state = 4},
  [479] = {.lex_state = 7, .external_lex_state = 4},
  [480] = {.lex_state = 7, .external_lex_state = 4},
  [481] = {.lex_state = 7, .external_lex_state = 3},
  [482] = {.lex_state = 7, .external_lex_state = 3},
  [483] = {.lex_state = 7, .external_lex_state = 3},
  [484] = {.lex_state = 7, .external_lex_state = 4},
  [485] = {.lex_state = 7, .external_lex_state = 3},
  [486] = {.lex_state = 7, .external_lex_state = 4},
  [487] = {.lex_state = 7, .external_lex_state = 3},
  [488] = {.lex_state = 7, .external_lex_state = 3},
  [489] = {.lex_state = 7, .external_lex_state = 3},
  [490] = {.lex_state = 7, .external_lex_state = 3},
  [491] = {.lex_state = 7, .external_lex_state = 3},
  [492] = {.lex_state = 7, .external_lex_state = 3},
  [493] = {.lex_state = 7, .external_lex_state = 3},
  [494] = {.lex_state = 7, .external_lex_state = 3},
  [495] = {.lex_state = 7, .external_lex_state = 3},
  [496] = {.lex_state = 7, .external_lex_state = 3},
  [497] = {.lex_state = 7, .external_lex_state = 3},
  [498] = {.lex_state = 7, .external_lex_state = 3},
  [499] = {.lex_state = 7, .external_lex_state = 3},
  [500] = {.lex_state = 7, .external_lex_state = 3},
  [501] = {.lex_state = 7, .external_lex_state = 3},
  [502] = {.lex_state = 7, .external_lex_state = 3},
  [503] = {.lex_state = 7, .external_lex_state = 3},
  [504] = {.lex_state = 7, .external_lex_state = 3},
  [505] = {.lex_state = 8, .external_lex_state = 4},
  [506] = {.lex_state = 8, .external_lex_state = 3},
  [507] = {.lex_state = 8, .external_lex_state = 3},
  [508] = {.lex_state = 8, .external_lex_state = 3},
  [509] = {.lex_state = 8, .external_lex_state = 3},
  [510] = {.lex_state = 8, .external_lex_state = 4},
  [511] = {.lex_state = 8, .external_lex_state = 3},
  [512] = {.lex_state = 8, .external_lex_state = 3},
  [513] = {.lex_state = 8, .external_lex_state = 4},
  [514] = {.lex_state = 8, .external_lex_state = 3},
  [515] = {.lex_state = 8, .external_lex_state = 3},
  [516] = {.lex_state = 8, .external_lex_state = 3},
  [517] = {.lex_state = 8, .external_lex_state = 3},
  [518] = {.lex_state = 8, .external_lex_state = 3},
  [519] = {.lex_state = 8, .external_lex_state = 3},
  [520] = {.lex_state = 8, .external_lex_state = 3},
  [521] = {.lex_state = 8, .external_lex_state = 3},
  [522] = {.lex_state = 8, .external_lex_state = 3},
  [523] = {.lex_state = 8, .external_lex_state = 3},
  [524] = {.lex_state = 8, .external_lex_state = 3},
  [525] = {.lex_state = 8, .external_lex_state = 3},
  [526] = {.lex_state = 8, .external_lex_state = 3},
  [527] = {.lex_state = 8, .external_lex_state = 3},
  [528] = {.lex_state = 8, .external_lex_state = 3},
  [529] = {.lex_state = 8, .external_lex_state = 3},
  [530] = {.lex_state = 8, .external_lex_state = 3},
  [531] = {.lex_state = 8, .external_lex_state = 3},
  [532] = {.lex_state = 8, .external_lex_state = 3},
  [533] = {.lex_state = 8, .external_lex_state = 3},
  [534] = {.lex_state = 8, .external_lex_state = 3},
  [535] = {.lex_state = 8, .external_lex_state = 3},
  [536] = {.lex_state = 8, .external_lex_state = 3},
  [537] = {.lex_state = 8, .external_lex_state = 3},
  [538] = {.lex_state = 8, .external_lex_state = 3},
  [539] = {.lex_state = 8, .external_lex_state = 3},
  [540] = {.lex_state = 8, .external_lex_state = 3},
  [541] = {.lex_state = 8, .external_lex_state = 3},
  [542] = {.lex_state = 8, .external_lex_state = 3},
  [543] = {.lex_state = 8, .external_lex_state = 3},
  [544] = {.lex_state = 8, .external_lex_state = 3},
  [545] = {.lex_state = 8, .external_lex_state = 3},
  [546] = {.lex_state = 8, .external_lex_state = 3},
  [547] = {.lex_state = 8, .external_lex_state = 3},
  [548] = {.lex_state = 8, .external_lex_state = 3},
  [549] = {.lex_state = 8, .external_lex_state = 3},
  [550] = {.lex_state = 8, .external_lex_state = 3},
  [551] = {.lex_state = 8, .external_lex_state = 3},
  [552] = {.lex_state = 8, .external_lex_state = 3},
  [553] = {.lex_state = 8, .external_lex_state = 3},
  [554] = {.lex_state = 9, .external_lex_state = 3},
  [555] = {.lex_state = 8, .external_lex_state = 3},
  [556] = {.lex_state = 8, .external_lex_state = 3},
  [557] = {.lex_state = 8, .external_lex_state = 3},
  [558] = {.lex_state = 8, .external_lex_state = 3},
  [559] = {.lex_state = 8, .external_lex_state = 3},
  [560] = {.lex_state = 8, .external_lex_state = 3},
  [561] = {.lex_state = 8, .external_lex_state = 3},
  [562] = {.lex_state = 8, .external_lex_state = 3},
  [563] = {.lex_state = 8, .external_lex_state = 3},
  [564] = {.lex_state = 8, .external_lex_state = 3},
  [565] = {.lex_state = 8, .external_lex_state = 3},
  [566] = {.lex_state = 8, .external_lex_state = 3},
  [567] = {.lex_state = 8, .external_lex_state = 3},
  [568] = {.lex_state = 8, .external_lex_state = 3},
  [569] = {.lex_state = 8, .external_lex_state = 3},
  [570] = {.lex_state = 8, .external_lex_state = 3},
  [571] = {.lex_state = 8, .external_lex_state = 3},
  [572] = {.lex_state = 8, .external_lex_state = 3},
  [573] = {.lex_state = 8, .external_lex_state = 3},
  [574] = {.lex_state = 8, .external_lex_state = 3},
  [575] = {.lex_state = 8, .external_lex_state = 3},
  [576] = {.lex_state = 8, .external_lex_state = 3},
  [577] = {.lex_state = 8, .external_lex_state = 3},
  [578] = {.lex_state = 8, .external_lex_state = 3},
  [579] = {.lex_state = 8, .external_lex_state = 3},
  [580] = {.lex_state = 8, .external_lex_state = 4},
  [581] = {.lex_state = 8, .external_lex_state = 3},
  [582] = {.lex_state = 8, .external_lex_state = 3},
  [583] = {.lex_state = 8, .external_lex_state = 4},
  [584] = {.lex_state = 8, .external_lex_state = 4},
  [585] = {.lex_state = 8, .external_lex_state = 4},
  [586] = {.lex_state = 8, .external_lex_state = 3},
  [587] = {.lex_state = 8, .external_lex_state = 3},
  [588] = {.lex_state = 8, .external_lex_state = 3},
  [589] = {.lex_state = 8, .external_lex_state = 3},
  [590] = {.lex_state = 8, .external_lex_state = 3},
  [591] = {.lex_state = 8, .external_lex_state = 3},
  [592] = {.lex_state = 8, .external_lex_state = 3},
  [593] = {.lex_state = 8, .external_lex_state = 3},
  [594] = {.lex_state = 8, .external_lex_state = 3},
  [595] = {.lex_state = 8, .external_lex_state = 3},
  [596] = {.lex_state = 8, .external_lex_state = 3},
  [597] = {.lex_state = 8, .external_lex_state = 3},
  [598] = {.lex_state = 8, .external_lex_state = 3},
  [599] = {.lex_state = 8, .external_lex_state = 3},
  [600] = {.lex_state = 8, .external_lex_state = 3},
  [601] = {.lex_state = 8, .external_lex_state = 3},
  [602] = {.lex_state = 8, .external_lex_state = 4},
  [603] = {.lex_state = 8, .external_lex_state = 4},
  [604] = {.lex_state = 8, .external_lex_state = 4},
  [605] = {.lex_state = 8, .external_lex_state = 3},
  [606] = {.lex_state = 8, .external_lex_state = 4},
  [607] = {.lex_state = 8, .external_lex_state = 3},
  [608] = {.lex_state = 8, .external_lex_state = 3},
  [609] = {.lex_state = 8, .external_lex_state = 3},
  [610] = {.lex_state = 8, .external_lex_state = 3},
  [611] = {.lex_state = 8, .external_lex_state = 3},
  [612] = {.lex_state = 8, .external_lex_state = 3},
  [613] = {.lex_state = 8, .external_lex_state = 3},
  [614] = {.lex_state = 8, .external_lex_state = 4},
  [615] = {.lex_state = 8, .external_lex_state = 4},
  [616] = {.lex_state = 8, .external_lex_state = 4},
  [617] = {.lex_state = 8, .external_lex_state = 4},
  [618] = {.lex_state = 8, .external_lex_state = 4},
  [619] = {.lex_state = 8, .external_lex_state = 4},
  [620] = {.lex_state = 8, .external_lex_state = 4},
  [621] = {.lex_state = 8, .external_lex_state = 3},
  [622] = {.lex_state = 8, .external_lex_state = 4},
  [623] = {.lex_state = 8, .external_lex_state = 4},
  [624] = {.lex_state = 8, .external_lex_state = 4},
  [625] = {.lex_state = 8, .external_lex_state = 4},
  [626] = {.lex_state = 8, .external_lex_state = 4},
  [627] = {.lex_state = 8, .external_lex_state = 4},
  [628] = {.lex_state = 8, .external_lex_state = 4},
  [629] = {.lex_state = 8, .external_lex_state = 4},
  [630] = {.lex_state = 8, .external_lex_state = 4},
  [631] = {.lex_state = 8, .external_lex_state = 4},
  [632] = {.lex_state = 8, .external_lex_state = 4},
  [633] = {.lex_state = 8, .external_lex_state = 4},
  [634] = {.lex_state = 8, .external_lex_state = 4},
  [635] = {.lex_state = 8, .external_lex_state = 3},
  [636] = {.lex_state = 8, .external_lex_state = 4},
  [637] = {.lex_state = 8, .external_lex_state = 4},
  [638] = {.lex_state = 8, .external_lex_state = 4},
  [639] = {.lex_state = 8, .external_lex_state = 4},
  [640] = {.lex_state = 8, .external_lex_state = 4},
  [641] = {.lex_state = 8, .external_lex_state = 4},
  [642] = {.lex_state = 8, .external_lex_state = 4},
  [643] = {.lex_state = 8, .external_lex_state = 4},
  [644] = {.lex_state = 8, .external_lex_state = 4},
  [645] = {.lex_state = 8, .external_lex_state = 4},
  [646] = {.lex_state = 8, .external_lex_state = 4},
  [647] = {.lex_state = 8, .external_lex_state = 4},
  [648] = {.lex_state = 8, .external_lex_state = 4},
  [649] = {.lex_state = 8, .external_lex_state = 4},
  [650] = {.lex_state = 8, .external_lex_state = 4},
  [651] = {.lex_state = 8, .external_lex_state = 4},
  [652] = {.lex_state = 8, .external_lex_state = 4},
  [653] = {.lex_state = 8, .external_lex_state = 4},
  [654] = {.lex_state = 8, .external_lex_state = 4},
  [655] = {.lex_state = 8, .external_lex_state = 4},
  [656] = {.lex_state = 8, .external_lex_state = 4},
  [657] = {.lex_state = 8, .external_lex_state = 4},
  [658] = {.lex_state = 8, .external_lex_state = 4},
  [659] = {.lex_state = 8, .external_lex_state = 4},
  [660] = {.lex_state = 8, .external_lex_state = 4},
  [661] = {.lex_state = 8, .external_lex_state = 4},
  [662] = {.lex_state = 8, .external_lex_state = 4},
  [663] = {.lex_state = 8, .external_lex_state = 4},
  [664] = {.lex_state = 8, .external_lex_state = 4},
  [665] = {.lex_state = 8, .external_lex_state = 4},
  [666] = {.lex_state = 8, .external_lex_state = 4},
  [667] = {.lex_state = 8, .external_lex_state = 4},
  [668] = {.lex_state = 8, .external_lex_state = 4},
  [669] = {.lex_state = 8, .external_lex_state = 4},
  [670] = {.lex_state = 8, .external_lex_state = 4},
  [671] = {.lex_state = 8, .external_lex_state = 4},
  [672] = {.lex_state = 8, .external_lex_state = 4},
  [673] = {.lex_state = 8, .external_lex_state = 4},
  [674] = {.lex_state = 8, .external_lex_state = 4},
  [675] = {.lex_state = 8, .external_lex_state = 4},
  [676] = {.lex_state = 8, .external_lex_state = 4},
  [677] = {.lex_state = 8, .external_lex_state = 4},
  [678] = {.lex_state = 8, .external_lex_state = 4},
  [679] = {.lex_state = 8, .external_lex_state = 4},
  [680] = {.lex_state = 8, .external_lex_state = 4},
  [681] = {.lex_state = 8, .external_lex_state = 4},
  [682] = {.lex_state = 8, .external_lex_state = 4},
  [683] = {.lex_state = 8, .external_lex_state = 4},
  [684] = {.lex_state = 8, .external_lex_state = 4},
  [685] = {.lex_state = 8, .external_lex_state = 4},
  [686] = {.lex_state = 8, .external_lex_state = 3},
  [687] = {.lex_state = 8, .external_lex_state = 4},
  [688] = {.lex_state = 8, .external_lex_state = 4},
  [689] = {.lex_state = 8, .external_lex_state = 4},
  [690] = {.lex_state = 8, .external_lex_state = 4},
  [691] = {.lex_state = 8, .external_lex_state = 4},
  [692] = {.lex_state = 8, .external_lex_state = 4},
  [693] = {.lex_state = 8, .external_lex_state = 4},
  [694] = {.lex_state = 8, .external_lex_state = 4},
  [695] = {.lex_state = 8, .external_lex_state = 4},
  [696] = {.lex_state = 8, .external_lex_state = 4},
  [697] = {.lex_state = 8, .external_lex_state = 4},
  [698] = {.lex_state = 8, .external_lex_state = 4},
  [699] = {.lex_state = 8, .external_lex_state = 4},
  [700] = {.lex_state = 8, .external_lex_state = 4},
  [701] = {.lex_state = 8, .external_lex_state = 4},
  [702] = {.lex_state = 8, .external_lex_state = 4},
  [703] = {.lex_state = 8, .external_lex_state = 4},
  [704] = {.lex_state = 8, .external_lex_state = 4},
  [705] = {.lex_state = 8, .external_lex_state = 4},
  [706] = {.lex_state = 8, .external_lex_state = 4},
  [707] = {.lex_state = 8, .external_lex_state = 4},
  [708] = {.lex_state = 8, .external_lex_state = 4},
  [709] = {.lex_state = 8, .external_lex_state = 4},
  [710] = {.lex_state = 8, .external_lex_state = 4},
  [711] = {.lex_state = 8, .external_lex_state = 4},
  [712] = {.lex_state = 8, .external_lex_state = 4},
  [713] = {.lex_state = 8, .external_lex_state = 4},
  [714] = {.lex_state = 8, .external_lex_state = 4},
  [715] = {.lex_state = 8, .external_lex_state = 4},
  [716] = {.lex_state = 8, .external_lex_state = 4},
  [717] = {.lex_state = 8, .external_lex_state = 4},
  [718] = {.lex_state = 8, .external_lex_state = 4},
  [719] = {.lex_state = 8, .external_lex_state = 4},
  [720] = {.lex_state = 8, .external_lex_state = 4},
  [721] = {.lex_state = 8, .external_lex_state = 4},
  [722] = {.lex_state = 8, .external_lex_state = 4},
  [723] = {.lex_state = 8, .external_lex_state = 4},
  [724] = {.lex_state = 8, .external_lex_state = 4},
  [725] = {.lex_state = 9, .external_lex_state = 4},
  [726] = {.lex_state = 8, .external_lex_state = 4},
  [727] = {.lex_state = 9, .external_lex_state = 4},
  [728] = {.lex_state = 8, .external_lex_state = 4},
  [729] = {.lex_state = 8, .external_lex_state = 3},
  [730] = {.lex_state = 8, .external_lex_state = 4},
  [731] = {.lex_state = 8, .external_lex_state = 3},
  [732] = {.lex_state = 8, .external_lex_state = 3},
  [733] = {.lex_state = 8, .external_lex_state = 3},
  [734] = {.lex_state = 8, .external_lex_state = 4},
  [735] = {.lex_state = 8, .external_lex_state = 4},
  [736] = {.lex_state = 8, .external_lex_state = 4},
  [737] = {.lex_state = 8, .external_lex_state = 4},
  [738] = {.lex_state = 8, .external_lex_state = 4},
  [739] = {.lex_state = 8, .external_lex_state = 4},
  [740] = {.lex_state = 8, .external_lex_state = 4},
  [741] = {.lex_state = 8, .external_lex_state = 4},
  [742] = {.lex_state = 8, .external_lex_state = 4},
  [743] = {.lex_state = 8, .external_lex_state = 4},
  [744] = {.lex_state = 8, .external_lex_state = 4},
  [745] = {.lex_state = 8, .external_lex_state = 4},
  [746] = {.lex_state = 8, .external_lex_state = 4},
  [747] = {.lex_state = 8, .external_lex_state = 4},
  [748] = {.lex_state = 8, .external_lex_state = 4},
  [749] = {.lex_state = 8, .external_lex_state = 4},
  [750] = {.lex_state = 8, .external_lex_state = 4},
  [751] = {.lex_state = 8, .external_lex_state = 4},
  [752] = {.lex_state = 8, .external_lex_state = 4},
  [753] = {.lex_state = 8, .external_lex_state = 4},
  [754] = {.lex_state = 8, .external_lex_state = 3},
  [755] = {.lex_state = 8, .external_lex_state = 4},
  [756] = {.lex_state = 8, .external_lex_state = 3},
  [757] = {.lex_state = 8, .external_lex_state = 3},
  [758] = {.lex_state = 8, .external_lex_state = 3},
  [759] = {.lex_state = 8, .external_lex_state = 3},
  [760] = {.lex_state = 8, .external_lex_state = 3},
  [761] = {.lex_state = 8, .external_lex_state = 3},
  [762] = {.lex_state = 8, .external_lex_state = 3},
  [763] = {.lex_state = 8, .external_lex_state = 3},
  [764] = {.lex_state = 8, .external_lex_state = 3},
  [765] = {.lex_state = 8, .external_lex_state = 3},
  [766] = {.lex_state = 8, .external_lex_state = 3},
  [767] = {.lex_state = 8, .external_lex_state = 3},
  [768] = {.lex_state = 8, .external_lex_state = 3},
  [769] = {.lex_state = 8, .external_lex_state = 3},
  [770] = {.lex_state = 8, .external_lex_state = 3},
  [771] = {.lex_state = 8, .external_lex_state = 3},
  [772] = {.lex_state = 8, .external_lex_state = 3},
  [773] = {.lex_state = 8, .external_lex_state = 3},
  [774] = {.lex_state = 8, .external_lex_state = 3},
  [775] = {.lex_state = 8, .external_lex_state = 3},
  [776] = {.lex_state = 8, .external_lex_state = 3},
  [777] = {.lex_state = 8, .external_lex_state = 3},
  [778] = {.lex_state = 8, .external_lex_state = 3},
  [779] = {.lex_state = 8, .external_lex_state = 3},
  [780] = {.lex_state = 8, .external_lex_state = 3},
  [781] = {.lex_state = 8, .external_lex_state = 3},
  [782] = {.lex_state = 8, .external_lex_state = 3},
  [783] = {.lex_state = 8, .external_lex_state = 3},
  [784] = {.lex_state = 8, .external_lex_state = 3},
  [785] = {.lex_state = 8, .external_lex_state = 3},
  [786] = {.lex_state = 8, .external_lex_state = 3},
  [787] = {.lex_state = 8, .external_lex_state = 3},
  [788] = {.lex_state = 8, .external_lex_state = 3},
  [789] = {.lex_state = 8, .external_lex_state = 3},
  [790] = {.lex_state = 8, .external_lex_state = 3},
  [791] = {.lex_state = 8, .external_lex_state = 3},
  [792] = {.lex_state = 8, .external_lex_state = 3},
  [793] = {.lex_state = 8, .external_lex_state = 3},
  [794] = {.lex_state = 8, .external_lex_state = 3},
  [795] = {.lex_state = 8, .external_lex_state = 3},
  [796] = {.lex_state = 8, .external_lex_state = 3},
  [797] = {.lex_state = 8, .external_lex_state = 3},
  [798] = {.lex_state = 8, .external_lex_state = 4},
  [799] = {.lex_state = 8, .external_lex_state = 3},
  [800] = {.lex_state = 8, .external_lex_state = 3},
  [801] = {.lex_state = 8, .external_lex_state = 3},
  [802] = {.lex_state = 8, .external_lex_state = 3},
  [803] = {.lex_state = 8, .external_lex_state = 3},
  [804] = {.lex_state = 8, .external_lex_state = 3},
  [805] = {.lex_state = 8, .external_lex_state = 3},
  [806] = {.lex_state = 8, .external_lex_state = 3},
  [807] = {.lex_state = 8, .external_lex_state = 3},
  [808] = {.lex_state = 8, .external_lex_state = 3},
  [809] = {.lex_state = 8, .external_lex_state = 3},
  [810] = {.lex_state = 8, .external_lex_state = 3},
  [811] = {.lex_state = 8, .external_lex_state = 3},
  [812] = {.lex_state = 8, .external_lex_state = 3},
  [813] = {.lex_state = 8, .external_lex_state = 3},
  [814] = {.lex_state = 8, .external_lex_state = 3},
  [815] = {.lex_state = 8, .external_lex_state = 3},
  [816] = {.lex_state = 8, .external_lex_state = 3},
  [817] = {.lex_state = 8, .external_lex_state = 3},
  [818] = {.lex_state = 8, .external_lex_state = 3},
  [819] = {.lex_state = 8, .external_lex_state = 3},
  [820] = {.lex_state = 8, .external_lex_state = 3},
  [821] = {.lex_state = 8, .external_lex_state = 3},
  [822] = {.lex_state = 8, .external_lex_state = 3},
  [823] = {.lex_state = 8, .external_lex_state = 3},
  [824] = {.lex_state = 8, .external_lex_state = 4},
  [825] = {.lex_state = 8, .external_lex_state = 3},
  [826] = {.lex_state = 8, .external_lex_state = 3},
  [827] = {.lex_state = 8, .external_lex_state = 3},
  [828] = {.lex_state = 8, .external_lex_state = 3},
  [829] = {.lex_state = 8, .external_lex_state = 3},
  [830] = {.lex_state = 8, .external_lex_state = 3},
  [831] = {.lex_state = 8, .external_lex_state = 3},
  [832] = {.lex_state = 5, .external_lex_state = 2},
  [833] = {.lex_state = 8, .external_lex_state = 4},
  [834] = {.lex_state = 8, .external_lex_state = 3},
  [835] = {.lex_state = 9, .external_lex_state = 3},
  [836] = {.lex_state = 5, .external_lex_state = 2},
  [837] = {.lex_state = 8, .external_lex_state = 3},
  [838] = {.lex_state = 8, .external_lex_state = 4},
  [839] = {.lex_state = 8, .external_lex_state = 3},
  [840] = {.lex_state = 5, .external_lex_state = 2},
  [841] = {.lex_state = 8, .external_lex_state = 3},
  [842] = {.lex_state = 5, .external_lex_state = 2},
  [843] = {.lex_state = 5, .external_lex_state = 2},
  [844] = {.lex_state = 5, .external_lex_state = 2},
  [845] = {.lex_state = 8, .external_lex_state = 3},
  [846] = {.lex_state = 8, .external_lex_state = 3},
  [847] = {.lex_state = 8, .external_lex_state = 3},
  [848] = {.lex_state = 8, .external_lex_state = 3},
  [849] = {.lex_state = 8, .external_lex_state = 3},
  [850] = {.lex_state = 8, .external_lex_state = 3},
  [851] = {.lex_state = 8, .external_lex_state = 3},
  [852] = {.lex_state = 8, .external_lex_state = 3},
  [853] = {.lex_state = 8, .external_lex_state = 3},
  [854] = {.lex_state = 8, .external_lex_state = 3},
  [855] = {.lex_state = 8, .external_lex_state = 3},
  [856] = {.lex_state = 8, .external_lex_state = 3},
  [857] = {.lex_state = 8, .external_lex_state = 3},
  [858] = {.lex_state = 8, .external_lex_state = 3},
  [859] = {.lex_state = 8, .external_lex_state = 3},
  [860] = {.lex_state = 8, .external_lex_state = 3},
  [861] = {.lex_state = 8, .external_lex_state = 3},
  [862] = {.lex_state = 8, .external_lex_state = 3},
  [863] = {.lex_state = 8, .external_lex_state = 3},
  [864] = {.lex_state = 8, .external_lex_state = 3},
  [865] = {.lex_state = 8, .external_lex_state = 3},
  [866] = {.lex_state = 8, .external_lex_state = 3},
  [867] = {.lex_state = 8, .external_lex_state = 3},
  [868] = {.lex_state = 8, .external_lex_state = 3},
  [869] = {.lex_state = 8, .external_lex_state = 3},
  [870] = {.lex_state = 8, .external_lex_state = 3},
  [871] = {.lex_state = 8, .external_lex_state = 3},
  [872] = {.lex_state = 8, .external_lex_state = 3},
  [873] = {.lex_state = 8, .external_lex_state = 3},
  [874] = {.lex_state = 8, .external_lex_state = 3},
  [875] = {.lex_state = 8, .external_lex_state = 3},
  [876] = {.lex_state = 8, .external_lex_state = 3},
  [877] = {.lex_state = 8, .external_lex_state = 3},
  [878] = {.lex_state = 5, .external_lex_state = 2},
  [879] = {.lex_state = 8, .external_lex_state = 3},
  [880] = {.lex_state = 8, .external_lex_state = 3},
  [881] = {.lex_state = 5, .external_lex_state = 2},
  [882] = {.lex_state = 5, .external_lex_state = 2},
  [883] = {.lex_state = 5, .external_lex_state = 2},
  [884] = {.lex_state = 5, .external_lex_state = 2},
  [885] = {.lex_state = 5, .external_lex_state = 2},
  [886] = {.lex_state = 5, .external_lex_state = 2},
  [887] = {.lex_state = 5, .external_lex_state = 2},
  [888] = {.lex_state = 5, .external_lex_state = 2},
  [889] = {.lex_state = 5, .external_lex_state = 2},
  [890] = {.lex_state = 5, .external_lex_state = 2},
  [891] = {.lex_state = 5, .external_lex_state = 2},
  [892] = {.lex_state = 144, .external_lex_state = 2},
  [893] = {.lex_state = 144, .external_lex_state = 2},
  [894] = {.lex_state = 144, .external_lex_state = 2},
  [895] = {.lex_state = 144, .external_lex_state = 2},
  [896] = {.lex_state = 144, .external_lex_state = 2},
  [897] = {.lex_state = 144, .external_lex_state = 2},
  [898] = {.lex_state = 144, .external_lex_state = 2},
  [899] = {.lex_state = 144, .external_lex_state = 2},
  [900] = {.lex_state = 144, .external_lex_state = 2},
  [901] = {.lex_state = 144, .external_lex_state = 2},
  [902] = {.lex_state = 144, .external_lex_state = 2},
  [903] = {.lex_state = 144, .external_lex_state = 2},
  [904] = {.lex_state = 144, .external_lex_state = 2},
  [905] = {.lex_state = 144, .external_lex_state = 2},
  [906] = {.lex_state = 144, .external_lex_state = 2},
  [907] = {.lex_state = 144, .external_lex_state = 5},
  [908] = {.lex_state = 144, .external_lex_state = 2},
  [909] = {.lex_state = 144, .external_lex_state = 2},
  [910] = {.lex_state = 144, .external_lex_state = 2},
  [911] = {.lex_state = 144, .external_lex_state = 2},
  [912] = {.lex_state = 144, .external_lex_state = 2},
  [913] = {.lex_state = 144, .external_lex_state = 2},
  [914] = {.lex_state = 144, .external_lex_state = 2},
  [915] = {.lex_state = 5, .external_lex_state = 2},
  [916] = {.lex_state = 144, .external_lex_state = 2},
  [917] = {.lex_state = 144, .external_lex_state = 2},
  [918] = {.lex_state = 144, .external_lex_state = 2},
  [919] = {.lex_state = 144, .external_lex_state = 5},
  [920] = {.lex_state = 144, .external_lex_state = 5},
  [921] = {.lex_state = 144, .external_lex_state = 2},
  [922] = {.lex_state = 144, .external_lex_state = 2},
  [923] = {.lex_state = 144, .external_lex_state = 2},
  [924] = {.lex_state = 144, .external_lex_state = 2},
  [925] = {.lex_state = 144, .external_lex_state = 5},
  [926] = {.lex_state = 5, .external_lex_state = 2},
  [927] = {.lex_state = 144, .external_lex_state = 5},
  [928] = {.lex_state = 5, .external_lex_state = 2},
  [929] = {.lex_state = 144, .external_lex_state = 5},
  [930] = {.lex_state = 5, .external_lex_state = 2},
  [931] = {.lex_state = 5, .external_lex_state = 2},
  [932] = {.lex_state = 5, .external_lex_state = 2},
  [933] = {.lex_state = 144, .external_lex_state = 5},
  [934] = {.lex_state = 144, .external_lex_state = 5},
  [935] = {.lex_state = 5, .external_lex_state = 2},
  [936] = {.lex_state = 11, .external_lex_state = 2},
  [937] = {.lex_state = 5, .external_lex_state = 2},
  [938] = {.lex_state = 5, .external_lex_state = 2},
  [939] = {.lex_state = 5, .external_lex_state = 2},
  [940] = {.lex_state = 5, .external_lex_state = 5},
  [941] = {.lex_state = 5, .external_lex_state = 2},
  [942] = {.lex_state = 5, .external_lex_state = 2},
  [943] = {.lex_state = 144, .external_lex_state = 2},
  [944] = {.lex_state = 5, .external_lex_state = 2},
  [945] = {.lex_state = 5, .external_lex_state = 2},
  [946] = {.lex_state = 5, .external_lex_state = 5},
  [947] = {.lex_state = 5, .external_lex_state = 2},
  [948] = {.lex_state = 5, .external_lex_state = 2},
  [949] = {.lex_state = 5, .external_lex_state = 2},
  [950] = {.lex_state = 5, .external_lex_state = 2},
  [951] = {.lex_state = 5, .external_lex_state = 2},
  [952] = {.lex_state = 5, .external_lex_state = 2},
  [953] = {.lex_state = 5, .external_lex_state = 2},
  [954] = {.lex_state = 5, .external_lex_state = 2},
  [955] = {.lex_state = 5, .external_lex_state = 2},
  [956] = {.lex_state = 5, .external_lex_state = 2},
  [957] = {.lex_state = 5, .external_lex_state = 2},
  [958] = {.lex_state = 5, .external_lex_state = 2},
  [959] = {.lex_state = 5, .external_lex_state = 2},
  [960] = {.lex_state = 5, .external_lex_state = 2},
  [961] = {.lex_state = 144, .external_lex_state = 5},
  [962] = {.lex_state = 5, .external_lex_state = 2},
  [963] = {.lex_state = 5, .external_lex_state = 2},
  [964] = {.lex_state = 144, .external_lex_state = 5},
  [965] = {.lex_state = 144, .external_lex_state = 5},
  [966] = {.lex_state = 144, .external_lex_state = 5},
  [967] = {.lex_state = 5, .external_lex_state = 2},
  [968] = {.lex_state = 5, .external_lex_state = 2},
  [969] = {.lex_state = 5, .external_lex_state = 2},
  [970] = {.lex_state = 5, .external_lex_state = 2},
  [971] = {.lex_state = 5, .external_lex_state = 2},
  [972] = {.lex_state = 5, .external_lex_state = 2},
  [973] = {.lex_state = 5, .external_lex_state = 2},
  [974] = {.lex_state = 5, .external_lex_state = 2},
  [975] = {.lex_state = 5, .external_lex_state = 2},
  [976] = {.lex_state = 5, .external_lex_state = 2},
  [977] = {.lex_state = 5, .external_lex_state = 2},
  [978] = {.lex_state = 5, .external_lex_state = 2},
  [979] = {.lex_state = 11, .external_lex_state = 2},
  [980] = {.lex_state = 144, .external_lex_state = 2},
  [981] = {.lex_state = 144, .external_lex_state = 2},
  [982] = {.lex_state = 144, .external_lex_state = 2},
  [983] = {.lex_state = 144, .external_lex_state = 2},
  [984] = {.lex_state = 144, .external_lex_state = 2},
  [985] = {.lex_state = 144, .external_lex_state = 2},
  [986] = {.lex_state = 144, .external_lex_state = 2},
  [987] = {.lex_state = 144, .external_lex_state = 2},
  [988] = {.lex_state = 144, .external_lex_state = 2},
  [989] = {.lex_state = 144, .external_lex_state = 2},
  [990] = {.lex_state = 5, .external_lex_state = 2},
  [991] = {.lex_state = 5, .external_lex_state = 2},
  [992] = {.lex_state = 5, .external_lex_state = 2},
  [993] = {.lex_state = 144, .external_lex_state = 2},
  [994] = {.lex_state = 144, .external_lex_state = 2},
  [995] = {.lex_state = 144, .external_lex_state = 2},
  [996] = {.lex_state = 144, .external_lex_state = 2},
  [997] = {.lex_state = 144, .external_lex_state = 2},
  [998] = {.lex_state = 144, .external_lex_state = 2},
  [999] = {.lex_state = 144, .external_lex_state = 2},
  [1000] = {.lex_state = 144, .external_lex_state = 2},
  [1001] = {.lex_state = 144, .external_lex_state = 2},
  [1002] = {.lex_state = 144, .external_lex_state = 2},
  [1003] = {.lex_state = 144, .external_lex_state = 2},
  [1004] = {.lex_state = 144, .external_lex_state = 2},
  [1005] = {.lex_state = 144, .external_lex_state = 2},
  [1006] = {.lex_state = 144, .external_lex_state = 2},
  [1007] = {.lex_state = 5, .external_lex_state = 2},
  [1008] = {.lex_state = 144, .external_lex_state = 2},
  [1009] = {.lex_state = 144, .external_lex_state = 2},
  [1010] = {.lex_state = 144, .external_lex_state = 2},
  [1011] = {.lex_state = 144, .external_lex_state = 2},
  [1012] = {.lex_state = 144, .external_lex_state = 2},
  [1013] = {.lex_state = 144, .external_lex_state = 2},
  [1014] = {.lex_state = 5, .external_lex_state = 2},
  [1015] = {.lex_state = 144, .external_lex_state = 2},
  [1016] = {.lex_state = 144, .external_lex_state = 2},
  [1017] = {.lex_state = 144, .external_lex_state = 2},
  [1018] = {.lex_state = 144, .external_lex_state = 2},
  [1019] = {.lex_state = 144, .external_lex_state = 2},
  [1020] = {.lex_state = 144, .external_lex_state = 2},
  [1021] = {.lex_state = 144, .external_lex_state = 2},
  [1022] = {.lex_state = 144, .external_lex_state = 2},
  [1023] = {.lex_state = 5, .external_lex_state = 2},
  [1024] = {.lex_state = 144, .external_lex_state = 2},
  [1025] = {.lex_state = 144, .external_lex_state = 2},
  [1026] = {.lex_state = 144, .external_lex_state = 2},
  [1027] = {.lex_state = 144, .external_lex_state = 2},
  [1028] = {.lex_state = 7, .external_lex_state = 2},
  [1029] = {.lex_state = 144, .external_lex_state = 2},
  [1030] = {.lex_state = 144, .external_lex_state = 2},
  [1031] = {.lex_state = 144, .external_lex_state = 2},
  [1032] = {.lex_state = 7, .external_lex_state = 2},
  [1033] = {.lex_state = 7, .external_lex_state = 2},
  [1034] = {.lex_state = 7, .external_lex_state = 2},
  [1035] = {.lex_state = 144, .external_lex_state = 2},
  [1036] = {.lex_state = 144, .external_lex_state = 2},
  [1037] = {.lex_state = 144, .external_lex_state = 2},
  [1038] = {.lex_state = 144, .external_lex_state = 2},
  [1039] = {.lex_state = 144, .external_lex_state = 2},
  [1040] = {.lex_state = 144, .external_lex_state = 2},
  [1041] = {.lex_state = 144, .external_lex_state = 2},
  [1042] = {.lex_state = 144, .external_lex_state = 2},
  [1043] = {.lex_state = 144, .external_lex_state = 2},
  [1044] = {.lex_state = 144, .external_lex_state = 2},
  [1045] = {.lex_state = 144, .external_lex_state = 2},
  [1046] = {.lex_state = 144, .external_lex_state = 2},
  [1047] = {.lex_state = 7, .external_lex_state = 2},
  [1048] = {.lex_state = 143, .external_lex_state = 2},
  [1049] = {.lex_state = 13, .external_lex_state = 2},
  [1050] = {.lex_state = 13, .external_lex_state = 2},
  [1051] = {.lex_state = 11, .external_lex_state = 6},
  [1052] = {.lex_state = 11, .external_lex_state = 6},
  [1053] = {.lex_state = 11, .external_lex_state = 6},
  [1054] = {.lex_state = 13, .external_lex_state = 2},
  [1055] = {.lex_state = 11, .external_lex_state = 6},
  [1056] = {.lex_state = 11, .external_lex_state = 6},
  [1057] = {.lex_state = 11, .external_lex_state = 6},
  [1058] = {.lex_state = 11, .external_lex_state = 6},
  [1059] = {.lex_state = 11, .external_lex_state = 6},
  [1060] = {.lex_state = 13, .external_lex_state = 2},
  [1061] = {.lex_state = 13, .external_lex_state = 2},
  [1062] = {.lex_state = 11, .external_lex_state = 6},
  [1063] = {.lex_state = 13, .external_lex_state = 2},
  [1064] = {.lex_state = 13, .external_lex_state = 2},
  [1065] = {.lex_state = 13, .external_lex_state = 2},
  [1066] = {.lex_state = 13, .external_lex_state = 2},
  [1067] = {.lex_state = 13, .external_lex_state = 2},
  [1068] = {.lex_state = 13, .external_lex_state = 2},
  [1069] = {.lex_state = 13, .external_lex_state = 2},
  [1070] = {.lex_state = 13, .external_lex_state = 2},
  [1071] = {.lex_state = 13, .external_lex_state = 2},
  [1072] = {.lex_state = 13, .external_lex_state = 2},
  [1073] = {.lex_state = 13, .external_lex_state = 2},
  [1074] = {.lex_state = 13, .external_lex_state = 2},
  [1075] = {.lex_state = 13, .external_lex_state = 2},
  [1076] = {.lex_state = 13, .external_lex_state = 2},
  [1077] = {.lex_state = 13, .external_lex_state = 2},
  [1078] = {.lex_state = 13, .external_lex_state = 2},
  [1079] = {.lex_state = 13, .external_lex_state = 2},
  [1080] = {.lex_state = 13, .external_lex_state = 2},
  [1081] = {.lex_state = 13, .external_lex_state = 2},
  [1082] = {.lex_state = 13, .external_lex_state = 2},
  [1083] = {.lex_state = 13, .external_lex_state = 2},
  [1084] = {.lex_state = 13, .external_lex_state = 2},
  [1085] = {.lex_state = 13, .external_lex_state = 2},
  [1086] = {.lex_state = 13, .external_lex_state = 2},
  [1087] = {.lex_state = 13, .external_lex_state = 2},
  [1088] = {.lex_state = 13, .external_lex_state = 2},
  [1089] = {.lex_state = 13, .external_lex_state = 2},
  [1090] = {.lex_state = 13, .external_lex_state = 2},
  [1091] = {.lex_state = 13, .external_lex_state = 2},
  [1092] = {.lex_state = 13, .external_lex_state = 2},
  [1093] = {.lex_state = 144, .external_lex_state = 2},
  [1094] = {.lex_state = 144, .external_lex_state = 2},
  [1095] = {.lex_state = 144, .external_lex_state = 2},
  [1096] = {.lex_state = 144, .external_lex_state = 2},
  [1097] = {.lex_state = 144, .external_lex_state = 2},
  [1098] = {.lex_state = 144, .external_lex_state = 2},
  [1099] = {.lex_state = 144, .external_lex_state = 2},
  [1100] = {.lex_state = 144, .external_lex_state = 2},
  [1101] = {.lex_state = 144, .external_lex_state = 2},
  [1102] = {.lex_state = 144, .external_lex_state = 2},
  [1103] = {.lex_state = 144, .external_lex_state = 5},
  [1104] = {.lex_state = 144, .external_lex_state = 2},
  [1105] = {.lex_state = 144, .external_lex_state = 2},
  [1106] = {.lex_state = 144, .external_lex_state = 2},
  [1107] = {.lex_state = 144, .external_lex_state = 2},
  [1108] = {.lex_state = 144, .external_lex_state = 2},
  [1109] = {.lex_state = 144, .external_lex_state = 5},
  [1110] = {.lex_state = 144, .external_lex_state = 2},
  [1111] = {.lex_state = 144, .external_lex_state = 2},
  [1112] = {.lex_state = 144, .external_lex_state = 2},
  [1113] = {.lex_state = 144, .external_lex_state = 2},
  [1114] = {.lex_state = 144, .external_lex_state = 2},
  [1115] = {.lex_state = 144, .external_lex_state = 2},
  [1116] = {.lex_state = 144, .external_lex_state = 2},
  [1117] = {.lex_state = 13, .external_lex_state = 2},
  [1118] = {.lex_state = 144, .external_lex_state = 2},
  [1119] = {.lex_state = 144, .external_lex_state = 2},
  [1120] = {.lex_state = 19, .external_lex_state = 7},
  [1121] = {.lex_state = 144, .external_lex_state = 2},
  [1122] = {.lex_state = 144, .external_lex_state = 5},
  [1123] = {.lex_state = 13, .external_lex_state = 2},
  [1124] = {.lex_state = 144, .external_lex_state = 2},
  [1125] = {.lex_state = 144, .external_lex_state = 5},
  [1126] = {.lex_state = 13, .external_lex_state = 2},
  [1127] = {.lex_state = 144, .external_lex_state = 5},
  [1128] = {.lex_state = 144, .external_lex_state = 5},
  [1129] = {.lex_state = 144, .external_lex_state = 5},
  [1130] = {.lex_state = 144, .external_lex_state = 2},
  [1131] = {.lex_state = 144, .external_lex_state = 5},
  [1132] = {.lex_state = 144, .external_lex_state = 5},
  [1133] = {.lex_state = 144, .external_lex_state = 5},
  [1134] = {.lex_state = 144, .external_lex_state = 2},
  [1135] = {.lex_state = 144, .external_lex_state = 2},
  [1136] = {.lex_state = 144, .external_lex_state = 5},
  [1137] = {.lex_state = 144, .external_lex_state = 2},
  [1138] = {.lex_state = 144, .external_lex_state = 5},
  [1139] = {.lex_state = 19, .external_lex_state = 7},
  [1140] = {.lex_state = 19, .external_lex_state = 7},
  [1141] = {.lex_state = 144, .external_lex_state = 2},
  [1142] = {.lex_state = 144, .external_lex_state = 2},
  [1143] = {.lex_state = 19, .external_lex_state = 7},
  [1144] = {.lex_state = 144, .external_lex_state = 2},
  [1145] = {.lex_state = 13, .external_lex_state = 2},
  [1146] = {.lex_state = 144, .external_lex_state = 2},
  [1147] = {.lex_state = 144, .external_lex_state = 5},
  [1148] = {.lex_state = 144, .external_lex_state = 5},
  [1149] = {.lex_state = 19, .external_lex_state = 7},
  [1150] = {.lex_state = 11, .external_lex_state = 6},
  [1151] = {.lex_state = 13, .external_lex_state = 2},
  [1152] = {.lex_state = 144, .external_lex_state = 2},
  [1153] = {.lex_state = 144, .external_lex_state = 2},
  [1154] = {.lex_state = 11, .external_lex_state = 6},
  [1155] = {.lex_state = 13, .external_lex_state = 2},
  [1156] = {.lex_state = 144, .external_lex_state = 2},
  [1157] = {.lex_state = 13, .external_lex_state = 2},
  [1158] = {.lex_state = 11, .external_lex_state = 6},
  [1159] = {.lex_state = 144, .external_lex_state = 2},
  [1160] = {.lex_state = 144, .external_lex_state = 2},
  [1161] = {.lex_state = 144, .external_lex_state = 2},
  [1162] = {.lex_state = 144, .external_lex_state = 2},
  [1163] = {.lex_state = 144, .external_lex_state = 5},
  [1164] = {.lex_state = 13, .external_lex_state = 2},
  [1165] = {.lex_state = 144, .external_lex_state = 5},
  [1166] = {.lex_state = 11, .external_lex_state = 6},
  [1167] = {.lex_state = 13, .external_lex_state = 2},
  [1168] = {.lex_state = 13, .external_lex_state = 2},
  [1169] = {.lex_state = 144, .external_lex_state = 2},
  [1170] = {.lex_state = 11, .external_lex_state = 6},
  [1171] = {.lex_state = 13, .external_lex_state = 2},
  [1172] = {.lex_state = 13, .external_lex_state = 2},
  [1173] = {.lex_state = 11, .external_lex_state = 6},
  [1174] = {.lex_state = 144, .external_lex_state = 2},
  [1175] = {.lex_state = 13, .external_lex_state = 2},
  [1176] = {.lex_state = 13, .external_lex_state = 2},
  [1177] = {.lex_state = 144, .external_lex_state = 2},
  [1178] = {.lex_state = 144, .external_lex_state = 2},
  [1179] = {.lex_state = 11, .external_lex_state = 6},
  [1180] = {.lex_state = 144, .external_lex_state = 2},
  [1181] = {.lex_state = 11, .external_lex_state = 6},
  [1182] = {.lex_state = 11, .external_lex_state = 6},
  [1183] = {.lex_state = 11, .external_lex_state = 6},
  [1184] = {.lex_state = 144, .external_lex_state = 2},
  [1185] = {.lex_state = 144, .external_lex_state = 2},
  [1186] = {.lex_state = 144, .external_lex_state = 5},
  [1187] = {.lex_state = 13, .external_lex_state = 2},
  [1188] = {.lex_state = 11, .external_lex_state = 6},
  [1189] = {.lex_state = 144, .external_lex_state = 2},
  [1190] = {.lex_state = 11, .external_lex_state = 6},
  [1191] = {.lex_state = 144, .external_lex_state = 2},
  [1192] = {.lex_state = 13, .external_lex_state = 2},
  [1193] = {.lex_state = 13, .external_lex_state = 2},
  [1194] = {.lex_state = 11, .external_lex_state = 6},
  [1195] = {.lex_state = 13, .external_lex_state = 2},
  [1196] = {.lex_state = 144, .external_lex_state = 2},
  [1197] = {.lex_state = 13, .external_lex_state = 2},
  [1198] = {.lex_state = 13, .external_lex_state = 2},
  [1199] = {.lex_state = 144, .external_lex_state = 2},
  [1200] = {.lex_state = 13, .external_lex_state = 2},
  [1201] = {.lex_state = 13, .external_lex_state = 2},
  [1202] = {.lex_state = 144, .external_lex_state = 5},
  [1203] = {.lex_state = 13, .external_lex_state = 2},
  [1204] = {.lex_state = 13, .external_lex_state = 2},
  [1205] = {.lex_state = 13, .external_lex_state = 2},
  [1206] = {.lex_state = 13, .external_lex_state = 2},
  [1207] = {.lex_state = 13, .external_lex_state = 2},
  [1208] = {.lex_state = 144, .external_lex_state = 2},
  [1209] = {.lex_state = 11, .external_lex_state = 6},
  [1210] = {.lex_state = 144, .external_lex_state = 2},
  [1211] = {.lex_state = 11, .external_lex_state = 6},
  [1212] = {.lex_state = 11, .external_lex_state = 6},
  [1213] = {.lex_state = 144, .external_lex_state = 2},
  [1214] = {.lex_state = 144, .external_lex_state = 2},
  [1215] = {.lex_state = 13, .external_lex_state = 2},
  [1216] = {.lex_state = 11, .external_lex_state = 6},
  [1217] = {.lex_state = 144, .external_lex_state = 2},
  [1218] = {.lex_state = 144, .external_lex_state = 2},
  [1219] = {.lex_state = 144, .external_lex_state = 5},
  [1220] = {.lex_state = 144, .external_lex_state = 5},
  [1221] = {.lex_state = 144, .external_lex_state = 5},
  [1222] = {.lex_state = 144, .external_lex_state = 2},
  [1223] = {.lex_state = 144, .external_lex_state = 2},
  [1224] = {.lex_state = 144, .external_lex_state = 2},
  [1225] = {.lex_state = 144, .external_lex_state = 2},
  [1226] = {.lex_state = 144, .external_lex_state = 2},
  [1227] = {.lex_state = 144, .external_lex_state = 2},
  [1228] = {.lex_state = 15, .external_lex_state = 8},
  [1229] = {.lex_state = 23, .external_lex_state = 8},
  [1230] = {.lex_state = 144, .external_lex_state = 2},
  [1231] = {.lex_state = 12, .external_lex_state = 2},
  [1232] = {.lex_state = 21, .external_lex_state = 2},
  [1233] = {.lex_state = 23, .external_lex_state = 8},
  [1234] = {.lex_state = 144, .external_lex_state = 2},
  [1235] = {.lex_state = 144, .external_lex_state = 2},
  [1236] = {.lex_state = 144, .external_lex_state = 2},
  [1237] = {.lex_state = 19, .external_lex_state = 7},
  [1238] = {.lex_state = 144, .external_lex_state = 2},
  [1239] = {.lex_state = 15, .external_lex_state = 8},
  [1240] = {.lex_state = 144, .external_lex_state = 5},
  [1241] = {.lex_state = 15, .external_lex_state = 8},
  [1242] = {.lex_state = 23, .external_lex_state = 8},
  [1243] = {.lex_state = 144, .external_lex_state = 2},
  [1244] = {.lex_state = 144, .external_lex_state = 2},
  [1245] = {.lex_state = 144, .external_lex_state = 2},
  [1246] = {.lex_state = 15, .external_lex_state = 8},
  [1247] = {.lex_state = 23, .external_lex_state = 8},
  [1248] = {.lex_state = 144, .external_lex_state = 2},
  [1249] = {.lex_state = 15, .external_lex_state = 8},
  [1250] = {.lex_state = 23, .external_lex_state = 8},
  [1251] = {.lex_state = 144, .external_lex_state = 5},
  [1252] = {.lex_state = 15, .external_lex_state = 8},
  [1253] = {.lex_state = 23, .external_lex_state = 8},
  [1254] = {.lex_state = 144, .external_lex_state = 2},
  [1255] = {.lex_state = 15, .external_lex_state = 8},
  [1256] = {.lex_state = 23, .external_lex_state = 8},
  [1257] = {.lex_state = 144, .external_lex_state = 2},
  [1258] = {.lex_state = 144, .external_lex_state = 2},
  [1259] = {.lex_state = 144, .external_lex_state = 2},
  [1260] = {.lex_state = 144, .external_lex_state = 2},
  [1261] = {.lex_state = 144, .external_lex_state = 2},
  [1262] = {.lex_state = 144, .external_lex_state = 2},
  [1263] = {.lex_state = 144, .external_lex_state = 2},
  [1264] = {.lex_state = 144, .external_lex_state = 2},
  [1265] = {.lex_state = 144, .external_lex_state = 2},
  [1266] = {.lex_state = 144, .external_lex_state = 2},
  [1267] = {.lex_state = 143, .external_lex_state = 2},
  [1268] = {.lex_state = 12, .external_lex_state = 2},
  [1269] = {.lex_state = 21, .external_lex_state = 2},
  [1270] = {.lex_state = 144, .external_lex_state = 2},
  [1271] = {.lex_state = 144, .external_lex_state = 5},
  [1272] = {.lex_state = 144, .external_lex_state = 2},
  [1273] = {.lex_state = 144, .external_lex_state = 5},
  [1274] = {.lex_state = 144, .external_lex_state = 2},
  [1275] = {.lex_state = 144, .external_lex_state = 2},
  [1276] = {.lex_state = 15, .external_lex_state = 8},
  [1277] = {.lex_state = 23, .external_lex_state = 8},
  [1278] = {.lex_state = 144, .external_lex_state = 2},
  [1279] = {.lex_state = 143, .external_lex_state = 2},
  [1280] = {.lex_state = 144, .external_lex_state = 5},
  [1281] = {.lex_state = 144, .external_lex_state = 5},
  [1282] = {.lex_state = 144, .external_lex_state = 5},
  [1283] = {.lex_state = 144, .external_lex_state = 5},
  [1284] = {.lex_state = 144, .external_lex_state = 5},
  [1285] = {.lex_state = 144, .external_lex_state = 2},
  [1286] = {.lex_state = 12, .external_lex_state = 2},
  [1287] = {.lex_state = 15, .external_lex_state = 8},
  [1288] = {.lex_state = 23, .external_lex_state = 8},
  [1289] = {.lex_state = 144, .external_lex_state = 2},
  [1290] = {.lex_state = 21, .external_lex_state = 2},
  [1291] = {.lex_state = 144, .external_lex_state = 2},
  [1292] = {.lex_state = 144, .external_lex_state = 2},
  [1293] = {.lex_state = 144, .external_lex_state = 2},
  [1294] = {.lex_state = 144, .external_lex_state = 2},
  [1295] = {.lex_state = 144, .external_lex_state = 2},
  [1296] = {.lex_state = 6, .external_lex_state = 2},
  [1297] = {.lex_state = 144, .external_lex_state = 2},
  [1298] = {.lex_state = 144, .external_lex_state = 5},
  [1299] = {.lex_state = 144, .external_lex_state = 2},
  [1300] = {.lex_state = 144, .external_lex_state = 2},
  [1301] = {.lex_state = 144, .external_lex_state = 2},
  [1302] = {.lex_state = 144, .external_lex_state = 2},
  [1303] = {.lex_state = 2, .external_lex_state = 2},
  [1304] = {.lex_state = 144, .external_lex_state = 2},
  [1305] = {.lex_state = 144, .external_lex_state = 2},
  [1306] = {.lex_state = 6, .external_lex_state = 2},
  [1307] = {.lex_state = 144, .external_lex_state = 5},
  [1308] = {.lex_state = 144, .external_lex_state = 2},
  [1309] = {.lex_state = 144, .external_lex_state = 2},
  [1310] = {.lex_state = 144, .external_lex_state = 2},
  [1311] = {.lex_state = 144, .external_lex_state = 2},
  [1312] = {.lex_state = 144, .external_lex_state = 2},
  [1313] = {.lex_state = 144, .external_lex_state = 2},
  [1314] = {.lex_state = 144, .external_lex_state = 2},
  [1315] = {.lex_state = 144, .external_lex_state = 2},
  [1316] = {.lex_state = 144, .external_lex_state = 2},
  [1317] = {.lex_state = 144, .external_lex_state = 2},
  [1318] = {.lex_state = 144, .external_lex_state = 2},
  [1319] = {.lex_state = 144, .external_lex_state = 2},
  [1320] = {.lex_state = 144, .external_lex_state = 2},
  [1321] = {.lex_state = 144, .external_lex_state = 5},
  [1322] = {.lex_state = 144, .external_lex_state = 2},
  [1323] = {.lex_state = 144, .external_lex_state = 2},
  [1324] = {.lex_state = 144, .external_lex_state = 2},
  [1325] = {.lex_state = 144, .external_lex_state = 2},
  [1326] = {.lex_state = 144, .external_lex_state = 2},
  [1327] = {.lex_state = 144, .external_lex_state = 2},
  [1328] = {.lex_state = 144, .external_lex_state = 2},
  [1329] = {.lex_state = 144, .external_lex_state = 2},
  [1330] = {.lex_state = 144, .external_lex_state = 5},
  [1331] = {.lex_state = 144, .external_lex_state = 2},
  [1332] = {.lex_state = 144, .external_lex_state = 2},
  [1333] = {.lex_state = 144, .external_lex_state = 2},
  [1334] = {.lex_state = 144, .external_lex_state = 2},
  [1335] = {.lex_state = 144, .external_lex_state = 2},
  [1336] = {.lex_state = 144, .external_lex_state = 2},
  [1337] = {.lex_state = 144, .external_lex_state = 2},
  [1338] = {.lex_state = 143, .external_lex_state = 2},
  [1339] = {.lex_state = 144, .external_lex_state = 5},
  [1340] = {.lex_state = 144, .external_lex_state = 2},
  [1341] = {.lex_state = 144, .external_lex_state = 2},
  [1342] = {.lex_state = 144, .external_lex_state = 2},
  [1343] = {.lex_state = 144, .external_lex_state = 2},
  [1344] = {.lex_state = 144, .external_lex_state = 5},
  [1345] = {.lex_state = 144, .external_lex_state = 2},
  [1346] = {.lex_state = 144, .external_lex_state = 2},
  [1347] = {.lex_state = 144, .external_lex_state = 2},
  [1348] = {.lex_state = 2, .external_lex_state = 2},
  [1349] = {.lex_state = 144, .external_lex_state = 5},
  [1350] = {.lex_state = 144, .external_lex_state = 2},
  [1351] = {.lex_state = 144, .external_lex_state = 5},
  [1352] = {.lex_state = 144, .external_lex_state = 2},
  [1353] = {.lex_state = 144, .external_lex_state = 5},
  [1354] = {.lex_state = 144, .external_lex_state = 2},
  [1355] = {.lex_state = 144, .external_lex_state = 2},
  [1356] = {.lex_state = 144, .external_lex_state = 2},
  [1357] = {.lex_state = 2, .external_lex_state = 2},
  [1358] = {.lex_state = 144, .external_lex_state = 2},
  [1359] = {.lex_state = 144, .external_lex_state = 2},
  [1360] = {.lex_state = 144, .external_lex_state = 2},
  [1361] = {.lex_state = 144, .external_lex_state = 2},
  [1362] = {.lex_state = 144, .external_lex_state = 2},
  [1363] = {.lex_state = 144, .external_lex_state = 2},
  [1364] = {.lex_state = 2, .external_lex_state = 2},
  [1365] = {.lex_state = 144, .external_lex_state = 2},
  [1366] = {.lex_state = 144, .external_lex_state = 2},
  [1367] = {.lex_state = 144, .external_lex_state = 2},
  [1368] = {.lex_state = 144, .external_lex_state = 2},
  [1369] = {.lex_state = 144, .external_lex_state = 2},
  [1370] = {.lex_state = 144, .external_lex_state = 2},
  [1371] = {.lex_state = 144, .external_lex_state = 2},
  [1372] = {.lex_state = 144, .external_lex_state = 2},
  [1373] = {.lex_state = 144, .external_lex_state = 2},
  [1374] = {.lex_state = 2, .external_lex_state = 2},
  [1375] = {.lex_state = 144, .external_lex_state = 2},
  [1376] = {.lex_state = 144, .external_lex_state = 5},
  [1377] = {.lex_state = 143, .external_lex_state = 2},
  [1378] = {.lex_state = 2, .external_lex_state = 2},
  [1379] = {.lex_state = 144, .external_lex_state = 2},
  [1380] = {.lex_state = 144, .external_lex_state = 2},
  [1381] = {.lex_state = 144, .external_lex_state = 2},
  [1382] = {.lex_state = 144, .external_lex_state = 2},
  [1383] = {.lex_state = 144, .external_lex_state = 2},
  [1384] = {.lex_state = 144, .external_lex_state = 2},
  [1385] = {.lex_state = 144, .external_lex_state = 2},
  [1386] = {.lex_state = 2, .external_lex_state = 2},
  [1387] = {.lex_state = 144, .external_lex_state = 2},
  [1388] = {.lex_state = 144, .external_lex_state = 2},
  [1389] = {.lex_state = 144, .external_lex_state = 2},
  [1390] = {.lex_state = 144, .external_lex_state = 2},
  [1391] = {.lex_state = 6, .external_lex_state = 2},
  [1392] = {.lex_state = 144, .external_lex_state = 2},
  [1393] = {.lex_state = 144, .external_lex_state = 2},
  [1394] = {.lex_state = 6, .external_lex_state = 2},
  [1395] = {.lex_state = 144, .external_lex_state = 2},
  [1396] = {.lex_state = 144, .external_lex_state = 2},
  [1397] = {.lex_state = 144, .external_lex_state = 2},
  [1398] = {.lex_state = 144, .external_lex_state = 2},
  [1399] = {.lex_state = 144, .external_lex_state = 2},
  [1400] = {.lex_state = 144, .external_lex_state = 2},
  [1401] = {.lex_state = 144, .external_lex_state = 2},
  [1402] = {.lex_state = 144, .external_lex_state = 2},
  [1403] = {.lex_state = 144, .external_lex_state = 2},
  [1404] = {.lex_state = 144, .external_lex_state = 2},
  [1405] = {.lex_state = 144, .external_lex_state = 2},
  [1406] = {.lex_state = 144, .external_lex_state = 2},
  [1407] = {.lex_state = 144, .external_lex_state = 2},
  [1408] = {.lex_state = 144, .external_lex_state = 2},
  [1409] = {.lex_state = 144, .external_lex_state = 2},
  [1410] = {.lex_state = 144, .external_lex_state = 2},
  [1411] = {.lex_state = 144, .external_lex_state = 2},
  [1412] = {.lex_state = 144, .external_lex_state = 5},
  [1413] = {.lex_state = 144, .external_lex_state = 2},
  [1414] = {.lex_state = 144, .external_lex_state = 2},
  [1415] = {.lex_state = 144, .external_lex_state = 2},
  [1416] = {.lex_state = 144, .external_lex_state = 2},
  [1417] = {.lex_state = 144, .external_lex_state = 2},
  [1418] = {.lex_state = 6, .external_lex_state = 2},
  [1419] = {.lex_state = 144, .external_lex_state = 2},
  [1420] = {.lex_state = 144, .external_lex_state = 2},
  [1421] = {.lex_state = 144, .external_lex_state = 2},
  [1422] = {.lex_state = 144, .external_lex_state = 2},
  [1423] = {.lex_state = 144, .external_lex_state = 2},
  [1424] = {.lex_state = 144, .external_lex_state = 2},
  [1425] = {.lex_state = 144, .external_lex_state = 2},
  [1426] = {.lex_state = 144, .external_lex_state = 2},
  [1427] = {.lex_state = 144, .external_lex_state = 2},
  [1428] = {.lex_state = 144, .external_lex_state = 2},
  [1429] = {.lex_state = 144, .external_lex_state = 2},
  [1430] = {.lex_state = 144, .external_lex_state = 5},
  [1431] = {.lex_state = 144, .external_lex_state = 2},
  [1432] = {.lex_state = 144, .external_lex_state = 2},
  [1433] = {.lex_state = 144, .external_lex_state = 2},
  [1434] = {.lex_state = 144, .external_lex_state = 2},
  [1435] = {.lex_state = 144, .external_lex_state = 2},
  [1436] = {.lex_state = 144, .external_lex_state = 2},
  [1437] = {.lex_state = 144, .external_lex_state = 2},
  [1438] = {.lex_state = 144, .external_lex_state = 2},
  [1439] = {.lex_state = 144, .external_lex_state = 2},
  [1440] = {.lex_state = 144, .external_lex_state = 2},
  [1441] = {.lex_state = 144, .external_lex_state = 2},
  [1442] = {.lex_state = 144, .external_lex_state = 5},
  [1443] = {.lex_state = 144, .external_lex_state = 5},
  [1444] = {.lex_state = 144, .external_lex_state = 2},
  [1445] = {.lex_state = 144, .external_lex_state = 2},
  [1446] = {.lex_state = 144, .external_lex_state = 2},
  [1447] = {.lex_state = 6, .external_lex_state = 2},
  [1448] = {.lex_state = 144, .external_lex_state = 2},
  [1449] = {.lex_state = 144, .external_lex_state = 2},
  [1450] = {.lex_state = 144, .external_lex_state = 2},
  [1451] = {.lex_state = 144, .external_lex_state = 2},
  [1452] = {.lex_state = 144, .external_lex_state = 2},
  [1453] = {.lex_state = 144, .external_lex_state = 2},
  [1454] = {.lex_state = 144, .external_lex_state = 2},
  [1455] = {.lex_state = 144, .external_lex_state = 2},
  [1456] = {.lex_state = 144, .external_lex_state = 2},
  [1457] = {.lex_state = 144, .external_lex_state = 2},
  [1458] = {.lex_state = 144, .external_lex_state = 2},
  [1459] = {.lex_state = 144, .external_lex_state = 2},
  [1460] = {.lex_state = 144, .external_lex_state = 2},
  [1461] = {.lex_state = 144, .external_lex_state = 2},
  [1462] = {.lex_state = 144, .external_lex_state = 2},
  [1463] = {.lex_state = 144, .external_lex_state = 2},
  [1464] = {.lex_state = 144, .external_lex_state = 2},
  [1465] = {.lex_state = 144, .external_lex_state = 2},
  [1466] = {.lex_state = 144, .external_lex_state = 2},
  [1467] = {.lex_state = 144, .external_lex_state = 2},
  [1468] = {.lex_state = 144, .external_lex_state = 2},
  [1469] = {.lex_state = 144, .external_lex_state = 2},
  [1470] = {.lex_state = 144, .external_lex_state = 2},
  [1471] = {.lex_state = 144, .external_lex_state = 2},
  [1472] = {.lex_state = 144, .external_lex_state = 2},
  [1473] = {.lex_state = 144, .external_lex_state = 2},
  [1474] = {.lex_state = 144, .external_lex_state = 2},
  [1475] = {.lex_state = 144, .external_lex_state = 2},
  [1476] = {.lex_state = 144, .external_lex_state = 2},
  [1477] = {.lex_state = 144, .external_lex_state = 2},
  [1478] = {.lex_state = 144, .external_lex_state = 5},
  [1479] = {.lex_state = 144, .external_lex_state = 2},
  [1480] = {.lex_state = 144, .external_lex_state = 2},
  [1481] = {.lex_state = 144, .external_lex_state = 2},
  [1482] = {.lex_state = 144, .external_lex_state = 2},
  [1483] = {.lex_state = 144, .external_lex_state = 2},
  [1484] = {.lex_state = 144, .external_lex_state = 2},
  [1485] = {.lex_state = 144, .external_lex_state = 5},
  [1486] = {.lex_state = 144, .external_lex_state = 2},
  [1487] = {.lex_state = 144, .external_lex_state = 2},
  [1488] = {.lex_state = 144, .external_lex_state = 2},
  [1489] = {.lex_state = 144, .external_lex_state = 2},
  [1490] = {.lex_state = 144, .external_lex_state = 2},
  [1491] = {.lex_state = 144, .external_lex_state = 5},
  [1492] = {.lex_state = 144, .external_lex_state = 2},
  [1493] = {.lex_state = 144, .external_lex_state = 5},
  [1494] = {.lex_state = 144, .external_lex_state = 2},
  [1495] = {.lex_state = 144, .external_lex_state = 2},
  [1496] = {.lex_state = 144, .external_lex_state = 2},
  [1497] = {.lex_state = 144, .external_lex_state = 2},
  [1498] = {.lex_state = 144, .external_lex_state = 2},
  [1499] = {.lex_state = 144, .external_lex_state = 2},
  [1500] = {.lex_state = 144, .external_lex_state = 2},
  [1501] = {.lex_state = 144, .external_lex_state = 2},
  [1502] = {.lex_state = 144, .external_lex_state = 2},
  [1503] = {.lex_state = 144, .external_lex_state = 2},
  [1504] = {.lex_state = 144, .external_lex_state = 2},
  [1505] = {.lex_state = 144, .external_lex_state = 2},
  [1506] = {.lex_state = 144, .external_lex_state = 2},
  [1507] = {.lex_state = 144, .external_lex_state = 2},
  [1508] = {.lex_state = 144, .external_lex_state = 2},
  [1509] = {.lex_state = 144, .external_lex_state = 2},
  [1510] = {.lex_state = 144, .external_lex_state = 2},
  [1511] = {.lex_state = 144, .external_lex_state = 2},
  [1512] = {.lex_state = 144, .external_lex_state = 2},
  [1513] = {.lex_state = 144, .external_lex_state = 2},
  [1514] = {.lex_state = 144, .external_lex_state = 5},
  [1515] = {.lex_state = 144, .external_lex_state = 5},
  [1516] = {.lex_state = 144, .external_lex_state = 2},
  [1517] = {.lex_state = 144, .external_lex_state = 2},
  [1518] = {.lex_state = 144, .external_lex_state = 2},
  [1519] = {.lex_state = 144, .external_lex_state = 2},
  [1520] = {.lex_state = 144, .external_lex_state = 2},
  [1521] = {.lex_state = 144, .external_lex_state = 2},
  [1522] = {.lex_state = 144, .external_lex_state = 2},
  [1523] = {.lex_state = 6, .external_lex_state = 2},
  [1524] = {.lex_state = 144, .external_lex_state = 2},
  [1525] = {.lex_state = 144, .external_lex_state = 2},
  [1526] = {.lex_state = 144, .external_lex_state = 5},
  [1527] = {.lex_state = 144, .external_lex_state = 2},
  [1528] = {.lex_state = 144, .external_lex_state = 2},
  [1529] = {.lex_state = 144, .external_lex_state = 2},
  [1530] = {.lex_state = 144, .external_lex_state = 2},
  [1531] = {.lex_state = 144, .external_lex_state = 2},
  [1532] = {.lex_state = 144, .external_lex_state = 2},
  [1533] = {.lex_state = 144, .external_lex_state = 2},
  [1534] = {.lex_state = 144, .external_lex_state = 2},
  [1535] = {.lex_state = 144, .external_lex_state = 2},
  [1536] = {.lex_state = 144, .external_lex_state = 2},
  [1537] = {.lex_state = 144, .external_lex_state = 2},
  [1538] = {.lex_state = 144, .external_lex_state = 2},
  [1539] = {.lex_state = 144, .external_lex_state = 2},
  [1540] = {.lex_state = 144, .external_lex_state = 2},
  [1541] = {.lex_state = 144, .external_lex_state = 2},
  [1542] = {.lex_state = 144, .external_lex_state = 2},
  [1543] = {.lex_state = 144, .external_lex_state = 5},
  [1544] = {.lex_state = 144, .external_lex_state = 2},
  [1545] = {.lex_state = 144, .external_lex_state = 5},
  [1546] = {.lex_state = 144, .external_lex_state = 2},
  [1547] = {.lex_state = 144, .external_lex_state = 2},
  [1548] = {.lex_state = 144, .external_lex_state = 2},
  [1549] = {.lex_state = 144, .external_lex_state = 2},
  [1550] = {.lex_state = 144, .external_lex_state = 2},
  [1551] = {.lex_state = 144, .external_lex_state = 2},
  [1552] = {.lex_state = 144, .external_lex_state = 2},
  [1553] = {.lex_state = 144, .external_lex_state = 2},
  [1554] = {.lex_state = 144, .external_lex_state = 5},
  [1555] = {.lex_state = 144, .external_lex_state = 2},
  [1556] = {.lex_state = 144, .external_lex_state = 2},
  [1557] = {.lex_state = 144, .external_lex_state = 2},
  [1558] = {.lex_state = 144, .external_lex_state = 5},
  [1559] = {.lex_state = 144, .external_lex_state = 2},
  [1560] = {.lex_state = 144, .external_lex_state = 2},
  [1561] = {.lex_state = 144, .external_lex_state = 2},
  [1562] = {.lex_state = 144, .external_lex_state = 2},
  [1563] = {.lex_state = 144, .external_lex_state = 2},
  [1564] = {.lex_state = 144, .external_lex_state = 2},
  [1565] = {.lex_state = 144, .external_lex_state = 2},
  [1566] = {.lex_state = 144, .external_lex_state = 2},
  [1567] = {.lex_state = 144, .external_lex_state = 2},
  [1568] = {.lex_state = 144, .external_lex_state = 2},
  [1569] = {.lex_state = 144, .external_lex_state = 2},
  [1570] = {.lex_state = 144, .external_lex_state = 2},
  [1571] = {.lex_state = 144, .external_lex_state = 2},
  [1572] = {.lex_state = 144, .external_lex_state = 2},
  [1573] = {.lex_state = 144, .external_lex_state = 2},
  [1574] = {.lex_state = 144, .external_lex_state = 5},
  [1575] = {.lex_state = 144, .external_lex_state = 2},
  [1576] = {.lex_state = 144, .external_lex_state = 2},
  [1577] = {.lex_state = 144, .external_lex_state = 2},
  [1578] = {.lex_state = 144, .external_lex_state = 2},
  [1579] = {.lex_state = 144, .external_lex_state = 2},
  [1580] = {.lex_state = 144, .external_lex_state = 2},
  [1581] = {.lex_state = 144, .external_lex_state = 5},
  [1582] = {.lex_state = 144, .external_lex_state = 5},
  [1583] = {.lex_state = 144, .external_lex_state = 2},
  [1584] = {.lex_state = 144, .external_lex_state = 2},
  [1585] = {.lex_state = 144, .external_lex_state = 2},
  [1586] = {.lex_state = 144, .external_lex_state = 2},
  [1587] = {.lex_state = 144, .external_lex_state = 2},
  [1588] = {.lex_state = 144, .external_lex_state = 2},
  [1589] = {.lex_state = 144, .external_lex_state = 2},
  [1590] = {.lex_state = 144, .external_lex_state = 2},
  [1591] = {.lex_state = 144, .external_lex_state = 2},
  [1592] = {.lex_state = 144, .external_lex_state = 2},
  [1593] = {.lex_state = 144, .external_lex_state = 2},
  [1594] = {.lex_state = 144, .external_lex_state = 2},
  [1595] = {.lex_state = 144, .external_lex_state = 2},
  [1596] = {.lex_state = 144, .external_lex_state = 2},
  [1597] = {.lex_state = 144, .external_lex_state = 2},
  [1598] = {.lex_state = 144, .external_lex_state = 2},
  [1599] = {.lex_state = 144, .external_lex_state = 2},
  [1600] = {.lex_state = 144, .external_lex_state = 2},
  [1601] = {.lex_state = 144, .external_lex_state = 5},
  [1602] = {.lex_state = 144, .external_lex_state = 2},
  [1603] = {.lex_state = 144, .external_lex_state = 5},
  [1604] = {.lex_state = 144, .external_lex_state = 2},
  [1605] = {.lex_state = 144, .external_lex_state = 5},
  [1606] = {.lex_state = 144, .external_lex_state = 2},
  [1607] = {.lex_state = 144, .external_lex_state = 2},
  [1608] = {.lex_state = 144, .external_lex_state = 2},
  [1609] = {.lex_state = 144, .external_lex_state = 5},
  [1610] = {.lex_state = 144, .external_lex_state = 2},
  [1611] = {.lex_state = 144, .external_lex_state = 2},
  [1612] = {.lex_state = 144, .external_lex_state = 2},
  [1613] = {.lex_state = 144, .external_lex_state = 2},
  [1614] = {.lex_state = 144, .external_lex_state = 2},
  [1615] = {.lex_state = 144, .external_lex_state = 2},
  [1616] = {.lex_state = 144, .external_lex_state = 2},
  [1617] = {.lex_state = 144, .external_lex_state = 2},
  [1618] = {.lex_state = 144, .external_lex_state = 2},
  [1619] = {.lex_state = 13, .external_lex_state = 2},
  [1620] = {.lex_state = 144, .external_lex_state = 2},
  [1621] = {.lex_state = 144, .external_lex_state = 2},
  [1622] = {.lex_state = 144, .external_lex_state = 2},
  [1623] = {.lex_state = 144, .external_lex_state = 2},
  [1624] = {.lex_state = 144, .external_lex_state = 2},
  [1625] = {.lex_state = 144, .external_lex_state = 2},
  [1626] = {.lex_state = 144, .external_lex_state = 2},
  [1627] = {.lex_state = 144, .external_lex_state = 2},
  [1628] = {.lex_state = 144, .external_lex_state = 2},
  [1629] = {.lex_state = 6, .external_lex_state = 2},
  [1630] = {.lex_state = 144, .external_lex_state = 2},
  [1631] = {.lex_state = 144, .external_lex_state = 2},
  [1632] = {.lex_state = 144, .external_lex_state = 2},
  [1633] = {.lex_state = 144, .external_lex_state = 2},
  [1634] = {.lex_state = 144, .external_lex_state = 2},
  [1635] = {.lex_state = 144, .external_lex_state = 2},
  [1636] = {.lex_state = 144, .external_lex_state = 2},
  [1637] = {.lex_state = 144, .external_lex_state = 2},
  [1638] = {.lex_state = 144, .external_lex_state = 2},
  [1639] = {.lex_state = 144, .external_lex_state = 2},
  [1640] = {.lex_state = 144, .external_lex_state = 2},
  [1641] = {.lex_state = 144, .external_lex_state = 2},
  [1642] = {.lex_state = 144, .external_lex_state = 2},
  [1643] = {.lex_state = 144, .external_lex_state = 2},
  [1644] = {.lex_state = 144, .external_lex_state = 2},
  [1645] = {.lex_state = 144, .external_lex_state = 2},
  [1646] = {.lex_state = 144, .external_lex_state = 2},
  [1647] = {.lex_state = 144, .external_lex_state = 2},
  [1648] = {.lex_state = 144, .external_lex_state = 2},
  [1649] = {.lex_state = 144, .external_lex_state = 2},
  [1650] = {.lex_state = 144, .external_lex_state = 2},
  [1651] = {.lex_state = 144, .external_lex_state = 2},
  [1652] = {.lex_state = 144, .external_lex_state = 2},
  [1653] = {.lex_state = 34, .external_lex_state = 2},
  [1654] = {.lex_state = 144, .external_lex_state = 2},
  [1655] = {.lex_state = 34, .external_lex_state = 2},
  [1656] = {.lex_state = 144, .external_lex_state = 2},
  [1657] = {.lex_state = 144, .external_lex_state = 2},
  [1658] = {.lex_state = 144, .external_lex_state = 2},
  [1659] = {.lex_state = 144, .external_lex_state = 2},
  [1660] = {.lex_state = 144, .external_lex_state = 2},
  [1661] = {.lex_state = 144, .external_lex_state = 2},
  [1662] = {.lex_state = 144, .external_lex_state = 2},
  [1663] = {.lex_state = 144, .external_lex_state = 2},
  [1664] = {.lex_state = 144, .external_lex_state = 2},
  [1665] = {.lex_state = 144, .external_lex_state = 2},
  [1666] = {.lex_state = 144, .external_lex_state = 2},
  [1667] = {.lex_state = 144, .external_lex_state = 2},
  [1668] = {.lex_state = 144, .external_lex_state = 2},
  [1669] = {.lex_state = 144, .external_lex_state = 2},
  [1670] = {.lex_state = 144, .external_lex_state = 2},
  [1671] = {.lex_state = 144, .external_lex_state = 2},
  [1672] = {.lex_state = 144, .external_lex_state = 2},
  [1673] = {.lex_state = 144, .external_lex_state = 2},
  [1674] = {.lex_state = 144, .external_lex_state = 2},
  [1675] = {.lex_state = 144, .external_lex_state = 2},
  [1676] = {.lex_state = 144, .external_lex_state = 2},
  [1677] = {.lex_state = 144, .external_lex_state = 2},
  [1678] = {.lex_state = 144, .external_lex_state = 2},
  [1679] = {.lex_state = 34, .external_lex_state = 2},
  [1680] = {.lex_state = 144, .external_lex_state = 2},
  [1681] = {.lex_state = 144, .external_lex_state = 2},
  [1682] = {.lex_state = 144, .external_lex_state = 2},
  [1683] = {.lex_state = 144, .external_lex_state = 2},
  [1684] = {.lex_state = 144, .external_lex_state = 2},
  [1685] = {.lex_state = 144, .external_lex_state = 2},
  [1686] = {.lex_state = 144, .external_lex_state = 2},
  [1687] = {.lex_state = 144, .external_lex_state = 2},
  [1688] = {.lex_state = 144, .external_lex_state = 2},
  [1689] = {.lex_state = 144, .external_lex_state = 2},
  [1690] = {.lex_state = 144, .external_lex_state = 2},
  [1691] = {.lex_state = 144, .external_lex_state = 2},
  [1692] = {.lex_state = 144, .external_lex_state = 2},
  [1693] = {.lex_state = 144, .external_lex_state = 2},
  [1694] = {.lex_state = 144, .external_lex_state = 2},
  [1695] = {.lex_state = 144, .external_lex_state = 2},
  [1696] = {.lex_state = 144, .external_lex_state = 2},
  [1697] = {.lex_state = 144, .external_lex_state = 2},
  [1698] = {.lex_state = 144, .external_lex_state = 2},
  [1699] = {.lex_state = 144, .external_lex_state = 2},
  [1700] = {.lex_state = 144, .external_lex_state = 2},
  [1701] = {.lex_state = 144, .external_lex_state = 2},
  [1702] = {.lex_state = 144, .external_lex_state = 2},
  [1703] = {.lex_state = 144, .external_lex_state = 2},
  [1704] = {.lex_state = 3, .external_lex_state = 9},
  [1705] = {.lex_state = 144, .external_lex_state = 2},
  [1706] = {.lex_state = 3, .external_lex_state = 9},
  [1707] = {.lex_state = 144, .external_lex_state = 2},
  [1708] = {.lex_state = 3, .external_lex_state = 9},
  [1709] = {.lex_state = 144, .external_lex_state = 2},
  [1710] = {.lex_state = 144, .external_lex_state = 2},
  [1711] = {.lex_state = 144, .external_lex_state = 2},
  [1712] = {.lex_state = 144, .external_lex_state = 2},
  [1713] = {.lex_state = 144, .external_lex_state = 2},
  [1714] = {.lex_state = 3, .external_lex_state = 9},
  [1715] = {.lex_state = 144, .external_lex_state = 2},
  [1716] = {.lex_state = 144, .external_lex_state = 2},
  [1717] = {.lex_state = 144, .external_lex_state = 2},
  [1718] = {.lex_state = 144, .external_lex_state = 2},
  [1719] = {.lex_state = 144, .external_lex_state = 2},
  [1720] = {.lex_state = 144, .external_lex_state = 2},
  [1721] = {.lex_state = 144, .external_lex_state = 2},
  [1722] = {.lex_state = 144, .external_lex_state = 2},
  [1723] = {.lex_state = 144, .external_lex_state = 2},
  [1724] = {.lex_state = 144, .external_lex_state = 2},
  [1725] = {.lex_state = 144, .external_lex_state = 2},
  [1726] = {.lex_state = 144, .external_lex_state = 2},
  [1727] = {.lex_state = 144, .external_lex_state = 2},
  [1728] = {.lex_state = 144, .external_lex_state = 2},
  [1729] = {.lex_state = 144, .external_lex_state = 2},
  [1730] = {.lex_state = 144, .external_lex_state = 2},
  [1731] = {.lex_state = 144, .external_lex_state = 2},
  [1732] = {.lex_state = 34, .external_lex_state = 2},
  [1733] = {.lex_state = 144, .external_lex_state = 2},
  [1734] = {.lex_state = 144, .external_lex_state = 2},
  [1735] = {.lex_state = 144, .external_lex_state = 2},
  [1736] = {.lex_state = 144, .external_lex_state = 2},
  [1737] = {.lex_state = 144, .external_lex_state = 2},
  [1738] = {.lex_state = 144, .external_lex_state = 2},
  [1739] = {.lex_state = 144, .external_lex_state = 2},
  [1740] = {.lex_state = 144, .external_lex_state = 2},
  [1741] = {.lex_state = 144, .external_lex_state = 2},
  [1742] = {.lex_state = 144, .external_lex_state = 2},
  [1743] = {.lex_state = 144, .external_lex_state = 2},
  [1744] = {.lex_state = 144, .external_lex_state = 2},
  [1745] = {.lex_state = 144, .external_lex_state = 2},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_hash_bang_line] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_debugger] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_finally] = ACTIONS(1),
    [anon_sym_yield] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [sym_glimmer_opening_tag] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_async] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [sym_optional_chain] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_PIPE_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK_EQ] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_instanceof] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_typeof] = ACTIONS(1),
    [anon_sym_void] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [anon_sym_SLASH2] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_private_property_identifier] = ACTIONS(1),
    [anon_sym_target] = ACTIONS(1),
    [anon_sym_meta] = ACTIONS(1),
    [sym_this] = ACTIONS(1),
    [sym_super] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_undefined] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [aux_sym_method_definition_token1] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [sym__automatic_semicolon] = ACTIONS(1),
    [sym__template_chars] = ACTIONS(1),
    [sym__ternary_qmark] = ACTIONS(1),
    [sym_html_comment] = ACTIONS(5),
    [sym_jsx_text] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1658),
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(14),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(14),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [sym_hash_bang_line] = ACTIONS(11),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [2] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1700),
    [sym_object_assignment_pattern] = STATE(1309),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1700),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1700),
    [sym_spread_element] = STATE(1314),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(747),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [sym_rest_pattern] = STATE(1309),
    [sym_method_definition] = STATE(1314),
    [sym_pair] = STATE(1314),
    [sym_pair_pattern] = STATE(1309),
    [sym__property_name] = STATE(1328),
    [sym_computed_property_name] = STATE(1328),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(915),
    [aux_sym_object_repeat1] = STATE(1354),
    [aux_sym_object_pattern_repeat1] = STATE(1360),
    [sym_identifier] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(103),
    [anon_sym_RBRACE] = ACTIONS(105),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(107),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(111),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(115),
    [sym_private_property_identifier] = ACTIONS(117),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(119),
    [aux_sym_method_definition_token1] = ACTIONS(121),
    [anon_sym_get] = ACTIONS(123),
    [anon_sym_set] = ACTIONS(123),
    [sym_html_comment] = ACTIONS(5),
  },
  [3] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1700),
    [sym_object_assignment_pattern] = STATE(1309),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1700),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1700),
    [sym_spread_element] = STATE(1314),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(747),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [sym_rest_pattern] = STATE(1309),
    [sym_method_definition] = STATE(1314),
    [sym_pair] = STATE(1314),
    [sym_pair_pattern] = STATE(1309),
    [sym__property_name] = STATE(1328),
    [sym_computed_property_name] = STATE(1328),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(915),
    [aux_sym_object_repeat1] = STATE(1354),
    [aux_sym_object_pattern_repeat1] = STATE(1360),
    [sym_identifier] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(103),
    [anon_sym_RBRACE] = ACTIONS(125),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(107),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(111),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(115),
    [sym_private_property_identifier] = ACTIONS(117),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(119),
    [aux_sym_method_definition_token1] = ACTIONS(121),
    [anon_sym_get] = ACTIONS(123),
    [anon_sym_set] = ACTIONS(123),
    [sym_html_comment] = ACTIONS(5),
  },
  [4] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1700),
    [sym_object_assignment_pattern] = STATE(1309),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1700),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1700),
    [sym_spread_element] = STATE(1314),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(747),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [sym_rest_pattern] = STATE(1309),
    [sym_method_definition] = STATE(1314),
    [sym_pair] = STATE(1314),
    [sym_pair_pattern] = STATE(1309),
    [sym__property_name] = STATE(1328),
    [sym_computed_property_name] = STATE(1328),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(915),
    [aux_sym_object_repeat1] = STATE(1354),
    [aux_sym_object_pattern_repeat1] = STATE(1360),
    [sym_identifier] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(99),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(103),
    [anon_sym_RBRACE] = ACTIONS(127),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(107),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(111),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(115),
    [sym_private_property_identifier] = ACTIONS(117),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(119),
    [aux_sym_method_definition_token1] = ACTIONS(121),
    [anon_sym_get] = ACTIONS(123),
    [anon_sym_set] = ACTIONS(123),
    [sym_html_comment] = ACTIONS(5),
  },
  [5] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1700),
    [sym_object_assignment_pattern] = STATE(1309),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1700),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1700),
    [sym_spread_element] = STATE(1368),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(747),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [sym_rest_pattern] = STATE(1309),
    [sym_method_definition] = STATE(1368),
    [sym_pair] = STATE(1368),
    [sym_pair_pattern] = STATE(1309),
    [sym__property_name] = STATE(1328),
    [sym_computed_property_name] = STATE(1328),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(915),
    [aux_sym_object_repeat1] = STATE(1369),
    [aux_sym_object_pattern_repeat1] = STATE(1360),
    [sym_identifier] = ACTIONS(129),
    [anon_sym_export] = ACTIONS(131),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(103),
    [anon_sym_RBRACE] = ACTIONS(133),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(135),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(137),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(115),
    [sym_private_property_identifier] = ACTIONS(117),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(139),
    [aux_sym_method_definition_token1] = ACTIONS(121),
    [anon_sym_get] = ACTIONS(141),
    [anon_sym_set] = ACTIONS(141),
    [sym_html_comment] = ACTIONS(5),
  },
  [6] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1700),
    [sym_object_assignment_pattern] = STATE(1309),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1700),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1700),
    [sym_spread_element] = STATE(1368),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(747),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [sym_rest_pattern] = STATE(1309),
    [sym_method_definition] = STATE(1368),
    [sym_pair] = STATE(1368),
    [sym_pair_pattern] = STATE(1309),
    [sym__property_name] = STATE(1328),
    [sym_computed_property_name] = STATE(1328),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(915),
    [aux_sym_object_repeat1] = STATE(1369),
    [aux_sym_object_pattern_repeat1] = STATE(1360),
    [sym_identifier] = ACTIONS(143),
    [anon_sym_export] = ACTIONS(145),
    [anon_sym_STAR] = ACTIONS(101),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(103),
    [anon_sym_RBRACE] = ACTIONS(133),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(147),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(109),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(149),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(115),
    [sym_private_property_identifier] = ACTIONS(117),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(151),
    [aux_sym_method_definition_token1] = ACTIONS(121),
    [anon_sym_get] = ACTIONS(153),
    [anon_sym_set] = ACTIONS(153),
    [sym_html_comment] = ACTIONS(5),
  },
  [7] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [ts_builtin_sym_end] = ACTIONS(155),
    [sym_identifier] = ACTIONS(157),
    [anon_sym_export] = ACTIONS(160),
    [anon_sym_default] = ACTIONS(163),
    [anon_sym_LBRACE] = ACTIONS(165),
    [anon_sym_RBRACE] = ACTIONS(155),
    [anon_sym_import] = ACTIONS(168),
    [anon_sym_with] = ACTIONS(171),
    [anon_sym_var] = ACTIONS(174),
    [anon_sym_let] = ACTIONS(177),
    [anon_sym_const] = ACTIONS(180),
    [anon_sym_if] = ACTIONS(183),
    [anon_sym_switch] = ACTIONS(186),
    [anon_sym_for] = ACTIONS(189),
    [anon_sym_LPAREN] = ACTIONS(192),
    [anon_sym_SEMI] = ACTIONS(195),
    [anon_sym_await] = ACTIONS(198),
    [anon_sym_while] = ACTIONS(201),
    [anon_sym_do] = ACTIONS(204),
    [anon_sym_try] = ACTIONS(207),
    [anon_sym_break] = ACTIONS(210),
    [anon_sym_continue] = ACTIONS(213),
    [anon_sym_debugger] = ACTIONS(216),
    [anon_sym_return] = ACTIONS(219),
    [anon_sym_throw] = ACTIONS(222),
    [anon_sym_case] = ACTIONS(163),
    [anon_sym_yield] = ACTIONS(225),
    [anon_sym_LBRACK] = ACTIONS(228),
    [sym_glimmer_opening_tag] = ACTIONS(231),
    [anon_sym_LT] = ACTIONS(234),
    [anon_sym_DQUOTE] = ACTIONS(237),
    [anon_sym_SQUOTE] = ACTIONS(240),
    [anon_sym_class] = ACTIONS(243),
    [anon_sym_async] = ACTIONS(246),
    [anon_sym_function] = ACTIONS(249),
    [anon_sym_new] = ACTIONS(252),
    [anon_sym_PLUS] = ACTIONS(255),
    [anon_sym_DASH] = ACTIONS(255),
    [anon_sym_SLASH] = ACTIONS(258),
    [anon_sym_BANG] = ACTIONS(261),
    [anon_sym_TILDE] = ACTIONS(261),
    [anon_sym_typeof] = ACTIONS(255),
    [anon_sym_void] = ACTIONS(255),
    [anon_sym_delete] = ACTIONS(255),
    [anon_sym_PLUS_PLUS] = ACTIONS(264),
    [anon_sym_DASH_DASH] = ACTIONS(264),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(267),
    [sym_number] = ACTIONS(270),
    [sym_private_property_identifier] = ACTIONS(273),
    [sym_this] = ACTIONS(276),
    [sym_super] = ACTIONS(276),
    [sym_true] = ACTIONS(276),
    [sym_false] = ACTIONS(276),
    [sym_null] = ACTIONS(276),
    [sym_undefined] = ACTIONS(279),
    [anon_sym_AT] = ACTIONS(282),
    [anon_sym_static] = ACTIONS(285),
    [anon_sym_get] = ACTIONS(285),
    [anon_sym_set] = ACTIONS(285),
    [sym_html_comment] = ACTIONS(5),
  },
  [8] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(11),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(11),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(288),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(290),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(288),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [9] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(292),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(294),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(292),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [10] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(9),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(9),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(296),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(298),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(296),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [11] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_default] = ACTIONS(300),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(302),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_case] = ACTIONS(300),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [12] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(15),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(15),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [ts_builtin_sym_end] = ACTIONS(304),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [13] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(18),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(18),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(306),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [14] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [ts_builtin_sym_end] = ACTIONS(304),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [15] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [ts_builtin_sym_end] = ACTIONS(308),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [16] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(310),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [17] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(16),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(16),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(312),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [18] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(314),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [19] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(316),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [20] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(19),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(19),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(318),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [21] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(320),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [22] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(21),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(21),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(322),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [23] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(324),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [24] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(23),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(23),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(326),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [25] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(26),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(26),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(328),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [26] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(7),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_program_repeat1] = STATE(7),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(330),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [27] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(417),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [28] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(394),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [29] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(383),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [30] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(360),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [31] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(400),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [32] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(1332),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [33] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(415),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [34] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(417),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [35] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(1736),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [36] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(405),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [37] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(360),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [38] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(376),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [39] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(384),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [40] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(385),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [41] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(393),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [42] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(391),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [43] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(392),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [44] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(393),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [45] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(394),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [46] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(376),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [47] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(405),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [48] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(400),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [49] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(384),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [50] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(385),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [51] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(351),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [52] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(388),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [53] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(383),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [54] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(391),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [55] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(392),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [56] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(415),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1161),
    [sym_identifier] = ACTIONS(9),
    [anon_sym_export] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(23),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(27),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(39),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(69),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(95),
    [anon_sym_get] = ACTIONS(95),
    [anon_sym_set] = ACTIONS(95),
    [sym_html_comment] = ACTIONS(5),
  },
  [57] = {
    [sym_export_statement] = STATE(406),
    [sym_declaration] = STATE(406),
    [sym_import] = STATE(1267),
    [sym_import_statement] = STATE(406),
    [sym_statement] = STATE(388),
    [sym_expression_statement] = STATE(406),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_statement_block] = STATE(406),
    [sym_if_statement] = STATE(406),
    [sym_switch_statement] = STATE(406),
    [sym_for_statement] = STATE(406),
    [sym_for_in_statement] = STATE(406),
    [sym_while_statement] = STATE(406),
    [sym_do_statement] = STATE(406),
    [sym_try_statement] = STATE(406),
    [sym_with_statement] = STATE(406),
    [sym_break_statement] = STATE(406),
    [sym_continue_statement] = STATE(406),
    [sym_debugger_statement] = STATE(406),
    [sym_return_statement] = STATE(406),
    [sym_throw_statement] = STATE(406),
    [sym_empty_statement] = STATE(406),
    [sym_labeled_statement] = STATE(406),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(748),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1582),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1153),
    [sym_identifier] = ACTIONS(332),
    [anon_sym_export] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_import] = ACTIONS(17),
    [anon_sym_with] = ACTIONS(338),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(340),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_if] = ACTIONS(342),
    [anon_sym_switch] = ACTIONS(29),
    [anon_sym_for] = ACTIONS(344),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_while] = ACTIONS(346),
    [anon_sym_do] = ACTIONS(41),
    [anon_sym_try] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_debugger] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_throw] = ACTIONS(53),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(350),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(354),
    [anon_sym_get] = ACTIONS(354),
    [anon_sym_set] = ACTIONS(354),
    [sym_html_comment] = ACTIONS(5),
  },
  [58] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(579),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_STAR] = ACTIONS(360),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_COMMA] = ACTIONS(364),
    [anon_sym_RBRACE] = ACTIONS(364),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(364),
    [anon_sym_RPAREN] = ACTIONS(364),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_in] = ACTIONS(372),
    [anon_sym_COLON] = ACTIONS(364),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [anon_sym_RBRACK] = ACTIONS(364),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_GT] = ACTIONS(372),
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [sym_optional_chain] = ACTIONS(364),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_AMP_AMP] = ACTIONS(364),
    [anon_sym_PIPE_PIPE] = ACTIONS(364),
    [anon_sym_GT_GT] = ACTIONS(372),
    [anon_sym_GT_GT_GT] = ACTIONS(364),
    [anon_sym_LT_LT] = ACTIONS(364),
    [anon_sym_AMP] = ACTIONS(372),
    [anon_sym_CARET] = ACTIONS(364),
    [anon_sym_PIPE] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_PERCENT] = ACTIONS(364),
    [anon_sym_STAR_STAR] = ACTIONS(364),
    [anon_sym_LT_EQ] = ACTIONS(364),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(364),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(364),
    [anon_sym_GT_EQ] = ACTIONS(364),
    [anon_sym_QMARK_QMARK] = ACTIONS(364),
    [anon_sym_instanceof] = ACTIONS(372),
    [anon_sym_BANG] = ACTIONS(394),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym__ternary_qmark] = ACTIONS(364),
    [sym_html_comment] = ACTIONS(5),
  },
  [59] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(743),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_STAR] = ACTIONS(416),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_COMMA] = ACTIONS(364),
    [anon_sym_RBRACE] = ACTIONS(364),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(364),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_in] = ACTIONS(372),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(372),
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [sym_optional_chain] = ACTIONS(364),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_AMP_AMP] = ACTIONS(364),
    [anon_sym_PIPE_PIPE] = ACTIONS(364),
    [anon_sym_GT_GT] = ACTIONS(372),
    [anon_sym_GT_GT_GT] = ACTIONS(364),
    [anon_sym_LT_LT] = ACTIONS(364),
    [anon_sym_AMP] = ACTIONS(372),
    [anon_sym_CARET] = ACTIONS(364),
    [anon_sym_PIPE] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_PERCENT] = ACTIONS(364),
    [anon_sym_STAR_STAR] = ACTIONS(364),
    [anon_sym_LT_EQ] = ACTIONS(364),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(364),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(364),
    [anon_sym_GT_EQ] = ACTIONS(364),
    [anon_sym_QMARK_QMARK] = ACTIONS(364),
    [anon_sym_instanceof] = ACTIONS(372),
    [anon_sym_BANG] = ACTIONS(75),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym__automatic_semicolon] = ACTIONS(364),
    [sym__ternary_qmark] = ACTIONS(364),
    [sym_html_comment] = ACTIONS(5),
  },
  [60] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(484),
    [sym_expression] = STATE(719),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1733),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1733),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(484),
    [sym_subscript_expression] = STATE(484),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1034),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1733),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1734),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(428),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_STAR] = ACTIONS(432),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_COMMA] = ACTIONS(364),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(364),
    [anon_sym_await] = ACTIONS(434),
    [anon_sym_in] = ACTIONS(372),
    [anon_sym_of] = ACTIONS(372),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_GT] = ACTIONS(372),
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(426),
    [sym_optional_chain] = ACTIONS(364),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_AMP_AMP] = ACTIONS(364),
    [anon_sym_PIPE_PIPE] = ACTIONS(364),
    [anon_sym_GT_GT] = ACTIONS(372),
    [anon_sym_GT_GT_GT] = ACTIONS(364),
    [anon_sym_LT_LT] = ACTIONS(364),
    [anon_sym_AMP] = ACTIONS(372),
    [anon_sym_CARET] = ACTIONS(364),
    [anon_sym_PIPE] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_PERCENT] = ACTIONS(364),
    [anon_sym_STAR_STAR] = ACTIONS(364),
    [anon_sym_LT_EQ] = ACTIONS(364),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(364),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(364),
    [anon_sym_GT_EQ] = ACTIONS(364),
    [anon_sym_QMARK_QMARK] = ACTIONS(364),
    [anon_sym_instanceof] = ACTIONS(372),
    [anon_sym_BANG] = ACTIONS(442),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(450),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym__automatic_semicolon] = ACTIONS(364),
    [sym__ternary_qmark] = ACTIONS(364),
    [sym_html_comment] = ACTIONS(5),
  },
  [61] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(504),
    [sym_expression] = STATE(837),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1744),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1744),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(504),
    [sym_subscript_expression] = STATE(504),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1047),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1744),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1725),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(454),
    [anon_sym_export] = ACTIONS(456),
    [anon_sym_STAR] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(462),
    [anon_sym_in] = ACTIONS(372),
    [anon_sym_of] = ACTIONS(372),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_GT] = ACTIONS(372),
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(390),
    [sym_optional_chain] = ACTIONS(364),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_AMP_AMP] = ACTIONS(364),
    [anon_sym_PIPE_PIPE] = ACTIONS(364),
    [anon_sym_GT_GT] = ACTIONS(372),
    [anon_sym_GT_GT_GT] = ACTIONS(364),
    [anon_sym_LT_LT] = ACTIONS(364),
    [anon_sym_AMP] = ACTIONS(372),
    [anon_sym_CARET] = ACTIONS(364),
    [anon_sym_PIPE] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(474),
    [anon_sym_PERCENT] = ACTIONS(364),
    [anon_sym_STAR_STAR] = ACTIONS(364),
    [anon_sym_LT_EQ] = ACTIONS(364),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(364),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(364),
    [anon_sym_GT_EQ] = ACTIONS(364),
    [anon_sym_QMARK_QMARK] = ACTIONS(364),
    [anon_sym_instanceof] = ACTIONS(372),
    [anon_sym_BANG] = ACTIONS(472),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_typeof] = ACTIONS(472),
    [anon_sym_void] = ACTIONS(472),
    [anon_sym_delete] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(480),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_get] = ACTIONS(456),
    [anon_sym_set] = ACTIONS(456),
    [sym__ternary_qmark] = ACTIONS(364),
    [sym_html_comment] = ACTIONS(5),
  },
  [62] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(773),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_STAR] = ACTIONS(488),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_in] = ACTIONS(372),
    [anon_sym_COLON] = ACTIONS(364),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_GT] = ACTIONS(372),
    [anon_sym_DOT] = ACTIONS(372),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [sym_optional_chain] = ACTIONS(364),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_AMP_AMP] = ACTIONS(364),
    [anon_sym_PIPE_PIPE] = ACTIONS(364),
    [anon_sym_GT_GT] = ACTIONS(372),
    [anon_sym_GT_GT_GT] = ACTIONS(364),
    [anon_sym_LT_LT] = ACTIONS(364),
    [anon_sym_AMP] = ACTIONS(372),
    [anon_sym_CARET] = ACTIONS(364),
    [anon_sym_PIPE] = ACTIONS(372),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_PERCENT] = ACTIONS(364),
    [anon_sym_STAR_STAR] = ACTIONS(364),
    [anon_sym_LT_EQ] = ACTIONS(364),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(364),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(364),
    [anon_sym_GT_EQ] = ACTIONS(364),
    [anon_sym_QMARK_QMARK] = ACTIONS(364),
    [anon_sym_instanceof] = ACTIONS(372),
    [anon_sym_BANG] = ACTIONS(498),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym__ternary_qmark] = ACTIONS(364),
    [sym_html_comment] = ACTIONS(5),
  },
  [63] = {
    [ts_builtin_sym_end] = ACTIONS(508),
    [sym_identifier] = ACTIONS(510),
    [anon_sym_export] = ACTIONS(510),
    [anon_sym_STAR] = ACTIONS(512),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_COMMA] = ACTIONS(514),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_import] = ACTIONS(510),
    [anon_sym_with] = ACTIONS(510),
    [anon_sym_var] = ACTIONS(510),
    [anon_sym_let] = ACTIONS(510),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_else] = ACTIONS(510),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_for] = ACTIONS(510),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_await] = ACTIONS(510),
    [anon_sym_in] = ACTIONS(512),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_do] = ACTIONS(510),
    [anon_sym_try] = ACTIONS(510),
    [anon_sym_break] = ACTIONS(510),
    [anon_sym_continue] = ACTIONS(510),
    [anon_sym_debugger] = ACTIONS(510),
    [anon_sym_return] = ACTIONS(510),
    [anon_sym_throw] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(510),
    [anon_sym_yield] = ACTIONS(510),
    [anon_sym_EQ] = ACTIONS(516),
    [anon_sym_LBRACK] = ACTIONS(508),
    [sym_glimmer_opening_tag] = ACTIONS(508),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(512),
    [anon_sym_DOT] = ACTIONS(512),
    [anon_sym_DQUOTE] = ACTIONS(508),
    [anon_sym_SQUOTE] = ACTIONS(508),
    [anon_sym_class] = ACTIONS(510),
    [anon_sym_async] = ACTIONS(510),
    [anon_sym_function] = ACTIONS(510),
    [sym_optional_chain] = ACTIONS(514),
    [anon_sym_new] = ACTIONS(510),
    [anon_sym_AMP_AMP] = ACTIONS(514),
    [anon_sym_PIPE_PIPE] = ACTIONS(514),
    [anon_sym_GT_GT] = ACTIONS(512),
    [anon_sym_GT_GT_GT] = ACTIONS(514),
    [anon_sym_LT_LT] = ACTIONS(514),
    [anon_sym_AMP] = ACTIONS(512),
    [anon_sym_CARET] = ACTIONS(514),
    [anon_sym_PIPE] = ACTIONS(512),
    [anon_sym_PLUS] = ACTIONS(510),
    [anon_sym_DASH] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(510),
    [anon_sym_PERCENT] = ACTIONS(514),
    [anon_sym_STAR_STAR] = ACTIONS(514),
    [anon_sym_LT_EQ] = ACTIONS(514),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(514),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(514),
    [anon_sym_GT_EQ] = ACTIONS(514),
    [anon_sym_QMARK_QMARK] = ACTIONS(514),
    [anon_sym_instanceof] = ACTIONS(512),
    [anon_sym_BANG] = ACTIONS(510),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_typeof] = ACTIONS(510),
    [anon_sym_void] = ACTIONS(510),
    [anon_sym_delete] = ACTIONS(510),
    [anon_sym_PLUS_PLUS] = ACTIONS(508),
    [anon_sym_DASH_DASH] = ACTIONS(508),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(508),
    [sym_number] = ACTIONS(508),
    [sym_private_property_identifier] = ACTIONS(508),
    [sym_this] = ACTIONS(510),
    [sym_super] = ACTIONS(510),
    [sym_true] = ACTIONS(510),
    [sym_false] = ACTIONS(510),
    [sym_null] = ACTIONS(510),
    [sym_undefined] = ACTIONS(510),
    [anon_sym_AT] = ACTIONS(508),
    [anon_sym_static] = ACTIONS(510),
    [anon_sym_get] = ACTIONS(510),
    [anon_sym_set] = ACTIONS(510),
    [sym__automatic_semicolon] = ACTIONS(518),
    [sym__ternary_qmark] = ACTIONS(514),
    [sym_html_comment] = ACTIONS(5),
  },
  [64] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(791),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_spread_element] = STATE(1311),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1310),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(524),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [anon_sym_RBRACK] = ACTIONS(526),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [65] = {
    [ts_builtin_sym_end] = ACTIONS(532),
    [sym_identifier] = ACTIONS(534),
    [anon_sym_export] = ACTIONS(534),
    [anon_sym_STAR] = ACTIONS(536),
    [anon_sym_default] = ACTIONS(534),
    [anon_sym_LBRACE] = ACTIONS(532),
    [anon_sym_COMMA] = ACTIONS(538),
    [anon_sym_RBRACE] = ACTIONS(532),
    [anon_sym_import] = ACTIONS(534),
    [anon_sym_with] = ACTIONS(534),
    [anon_sym_var] = ACTIONS(534),
    [anon_sym_let] = ACTIONS(534),
    [anon_sym_const] = ACTIONS(534),
    [anon_sym_else] = ACTIONS(534),
    [anon_sym_if] = ACTIONS(534),
    [anon_sym_switch] = ACTIONS(534),
    [anon_sym_for] = ACTIONS(534),
    [anon_sym_LPAREN] = ACTIONS(532),
    [anon_sym_SEMI] = ACTIONS(532),
    [anon_sym_await] = ACTIONS(534),
    [anon_sym_in] = ACTIONS(536),
    [anon_sym_while] = ACTIONS(534),
    [anon_sym_do] = ACTIONS(534),
    [anon_sym_try] = ACTIONS(534),
    [anon_sym_break] = ACTIONS(534),
    [anon_sym_continue] = ACTIONS(534),
    [anon_sym_debugger] = ACTIONS(534),
    [anon_sym_return] = ACTIONS(534),
    [anon_sym_throw] = ACTIONS(534),
    [anon_sym_case] = ACTIONS(534),
    [anon_sym_yield] = ACTIONS(534),
    [anon_sym_LBRACK] = ACTIONS(532),
    [sym_glimmer_opening_tag] = ACTIONS(532),
    [anon_sym_LT] = ACTIONS(534),
    [anon_sym_GT] = ACTIONS(536),
    [anon_sym_DOT] = ACTIONS(536),
    [anon_sym_DQUOTE] = ACTIONS(532),
    [anon_sym_SQUOTE] = ACTIONS(532),
    [anon_sym_class] = ACTIONS(534),
    [anon_sym_async] = ACTIONS(534),
    [anon_sym_function] = ACTIONS(534),
    [sym_optional_chain] = ACTIONS(538),
    [anon_sym_new] = ACTIONS(534),
    [anon_sym_AMP_AMP] = ACTIONS(538),
    [anon_sym_PIPE_PIPE] = ACTIONS(538),
    [anon_sym_GT_GT] = ACTIONS(536),
    [anon_sym_GT_GT_GT] = ACTIONS(538),
    [anon_sym_LT_LT] = ACTIONS(538),
    [anon_sym_AMP] = ACTIONS(536),
    [anon_sym_CARET] = ACTIONS(538),
    [anon_sym_PIPE] = ACTIONS(536),
    [anon_sym_PLUS] = ACTIONS(534),
    [anon_sym_DASH] = ACTIONS(534),
    [anon_sym_SLASH] = ACTIONS(534),
    [anon_sym_PERCENT] = ACTIONS(538),
    [anon_sym_STAR_STAR] = ACTIONS(538),
    [anon_sym_LT_EQ] = ACTIONS(538),
    [anon_sym_EQ_EQ] = ACTIONS(536),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(538),
    [anon_sym_BANG_EQ] = ACTIONS(536),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(538),
    [anon_sym_GT_EQ] = ACTIONS(538),
    [anon_sym_QMARK_QMARK] = ACTIONS(538),
    [anon_sym_instanceof] = ACTIONS(536),
    [anon_sym_BANG] = ACTIONS(534),
    [anon_sym_TILDE] = ACTIONS(532),
    [anon_sym_typeof] = ACTIONS(534),
    [anon_sym_void] = ACTIONS(534),
    [anon_sym_delete] = ACTIONS(534),
    [anon_sym_PLUS_PLUS] = ACTIONS(532),
    [anon_sym_DASH_DASH] = ACTIONS(532),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(532),
    [sym_number] = ACTIONS(532),
    [sym_private_property_identifier] = ACTIONS(532),
    [sym_this] = ACTIONS(534),
    [sym_super] = ACTIONS(534),
    [sym_true] = ACTIONS(534),
    [sym_false] = ACTIONS(534),
    [sym_null] = ACTIONS(534),
    [sym_undefined] = ACTIONS(534),
    [anon_sym_AT] = ACTIONS(532),
    [anon_sym_static] = ACTIONS(534),
    [anon_sym_get] = ACTIONS(534),
    [anon_sym_set] = ACTIONS(534),
    [sym__automatic_semicolon] = ACTIONS(540),
    [sym__ternary_qmark] = ACTIONS(538),
    [sym_html_comment] = ACTIONS(5),
  },
  [66] = {
    [ts_builtin_sym_end] = ACTIONS(542),
    [sym_identifier] = ACTIONS(544),
    [anon_sym_export] = ACTIONS(544),
    [anon_sym_STAR] = ACTIONS(546),
    [anon_sym_default] = ACTIONS(544),
    [anon_sym_LBRACE] = ACTIONS(542),
    [anon_sym_COMMA] = ACTIONS(548),
    [anon_sym_RBRACE] = ACTIONS(542),
    [anon_sym_import] = ACTIONS(544),
    [anon_sym_with] = ACTIONS(544),
    [anon_sym_var] = ACTIONS(544),
    [anon_sym_let] = ACTIONS(544),
    [anon_sym_const] = ACTIONS(544),
    [anon_sym_else] = ACTIONS(544),
    [anon_sym_if] = ACTIONS(544),
    [anon_sym_switch] = ACTIONS(544),
    [anon_sym_for] = ACTIONS(544),
    [anon_sym_LPAREN] = ACTIONS(542),
    [anon_sym_SEMI] = ACTIONS(542),
    [anon_sym_await] = ACTIONS(544),
    [anon_sym_in] = ACTIONS(546),
    [anon_sym_while] = ACTIONS(544),
    [anon_sym_do] = ACTIONS(544),
    [anon_sym_try] = ACTIONS(544),
    [anon_sym_break] = ACTIONS(544),
    [anon_sym_continue] = ACTIONS(544),
    [anon_sym_debugger] = ACTIONS(544),
    [anon_sym_return] = ACTIONS(544),
    [anon_sym_throw] = ACTIONS(544),
    [anon_sym_case] = ACTIONS(544),
    [anon_sym_yield] = ACTIONS(544),
    [anon_sym_LBRACK] = ACTIONS(542),
    [sym_glimmer_opening_tag] = ACTIONS(542),
    [anon_sym_LT] = ACTIONS(544),
    [anon_sym_GT] = ACTIONS(546),
    [anon_sym_DOT] = ACTIONS(546),
    [anon_sym_DQUOTE] = ACTIONS(542),
    [anon_sym_SQUOTE] = ACTIONS(542),
    [anon_sym_class] = ACTIONS(544),
    [anon_sym_async] = ACTIONS(544),
    [anon_sym_function] = ACTIONS(544),
    [sym_optional_chain] = ACTIONS(548),
    [anon_sym_new] = ACTIONS(544),
    [anon_sym_AMP_AMP] = ACTIONS(548),
    [anon_sym_PIPE_PIPE] = ACTIONS(548),
    [anon_sym_GT_GT] = ACTIONS(546),
    [anon_sym_GT_GT_GT] = ACTIONS(548),
    [anon_sym_LT_LT] = ACTIONS(548),
    [anon_sym_AMP] = ACTIONS(546),
    [anon_sym_CARET] = ACTIONS(548),
    [anon_sym_PIPE] = ACTIONS(546),
    [anon_sym_PLUS] = ACTIONS(544),
    [anon_sym_DASH] = ACTIONS(544),
    [anon_sym_SLASH] = ACTIONS(544),
    [anon_sym_PERCENT] = ACTIONS(548),
    [anon_sym_STAR_STAR] = ACTIONS(548),
    [anon_sym_LT_EQ] = ACTIONS(548),
    [anon_sym_EQ_EQ] = ACTIONS(546),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(548),
    [anon_sym_BANG_EQ] = ACTIONS(546),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(548),
    [anon_sym_GT_EQ] = ACTIONS(548),
    [anon_sym_QMARK_QMARK] = ACTIONS(548),
    [anon_sym_instanceof] = ACTIONS(546),
    [anon_sym_BANG] = ACTIONS(544),
    [anon_sym_TILDE] = ACTIONS(542),
    [anon_sym_typeof] = ACTIONS(544),
    [anon_sym_void] = ACTIONS(544),
    [anon_sym_delete] = ACTIONS(544),
    [anon_sym_PLUS_PLUS] = ACTIONS(542),
    [anon_sym_DASH_DASH] = ACTIONS(542),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(542),
    [sym_number] = ACTIONS(542),
    [sym_private_property_identifier] = ACTIONS(542),
    [sym_this] = ACTIONS(544),
    [sym_super] = ACTIONS(544),
    [sym_true] = ACTIONS(544),
    [sym_false] = ACTIONS(544),
    [sym_null] = ACTIONS(544),
    [sym_undefined] = ACTIONS(544),
    [anon_sym_AT] = ACTIONS(542),
    [anon_sym_static] = ACTIONS(544),
    [anon_sym_get] = ACTIONS(544),
    [anon_sym_set] = ACTIONS(544),
    [sym__automatic_semicolon] = ACTIONS(550),
    [sym__ternary_qmark] = ACTIONS(548),
    [sym_html_comment] = ACTIONS(5),
  },
  [67] = {
    [ts_builtin_sym_end] = ACTIONS(552),
    [sym_identifier] = ACTIONS(554),
    [anon_sym_export] = ACTIONS(554),
    [anon_sym_STAR] = ACTIONS(556),
    [anon_sym_default] = ACTIONS(554),
    [anon_sym_LBRACE] = ACTIONS(552),
    [anon_sym_COMMA] = ACTIONS(558),
    [anon_sym_RBRACE] = ACTIONS(552),
    [anon_sym_import] = ACTIONS(554),
    [anon_sym_with] = ACTIONS(554),
    [anon_sym_var] = ACTIONS(554),
    [anon_sym_let] = ACTIONS(554),
    [anon_sym_const] = ACTIONS(554),
    [anon_sym_else] = ACTIONS(554),
    [anon_sym_if] = ACTIONS(554),
    [anon_sym_switch] = ACTIONS(554),
    [anon_sym_for] = ACTIONS(554),
    [anon_sym_LPAREN] = ACTIONS(552),
    [anon_sym_SEMI] = ACTIONS(552),
    [anon_sym_await] = ACTIONS(554),
    [anon_sym_in] = ACTIONS(556),
    [anon_sym_while] = ACTIONS(554),
    [anon_sym_do] = ACTIONS(554),
    [anon_sym_try] = ACTIONS(554),
    [anon_sym_break] = ACTIONS(554),
    [anon_sym_continue] = ACTIONS(554),
    [anon_sym_debugger] = ACTIONS(554),
    [anon_sym_return] = ACTIONS(554),
    [anon_sym_throw] = ACTIONS(554),
    [anon_sym_case] = ACTIONS(554),
    [anon_sym_yield] = ACTIONS(554),
    [anon_sym_LBRACK] = ACTIONS(552),
    [sym_glimmer_opening_tag] = ACTIONS(552),
    [anon_sym_LT] = ACTIONS(554),
    [anon_sym_GT] = ACTIONS(556),
    [anon_sym_DOT] = ACTIONS(556),
    [anon_sym_DQUOTE] = ACTIONS(552),
    [anon_sym_SQUOTE] = ACTIONS(552),
    [anon_sym_class] = ACTIONS(554),
    [anon_sym_async] = ACTIONS(554),
    [anon_sym_function] = ACTIONS(554),
    [sym_optional_chain] = ACTIONS(558),
    [anon_sym_new] = ACTIONS(554),
    [anon_sym_AMP_AMP] = ACTIONS(558),
    [anon_sym_PIPE_PIPE] = ACTIONS(558),
    [anon_sym_GT_GT] = ACTIONS(556),
    [anon_sym_GT_GT_GT] = ACTIONS(558),
    [anon_sym_LT_LT] = ACTIONS(558),
    [anon_sym_AMP] = ACTIONS(556),
    [anon_sym_CARET] = ACTIONS(558),
    [anon_sym_PIPE] = ACTIONS(556),
    [anon_sym_PLUS] = ACTIONS(554),
    [anon_sym_DASH] = ACTIONS(554),
    [anon_sym_SLASH] = ACTIONS(554),
    [anon_sym_PERCENT] = ACTIONS(558),
    [anon_sym_STAR_STAR] = ACTIONS(558),
    [anon_sym_LT_EQ] = ACTIONS(558),
    [anon_sym_EQ_EQ] = ACTIONS(556),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(558),
    [anon_sym_BANG_EQ] = ACTIONS(556),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(558),
    [anon_sym_GT_EQ] = ACTIONS(558),
    [anon_sym_QMARK_QMARK] = ACTIONS(558),
    [anon_sym_instanceof] = ACTIONS(556),
    [anon_sym_BANG] = ACTIONS(554),
    [anon_sym_TILDE] = ACTIONS(552),
    [anon_sym_typeof] = ACTIONS(554),
    [anon_sym_void] = ACTIONS(554),
    [anon_sym_delete] = ACTIONS(554),
    [anon_sym_PLUS_PLUS] = ACTIONS(552),
    [anon_sym_DASH_DASH] = ACTIONS(552),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(552),
    [sym_number] = ACTIONS(552),
    [sym_private_property_identifier] = ACTIONS(552),
    [sym_this] = ACTIONS(554),
    [sym_super] = ACTIONS(554),
    [sym_true] = ACTIONS(554),
    [sym_false] = ACTIONS(554),
    [sym_null] = ACTIONS(554),
    [sym_undefined] = ACTIONS(554),
    [anon_sym_AT] = ACTIONS(552),
    [anon_sym_static] = ACTIONS(554),
    [anon_sym_get] = ACTIONS(554),
    [anon_sym_set] = ACTIONS(554),
    [sym__automatic_semicolon] = ACTIONS(560),
    [sym__ternary_qmark] = ACTIONS(558),
    [sym_html_comment] = ACTIONS(5),
  },
  [68] = {
    [ts_builtin_sym_end] = ACTIONS(562),
    [sym_identifier] = ACTIONS(564),
    [anon_sym_export] = ACTIONS(564),
    [anon_sym_STAR] = ACTIONS(564),
    [anon_sym_default] = ACTIONS(564),
    [anon_sym_LBRACE] = ACTIONS(562),
    [anon_sym_COMMA] = ACTIONS(562),
    [anon_sym_RBRACE] = ACTIONS(562),
    [anon_sym_import] = ACTIONS(564),
    [anon_sym_with] = ACTIONS(564),
    [anon_sym_var] = ACTIONS(564),
    [anon_sym_let] = ACTIONS(564),
    [anon_sym_const] = ACTIONS(564),
    [anon_sym_else] = ACTIONS(564),
    [anon_sym_if] = ACTIONS(564),
    [anon_sym_switch] = ACTIONS(564),
    [anon_sym_for] = ACTIONS(564),
    [anon_sym_LPAREN] = ACTIONS(562),
    [anon_sym_SEMI] = ACTIONS(562),
    [anon_sym_await] = ACTIONS(564),
    [anon_sym_in] = ACTIONS(564),
    [anon_sym_while] = ACTIONS(564),
    [anon_sym_do] = ACTIONS(564),
    [anon_sym_try] = ACTIONS(564),
    [anon_sym_break] = ACTIONS(564),
    [anon_sym_continue] = ACTIONS(564),
    [anon_sym_debugger] = ACTIONS(564),
    [anon_sym_return] = ACTIONS(564),
    [anon_sym_throw] = ACTIONS(564),
    [anon_sym_case] = ACTIONS(564),
    [anon_sym_yield] = ACTIONS(564),
    [anon_sym_LBRACK] = ACTIONS(562),
    [sym_glimmer_opening_tag] = ACTIONS(562),
    [anon_sym_LT] = ACTIONS(564),
    [anon_sym_GT] = ACTIONS(564),
    [anon_sym_DOT] = ACTIONS(564),
    [anon_sym_DQUOTE] = ACTIONS(562),
    [anon_sym_SQUOTE] = ACTIONS(562),
    [anon_sym_class] = ACTIONS(564),
    [anon_sym_async] = ACTIONS(564),
    [anon_sym_function] = ACTIONS(564),
    [sym_optional_chain] = ACTIONS(562),
    [anon_sym_new] = ACTIONS(564),
    [anon_sym_AMP_AMP] = ACTIONS(562),
    [anon_sym_PIPE_PIPE] = ACTIONS(562),
    [anon_sym_GT_GT] = ACTIONS(564),
    [anon_sym_GT_GT_GT] = ACTIONS(562),
    [anon_sym_LT_LT] = ACTIONS(562),
    [anon_sym_AMP] = ACTIONS(564),
    [anon_sym_CARET] = ACTIONS(562),
    [anon_sym_PIPE] = ACTIONS(564),
    [anon_sym_PLUS] = ACTIONS(564),
    [anon_sym_DASH] = ACTIONS(564),
    [anon_sym_SLASH] = ACTIONS(564),
    [anon_sym_PERCENT] = ACTIONS(562),
    [anon_sym_STAR_STAR] = ACTIONS(562),
    [anon_sym_LT_EQ] = ACTIONS(562),
    [anon_sym_EQ_EQ] = ACTIONS(564),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(562),
    [anon_sym_BANG_EQ] = ACTIONS(564),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(562),
    [anon_sym_GT_EQ] = ACTIONS(562),
    [anon_sym_QMARK_QMARK] = ACTIONS(562),
    [anon_sym_instanceof] = ACTIONS(564),
    [anon_sym_BANG] = ACTIONS(564),
    [anon_sym_TILDE] = ACTIONS(562),
    [anon_sym_typeof] = ACTIONS(564),
    [anon_sym_void] = ACTIONS(564),
    [anon_sym_delete] = ACTIONS(564),
    [anon_sym_PLUS_PLUS] = ACTIONS(562),
    [anon_sym_DASH_DASH] = ACTIONS(562),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(562),
    [sym_number] = ACTIONS(562),
    [sym_private_property_identifier] = ACTIONS(562),
    [sym_this] = ACTIONS(564),
    [sym_super] = ACTIONS(564),
    [sym_true] = ACTIONS(564),
    [sym_false] = ACTIONS(564),
    [sym_null] = ACTIONS(564),
    [sym_undefined] = ACTIONS(564),
    [anon_sym_AT] = ACTIONS(562),
    [anon_sym_static] = ACTIONS(564),
    [anon_sym_get] = ACTIONS(564),
    [anon_sym_set] = ACTIONS(564),
    [sym__automatic_semicolon] = ACTIONS(562),
    [sym__ternary_qmark] = ACTIONS(562),
    [sym_html_comment] = ACTIONS(5),
  },
  [69] = {
    [ts_builtin_sym_end] = ACTIONS(566),
    [sym_identifier] = ACTIONS(568),
    [anon_sym_export] = ACTIONS(568),
    [anon_sym_STAR] = ACTIONS(568),
    [anon_sym_default] = ACTIONS(568),
    [anon_sym_LBRACE] = ACTIONS(566),
    [anon_sym_COMMA] = ACTIONS(566),
    [anon_sym_RBRACE] = ACTIONS(566),
    [anon_sym_import] = ACTIONS(568),
    [anon_sym_with] = ACTIONS(568),
    [anon_sym_var] = ACTIONS(568),
    [anon_sym_let] = ACTIONS(568),
    [anon_sym_const] = ACTIONS(568),
    [anon_sym_else] = ACTIONS(568),
    [anon_sym_if] = ACTIONS(568),
    [anon_sym_switch] = ACTIONS(568),
    [anon_sym_for] = ACTIONS(568),
    [anon_sym_LPAREN] = ACTIONS(566),
    [anon_sym_SEMI] = ACTIONS(566),
    [anon_sym_await] = ACTIONS(568),
    [anon_sym_in] = ACTIONS(568),
    [anon_sym_while] = ACTIONS(568),
    [anon_sym_do] = ACTIONS(568),
    [anon_sym_try] = ACTIONS(568),
    [anon_sym_break] = ACTIONS(568),
    [anon_sym_continue] = ACTIONS(568),
    [anon_sym_debugger] = ACTIONS(568),
    [anon_sym_return] = ACTIONS(568),
    [anon_sym_throw] = ACTIONS(568),
    [anon_sym_case] = ACTIONS(568),
    [anon_sym_yield] = ACTIONS(568),
    [anon_sym_LBRACK] = ACTIONS(566),
    [sym_glimmer_opening_tag] = ACTIONS(566),
    [anon_sym_LT] = ACTIONS(568),
    [anon_sym_GT] = ACTIONS(568),
    [anon_sym_DOT] = ACTIONS(568),
    [anon_sym_DQUOTE] = ACTIONS(566),
    [anon_sym_SQUOTE] = ACTIONS(566),
    [anon_sym_class] = ACTIONS(568),
    [anon_sym_async] = ACTIONS(568),
    [anon_sym_function] = ACTIONS(568),
    [sym_optional_chain] = ACTIONS(566),
    [anon_sym_new] = ACTIONS(568),
    [anon_sym_AMP_AMP] = ACTIONS(566),
    [anon_sym_PIPE_PIPE] = ACTIONS(566),
    [anon_sym_GT_GT] = ACTIONS(568),
    [anon_sym_GT_GT_GT] = ACTIONS(566),
    [anon_sym_LT_LT] = ACTIONS(566),
    [anon_sym_AMP] = ACTIONS(568),
    [anon_sym_CARET] = ACTIONS(566),
    [anon_sym_PIPE] = ACTIONS(568),
    [anon_sym_PLUS] = ACTIONS(568),
    [anon_sym_DASH] = ACTIONS(568),
    [anon_sym_SLASH] = ACTIONS(568),
    [anon_sym_PERCENT] = ACTIONS(566),
    [anon_sym_STAR_STAR] = ACTIONS(566),
    [anon_sym_LT_EQ] = ACTIONS(566),
    [anon_sym_EQ_EQ] = ACTIONS(568),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(566),
    [anon_sym_BANG_EQ] = ACTIONS(568),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(566),
    [anon_sym_GT_EQ] = ACTIONS(566),
    [anon_sym_QMARK_QMARK] = ACTIONS(566),
    [anon_sym_instanceof] = ACTIONS(568),
    [anon_sym_BANG] = ACTIONS(568),
    [anon_sym_TILDE] = ACTIONS(566),
    [anon_sym_typeof] = ACTIONS(568),
    [anon_sym_void] = ACTIONS(568),
    [anon_sym_delete] = ACTIONS(568),
    [anon_sym_PLUS_PLUS] = ACTIONS(566),
    [anon_sym_DASH_DASH] = ACTIONS(566),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(566),
    [sym_number] = ACTIONS(566),
    [sym_private_property_identifier] = ACTIONS(566),
    [sym_this] = ACTIONS(568),
    [sym_super] = ACTIONS(568),
    [sym_true] = ACTIONS(568),
    [sym_false] = ACTIONS(568),
    [sym_null] = ACTIONS(568),
    [sym_undefined] = ACTIONS(568),
    [anon_sym_AT] = ACTIONS(566),
    [anon_sym_static] = ACTIONS(568),
    [anon_sym_get] = ACTIONS(568),
    [anon_sym_set] = ACTIONS(568),
    [sym__automatic_semicolon] = ACTIONS(566),
    [sym__ternary_qmark] = ACTIONS(566),
    [sym_html_comment] = ACTIONS(5),
  },
  [70] = {
    [ts_builtin_sym_end] = ACTIONS(570),
    [sym_identifier] = ACTIONS(572),
    [anon_sym_export] = ACTIONS(572),
    [anon_sym_STAR] = ACTIONS(572),
    [anon_sym_default] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_RBRACE] = ACTIONS(570),
    [anon_sym_import] = ACTIONS(572),
    [anon_sym_with] = ACTIONS(572),
    [anon_sym_var] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(572),
    [anon_sym_const] = ACTIONS(572),
    [anon_sym_else] = ACTIONS(572),
    [anon_sym_if] = ACTIONS(572),
    [anon_sym_switch] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(570),
    [anon_sym_await] = ACTIONS(572),
    [anon_sym_in] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(572),
    [anon_sym_do] = ACTIONS(572),
    [anon_sym_try] = ACTIONS(572),
    [anon_sym_break] = ACTIONS(572),
    [anon_sym_continue] = ACTIONS(572),
    [anon_sym_debugger] = ACTIONS(572),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_throw] = ACTIONS(572),
    [anon_sym_case] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(572),
    [anon_sym_LBRACK] = ACTIONS(570),
    [sym_glimmer_opening_tag] = ACTIONS(570),
    [anon_sym_LT] = ACTIONS(572),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_DOT] = ACTIONS(572),
    [anon_sym_DQUOTE] = ACTIONS(570),
    [anon_sym_SQUOTE] = ACTIONS(570),
    [anon_sym_class] = ACTIONS(572),
    [anon_sym_async] = ACTIONS(572),
    [anon_sym_function] = ACTIONS(572),
    [sym_optional_chain] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_AMP_AMP] = ACTIONS(570),
    [anon_sym_PIPE_PIPE] = ACTIONS(570),
    [anon_sym_GT_GT] = ACTIONS(572),
    [anon_sym_GT_GT_GT] = ACTIONS(570),
    [anon_sym_LT_LT] = ACTIONS(570),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(570),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(572),
    [anon_sym_DASH] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(572),
    [anon_sym_PERCENT] = ACTIONS(570),
    [anon_sym_STAR_STAR] = ACTIONS(570),
    [anon_sym_LT_EQ] = ACTIONS(570),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(570),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(570),
    [anon_sym_GT_EQ] = ACTIONS(570),
    [anon_sym_QMARK_QMARK] = ACTIONS(570),
    [anon_sym_instanceof] = ACTIONS(572),
    [anon_sym_BANG] = ACTIONS(572),
    [anon_sym_TILDE] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_void] = ACTIONS(572),
    [anon_sym_delete] = ACTIONS(572),
    [anon_sym_PLUS_PLUS] = ACTIONS(570),
    [anon_sym_DASH_DASH] = ACTIONS(570),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(570),
    [sym_number] = ACTIONS(570),
    [sym_private_property_identifier] = ACTIONS(570),
    [sym_this] = ACTIONS(572),
    [sym_super] = ACTIONS(572),
    [sym_true] = ACTIONS(572),
    [sym_false] = ACTIONS(572),
    [sym_null] = ACTIONS(572),
    [sym_undefined] = ACTIONS(572),
    [anon_sym_AT] = ACTIONS(570),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [sym__automatic_semicolon] = ACTIONS(574),
    [sym__ternary_qmark] = ACTIONS(570),
    [sym_html_comment] = ACTIONS(5),
  },
  [71] = {
    [ts_builtin_sym_end] = ACTIONS(570),
    [sym_identifier] = ACTIONS(572),
    [anon_sym_export] = ACTIONS(572),
    [anon_sym_STAR] = ACTIONS(572),
    [anon_sym_default] = ACTIONS(572),
    [anon_sym_LBRACE] = ACTIONS(570),
    [anon_sym_COMMA] = ACTIONS(570),
    [anon_sym_RBRACE] = ACTIONS(570),
    [anon_sym_import] = ACTIONS(572),
    [anon_sym_with] = ACTIONS(572),
    [anon_sym_var] = ACTIONS(572),
    [anon_sym_let] = ACTIONS(572),
    [anon_sym_const] = ACTIONS(572),
    [anon_sym_else] = ACTIONS(572),
    [anon_sym_if] = ACTIONS(572),
    [anon_sym_switch] = ACTIONS(572),
    [anon_sym_for] = ACTIONS(572),
    [anon_sym_LPAREN] = ACTIONS(570),
    [anon_sym_SEMI] = ACTIONS(570),
    [anon_sym_await] = ACTIONS(572),
    [anon_sym_in] = ACTIONS(572),
    [anon_sym_while] = ACTIONS(572),
    [anon_sym_do] = ACTIONS(572),
    [anon_sym_try] = ACTIONS(572),
    [anon_sym_break] = ACTIONS(572),
    [anon_sym_continue] = ACTIONS(572),
    [anon_sym_debugger] = ACTIONS(572),
    [anon_sym_return] = ACTIONS(572),
    [anon_sym_throw] = ACTIONS(572),
    [anon_sym_case] = ACTIONS(572),
    [anon_sym_yield] = ACTIONS(572),
    [anon_sym_LBRACK] = ACTIONS(570),
    [sym_glimmer_opening_tag] = ACTIONS(570),
    [anon_sym_LT] = ACTIONS(572),
    [anon_sym_GT] = ACTIONS(572),
    [anon_sym_DOT] = ACTIONS(572),
    [anon_sym_DQUOTE] = ACTIONS(570),
    [anon_sym_SQUOTE] = ACTIONS(570),
    [anon_sym_class] = ACTIONS(572),
    [anon_sym_async] = ACTIONS(572),
    [anon_sym_function] = ACTIONS(572),
    [sym_optional_chain] = ACTIONS(570),
    [anon_sym_new] = ACTIONS(572),
    [anon_sym_AMP_AMP] = ACTIONS(570),
    [anon_sym_PIPE_PIPE] = ACTIONS(570),
    [anon_sym_GT_GT] = ACTIONS(572),
    [anon_sym_GT_GT_GT] = ACTIONS(570),
    [anon_sym_LT_LT] = ACTIONS(570),
    [anon_sym_AMP] = ACTIONS(572),
    [anon_sym_CARET] = ACTIONS(570),
    [anon_sym_PIPE] = ACTIONS(572),
    [anon_sym_PLUS] = ACTIONS(572),
    [anon_sym_DASH] = ACTIONS(572),
    [anon_sym_SLASH] = ACTIONS(572),
    [anon_sym_PERCENT] = ACTIONS(570),
    [anon_sym_STAR_STAR] = ACTIONS(570),
    [anon_sym_LT_EQ] = ACTIONS(570),
    [anon_sym_EQ_EQ] = ACTIONS(572),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(570),
    [anon_sym_BANG_EQ] = ACTIONS(572),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(570),
    [anon_sym_GT_EQ] = ACTIONS(570),
    [anon_sym_QMARK_QMARK] = ACTIONS(570),
    [anon_sym_instanceof] = ACTIONS(572),
    [anon_sym_BANG] = ACTIONS(572),
    [anon_sym_TILDE] = ACTIONS(570),
    [anon_sym_typeof] = ACTIONS(572),
    [anon_sym_void] = ACTIONS(572),
    [anon_sym_delete] = ACTIONS(572),
    [anon_sym_PLUS_PLUS] = ACTIONS(570),
    [anon_sym_DASH_DASH] = ACTIONS(570),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(570),
    [sym_number] = ACTIONS(570),
    [sym_private_property_identifier] = ACTIONS(570),
    [sym_this] = ACTIONS(572),
    [sym_super] = ACTIONS(572),
    [sym_true] = ACTIONS(572),
    [sym_false] = ACTIONS(572),
    [sym_null] = ACTIONS(572),
    [sym_undefined] = ACTIONS(572),
    [anon_sym_AT] = ACTIONS(570),
    [anon_sym_static] = ACTIONS(572),
    [anon_sym_get] = ACTIONS(572),
    [anon_sym_set] = ACTIONS(572),
    [sym__automatic_semicolon] = ACTIONS(570),
    [sym__ternary_qmark] = ACTIONS(570),
    [sym_html_comment] = ACTIONS(5),
  },
  [72] = {
    [ts_builtin_sym_end] = ACTIONS(508),
    [sym_identifier] = ACTIONS(510),
    [anon_sym_export] = ACTIONS(510),
    [anon_sym_STAR] = ACTIONS(510),
    [anon_sym_default] = ACTIONS(510),
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_COMMA] = ACTIONS(508),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_import] = ACTIONS(510),
    [anon_sym_with] = ACTIONS(510),
    [anon_sym_var] = ACTIONS(510),
    [anon_sym_let] = ACTIONS(510),
    [anon_sym_const] = ACTIONS(510),
    [anon_sym_else] = ACTIONS(510),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_switch] = ACTIONS(510),
    [anon_sym_for] = ACTIONS(510),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym_SEMI] = ACTIONS(508),
    [anon_sym_await] = ACTIONS(510),
    [anon_sym_in] = ACTIONS(510),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_do] = ACTIONS(510),
    [anon_sym_try] = ACTIONS(510),
    [anon_sym_break] = ACTIONS(510),
    [anon_sym_continue] = ACTIONS(510),
    [anon_sym_debugger] = ACTIONS(510),
    [anon_sym_return] = ACTIONS(510),
    [anon_sym_throw] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(510),
    [anon_sym_yield] = ACTIONS(510),
    [anon_sym_LBRACK] = ACTIONS(508),
    [sym_glimmer_opening_tag] = ACTIONS(508),
    [anon_sym_LT] = ACTIONS(510),
    [anon_sym_GT] = ACTIONS(510),
    [anon_sym_DOT] = ACTIONS(510),
    [anon_sym_DQUOTE] = ACTIONS(508),
    [anon_sym_SQUOTE] = ACTIONS(508),
    [anon_sym_class] = ACTIONS(510),
    [anon_sym_async] = ACTIONS(510),
    [anon_sym_function] = ACTIONS(510),
    [sym_optional_chain] = ACTIONS(508),
    [anon_sym_new] = ACTIONS(510),
    [anon_sym_AMP_AMP] = ACTIONS(508),
    [anon_sym_PIPE_PIPE] = ACTIONS(508),
    [anon_sym_GT_GT] = ACTIONS(510),
    [anon_sym_GT_GT_GT] = ACTIONS(508),
    [anon_sym_LT_LT] = ACTIONS(508),
    [anon_sym_AMP] = ACTIONS(510),
    [anon_sym_CARET] = ACTIONS(508),
    [anon_sym_PIPE] = ACTIONS(510),
    [anon_sym_PLUS] = ACTIONS(510),
    [anon_sym_DASH] = ACTIONS(510),
    [anon_sym_SLASH] = ACTIONS(510),
    [anon_sym_PERCENT] = ACTIONS(508),
    [anon_sym_STAR_STAR] = ACTIONS(508),
    [anon_sym_LT_EQ] = ACTIONS(508),
    [anon_sym_EQ_EQ] = ACTIONS(510),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(508),
    [anon_sym_BANG_EQ] = ACTIONS(510),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(508),
    [anon_sym_GT_EQ] = ACTIONS(508),
    [anon_sym_QMARK_QMARK] = ACTIONS(508),
    [anon_sym_instanceof] = ACTIONS(510),
    [anon_sym_BANG] = ACTIONS(510),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_typeof] = ACTIONS(510),
    [anon_sym_void] = ACTIONS(510),
    [anon_sym_delete] = ACTIONS(510),
    [anon_sym_PLUS_PLUS] = ACTIONS(508),
    [anon_sym_DASH_DASH] = ACTIONS(508),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(508),
    [sym_number] = ACTIONS(508),
    [sym_private_property_identifier] = ACTIONS(508),
    [sym_this] = ACTIONS(510),
    [sym_super] = ACTIONS(510),
    [sym_true] = ACTIONS(510),
    [sym_false] = ACTIONS(510),
    [sym_null] = ACTIONS(510),
    [sym_undefined] = ACTIONS(510),
    [anon_sym_AT] = ACTIONS(508),
    [anon_sym_static] = ACTIONS(510),
    [anon_sym_get] = ACTIONS(510),
    [anon_sym_set] = ACTIONS(510),
    [sym__automatic_semicolon] = ACTIONS(576),
    [sym__ternary_qmark] = ACTIONS(508),
    [sym_html_comment] = ACTIONS(5),
  },
  [73] = {
    [ts_builtin_sym_end] = ACTIONS(578),
    [sym_identifier] = ACTIONS(580),
    [anon_sym_export] = ACTIONS(580),
    [anon_sym_STAR] = ACTIONS(580),
    [anon_sym_default] = ACTIONS(580),
    [anon_sym_LBRACE] = ACTIONS(578),
    [anon_sym_COMMA] = ACTIONS(578),
    [anon_sym_RBRACE] = ACTIONS(578),
    [anon_sym_import] = ACTIONS(580),
    [anon_sym_with] = ACTIONS(580),
    [anon_sym_var] = ACTIONS(580),
    [anon_sym_let] = ACTIONS(580),
    [anon_sym_const] = ACTIONS(580),
    [anon_sym_else] = ACTIONS(580),
    [anon_sym_if] = ACTIONS(580),
    [anon_sym_switch] = ACTIONS(580),
    [anon_sym_for] = ACTIONS(580),
    [anon_sym_LPAREN] = ACTIONS(578),
    [anon_sym_SEMI] = ACTIONS(578),
    [anon_sym_await] = ACTIONS(580),
    [anon_sym_in] = ACTIONS(580),
    [anon_sym_while] = ACTIONS(580),
    [anon_sym_do] = ACTIONS(580),
    [anon_sym_try] = ACTIONS(580),
    [anon_sym_break] = ACTIONS(580),
    [anon_sym_continue] = ACTIONS(580),
    [anon_sym_debugger] = ACTIONS(580),
    [anon_sym_return] = ACTIONS(580),
    [anon_sym_throw] = ACTIONS(580),
    [anon_sym_case] = ACTIONS(580),
    [anon_sym_yield] = ACTIONS(580),
    [anon_sym_LBRACK] = ACTIONS(578),
    [sym_glimmer_opening_tag] = ACTIONS(578),
    [anon_sym_LT] = ACTIONS(580),
    [anon_sym_GT] = ACTIONS(580),
    [anon_sym_DOT] = ACTIONS(580),
    [anon_sym_DQUOTE] = ACTIONS(578),
    [anon_sym_SQUOTE] = ACTIONS(578),
    [anon_sym_class] = ACTIONS(580),
    [anon_sym_async] = ACTIONS(580),
    [anon_sym_function] = ACTIONS(580),
    [sym_optional_chain] = ACTIONS(578),
    [anon_sym_new] = ACTIONS(580),
    [anon_sym_AMP_AMP] = ACTIONS(578),
    [anon_sym_PIPE_PIPE] = ACTIONS(578),
    [anon_sym_GT_GT] = ACTIONS(580),
    [anon_sym_GT_GT_GT] = ACTIONS(578),
    [anon_sym_LT_LT] = ACTIONS(578),
    [anon_sym_AMP] = ACTIONS(580),
    [anon_sym_CARET] = ACTIONS(578),
    [anon_sym_PIPE] = ACTIONS(580),
    [anon_sym_PLUS] = ACTIONS(580),
    [anon_sym_DASH] = ACTIONS(580),
    [anon_sym_SLASH] = ACTIONS(580),
    [anon_sym_PERCENT] = ACTIONS(578),
    [anon_sym_STAR_STAR] = ACTIONS(578),
    [anon_sym_LT_EQ] = ACTIONS(578),
    [anon_sym_EQ_EQ] = ACTIONS(580),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(578),
    [anon_sym_BANG_EQ] = ACTIONS(580),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(578),
    [anon_sym_GT_EQ] = ACTIONS(578),
    [anon_sym_QMARK_QMARK] = ACTIONS(578),
    [anon_sym_instanceof] = ACTIONS(580),
    [anon_sym_BANG] = ACTIONS(580),
    [anon_sym_TILDE] = ACTIONS(578),
    [anon_sym_typeof] = ACTIONS(580),
    [anon_sym_void] = ACTIONS(580),
    [anon_sym_delete] = ACTIONS(580),
    [anon_sym_PLUS_PLUS] = ACTIONS(578),
    [anon_sym_DASH_DASH] = ACTIONS(578),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(578),
    [sym_number] = ACTIONS(578),
    [sym_private_property_identifier] = ACTIONS(578),
    [sym_this] = ACTIONS(580),
    [sym_super] = ACTIONS(580),
    [sym_true] = ACTIONS(580),
    [sym_false] = ACTIONS(580),
    [sym_null] = ACTIONS(580),
    [sym_undefined] = ACTIONS(580),
    [anon_sym_AT] = ACTIONS(578),
    [anon_sym_static] = ACTIONS(580),
    [anon_sym_get] = ACTIONS(580),
    [anon_sym_set] = ACTIONS(580),
    [sym__automatic_semicolon] = ACTIONS(578),
    [sym__ternary_qmark] = ACTIONS(578),
    [sym_html_comment] = ACTIONS(5),
  },
  [74] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(790),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_spread_element] = STATE(1382),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1384),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(524),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [anon_sym_RBRACK] = ACTIONS(582),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [75] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(783),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_spread_element] = STATE(1311),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1310),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(524),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [anon_sym_RBRACK] = ACTIONS(526),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [76] = {
    [ts_builtin_sym_end] = ACTIONS(584),
    [sym_identifier] = ACTIONS(586),
    [anon_sym_export] = ACTIONS(586),
    [anon_sym_STAR] = ACTIONS(588),
    [anon_sym_default] = ACTIONS(586),
    [anon_sym_LBRACE] = ACTIONS(584),
    [anon_sym_COMMA] = ACTIONS(590),
    [anon_sym_RBRACE] = ACTIONS(584),
    [anon_sym_import] = ACTIONS(586),
    [anon_sym_with] = ACTIONS(586),
    [anon_sym_var] = ACTIONS(586),
    [anon_sym_let] = ACTIONS(586),
    [anon_sym_const] = ACTIONS(586),
    [anon_sym_else] = ACTIONS(586),
    [anon_sym_if] = ACTIONS(586),
    [anon_sym_switch] = ACTIONS(586),
    [anon_sym_for] = ACTIONS(586),
    [anon_sym_LPAREN] = ACTIONS(584),
    [anon_sym_SEMI] = ACTIONS(584),
    [anon_sym_await] = ACTIONS(586),
    [anon_sym_in] = ACTIONS(588),
    [anon_sym_while] = ACTIONS(586),
    [anon_sym_do] = ACTIONS(586),
    [anon_sym_try] = ACTIONS(586),
    [anon_sym_break] = ACTIONS(586),
    [anon_sym_continue] = ACTIONS(586),
    [anon_sym_debugger] = ACTIONS(586),
    [anon_sym_return] = ACTIONS(586),
    [anon_sym_throw] = ACTIONS(586),
    [anon_sym_case] = ACTIONS(586),
    [anon_sym_yield] = ACTIONS(586),
    [anon_sym_LBRACK] = ACTIONS(584),
    [sym_glimmer_opening_tag] = ACTIONS(584),
    [anon_sym_LT] = ACTIONS(586),
    [anon_sym_GT] = ACTIONS(588),
    [anon_sym_DOT] = ACTIONS(588),
    [anon_sym_DQUOTE] = ACTIONS(584),
    [anon_sym_SQUOTE] = ACTIONS(584),
    [anon_sym_class] = ACTIONS(586),
    [anon_sym_async] = ACTIONS(586),
    [anon_sym_function] = ACTIONS(586),
    [sym_optional_chain] = ACTIONS(590),
    [anon_sym_new] = ACTIONS(586),
    [anon_sym_AMP_AMP] = ACTIONS(590),
    [anon_sym_PIPE_PIPE] = ACTIONS(590),
    [anon_sym_GT_GT] = ACTIONS(588),
    [anon_sym_GT_GT_GT] = ACTIONS(590),
    [anon_sym_LT_LT] = ACTIONS(590),
    [anon_sym_AMP] = ACTIONS(588),
    [anon_sym_CARET] = ACTIONS(590),
    [anon_sym_PIPE] = ACTIONS(588),
    [anon_sym_PLUS] = ACTIONS(586),
    [anon_sym_DASH] = ACTIONS(586),
    [anon_sym_SLASH] = ACTIONS(586),
    [anon_sym_PERCENT] = ACTIONS(590),
    [anon_sym_STAR_STAR] = ACTIONS(590),
    [anon_sym_LT_EQ] = ACTIONS(590),
    [anon_sym_EQ_EQ] = ACTIONS(588),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(590),
    [anon_sym_BANG_EQ] = ACTIONS(588),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(590),
    [anon_sym_GT_EQ] = ACTIONS(590),
    [anon_sym_QMARK_QMARK] = ACTIONS(590),
    [anon_sym_instanceof] = ACTIONS(588),
    [anon_sym_BANG] = ACTIONS(586),
    [anon_sym_TILDE] = ACTIONS(584),
    [anon_sym_typeof] = ACTIONS(586),
    [anon_sym_void] = ACTIONS(586),
    [anon_sym_delete] = ACTIONS(586),
    [anon_sym_PLUS_PLUS] = ACTIONS(584),
    [anon_sym_DASH_DASH] = ACTIONS(584),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(584),
    [sym_number] = ACTIONS(584),
    [sym_private_property_identifier] = ACTIONS(584),
    [sym_this] = ACTIONS(586),
    [sym_super] = ACTIONS(586),
    [sym_true] = ACTIONS(586),
    [sym_false] = ACTIONS(586),
    [sym_null] = ACTIONS(586),
    [sym_undefined] = ACTIONS(586),
    [anon_sym_AT] = ACTIONS(584),
    [anon_sym_static] = ACTIONS(586),
    [anon_sym_get] = ACTIONS(586),
    [anon_sym_set] = ACTIONS(586),
    [sym__automatic_semicolon] = ACTIONS(592),
    [sym__ternary_qmark] = ACTIONS(590),
    [sym_html_comment] = ACTIONS(5),
  },
  [77] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(790),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_spread_element] = STATE(1382),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1384),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(524),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [anon_sym_RBRACK] = ACTIONS(594),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [78] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(790),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_spread_element] = STATE(1382),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1384),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(524),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [anon_sym_RBRACK] = ACTIONS(596),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [79] = {
    [ts_builtin_sym_end] = ACTIONS(598),
    [sym_identifier] = ACTIONS(600),
    [anon_sym_export] = ACTIONS(600),
    [anon_sym_STAR] = ACTIONS(602),
    [anon_sym_default] = ACTIONS(600),
    [anon_sym_LBRACE] = ACTIONS(598),
    [anon_sym_COMMA] = ACTIONS(604),
    [anon_sym_RBRACE] = ACTIONS(598),
    [anon_sym_import] = ACTIONS(600),
    [anon_sym_with] = ACTIONS(600),
    [anon_sym_var] = ACTIONS(600),
    [anon_sym_let] = ACTIONS(600),
    [anon_sym_const] = ACTIONS(600),
    [anon_sym_else] = ACTIONS(600),
    [anon_sym_if] = ACTIONS(600),
    [anon_sym_switch] = ACTIONS(600),
    [anon_sym_for] = ACTIONS(600),
    [anon_sym_LPAREN] = ACTIONS(598),
    [anon_sym_SEMI] = ACTIONS(598),
    [anon_sym_await] = ACTIONS(600),
    [anon_sym_in] = ACTIONS(602),
    [anon_sym_while] = ACTIONS(600),
    [anon_sym_do] = ACTIONS(600),
    [anon_sym_try] = ACTIONS(600),
    [anon_sym_break] = ACTIONS(600),
    [anon_sym_continue] = ACTIONS(600),
    [anon_sym_debugger] = ACTIONS(600),
    [anon_sym_return] = ACTIONS(600),
    [anon_sym_throw] = ACTIONS(600),
    [anon_sym_case] = ACTIONS(600),
    [anon_sym_yield] = ACTIONS(600),
    [anon_sym_LBRACK] = ACTIONS(598),
    [sym_glimmer_opening_tag] = ACTIONS(598),
    [anon_sym_LT] = ACTIONS(600),
    [anon_sym_GT] = ACTIONS(602),
    [anon_sym_DOT] = ACTIONS(602),
    [anon_sym_DQUOTE] = ACTIONS(598),
    [anon_sym_SQUOTE] = ACTIONS(598),
    [anon_sym_class] = ACTIONS(600),
    [anon_sym_async] = ACTIONS(600),
    [anon_sym_function] = ACTIONS(600),
    [sym_optional_chain] = ACTIONS(604),
    [anon_sym_new] = ACTIONS(600),
    [anon_sym_AMP_AMP] = ACTIONS(604),
    [anon_sym_PIPE_PIPE] = ACTIONS(604),
    [anon_sym_GT_GT] = ACTIONS(602),
    [anon_sym_GT_GT_GT] = ACTIONS(604),
    [anon_sym_LT_LT] = ACTIONS(604),
    [anon_sym_AMP] = ACTIONS(602),
    [anon_sym_CARET] = ACTIONS(604),
    [anon_sym_PIPE] = ACTIONS(602),
    [anon_sym_PLUS] = ACTIONS(600),
    [anon_sym_DASH] = ACTIONS(600),
    [anon_sym_SLASH] = ACTIONS(600),
    [anon_sym_PERCENT] = ACTIONS(604),
    [anon_sym_STAR_STAR] = ACTIONS(604),
    [anon_sym_LT_EQ] = ACTIONS(604),
    [anon_sym_EQ_EQ] = ACTIONS(602),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(604),
    [anon_sym_BANG_EQ] = ACTIONS(602),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(604),
    [anon_sym_GT_EQ] = ACTIONS(604),
    [anon_sym_QMARK_QMARK] = ACTIONS(604),
    [anon_sym_instanceof] = ACTIONS(602),
    [anon_sym_BANG] = ACTIONS(600),
    [anon_sym_TILDE] = ACTIONS(598),
    [anon_sym_typeof] = ACTIONS(600),
    [anon_sym_void] = ACTIONS(600),
    [anon_sym_delete] = ACTIONS(600),
    [anon_sym_PLUS_PLUS] = ACTIONS(598),
    [anon_sym_DASH_DASH] = ACTIONS(598),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(598),
    [sym_number] = ACTIONS(598),
    [sym_private_property_identifier] = ACTIONS(598),
    [sym_this] = ACTIONS(600),
    [sym_super] = ACTIONS(600),
    [sym_true] = ACTIONS(600),
    [sym_false] = ACTIONS(600),
    [sym_null] = ACTIONS(600),
    [sym_undefined] = ACTIONS(600),
    [anon_sym_AT] = ACTIONS(598),
    [anon_sym_static] = ACTIONS(600),
    [anon_sym_get] = ACTIONS(600),
    [anon_sym_set] = ACTIONS(600),
    [sym__automatic_semicolon] = ACTIONS(606),
    [sym__ternary_qmark] = ACTIONS(604),
    [sym_html_comment] = ACTIONS(5),
  },
  [80] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(790),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_spread_element] = STATE(1382),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1384),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(524),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [anon_sym_RBRACK] = ACTIONS(608),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [81] = {
    [ts_builtin_sym_end] = ACTIONS(610),
    [sym_identifier] = ACTIONS(612),
    [anon_sym_export] = ACTIONS(612),
    [anon_sym_STAR] = ACTIONS(614),
    [anon_sym_default] = ACTIONS(612),
    [anon_sym_LBRACE] = ACTIONS(610),
    [anon_sym_COMMA] = ACTIONS(616),
    [anon_sym_RBRACE] = ACTIONS(610),
    [anon_sym_import] = ACTIONS(612),
    [anon_sym_with] = ACTIONS(612),
    [anon_sym_var] = ACTIONS(612),
    [anon_sym_let] = ACTIONS(612),
    [anon_sym_const] = ACTIONS(612),
    [anon_sym_else] = ACTIONS(612),
    [anon_sym_if] = ACTIONS(612),
    [anon_sym_switch] = ACTIONS(612),
    [anon_sym_for] = ACTIONS(612),
    [anon_sym_LPAREN] = ACTIONS(610),
    [anon_sym_SEMI] = ACTIONS(610),
    [anon_sym_await] = ACTIONS(612),
    [anon_sym_in] = ACTIONS(614),
    [anon_sym_while] = ACTIONS(612),
    [anon_sym_do] = ACTIONS(612),
    [anon_sym_try] = ACTIONS(612),
    [anon_sym_break] = ACTIONS(612),
    [anon_sym_continue] = ACTIONS(612),
    [anon_sym_debugger] = ACTIONS(612),
    [anon_sym_return] = ACTIONS(612),
    [anon_sym_throw] = ACTIONS(612),
    [anon_sym_case] = ACTIONS(612),
    [anon_sym_yield] = ACTIONS(612),
    [anon_sym_LBRACK] = ACTIONS(610),
    [sym_glimmer_opening_tag] = ACTIONS(610),
    [anon_sym_LT] = ACTIONS(612),
    [anon_sym_GT] = ACTIONS(614),
    [anon_sym_DOT] = ACTIONS(614),
    [anon_sym_DQUOTE] = ACTIONS(610),
    [anon_sym_SQUOTE] = ACTIONS(610),
    [anon_sym_class] = ACTIONS(612),
    [anon_sym_async] = ACTIONS(612),
    [anon_sym_function] = ACTIONS(612),
    [sym_optional_chain] = ACTIONS(616),
    [anon_sym_new] = ACTIONS(612),
    [anon_sym_AMP_AMP] = ACTIONS(616),
    [anon_sym_PIPE_PIPE] = ACTIONS(616),
    [anon_sym_GT_GT] = ACTIONS(614),
    [anon_sym_GT_GT_GT] = ACTIONS(616),
    [anon_sym_LT_LT] = ACTIONS(616),
    [anon_sym_AMP] = ACTIONS(614),
    [anon_sym_CARET] = ACTIONS(616),
    [anon_sym_PIPE] = ACTIONS(614),
    [anon_sym_PLUS] = ACTIONS(612),
    [anon_sym_DASH] = ACTIONS(612),
    [anon_sym_SLASH] = ACTIONS(612),
    [anon_sym_PERCENT] = ACTIONS(616),
    [anon_sym_STAR_STAR] = ACTIONS(616),
    [anon_sym_LT_EQ] = ACTIONS(616),
    [anon_sym_EQ_EQ] = ACTIONS(614),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(616),
    [anon_sym_BANG_EQ] = ACTIONS(614),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(616),
    [anon_sym_GT_EQ] = ACTIONS(616),
    [anon_sym_QMARK_QMARK] = ACTIONS(616),
    [anon_sym_instanceof] = ACTIONS(614),
    [anon_sym_BANG] = ACTIONS(612),
    [anon_sym_TILDE] = ACTIONS(610),
    [anon_sym_typeof] = ACTIONS(612),
    [anon_sym_void] = ACTIONS(612),
    [anon_sym_delete] = ACTIONS(612),
    [anon_sym_PLUS_PLUS] = ACTIONS(610),
    [anon_sym_DASH_DASH] = ACTIONS(610),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(610),
    [sym_number] = ACTIONS(610),
    [sym_private_property_identifier] = ACTIONS(610),
    [sym_this] = ACTIONS(612),
    [sym_super] = ACTIONS(612),
    [sym_true] = ACTIONS(612),
    [sym_false] = ACTIONS(612),
    [sym_null] = ACTIONS(612),
    [sym_undefined] = ACTIONS(612),
    [anon_sym_AT] = ACTIONS(610),
    [anon_sym_static] = ACTIONS(612),
    [anon_sym_get] = ACTIONS(612),
    [anon_sym_set] = ACTIONS(612),
    [sym__automatic_semicolon] = ACTIONS(618),
    [sym__ternary_qmark] = ACTIONS(616),
    [sym_html_comment] = ACTIONS(5),
  },
  [82] = {
    [ts_builtin_sym_end] = ACTIONS(620),
    [sym_identifier] = ACTIONS(622),
    [anon_sym_export] = ACTIONS(622),
    [anon_sym_STAR] = ACTIONS(624),
    [anon_sym_default] = ACTIONS(622),
    [anon_sym_LBRACE] = ACTIONS(620),
    [anon_sym_COMMA] = ACTIONS(626),
    [anon_sym_RBRACE] = ACTIONS(620),
    [anon_sym_import] = ACTIONS(622),
    [anon_sym_with] = ACTIONS(622),
    [anon_sym_var] = ACTIONS(622),
    [anon_sym_let] = ACTIONS(622),
    [anon_sym_const] = ACTIONS(622),
    [anon_sym_else] = ACTIONS(622),
    [anon_sym_if] = ACTIONS(622),
    [anon_sym_switch] = ACTIONS(622),
    [anon_sym_for] = ACTIONS(622),
    [anon_sym_LPAREN] = ACTIONS(620),
    [anon_sym_SEMI] = ACTIONS(620),
    [anon_sym_await] = ACTIONS(622),
    [anon_sym_in] = ACTIONS(624),
    [anon_sym_while] = ACTIONS(622),
    [anon_sym_do] = ACTIONS(622),
    [anon_sym_try] = ACTIONS(622),
    [anon_sym_break] = ACTIONS(622),
    [anon_sym_continue] = ACTIONS(622),
    [anon_sym_debugger] = ACTIONS(622),
    [anon_sym_return] = ACTIONS(622),
    [anon_sym_throw] = ACTIONS(622),
    [anon_sym_case] = ACTIONS(622),
    [anon_sym_yield] = ACTIONS(622),
    [anon_sym_LBRACK] = ACTIONS(620),
    [sym_glimmer_opening_tag] = ACTIONS(620),
    [anon_sym_LT] = ACTIONS(622),
    [anon_sym_GT] = ACTIONS(624),
    [anon_sym_DOT] = ACTIONS(624),
    [anon_sym_DQUOTE] = ACTIONS(620),
    [anon_sym_SQUOTE] = ACTIONS(620),
    [anon_sym_class] = ACTIONS(622),
    [anon_sym_async] = ACTIONS(622),
    [anon_sym_function] = ACTIONS(622),
    [sym_optional_chain] = ACTIONS(626),
    [anon_sym_new] = ACTIONS(622),
    [anon_sym_AMP_AMP] = ACTIONS(626),
    [anon_sym_PIPE_PIPE] = ACTIONS(626),
    [anon_sym_GT_GT] = ACTIONS(624),
    [anon_sym_GT_GT_GT] = ACTIONS(626),
    [anon_sym_LT_LT] = ACTIONS(626),
    [anon_sym_AMP] = ACTIONS(624),
    [anon_sym_CARET] = ACTIONS(626),
    [anon_sym_PIPE] = ACTIONS(624),
    [anon_sym_PLUS] = ACTIONS(622),
    [anon_sym_DASH] = ACTIONS(622),
    [anon_sym_SLASH] = ACTIONS(622),
    [anon_sym_PERCENT] = ACTIONS(626),
    [anon_sym_STAR_STAR] = ACTIONS(626),
    [anon_sym_LT_EQ] = ACTIONS(626),
    [anon_sym_EQ_EQ] = ACTIONS(624),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(626),
    [anon_sym_BANG_EQ] = ACTIONS(624),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(626),
    [anon_sym_GT_EQ] = ACTIONS(626),
    [anon_sym_QMARK_QMARK] = ACTIONS(626),
    [anon_sym_instanceof] = ACTIONS(624),
    [anon_sym_BANG] = ACTIONS(622),
    [anon_sym_TILDE] = ACTIONS(620),
    [anon_sym_typeof] = ACTIONS(622),
    [anon_sym_void] = ACTIONS(622),
    [anon_sym_delete] = ACTIONS(622),
    [anon_sym_PLUS_PLUS] = ACTIONS(620),
    [anon_sym_DASH_DASH] = ACTIONS(620),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(620),
    [sym_number] = ACTIONS(620),
    [sym_private_property_identifier] = ACTIONS(620),
    [sym_this] = ACTIONS(622),
    [sym_super] = ACTIONS(622),
    [sym_true] = ACTIONS(622),
    [sym_false] = ACTIONS(622),
    [sym_null] = ACTIONS(622),
    [sym_undefined] = ACTIONS(622),
    [anon_sym_AT] = ACTIONS(620),
    [anon_sym_static] = ACTIONS(622),
    [anon_sym_get] = ACTIONS(622),
    [anon_sym_set] = ACTIONS(622),
    [sym__automatic_semicolon] = ACTIONS(628),
    [sym__ternary_qmark] = ACTIONS(626),
    [sym_html_comment] = ACTIONS(5),
  },
  [83] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(790),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_spread_element] = STATE(1382),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1384),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(524),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [anon_sym_RBRACK] = ACTIONS(630),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [84] = {
    [ts_builtin_sym_end] = ACTIONS(632),
    [sym_identifier] = ACTIONS(634),
    [anon_sym_export] = ACTIONS(634),
    [anon_sym_STAR] = ACTIONS(636),
    [anon_sym_default] = ACTIONS(634),
    [anon_sym_LBRACE] = ACTIONS(632),
    [anon_sym_COMMA] = ACTIONS(638),
    [anon_sym_RBRACE] = ACTIONS(632),
    [anon_sym_import] = ACTIONS(634),
    [anon_sym_with] = ACTIONS(634),
    [anon_sym_var] = ACTIONS(634),
    [anon_sym_let] = ACTIONS(634),
    [anon_sym_const] = ACTIONS(634),
    [anon_sym_else] = ACTIONS(634),
    [anon_sym_if] = ACTIONS(634),
    [anon_sym_switch] = ACTIONS(634),
    [anon_sym_for] = ACTIONS(634),
    [anon_sym_LPAREN] = ACTIONS(632),
    [anon_sym_SEMI] = ACTIONS(632),
    [anon_sym_await] = ACTIONS(634),
    [anon_sym_in] = ACTIONS(636),
    [anon_sym_while] = ACTIONS(634),
    [anon_sym_do] = ACTIONS(634),
    [anon_sym_try] = ACTIONS(634),
    [anon_sym_break] = ACTIONS(634),
    [anon_sym_continue] = ACTIONS(634),
    [anon_sym_debugger] = ACTIONS(634),
    [anon_sym_return] = ACTIONS(634),
    [anon_sym_throw] = ACTIONS(634),
    [anon_sym_case] = ACTIONS(634),
    [anon_sym_yield] = ACTIONS(634),
    [anon_sym_LBRACK] = ACTIONS(632),
    [sym_glimmer_opening_tag] = ACTIONS(632),
    [anon_sym_LT] = ACTIONS(634),
    [anon_sym_GT] = ACTIONS(636),
    [anon_sym_DOT] = ACTIONS(636),
    [anon_sym_DQUOTE] = ACTIONS(632),
    [anon_sym_SQUOTE] = ACTIONS(632),
    [anon_sym_class] = ACTIONS(634),
    [anon_sym_async] = ACTIONS(634),
    [anon_sym_function] = ACTIONS(634),
    [sym_optional_chain] = ACTIONS(638),
    [anon_sym_new] = ACTIONS(634),
    [anon_sym_AMP_AMP] = ACTIONS(638),
    [anon_sym_PIPE_PIPE] = ACTIONS(638),
    [anon_sym_GT_GT] = ACTIONS(636),
    [anon_sym_GT_GT_GT] = ACTIONS(638),
    [anon_sym_LT_LT] = ACTIONS(638),
    [anon_sym_AMP] = ACTIONS(636),
    [anon_sym_CARET] = ACTIONS(638),
    [anon_sym_PIPE] = ACTIONS(636),
    [anon_sym_PLUS] = ACTIONS(634),
    [anon_sym_DASH] = ACTIONS(634),
    [anon_sym_SLASH] = ACTIONS(634),
    [anon_sym_PERCENT] = ACTIONS(638),
    [anon_sym_STAR_STAR] = ACTIONS(638),
    [anon_sym_LT_EQ] = ACTIONS(638),
    [anon_sym_EQ_EQ] = ACTIONS(636),
    [anon_sym_EQ_EQ_EQ] = ACTIONS(638),
    [anon_sym_BANG_EQ] = ACTIONS(636),
    [anon_sym_BANG_EQ_EQ] = ACTIONS(638),
    [anon_sym_GT_EQ] = ACTIONS(638),
    [anon_sym_QMARK_QMARK] = ACTIONS(638),
    [anon_sym_instanceof] = ACTIONS(636),
    [anon_sym_BANG] = ACTIONS(634),
    [anon_sym_TILDE] = ACTIONS(632),
    [anon_sym_typeof] = ACTIONS(634),
    [anon_sym_void] = ACTIONS(634),
    [anon_sym_delete] = ACTIONS(634),
    [anon_sym_PLUS_PLUS] = ACTIONS(632),
    [anon_sym_DASH_DASH] = ACTIONS(632),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(632),
    [sym_number] = ACTIONS(632),
    [sym_private_property_identifier] = ACTIONS(632),
    [sym_this] = ACTIONS(634),
    [sym_super] = ACTIONS(634),
    [sym_true] = ACTIONS(634),
    [sym_false] = ACTIONS(634),
    [sym_null] = ACTIONS(634),
    [sym_undefined] = ACTIONS(634),
    [anon_sym_AT] = ACTIONS(632),
    [anon_sym_static] = ACTIONS(634),
    [anon_sym_get] = ACTIONS(634),
    [anon_sym_set] = ACTIONS(634),
    [sym__automatic_semicolon] = ACTIONS(640),
    [sym__ternary_qmark] = ACTIONS(638),
    [sym_html_comment] = ACTIONS(5),
  },
  [85] = {
    [sym_declaration] = STATE(413),
    [sym_import] = STATE(1267),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(838),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1245),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(644),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [86] = {
    [sym_declaration] = STATE(382),
    [sym_import] = STATE(1267),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(833),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1264),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(646),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [87] = {
    [sym_declaration] = STATE(382),
    [sym_import] = STATE(1267),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(833),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1245),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(67),
    [anon_sym_async] = ACTIONS(644),
    [anon_sym_function] = ACTIONS(71),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [88] = {
    [sym_declaration] = STATE(413),
    [sym_import] = STATE(1267),
    [sym_variable_declaration] = STATE(407),
    [sym_lexical_declaration] = STATE(407),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(838),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_class_declaration] = STATE(407),
    [sym_function_expression] = STATE(649),
    [sym_function_declaration] = STATE(407),
    [sym_generator_function] = STATE(649),
    [sym_generator_function_declaration] = STATE(407),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1264),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_let] = ACTIONS(642),
    [anon_sym_const] = ACTIONS(25),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(348),
    [anon_sym_async] = ACTIONS(646),
    [anon_sym_function] = ACTIONS(352),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [89] = {
    [sym_import] = STATE(1279),
    [sym_variable_declaration] = STATE(113),
    [sym_lexical_declaration] = STATE(113),
    [sym_empty_statement] = STATE(113),
    [sym_parenthesized_expression] = STATE(495),
    [sym_expression] = STATE(795),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1393),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1393),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(495),
    [sym_subscript_expression] = STATE(495),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1393),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1739),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(652),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_var] = ACTIONS(654),
    [anon_sym_let] = ACTIONS(656),
    [anon_sym_const] = ACTIONS(658),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(660),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(662),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(650),
    [anon_sym_get] = ACTIONS(650),
    [anon_sym_set] = ACTIONS(650),
    [sym_html_comment] = ACTIONS(5),
  },
  [90] = {
    [sym_import] = STATE(1279),
    [sym_variable_declaration] = STATE(114),
    [sym_lexical_declaration] = STATE(114),
    [sym_empty_statement] = STATE(114),
    [sym_parenthesized_expression] = STATE(495),
    [sym_expression] = STATE(829),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1393),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1393),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(495),
    [sym_subscript_expression] = STATE(495),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1393),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1743),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(648),
    [anon_sym_export] = ACTIONS(650),
    [anon_sym_LBRACE] = ACTIONS(652),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_var] = ACTIONS(654),
    [anon_sym_let] = ACTIONS(656),
    [anon_sym_const] = ACTIONS(658),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(660),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(662),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(664),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(650),
    [anon_sym_get] = ACTIONS(650),
    [anon_sym_set] = ACTIONS(650),
    [sym_html_comment] = ACTIONS(5),
  },
  [91] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(818),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1452),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_spread_element] = STATE(1313),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1316),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(666),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [anon_sym_RBRACK] = ACTIONS(666),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(113),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [92] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1210),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1210),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1210),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(669),
    [anon_sym_export] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_COMMA] = ACTIONS(675),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [anon_sym_RBRACK] = ACTIONS(679),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(671),
    [anon_sym_get] = ACTIONS(671),
    [anon_sym_set] = ACTIONS(671),
    [sym_html_comment] = ACTIONS(5),
  },
  [93] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1210),
    [sym_assignment_pattern] = STATE(1381),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1210),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1210),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [sym_pattern] = STATE(1285),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_pattern_repeat1] = STATE(1291),
    [sym_identifier] = ACTIONS(669),
    [anon_sym_export] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_COMMA] = ACTIONS(675),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [anon_sym_RBRACK] = ACTIONS(687),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(671),
    [anon_sym_get] = ACTIONS(671),
    [anon_sym_set] = ACTIONS(671),
    [sym_html_comment] = ACTIONS(5),
  },
  [94] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(871),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1392),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(496),
    [sym_subscript_expression] = STATE(496),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1218),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_pattern_repeat1] = STATE(1336),
    [sym_identifier] = ACTIONS(689),
    [anon_sym_export] = ACTIONS(691),
    [anon_sym_LBRACE] = ACTIONS(693),
    [anon_sym_COMMA] = ACTIONS(675),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(691),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(695),
    [anon_sym_RBRACK] = ACTIONS(679),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(697),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(699),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(691),
    [anon_sym_get] = ACTIONS(691),
    [anon_sym_set] = ACTIONS(691),
    [sym_html_comment] = ACTIONS(5),
  },
  [95] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1210),
    [sym_assignment_pattern] = STATE(1452),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1210),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1210),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [sym_pattern] = STATE(1316),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(669),
    [anon_sym_export] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_COMMA] = ACTIONS(701),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [anon_sym_RBRACK] = ACTIONS(701),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(671),
    [anon_sym_get] = ACTIONS(671),
    [anon_sym_set] = ACTIONS(671),
    [sym_html_comment] = ACTIONS(5),
  },
  [96] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(794),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1359),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1687),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1235),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(703),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [97] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(800),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1359),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1719),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1235),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(703),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [98] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(812),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_spread_element] = STATE(1315),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1317),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_COMMA] = ACTIONS(705),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(707),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(709),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [99] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1210),
    [sym_assignment_pattern] = STATE(1359),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1210),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1210),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [sym_pattern] = STATE(1235),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(669),
    [anon_sym_export] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(703),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(671),
    [anon_sym_get] = ACTIONS(671),
    [anon_sym_set] = ACTIONS(671),
    [sym_html_comment] = ACTIONS(5),
  },
  [100] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1210),
    [sym_assignment_pattern] = STATE(1630),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1210),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1210),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [sym_pattern] = STATE(1350),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(669),
    [anon_sym_export] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(711),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(671),
    [anon_sym_get] = ACTIONS(671),
    [anon_sym_set] = ACTIONS(671),
    [sym_html_comment] = ACTIONS(5),
  },
  [101] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(818),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_spread_element] = STATE(1313),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_COMMA] = ACTIONS(713),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(713),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [anon_sym_RBRACK] = ACTIONS(713),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(709),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [102] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(763),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_spread_element] = STATE(1322),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1324),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_COMMA] = ACTIONS(705),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(715),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(709),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [103] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(804),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_spread_element] = STATE(1293),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [aux_sym_array_repeat1] = STATE(1294),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_COMMA] = ACTIONS(705),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(717),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(709),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [104] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1210),
    [sym_assignment_pattern] = STATE(1630),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1210),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1210),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [sym_pattern] = STATE(1350),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(669),
    [anon_sym_export] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(719),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(671),
    [anon_sym_get] = ACTIONS(671),
    [anon_sym_set] = ACTIONS(671),
    [sym_html_comment] = ACTIONS(5),
  },
  [105] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(820),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_spread_element] = STATE(1745),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1745),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_RBRACE] = ACTIONS(721),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(709),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [106] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(834),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1156),
    [sym_assignment_pattern] = STATE(1397),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1156),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(483),
    [sym_subscript_expression] = STATE(483),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1156),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [sym_pattern] = STATE(1385),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(520),
    [anon_sym_export] = ACTIONS(522),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(522),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(528),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(530),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(522),
    [anon_sym_get] = ACTIONS(522),
    [anon_sym_set] = ACTIONS(522),
    [sym_html_comment] = ACTIONS(5),
  },
  [107] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1210),
    [sym_assignment_pattern] = STATE(1397),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1210),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1210),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [sym_pattern] = STATE(1385),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(669),
    [anon_sym_export] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(671),
    [anon_sym_get] = ACTIONS(671),
    [anon_sym_set] = ACTIONS(671),
    [sym_html_comment] = ACTIONS(5),
  },
  [108] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(802),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_spread_element] = STATE(1710),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1710),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_RBRACE] = ACTIONS(723),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(709),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [109] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1210),
    [sym_assignment_pattern] = STATE(1630),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1210),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(487),
    [sym_subscript_expression] = STATE(487),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1210),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [sym_pattern] = STATE(1350),
    [sym_rest_pattern] = STATE(1160),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(669),
    [anon_sym_export] = ACTIONS(671),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(671),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(681),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(683),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(685),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(671),
    [anon_sym_get] = ACTIONS(671),
    [anon_sym_set] = ACTIONS(671),
    [sym_html_comment] = ACTIONS(5),
  },
  [110] = {
    [sym_import] = STATE(1279),
    [sym_empty_statement] = STATE(120),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(762),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1671),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [111] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(755),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1605),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(725),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym__automatic_semicolon] = ACTIONS(725),
    [sym_html_comment] = ACTIONS(5),
  },
  [112] = {
    [sym_import] = STATE(1279),
    [sym_empty_statement] = STATE(115),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(796),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1663),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [113] = {
    [sym_import] = STATE(1279),
    [sym_empty_statement] = STATE(119),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(777),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1657),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [114] = {
    [sym_import] = STATE(1279),
    [sym_empty_statement] = STATE(118),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(787),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1662),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_SEMI] = ACTIONS(35),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [115] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(793),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1731),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(727),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [116] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(772),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1724),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(729),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [117] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(503),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1335),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1335),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(503),
    [sym_subscript_expression] = STATE(503),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1335),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(731),
    [anon_sym_export] = ACTIONS(733),
    [anon_sym_LBRACE] = ACTIONS(652),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_var] = ACTIONS(735),
    [anon_sym_let] = ACTIONS(737),
    [anon_sym_const] = ACTIONS(739),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(660),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(741),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(743),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(733),
    [anon_sym_get] = ACTIONS(733),
    [anon_sym_set] = ACTIONS(733),
    [sym_html_comment] = ACTIONS(5),
  },
  [118] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(809),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1670),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(745),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [119] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(828),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1646),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(747),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [120] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(765),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1688),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(749),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [121] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(767),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1639),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(751),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [122] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(764),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1685),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(753),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [123] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(784),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1721),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_RPAREN] = ACTIONS(755),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [124] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(561),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(605),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(757),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [125] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(573),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(775),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym_html_comment] = ACTIONS(5),
  },
  [126] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(821),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1699),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [127] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(781),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1675),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [128] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(506),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(507),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DOT] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym_html_comment] = ACTIONS(5),
  },
  [129] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(823),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1709),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [130] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(825),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1737),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [131] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(799),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1715),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [132] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(668),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(670),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [133] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(803),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1717),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [134] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(672),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(675),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [135] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(736),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(737),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [136] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(506),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(507),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(765),
    [anon_sym_export] = ACTIONS(767),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(767),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DOT] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(769),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(767),
    [anon_sym_get] = ACTIONS(767),
    [anon_sym_set] = ACTIONS(767),
    [sym_html_comment] = ACTIONS(5),
  },
  [137] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(713),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(718),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [138] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(677),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(704),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [139] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(822),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1682),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [140] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(521),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(582),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(757),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [141] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(556),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(588),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(757),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [142] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(576),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(601),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(757),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [143] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(788),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1712),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [144] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(658),
    [sym_parenthesized_expression] = STATE(484),
    [sym_expression] = STATE(674),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1733),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1733),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(484),
    [sym_subscript_expression] = STATE(484),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1034),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1733),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1734),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(428),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(434),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(450),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym_html_comment] = ACTIONS(5),
  },
  [145] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(792),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1690),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [146] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(815),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1644),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [147] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(736),
    [sym_parenthesized_expression] = STATE(484),
    [sym_expression] = STATE(683),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1733),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1733),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(484),
    [sym_subscript_expression] = STATE(484),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1034),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1733),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1734),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(428),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(434),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(450),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym_html_comment] = ACTIONS(5),
  },
  [148] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(658),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(663),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [149] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(713),
    [sym_parenthesized_expression] = STATE(484),
    [sym_expression] = STATE(698),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1733),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1733),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(484),
    [sym_subscript_expression] = STATE(484),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1034),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1733),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1734),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(428),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(434),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(450),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym_html_comment] = ACTIONS(5),
  },
  [150] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(668),
    [sym_parenthesized_expression] = STATE(484),
    [sym_expression] = STATE(700),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1733),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1733),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(484),
    [sym_subscript_expression] = STATE(484),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1034),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1733),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1734),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(428),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(434),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(450),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym_html_comment] = ACTIONS(5),
  },
  [151] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(672),
    [sym_parenthesized_expression] = STATE(484),
    [sym_expression] = STATE(701),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1733),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1733),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(484),
    [sym_subscript_expression] = STATE(484),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1034),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1733),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1734),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(428),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(434),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(450),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym_html_comment] = ACTIONS(5),
  },
  [152] = {
    [sym_import] = STATE(1267),
    [sym_statement_block] = STATE(677),
    [sym_parenthesized_expression] = STATE(484),
    [sym_expression] = STATE(702),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1733),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1733),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(484),
    [sym_subscript_expression] = STATE(484),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1034),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1733),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1734),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(428),
    [anon_sym_export] = ACTIONS(430),
    [anon_sym_LBRACE] = ACTIONS(763),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(430),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(434),
    [anon_sym_yield] = ACTIONS(436),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(438),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(442),
    [anon_sym_DASH] = ACTIONS(442),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(446),
    [anon_sym_TILDE] = ACTIONS(446),
    [anon_sym_typeof] = ACTIONS(442),
    [anon_sym_void] = ACTIONS(442),
    [anon_sym_delete] = ACTIONS(442),
    [anon_sym_PLUS_PLUS] = ACTIONS(448),
    [anon_sym_DASH_DASH] = ACTIONS(448),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(450),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(452),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(430),
    [anon_sym_get] = ACTIONS(430),
    [anon_sym_set] = ACTIONS(430),
    [sym_html_comment] = ACTIONS(5),
  },
  [153] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(827),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1686),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [154] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(471),
    [sym_expression] = STATE(880),
    [sym_primary_expression] = STATE(603),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(604),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(471),
    [sym_subscript_expression] = STATE(471),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(771),
    [anon_sym_export] = ACTIONS(773),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(773),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DOT] = ACTIONS(775),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(777),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(779),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(773),
    [anon_sym_get] = ACTIONS(773),
    [anon_sym_set] = ACTIONS(773),
    [sym_html_comment] = ACTIONS(5),
  },
  [155] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(776),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1730),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [156] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(789),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1696),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [157] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(521),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(782),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym_html_comment] = ACTIONS(5),
  },
  [158] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(556),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(830),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym_html_comment] = ACTIONS(5),
  },
  [159] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(573),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(608),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(757),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [160] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(471),
    [sym_expression] = STATE(880),
    [sym_primary_expression] = STATE(603),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(604),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(471),
    [sym_subscript_expression] = STATE(471),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1734),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(781),
    [anon_sym_export] = ACTIONS(783),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(783),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DOT] = ACTIONS(775),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(785),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(440),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(444),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(779),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(783),
    [anon_sym_get] = ACTIONS(783),
    [anon_sym_set] = ACTIONS(783),
    [sym_html_comment] = ACTIONS(5),
  },
  [161] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(576),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(770),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym_html_comment] = ACTIONS(5),
  },
  [162] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(572),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(607),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(757),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [163] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(561),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(771),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym_html_comment] = ACTIONS(5),
  },
  [164] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(521),
    [sym_parenthesized_expression] = STATE(504),
    [sym_expression] = STATE(868),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1744),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1744),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(504),
    [sym_subscript_expression] = STATE(504),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1047),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1744),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1725),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(454),
    [anon_sym_export] = ACTIONS(456),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_typeof] = ACTIONS(472),
    [anon_sym_void] = ACTIONS(472),
    [anon_sym_delete] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(480),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_get] = ACTIONS(456),
    [anon_sym_set] = ACTIONS(456),
    [sym_html_comment] = ACTIONS(5),
  },
  [165] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(556),
    [sym_parenthesized_expression] = STATE(504),
    [sym_expression] = STATE(850),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1744),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1744),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(504),
    [sym_subscript_expression] = STATE(504),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1047),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1744),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1725),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(454),
    [anon_sym_export] = ACTIONS(456),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_typeof] = ACTIONS(472),
    [anon_sym_void] = ACTIONS(472),
    [anon_sym_delete] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(480),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_get] = ACTIONS(456),
    [anon_sym_set] = ACTIONS(456),
    [sym_html_comment] = ACTIONS(5),
  },
  [166] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(576),
    [sym_parenthesized_expression] = STATE(504),
    [sym_expression] = STATE(863),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1744),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1744),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(504),
    [sym_subscript_expression] = STATE(504),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1047),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1744),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1725),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(454),
    [anon_sym_export] = ACTIONS(456),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_typeof] = ACTIONS(472),
    [anon_sym_void] = ACTIONS(472),
    [anon_sym_delete] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(480),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_get] = ACTIONS(456),
    [anon_sym_set] = ACTIONS(456),
    [sym_html_comment] = ACTIONS(5),
  },
  [167] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(561),
    [sym_parenthesized_expression] = STATE(504),
    [sym_expression] = STATE(864),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1744),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1744),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(504),
    [sym_subscript_expression] = STATE(504),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1047),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1744),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1725),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(454),
    [anon_sym_export] = ACTIONS(456),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_typeof] = ACTIONS(472),
    [anon_sym_void] = ACTIONS(472),
    [anon_sym_delete] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(480),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_get] = ACTIONS(456),
    [anon_sym_set] = ACTIONS(456),
    [sym_html_comment] = ACTIONS(5),
  },
  [168] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(572),
    [sym_parenthesized_expression] = STATE(504),
    [sym_expression] = STATE(865),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1744),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1744),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(504),
    [sym_subscript_expression] = STATE(504),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1047),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1744),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1725),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(454),
    [anon_sym_export] = ACTIONS(456),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_typeof] = ACTIONS(472),
    [anon_sym_void] = ACTIONS(472),
    [anon_sym_delete] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(480),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_get] = ACTIONS(456),
    [anon_sym_set] = ACTIONS(456),
    [sym_html_comment] = ACTIONS(5),
  },
  [169] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(573),
    [sym_parenthesized_expression] = STATE(504),
    [sym_expression] = STATE(866),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1744),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1744),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(504),
    [sym_subscript_expression] = STATE(504),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1047),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1744),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1725),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(454),
    [anon_sym_export] = ACTIONS(456),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(456),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(462),
    [anon_sym_yield] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(468),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_typeof] = ACTIONS(472),
    [anon_sym_void] = ACTIONS(472),
    [anon_sym_delete] = ACTIONS(472),
    [anon_sym_PLUS_PLUS] = ACTIONS(478),
    [anon_sym_DASH_DASH] = ACTIONS(478),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(480),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(482),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(456),
    [anon_sym_get] = ACTIONS(456),
    [anon_sym_set] = ACTIONS(456),
    [sym_html_comment] = ACTIONS(5),
  },
  [170] = {
    [sym_import] = STATE(1279),
    [sym_statement_block] = STATE(572),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(774),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(759),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym_html_comment] = ACTIONS(5),
  },
  [171] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(506),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(507),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1725),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(787),
    [anon_sym_export] = ACTIONS(789),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(789),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DOT] = ACTIONS(761),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(791),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(470),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(789),
    [anon_sym_get] = ACTIONS(789),
    [anon_sym_set] = ACTIONS(789),
    [sym_html_comment] = ACTIONS(5),
  },
  [172] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(750),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_sequence_expression] = STATE(1609),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [173] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(813),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_sequence_expression] = STATE(1742),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [174] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(626),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [175] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(757),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [176] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(839),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [177] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(841),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [178] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(879),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1159),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1159),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(485),
    [sym_subscript_expression] = STATE(485),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1159),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(793),
    [anon_sym_export] = ACTIONS(795),
    [anon_sym_LBRACE] = ACTIONS(673),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(795),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(677),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(797),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(799),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(795),
    [anon_sym_get] = ACTIONS(795),
    [anon_sym_set] = ACTIONS(795),
    [sym_html_comment] = ACTIONS(5),
  },
  [179] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(644),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [180] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(834),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [181] = {
    [sym_import] = STATE(1267),
    [sym_parenthesized_expression] = STATE(486),
    [sym_expression] = STATE(740),
    [sym_primary_expression] = STATE(619),
    [sym_yield_expression] = STATE(685),
    [sym_object] = STATE(649),
    [sym_object_pattern] = STATE(1654),
    [sym_array] = STATE(649),
    [sym_array_pattern] = STATE(1654),
    [sym_glimmer_template] = STATE(685),
    [sym_jsx_element] = STATE(685),
    [sym_jsx_opening_element] = STATE(1059),
    [sym_jsx_self_closing_element] = STATE(685),
    [sym_class] = STATE(649),
    [sym_function_expression] = STATE(649),
    [sym_generator_function] = STATE(649),
    [sym_arrow_function] = STATE(649),
    [sym_call_expression] = STATE(649),
    [sym_new_expression] = STATE(615),
    [sym_await_expression] = STATE(685),
    [sym_member_expression] = STATE(486),
    [sym_subscript_expression] = STATE(486),
    [sym_assignment_expression] = STATE(685),
    [sym__augmented_assignment_lhs] = STATE(1028),
    [sym_augmented_assignment_expression] = STATE(685),
    [sym__destructuring_pattern] = STATE(1654),
    [sym_ternary_expression] = STATE(685),
    [sym_binary_expression] = STATE(685),
    [sym_unary_expression] = STATE(685),
    [sym_update_expression] = STATE(685),
    [sym_string] = STATE(649),
    [sym_template_string] = STATE(649),
    [sym_regex] = STATE(649),
    [sym_meta_property] = STATE(649),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1701),
    [aux_sym_export_statement_repeat1] = STATE(1261),
    [sym_identifier] = ACTIONS(412),
    [anon_sym_export] = ACTIONS(414),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_import] = ACTIONS(420),
    [anon_sym_let] = ACTIONS(414),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_await] = ACTIONS(37),
    [anon_sym_yield] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [sym_glimmer_opening_tag] = ACTIONS(59),
    [anon_sym_LT] = ACTIONS(61),
    [anon_sym_DQUOTE] = ACTIONS(63),
    [anon_sym_SQUOTE] = ACTIONS(65),
    [anon_sym_class] = ACTIONS(422),
    [anon_sym_async] = ACTIONS(424),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(73),
    [anon_sym_PLUS] = ACTIONS(75),
    [anon_sym_DASH] = ACTIONS(75),
    [anon_sym_SLASH] = ACTIONS(77),
    [anon_sym_BANG] = ACTIONS(79),
    [anon_sym_TILDE] = ACTIONS(79),
    [anon_sym_typeof] = ACTIONS(75),
    [anon_sym_void] = ACTIONS(75),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_PLUS_PLUS] = ACTIONS(81),
    [anon_sym_DASH_DASH] = ACTIONS(81),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(83),
    [sym_number] = ACTIONS(85),
    [sym_private_property_identifier] = ACTIONS(87),
    [sym_this] = ACTIONS(89),
    [sym_super] = ACTIONS(89),
    [sym_true] = ACTIONS(89),
    [sym_false] = ACTIONS(89),
    [sym_null] = ACTIONS(89),
    [sym_undefined] = ACTIONS(91),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(414),
    [anon_sym_get] = ACTIONS(414),
    [anon_sym_set] = ACTIONS(414),
    [sym_html_comment] = ACTIONS(5),
  },
  [182] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(430),
    [sym_expression] = STATE(873),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1651),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1651),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(430),
    [sym_subscript_expression] = STATE(430),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1033),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1651),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1693),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(484),
    [anon_sym_export] = ACTIONS(486),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(490),
    [anon_sym_yield] = ACTIONS(492),
    [anon_sym_LBRACK] = ACTIONS(466),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(496),
    [anon_sym_PLUS] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_typeof] = ACTIONS(498),
    [anon_sym_void] = ACTIONS(498),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_DASH_DASH] = ACTIONS(502),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(504),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(506),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(486),
    [anon_sym_get] = ACTIONS(486),
    [anon_sym_set] = ACTIONS(486),
    [sym_html_comment] = ACTIONS(5),
  },
  [183] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(511),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [184] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(508),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [185] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(581),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [186] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(586),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [187] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(587),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [188] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(589),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [189] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(590),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [190] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(621),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [191] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(591),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [192] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(592),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [193] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(593),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [194] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(594),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [195] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(595),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [196] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(613),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [197] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(596),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [198] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(597),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [199] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(598),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394),
    [anon_sym_delete] = ACTIONS(394),
    [anon_sym_PLUS_PLUS] = ACTIONS(400),
    [anon_sym_DASH_DASH] = ACTIONS(400),
    [sym_comment] = ACTIONS(5),
    [anon_sym_BQUOTE] = ACTIONS(402),
    [sym_number] = ACTIONS(404),
    [sym_private_property_identifier] = ACTIONS(406),
    [sym_this] = ACTIONS(408),
    [sym_super] = ACTIONS(408),
    [sym_true] = ACTIONS(408),
    [sym_false] = ACTIONS(408),
    [sym_null] = ACTIONS(408),
    [sym_undefined] = ACTIONS(410),
    [anon_sym_AT] = ACTIONS(93),
    [anon_sym_static] = ACTIONS(358),
    [anon_sym_get] = ACTIONS(358),
    [anon_sym_set] = ACTIONS(358),
    [sym_html_comment] = ACTIONS(5),
  },
  [200] = {
    [sym_import] = STATE(1279),
    [sym_parenthesized_expression] = STATE(445),
    [sym_expression] = STATE(599),
    [sym_primary_expression] = STATE(515),
    [sym_yield_expression] = STATE(535),
    [sym_object] = STATE(531),
    [sym_object_pattern] = STATE(1691),
    [sym_array] = STATE(531),
    [sym_array_pattern] = STATE(1691),
    [sym_glimmer_template] = STATE(535),
    [sym_jsx_element] = STATE(535),
    [sym_jsx_opening_element] = STATE(1053),
    [sym_jsx_self_closing_element] = STATE(535),
    [sym_class] = STATE(531),
    [sym_function_expression] = STATE(531),
    [sym_generator_function] = STATE(531),
    [sym_arrow_function] = STATE(531),
    [sym_call_expression] = STATE(531),
    [sym_new_expression] = STATE(514),
    [sym_await_expression] = STATE(535),
    [sym_member_expression] = STATE(445),
    [sym_subscript_expression] = STATE(445),
    [sym_assignment_expression] = STATE(535),
    [sym__augmented_assignment_lhs] = STATE(1032),
    [sym_augmented_assignment_expression] = STATE(535),
    [sym__destructuring_pattern] = STATE(1691),
    [sym_ternary_expression] = STATE(535),
    [sym_binary_expression] = STATE(535),
    [sym_unary_expression] = STATE(535),
    [sym_update_expression] = STATE(535),
    [sym_string] = STATE(531),
    [sym_template_string] = STATE(531),
    [sym_regex] = STATE(531),
    [sym_meta_property] = STATE(531),
    [sym_decorator] = STATE(991),
    [sym_formal_parameters] = STATE(1652),
    [aux_sym_export_statement_repeat1] = STATE(1236),
    [sym_identifier] = ACTIONS(356),
    [anon_sym_export] = ACTIONS(358),
    [anon_sym_LBRACE] = ACTIONS(362),
    [anon_sym_import] = ACTIONS(366),
    [anon_sym_let] = ACTIONS(358),
    [anon_sym_LPAREN] = ACTIONS(368),
    [anon_sym_await] = ACTIONS(370),
    [anon_sym_yield] = ACTIONS(374),
    [anon_sym_LBRACK] = ACTIONS(376),
    [sym_glimmer_opening_tag] = ACTIONS(378),
    [anon_sym_LT] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(382),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_class] = ACTIONS(386),
    [anon_sym_async] = ACTIONS(388),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(392),
    [anon_sym_PLUS] = ACTIONS(394),
    [anon_sym_DASH] = ACTIONS(394),
    [anon_sym_SLASH] = ACTIONS(396),
    [anon_sym_BANG] = ACTIONS(398),
    [anon_sym_TILDE] = ACTIONS(398),
    [anon_sym_typeof] = ACTIONS(394),
    [anon_sym_void] = ACTIONS(394)