// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteLogTargetDefaultsAcceptedCode is the HTTP code returned for type DeleteLogTargetDefaultsAccepted
const DeleteLogTargetDefaultsAcceptedCode int = 202

/*
DeleteLogTargetDefaultsAccepted Configuration change accepted and reload requested

swagger:response deleteLogTargetDefaultsAccepted
*/
type DeleteLogTargetDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteLogTargetDefaultsAccepted creates DeleteLogTargetDefaultsAccepted with default headers values
func NewDeleteLogTargetDefaultsAccepted() *DeleteLogTargetDefaultsAccepted {

	return &DeleteLogTargetDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the delete log target defaults accepted response
func (o *DeleteLogTargetDefaultsAccepted) WithReloadID(reloadID string) *DeleteLogTargetDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete log target defaults accepted response
func (o *DeleteLogTargetDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteLogTargetDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteLogTargetDefaultsNoContentCode is the HTTP code returned for type DeleteLogTargetDefaultsNoContent
const DeleteLogTargetDefaultsNoContentCode int = 204

/*
DeleteLogTargetDefaultsNoContent Log Target deleted

swagger:response deleteLogTargetDefaultsNoContent
*/
type DeleteLogTargetDefaultsNoContent struct {
}

// NewDeleteLogTargetDefaultsNoContent creates DeleteLogTargetDefaultsNoContent with default headers values
func NewDeleteLogTargetDefaultsNoContent() *DeleteLogTargetDefaultsNoContent {

	return &DeleteLogTargetDefaultsNoContent{}
}

// WriteResponse to the client
func (o *DeleteLogTargetDefaultsNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteLogTargetDefaultsNotFoundCode is the HTTP code returned for type DeleteLogTargetDefaultsNotFound
const DeleteLogTargetDefaultsNotFoundCode int = 404

/*
DeleteLogTargetDefaultsNotFound The specified resource was not found

swagger:response deleteLogTargetDefaultsNotFound
*/
type DeleteLogTargetDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetDefaultsNotFound creates DeleteLogTargetDefaultsNotFound with default headers values
func NewDeleteLogTargetDefaultsNotFound() *DeleteLogTargetDefaultsNotFound {

	return &DeleteLogTargetDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete log target defaults not found response
func (o *DeleteLogTargetDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target defaults not found response
func (o *DeleteLogTargetDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target defaults not found response
func (o *DeleteLogTargetDefaultsNotFound) WithPayload(payload *models.Error) *DeleteLogTargetDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target defaults not found response
func (o *DeleteLogTargetDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteLogTargetDefaultsDefault General Error

swagger:response deleteLogTargetDefaultsDefault
*/
type DeleteLogTargetDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetDefaultsDefault creates DeleteLogTargetDefaultsDefault with default headers values
func NewDeleteLogTargetDefaultsDefault(code int) *DeleteLogTargetDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteLogTargetDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete log target defaults default response
func (o *DeleteLogTargetDefaultsDefault) WithStatusCode(code int) *DeleteLogTargetDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete log target defaults default response
func (o *DeleteLogTargetDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete log target defaults default response
func (o *DeleteLogTargetDefaultsDefault) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target defaults default response
func (o *DeleteLogTargetDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target defaults default response
func (o *DeleteLogTargetDefaultsDefault) WithPayload(payload *models.Error) *DeleteLogTargetDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target defaults default response
func (o *DeleteLogTargetDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
