// Copyright (c) 2012 Ecma International.  All rights reserved.
// Ecma International makes this code available under the terms and conditions set
// forth on http://hg.ecmascript.org/tests/test262/raw-file/tip/LICENSE (the
// "Use Terms").   Any redistribution of this code must retain the above
// copyright and this notice and otherwise comply with the Use Terms.

/*---
es5id: 15.2.3.6-4-71
description: >
    Object.defineProperty - both desc.value and name.value are Ojbects
    which refer to the same Object (8.12.9 step 6)
includes: [propertyHelper.js]
---*/


var obj = {};

var obj1 = { length: 10 };

Object.defineProperty(obj, "foo", { value: obj1 });

Object.defineProperty(obj, "foo", { value: obj1 });
verifyEqualTo(obj, "foo", obj1);

verifyNotWritable(obj, "foo");

verifyNotEnumerable(obj, "foo");

verifyNotConfigurable(obj, "foo");

