// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/cloudcontrolspartner/v1/core.proto

#include "google/cloud/cloudcontrolspartner/v1/internal/cloud_controls_partner_core_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/cloudcontrolspartner/v1/core.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudcontrolspartner_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudControlsPartnerCoreStub::~CloudControlsPartnerCoreStub() = default;

StatusOr<google::cloud::cloudcontrolspartner::v1::Workload>
DefaultCloudControlsPartnerCoreStub::GetWorkload(
    grpc::ClientContext& context, Options const&,
    google::cloud::cloudcontrolspartner::v1::GetWorkloadRequest const&
        request) {
  google::cloud::cloudcontrolspartner::v1::Workload response;
  auto status = grpc_stub_->GetWorkload(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::cloudcontrolspartner::v1::ListWorkloadsResponse>
DefaultCloudControlsPartnerCoreStub::ListWorkloads(
    grpc::ClientContext& context, Options const&,
    google::cloud::cloudcontrolspartner::v1::ListWorkloadsRequest const&
        request) {
  google::cloud::cloudcontrolspartner::v1::ListWorkloadsResponse response;
  auto status = grpc_stub_->ListWorkloads(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Customer>
DefaultCloudControlsPartnerCoreStub::GetCustomer(
    grpc::ClientContext& context, Options const&,
    google::cloud::cloudcontrolspartner::v1::GetCustomerRequest const&
        request) {
  google::cloud::cloudcontrolspartner::v1::Customer response;
  auto status = grpc_stub_->GetCustomer(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::cloudcontrolspartner::v1::ListCustomersResponse>
DefaultCloudControlsPartnerCoreStub::ListCustomers(
    grpc::ClientContext& context, Options const&,
    google::cloud::cloudcontrolspartner::v1::ListCustomersRequest const&
        request) {
  google::cloud::cloudcontrolspartner::v1::ListCustomersResponse response;
  auto status = grpc_stub_->ListCustomers(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::cloudcontrolspartner::v1::EkmConnections>
DefaultCloudControlsPartnerCoreStub::GetEkmConnections(
    grpc::ClientContext& context, Options const&,
    google::cloud::cloudcontrolspartner::v1::GetEkmConnectionsRequest const&
        request) {
  google::cloud::cloudcontrolspartner::v1::EkmConnections response;
  auto status = grpc_stub_->GetEkmConnections(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::cloudcontrolspartner::v1::PartnerPermissions>
DefaultCloudControlsPartnerCoreStub::GetPartnerPermissions(
    grpc::ClientContext& context, Options const&,
    google::cloud::cloudcontrolspartner::v1::GetPartnerPermissionsRequest const&
        request) {
  google::cloud::cloudcontrolspartner::v1::PartnerPermissions response;
  auto status = grpc_stub_->GetPartnerPermissions(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<
    google::cloud::cloudcontrolspartner::v1::ListAccessApprovalRequestsResponse>
DefaultCloudControlsPartnerCoreStub::ListAccessApprovalRequests(
    grpc::ClientContext& context, Options const&,
    google::cloud::cloudcontrolspartner::v1::
        ListAccessApprovalRequestsRequest const& request) {
  google::cloud::cloudcontrolspartner::v1::ListAccessApprovalRequestsResponse
      response;
  auto status =
      grpc_stub_->ListAccessApprovalRequests(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::cloudcontrolspartner::v1::Partner>
DefaultCloudControlsPartnerCoreStub::GetPartner(
    grpc::ClientContext& context, Options const&,
    google::cloud::cloudcontrolspartner::v1::GetPartnerRequest const& request) {
  google::cloud::cloudcontrolspartner::v1::Partner response;
  auto status = grpc_stub_->GetPartner(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudcontrolspartner_v1_internal
}  // namespace cloud
}  // namespace google
