// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/storagetransfer/v1/transfer.proto

#include "google/cloud/storagetransfer/v1/internal/storage_transfer_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace storagetransfer_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

StorageTransferServiceTracingStub::StorageTransferServiceTracingStub(
    std::shared_ptr<StorageTransferServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::storagetransfer::v1::GoogleServiceAccount>
StorageTransferServiceTracingStub::GetGoogleServiceAccount(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::GetGoogleServiceAccountRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.storagetransfer.v1.StorageTransferService",
                             "GetGoogleServiceAccount");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->GetGoogleServiceAccount(context, options, request));
}

StatusOr<google::storagetransfer::v1::TransferJob>
StorageTransferServiceTracingStub::CreateTransferJob(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::CreateTransferJobRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "CreateTransferJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateTransferJob(context, options, request));
}

StatusOr<google::storagetransfer::v1::TransferJob>
StorageTransferServiceTracingStub::UpdateTransferJob(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::UpdateTransferJobRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "UpdateTransferJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateTransferJob(context, options, request));
}

StatusOr<google::storagetransfer::v1::TransferJob>
StorageTransferServiceTracingStub::GetTransferJob(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::GetTransferJobRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "GetTransferJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetTransferJob(context, options, request));
}

StatusOr<google::storagetransfer::v1::ListTransferJobsResponse>
StorageTransferServiceTracingStub::ListTransferJobs(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::ListTransferJobsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "ListTransferJobs");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTransferJobs(context, options, request));
}

Status StorageTransferServiceTracingStub::PauseTransferOperation(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::PauseTransferOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.storagetransfer.v1.StorageTransferService",
                             "PauseTransferOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->PauseTransferOperation(context, options, request));
}

Status StorageTransferServiceTracingStub::ResumeTransferOperation(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::ResumeTransferOperationRequest const&
        request) {
  auto span =
      internal::MakeSpanGrpc("google.storagetransfer.v1.StorageTransferService",
                             "ResumeTransferOperation");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ResumeTransferOperation(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
StorageTransferServiceTracingStub::AsyncRunTransferJob(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::storagetransfer::v1::RunTransferJobRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "RunTransferJob");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncRunTransferJob(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
StorageTransferServiceTracingStub::RunTransferJob(
    grpc::ClientContext& context, Options options,
    google::storagetransfer::v1::RunTransferJobRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "RunTransferJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RunTransferJob(context, options, request));
}

Status StorageTransferServiceTracingStub::DeleteTransferJob(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::DeleteTransferJobRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "DeleteTransferJob");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteTransferJob(context, options, request));
}

StatusOr<google::storagetransfer::v1::AgentPool>
StorageTransferServiceTracingStub::CreateAgentPool(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::CreateAgentPoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "CreateAgentPool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateAgentPool(context, options, request));
}

StatusOr<google::storagetransfer::v1::AgentPool>
StorageTransferServiceTracingStub::UpdateAgentPool(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::UpdateAgentPoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "UpdateAgentPool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateAgentPool(context, options, request));
}

StatusOr<google::storagetransfer::v1::AgentPool>
StorageTransferServiceTracingStub::GetAgentPool(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::GetAgentPoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "GetAgentPool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAgentPool(context, options, request));
}

StatusOr<google::storagetransfer::v1::ListAgentPoolsResponse>
StorageTransferServiceTracingStub::ListAgentPools(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::ListAgentPoolsRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "ListAgentPools");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAgentPools(context, options, request));
}

Status StorageTransferServiceTracingStub::DeleteAgentPool(
    grpc::ClientContext& context, Options const& options,
    google::storagetransfer::v1::DeleteAgentPoolRequest const& request) {
  auto span = internal::MakeSpanGrpc(
      "google.storagetransfer.v1.StorageTransferService", "DeleteAgentPool");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteAgentPool(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
StorageTransferServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> StorageTransferServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<StorageTransferServiceStub>
MakeStorageTransferServiceTracingStub(
    std::shared_ptr<StorageTransferServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<StorageTransferServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace storagetransfer_v1_internal
}  // namespace cloud
}  // namespace google
