// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/reservation/v1/reservation.proto

#include "google/cloud/bigquery/reservation/v1/reservation_connection.h"
#include "google/cloud/bigquery/reservation/v1/internal/reservation_connection_impl.h"
#include "google/cloud/bigquery/reservation/v1/internal/reservation_option_defaults.h"
#include "google/cloud/bigquery/reservation/v1/internal/reservation_stub_factory.h"
#include "google/cloud/bigquery/reservation/v1/internal/reservation_tracing_connection.h"
#include "google/cloud/bigquery/reservation/v1/reservation_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_reservation_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ReservationServiceConnection::~ReservationServiceConnection() = default;

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceConnection::CreateReservation(
    google::cloud::bigquery::reservation::v1::CreateReservationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceConnection::ListReservations(
    google::cloud::bigquery::reservation::v1::
        ListReservationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::reservation::v1::Reservation>>();
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceConnection::GetReservation(
    google::cloud::bigquery::reservation::v1::GetReservationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ReservationServiceConnection::DeleteReservation(
    google::cloud::bigquery::reservation::v1::DeleteReservationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
ReservationServiceConnection::UpdateReservation(
    google::cloud::bigquery::reservation::v1::UpdateReservationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnection::CreateCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        CreateCapacityCommitmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnection::ListCapacityCommitments(
    google::cloud::bigquery::reservation::v1::
        ListCapacityCommitmentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<StreamRange<
      google::cloud::bigquery::reservation::v1::CapacityCommitment>>();
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnection::GetCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        GetCapacityCommitmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ReservationServiceConnection::DeleteCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        DeleteCapacityCommitmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnection::UpdateCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        UpdateCapacityCommitmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<
    google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>
ReservationServiceConnection::SplitCapacityCommitment(
    google::cloud::bigquery::reservation::v1::
        SplitCapacityCommitmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
ReservationServiceConnection::MergeCapacityCommitments(
    google::cloud::bigquery::reservation::v1::
        MergeCapacityCommitmentsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnection::CreateAssignment(
    google::cloud::bigquery::reservation::v1::CreateAssignmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnection::ListAssignments(
    google::cloud::bigquery::reservation::v1::
        ListAssignmentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::reservation::v1::Assignment>>();
}

Status ReservationServiceConnection::DeleteAssignment(
    google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnection::SearchAssignments(
    google::cloud::bigquery::reservation::v1::
        SearchAssignmentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::reservation::v1::Assignment>>();
}

StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnection::SearchAllAssignments(
    google::cloud::bigquery::reservation::v1::
        SearchAllAssignmentsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::reservation::v1::Assignment>>();
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnection::MoveAssignment(
    google::cloud::bigquery::reservation::v1::MoveAssignmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
ReservationServiceConnection::UpdateAssignment(
    google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
ReservationServiceConnection::GetBiReservation(
    google::cloud::bigquery::reservation::v1::GetBiReservationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
ReservationServiceConnection::UpdateBiReservation(
    google::cloud::bigquery::reservation::v1::
        UpdateBiReservationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<ReservationServiceConnection> MakeReservationServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ReservationServicePolicyOptionList>(options,
                                                                     __func__);
  options = bigquery_reservation_v1_internal::ReservationServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto stub =
      bigquery_reservation_v1_internal::CreateDefaultReservationServiceStub(
          background->cq(), options);
  return bigquery_reservation_v1_internal::
      MakeReservationServiceTracingConnection(
          std::make_shared<bigquery_reservation_v1_internal::
                               ReservationServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_reservation_v1
}  // namespace cloud
}  // namespace google
