// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

#include "google/cloud/contactcenterinsights/v1/internal/contact_center_insights_option_defaults.h"
#include "google/cloud/contactcenterinsights/v1/contact_center_insights_connection.h"
#include "google/cloud/contactcenterinsights/v1/contact_center_insights_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>

namespace google {
namespace cloud {
namespace contactcenterinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options ContactCenterInsightsDefaultOptions(Options options) {
  options = google::cloud::internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_CONTACT_CENTER_INSIGHTS_ENDPOINT",
      "", "GOOGLE_CLOUD_CPP_CONTACT_CENTER_INSIGHTS_AUTHORITY",
      "contactcenterinsights.googleapis.com");
  options =
      google::cloud::internal::PopulateGrpcOptions(std::move(options), "");
  if (!options.has<
          contactcenterinsights_v1::ContactCenterInsightsRetryPolicyOption>()) {
    options.set<
        contactcenterinsights_v1::ContactCenterInsightsRetryPolicyOption>(
        contactcenterinsights_v1::ContactCenterInsightsLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<contactcenterinsights_v1::
                       ContactCenterInsightsBackoffPolicyOption>()) {
    options.set<
        contactcenterinsights_v1::ContactCenterInsightsBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<contactcenterinsights_v1::
                       ContactCenterInsightsPollingPolicyOption>()) {
    options.set<
        contactcenterinsights_v1::ContactCenterInsightsPollingPolicyOption>(
        GenericPollingPolicy<
            contactcenterinsights_v1::ContactCenterInsightsRetryPolicyOption::
                Type,
            contactcenterinsights_v1::ContactCenterInsightsBackoffPolicyOption::
                Type>(
            options
                .get<contactcenterinsights_v1::
                         ContactCenterInsightsRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options
           .has<contactcenterinsights_v1::
                    ContactCenterInsightsConnectionIdempotencyPolicyOption>()) {
    options.set<contactcenterinsights_v1::
                    ContactCenterInsightsConnectionIdempotencyPolicyOption>(
        contactcenterinsights_v1::
            MakeDefaultContactCenterInsightsConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contactcenterinsights_v1_internal
}  // namespace cloud
}  // namespace google
