/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class FindText
extends EDialog {
    private static Preferences prefs = Preferences.userNodeForPackage(FindText.class);
    private static Pref prefCaseSensitive = Pref.makeBooleanPref("FindText_caseSensitive", prefs, false);
    private static Pref prefFindTextMessage = Pref.makeStringPref("FindText_findTextMessage", prefs, "");
    private static Pref prefReplaceTextMessage = Pref.makeStringPref("FindText_ReplaceTextMessage", prefs, "");
    private static Pref prefFindReverse = Pref.makeBooleanPref("FindText_findReverse", prefs, false);
    private static Pref prefRegExp = Pref.makeBooleanPref("FindText_regExp", prefs, false);
    private static Pref prefSearchNodeNames = Pref.makeBooleanPref("FindText_searchNodeNames", prefs, true);
    private static Pref prefSearchNodeVars = Pref.makeBooleanPref("FindText_searchNodeVars", prefs, true);
    private static Pref prefSearchArcNames = Pref.makeBooleanPref("FindText_searchArcNames", prefs, true);
    private static Pref prefSearchArcVars = Pref.makeBooleanPref("FindText_searchArcVars", prefs, true);
    private static Pref prefSearchExportNames = Pref.makeBooleanPref("FindText_searchExportNames", prefs, true);
    private static Pref prefSearchExportVars = Pref.makeBooleanPref("FindText_searchExportVars", prefs, true);
    private static Pref prefSearchCellVars = Pref.makeBooleanPref("FindText_searchCellVars", prefs, true);
    private static Pref prefSearchTempNames = Pref.makeBooleanPref("FindText_searchTempNames", prefs, false);
    private String lastSearch = null;
    private JButton Done;
    private JCheckBox caseSensitive;
    private JButton find;
    private JCheckBox findReverse;
    private JTextField findString;
    private JButton goToLine;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JTextField lineNumber;
    private JCheckBox regExp;
    private JButton replace;
    private JButton replaceAll;
    private JButton replaceAndFind;
    private JTextField replaceString;
    private JCheckBox searchArcNames;
    private JCheckBox searchArcVars;
    private JCheckBox searchCellVars;
    private JCheckBox searchExportNames;
    private JCheckBox searchExportVars;
    private JCheckBox searchNodeNames;
    private JCheckBox searchNodeVars;
    private JCheckBox searchTempNames;
    private JPanel whatToSearch;

    public static void findTextDialog() {
        FindText dialog = new FindText((Frame)TopLevel.getCurrentJFrame(), false);
        dialog.setVisible(true);
    }

    private FindText(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.findString.setText(prefFindTextMessage.getString());
        this.replaceString.setText(prefReplaceTextMessage.getString());
        this.caseSensitive.setSelected(prefCaseSensitive.getBoolean());
        this.findReverse.setSelected(prefFindReverse.getBoolean());
        this.regExp.setSelected(prefRegExp.getBoolean());
        this.searchNodeNames.setSelected(prefSearchNodeNames.getBoolean());
        this.searchNodeVars.setSelected(prefSearchNodeVars.getBoolean());
        this.searchArcNames.setSelected(prefSearchArcNames.getBoolean());
        this.searchArcVars.setSelected(prefSearchArcVars.getBoolean());
        this.searchExportNames.setSelected(prefSearchExportNames.getBoolean());
        this.searchExportVars.setSelected(prefSearchExportVars.getBoolean());
        this.searchCellVars.setSelected(prefSearchCellVars.getBoolean());
        this.searchTempNames.setSelected(prefSearchTempNames.getBoolean());
        this.getRootPane().setDefaultButton(this.find);
        this.finishInitialization();
    }

    private boolean badRegExpSyntax() {
        if (!this.regExp.isSelected()) {
            return false;
        }
        try {
            Pattern.compile(this.findString.getText());
            return false;
        }
        catch (Exception e) {
            System.out.println("Regular Expression error in Find string. Operation aborted.");
            return true;
        }
    }

    private Set getWhatToSearch() {
        HashSet<WhatToSearch> whatToSearch = new HashSet<WhatToSearch>();
        if (this.searchNodeNames.isSelected()) {
            whatToSearch.add(WhatToSearch.NODE_NAME);
        }
        if (this.searchNodeVars.isSelected()) {
            whatToSearch.add(WhatToSearch.NODE_VAR);
        }
        if (this.searchArcNames.isSelected()) {
            whatToSearch.add(WhatToSearch.ARC_NAME);
        }
        if (this.searchArcVars.isSelected()) {
            whatToSearch.add(WhatToSearch.ARC_VAR);
        }
        if (this.searchExportNames.isSelected()) {
            whatToSearch.add(WhatToSearch.EXPORT_NAME);
        }
        if (this.searchExportVars.isSelected()) {
            whatToSearch.add(WhatToSearch.EXPORT_VAR);
        }
        if (this.searchCellVars.isSelected()) {
            whatToSearch.add(WhatToSearch.CELL_VAR);
        }
        if (this.searchTempNames.isSelected()) {
            whatToSearch.add(WhatToSearch.TEMP_NAMES);
        }
        return whatToSearch;
    }

    protected void escapePressed() {
        this.doneActionPerformed(null);
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.Done = new JButton();
        this.findString = new JTextField();
        this.jLabel1 = new JLabel();
        this.replaceString = new JTextField();
        this.caseSensitive = new JCheckBox();
        this.findReverse = new JCheckBox();
        this.replace = new JButton();
        this.replaceAndFind = new JButton();
        this.replaceAll = new JButton();
        this.jLabel2 = new JLabel();
        this.lineNumber = new JTextField();
        this.find = new JButton();
        this.goToLine = new JButton();
        this.regExp = new JCheckBox();
        this.whatToSearch = new JPanel();
        this.searchNodeNames = new JCheckBox();
        this.searchNodeVars = new JCheckBox();
        this.searchArcNames = new JCheckBox();
        this.searchArcVars = new JCheckBox();
        this.searchExportNames = new JCheckBox();
        this.searchExportVars = new JCheckBox();
        this.searchCellVars = new JCheckBox();
        this.searchTempNames = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Search and Replace");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FindText.this.closeDialog(evt);
            }
        });
        this.jLabel4.setText("Find:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.Done.setText("Done");
        this.Done.setActionCommand("done");
        this.Done.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.doneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.Done, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findString, gridBagConstraints);
        this.jLabel1.setText("Line Number:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceString, gridBagConstraints);
        this.caseSensitive.setText("Case Sensitive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.caseSensitive, gridBagConstraints);
        this.findReverse.setText("Find Reverse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findReverse, gridBagConstraints);
        this.replace.setText("Replace");
        this.replace.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replace, gridBagConstraints);
        this.replaceAndFind.setText("Replace and Find");
        this.replaceAndFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceAndFindActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceAndFind, gridBagConstraints);
        this.replaceAll.setText("Replace All");
        this.replaceAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.replaceAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceAll, gridBagConstraints);
        this.jLabel2.setText("Replace:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.lineNumber.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.lineNumber, gridBagConstraints);
        this.find.setText("Find");
        this.find.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.findActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.find, gridBagConstraints);
        this.goToLine.setText("Go To Line");
        this.goToLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindText.this.goToLineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.goToLine, gridBagConstraints);
        this.regExp.setText("Regular Expressions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.regExp, gridBagConstraints);
        this.whatToSearch.setLayout(new GridBagLayout());
        this.whatToSearch.setBorder(new TitledBorder("Objects to Search"));
        this.searchNodeNames.setText("Node Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchNodeNames, gridBagConstraints);
        this.searchNodeVars.setText("Node Variables");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchNodeVars, gridBagConstraints);
        this.searchArcNames.setText("Arc Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchArcNames, gridBagConstraints);
        this.searchArcVars.setText("Arc Variables");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchArcVars, gridBagConstraints);
        this.searchExportNames.setText("Export Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchExportNames, gridBagConstraints);
        this.searchExportVars.setText("Export Variables");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchExportVars, gridBagConstraints);
        this.searchCellVars.setText("Cell Variables");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.whatToSearch.add((Component)this.searchCellVars, gridBagConstraints);
        this.searchTempNames.setText("Automatically Generated Node and Arc Names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        this.whatToSearch.add((Component)this.searchTempNames, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        this.getContentPane().add((Component)this.whatToSearch, gridBagConstraints);
        this.pack();
    }

    private void doneActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void goToLineActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        WindowContent content = wf.getContent();
        if (content instanceof TextWindow) {
            TextWindow tw = (TextWindow)content;
            int i = TextUtils.atoi(this.lineNumber.getText());
            tw.goToLineNumber(i);
            return;
        }
        System.out.println("Cannot access this window by line numbers");
    }

    private void replaceAllActionPerformed(ActionEvent evt) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        String search = this.findString.getText();
        String replace = this.replaceString.getText();
        WindowContent content = wf.getContent();
        content.initTextSearch(search, this.caseSensitive.isSelected(), this.regExp.isSelected(), this.getWhatToSearch());
        content.replaceAllText(replace);
    }

    private void replaceAndFindActionPerformed(ActionEvent evt) {
        if (this.badRegExpSyntax()) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (this.lastSearch == null) {
            return;
        }
        WindowContent content = wf.getContent();
        content.replaceText(this.replaceString.getText());
        if (!content.findNextText(this.findReverse.isSelected())) {
            this.lastSearch = null;
        }
    }

    private void replaceActionPerformed(ActionEvent evt) {
        if (this.badRegExpSyntax()) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        if (this.lastSearch == null) {
            return;
        }
        WindowContent content = wf.getContent();
        content.replaceText(this.replaceString.getText());
    }

    private void findActionPerformed(ActionEvent evt) {
        if (this.badRegExpSyntax()) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        String search = this.findString.getText();
        WindowContent content = wf.getContent();
        if (this.lastSearch != null && !this.lastSearch.equals(search)) {
            this.lastSearch = null;
        }
        if (this.lastSearch == null) {
            content.initTextSearch(search, this.caseSensitive.isSelected(), this.regExp.isSelected(), this.getWhatToSearch());
        }
        this.lastSearch = search;
        if (!content.findNextText(this.findReverse.isSelected())) {
            this.lastSearch = null;
        }
    }

    private void closeDialog(WindowEvent evt) {
        prefFindTextMessage.setString(this.findString.getText());
        prefReplaceTextMessage.setString(this.replaceString.getText());
        prefCaseSensitive.setBoolean(this.caseSensitive.isSelected());
        prefFindReverse.setBoolean(this.findReverse.isSelected());
        prefRegExp.setBoolean(this.regExp.isSelected());
        prefSearchNodeNames.setBoolean(this.searchNodeNames.isSelected());
        prefSearchNodeVars.setBoolean(this.searchNodeVars.isSelected());
        prefSearchArcNames.setBoolean(this.searchArcNames.isSelected());
        prefSearchArcVars.setBoolean(this.searchArcVars.isSelected());
        prefSearchExportNames.setBoolean(this.searchExportNames.isSelected());
        prefSearchExportVars.setBoolean(this.searchExportVars.isSelected());
        prefSearchCellVars.setBoolean(this.searchCellVars.isSelected());
        prefSearchTempNames.setBoolean(this.searchTempNames.isSelected());
        this.setVisible(false);
        this.dispose();
    }

    public static class WhatToSearch {
        public static final WhatToSearch ARC_NAME = new WhatToSearch("Arc Name");
        public static final WhatToSearch ARC_VAR = new WhatToSearch("Arc Variable");
        public static final WhatToSearch NODE_NAME = new WhatToSearch("Node Name");
        public static final WhatToSearch NODE_VAR = new WhatToSearch("Node Variable");
        public static final WhatToSearch EXPORT_NAME = new WhatToSearch("Export Name");
        public static final WhatToSearch EXPORT_VAR = new WhatToSearch("Export Variable");
        public static final WhatToSearch CELL_VAR = new WhatToSearch("Cell Name");
        public static final WhatToSearch TEMP_NAMES = new WhatToSearch(null);
        private String descriptionOfObjectFound;

        private WhatToSearch(String descriptionOfObjectFound) {
            this.descriptionOfObjectFound = descriptionOfObjectFound;
        }

        public String toString() {
            return this.descriptionOfObjectFound;
        }
    }
}

