/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LayoutText
extends EDialog {
    private static int lastSize = 12;
    private static double lastScale = 1.0;
    private static double lastSeparation = 0.0;
    private static boolean lastItalic = false;
    private static boolean lastBold = false;
    private static boolean lastUnderline = false;
    private static String lastFont = User.getDefaultFont();
    private static String lastLayer = null;
    private static String lastMessage = null;
    private JButton cancel;
    private JTextField dotSeparation;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JButton ok;
    private JCheckBox textBold;
    private JComboBox textFont;
    private JCheckBox textItalic;
    private JComboBox textLayer;
    private JTextArea textMessage;
    private JTextField textScale;
    private JTextField textSize;
    private JCheckBox textUnderline;

    public LayoutText(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.textSize.setText(Integer.toString(lastSize));
        this.textScale.setText(TextUtils.formatDouble(lastScale));
        this.dotSeparation.setText(TextUtils.formatDouble(lastSeparation));
        this.textItalic.setSelected(lastItalic);
        this.textBold.setSelected(lastBold);
        this.textUnderline.setSelected(lastUnderline);
        Iterator it = Technology.getCurrent().getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            if (np.getFunction() != PrimitiveNode.Function.NODE) continue;
            this.textLayer.addItem(np.getName());
        }
        if (lastLayer != null) {
            this.textLayer.setSelectedItem(lastLayer);
        }
        if (lastMessage != null) {
            this.textMessage.setText(lastMessage);
        }
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            this.textFont.addItem(fonts[i].getFontName());
        }
        if (lastFont != null) {
            this.textFont.setSelectedItem(lastFont);
        }
        this.textFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.updateMessageField();
            }
        });
        this.textItalic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.updateMessageField();
            }
        });
        this.textBold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.updateMessageField();
            }
        });
        this.textSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.updateMessageField();
            }
        });
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    private void updateMessageField() {
        int size;
        Font theFont;
        String fontName = (String)this.textFont.getSelectedItem();
        int fontStyle = 0;
        if (this.textItalic.isSelected()) {
            fontStyle |= 2;
        }
        if (this.textBold.isSelected()) {
            fontStyle |= 1;
        }
        if ((theFont = new Font(fontName, fontStyle, size = TextUtils.atoi(this.textSize.getText()))) != null) {
            this.textMessage.setFont(theFont);
        }
    }

    private void makeLayoutText(String layer, int tsize, double scale, String font, boolean italic, boolean bold, boolean underline, double separation, String msg) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        String nodeName = (String)this.textLayer.getSelectedItem();
        PrimitiveNode primNode = Technology.getCurrent().findNodeProto(nodeName);
        if (primNode == null) {
            System.out.println("Cannot find " + nodeName + " primitive");
            return;
        }
        int yOffset = 0;
        String[] strings = msg.split("\n");
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            Raster ras = PixelDrawing.renderText(str, font, tsize, italic, bold, underline, -1, -1);
            if (ras == null) {
                return;
            }
            DataBufferByte dbb = (DataBufferByte)ras.getDataBuffer();
            byte[] samples = dbb.getData();
            int samp = 0;
            for (int y = 0; y < ras.getHeight(); ++y) {
                for (int x = 0; x < ras.getWidth(); ++x) {
                    if (samples[samp++] == 0) continue;
                    Point2D.Double center = new Point2D.Double((double)x * scale, (double)(-(y + yOffset)) * scale);
                    double wid = scale - separation;
                    double hei = scale - separation;
                    NodeInst ni = NodeInst.newInstance(primNode, center, wid, hei, curCell);
                }
            }
            yOffset += ras.getHeight();
        }
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.textSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.textScale = new JTextField();
        this.jLabel3 = new JLabel();
        this.dotSeparation = new JTextField();
        this.jLabel4 = new JLabel();
        this.textFont = new JComboBox();
        this.textItalic = new JCheckBox();
        this.textBold = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.textLayer = new JComboBox();
        this.jLabel6 = new JLabel();
        this.textUnderline = new JCheckBox();
        this.textMessage = new JTextArea();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Make Layout Text");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LayoutText.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Size (max 63):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.textSize.setColumns(8);
        this.textSize.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textSize, gridBagConstraints);
        this.jLabel2.setText("Scale factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.textScale.setColumns(8);
        this.textScale.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textScale, gridBagConstraints);
        this.jLabel3.setText("Dot separation (units):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.dotSeparation.setColumns(8);
        this.dotSeparation.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.dotSeparation, gridBagConstraints);
        this.jLabel4.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textFont, gridBagConstraints);
        this.textItalic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textItalic, gridBagConstraints);
        this.textBold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textBold, gridBagConstraints);
        this.jLabel5.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textLayer, gridBagConstraints);
        this.jLabel6.setText("Message:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.textUnderline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.textUnderline, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textMessage, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        CreateLayoutText job = new CreateLayoutText(this);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.grabDialogValues();
        this.setVisible(false);
        this.dispose();
    }

    private void grabDialogValues() {
        lastSize = TextUtils.atoi(this.textSize.getText());
        lastScale = TextUtils.atof(this.textScale.getText());
        lastSeparation = TextUtils.atof(this.dotSeparation.getText());
        lastItalic = this.textItalic.isSelected();
        lastBold = this.textBold.isSelected();
        lastUnderline = this.textUnderline.isSelected();
        lastLayer = (String)this.textLayer.getSelectedItem();
        lastFont = (String)this.textFont.getSelectedItem();
        lastMessage = this.textMessage.getText();
    }

    private static class CreateLayoutText
    extends Job {
        LayoutText dialog;

        protected CreateLayoutText(LayoutText dialog) {
            super("Create Layout Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            this.dialog.grabDialogValues();
            this.dialog.makeLayoutText(lastLayer, lastSize, lastScale, lastFont, lastItalic, lastBold, lastUnderline, lastSeparation, lastMessage);
            return true;
        }
    }
}

