/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.LEFDEF;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.MutableBoolean;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LEF
extends LEFDEF {
    protected static final boolean PLACEGEOMETRY = true;
    protected static final boolean PLACEEXPORTS = true;
    protected static final boolean PLACEONLYMETAL = false;
    private LEFPreferences localPrefs;

    LEF(EditingPreferences ep, LEFPreferences ap) {
        super(ep);
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        this.initializeLEFDEF(tech);
        widthsFromLEF = new HashMap();
        this.initKeywordParsing();
        try {
            if (this.readFile(lib)) {
                return null;
            }
        }
        catch (IOException e) {
            this.reportError("ERROR reading LEF libraries", null);
        }
        return lib;
    }

    @Override
    protected String preprocessLine(String line) {
        int sharpPos = line.indexOf(35);
        if (sharpPos >= 0) {
            return line.substring(0, sharpPos);
        }
        return line;
    }

    private boolean readFile(Library lib) throws IOException {
        String key;
        while ((key = this.getAKeyword()) != null) {
            if (key.equalsIgnoreCase("LAYER") && this.readLayer()) {
                return true;
            }
            if (key.equalsIgnoreCase("MACRO") && this.readMacro(lib)) {
                return true;
            }
            if (key.equalsIgnoreCase("VIA") && this.readVia(lib)) {
                return true;
            }
            if (key.equalsIgnoreCase("VIARULE") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("ARRAY")) {
                String name = this.getAKeyword();
                this.ignoreToEnd(name, null);
                continue;
            }
            if (key.equalsIgnoreCase("SPACING") || key.equalsIgnoreCase("PROPERTYDEFINITIONS")) {
                this.ignoreToEnd(key, null);
                continue;
            }
            if (!key.equalsIgnoreCase("MINFEATURE")) continue;
            this.ignoreToSemicolon(key, null);
        }
        return false;
    }

    private boolean readVia(Library lib) throws IOException {
        String key;
        LEFDEF.GetLayerInformation viaLayer;
        LEFDEF.GetLayerInformation highMetalLayer;
        LEFDEF.GetLayerInformation lowMetalLayer;
        int rowColY;
        int rowColX;
        double bottomEnclosure;
        double topEnclosure;
        double rightEnclosure;
        double leftEnclosure;
        double cutSpacingY;
        double cutSpacingX;
        double cutSizeY;
        double cutSizeX;
        Cell cell;
        LEFDEF.ViaDef vd;
        block49: {
            String cellName;
            String viaName = this.getAKeyword();
            if (viaName == null) {
                return true;
            }
            vd = new LEFDEF.ViaDef(viaName, null);
            viaDefsFromLEF.put(viaName.toLowerCase(), vd);
            cell = null;
            if (!this.localPrefs.ignoreTechnology && (cell = this.createCell(lib, cellName = viaName + "{lay}")) == null) {
                this.reportError("Cannot create via cell '" + cellName + "'", null);
                return true;
            }
            boolean ignoreDefault = true;
            LEFDEF.GetLayerInformation li = null;
            cutSizeX = 0.0;
            cutSizeY = 0.0;
            cutSpacingX = 0.0;
            cutSpacingY = 0.0;
            leftEnclosure = 0.0;
            rightEnclosure = 0.0;
            topEnclosure = 0.0;
            bottomEnclosure = 0.0;
            rowColX = 0;
            rowColY = 0;
            lowMetalLayer = null;
            highMetalLayer = null;
            viaLayer = null;
            while (true) {
                if ((key = this.getAKeyword()) == null) {
                    return true;
                }
                if (ignoreDefault) {
                    ignoreDefault = false;
                    if (key.equalsIgnoreCase("DEFAULT")) continue;
                }
                if (key.equalsIgnoreCase("END")) break block49;
                if (key.equalsIgnoreCase("CUTSIZE")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    cutSizeX = this.convertLEFString(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    cutSizeY = this.convertLEFString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("CUTSPACING")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    cutSpacingX = this.convertLEFString(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    cutSpacingY = this.convertLEFString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("ENCLOSURE")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    leftEnclosure = this.convertLEFString(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    bottomEnclosure = this.convertLEFString(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    rightEnclosure = this.convertLEFString(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    topEnclosure = this.convertLEFString(key);
                    continue;
                }
                if (key.equalsIgnoreCase("ROWCOL")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    rowColX = TextUtils.atoi(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    rowColY = TextUtils.atoi(key);
                    continue;
                }
                if (key.equalsIgnoreCase("LAYERS")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    lowMetalLayer = this.getLayerInformation(key);
                    if (lowMetalLayer.pure == null) {
                        this.reportError("Layer " + key + " not found", cell);
                        return true;
                    }
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    viaLayer = this.getLayerInformation(key);
                    if (viaLayer.pure == null) {
                        this.reportError("Layer " + key + " not found", cell);
                        return true;
                    }
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    highMetalLayer = this.getLayerInformation(key);
                    if (highMetalLayer.pure != null) continue;
                    this.reportError("Layer " + key + " not found", cell);
                    return true;
                }
                if (key.equalsIgnoreCase("RESISTANCE")) {
                    if (!this.ignoreToSemicolon(key, cell)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("LAYER")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        return true;
                    }
                    li = this.getLayerInformation(key);
                    if (li.arc != null) {
                        if (vd.gLay1 == null) {
                            vd.gLay1 = li;
                        } else {
                            vd.gLay2 = li;
                        }
                    }
                    if (!this.ignoreToSemicolon("LAYER", cell)) continue;
                    return true;
                }
                if (!key.equalsIgnoreCase("RECT")) continue;
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double lX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double lY = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double hX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    return true;
                }
                double hY = this.convertLEFString(key);
                if (hX - lX > vd.sX) {
                    vd.sX = hX - lX;
                }
                if (hY - lY > vd.sY) {
                    vd.sY = hY - lY;
                }
                if (cell != null) {
                    double sY;
                    NodeProto np = li.pure;
                    if (np == null) {
                        this.reportError(" No layer '" + li.name + "' defined for RECT", cell);
                        return true;
                    }
                    Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                    double sX = Math.abs(hX - lX);
                    NodeInst ni = NodeInst.makeInstance(np, this.ep, ctr, sX, sY = Math.abs(hY - lY), cell);
                    if (ni == null) {
                        this.reportError("Cannot create node for RECT", cell);
                        return true;
                    }
                }
                if (this.ignoreToSemicolon("RECT", cell)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        if (cell != null) {
            Point2D.Double ctr = new Point2D.Double(0.0, 0.0);
            PrimitiveNode pnp = Generic.tech().universalPinNode;
            NodeInst ni = NodeInst.makeInstance(pnp, this.ep, ctr, pnp.getDefWidth(this.ep), pnp.getDefHeight(this.ep), cell);
            PortInst pi = ni.getOnlyPortInst();
            Export e = Export.newInstance(cell, pi, "viaPort", this.ep);
            if (vd.gLay1 != null && vd.gLay2 != null) {
                String[] preferredArcs = new String[]{vd.gLay1.arc.getFullName(), vd.gLay2.arc.getFullName()};
                e.newVar(Export.EXPORT_PREFERRED_ARCS, (Object)preferredArcs, this.ep);
            }
            if (rowColX > 0 && rowColY > 0 && lowMetalLayer != null && highMetalLayer != null && viaLayer != null) {
                double cutsWidth = (double)rowColX * cutSizeX + (double)(rowColX - 1) * cutSpacingX;
                double cutsHeight = (double)rowColY * cutSizeY + (double)(rowColY - 1) * cutSpacingY;
                for (int x2 = 0; x2 < rowColX; ++x2) {
                    for (int y = 0; y < rowColY; ++y) {
                        double xP = -cutsWidth / 2.0 + (double)x2 * (cutSizeX + cutSpacingX) + cutSizeX / 2.0;
                        double yP = -cutsHeight / 2.0 + (double)y * (cutSizeY + cutSpacingY) + cutSizeY / 2.0;
                        ni = NodeInst.makeInstance(viaLayer.pure, this.ep, EPoint.fromLambda(xP, yP), cutSizeX, cutSizeY, cell);
                        if (ni != null) continue;
                        return true;
                    }
                }
                double sX = cutsWidth + leftEnclosure + rightEnclosure;
                double sY = cutsHeight + topEnclosure + bottomEnclosure;
                double cX = (rightEnclosure - leftEnclosure) / 2.0;
                double cY = (topEnclosure - bottomEnclosure) / 2.0;
                EPoint metCtr = EPoint.fromLambda(cX, cY);
                ni = NodeInst.makeInstance(lowMetalLayer.pure, this.ep, metCtr, sX, sY, cell);
                if (ni == null) {
                    return true;
                }
                ni = NodeInst.makeInstance(highMetalLayer.pure, this.ep, metCtr, sX, sY, cell);
                if (ni == null) {
                    return true;
                }
            }
        }
        if (vd.gLay1 != null && vd.gLay2 != null) {
            Iterator<PrimitiveNode> it = this.curTech.getNodes();
            while (it.hasNext()) {
                PrimitivePort pp;
                PrimitiveNode np = it.next();
                if (!np.getFunction().isContact() || !(pp = np.getPort(0)).connectsTo(vd.gLay1.arc) || !pp.connectsTo(vd.gLay2.arc)) continue;
                vd.via = np;
                break;
            }
        }
        return false;
    }

    private Cell createCell(Library lib, String cellName) {
        Cell cell = Cell.makeInstance(this.ep, lib, cellName);
        if (cell == null) {
            this.reportError("Cannot create cell '" + cellName + "'", null);
            return null;
        }
        cell.setTechnology(this.curTech);
        return cell;
    }

    private boolean readMacro(Library lib) throws IOException {
        String key;
        block18: {
            Cell cell;
            block19: {
                String cellName = this.getAKeyword();
                if (cellName == null) {
                    this.reportError("EOF parsing MACRO header", null);
                    return true;
                }
                cell = this.createCell(lib, cellName = cellName + "{lay}");
                if (cell == null) {
                    return true;
                }
                while (true) {
                    if ((key = this.getAKeyword()) == null) {
                        this.reportError("EOF parsing MACRO", cell);
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block18;
                    if (key.equalsIgnoreCase("SOURCE") || key.equalsIgnoreCase("FOREIGN") || key.equalsIgnoreCase("SYMMETRY") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("CLASS") || key.equalsIgnoreCase("LEQ") || key.equalsIgnoreCase("POWER") || key.equalsIgnoreCase("PROPERTY")) {
                        if (!this.ignoreToSemicolon(key, cell)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("ORIGIN")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading ORIGIN X", cell);
                            return true;
                        }
                        double oX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading ORIGIN Y", cell);
                            return true;
                        }
                        double oY = this.convertLEFString(key);
                        if (this.ignoreToSemicolon("ORIGIN", cell)) {
                            return true;
                        }
                        Geometric ccNi = null;
                        Iterator<NodeInst> it = cell.getNodes();
                        while (it.hasNext()) {
                            NodeInst ni = it.next();
                            if (!Generic.isCellCenter(ni)) continue;
                            ccNi = ni;
                            break;
                        }
                        if (ccNi == null) {
                            double sY;
                            double sX = Generic.tech().cellCenterNode.getDefWidth(this.ep);
                            ccNi = NodeInst.makeInstance(Generic.tech().cellCenterNode, this.ep, new Point2D.Double(oX, oY), sX, sY = Generic.tech().cellCenterNode.getDefHeight(this.ep), cell);
                            if (ccNi == null) {
                                this.reportError("Cannot create cell center node", cell);
                                return true;
                            }
                            ((NodeInst)ccNi).setHardSelect();
                            ((NodeInst)ccNi).setVisInside();
                            continue;
                        }
                        double dX = oX - ccNi.getTrueCenterX();
                        double dY = oY - ccNi.getTrueCenterY();
                        ((NodeInst)ccNi).move(dX, dY);
                        continue;
                    }
                    if (key.equalsIgnoreCase("SIZE")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading SIZE X", cell);
                            return true;
                        }
                        double wid = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading SIZE 'BY'", cell);
                            return true;
                        }
                        if (!key.equalsIgnoreCase("BY")) {
                            this.reportError("Expected 'by' in SIZE", cell);
                            return true;
                        }
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading SIZE Y", cell);
                            return true;
                        }
                        double hei = this.convertLEFString(key);
                        cell.newVar(prXkey, (Object)new Double(wid), this.ep);
                        cell.newVar(prYkey, (Object)new Double(hei), this.ep);
                        if (!this.ignoreToSemicolon("SIZE", cell)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("PIN")) {
                        if (!this.readPin(cell)) continue;
                        return true;
                    }
                    if (!key.equalsIgnoreCase("OBS")) break block19;
                    if (this.readObs(cell)) break;
                }
                return true;
            }
            this.reportError("Unknown MACRO keyword (" + key + ")", cell);
            return true;
        }
        key = this.getAKeyword();
        return false;
    }

    private boolean readObs(Cell cell) throws IOException {
        NodeProto np = null;
        LEFDEF.GetLayerInformation li = null;
        while (true) {
            double sY;
            String key;
            if ((key = this.getAKeyword()) == null) {
                this.reportError("EOF parsing OBS", cell);
                return true;
            }
            if (key.equalsIgnoreCase("END")) break;
            if (key.equalsIgnoreCase("LAYER")) {
                key = this.getAKeyword();
                if (key == null) {
                    this.reportError("EOF reading LAYER clause", cell);
                    return true;
                }
                li = this.getLayerInformation(key);
                np = li.pure;
                if (li.layerFun == Layer.Function.UNKNOWN || np == null) {
                    this.reportError("Unknown layer name (" + key + ")", cell);
                    return true;
                }
                if (!this.ignoreToSemicolon("LAYER", cell)) continue;
                return true;
            }
            if (key.equalsIgnoreCase("RECT")) {
                double sY2;
                key = this.getAKeyword();
                if (key == null) {
                    this.reportError("EOF reading RECT low X", cell);
                    return true;
                }
                double lX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    this.reportError("EOF reading RECT low Y", cell);
                    return true;
                }
                double lY = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    this.reportError("EOF reading RECT high X", cell);
                    return true;
                }
                double hX = this.convertLEFString(key);
                key = this.getAKeyword();
                if (key == null) {
                    this.reportError("EOF reading RECT high Y", cell);
                    return true;
                }
                double hY = this.convertLEFString(key);
                if (this.ignoreToSemicolon("RECT", cell)) {
                    return true;
                }
                if (np == null) {
                    this.reportError("No layers for RECT", cell);
                    return true;
                }
                Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                double sX = Math.abs(hX - lX);
                NodeInst ni = NodeInst.makeInstance(np, this.ep, ctr, sX, sY2 = Math.abs(hY - lY), cell);
                if (ni != null) continue;
                this.reportError("Cannot create node for RECT", cell);
                return true;
            }
            if (!key.equalsIgnoreCase("POLYGON")) continue;
            List<Point2D> points = this.readPolygon(cell);
            if (points == null) {
                return true;
            }
            if (np == null) {
                this.reportError("No layers for POLYGON", cell);
                return true;
            }
            double lX = 0.0;
            double lY = 0.0;
            double hX = 0.0;
            double hY = 0.0;
            for (int i = 0; i < points.size(); ++i) {
                Point2D pt = points.get(i);
                if (i == 0) {
                    lX = hX = pt.getX();
                    lY = hY = pt.getY();
                    continue;
                }
                if (pt.getX() < lX) {
                    lX = pt.getX();
                }
                if (pt.getX() > hX) {
                    hX = pt.getX();
                }
                if (pt.getY() < lY) {
                    lY = pt.getY();
                }
                if (!(pt.getY() > hY)) continue;
                hY = pt.getY();
            }
            Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
            double sX = Math.abs(hX - lX);
            NodeInst ni = NodeInst.makeInstance(np, this.ep, ctr, sX, sY = Math.abs(hY - lY), cell);
            if (ni == null) {
                this.reportError("Cannot create pin for POLYGON", cell);
                return true;
            }
            Point2D[] outline = new Point2D[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                outline[i] = EPoint.fromLambda(points.get(i).getX() - ((Point2D)ctr).getX(), points.get(i).getY() - ((Point2D)ctr).getY());
            }
            ni.setTrace(outline);
        }
        return false;
    }

    private boolean readPin(Cell cell) throws IOException {
        MutableBoolean pinMade;
        String pinName;
        String key;
        block24: {
            block25: {
                key = this.getAKeyword();
                if (key == null) {
                    this.reportError("EOF parsing PIN name", cell);
                    return true;
                }
                pinName = key.replace('<', '[').replace('>', ']');
                pinMade = new MutableBoolean(false);
                PortCharacteristic useCharacteristics = PortCharacteristic.UNKNOWN;
                PortCharacteristic portCharacteristics = PortCharacteristic.UNKNOWN;
                while (true) {
                    if ((key = this.getAKeyword()) == null) {
                        this.reportError("EOF parsing PIN", cell);
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block24;
                    if (key.equalsIgnoreCase("SHAPE") || key.equalsIgnoreCase("CAPACITANCE") || key.equalsIgnoreCase("ANTENNASIZE") || key.equalsIgnoreCase("ANTENNADIFFAREA") || key.equalsIgnoreCase("ANTENNAMODEL") || key.equalsIgnoreCase("ANTENNAGATEAREA") || key.equalsIgnoreCase("ANTENNAPARTIALCUTAREA") || key.equalsIgnoreCase("ANTENNAMAXAREACAR") || key.equalsIgnoreCase("ANTENNAMAXCUTCAR") || key.equalsIgnoreCase("PROPERTY")) {
                        if (!this.ignoreToSemicolon(key, cell)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("USE")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading USE clause", cell);
                            return true;
                        }
                        if (key.equalsIgnoreCase("POWER")) {
                            useCharacteristics = PortCharacteristic.PWR;
                        } else if (key.equalsIgnoreCase("GROUND")) {
                            useCharacteristics = PortCharacteristic.GND;
                        } else if (key.equalsIgnoreCase("CLOCK")) {
                            useCharacteristics = PortCharacteristic.CLK;
                        } else if (!key.equalsIgnoreCase("SIGNAL") && !key.equalsIgnoreCase("DATA")) {
                            this.reportError("Unknown USE keyword (" + key + ")", cell);
                        }
                        if (!this.ignoreToSemicolon("USE", cell)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("DIRECTION")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading DIRECTION clause", cell);
                            return true;
                        }
                        if (key.equalsIgnoreCase("INPUT")) {
                            portCharacteristics = PortCharacteristic.IN;
                        } else if (key.equalsIgnoreCase("OUTPUT")) {
                            portCharacteristics = PortCharacteristic.OUT;
                        } else if (key.equalsIgnoreCase("INOUT")) {
                            portCharacteristics = PortCharacteristic.BIDIR;
                        } else {
                            this.reportError("Unknown DIRECTION keyword (" + key + ")", cell);
                        }
                        if (!this.ignoreToSemicolon("DIRECTION", cell)) continue;
                        return true;
                    }
                    if (!key.equalsIgnoreCase("PORT")) break block25;
                    if (useCharacteristics != PortCharacteristic.UNKNOWN) {
                        portCharacteristics = useCharacteristics;
                    }
                    if (this.readPort(cell, pinName, portCharacteristics, pinMade) && !this.localPrefs.continueReading) break;
                }
                return true;
            }
            this.reportError("Unknown PIN keyword (" + key + ")", cell);
            return true;
        }
        key = this.getAKeyword();
        if (!pinMade.booleanValue() && !this.localPrefs.ignoreUngeneratedPins) {
            PrimitiveNode pureNp = Generic.tech().universalPinNode;
            Point2D.Double ctr = new Point2D.Double(0.0, 0.0);
            double sX = 0.0;
            double sY = 0.0;
            NodeInst ni = NodeInst.makeInstance(pureNp, this.ep, ctr, sX, sY, cell);
            if (ni == null) {
                this.reportError("Cannot create universal pin for RECT", cell);
                return true;
            }
            this.newPort(cell, ni, pureNp.getPort(0), pinName);
            this.reportWarning("Pin " + pinName + " in macro " + cell.describe(false) + " has no location, presuming (0,0)", ni, cell);
        }
        return false;
    }

    private void reportError(String message, Cell cell) {
        String msg = "Error on line " + this.lineReader.getLineNumber() + ": " + message;
        System.out.println(msg);
        errorLogger.logError(msg, cell, 0);
    }

    private void reportWarning(String message, Geometric geom, Cell cell) {
        String msg = "Warning on line " + this.lineReader.getLineNumber() + ": " + message;
        System.out.println(msg);
        errorLogger.logWarning(msg, geom, cell, null, 0);
    }

    private boolean readPort(Cell cell, String portname, PortCharacteristic portCharacteristics, MutableBoolean pinMade) throws IOException {
        PrimitiveNode pin;
        Point2D.Double singlePathPoint;
        boolean first;
        LEFPath lefPaths;
        ArcProto ap;
        block53: {
            String key;
            block54: {
                ap = null;
                NodeProto pureNp = null;
                lefPaths = null;
                first = true;
                double intWidth = 0.0;
                double lastIntX = 0.0;
                double lastIntY = 0.0;
                singlePathPoint = null;
                LEFDEF.GetLayerInformation li = null;
                block0: while (true) {
                    double sY;
                    if ((key = this.getAKeyword()) == null) {
                        this.reportError("EOF parsing PORT", cell);
                        return true;
                    }
                    if (key.equalsIgnoreCase("END")) break block53;
                    if (key.equalsIgnoreCase("CLASS")) {
                        if (!this.ignoreToSemicolon("LAYER", cell)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("LAYER")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading LAYER clause", cell);
                            return true;
                        }
                        li = this.getLayerInformation(key);
                        ap = li.arc;
                        pureNp = li.pure;
                        if (!this.ignoreToSemicolon("LAYER", cell)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("WIDTH")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading WIDTH clause", cell);
                            return true;
                        }
                        intWidth = this.convertLEFString(key);
                        if (!this.ignoreToSemicolon("WIDTH", cell)) continue;
                        return true;
                    }
                    if (key.equalsIgnoreCase("POLYGON")) {
                        double sY2;
                        List<Point2D> points = this.readPolygon(cell);
                        if (points == null) {
                            return true;
                        }
                        if (pureNp == null) {
                            this.reportError("No layers for POLYGON", cell);
                            return true;
                        }
                        pinMade.setValue(true);
                        double lX = 0.0;
                        double lY = 0.0;
                        double hX = 0.0;
                        double hY = 0.0;
                        for (int i = 0; i < points.size(); ++i) {
                            Point2D pt = points.get(i);
                            if (i == 0) {
                                lX = hX = pt.getX();
                                lY = hY = pt.getY();
                                continue;
                            }
                            if (pt.getX() < lX) {
                                lX = pt.getX();
                            }
                            if (pt.getX() > hX) {
                                hX = pt.getX();
                            }
                            if (pt.getY() < lY) {
                                lY = pt.getY();
                            }
                            if (!(pt.getY() > hY)) continue;
                            hY = pt.getY();
                        }
                        Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                        double sX = Math.abs(hX - lX);
                        NodeInst ni = NodeInst.makeInstance(pureNp, this.ep, ctr, sX, sY2 = Math.abs(hY - lY), cell);
                        if (ni == null) {
                            this.reportError("Cannot create pin for POLYGON", cell);
                            return true;
                        }
                        Point2D[] outline = new Point2D[points.size()];
                        for (int i = 0; i < points.size(); ++i) {
                            outline[i] = EPoint.fromLambda(points.get(i).getX() - ((Point2D)ctr).getX(), points.get(i).getY() - ((Point2D)ctr).getY());
                        }
                        ni.setTrace(outline);
                        if (!first) continue;
                        first = false;
                        Export pp = this.newPort(cell, ni, pureNp.getPort(0), portname);
                        if (pp == null) continue;
                        pp.setCharacteristic(portCharacteristics);
                        continue;
                    }
                    if (key.equalsIgnoreCase("RECT")) {
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading RECT low X", cell);
                            return true;
                        }
                        double lX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading RECT low Y", cell);
                            return true;
                        }
                        double lY = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading RECT high X", cell);
                            return true;
                        }
                        double hX = this.convertLEFString(key);
                        key = this.getAKeyword();
                        if (key == null) {
                            this.reportError("EOF reading RECT high Y", cell);
                            return true;
                        }
                        double hY = this.convertLEFString(key);
                        if (this.ignoreToSemicolon("RECT", cell)) {
                            return true;
                        }
                        if (pureNp == null) {
                            this.reportError("No layers for RECT", cell);
                            return true;
                        }
                        pinMade.setValue(true);
                        Point2D.Double ctr = new Point2D.Double((lX + hX) / 2.0, (lY + hY) / 2.0);
                        double sX = Math.abs(hX - lX);
                        double sY3 = Math.abs(hY - lY);
                        NodeInst ni = NodeInst.makeInstance(pureNp, this.ep, ctr, sX, sY3, cell);
                        if (ni == null) {
                            this.reportError("Cannot create pin for RECT", cell);
                            return true;
                        }
                        if (!first) continue;
                        first = false;
                        Export pp = this.newPort(cell, ni, pureNp.getPort(0), portname);
                        if (pp == null) continue;
                        pp.setCharacteristic(portCharacteristics);
                        continue;
                    }
                    if (key.equalsIgnoreCase("PATH")) {
                        if (ap == null) {
                            this.reportError("No arc associated with layer '" + li.name + "' for PATH definition", cell);
                            return true;
                        }
                        int i = 0;
                        while (true) {
                            if ((key = this.getAKeyword()) == null) {
                                this.reportError("EOF reading PATH clause", cell);
                                return true;
                            }
                            if (key.equals(";")) continue block0;
                            double intx = this.convertLEFString(key);
                            key = this.getAKeyword();
                            if (key == null) {
                                this.reportError("EOF reading PATH clause", cell);
                                return true;
                            }
                            double inty = this.convertLEFString(key);
                            if (i == 0) {
                                singlePathPoint = new Point2D.Double(intx, inty);
                            } else {
                                LEFPath lp = new LEFPath();
                                ((LEFPath)lp).pt[0] = new Point2D.Double(lastIntX, lastIntY);
                                ((LEFPath)lp).pt[1] = new Point2D.Double(intx, inty);
                                ((LEFPath)lp).ni[0] = null;
                                ((LEFPath)lp).ni[1] = null;
                                lp.width = intWidth;
                                lp.arc = ap;
                                lp.nextLEFPath = lefPaths;
                                lefPaths = lp;
                            }
                            lastIntX = intx;
                            lastIntY = inty;
                            ++i;
                        }
                    }
                    if (!key.equalsIgnoreCase("VIA")) break block54;
                    key = this.getAKeyword();
                    if (key == null) {
                        this.reportError("EOF reading VIA clause", cell);
                        return true;
                    }
                    double intX = this.convertLEFString(key);
                    key = this.getAKeyword();
                    if (key == null) {
                        this.reportError("EOF reading VIA clause", cell);
                        return true;
                    }
                    double intY = this.convertLEFString(key);
                    key = this.getAKeyword();
                    li = this.getLayerInformation(key);
                    if (li.pin == null) {
                        this.reportError("No Via in current technology for '" + key + "'", cell);
                        return true;
                    }
                    if (this.ignoreToSemicolon("VIA", cell)) {
                        return true;
                    }
                    double sX = li.pin.getDefWidth(this.ep);
                    NodeInst ni = NodeInst.makeInstance(li.pin, this.ep, new Point2D.Double(intX, intY), sX, sY = li.pin.getDefHeight(this.ep), cell);
                    if (ni == null) break;
                }
                this.reportError("Cannot create VIA for PATH", cell);
                return true;
            }
            this.reportError("Unknown PORT keyword (" + key + ")", cell);
            return true;
        }
        LEFPath lp = lefPaths;
        while (lp != null) {
            for (int i = 0; i < 2; ++i) {
                if (lp.ni[i] != null) continue;
                Rectangle2D.Double bounds = new Rectangle2D.Double(lp.pt[i].getX(), lp.pt[i].getY(), 0.0, 0.0);
                Iterator<Geometric> sea = cell.searchIterator(bounds);
                while (sea.hasNext()) {
                    NodeInst ni;
                    Geometric geom = sea.next();
                    if (!(geom instanceof NodeInst) || !DBMath.areEquals((ni = (NodeInst)geom).getTrueCenter(), lp.pt[i])) continue;
                    ((LEFPath)lp).ni[i] = ni;
                    break;
                }
                if (lp.ni[i] == null) continue;
                LEFPath oLp = lefPaths;
                while (oLp != null) {
                    for (int j = 0; j < 2; ++j) {
                        if (oLp.ni[j] != null || !DBMath.areEquals(oLp.pt[j], lp.pt[i])) continue;
                        ((LEFPath)oLp).ni[j] = lp.ni[i];
                    }
                    oLp = oLp.nextLEFPath;
                }
            }
            lp = lp.nextLEFPath;
        }
        lp = lefPaths;
        while (lp != null) {
            for (int i = 0; i < 2; ++i) {
                if (lp.ni[i] != null) continue;
                pinMade.setValue(true);
                PrimitiveNode pin2 = lp.arc.findPinProto();
                if (pin2 == null) continue;
                double sX = pin2.getDefWidth(this.ep);
                double sY = pin2.getDefHeight(this.ep);
                ((LEFPath)lp).ni[i] = NodeInst.makeInstance(pin2, this.ep, lp.pt[i], sX, sY, cell);
                if (lp.ni[i] == null) {
                    this.reportError("Cannot create pin for PATH", cell);
                    return true;
                }
                if (first) {
                    first = false;
                    Export pp = this.newPort(cell, lp.ni[i], pin2.getPort(0), portname);
                    if (pp != null) {
                        pp.setCharacteristic(portCharacteristics);
                    }
                }
                LEFPath oLp = lefPaths;
                while (oLp != null) {
                    for (int j = 0; j < 2; ++j) {
                        if (oLp.ni[j] != null || !DBMath.areEquals(oLp.pt[j], lp.pt[i]) || oLp.arc != lp.arc) continue;
                        ((LEFPath)oLp).ni[j] = lp.ni[i];
                    }
                    oLp = oLp.nextLEFPath;
                }
            }
            lp = lp.nextLEFPath;
        }
        lp = lefPaths;
        while (lp != null) {
            PortInst head2 = lp.ni[0].getPortInst(0);
            PortInst tail = lp.ni[1].getPortInst(0);
            Point2D headPt = lp.pt[0];
            Point2D tailPt = lp.pt[1];
            ArcInst ai = ArcInst.makeInstanceBase(lp.arc, this.ep, lp.width, head2, tail, headPt, tailPt, null);
            if (ai == null) {
                this.reportError("Cannot create " + lp.arc.describe() + " arc for PATH", cell);
                return true;
            }
            lp = lp.nextLEFPath;
        }
        if (lefPaths == null && singlePathPoint != null && ap != null && first && (pin = ap.findPinProto()) != null) {
            pinMade.setValue(true);
            double sX = pin.getDefWidth(this.ep);
            double sY = pin.getDefHeight(this.ep);
            NodeInst ni = NodeInst.makeInstance(pin, this.ep, singlePathPoint, sX, sY, cell);
            if (ni == null) {
                this.reportError("Cannot create pin for PATH", cell);
                return true;
            }
            Export pp = this.newPort(cell, ni, pin.getPort(0), portname);
            if (pp != null) {
                pp.setCharacteristic(portCharacteristics);
            }
        }
        return false;
    }

    private Export newPort(Cell cell, NodeInst ni, PortProto pp, String thename) {
        String portName = thename;
        String newName = null;
        int i = 0;
        while (true) {
            Export e;
            if ((e = (Export)cell.findPortProto(portName)) == null) {
                PortInst pi = ni.findPortInstFromProto(pp);
                Export ex = Export.newInstance(cell, pi, portName, this.ep);
                return ex;
            }
            int sqPos = thename.indexOf(91);
            newName = sqPos < 0 ? thename + "-" + i : thename.substring(0, sqPos) + "-" + i + thename.substring(sqPos);
            portName = newName;
            ++i;
        }
    }

    private boolean readLayer() throws IOException {
        String key;
        double defWidth;
        String layerType;
        String layerName;
        block10: {
            layerName = this.getAKeyword();
            if (layerName == null) {
                this.reportError("EOF parsing LAYER header", null);
                return true;
            }
            layerType = null;
            defWidth = -1.0;
            while (true) {
                if ((key = this.getAKeyword()) == null) {
                    this.reportError("EOF parsing LAYER", null);
                    return true;
                }
                if (key.equalsIgnoreCase("END")) break block10;
                if (key.equalsIgnoreCase("WIDTH")) {
                    key = this.getAKeyword();
                    if (key == null) {
                        this.reportError("EOF reading WIDTH", null);
                        return true;
                    }
                    defWidth = this.convertLEFString(key);
                    if (!this.ignoreToSemicolon("WIDTH", null)) continue;
                    return true;
                }
                if (key.equalsIgnoreCase("TYPE")) {
                    layerType = this.getAKeyword();
                    if (!this.ignoreToSemicolon("TYPE", null)) continue;
                    return true;
                }
                if ((key.equalsIgnoreCase("SPACING") || key.equalsIgnoreCase("PITCH") || key.equalsIgnoreCase("DIRECTION") || key.equalsIgnoreCase("CAPACITANCE") || key.equalsIgnoreCase("RESISTANCE")) && this.ignoreToSemicolon(key, null)) break;
            }
            return true;
        }
        key = this.getAKeyword();
        LEFDEF.GetLayerInformation li = new LEFDEF.GetLayerInformation(this, layerName, layerType);
        knownLayers.put(layerName, li);
        ArcProto ap = li.arc;
        if (defWidth > 0.0) {
            if (ap != null) {
                widthsFromLEF.put(ap, new Double(defWidth));
            } else {
                if (layerWidthsFromLEF == null) {
                    layerWidthsFromLEF = new HashMap();
                }
                layerWidthsFromLEF.put(layerName, new Double(defWidth));
            }
        }
        return false;
    }

    private List<Point2D> readPolygon(Cell cell) throws IOException {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        while (true) {
            String key;
            if ((key = this.getAKeyword()) == null) {
                this.reportError("EOF reading POLYGON X coordinate", cell);
                return null;
            }
            if (key.equals(";")) break;
            if (points.size() == 0 && key.equalsIgnoreCase("ITERATE")) continue;
            double x2 = this.convertLEFString(key);
            key = this.getAKeyword();
            if (key == null) {
                this.reportError("EOF reading POLYGON Y coordinate", cell);
                return null;
            }
            if (key.equals(";")) break;
            double y = this.convertLEFString(key);
            points.add(new Point2D.Double(x2, y));
        }
        return points;
    }

    private boolean ignoreToSemicolon(String command, Cell cell) throws IOException {
        String key;
        do {
            if ((key = this.getAKeyword()) != null) continue;
            this.reportError("EOF parsing " + command, cell);
            return true;
        } while (!key.equals(";"));
        return false;
    }

    private boolean ignoreToEnd(String endName, Cell cell) throws IOException {
        boolean findEnd = true;
        while (true) {
            String key;
            if ((key = this.getAKeyword()) == null) {
                this.reportError("EOF parsing " + endName, cell);
                return true;
            }
            if (findEnd && key.equalsIgnoreCase("END")) {
                key = this.getAKeyword();
                if (key == null) {
                    this.reportError("EOF parsing " + endName, cell);
                    return true;
                }
                if (!key.equals(endName)) continue;
                break;
            }
            if (key.equals(";")) {
                findEnd = true;
                continue;
            }
            findEnd = false;
        }
        return false;
    }

    private double convertLEFString(String key) {
        double v = TextUtils.atof(key) * this.localPrefs.overallscale;
        return TextUtils.convertFromDistance(v, this.curTech, TextUtils.UnitScale.MICRO);
    }

    protected boolean importTechFile() {
        this.initializeLEFDEF(null);
        layerWidthsFromLEF = new HashMap();
        this.initKeywordParsing();
        try {
            if (this.readTechnologyFile()) {
                return false;
            }
        }
        catch (IOException e) {
            this.reportError("ERROR reading LEF tech file", null);
            return false;
        }
        return true;
    }

    private boolean readTechnologyFile() throws IOException {
        String key;
        while ((key = this.getAKeyword()) != null) {
            if (key.equalsIgnoreCase("LAYER")) {
                if (!this.readLayer()) continue;
                return true;
            }
            if (key.equalsIgnoreCase("VIA") || key.equalsIgnoreCase("VIARULE") || key.equalsIgnoreCase("SITE") || key.equalsIgnoreCase("ARRAY")) {
                String name = this.getAKeyword();
                this.ignoreToEnd(name, null);
                continue;
            }
            if (key.equalsIgnoreCase("VERSION") || key.equalsIgnoreCase("NAMESCASESENSITIVE") || key.equalsIgnoreCase("BUSBITCHARS") || key.equalsIgnoreCase("DIVIDERCHAR") || key.equalsIgnoreCase("MANUFACTURINGGRID")) {
                this.ignoreToSemicolon(key, null);
                continue;
            }
            if (!key.equalsIgnoreCase("UNITS")) continue;
            this.ignoreToEnd(key, null);
        }
        return false;
    }

    public static class LEFPreferences
    extends Input.InputPreferences {
        private boolean ignoreUngeneratedPins;
        public boolean ignoreTechnology;
        public boolean continueReading = false;
        public double overallscale = 1.0;

        public LEFPreferences(boolean factory) {
            super(factory);
            if (factory) {
                this.ignoreUngeneratedPins = IOTool.isFactoryLEFIgnoreUngeneratedPins();
                this.ignoreTechnology = IOTool.isFactoryLEFIgnoreTechnology();
            } else {
                this.ignoreUngeneratedPins = IOTool.isLEFIgnoreUngeneratedPins();
                this.ignoreTechnology = IOTool.isLEFIgnoreTechnology();
            }
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, EditingPreferences ep, Map<Library, Cell> currentCells, Map<CellId, BitSet> nodesToExpand, Job job) {
            LEF in = new LEF(ep, this);
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }

        public boolean doTechInput(URL fileURL, EditingPreferences ep) {
            LEF in = new LEF(ep, this);
            if (in.openTextInput(fileURL)) {
                return false;
            }
            boolean result2 = in.importTechFile();
            in.closeInput();
            return result2;
        }
    }

    private static class LEFPath {
        private Point2D[] pt = new Point2D[2];
        private NodeInst[] ni = new NodeInst[2];
        private double width;
        private ArcProto arc;
        private LEFPath nextLEFPath;

        private LEFPath() {
        }
    }
}

