/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.math;

import com.sun.electric.util.math.FixpCoord;

public class ECoord
extends FixpCoord {
    public static final ECoord MIN_ECOORD = new ECoord(Long.MIN_VALUE);
    public static final ECoord MAX_ECOORD = new ECoord(0x7FFFFFFFFFF00000L);

    ECoord(long fixp) {
        super(fixp);
        assert ((fixp & 0xFFFFFL) == 0L);
    }

    public static ECoord fromGrid(long grid) {
        return ECoord.fromAlignedFixp(grid << 20);
    }

    public long getGrid() {
        return this.getFixp() >> 20;
    }

    public ECoord add(ECoord y) {
        long xFixp = this.getFixp();
        long yFixp = y.getFixp();
        if (yFixp == 0L) {
            return this;
        }
        if (xFixp == 0L) {
            return y;
        }
        return ECoord.fromAlignedFixp(xFixp + yFixp);
    }

    public ECoord subtract(ECoord y) {
        long xFixp = this.getFixp();
        long yFixp = y.getFixp();
        if (yFixp == 0L) {
            return this;
        }
        return ECoord.fromAlignedFixp(xFixp - yFixp);
    }

    @Override
    public ECoord multiply(long scale) {
        if (scale == 1L) {
            return this;
        }
        return ECoord.fromAlignedFixp(this.getFixp() * scale);
    }

    public ECoord min(ECoord y) {
        return this.getFixp() <= y.getFixp() ? this : y;
    }

    public ECoord max(ECoord y) {
        return this.getFixp() >= y.getFixp() ? this : y;
    }
}

