/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.ObjectQTree;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.extract.LayerCoverageTool;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.tool.user.tests.MakeFakeCircuitry;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayerCoverageToolTest
extends AbstractTest {
    public LayerCoverageToolTest(String name) {
        super(name);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new LayerCoverageToolTest("Area"));
        list.add(new LayerCoverageToolTest("Network"));
        list.add(new LayerCoverageToolTest("Implant"));
        list.add(new LayerCoverageToolTest("QTree"));
        return list;
    }

    public static String getOutputDirectory() {
        return null;
    }

    public Boolean Area() {
        return LayerCoverageToolTest.basicAreaCoverageTest(null);
    }

    public static boolean basicAreaCoverageTest(String logname) {
        boolean[] errorCounts = new boolean[2];
        try {
            if (logname != null) {
                MessagesStream.getMessagesStream().save(logname);
            }
            String techName = "mocmos";
            String libName = "areaCoverage" + techName;
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            LayerCoverageToolTest.makeFakeCircuitryForCoverageCommand(libName, techName, false, ep);
            Library rootLib = Library.findLibrary(libName);
            Cell cell = rootLib.findNodeProto("higher{lay}");
            GeometryHandler.GHMode[] modes = new GeometryHandler.GHMode[]{GeometryHandler.GHMode.ALGO_MERGE, GeometryHandler.GHMode.ALGO_SWEEP};
            for (int i = 0; i < modes.length; ++i) {
                GeometryHandler.GHMode mode = modes[i];
                System.out.println("------ RUNNING " + (Object)((Object)mode) + " MODE -------------");
                Map<Layer, Double> map2 = LayerCoverageTool.layerCoverageCommand(cell, mode, false, new LayerCoverageTool.LayerCoveragePreferences(true));
                errorCounts[i] = map2 == null;
                System.out.println("------ FINISHED " + (Object)((Object)mode) + " MODE: " + (errorCounts[i] ? "FAILED" : "PASSED"));
            }
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
            e.printStackTrace();
            return false;
        }
        return !errorCounts[0] && !errorCounts[1];
    }

    public static void makeFakeCircuitryForCoverageCommand(String libName, String tech, boolean asJob, EditingPreferences ep) {
        if (asJob) {
            new FakeCoverageCircuitry(libName, tech);
        } else {
            FakeCoverageCircuitry.doItInternal(libName, tech, new HashMap(), ep);
        }
    }

    public Boolean Network() {
        return LayerCoverageToolTest.basicNetworkCoverageTest(null);
    }

    public static boolean basicNetworkCoverageTest(String logname) {
        boolean[] errorCounts = new boolean[2];
        double delta = DBMath.getEpsilon() * DBMath.getEpsilon();
        double wireLength = GenMath.toNearest(165.45876875, delta);
        try {
            if (logname != null) {
                MessagesStream.getMessagesStream().save(logname);
            }
            String techName = "mocmos";
            String libName = "networkCoverage" + techName;
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            MakeFakeCircuitry.makeFakeCircuitryCommand(libName, techName, Boolean.FALSE, ep);
            Library rootLib = Library.findLibrary(libName);
            Cell cell = rootLib.findNodeProto(techName + "test{lay}");
            double calculatedValue = 0.0;
            Netlist netlist = cell.getNetlist();
            ArrayList<Network> networks = new ArrayList<Network>();
            Iterator<Network> it = netlist.getNetworks();
            while (it.hasNext()) {
                networks.add(it.next());
            }
            Collections.sort(networks, new TextUtils.NetworksByName());
            GeometryHandler.GHMode[] modes = new GeometryHandler.GHMode[]{GeometryHandler.GHMode.ALGO_MERGE, GeometryHandler.GHMode.ALGO_SWEEP};
            LayerCoverageTool.LayerCoveragePreferences lcp = new LayerCoverageTool.LayerCoveragePreferences(true);
            for (int i = 0; i < modes.length; ++i) {
                GeometryHandler.GHMode mode = modes[i];
                System.out.println("------ RUNNING " + (Object)((Object)mode) + " MODE -------------");
                for (Network net : networks) {
                    HashSet<Network> nets = new HashSet<Network>();
                    nets.add(net);
                    LayerCoverageTool.GeometryOnNetwork geoms = LayerCoverageTool.listGeometryOnNetworks(cell, nets, false, mode, lcp);
                    System.out.println("Network " + net + " has wire length " + geoms.getTotalWireLength());
                    if (geoms.getTotalWireLength() == 0.0) continue;
                    calculatedValue = GenMath.toNearest(geoms.getTotalWireLength(), delta);
                }
                System.out.println("Wire value " + calculatedValue + " (expected " + wireLength + ")");
                errorCounts[i] = !GenMath.doublesEqual(calculatedValue, wireLength);
                System.out.println("------ FINISHED " + (Object)((Object)mode) + " MODE: " + (errorCounts[i] ? "FAILED" : "PASSED"));
            }
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
            e.printStackTrace();
            return false;
        }
        return !errorCounts[0] && !errorCounts[1];
    }

    public Boolean Implant() {
        return LayerCoverageToolTest.basicImplantCoverageTest(null);
    }

    public static boolean basicImplantCoverageTest(String logname) {
        boolean[] errorCounts = new boolean[2];
        try {
            if (logname != null) {
                MessagesStream.getMessagesStream().save(logname);
            }
            String techName = "mocmos";
            String libName = "implantCoverage" + techName;
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            MakeFakeCircuitry.makeFakeCircuitryCommand(libName, techName, Boolean.FALSE, ep);
            Library rootLib = Library.findLibrary(libName);
            Cell cell = rootLib.findNodeProto(techName + "test{lay}");
            GeometryHandler.GHMode[] modes = new GeometryHandler.GHMode[]{GeometryHandler.GHMode.ALGO_MERGE, GeometryHandler.GHMode.ALGO_SWEEP};
            int[] results = new int[]{2, 2};
            for (int i = 0; i < modes.length; ++i) {
                GeometryHandler.GHMode mode = modes[i];
                System.out.println("------ RUNNING " + (Object)((Object)mode) + " MODE -------------");
                List<Object> list = LayerCoverageTool.layerCoverageCommand(LayerCoverageTool.LCMode.IMPLANT, mode, cell, false, new LayerCoverageTool.LayerCoveragePreferences(true));
                errorCounts[i] = list.size() != results[i];
                System.out.println("------ FINISHED " + (Object)((Object)mode) + " MODE: " + (errorCounts[i] ? "FAILED" : "PASSED"));
            }
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
            e.printStackTrace();
            return false;
        }
        return !errorCounts[0] && !errorCounts[1];
    }

    public Boolean QTree() {
        return LayerCoverageToolTest.basicQTreeTest(null);
    }

    public static boolean basicQTreeTest(String logname) {
        boolean pass = false;
        try {
            if (logname != null) {
                MessagesStream.getMessagesStream().save(logname);
            }
            Rectangle2D.Double expanded = new Rectangle2D.Double(9.0, 7.0, 2.0, 6.0);
            ObjectQTree oqt = new ObjectQTree(expanded);
            Rectangle2D.Double bounds1 = new Rectangle2D.Double(10.0, 8.0, 0.0, 0.0);
            oqt.add(new Integer(1), bounds1);
            Rectangle2D.Double bounds2 = new Rectangle2D.Double(10.0, 10.0, 0.0, 0.0);
            oqt.add(new Integer(2), bounds2);
            Rectangle2D.Double bounds3 = new Rectangle2D.Double(10.0, 12.0, 0.0, 0.0);
            oqt.add(new Integer(3), bounds3);
            Rectangle2D.Double bounds4 = new Rectangle2D.Double(10.5, 11.0, 0.0, 0.0);
            oqt.add(new Integer(4), bounds4);
            Rectangle2D.Double bounds5 = new Rectangle2D.Double(14.0, 10.6, 0.0, 0.0);
            oqt.add(new Integer(5), bounds5);
            Rectangle2D.Double searchBounds = new Rectangle2D.Double(9.5, 10.0, 2.0, 4.0);
            Set set = oqt.find(searchBounds);
            int setSize = 0;
            if (set != null) {
                setSize = set.size();
            }
            pass = setSize == 3;
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
            e.printStackTrace();
        }
        return pass;
    }

    private static class FakeCoverageCircuitry
    extends Job {
        private String theTechnology;
        private String theLibrary;
        private Map<CellId, BitSet> nodesToExpand = new HashMap<CellId, BitSet>();

        protected FakeCoverageCircuitry(String libName, String tech) {
            super("Make fake circuitry for coverage tests", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.theTechnology = tech;
            this.theLibrary = libName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            FakeCoverageCircuitry.doItInternal(this.theLibrary, this.theTechnology, this.nodesToExpand, this.getEditingPreferences());
            this.fieldVariableChanged("nodesToExpand");
            return true;
        }

        @Override
        public void terminateOK() {
            this.getDatabase().expandNodes(this.nodesToExpand);
        }

        private static void doItInternal(String libName, String technology, Map<CellId, BitSet> nodesToExpand, EditingPreferences ep) {
            EDatabase database = EDatabase.currentDatabase();
            Technology tech = Technology.findTechnology(technology);
            if (tech == null) {
                System.out.println("Technology not found in createCoverageTestCells");
                return;
            }
            NodeProto m1NodeProto = Cell.findNodeProto(technology + ":Metal-1-Node");
            NodeProto m2NodeProto = Cell.findNodeProto(technology + ":Metal-2-Node");
            NodeProto m3NodeProto = Cell.findNodeProto(technology + ":Metal-3-Node");
            NodeProto m4NodeProto = Cell.findNodeProto(technology + ":Metal-4-Node");
            Library mainLib = Library.newInstance(libName, null);
            Cell m1Cell = Cell.makeInstance(ep, mainLib, technology + "Metal1Test{lay}");
            NodeInst.newInstance(m1NodeProto, ep, new Point2D.Double(0.0, 0.0), m1NodeProto.getDefWidth(ep), m1NodeProto.getDefHeight(ep), m1Cell);
            Cell myCell = Cell.makeInstance(ep, mainLib, technology + "M1M2Test{lay}");
            NodeInst.newInstance(m1NodeProto, ep, new Point2D.Double(-m1NodeProto.getDefWidth(ep) / 2.0, -m1NodeProto.getDefHeight(ep) / 2.0), m1NodeProto.getDefWidth(ep), m1NodeProto.getDefHeight(ep), myCell);
            NodeInst.newInstance(m2NodeProto, ep, new Point2D.Double(-m2NodeProto.getDefWidth(ep) / 2.0, m2NodeProto.getDefHeight(ep) / 2.0), m2NodeProto.getDefWidth(ep), m2NodeProto.getDefHeight(ep), myCell);
            NodeInst.newInstance(m3NodeProto, ep, new Point2D.Double(m3NodeProto.getDefWidth(ep) / 2.0, -m3NodeProto.getDefHeight(ep) / 2.0), m3NodeProto.getDefWidth(ep), m3NodeProto.getDefHeight(ep), myCell);
            NodeInst.newInstance(m4NodeProto, ep, new Point2D.Double(m4NodeProto.getDefWidth(ep) / 2.0, m4NodeProto.getDefHeight(ep) / 2.0), m4NodeProto.getDefWidth(ep), m4NodeProto.getDefHeight(ep), myCell);
            Cell higherCell = Cell.makeInstance(ep, mainLib, "higher{lay}");
            double myWidth = myCell.getDefWidth();
            double myHeight = myCell.getDefHeight();
            for (int iX = 0; iX < 2; ++iX) {
                boolean flipX = iX != 0;
                for (int i = 0; i < 4; ++i) {
                    Orientation orient = Orientation.fromJava(i * 900, flipX, false);
                    NodeInst instanceNode = NodeInst.newInstance((NodeProto)myCell, ep, new Point2D.Double((double)i * myWidth, (double)iX * myHeight), myWidth, myHeight, higherCell, orient, null);
                    database.addToNodes(nodesToExpand, instanceNode);
                }
            }
            System.out.println("Created " + higherCell);
        }
    }
}

