/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.provider;

import gnu.crypto.der.DER;
import gnu.crypto.der.DERReader;
import gnu.crypto.der.DERValue;
import gnu.crypto.der.DERWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DSAParameters
extends AlgorithmParametersSpi {
    private BigInteger q;
    private BigInteger p;
    private BigInteger g;
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;
    static /* synthetic */ Class class$gnu$crypto$pki$provider$DSAParameters;

    public void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Only accepts DSAParameterSpec");
        }
        DSAParameterSpec dsaParamSpec = (DSAParameterSpec)paramSpec;
        this.p = dsaParamSpec.getP();
        this.q = dsaParamSpec.getQ();
        this.g = dsaParamSpec.getG();
    }

    public void engineInit(byte[] params) throws IOException {
        DERReader in = new DERReader(params);
        DERValue val = in.read();
        if (val.getValue() != DER.CONSTRUCTED_VALUE) {
            throw new IOException("badly formed parameters");
        }
        try {
            this.p = (BigInteger)in.read().getValue();
            this.q = (BigInteger)in.read().getValue();
            this.g = (BigInteger)in.read().getValue();
        }
        catch (Exception x) {
            IOException ioe = new IOException("badly formed parameters");
            ioe.initCause(x);
            throw ioe;
        }
    }

    public void engineInit(byte[] params, String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
        this.engineInit(params);
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        Class clazz = class$java$security$spec$DSAParameterSpec;
        if (clazz == null) {
            clazz = class$java$security$spec$DSAParameterSpec = DSAParameters.class("[Ljava.security.spec.DSAParameterSpec;", false);
        }
        if (paramSpec.isAssignableFrom(clazz)) {
            return new DSAParameterSpec(this.p, this.q, this.g);
        }
        throw new InvalidParameterSpecException("Only accepts DSAParameterSpec");
    }

    public byte[] engineGetEncoded() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ArrayList<DERValue> seq = new ArrayList<DERValue>(3);
        seq.add(new DERValue(2, this.p));
        seq.add(new DERValue(2, this.q));
        seq.add(new DERValue(2, this.g));
        DERWriter.write(bout, new DERValue(48, seq));
        return bout.toByteArray();
    }

    public byte[] engineGetEncoded(String format) throws IOException {
        if (!format.equals("ASN.1")) {
            throw new IOException("Invalid Format: Only accepts ASN.1");
        }
        return this.engineGetEncoded();
    }

    public String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$gnu$crypto$pki$provider$DSAParameters;
        if (clazz == null) {
            clazz = class$gnu$crypto$pki$provider$DSAParameters = DSAParameters.class("[Lgnu.crypto.pki.provider.DSAParameters;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ q: ").append(this.q).append(" p: ").append(this.p).append(" g: ").append(this.g).append(" ]").toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

