/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.gnunet.mq.Envelope;
import org.gnunet.mq.MessageQueue;
import org.gnunet.util.AbsoluteTime;
import org.gnunet.util.Cancelable;
import org.gnunet.util.Configuration;
import org.gnunet.util.Connection;
import org.gnunet.util.Continuation;
import org.gnunet.util.GnunetMessage;
import org.gnunet.util.MessageReceiver;
import org.gnunet.util.MessageTransmitter;
import org.gnunet.util.RelativeTime;
import org.gnunet.util.RunaboutMessageReceiver;
import org.gnunet.util.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends MessageQueue {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private Connection connection;
    private final String hostname;
    private final int port;
    private static final RelativeTime INITAL_BACKOFF = RelativeTime.MILLISECOND.multiply(5);
    private static final RelativeTime MAX_BACKOFF = RelativeTime.SECOND.multiply(5);
    private RelativeTime connectBackoff = INITAL_BACKOFF;
    private boolean notifyTransmitReadyDelayed;
    private Cancelable delayedNotifyTransmitHandle;
    private RunaboutMessageReceiver receiver;
    private boolean receiverActive;
    private Cancelable currentSubmit;
    private Scheduler.TaskIdentifier receiverLifenessTask;

    public Client(String serviceName, Configuration cfg) {
        if (cfg == null) {
            throw new AssertionError((Object)"Configuration may not be null");
        }
        if (!cfg.haveValue(serviceName, "PORT")) {
            throw new Configuration.ConfigurationException(String.format("PORT of service '%s' not specified", serviceName));
        }
        if (!cfg.haveValue(serviceName, "HOSTNAME")) {
            throw new Configuration.ConfigurationException(String.format("HOSTNAME of service '%s' not specified", serviceName));
        }
        Optional<Long> portOption = cfg.getValueNumber(serviceName, "PORT");
        this.port = ((Long)portOption.get()).intValue();
        this.hostname = (String)cfg.getValueString(serviceName, "HOSTNAME").get();
        if (this.hostname == null || this.hostname.isEmpty()) {
            throw new Configuration.ConfigurationException(String.format("hostname of service '%s' empty", serviceName));
        }
        this.reconnect();
        this.reportReadyForSubmit();
    }

    public Client(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.reconnect();
        this.reportReadyForSubmit();
    }

    public void receiveOne(RelativeTime timeout, MessageReceiver receiver) {
        this.connection.receive(timeout, receiver);
    }

    public Cancelable notifyTransmitReady(final RelativeTime timeout, boolean autoRetry, int size, final MessageTransmitter transmitter) {
        if (this.notifyTransmitReadyDelayed) {
            throw new AssertionError((Object)"notifyTransmitReady called twice!");
        }
        if (this.connection == null) {
            throw new AssertionError((Object)"notifyTransmitReady called on disconnected client");
        }
        if (this.connection.isConnected()) {
            return this.connection.notifyTransmitReady(0, timeout, transmitter);
        }
        this.notifyTransmitReadyDelayed = true;
        final AbsoluteTime deadline = timeout.toAbsolute();
        this.delayedNotifyTransmitHandle = this.connection.notifyConnected(this.connectBackoff, new Continuation(){

            @Override
            public void cont(boolean success) {
                Client.this.delayedNotifyTransmitHandle = null;
                if (success) {
                    Client.this.activateReceiver();
                    Client.this.notifyTransmitReadyDelayed = false;
                    Client.this.delayedNotifyTransmitHandle = Client.this.connection.notifyTransmitReady(0, timeout, new MessageTransmitter(){

                        @Override
                        public void transmit(Connection.MessageSink sink) {
                            Client.this.delayedNotifyTransmitHandle = null;
                            transmitter.transmit(sink);
                        }

                        @Override
                        public void handleError() {
                            Client.this.delayedNotifyTransmitHandle = null;
                            transmitter.handleError();
                        }
                    });
                } else {
                    logger.debug("connect timed out, trying again");
                    if (deadline.isDue()) {
                        transmitter.handleError();
                    } else {
                        RelativeTime timeout2 = deadline.getRemaining();
                        Client.this.connectBackoff = RelativeTime.min(timeout2, RelativeTime.min(Client.this.connectBackoff.multiply(2), MAX_BACKOFF));
                        Client.this.reconnect();
                        Client.this.delayedNotifyTransmitHandle = Client.this.connection.notifyConnected(Client.this.connectBackoff, this);
                    }
                }
            }
        });
        return new Cancelable(){

            @Override
            public void cancel() {
                if (Client.this.delayedNotifyTransmitHandle != null) {
                    Client.this.delayedNotifyTransmitHandle.cancel();
                }
            }
        };
    }

    public Cancelable transmitWhenReady(RelativeTime timeout, final GnunetMessage.Body message, final Continuation cont) {
        return this.notifyTransmitReady(timeout, false, 0, new MessageTransmitter(){

            @Override
            public void transmit(Connection.MessageSink sink) {
                sink.send(message);
                if (cont != null) {
                    cont.cont(true);
                }
            }

            @Override
            public void handleError() {
                if (cont != null) {
                    cont.cont(false);
                }
            }
        });
    }

    public Cancelable transmitWhenReady(GnunetMessage.Body message, Continuation cont) {
        return this.transmitWhenReady(RelativeTime.FOREVER, message, cont);
    }

    public final void reconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.connection = new Connection(this.hostname, this.port);
    }

    public void disconnect() {
        this.connection.disconnect();
        this.connection = null;
        if (this.receiverLifenessTask != null) {
            this.receiverLifenessTask.cancel();
            this.receiverLifenessTask = null;
        }
        this.receiverActive = false;
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    @Override
    protected void submit(Envelope ev) {
        this.currentSubmit = this.transmitWhenReady(RelativeTime.FOREVER, ev.message, new Continuation(){

            @Override
            public void cont(boolean success) {
                Client.this.currentSubmit = null;
                Client.this.reportMessageSent();
                Client.this.reportReadyForSubmit();
            }
        });
    }

    @Override
    protected void retract() {
        if (this.currentSubmit == null) {
            throw new AssertionError();
        }
        this.currentSubmit.cancel();
        this.currentSubmit = null;
    }

    private void activateReceiver() {
        if (this.receiverActive || this.receiver == null) {
            return;
        }
        MessageReceiver proxyReceiver = new MessageReceiver(){

            @Override
            public void process(GnunetMessage.Body msg) {
                Client.this.receiver.process(msg);
                if (Client.this.connection != null && Client.this.connection.isConnected()) {
                    Client.this.connection.receive(RelativeTime.FOREVER, this);
                } else {
                    Client.this.receiverActive = false;
                }
            }

            @Override
            public void handleError() {
                Client.this.receiver.handleError();
                Client.this.receiverActive = false;
            }
        };
        this.connection.receive(RelativeTime.FOREVER, proxyReceiver);
        this.receiverActive = true;
    }

    public void installReceiver(RunaboutMessageReceiver receiver) {
        Preconditions.checkState((this.receiver == null ? 1 : 0) != 0);
        this.receiverLifenessTask = Scheduler.addDelayed(RelativeTime.FOREVER, new Scheduler.Task(){

            @Override
            public void run(Scheduler.RunContext ctx) {
            }
        });
        this.receiver = receiver;
        if (this.connection != null && this.connection.isConnected()) {
            this.activateReceiver();
        }
    }
}

