/* _string.c

   written by Don Robert Maszle
   12 January 1992
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s._string.c
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:14:39
      Author:  @a
   -- SCCS  ---------

   I think this is necessary to overcome a problem with NULL pointers.

   The following routines are provided as alternates to the standard
   library routines.  They handle NULL string pointer cases in a
   reasonable manner and ultimately call the standard library routines
   for non-NULL cases.  Some routines are implemented as macros.

   Use the header file "_string.h"

   Currently supported are:

   _strlen(), _strcpy(), Strcmp(), _strchr(), _strtok()
*/

#ifdef __LOCAL_HDR__
#include "string.h"
#else
#include <string.h>
#endif


int Strcmp(const char* sz1, const char* sz2)
{
  if (!sz1) {
    if (sz2)
      return (-1);  /* NULL comes before the -something- */
    else
      return (0);   /* Two NULL strings compare equal */
  } /* if */

  else {  /* assert (sz1) */
    if (sz2)
      return (strcmp(sz1, sz2));  /* Normal comparison */
    else
      return (1);   /* -Something- comes after the NULL */
  } /* else */
                                        /*-- Prevent compiler complaints */
  return 0;                             /*-- Never reached! */
} /* Strcmp */


#ifdef ndef    /* Is a macro */
char* _strcpy (char* szDest, const char* szSource)
{
  if (szSource && szDest)
    return (strcpy (szSource, szDest));

  return NULL;  /* If either is NULL, the resulting copy is NULL */
} /* _strcpy */
#endif


#ifdef ndef    /* Is a macro */
int _strlen (char* sz)
{
  if (sz)
    return (strlen(sz))
  return 0;
} /* _strlen */
#endif
