/* global.h

   written by Frederic Yves Bois
   13 August 1991
   
   Copyright (c) 1993.  Don Maszle, Frederic Bois.  All rights reserved.

   -- Revisions -----
     Logfile:  SCCS/s.global.h
    Revision:  1.1
        Date:  7/14/93
     Modtime:  19:15:00
      Author:  @a
   -- SCCS  ---------

   Global header for module globalTypes
*/

#ifndef GLOBAL_INCLUDED

/* ----- Inclusions */

/* ----- Constants */

#define nbrComparMax    14   /* max nbr of model compartments*/
#define nbrComposMax    3    /* max nbr of compound followed*/
#define nbrEquatiMax    42   /* number of equations computed*/
#define nbrParameMax    80   /* max nbr of parameters in an input file*/
#define nbrTimesRMax    20   /* max nbr of recorded times*/
#define precisReport    14   /* format of the floating point results*/

#define dim1Max         nbrEquatiMax /* for difsub and matinv etc. */


/* ----- Enumerations */

/* ----- Typedefs */

typedef int    admis[nbrComposMax][nbrComparMax];
typedef double espaceReel1D[nbrComposMax];
typedef double espaceReel2D[nbrComposMax][nbrComparMax];
typedef double matTimes[nbrTimesRMax];

/* structures for cross-reference of the parameters : */

typedef struct xrefRec {
  long typeD;
  union {
    long *iPtr;
    double *ePtr;
    double (*mPtr)[nbrComparMax];
    int (*tPtr)[nbrComparMax];
    double *vdPtr;
    double *vtPtr;
  } UU;
} xrefRec;

typedef xrefRec xrefMat1[nbrParameMax];
typedef xrefMat1 xrefMat2[3];


/* ----- Macros */

/* ----- Globals/Externals */

extern char feuvert; /* global for debugging */


/* ----- Prototypes */

#define GLOBAL_INCLUDED
#endif
