/* This file is part of the GNU plotutils package.  Copyright (C) 1995,
   1996, 1997, 1998, 1999, 2000, 2005, Free Software Foundation, Inc.

   The GNU plotutils package is free software.  You may redistribute it
   and/or modify it under the terms of the GNU General Public License as
   published by the Free Software foundation; either version 2, or (at your
   option) any later version.

   The GNU plotutils package is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with the GNU plotutils package; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin St., Fifth Floor,
   Boston, MA 02110-1301, USA. */

/* THIS FILE IS NOW SPLIT INTO TWO PIECES: g_fontdb.c and g_fontd2.c, 
   TO FACILITATE COMPILING.  This is the second half, containing PCL fonts 
   and Stick fonts (i.e., device-resident HP vector fonts). */

#include "sys-defines.h"
#include "extern.h"


/* The 45 standard HP LaserJet fonts, with ISO8859-1 (ISO-Latin-1) encoding
   where that is appropriate.  (Note that PL_NUM_PCL_FONTS is defined to equal
   45 in extern.h.)

   The tables of widths and `left edge' offsets are taken from the 
   LaserJet 4 font distribution, as of this writing available at
   ftp://ftp.hp.com/pub/printers/software/mp135mu.exe . This is a zipped
   archive file which includes both .afm and .pfb files for the 45 fonts
   (apparently constructed by Fontographer from TrueType or Intellifont
   originals).  Of these fonts, only the four Univers and four CGTimes
   fonts were available on the LaserJet III.  The same 45 fonts are
   available on the LaserJet 5 and 6, and more recent LaserJets such
   as the 2100-series, the 4000-series, and the 8000-series.
   
   Each plPCLFontInfoStruct includes these elements:

   (1a) PS name, (1b) alternative PS name if any (may be NULL),
   (1c) Substitute PS name to be used when outputing to a PS file, 
        if non-NULL.  This feature is used only to support the 
	Tidbits-is-Wingdings botch.
   (1c) X name.
   (1.5abcde) CSS font properties.
   (2) PCL typeface number.
   (3) PCL info: fixedwidth(0) / proportional(1).
   (4) PCL info: upright(0) / italic(1) / condensed(4) / cond. italic(5) /
   	compressed i.e. extra cond. (8) / expanded (24) / outline (32) / 
	inline (64).
   (5) PCL info: normal weight(0) / bold(3) / extra bold(4), etc.
   (6) PCL info: "symbol set" i.e. native character set/encoding.
   	(277 = Roman-8 i.e. default set; 14 = ISO8859-1 i.e. ECMA-94 Latin 1;
	621 = PS Symbol; 18540 = Wingdings.  In PCL as opposed to HP-GL/2,
	these numbers are encoded base 32, as a number and a letter.  E.g.,
	621 is written as 19M since 19*32+13, and 'M' is letter #13.)
	Note: even for ISO-Latin-1 fonts we do NOT specify `14'; we
	specify `277' instead, since we use HP's Roman-8 for the lower
	half of the font and HP's Latin 1 for the upper half.  See 
	comments in h_text.c.
   (7) and (8) normalized font ascent and descent (from font bounding box).
   (9ab) normalized cap height and x height (latter not yet implemented)
   (10) the character width information (array, size 256).
   (11) the character offset, or `left edge' information (array, size 256).  
        [Our HP/GL-2, i.e. PCL 5 driver needs this, since HP-GL/2 and PCL 5 
	rendering begin at the left edge of the bounding box, unlike 
	PS rendering.  We shift	rightward to compensate.  See h_text.c.]
   (12) a typeface id (an index into the _pl_g_ps_typeface_info[] array below).
   (13) a font index (which font within the typeface this is).
   (14) an `iso8859-1' flag (refers to character set after re-encoding if any;
        true for all but Wingdings and Symbol).
*/

/* IMPORTANT: The fonts in this array may be referred to elsewhere in the
   code by number.  If you change the numbering of PCL fonts, i.e., the
   order in which they appear in this array, be sure to update, e.g., the
   definitions PL_DEFAULT_PCL_FONT_INDEX, etc. in extern.h. */

const struct plPCLFontInfoStruct _pl_g_pcl_font_info[] = {
{
  "Univers",			/* #0 */
  NULL,
  NULL,
  "univers-medium-r-normal",
  "Univers", "sans-serif", "normal", "normal", "normal",
  4148, 1, 0, 0, 277,
  987, 250,
  688, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 332, 332, 498, 627, 627, 996, 756, 332,
    332, 332, 627, 996, 332, 996, 332, 332, 627, 627,
    627, 627, 627, 627, 627, 627, 627, 627, 332, 332,
    996, 996, 996, 517, 996, 738, 627, 701, 719, 572,
    553, 738, 719, 276, 553, 664, 535, 904, 719, 756,
    590, 774, 646, 646, 627, 719, 719, 996, 719, 682,
    608, 332, 332, 332, 498, 498, 332, 535, 572, 535,
    572, 535, 369, 572, 572, 240, 240, 535, 240, 867,
    572, 572, 572, 572, 351, 498, 369, 572, 553, 867,
    553, 553, 479, 443, 498, 443, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    332, 332, 627, 627, 627, 627, 498, 627, 627, 498,
    406, 553, 996, 332, 498, 627, 627, 996, 387, 387,
    627, 553, 627, 332, 627, 387, 406, 553, 996, 996,
    996, 517, 738, 738, 738, 738, 738, 738, 977, 701,
    572, 572, 572, 572, 276, 276, 276, 276, 719, 719,
    756, 756, 756, 756, 756, 996, 756, 719, 719, 719,
    719, 682, 590, 608, 535, 535, 535, 535, 535, 535,
    848, 535, 535, 535, 535, 535, 240, 240, 240, 240,
    572, 572, 572, 572, 572, 572, 572, 996, 572, 572,
    572, 572, 572, 553, 572, 553
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 117, 110, 71, 132, 124, 78, 79,
    96, 61, 155, 232, 82, 231, 116, 44,
    47, 151, 82, 70, 46, 87, 76, 80,
    67, 76, 115, 79, 201, 232, 201, 102,
    78, 33, 87, 69, 91, 90, 88, 64,
    87, 92, 36, 101, 87, 84, 83, 71,
    85, 73, 89, 66, 35, 86, 32, 28,
    40, 26, 49, 96, 29, 57, 48, 0,
    72, 56, 76, 52, 46, 49, 35, 49,
    72, 71, -10, 88, 73, 72, 72, 52,
    73, 51, 72, 47, 22, 68, 31, 50,
    33, 32, 48, 97, 224, 71, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 111, 123, 113, 75, 0, 224, 166,
    178, 147, 59, 81, 234, 45, 147, 149,
    151, 234, 62, 48, 262, -61, 117, 116,
    238, 89, 52, 81, 173, 177, 166, 107,
    33, 33, 33, 33, 33, 33, 17, 69,
    90, 90, 90, 90, 12, 63, -12, 4,
    21, 83, 71, 71, 71, 71, 71, 264,
    60, 86, 86, 86, 86, 26, 85, 73,
    56, 56, 56, 56, 56, 56, 54, 52,
    49, 49, 49, 49, -11, 41, -32, -17,
    53, 72, 52, 52, 52, 52, 52, 231,
    51, 68, 68, 68, 68, 32, 73, 32
  },
      0, 1, true,
},
{
  "Univers-Oblique",		/* #1 */
  NULL,
  NULL,
  "univers-medium-o-normal",
  "Univers", "sans-serif", "oblique", "normal", "normal",
  4148, 1, 1, 0, 277,
  989, 250,
  688, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 332, 332, 498, 627, 627, 996, 756, 332,
    332, 332, 627, 996, 332, 996, 332, 332, 627, 627,
    627, 627, 627, 627, 627, 627, 627, 627, 332, 332,
    996, 996, 996, 517, 996, 738, 627, 701, 719, 572,
    553, 738, 719, 276, 553, 664, 535, 904, 719, 756,
    590, 774, 646, 646, 627, 719, 719, 996, 719, 682,
    608, 332, 332, 332, 498, 498, 332, 535, 572, 535,
    572, 535, 369, 572, 572, 240, 240, 535, 240, 867,
    572, 572, 572, 572, 351, 498, 369, 572, 553, 867,
    553, 553, 479, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    332, 332, 627, 627, 627, 627, 498, 627, 627, 498,
    406, 553, 996, 332, 498, 627, 627, 996, 387, 387,
    627, 553, 627, 332, 627, 387, 406, 553, 996, 996,
    996, 517, 738, 738, 738, 738, 738, 738, 977, 701,
    572, 572, 572, 572, 276, 276, 276, 276, 719, 719,
    756, 756, 756, 756, 756, 996, 756, 719, 719, 719,
    719, 682, 590, 608, 535, 535, 535, 535, 535, 535,
    848, 535, 535, 535, 535, 535, 240, 240, 240, 240,
    572, 572, 572, 572, 572, 572, 572, 996, 572, 572,
    572, 572, 572, 553, 572, 553
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 47, 210, 93, 140, 171, 86, 154,
    104, -17, 208, 234, -19, 235, 42, -67,
    59, 219, 47, 63, 27, 64, 86, 148,
    57, 43, 44, -21, 201, 238, 201, 88,
    115, -41, 24, 87, 19, 23, 23, 89,
    18, 18, 3, 34, 24, 24, 21, 85,
    23, 91, 22, 51, 142, 80, 161, 146,
    -11, 155, -16, 11, 146, -53, 48, 0,
    137, 22, 9, 45, 44, 44, 51, -6,
    5, 6, -124, 8, 7, 5, 5, 40,
    -49, 45, 11, 14, 83, 40, 91, 110,
    -17, 86, -2, 116, 224, -71, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -25, 138, 39, 77, 91, 224, 166,
    288, 147, 113, 83, 235, 44, 147, 240,
    206, 231, 90, 93, 333, -61, 117, 131,
    118, 178, 110, 29, 188, 167, 174, 15,
    -41, -41, -41, -41, -41, -41, -61, 87,
    23, 23, 23, 23, 18, 18, 18, 18,
    19, 21, 85, 85, 85, 85, 85, 281,
    5, 80, 80, 80, 80, 155, 22, 14,
    22, 22, 22, 22, 22, 22, 35, 45,
    44, 44, 44, 44, 6, 6, 6, 6,
    46, 5, 40, 40, 40, 40, 40, 233,
    -2, 40, 40, 40, 40, 86, -49, 86
  },
      0, 2, true,
},
{
  "Univers-Bold",		/* #2 */
  NULL,
  NULL,
  "univers-bold-r-normal",
  "Univers", "sans-serif", "normal", "bold", "normal",
  4148, 1, 0, 3, 277,
  976, 250,
  688, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 332, 332, 517, 627, 627, 996, 756, 332,
    332, 332, 627, 996, 332, 996, 332, 332, 627, 627,
    627, 627, 627, 627, 627, 627, 627, 627, 332, 332,
    996, 996, 996, 517, 996, 738, 627, 701, 719, 572,
    553, 738, 719, 276, 553, 664, 535, 904, 719, 756,
    590, 774, 646, 646, 627, 719, 719, 996, 719, 682,
    608, 332, 332, 332, 498, 498, 332, 535, 572, 535,
    572, 535, 369, 572, 572, 240, 240, 535, 240, 867,
    572, 572, 572, 572, 351, 498, 369, 572, 553, 867,
    553, 553, 479, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    332, 332, 627, 627, 627, 627, 498, 627, 627, 498,
    406, 553, 996, 332, 498, 627, 627, 996, 387, 387,
    627, 590, 627, 332, 627, 387, 406, 553, 996, 996,
    996, 517, 738, 738, 738, 738, 738, 738, 977, 701,
    572, 572, 572, 572, 276, 276, 276, 276, 719, 719,
    756, 756, 756, 756, 756, 996, 756, 719, 719, 719,
    719, 682, 590, 608, 535, 535, 535, 535, 535, 535,
    848, 535, 535, 535, 535, 535, 240, 240, 240, 240,
    572, 572, 572, 572, 572, 572, 572, 996, 572, 572,
    572, 572, 572, 553, 572, 553
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 105, 100, 21, 99, 87, 64, 74,
    74, 74, 119, 218, 79, 218, 117, 47,
    47, 137, 76, 55, 32, 78, 62, 75,
    49, 58, 117, 80, 201, 220, 201, 76,
    43, 20, 74, 59, 74, 69, 72, 56,
    76, 69, 15, 86, 74, 71, 66, 59,
    73, 61, 73, 48, 33, 68, 22, 23,
    24, 25, 48, 96, 32, 51, 48, 0,
    84, 42, 63, 51, 43, 42, 29, 46,
    60, 49, -40, 70, 55, 63, 60, 44,
    60, 60, 61, 42, 22, 58, 26, 44,
    27, 24, 44, 79, 224, 60, 188, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 105, 92, 76, 48, 0, 224, 138,
    158, 147, 60, 67, 218, 63, 147, 174,
    128, 219, 50, 46, 232, -61, 117, 120,
    214, 91, 44, 59, 136, 136, 123, 86,
    20, 20, 20, 20, 20, 20, 20, 59,
    69, 69, 69, 69, 4, 32, -21, -24,
    18, 66, 59, 59, 59, 59, 59, 241,
    54, 68, 68, 68, 68, 25, 73, 64,
    42, 42, 42, 42, 42, 42, 42, 51,
    42, 42, 42, 42, -25, 19, -46, -41,
    43, 60, 44, 44, 44, 44, 44, 219,
    44, 58, 58, 58, 58, 24, 60, 24
  },
      0, 3, true,
},
{
  "Univers-BoldOblique",	/* #3 */
  NULL,
  NULL,
  "univers-bold-o-normal",
  "Univers", "sans-serif", "oblique", "bold", "normal",
  4148, 1, 1, 3, 277,
  976, 250,
  688, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 332, 332, 535, 627, 627, 996, 756, 332,
    332, 332, 627, 996, 332, 996, 332, 332, 627, 627,
    627, 627, 627, 627, 627, 627, 627, 627, 332, 332,
    996, 996, 996, 517, 996, 738, 627, 701, 719, 572,
    553, 738, 719, 276, 553, 664, 535, 904, 719, 756,
    590, 774, 646, 646, 627, 719, 719, 996, 719, 682,
    608, 332, 332, 332, 498, 498, 332, 535, 572, 535,
    572, 535, 369, 572, 572, 240, 240, 535, 240, 867,
    572, 572, 572, 572, 351, 498, 369, 572, 553, 867,
    553, 553, 479, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    332, 332, 627, 627, 627, 627, 498, 627, 627, 498,
    406, 553, 996, 332, 498, 627, 627, 996, 387, 387,
    627, 590, 627, 332, 627, 387, 406, 553, 996, 996,
    996, 517, 738, 738, 738, 738, 738, 738, 977, 701,
    572, 572, 572, 572, 276, 276, 276, 276, 719, 719,
    756, 756, 756, 756, 756, 996, 756, 719, 719, 719,
    719, 682, 590, 608, 535, 535, 535, 535, 535, 535,
    848, 535, 535, 535, 535, 535, 240, 240, 240, 240,
    572, 572, 572, 572, 572, 572, 572, 996, 572, 572,
    572, 572, 572, 553, 572, 553
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 48, 168, 53, 104, 128, 59, 148,
    82, -33, 175, 229, -19, 229, 33, -63,
    63, 193, 34, 36, 2, 51, 63, 105,
    33, 36, 33, -22, 201, 243, 201, 86,
    88, -27, 3, 74, 3, 4, 4, 80,
    6, -8, -1, 29, 5, 1, -2, 77,
    4, 77, 4, 45, 132, 64, 148, 145,
    -22, 149, -21, -25, 112, -69, 48, 0,
    129, 13, -10, 34, 32, 27, 39, -27,
    -8, -21, -170, -2, -20, -9, -6, 32,
    -60, 32, -8, 11, 70, 25, 82, 100,
    -40, 70, -6, 101, 224, -78, 188, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -36, 105, 50, 48, 51, 224, 138,
    257, 147, 105, 42, 229, 40, 147, 275,
    188, 228, 85, 86, 329, -61, 117, 128,
    119, 159, 105, -6, 151, 169, 146, -3,
    -27, -27, -27, -27, -27, -27, -56, 74,
    4, 4, 4, 4, -8, -8, -8, -8,
    3, -2, 77, 77, 77, 77, 77, 276,
    4, 64, 64, 64, 64, 149, 4, -8,
    13, 13, 13, 13, 13, 13, 16, 34,
    27, 27, 27, 27, -21, -21, -21, -21,
    32, -6, 32, 32, 32, 32, 32, 231,
    -14, 25, 25, 25, 25, 70, -59, 70
  },
      0, 4, true,
},
{
  "UniversCondensed",		/* #4 */
  NULL,
  NULL,
  "univers-medium-r-condensed",
  "Univers", "sans-serif", "normal", "normal", "condensed",
  4148, 1, 4, 0, 277,
  932, 250,
  688, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 221, 295, 369, 461, 461, 664, 608, 221,
    221, 221, 461, 664, 221, 664, 221, 221, 461, 461,
    461, 461, 461, 461, 461, 461, 461, 461, 221, 221,
    996, 664, 996, 424, 664, 517, 498, 498, 517, 424,
    406, 517, 517, 221, 424, 498, 387, 682, 535, 517,
    461, 517, 498, 479, 479, 517, 461, 682, 517, 461,
    461, 221, 221, 221, 498, 498, 221, 406, 406, 387,
    406, 387, 295, 406, 406, 185, 185, 406, 185, 608,
    406, 406, 406, 406, 276, 369, 295, 406, 387, 646,
    387, 406, 332, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    221, 295, 461, 461, 461, 461, 498, 461, 461, 498,
    276, 442, 664, 221, 498, 461, 461, 664, 276, 276,
    461, 553, 461, 221, 461, 276, 276, 442, 664, 664,
    664, 424, 517, 517, 517, 517, 517, 517, 701, 498,
    424, 424, 424, 424, 221, 221, 221, 221, 517, 535,
    517, 517, 517, 517, 517, 664, 517, 517, 517, 517,
    517, 461, 461, 442, 406, 406, 406, 406, 406, 406,
    627, 387, 387, 387, 387, 387, 221, 221, 221, 221,
    406, 406, 406, 406, 406, 406, 406, 664, 406, 406,
    406, 406, 406, 406, 406, 406
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 98, 62, 28, 86, 74, 56, 45,
    50, 42, 85, 141, 28, 141, 62, 36,
    52, 115, 57, 51, 21, 63, 59, 68,
    50, 51, 62, 28, 201, 141, 201, 67,
    60, 40, 68, 69, 67, 65, 66, 64,
    65, 68, 23, 72, 65, 66, 63, 65,
    66, 63, 65, 47, 36, 67, 26, 36,
    34, 31, 46, 52, 36, 27, 48, 0,
    40, 48, 49, 50, 48, 41, 36, 46,
    53, 47, -4, 60, 51, 41, 50, 49,
    53, 47, 53, 36, 33, 49, 32, 27,
    29, 32, 36, 97, 224, 71, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 98, 90, 88, 77, 44, 224, 82,
    105, 147, 26, 54, 141, 46, 147, 122,
    84, 141, 35, 37, 177, -61, 117, 62,
    141, 58, 24, 53, 101, 81, 82, 67,
    40, 40, 40, 40, 40, 40, 35, 69,
    65, 65, 65, 65, 17, 52, 7, -12,
    13, 63, 65, 65, 65, 65, 65, 152,
    68, 67, 67, 67, 67, 31, 68, 54,
    48, 48, 48, 48, 48, 48, 46, 50,
    41, 41, 41, 41, 4, 45, 2, -17,
    49, 50, 49, 49, 49, 49, 49, 143,
    49, 49, 49, 49, 49, 32, 53, 32
  },
      1, 1, true,
},
{
  "UniversCondensed-Oblique",	/* #5 */
  NULL,
  NULL,
  "univers-medium-o-condensed",
  "Univers", "sans-serif", "oblique", "normal", "condensed",
  4148, 1, 5, 0, 277,
  933, 250,
  688, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 221, 295, 369, 461, 461, 664, 608, 221,
    221, 221, 461, 664, 221, 664, 221, 221, 461, 461,
    461, 461, 461, 461, 461, 461, 461, 461, 221, 221,
    996, 664, 996, 424, 664, 517, 498, 498, 517, 424,
    406, 517, 517, 221, 424, 498, 387, 682, 535, 517,
    461, 517, 498, 479, 479, 517, 461, 682, 517, 461,
    461, 221, 295, 221, 498, 498, 221, 406, 406, 387,
    406, 387, 295, 406, 406, 185, 185, 406, 185, 608,
    406, 406, 406, 406, 276, 369, 295, 406, 387, 646,
    387, 406, 332, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    221, 295, 461, 461, 461, 461, 498, 461, 461, 498,
    295, 442, 664, 221, 498, 461, 461, 664, 276, 276,
    461, 553, 461, 221, 461, 276, 295, 442, 664, 664,
    664, 424, 517, 517, 517, 517, 517, 517, 701, 498,
    424, 424, 424, 424, 221, 221, 221, 221, 517, 535,
    517, 517, 517, 517, 517, 664, 517, 517, 517, 517,
    517, 461, 461, 442, 406, 406, 406, 406, 406, 406,
    627, 387, 387, 387, 387, 387, 221, 221, 221, 221,
    406, 406, 406, 406, 406, 406, 406, 664, 406, 406,
    406, 406, 406, 406, 406, 406
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 27, 140, 49, 78, 76, 43, 106,
    23, -71, 165, 129, -59, 129, -1, -82,
    25, 129, -15, 22, 23, 45, 49, 44,
    45, 31, -10, -59, 201, 130, 201, 73,
    11, -39, -8, 30, -9, -9, -5, 37,
    -7, -10, -21, -1, -8, -11, -12, 33,
    -4, 31, -8, 12, 122, 36, 98, 96,
    -35, 105, -31, -52, 97, -95, 48, 0,
    106, 3, -19, 19, 6, 9, 21, -48,
    -19, -22, -140, -5, -23, -19, -19, 18,
    -75, 11, -19, 0, 44, 11, 66, 63,
    -33, -23, -32, 116, 224, -71, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -20, 88, 30, 77, 2, 224, 107,
    190, 147, 95, 66, 129, 37, 147, 181,
    163, 131, 61, 86, 266, -61, 117, 77,
    -21, 145, 95, 20, 61, 44, 87, -27,
    -39, -39, -39, -39, -39, -39, -38, 21,
    -9, -9, -9, -9, -10, -10, -10, -10,
    -9, -12, 33, 33, 33, 33, 33, 158,
    29, 36, 36, 36, 36, 105, -3, -23,
    3, 3, 3, 3, 3, 3, 13, -35,
    9, 9, 9, 9, -4, -4, -4, -4,
    15, -19, 18, 18, 18, 18, 18, 151,
    14, 11, 11, 11, 11, -23, -75, -23
  },
      1, 2, true,
},
{
  "UniversCondensed-Bold",	/* #6 */
  NULL,
  NULL,
  "univers-bold-r-condensed",
  "Univers", "sans-serif", "normal", "bold", "condensed",
  4148, 1, 4, 3, 277,
  950, 250,
  688, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 221, 295, 406, 479, 479, 664, 627, 221,
    221, 221, 479, 664, 221, 664, 221, 221, 479, 479,
    479, 479, 479, 479, 479, 479, 479, 479, 221, 221,
    996, 664, 996, 442, 664, 553, 535, 517, 553, 461,
    442, 553, 553, 258, 479, 535, 424, 738, 572, 553,
    517, 572, 517, 535, 498, 553, 517, 774, 553, 517,
    461, 221, 221, 221, 498, 498, 221, 442, 442, 406,
    442, 424, 313, 442, 461, 240, 240, 442, 240, 664,
    461, 442, 442, 442, 332, 406, 313, 461, 442, 701,
    442, 442, 369, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    221, 295, 479, 479, 479, 479, 498, 479, 479, 498,
    406, 442, 664, 221, 498, 479, 479, 664, 313, 313,
    479, 590, 479, 221, 479, 313, 406, 442, 664, 664,
    664, 442, 553, 553, 553, 553, 553, 553, 774, 517,
    461, 461, 461, 461, 258, 258, 258, 258, 553, 572,
    553, 553, 553, 553, 553, 664, 553, 553, 553, 553,
    553, 517, 517, 498, 442, 442, 442, 442, 442, 442,
    664, 406, 424, 424, 424, 424, 240, 240, 240, 240,
    442, 461, 442, 442, 442, 442, 442, 664, 442, 461,
    461, 461, 461, 442, 442, 442
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 89, 46, -14, 73, 36, 42, 43,
    45, 22, 85, 104, 35, 105, 50, 29,
    52, 110, 61, 57, 32, 60, 57, 53,
    55, 55, 50, 35, 201, 105, 201, 49,
    31, 41, 65, 57, 69, 67, 66, 62,
    70, 61, 32, 70, 70, 61, 69, 63,
    63, 67, 60, 51, 31, 64, 27, 25,
    34, 26, 33, 45, 31, 32, 48, 0,
    36, 38, 46, 40, 46, 38, 24, 46,
    57, 58, -4, 58, 59, 44, 56, 46,
    46, 46, 58, 31, 21, 55, 29, 15,
    25, 26, 34, 79, 224, 60, 188, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 89, 81, 61, 48, 19, 224, 75,
    105, 147, 71, 34, 105, 40, 147, 86,
    85, 104, 48, 50, 177, -61, 117, 50,
    134, 70, 76, 34, 69, 57, 50, 63,
    41, 41, 41, 41, 41, 41, 16, 57,
    67, 67, 67, 67, 10, 55, 0, -10,
    15, 69, 63, 63, 63, 63, 63, 127,
    63, 64, 64, 64, 64, 26, 63, 57,
    38, 38, 38, 38, 38, 38, 40, 40,
    38, 38, 38, 38, -3, 42, -7, -14,
    46, 56, 46, 46, 46, 46, 46, 104,
    46, 55, 55, 55, 55, 26, 46, 26
  },
      1, 3, true,
},
{
  "UniversCondensed-BoldOblique", /* #7 */
  NULL,
  NULL,
  "univers-bold-o-condensed",
  "Univers", "sans-serif", "oblique", "bold", "condensed",
  4148, 1, 5, 3, 277,
  950, 250,
  688, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 221, 295, 406, 479, 479, 664, 627, 221,
    221, 221, 479, 664, 221, 664, 221, 221, 479, 479,
    479, 479, 479, 479, 479, 479, 479, 479, 221, 221,
    996, 664, 996, 442, 664, 553, 535, 517, 553, 461,
    442, 553, 553, 258, 479, 535, 424, 738, 572, 553,
    517, 572, 517, 535, 498, 553, 517, 774, 553, 517,
    461, 221, 313, 221, 498, 498, 221, 442, 442, 406,
    442, 424, 313, 442, 461, 240, 240, 442, 240, 664,
    461, 442, 442, 442, 332, 406, 313, 461, 442, 701,
    442, 442, 369, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    221, 295, 479, 479, 479, 479, 498, 479, 479, 498,
    406, 442, 664, 221, 498, 479, 479, 664, 313, 313,
    479, 590, 479, 221, 479, 313, 406, 442, 664, 664,
    664, 442, 553, 553, 553, 553, 553, 553, 774, 517,
    461, 461, 461, 461, 258, 258, 258, 258, 553, 572,
    553, 553, 553, 553, 553, 664, 553, 553, 553, 553,
    553, 517, 517, 498, 442, 442, 442, 442, 442, 442,
    664, 406, 424, 424, 424, 424, 240, 240, 240, 240,
    442, 461, 442, 442, 442, 442, 442, 664, 442, 461,
    461, 461, 461, 442, 442, 442
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 12, 131, 24, 61, 41, 32, 103,
    21, -77, 182, 104, -66, 105, -23, -79,
    26, 137, -18, 23, 1, 30, 29, 38,
    27, 19, -23, -64, 201, 105, 201, 78,
    6, -43, -2, 36, -3, -5, -10, 45,
    -8, -12, 9, -2, -7, -9, -4, 42,
    -7, 42, -8, 31, 109, 47, 111, 76,
    -45, 117, -34, -49, 114, -68, 48, 0,
    93, 5, -23, 12, 10, 11, 14, -45,
    -14, -16, -125, -11, -17, -20, -16, 14,
    -80, 8, -14, -2, 37, 18, 70, 56,
    -46, -25, -35, 101, 224, -78, 188, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -52, 74, 2, 48, 18, 224, 108,
    201, 147, 138, 38, 105, 27, 147, 223,
    171, 104, 66, 89, 250, -61, 117, 57,
    33, 148, 145, -20, 6, -5, 56, -36,
    -43, -43, -43, -43, -43, -43, -70, 36,
    -5, -5, -5, -5, -12, -12, -12, -12,
    -3, -4, 42, 42, 42, 42, 42, 143,
    42, 47, 47, 47, 47, 117, -6, -15,
    5, 5, 5, 5, 5, 5, 13, -21,
    11, 11, 11, 11, -15, -15, -15, -15,
    14, -16, 14, 14, 14, 14, 14, 104,
    14, 18, 18, 18, 18, -25, -80, -25
  },
      1, 4, true,
},
{
  "CGTimes",			/* #8 */
  NULL,
  NULL,
  "cg times-medium-r-normal",
  "CG Times", "serif", "normal", "normal", "normal",
  4101, 1, 0, 0, 277,
  910, 250,
  679, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 295, 332, 461, 498, 498, 885, 774, 332,
    332, 332, 498, 885, 332, 885, 332, 332, 498, 498,
    498, 498, 498, 498, 498, 498, 498, 498, 332, 332,
    996, 885, 996, 442, 885, 719, 627, 682, 738, 627,
    590, 719, 738, 332, 387, 701, 627, 904, 738, 719,
    572, 719, 664, 535, 627, 738, 719, 940, 719, 719,
    646, 332, 332, 332, 498, 498, 332, 442, 498, 442,
    498, 442, 332, 498, 498, 276, 276, 498, 276, 774,
    498, 498, 498, 498, 369, 387, 276, 498, 498, 719,
    498, 498, 442, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    295, 332, 498, 498, 498, 498, 498, 498, 498, 498,
    498, 406, 885, 332, 498, 498, 498, 885, 351, 351,
    498, 553, 498, 332, 498, 351, 498, 406, 885, 885,
    885, 442, 719, 719, 719, 719, 719, 719, 885, 682,
    627, 627, 627, 627, 332, 332, 332, 332, 738, 738,
    719, 719, 719, 719, 719, 885, 719, 738, 738, 738,
    738, 719, 572, 498, 442, 442, 442, 442, 442, 442,
    664, 442, 442, 442, 442, 442, 276, 276, 276, 276,
    498, 498, 498, 498, 498, 498, 498, 885, 498, 498,
    498, 498, 498, 498, 498, 498
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 109, 118, 9, 47, 146, 30, 98,
    49, 19, 78, 158, 98, 165, 109, 32,
    20, 118, 19, 39, 16, 29, 33, 20,
    48, 33, 109, 98, 201, 159, 201, 40,
    33, 17, 20, 38, 31, 27, 28, 36,
    25, 26, 6, 18, 32, 26, 31, 34,
    28, 36, 24, 41, 28, 28, 19, 9,
    18, 26, 37, 87, 28, 19, 48, 0,
    98, 30, 1, 26, 21, 25, 34, 25,
    7, 37, -74, 16, 27, 15, 19, 28,
    -1, 32, 25, 51, 14, -4, 13, 20,
    25, 8, 13, 82, 224, 69, 189, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 109, 66, 34, 13, 8, 224, 83,
    116, 95, 113, 33, 166, 40, 95, 85,
    121, 159, 45, 47, 176, 27, 65, 108,
    125, 84, 99, 33, 158, 107, 122, 67,
    17, 17, 17, 17, 17, 17, -1, 38,
    27, 27, 27, 27, 26, 26, 26, 26,
    31, 31, 34, 34, 34, 34, 34, 189,
    6, 28, 28, 28, 28, 26, 28, 10,
    30, 30, 30, 30, 30, 30, 55, 26,
    25, 25, 25, 25, 31, 37, 28, 11,
    27, 19, 28, 28, 28, 28, 28, 145,
    0, -4, -4, -4, -4, 8, -1, 8
  },
      2, 1, true,
},
{
  "CGTimes-Italic",		/* #9 */
  NULL,
  NULL,
  "cg times-medium-i-normal",
  "CG Times", "serif", "italic", "normal", "normal",
  4101, 1, 1, 0, 277,
  910, 250,
  679, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 295, 332, 479, 498, 498, 885, 774, 332,
    332, 332, 498, 885, 332, 885, 332, 332, 498, 498,
    498, 498, 498, 498, 498, 498, 498, 498, 332, 332,
    996, 885, 996, 498, 885, 608, 608, 664, 719, 608,
    572, 719, 719, 332, 442, 664, 553, 830, 664, 719,
    608, 719, 608, 498, 553, 719, 608, 830, 608, 553,
    553, 332, 332, 332, 498, 498, 332, 498, 498, 442,
    498, 442, 276, 498, 498, 276, 276, 442, 276, 719,
    498, 498, 498, 498, 387, 387, 276, 498, 442, 664,
    442, 442, 387, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    295, 332, 498, 498, 498, 498, 498, 498, 498, 498,
    498, 461, 885, 332, 498, 498, 498, 885, 351, 351,
    498, 553, 498, 332, 498, 351, 498, 461, 885, 885,
    885, 498, 608, 608, 608, 608, 608, 608, 885, 664,
    608, 608, 608, 608, 332, 332, 332, 332, 719, 664,
    719, 719, 719, 719, 719, 885, 719, 719, 719, 719,
    719, 553, 608, 498, 498, 498, 498, 498, 498, 498,
    664, 442, 442, 442, 442, 442, 276, 276, 276, 276,
    498, 498, 498, 498, 498, 498, 498, 885, 498, 498,
    498, 498, 498, 442, 498, 442
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 76, 194, 53, 31, 166, 62, 186,
    128, -29, 110, 164, 25, 165, 74, 20,
    41, 43, 28, 25, 26, 12, 44, 106,
    38, 33, 73, 25, 201, 171, 201, 158,
    59, -53, -15, 83, -37, -19, -16, 73,
    -11, -15, -18, -4, -44, -25, -10, 68,
    8, 63, -23, 27, 53, 112, 94, 81,
    -29, 91, -15, -10, 134, -89, 48, 0,
    186, 11, 10, 38, 9, 33, -160, 1,
    4, 34, -147, -4, 39, 8, 10, 22,
    -101, 25, 34, 7, 24, 32, 35, 23,
    -49, -46, -19, 114, 224, -35, 189, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 40, 79, -25, 13, 50, 224, 102,
    202, 95, 119, 37, 166, 44, 95, 211,
    184, 162, 71, 79, 254, 27, 65, 141,
    53, 97, 150, 31, 143, 111, 163, 28,
    -53, -53, -53, -53, -53, -53, -24, 83,
    -19, -19, -19, -19, -15, -15, -15, -15,
    -37, -10, 68, 68, 68, 68, 68, 188,
    41, 112, 112, 112, 112, 91, 8, -171,
    11, 11, 11, 11, 11, 11, 21, 26,
    33, 33, 33, 33, 34, 34, 34, 34,
    22, 10, 22, 22, 22, 22, 22, 162,
    -5, 32, 32, 32, 32, -46, -101, -46
  },
      2, 2, true,
},
{
  "CGTimes-Bold",		/* #10 */
  NULL,
  NULL,
  "cg times-bold-r-normal",
  "CG Times", "serif", "normal", "bold", "normal",
  4101, 1, 0, 3, 277,
  944, 250,
  685, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 295, 332, 461, 498, 498, 885, 830, 332,
    332, 332, 498, 885, 332, 885, 332, 332, 498, 498,
    498, 498, 498, 498, 498, 498, 498, 498, 332, 332,
    996, 885, 996, 498, 885, 719, 664, 719, 719, 664,
    608, 774, 774, 387, 479, 774, 664, 940, 719, 774,
    608, 774, 719, 553, 664, 719, 719, 996, 719, 719,
    664, 332, 332, 332, 498, 498, 332, 498, 553, 442,
    553, 442, 351, 498, 553, 276, 332, 553, 276, 830,
    553, 498, 553, 553, 442, 387, 332, 553, 498, 719,
    498, 498, 442, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    295, 332, 498, 498, 498, 498, 498, 498, 498, 498,
    498, 424, 885, 332, 498, 498, 498, 885, 351, 351,
    498, 553, 498, 332, 498, 351, 498, 424, 885, 885,
    885, 498, 719, 719, 719, 719, 719, 719, 1033, 719,
    664, 664, 664, 664, 387, 387, 387, 387, 719, 719,
    774, 774, 774, 774, 774, 885, 774, 719, 719, 719,
    719, 719, 608, 553, 498, 498, 498, 498, 498, 498,
    719, 442, 442, 442, 442, 442, 276, 276, 276, 276,
    498, 553, 498, 498, 498, 498, 498, 885, 498, 553,
    553, 553, 553, 498, 553, 498
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 84, 76, 12, 34, 76, 59, 73,
    66, 10, 56, 122, 73, 153, 83, 31,
    23, 64, 6, 11, 21, 21, 25, 21,
    24, 24, 83, 73, 201, 152, 201, 57,
    22, 20, 18, 38, 15, 14, 20, 40,
    15, 22, -12, 28, 22, 13, 13, 31,
    18, 32, 14, 45, 29, 7, 12, 13,
    17, 19, 21, 73, 21, 8, 48, 0,
    73, 24, 16, 21, 39, 26, 29, 30,
    16, 19, -76, 20, 20, 14, 17, 24,
    30, 37, 22, 27, 7, 16, 12, 13,
    12, 12, 15, 71, 224, 59, 203, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 78, 57, 6, 48, -17, 224, 72,
    87, 95, 87, 31, 147, 31, 95, 94,
    108, 143, 26, 27, 186, 21, 65, 81,
    118, 56, 94, 31, 83, 74, 61, 57,
    20, 20, 20, 20, 20, 20, 21, 38,
    14, 14, 14, 14, 22, 22, 22, 22,
    15, 13, 31, 31, 31, 31, 31, 167,
    32, 7, 7, 7, 7, 19, 18, 30,
    24, 24, 24, 24, 24, 24, 34, 21,
    26, 26, 26, 26, 16, 19, -2, -26,
    24, 17, 24, 24, 24, 24, 24, 153,
    24, 16, 16, 16, 16, 12, 30, 12
  },
      2, 3, true,
},
{
  "CGTimes-BoldItalic",		/* #11 */
  NULL,
  NULL,
  "cg times-bold-i-normal",
  "CG Times", "serif", "italic", "bold", "normal",
  4101, 1, 1, 3, 277,
  944, 250,
  685, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 295, 387, 517, 498, 498, 885, 774, 332,
    332, 332, 498, 885, 332, 885, 332, 332, 498, 498,
    498, 498, 498, 498, 498, 498, 498, 498, 332, 332,
    996, 885, 996, 498, 885, 664, 664, 664, 719, 664,
    608, 719, 774, 387, 498, 664, 608, 885, 719, 719,
    608, 701, 664, 553, 608, 719, 664, 885, 664, 608,
    608, 332, 332, 332, 498, 498, 332, 498, 498, 442,
    498, 442, 351, 498, 553, 276, 276, 498, 276, 774,
    553, 498, 498, 498, 387, 387, 276, 553, 442, 664,
    498, 442, 387, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    295, 387, 498, 498, 498, 498, 498, 498, 498, 498,
    498, 442, 885, 332, 498, 498, 498, 885, 332, 332,
    498, 553, 498, 332, 498, 332, 498, 442, 885, 885,
    885, 498, 664, 664, 664, 664, 664, 664, 922, 664,
    664, 664, 664, 664, 387, 387, 387, 387, 719, 719,
    719, 719, 719, 719, 719, 885, 719, 719, 719, 719,
    719, 608, 608, 498, 498, 498, 498, 498, 498, 498,
    701, 442, 442, 442, 442, 442, 276, 276, 276, 276,
    498, 553, 498, 498, 498, 498, 498, 885, 498, 553,
    553, 553, 553, 442, 498, 442
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 67, 169, 40, 10, 107, 46, 156,
    62, -23, 119, 167, -8, 175, 45, 4,
    47, 21, -4, 7, -2, 17, 50, 86,
    41, 23, 47, -9, 201, 175, 201, 124,
    42, -42, 5, 65, -11, -4, -8, 50,
    1, -1, -6, 0, -19, -1, 3, 57,
    3, 56, 5, 29, 86, 105, 102, 100,
    -10, 98, 17, -28, 134, -95, 48, 0,
    156, 9, 14, 34, 9, 35, -135, -25,
    6, 20, -168, 4, 18, 8, 14, 23,
    -98, 24, 12, 16, 10, 40, 44, 47,
    -20, -71, -20, 86, 224, -38, 203, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 75, -6, 48, 19, 224, 72,
    162, 95, 141, 28, 174, 34, 95, 160,
    163, 160, 58, 71, 242, 21, 65, 123,
    29, 68, 137, 7, 110, 100, 123, -16,
    -42, -42, -42, -42, -42, -42, -39, 65,
    -4, -4, -4, -4, -1, -1, -1, -1,
    -11, 3, 57, 57, 57, 57, 57, 190,
    -29, 105, 105, 105, 105, 98, 3, -173,
    9, 9, 9, 9, 9, 9, 9, 1,
    35, 35, 35, 35, 22, 22, 22, 22,
    23, 14, 23, 23, 23, 23, 23, 176,
    -36, 40, 40, 40, 40, -71, -98, -71
  },
      2, 4, true,
},
{
  "AlbertusMedium",		/* #12 */
  NULL,
  NULL,
  "albertus-semibold-r-normal",
  "Albertus", "serif", "normal", "600", "normal",
  4362, 1, 0, 1, 277,
  997, 250,
  764, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    313, 313, 498, 627, 627, 940, 867, 313,
    406, 406, 627, 940, 313, 940, 313, 442,
    627, 627, 627, 627, 627, 627, 627, 627,
    627, 627, 313, 313, 996, 940, 996, 461,
    940, 793, 572, 682, 701, 553, 517, 774,
    756, 313, 406, 682, 535, 922, 812, 867,
    517, 867, 627, 517, 627, 793, 774, 940,
    682, 646, 608, 424, 442, 424, 498, 498,
    313, 461, 535, 461, 553, 479, 313, 479,
    535, 240, 240, 479, 240, 830, 535, 553,
    553, 535, 369, 351, 332, 535, 479, 701,
    479, 498, 387, 442, 498, 442, 996, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    313, 313, 627, 627, 627, 627, 498, 627,
    627, 498, 387, 461, 940, 313, 498, 627,
    517, 940, 387, 387, 627, 553, 627, 313,
    627, 387, 387, 461, 940, 940, 940, 461,
    793, 793, 793, 793, 793, 793, 977, 682,
    553, 553, 553, 553, 313, 313, 313, 313,
    756, 812, 867, 867, 867, 867, 867, 940,
    867, 793, 793, 793, 793, 646, 517, 590,
    461, 461, 461, 461, 461, 461, 738, 461,
    479, 479, 479, 479, 240, 240, 240, 240,
    553, 535, 553, 553, 553, 553, 553, 940,
    553, 535, 535, 535, 535, 498, 553, 498
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 62, 90, 14, 96, 49, 42, 53,
    96, 72, 114, 179, 14, 181, 75, 9,
    27, 155, 34, 83, 76, 83, 46, 92,
    76, 54, 75, 14, 201, 179, 201, 62,
    50, -1, 70, 44, 68, 81, 69, 42,
    74, 74, 3, 65, 70, 20, 21, 44,
    41, 45, 79, 67, 22, 69, 17, 9,
    11, 14, 34, 92, 9, 67, 48, 0,
    39, 32, 43, 34, 47, 37, 45, 41,
    45, 49, -11, 46, 48, 42, 49, 30,
    52, 31, 51, 22, 7, 40, 2, 1,
    -6, -7, 10, 97, 224, 71, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 62, 115, 78, 77, 2, 224, 92,
    164, 147, 56, 27, 177, 42, 147, 165,
    81, 179, 22, 43, 268, -61, 117, 74,
    206, 90, 18, 24, 121, 102, 99, 62,
    -1, -1, -1, -1, -1, -1, -6, 44,
    81, 81, 81, 81, 39, 74, 21, 8,
    56, 21, 44, 44, 44, 44, 44, 162,
    44, 69, 69, 69, 69, 14, 41, 75,
    32, 32, 32, 32, 32, 32, 31, 34,
    37, 37, 37, 37, 15, 48, -20, -30,
    27, 49, 30, 30, 30, 30, 30, 177,
    30, 40, 40, 40, 40, -7, 52, -7
  },
      3, 1, true,
},
{
  "AlbertusExtraBold",		/* #13 */
  NULL,
  NULL,
  "albertus-extrabold-r-normal",
  "Albertus", "serif", "normal", "800", "normal",
  4362, 1, 0, 4, 277,
  1017, 260,
  764, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    369, 369, 572, 664, 664, 977, 904, 369,
    498, 498, 664, 977, 369, 977, 369, 498,
    664, 664, 664, 664, 664, 664, 664, 664,
    664, 664, 369, 369, 996, 977, 996, 479,
    977, 774, 701, 719, 774, 608, 572, 774,
    812, 387, 442, 738, 572, 977, 848, 904,
    646, 904, 701, 535, 627, 812, 756, 977,
    756, 664, 664, 498, 498, 498, 498, 498,
    369, 498, 608, 479, 590, 517, 369, 553,
    590, 295, 295, 627, 295, 885, 590, 608,
    590, 590, 424, 424, 406, 590, 553, 793,
    627, 553, 461, 498, 498, 498, 996, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    369, 369, 664, 664, 664, 664, 498, 664,
    664, 498, 461, 517, 977, 369, 498, 664,
    553, 977, 461, 461, 664, 590, 664, 369,
    664, 461, 461, 517, 977, 977, 977, 479,
    774, 774, 774, 774, 774, 774, 1014, 719,
    608, 608, 608, 608, 387, 387, 387, 387,
    812, 848, 904, 904, 904, 904, 904, 977,
    904, 812, 812, 812, 812, 664, 646, 646,
    498, 498, 498, 498, 498, 498, 756, 479,
    517, 517, 517, 517, 295, 295, 295, 295,
    608, 590, 608, 608, 608, 608, 608, 977,
    608, 590, 590, 590, 590, 553, 590, 553
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 64, 81, 29, 57, 25, 38, 28,
    76, 76, 128, 198, -9, 196, 76, 7,
    30, 131, 25, 60, 49, 58, 60, 67,
    64, 58, 76, -9, 201, 197, 201, 51,
    35, -26, 62, 43, 70, 67, 74, 46,
    64, 68, -35, 59, 67, -10, -4, 41,
    67, 39, 60, 54, -9, 61, -24, -11,
    -13, -22, 24, 80, 7, 80, 48, 0,
    53, 10, 39, 28, 24, 27, -6, 27,
    30, 29, -44, 32, 28, 28, 29, 23,
    31, 20, 31, 27, -4, 25, -27, -26,
    -10, -36, 0, 79, 224, 60, 188, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 64, 66, 55, 48, 10, 224, 78,
    132, 147, 73, 17, 199, 42, 147, 133,
    94, 198, 34, 56, 255, -61, 117, 76,
    245, 89, 31, 17, 66, 42, 49, 51,
    -26, -26, -26, -26, -26, -26, -18, 43,
    67, 67, 67, 67, 27, 68, 13, -6,
    49, -4, 41, 41, 41, 41, 41, 202,
    41, 61, 61, 61, 61, -22, 67, 33,
    10, 10, 10, 10, 10, 10, 14, 28,
    27, 27, 27, 27, -20, 29, -40, -54,
    23, 29, 23, 23, 23, 23, 23, 198,
    23, 25, 25, 25, 25, -36, 31, -36
  },
      3, 3, true,
},
{
  "AntiqueOlive",		/* #14 */
  NULL,
  NULL,
  "antique olive-medium-r-normal",
  "Antique Olive", "sans-serif", "normal", "normal", "normal",
  4168, 1, 0, 0, 277,
  1038, 250,
  750, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 295, 313, 424, 590, 590, 1014, 719, 258,
    295, 295, 590, 1014, 295, 1014, 295, 313, 590, 590,
    590, 590, 590, 590, 590, 590, 590, 590, 295, 295,
    996, 1014, 996, 572, 1014, 701, 664, 608, 701, 590,
    572, 682, 738, 276, 461, 627, 517, 885, 738, 719,
    627, 719, 627, 535, 572, 719, 627, 977, 627, 627,
    608, 295, 313, 295, 498, 498, 258, 572, 701, 553,
    701, 627, 442, 664, 682, 295, 295, 572, 276, 1033,
    682, 682, 701, 701, 461, 461, 461, 664, 590, 904,
    553, 590, 517, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    295, 313, 590, 590, 590, 590, 498, 590, 590, 498,
    590, 535, 1014, 295, 498, 590, 590, 1014, 387, 387,
    590, 553, 590, 295, 590, 387, 590, 535, 1014, 1014,
    1014, 572, 701, 701, 701, 701, 701, 701, 1162, 608,
    590, 590, 590, 590, 276, 276, 276, 276, 701, 738,
    719, 719, 719, 719, 719, 1014, 719, 719, 719, 719,
    719, 627, 627, 627, 572, 572, 572, 572, 572, 572,
    996, 553, 627, 627, 627, 627, 295, 295, 295, 295,
    682, 682, 682, 682, 682, 682, 682, 1014, 682, 664,
    664, 664, 664, 590, 701, 590
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 80, 73, 91, 64, 76, 114, 66,
    64, 11, 130, 211, 63, 207, 80, -4,
    33, 67, 57, 70, 35, 85, 55, 53,
    41, 50, 80, 64, 201, 209, 201, 69,
    87, 20, 74, 41, 77, 74, 86, 50,
    89, 84, 14, 96, 101, 80, 78, 45,
    90, 47, 76, 40, 21, 85, 4, 0,
    8, -5, 59, 83, -4, 43, 48, 0,
    94, 32, 87, 53, 70, 57, 37, 44,
    91, 77, -42, 83, 94, 85, 91, 57,
    95, 69, 84, 35, 29, 82, 17, 15,
    11, 16, 41, 97, 224, 71, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 90, 61, 71, 77, 51, 224, 121,
    140, 147, 133, 53, 211, 36, 147, 164,
    116, 206, 47, 49, 223, -61, 117, 80,
    193, 56, 106, 39, 43, 36, 69, 69,
    20, 20, 20, 20, 20, 20, 8, 41,
    74, 74, 74, 74, -32, 0, -14, -18,
    25, 78, 45, 45, 45, 45, 45, 206,
    36, 85, 85, 85, 85, -5, 91, 83,
    32, 32, 32, 32, 32, 32, 48, 53,
    57, 57, 57, 57, -19, 20, -6, -12,
    55, 91, 57, 57, 57, 57, 57, 207,
    42, 82, 82, 82, 82, 16, 95, 16
  },
      4, 1, true,
},
{
  "AntiqueOlive-Italic",	/* #15 */
  NULL,
  NULL,
  "antique olive-medium-i-normal",
  "Antique Olive", "sans-serif", "oblique", "normal", "normal",
  4168, 1, 1, 0, 277,
  1035, 250,
  750, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 295, 295, 442, 590, 590, 996, 664, 295,
    295, 295, 590, 996, 295, 996, 295, 295, 590, 590,
    590, 590, 590, 590, 590, 590, 590, 590, 295, 295,
    996, 996, 996, 535, 996, 682, 627, 608, 719, 590,
    572, 682, 738, 258, 461, 608, 479, 867, 738, 719,
    627, 719, 608, 553, 553, 701, 646, 959, 627, 627,
    608, 295, 295, 295, 498, 498, 295, 608, 682, 572,
    682, 627, 424, 682, 682, 258, 276, 553, 258, 1014,
    682, 664, 682, 682, 424, 479, 461, 682, 608, 922,
    572, 590, 517, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    295, 295, 590, 590, 590, 590, 498, 590, 590, 498,
    590, 517, 996, 295, 498, 590, 590, 996, 387, 387,
    590, 553, 590, 295, 590, 387, 590, 517, 996, 996,
    996, 535, 682, 682, 682, 682, 682, 682, 1069, 608,
    590, 590, 590, 590, 258, 258, 258, 258, 719, 738,
    719, 719, 719, 719, 719, 996, 719, 701, 701, 701,
    701, 627, 627, 608, 608, 608, 608, 608, 608, 608,
    977, 572, 627, 627, 627, 627, 258, 258, 258, 258,
    664, 682, 664, 664, 664, 664, 664, 996, 664, 682,
    682, 682, 682, 590, 682, 590
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 143, 85, 40, 116, 35, 120,
    60, -44, 160, 198, -32, 198, 23, -68,
    33, 83, 7, 26, 9, 33, 50, 58,
    23, 19, 23, -33, 201, 199, 201, 100,
    87, -44, 21, 51, 25, 17, 19, 55,
    29, 15, -32, 22, 21, 22, 22, 51,
    23, 59, 21, 16, 81, 67, 103, 101,
    -42, 99, -1, 23, 113, -26, 48, 0,
    120, 26, 22, 45, 42, 50, 46, 46,
    28, 15, -127, 22, 16, 21, 28, 51,
    -5, 42, 19, 10, 70, 59, 73, 77,
    -32, 64, -8, 116, 224, -71, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, 70, 11, 77, 88, 224, 123,
    227, 147, 151, 51, 199, 32, 147, 250,
    154, 198, 58, 57, 288, -61, 117, 94,
    127, 68, 143, -18, 116, 131, 118, -12,
    -44, -44, -44, -44, -44, -44, -59, 51,
    17, 17, 17, 17, 15, 15, 15, 15,
    24, 22, 51, 51, 51, 51, 51, 200,
    -23, 67, 67, 67, 67, 99, 21, 21,
    26, 26, 26, 26, 26, 26, 20, 45,
    50, 50, 50, 50, 15, 15, 15, 15,
    51, 28, 51, 51, 51, 51, 51, 197,
    -12, 59, 59, 59, 59, 64, -5, 64
  },
      4, 2, true,
},
{
  "AntiqueOlive-Bold",		/* #16 */
  NULL,
  NULL,
  "antique olive-bold-r-normal",
  "Antique Olive", "sans-serif", "normal", "bold", "normal",
  4168, 1, 0, 3, 277,
  1055, 250,
  750, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 332, 369, 461, 664, 664, 1143, 812, 258,
    332, 332, 664, 1143, 332, 1143, 332, 406, 664, 664,
    664, 664, 664, 664, 664, 664, 664, 664, 332, 332,
    996, 1143, 996, 608, 1143, 756, 682, 646, 738, 608,
    608, 701, 738, 313, 517, 701, 553, 922, 756, 756,
    701, 756, 682, 590, 646, 719, 719, 1033, 719, 719,
    664, 332, 406, 332, 498, 498, 258, 646, 719, 590,
    719, 664, 517, 719, 719, 332, 332, 646, 313, 1051,
    719, 701, 719, 719, 517, 553, 535, 701, 664, 996,
    664, 664, 572, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    332, 369, 664, 664, 664, 664, 498, 664, 664, 498,
    553, 590, 1143, 332, 498, 664, 664, 1143, 442, 442,
    664, 590, 664, 332, 664, 442, 553, 590, 1143, 1143,
    1143, 608, 756, 756, 756, 756, 756, 756, 1143, 646,
    608, 608, 608, 608, 313, 313, 313, 313, 738, 756,
    756, 756, 756, 756, 756, 1143, 756, 719, 719, 719,
    719, 719, 701, 701, 646, 646, 646, 646, 646, 646,
    1033, 590, 664, 664, 664, 664, 332, 332, 332, 332,
    701, 719, 701, 701, 701, 701, 701, 1143, 701, 701,
    701, 701, 701, 664, 719, 664
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 74, 55, 98, 60, 119, 82, 32,
    33, 38, 144, 267, 68, 265, 53, 8,
    29, 68, 64, 74, 42, 76, 53, 72,
    25, 48, 53, 53, 201, 267, 201, 77,
    119, 12, 56, 43, 67, 56, 71, 36,
    66, 64, 30, 74, 70, 49, 58, 39,
    63, 39, 63, 34, 38, 63, 15, 12,
    21, 12, 47, 55, 8, 50, 48, 0,
    54, 35, 62, 37, 42, 40, 31, 34,
    66, 49, -21, 67, 59, 61, 64, 40,
    60, 42, 62, 39, 20, 53, 10, 16,
    12, 11, 36, 68, 224, 59, 188, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 74, 73, 66, 69, 24, 224, 112,
    188, 147, 123, 27, 267, 32, 147, 140,
    131, 267, 64, 63, 232, -61, 109, 56,
    232, 63, 105, 27, 71, 74, 83, 55,
    12, 12, 12, 12, 12, 12, 13, 43,
    56, 56, 56, 56, -21, 0, -10, -5,
    9, 58, 39, 39, 39, 39, 39, 274,
    3, 63, 63, 63, 63, 12, 63, 72,
    35, 35, 35, 35, 35, 35, 34, 37,
    40, 40, 40, 40, -7, 23, -2, 5,
    41, 64, 40, 40, 40, 40, 40, 266,
    -14, 53, 53, 53, 53, 11, 60, 11
  },
      4, 3, true,
},
{
  "Arial-Roman",		/* #17 */
  NULL,
  NULL,
  "arial-medium-r-normal",
  "Arial", "sans-serif", "normal", "normal", "normal",
  16602, 1, 0, 0, 277,
  913, 216,
  715, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 278, 355, 556, 556, 889, 667, 222,
    333, 333, 389, 584, 278, 584, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 278, 278,
    584, 584, 584, 556, 1015, 667, 667, 722, 722, 667,
    611, 778, 722, 278, 500, 667, 556, 833, 722, 778,
    667, 778, 722, 667, 611, 722, 667, 944, 667, 667,
    611, 278, 278, 278, 469, 556, 222, 556, 556, 500,
    556, 556, 278, 556, 556, 222, 222, 500, 222, 833,
    556, 556, 556, 556, 333, 500, 278, 556, 500, 722,
    500, 500, 500, 334, 260, 334, 584, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 260, 556, 333, 737,
    370, 556, 584, 333, 737, 333, 400, 549, 333, 333,
    333, 576, 537, 278, 333, 333, 365, 556, 834, 834,
    834, 611, 667, 667, 667, 667, 667, 667, 1000, 722,
    667, 667, 667, 667, 278, 278, 278, 278, 722, 722,
    778, 778, 778, 778, 778, 584, 778, 722, 722, 722,
    722, 667, 667, 611, 556, 556, 556, 556, 556, 556,
    889, 500, 556, 556, 556, 556, 278, 278, 278, 278,
    556, 556, 556, 556, 556, 556, 556, 549, 611, 556,
    556, 556, 556, 500, 556, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 86, 45, 11, 36, 61, 41, 63,
    72, 37, 31, 56, 83, 56, 88, 0,
    43, 109, 30, 42, 13, 42, 38, 47,
    42, 42, 88, 83, 55, 56, 55, 46,
    55, -1, 73, 51, 77, 78, 82, 55,
    79, 93, 28, 74, 73, 70, 74, 48,
    78, 44, 79, 45, 23, 79, 4, 12,
    4, 3, 20, 79, 0, 16, 27, -15,
    63, 37, 65, 40, 34, 38, 12, 36,
    66, 66, -46, 66, 67, 66, 66, 34,
    66, 35, 65, 31, 8, 63, 13, 2,
    7, 16, 20, 33, 92, 28, 42, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 113, 53, 14, 37, -2, 92, 38,
    31, 1, 23, 69, 56, 32, 3, 22,
    63, 39, 12, 16, 128, 78, 0, 88,
    60, 52, 22, 68, 44, 30, 39, 79,
    -1, -1, -1, -1, -1, -1, 0, 51,
    78, 78, 78, 78, 32, 69, -21, -4,
    -1, 74, 48, 48, 48, 48, 48, 79,
    42, 79, 79, 79, 79, 3, 77, 75,
    37, 37, 37, 37, 37, 37, 37, 40,
    38, 38, 38, 38, 36, 64, -16, -6,
    37, 66, 34, 34, 34, 34, 34, 38,
    62, 63, 63, 63, 63, 16, 66, 16
  },
      5, 1, true,
},
{
  "Arial-Italic",		/* #18 */
  NULL,
  NULL,
  "arial-medium-i-normal",
  "Arial", "sans-serif", "oblique", "normal", "normal",
  16602, 1, 1, 0, 277,
  913, 213,
  715, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 278, 355, 556, 556, 889, 667, 222,
    333, 333, 389, 584, 278, 584, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 278, 278,
    584, 584, 584, 556, 1015, 667, 667, 722, 722, 667,
    611, 778, 722, 278, 500, 667, 556, 833, 722, 778,
    667, 778, 722, 667, 611, 722, 667, 944, 667, 667,
    611, 278, 278, 278, 469, 556, 222, 556, 556, 500,
    556, 556, 278, 556, 556, 222, 222, 500, 222, 833,
    556, 556, 556, 556, 333, 500, 278, 556, 500, 722,
    500, 500, 500, 334, 260, 334, 584, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 260, 556, 333, 737,
    370, 556, 584, 333, 737, 333, 400, 549, 333, 333,
    333, 576, 537, 278, 333, 333, 365, 556, 834, 834,
    834, 611, 667, 667, 667, 667, 667, 667, 1000, 722,
    667, 667, 667, 667, 278, 278, 278, 278, 722, 722,
    778, 778, 778, 778, 778, 584, 778, 722, 722, 722,
    722, 667, 667, 611, 556, 556, 556, 556, 556, 556,
    889, 500, 556, 556, 556, 556, 278, 278, 278, 278,
    556, 556, 556, 556, 556, 556, 556, 549, 611, 556,
    556, 556, 556, 500, 556, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 56, 134, 34, 51, 107, 78, 129,
    83, -54, 104, 90, 24, 93, 58, -51,
    70, 148, 59, 56, 45, 69, 83, 126,
    75, 66, 57, 24, 72, 90, 103, 128,
    89, -20, 43, 91, 44, 45, 45, 99,
    42, 58, 33, 44, 40, 44, 49, 83,
    43, 83, 47, 70, 125, 99, 124, 114,
    -32, 117, 24, 7, 85, -58, 66, -39,
    129, 44, 34, 57, 53, 52, 45, 26,
    33, 30, -122, 34, 26, 33, 33, 49,
    -10, 51, 33, 40, 57, 62, 79, 78,
    -1, 0, 20, 52, 136, -84, 79, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 44, 76, 33, 75, 37, 136, 28,
    111, 22, 75, 79, 90, 46, 22, 108,
    128, 50, 65, 81, 202, 3, 69, 114,
    19, 132, 69, 50, 71, 32, 94, 71,
    -20, -20, -20, -20, -20, -20, -40, 91,
    45, 45, 45, 45, 58, 58, 58, 58,
    41, 49, 83, 83, 83, 83, 83, 112,
    84, 99, 99, 99, 99, 117, 43, 37,
    44, 44, 44, 44, 44, 44, 42, 57,
    52, 52, 52, 52, 61, 61, 61, 61,
    50, 33, 49, 49, 49, 49, 49, 73,
    85, 62, 62, 62, 62, 0, -10, 0
  },
      5, 2, true,
},
{
  "Arial-Bold",			/* #19 */
  NULL,
  NULL,
  "arial-bold-r-normal",
  "Arial", "sans-serif", "normal", "bold", "normal",
  16602, 1, 0, 3, 277,
  924, 211,
  715, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 333, 474, 556, 556, 889, 722, 278,
    333, 333, 389, 584, 278, 584, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 333, 333,
    584, 584, 584, 611, 975, 722, 722, 722, 722, 667,
    611, 778, 722, 278, 556, 722, 611, 833, 722, 778,
    667, 778, 722, 667, 611, 722, 667, 944, 667, 667,
    611, 333, 278, 333, 584, 556, 278, 556, 611, 556,
    611, 556, 333, 611, 611, 278, 278, 556, 278, 889,
    611, 611, 611, 611, 389, 556, 333, 611, 556, 778,
    556, 556, 500, 389, 280, 389, 584, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 280, 556, 333, 737,
    370, 556, 584, 333, 737, 333, 400, 549, 333, 333,
    333, 576, 556, 278, 333, 333, 365, 556, 834, 834,
    834, 611, 722, 722, 722, 722, 722, 722, 1000, 722,
    667, 667, 667, 667, 278, 278, 278, 278, 722, 722,
    778, 778, 778, 778, 778, 584, 778, 722, 722, 722,
    722, 667, 667, 611, 556, 556, 556, 556, 556, 556,
    889, 556, 556, 556, 556, 556, 278, 278, 278, 278,
    611, 611, 611, 611, 611, 611, 611, 549, 611, 611,
    611, 611, 611, 556, 611, 556
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 90, 55, 9, 35, 53, 44, 75,
    54, 35, 13, 42, 57, 42, 72, -1,
    45, 81, 25, 32, 19, 33, 44, 42,
    40, 34, 99, 83, 46, 42, 46, 54,
    28, 0, 74, 48, 73, 73, 74, 49,
    74, 69, 17, 76, 77, 58, 70, 45,
    73, 44, 74, 36, 22, 72, 0, 7,
    0, -1, 15, 71, -1, 19, 54, -9,
    75, 34, 66, 44, 42, 35, 15, 42,
    71, 72, -45, 67, 72, 62, 71, 40,
    68, 43, 66, 29, 7, 69, 5, 4,
    6, 7, 17, 34, 86, 23, 34, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 95, 30, 6, 20, 2, 86, 37,
    10, -4, 18, 45, 42, 33, -3, 20,
    42, 24, 12, 20, 116, 54, -1, 72,
    18, 46, 14, 45, 58, 27, 42, 51,
    0, 0, 0, 0, 0, -1, -41, 48,
    73, 73, 73, 73, 10, 62, -22, -26,
    0, 70, 45, 45, 45, 45, 45, 54,
    32, 72, 72, 72, 72, -1, 73, 68,
    34, 34, 34, 34, 34, 34, 36, 44,
    35, 35, 35, 35, 3, 60, -18, -20,
    43, 71, 40, 40, 40, 40, 40, 24,
    42, 69, 69, 69, 69, 7, 68, 7
  },
      5, 3, true,
},
{
  "Arial-BoldItalic",		/* #20 */
  NULL,
  NULL,
  "arial-bold-i-normal",
  "Arial", "sans-serif", "oblique", "bold", "normal",
  16602, 1, 1, 3, 277,
  924, 221,
  715, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 333, 474, 556, 556, 889, 722, 278,
    333, 333, 389, 584, 278, 584, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 333, 333,
    584, 584, 584, 611, 975, 722, 722, 722, 722, 667,
    611, 778, 722, 278, 556, 722, 611, 833, 722, 778,
    667, 778, 722, 667, 611, 722, 667, 944, 667, 667,
    611, 333, 278, 333, 584, 556, 278, 556, 611, 556,
    611, 556, 333, 611, 611, 278, 278, 556, 278, 889,
    611, 611, 611, 611, 389, 556, 333, 611, 556, 778,
    556, 556, 500, 389, 280, 389, 584, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 280, 556, 333, 737,
    370, 556, 584, 333, 737, 333, 400, 549, 333, 333,
    333, 576, 556, 278, 333, 333, 365, 556, 834, 834,
    834, 611, 722, 722, 722, 722, 722, 722, 1000, 722,
    667, 667, 667, 667, 278, 278, 278, 278, 722, 722,
    778, 778, 778, 778, 778, 584, 778, 722, 722, 722,
    722, 667, 667, 611, 556, 556, 556, 556, 556, 556,
    889, 556, 556, 556, 556, 556, 278, 278, 278, 278,
    611, 611, 611, 611, 611, 611, 611, 549, 611, 611,
    611, 611, 611, 556, 611, 556
  }, 
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 62, 129, 28, 44, 105, 84, 125,
    64, -80, 67, 78, 11, 78, 44, -43,
    64, 119, 61, 42, 27, 63, 80, 104,
    66, 51, 70, 48, 65, 78, 85, 124,
    47, -11, 41, 94, 43, 41, 39, 86,
    43, 35, 18, 40, 45, 41, 45, 81,
    41, 78, 44, 63, 109, 91, 91, 118,
    -42, 104, 25, 12, 78, -57, 90, -9,
    111, 45, 37, 61, 59, 57, 54, 31,
    42, 40, -109, 38, 39, 36, 42, 63,
    -18, 60, 32, 22, 75, 65, 63, 72,
    -22, 6, 17, 41, 131, -86, 56, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 12, 57, 22, 43, 24, 131, 19,
    91, 20, 81, 65, 72, 39, 21, 105,
    111, 67, 78, 73, 219, -20, 61, 80,
    -6, 112, 70, 20, 85, 57, 112, 28,
    -11, -11, -11, -11, -11, -11, -32, 94,
    41, 41, 41, 41, 35, 35, 35, 35,
    37, 45, 81, 81, 81, 81, 81, 90,
    78, 91, 91, 91, 91, 104, 41, 35,
    45, 45, 45, 45, 45, 45, 45, 61,
    57, 57, 57, 57, 40, 40, 40, 40,
    61, 42, 63, 63, 63, 63, 63, 61,
    55, 65, 65, 65, 65, 6, -5, 6
  },
      5, 4, true,
},
{
  "ClarendonCondensed",		/* #21 */
  NULL,
  NULL,
  "clarendon-medium-r-condensed",
  "Clarendon", "serif", "normal", "normal", "condensed",
  4140, 1, 4, 3, 277,
  970, 261,
  694, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 221, 240, 442, 442, 442, 664, 627, 221,
    221, 221, 442, 664, 221, 664, 221, 221, 442, 442,
    442, 442, 442, 442, 442, 442, 442, 442, 221, 221,
    996, 664, 996, 442, 996, 517, 517, 479, 517, 517,
    498, 517, 572, 295, 424, 553, 461, 682, 553, 517,
    498, 535, 572, 461, 517, 498, 535, 738, 517, 498,
    461, 221, 221, 221, 498, 498, 221, 517, 479, 424,
    479, 442, 332, 517, 498, 258, 313, 498, 258, 738,
    498, 461, 479, 479, 369, 424, 313, 498, 442, 664,
    461, 461, 387, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    221, 240, 442, 442, 664, 442, 498, 442, 442, 498,
    442, 461, 664, 221, 498, 442, 442, 664, 295, 295,
    442, 553, 461, 221, 442, 295, 442, 461, 664, 664,
    664, 442, 517, 517, 517, 517, 517, 517, 867, 479,
    517, 517, 517, 517, 295, 295, 295, 295, 517, 553,
    517, 517, 517, 517, 517, 664, 517, 498, 498, 498,
    498, 498, 498, 498, 517, 517, 517, 517, 517, 517,
    682, 424, 442, 442, 442, 442, 258, 258, 258, 258,
    461, 498, 461, 461, 461, 461, 461, 664, 461, 498,
    498, 498, 498, 461, 479, 461
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 38, 91, 15, 24, 63, 32, 28,
    -3, -5, 13, 54, 28, 54, 33, 16,
    29, 91, 13, 21, 7, 22, 21, 15,
    8, 21, 34, 29, 201, 54, 201, 36,
    67, 7, 24, 53, 24, 26, 21, 46,
    23, 25, 17, 11, 23, 18, 27, 48,
    24, 48, 21, 39, 22, 9, 29, 14,
    16, 10, 15, 17, 16, 18, 48, 0,
    39, 33, 20, 33, 42, 42, 45, 21,
    21, 17, -35, 12, 23, 17, 16, 40,
    22, 37, 21, 36, 17, 15, 11, 2,
    15, 13, 15, 71, 224, 59, 203, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 38, 39, 8, 48, 5, 224, 15,
    65, 95, 36, 73, 28, 30, 95, 107,
    73, 54, 24, 24, 139, 21, 65, 33,
    109, 62, 46, 60, 28, 16, 27, 36,
    7, 7, 7, 7, 7, 7, 12, 53,
    26, 26, 26, 26, 25, 25, -4, -19,
    24, 27, 48, 48, 48, 48, 48, 44,
    -1, 9, 9, 9, 9, 10, 24, 21,
    33, 33, 33, 33, 33, 33, 25, 33,
    42, 42, 42, 42, 17, 17, -30, -35,
    40, 16, 40, 40, 40, 40, 40, 54,
    40, 15, 15, 15, 15, 13, 22, 13
  },
      6, 1, true,
},
{
  "Coronet",			/* #22 */
  NULL,
  NULL,
  "coronet-medium-r-normal",
  "Coronet", "cursive", "normal", "normal", "normal",
  4116, 1, 1, 0, 277,
  898, 257,
  744, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 203, 185, 276, 406, 406, 517, 774, 166,
    203, 203, 406, 517, 203, 517, 203, 203, 406, 406,
    406, 406, 406, 406, 406, 406, 406, 406, 203, 203,
    996, 517, 996, 295, 517, 885, 535, 553, 885, 572,
    646, 572, 904, 572, 498, 885, 682, 830, 590, 682,
    535, 682, 572, 664, 590, 627, 627, 904, 572, 608,
    682, 203, 203, 203, 498, 498, 166, 332, 313, 258,
    332, 258, 221, 313, 332, 185, 166, 313, 203, 461,
    313, 276, 313, 332, 221, 221, 185, 332, 258, 406,
    221, 295, 221, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    203, 185, 406, 406, 406, 406, 498, 406, 406, 498,
    313, 276, 517, 203, 498, 406, 406, 517, 240, 240,
    406, 553, 406, 203, 406, 240, 313, 276, 517, 517,
    517, 295, 885, 885, 885, 885, 885, 885, 922, 553,
    572, 572, 572, 572, 572, 572, 572, 572, 885, 590,
    682, 682, 682, 682, 682, 517, 682, 627, 627, 627,
    627, 608, 535, 351, 332, 332, 332, 332, 332, 332,
    424, 258, 258, 258, 258, 258, 185, 185, 185, 185,
    332, 313, 276, 276, 276, 276, 276, 517, 276, 332,
    332, 332, 332, 295, 313, 295
  }, 
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 145, 256, 216, 125, 223, 176, 280,
    131, 8, 379, 249, 105, 226, 155, 69,
    162, 233, 149, 123, 128, 104, 155, 210,
    154, 176, 155, 104, 201, 250, 201, 179,
    158, 96, 112, 163, 146, 137, 164, 160,
    101, 95, 58, 96, 107, 232, 223, 185,
    78, 185, 100, 109, 164, 236, 244, 242,
    89, 215, 98, 52, 208, 18, 48, 0,
    280, 129, 137, 126, 125, 124, 51, 105,
    124, 138, -12, 126, 139, 128, 127, 123,
    50, 126, 125, 113, 133, 145, 134, 133,
    88, 131, 100, 245, 224, 74, 189, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 67, 230, 93, 156, -20, 224, 138,
    279, 95, 165, 133, 252, 120, 95, 297,
    290, 224, 189, 172, 328, 27, 239, 197,
    196, 238, 197, 76, 191, 192, 150, 51,
    96, 96, 96, 96, 96, 96, 38, 163,
    137, 137, 137, 137, 95, 95, 95, 95,
    148, 223, 185, 185, 185, 185, 185, 247,
    104, 236, 236, 236, 236, 215, 78, 55,
    129, 129, 129, 129, 129, 129, 128, 112,
    124, 124, 124, 124, 139, 139, 118, 139,
    149, 127, 123, 123, 123, 123, 123, 246,
    94, 145, 145, 145, 145, 131, 50, 131
  },
      7, 1, true,
},
{
  "Courier",			/* #23 */
  NULL,
  NULL,
  "courier-medium-r-normal",
  "Courier", "monospace", "normal", "normal", "normal",
  4099, 0, 0, 0, 277,
  856, 253,
  560, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    600, 600, 600, 600, 600, 600, 500, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600
  }, 
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 239, 165, 81, 118, 101, 105, 188,
    295, 148, 113, 115, 184, 112, 231, 98,
    120, 113, 86, 93, 74, 98, 109, 46,
    112, 89, 231, 193, 152, 36, 124, 129,
    38, 16, 50, 73, 38, 64, 80, 43,
    43, 105, 54, 67, 58, 17, 26, 51,
    86, 50, 52, 73, 48, 31, 17, 12,
    34, 40, 89, 318, 98, 120, 187, -20,
    188, 58, 22, 80, 61, 80, 95, 52,
    33, 107, 75, 44, 107, 14, 39, 60,
    25, 58, 81, 104, 75, 32, 24, 19,
    29, 29, 110, 243, 281, 145, 106, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 240, 115, 91, 83, 35, 224, 129,
    382, 66, 160, 91, 112, 181, 66, 278,
    150, 115, 172, 171, 375, 39, 98, 236,
    449, 185, 164, 91, 34, 27, 33, 129,
    16, 16, 16, 16, 16, 16, 22, 72,
    64, 64, 64, 64, 106, 106, 106, 106,
    38, 26, 51, 51, 51, 51, 51, 143,
    50, 31, 31, 31, 31, 40, 79, 62,
    58, 58, 58, 58, 58, 58, 36, 80,
    80, 80, 80, 80, 107, 107, 107, 107,
    60, 39, 60, 60, 60, 60, 60, 112,
    61, 32, 32, 32, 32, 29, 25, 29
  },
      8, 1, true,
},
{ 
  "Courier-Italic",		/* #24 */
#ifndef USE_PS_FONTS_IN_PCL
  "Courier-Oblique",		/* treat name of similar PS font as alias */
#else
  NULL,
#endif
  NULL,
  "courier-medium-o-normal",
  "Courier", "monospace", "oblique", "normal", "normal",
  4099, 0, 1, 0, 277,
  856, 253,
  560, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    600, 600, 600, 600, 600, 600, 500, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 250, 233, 116, 121, 147, 129, 256,
    344, 134, 199, 169, 166, 170, 243, 84,
    165, 116, 86, 100, 105, 104, 149, 167,
    142, 87, 243, 172, 195, 99, 190, 215,
    90, 16, 51, 122, 38, 64, 77, 95,
    47, 104, 73, 67, 64, 17, 31, 101,
    87, 98, 51, 79, 115, 139, 123, 122,
    38, 145, 89, 298, 235, 104, 243, -19,
    256, 85, 30, 118, 101, 119, 102, 67,
    44, 107, 45, 57, 102, 13, 37, 101,
    -7, 95, 79, 103, 195, 114, 104, 97,
    33, 4, 110, 259, 330, 187, 165, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 272, 171, 143, 140, 147, 278, 126,
    489, 183, 221, 138, 170, 238, 183, 390,
    252, 112, 223, 227, 476, 91, 182, 300,
    422, 242, 222, 107, 28, 21, 29, 158,
    16, 16, 16, 16, 16, 16, 27, 123,
    64, 64, 64, 64, 104, 104, 104, 104,
    38, 31, 101, 101, 101, 101, 101, 175,
    82, 139, 139, 139, 139, 145, 87, 62,
    85, 85, 85, 85, 85, 85, 64, 119,
    118, 118, 118, 118, 107, 107, 107, 107,
    101, 37, 101, 101, 101, 101, 101, 171,
    78, 114, 114, 114, 114, 4, -7, 4
  },
      8, 2, true,
},
{
  "Courier-Bold",		/* #25 */
  NULL,
  NULL,
  "courier-bold-r-normal",
  "Courier", "monospace", "normal", "bold", "normal",
  4099, 0, 0, 3, 277,
  856, 237,
  560, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    600, 600, 600, 600, 600, 600, 500, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 212, 142, 66, 97, 48, 62, 152,
    263, 112, 88, 102, 152, 98, 206, 72,
    99, 94, 70, 67, 66, 78, 94, 68,
    96, 67, 206, 153, 119, 36, 93, 108,
    22, 2, 37, 53, 24, 49, 62, 40,
    24, 89, 48, 60, 49, -12, 14, 36,
    58, 36, 36, 55, 32, 17, -1, -3,
    23, 22, 72, 289, 74, 102, 132, -28,
    152, 58, -6, 60, 44, 64, 95, 42,
    20, 103, 78, 30, 89, -15, 24, 45,
    11, 49, 67, 85, 94, 21, 9, -8,
    17, 15, 103, 223, 249, 128, 77, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 212, 99, 82, 60, 23, 224, 116,
    348, 66, 157, 44, 98, 171, 66, 278,
    150, 101, 152, 147, 330, 24, 73, 208,
    447, 167, 149, 44, 4, 9, -21, 109,
    2, 2, 2, 2, 2, 2, 10, 54,
    49, 49, 49, 49, 69, 89, 89, 89,
    24, 14, 36, 36, 36, 36, 36, 130,
    36, 17, 17, 17, 17, 22, 40, 27,
    56, 57, 57, 57, 57, 57, 3, 60,
    64, 64, 64, 64, 19, 89, 89, 89,
    55, 24, 45, 45, 45, 45, 45, 97,
    45, 21, 21, 21, 21, 15, 11, 15
  },
      8, 3, true,
},
{
  "Courier-BoldItalic",		/* #26 */
#ifndef USE_PS_FONTS_IN_PCL
  "Courier-BoldOblique",	/* treat name of similar PS font as alias */
#else
  NULL,
#endif
  NULL,
  "courier-bold-o-normal",
  "Courier", "monospace", "oblique", "bold", "normal",
  4099, 0, 1, 3, 277,
  856, 237,
  560, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    600, 600, 600, 600, 600, 600, 500, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 593, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 163, 152, 37, 41, 63, 32, 153,
    248, 36, 104, 86, 106, 86, 155, -9,
    86, 37, 9, 14, 29, 22, 79, 97,
    67, 29, 154, 80, 60, 36, 125, 125,
    4, -61, -27, 43, -37, -16, 0, 29,
    -33, 26, 6, -10, -13, -68, -43, 26,
    20, 23, -26, -5, 31, 54, 32, 20,
    -38, 55, 11, 208, 144, 26, 149, -90,
    153, 13, -26, 40, 9, 41, 20, -1,
    -48, 29, -10, -30, 28, -73, -38, 27,
    -60, 17, 1, 16, 99, 33, 13, 0,
    -45, -61, 30, 208, 188, 47, 72, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 178, 90, 55, 52, 62, 224, 47,
    395, 108, 128, 9, 86, 161, 108, 338,
    210, 35, 137, 138, 386, 9, 92, 212,
    350, 155, 130, -12, -47, -52, -28, 77,
    -61, -61, -61, -61, -61, -61, -51, 42,
    -16, -16, -16, -16, 26, 26, 26, 26,
    -37, -43, 26, 26, 26, 26, 26, 95,
    -7, 54, 54, 54, 54, 55, -14, -34,
    13, 13, 13, 13, 13, 13, -26, 40,
    42, 42, 42, 42, 29, 29, 29, 29,
    43, -38, 27, 27, 27, 27, 27, 82,
    1, 33, 33, 33, 33, -61, -60, -61
  },
      8, 4, true,
},
{
  "Garamond",			/* #27 */
  NULL,
  NULL,
  "garamond-medium-r-normal",
  "Garamond", "serif", "normal", "normal", "normal",
  4197, 1, 0, 0, 277,		/* Garamond Antiqua */
  1023, 260,
  695, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 258, 258, 424, 479, 479, 812, 830, 276,
    295, 295, 479, 812, 258, 812, 258, 479, 479, 479,
    479, 479, 479, 479, 479, 479, 479, 479, 258, 258,
    996, 812, 996, 369, 816, 756, 608, 738, 793, 627,
    590, 793, 848, 332, 369, 719, 608, 904, 848, 848,
    590, 848, 701, 479, 682, 812, 719, 977, 756, 719,
    664, 295, 479, 295, 498, 498, 276, 424, 535, 424,
    517, 424, 313, 461, 553, 276, 258, 553, 276, 830,
    553, 535, 535, 517, 387, 351, 332, 535, 498, 756,
    498, 535, 461, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    258, 258, 479, 479, 479, 479, 498, 479, 479, 498,
    479, 424, 812, 258, 498, 479, 479, 812, 332, 332,
    479, 553, 479, 258, 479, 332, 479, 424, 812, 812,
    812, 369, 756, 756, 756, 756, 756, 756, 1069, 738,
    627, 627, 627, 627, 332, 332, 332, 332, 793, 848,
    848, 848, 848, 848, 848, 812, 848, 812, 812, 812,
    812, 719, 590, 553, 424, 424, 424, 424, 424, 424,
    646, 424, 424, 424, 424, 424, 276, 276, 276, 276,
    535, 553, 535, 535, 535, 535, 535, 812, 535, 535,
    535, 535, 535, 535, 535, 535
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 69, 91, 21, 51, 35, 46, 67,
    79, -25, 68, 148, 57, 150, 68, 21,
    37, 101, 23, 38, 21, 45, 44, 31,
    59, 33, 67, 55, 198, 150, 199, 56,
    -7, 18, 17, 47, 16, 23, 17, 44,
    23, 21, -54, 17, 25, 14, 11, 43,
    18, 42, 21, 34, 33, 24, 15, 8,
    17, 11, 33, 32, 24, 29, 47, 0,
    53, 50, 32, 32, 31, 33, 24, 48,
    27, 28, -6, 27, 30, 30, 28, 48,
    10, 38, 36, 30, 32, 14, 4, 11,
    15, 9, 28, 81, 223, 67, 187, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 69, 60, -37, -6, 14, 223, 46,
    85, 34, 109, 36, 148, 17, 34, 118,
    81, 148, 24, 26, 180, 26, 49, 67,
    122, 73, 66, 32, 97, 78, 69, 44,
    18, 18, 18, 18, 18, 18, 18, 47,
    23, 23, 23, 23, 20, 20, 20, 9,
    10, 11, 43, 43, 43, 43, 43, 154,
    32, 24, 24, 24, 24, 11, 14, 21,
    52, 52, 52, 52, 52, 52, 25, 33,
    32, 32, 32, 32, 26, 28, 4, -32,
    38, 28, 48, 48, 48, 48, 48, 146,
    37, 14, 14, 14, 14, 9, 10, 9
  },
      9, 1, true,
},
{
  "Garamond-Italic",		/* #28 */
  NULL,
  NULL,
  "garamond-medium-i-normal",
  "Garamond", "serif", "italic", "normal", "normal",
  4197, 1, 1, 0, 277,		/* Garamond Kursiv */
  984, 261,
  695, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 240, 240, 424, 479, 479, 774, 682, 240,
    240, 240, 479, 774, 240, 774, 240, 498, 479, 479,
    479, 479, 479, 479, 479, 479, 479, 479, 240, 240,
    996, 774, 996, 351, 779, 701, 572, 701, 756, 590,
    498, 774, 774, 332, 313, 682, 590, 774, 738, 793,
    553, 793, 682, 461, 608, 756, 719, 959, 701, 664,
    627, 240, 498, 240, 498, 498, 240, 461, 479, 369,
    498, 369, 276, 424, 479, 295, 240, 498, 276, 812,
    553, 461, 461, 479, 387, 295, 313, 517, 517, 719,
    461, 442, 424, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    240, 258, 479, 479, 479, 479, 498, 479, 479, 498,
    442, 406, 774, 240, 498, 479, 479, 774, 332, 332,
    479, 553, 479, 240, 479, 332, 442, 406, 774, 774,
    774, 351, 701, 701, 701, 701, 701, 701, 959, 701,
    590, 590, 590, 590, 332, 332, 332, 332, 756, 738,
    793, 793, 793, 793, 793, 774, 793, 756, 756, 756,
    756, 664, 553, 498, 461, 461, 461, 461, 461, 461,
    627, 369, 369, 369, 369, 369, 295, 295, 295, 295,
    461, 553, 461, 461, 461, 461, 461, 774, 461, 517,
    517, 517, 517, 442, 461, 442
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 20, 165, 52, 51, 96, 48, 112,
    17, -133, 147, 142, -11, 144, 16, -8,
    62, 81, 41, -2, 48, 55, 53, 83,
    52, 48, 17, -10, 198, 150, 199, 64,
    6, -52, -2, 79, -23, -21, -15, 81,
    -20, -13, -103, -9, -10, -44, 7, 72,
    -18, 74, -26, 20, 93, 111, 138, 130,
    -21, 101, 45, -79, 171, -131, 47, 0,
    150, -2, 11, 30, 14, 24, -146, -24,
    8, 48, -109, 13, 35, 34, 37, 38,
    -86, 11, 33, -6, 46, 34, 23, 23,
    -8, -28, -10, 132, 223, -36, 187, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -23, 94, 8, 37, 67, 223, 46,
    214, 187, 115, 49, 149, 42, 187, 198,
    136, 141, 75, 59, 286, 26, 86, 98,
    84, 96, 125, 28, 92, 55, 86, -33,
    -52, -52, -52, -52, -52, -52, -61, 79,
    -21, -21, -21, -21, -14, -14, -14, -14,
    -23, 7, 72, 72, 72, 72, 72, 154,
    5, 110, 110, 110, 110, 101, -17, -190,
    -2, -2, -2, -2, -2, -2, -3, 29,
    23, 23, 23, 23, 48, 48, 48, 48,
    38, 37, 38, 38, 38, 38, 38, 140,
    -45, 34, 34, 34, 34, -28, -86, -28
  },
      9, 2, true,
},
{
  "Garamond-Bold",		/* #29 */
  NULL,
  NULL,
  "garamond-bold-r-normal",
  "Garamond", "serif", "normal", "bold", "normal",
  4197, 1, 0, 3, 277,		/* Garamond Halbfett */
  1010, 261,
  695, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 276, 276, 406, 498, 498, 830, 848, 258,
    313, 313, 498, 830, 276, 830, 276, 498, 498, 498,
    498, 498, 498, 498, 498, 498, 498, 498, 276, 276,
    996, 830, 996, 387, 830, 756, 664, 756, 830, 627,
    627, 812, 885, 387, 369, 738, 608, 940, 848, 867,
    627, 867, 738, 535, 664, 812, 738, 996, 756, 701,
    664, 313, 498, 313, 498, 498, 258, 461, 553, 424,
    553, 442, 351, 535, 590, 295, 276, 553, 295, 867,
    590, 535, 553, 553, 424, 369, 369, 590, 535, 756,
    535, 517, 479, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    276, 276, 498, 498, 498, 498, 498, 498, 498, 498,
    461, 479, 830, 276, 498, 498, 498, 830, 351, 351,
    498, 553, 498, 276, 498, 351, 461, 479, 830, 830,
    830, 387, 756, 756, 756, 756, 756, 756, 977, 756,
    627, 627, 627, 627, 387, 387, 387, 387, 830, 848,
    867, 867, 867, 867, 867, 830, 867, 812, 812, 812,
    812, 701, 627, 590, 461, 461, 461, 461, 461, 461,
    682, 424, 442, 442, 442, 442, 295, 295, 295, 295,
    535, 590, 535, 535, 535, 535, 535, 830, 535, 590,
    590, 590, 590, 517, 553, 517
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 56, 74, 21, 52, 40, 42, 50,
    20, 19, 57, 157, 46, 157, 56, 57,
    46, 91, 21, 30, 39, 33, 46, 54,
    48, 37, 55, 46, 199, 157, 199, 53,
    -5, 3, 30, 39, 29, 23, 32, 35,
    26, 21, -66, 30, 28, 9, 13, 38,
    28, 37, 25, 38, 13, 12, 3, 25,
    20, 5, 24, 52, 42, 12, 47, 0,
    44, 31, 10, 34, 34, 32, 32, 44,
    28, 29, 11, 22, 24, 19, 30, 37,
    14, 32, 32, 39, 14, 23, 9, 14,
    21, 7, 30, 70, 223, 58, 200, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 56, 53, 17, -19, 14, 223, 40,
    83, 45, 71, 46, 157, 31, 45, 113,
    75, 156, 31, 34, 202, 20, 65, 50,
    108, 67, 56, 49, 63, 60, 52, 54,
    3, 3, 3, 3, 3, 3, -8, 39,
    23, 23, 23, 23, 21, 21, 21, 21,
    26, 13, 38, 38, 38, 38, 38, 156,
    34, 12, 12, 12, 12, 5, 29, 31,
    31, 31, 31, 31, 31, 31, 33, 34,
    31, 31, 31, 31, 28, 29, 17, -19,
    37, 30, 37, 37, 37, 37, 37, 157,
    31, 24, 24, 24, 24, 7, 14, 7
  },
      9, 3, true,
},
{
  "Garamond-BoldItalic",	/* #30 */
  NULL,
  NULL,
  "garamond-bold-i-normal",
  "Garamond", "serif", "italic", "bold", "normal",
  4197, 1, 1, 3, 277,		/* Garamond Kursiv Halbfett */
  1016, 264,
  697, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 258, 258, 424, 498, 498, 830, 701, 258,
    295, 295, 498, 830, 258, 830, 258, 498, 498, 498,
    498, 498, 498, 498, 498, 498, 498, 498, 258, 258,
    996, 830, 996, 387, 830, 738, 627, 738, 774, 627,
    572, 793, 812, 387, 351, 719, 627, 867, 793, 830,
    627, 830, 738, 498, 682, 812, 738, 996, 719, 738,
    664, 295, 498, 295, 498, 498, 258, 517, 553, 424,
    553, 424, 295, 479, 553, 313, 295, 535, 295, 812,
    553, 479, 553, 535, 387, 332, 313, 535, 572, 774,
    479, 498, 424, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    258, 258, 498, 498, 498, 498, 498, 498, 498, 498,
    424, 424, 830, 258, 498, 498, 498, 830, 332, 332,
    498, 553, 498, 258, 498, 332, 424, 424, 830, 830,
    830, 387, 738, 738, 738, 738, 738, 738, 977, 738,
    627, 627, 627, 627, 387, 387, 387, 387, 774, 793,
    830, 830, 830, 830, 830, 830, 830, 812, 812, 812,
    812, 738, 627, 535, 517, 517, 517, 517, 517, 517,
    701, 424, 424, 424, 424, 424, 313, 313, 313, 313,
    479, 553, 479, 479, 479, 479, 479, 830, 479, 535,
    535, 535, 535, 498, 553, 498
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 36, 137, 48, 39, 101, 74, 101,
    37, -112, 114, 157, 23, 157, 60, 7,
    57, 46, 4, -17, 22, 75, 45, 99,
    48, 46, 26, 9, 199, 157, 199, 87,
    17, -19, -21, 80, -3, -8, -10, 89,
    -16, -19, -118, -8, -6, -50, -5, 78,
    2, 78, -3, 21, 104, 115, 107, 92,
    -22, 131, 38, -58, 159, -92, 47, 0,
    118, 33, 36, 32, 32, 33, -95, -39,
    33, 30, -95, 33, 39, 38, 46, 36,
    -78, 30, 34, 14, 37, 44, 36, 30,
    -13, -19, -19, 85, 223, -39, 200, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -45, 98, 5, 19, 82, 262, 51,
    188, 167, 99, 26, 157, 28, 167, 205,
    124, 156, 72, 63, 278, 20, 75, 91,
    117, 109, 116, 10, 93, 94, 69, -15,
    -19, -19, -19, -19, -19, -19, -63, 80,
    -8, -8, -8, -8, -19, -19, -19, -19,
    -2, -5, 78, 78, 78, 78, 78, 160,
    74, 115, 115, 115, 115, 131, 2, -138,
    33, 33, 33, 33, 33, 33, 30, 32,
    33, 33, 33, 33, 31, 31, 31, 31,
    37, 46, 36, 36, 36, 36, 36, 157,
    32, 43, 43, 43, 43, -18, -79, -18
  },
      9, 4, true,
},
{
  "LetterGothic",		/* #31 */
  NULL,
  NULL,
  "letter gothic-medium-r-normal",
  "Letter Gothic", "monospace", "normal", "normal", "normal",
  4102, 0, 0, 0, 277,
  946, 308,
  721, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 199, 135, -5, 75, 46, 47, 200,
    147, 145, 29, 33, 200, 35, 206, 81,
    77, 94, 61, 53, 29, 53, 61, 59,
    52, 54, 205, 200, 35, 35, 35, 56,
    30, 9, 70, 52, 66, 88, 86, 34,
    63, 128, 32, 73, 78, 45, 72, 40,
    89, 41, 71, 37, 24, 63, 55, 32,
    62, 49, 59, 130, 71, 104, 49, 0,
    200, 62, 51, 49, 46, 51, 74, 40,
    73, 89, 58, 78, 92, 14, 56, 50,
    53, 45, 94, 57, 32, 72, 58, 7,
    42, -16, 54, 124, 225, 124, 19, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 206, 69, 38, 77, 49, 225, 65,
    139, 147, 124, 8, 35, 126, 147, 109,
    98, 33, 145, 116, 185, -13, 117, 211,
    190, 152, 119, 3, 32, 18, 21, 115,
    9, 9, 9, 9, 9, 9, 0, 52,
    88, 88, 88, 88, 128, 128, 93, 128,
    -5, 72, 40, 40, 40, 40, 40, 42,
    41, 63, 63, 63, 63, 49, 89, 89,
    62, 62, 62, 62, 62, 62, -2, 49,
    51, 51, 51, 51, 89, 89, 82, 89,
    40, 56, 50, 50, 50, 50, 50, 33,
    51, 72, 72, 72, 72, -16, 75, -16
  },
      10, 1, true,
},
{
  "LetterGothic-Italic",	/* #32 */
  NULL,
  NULL,
  "letter gothic-medium-i-normal",
  "Letter Gothic", "monospace", "oblique", "normal", "normal",
  4102, 0, 1, 0, 277,
  947, 308,
  721, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 154, 200, 9, 39, 17, 24, 257,
    162, 162, 81, 53, 155, 61, 197, 104,
    67, 47, -2, 16, 21, 44, 53, 86,
    34, 47, 164, 155, 23, 61, 46, 154,
    47, -46, 18, 50, 2, 25, 27, 30,
    10, 75, 51, 21, 44, -23, 17, 39,
    21, 39, 13, 7, 104, 45, 152, 23,
    0, 141, 4, 51, 167, 22, 49, 0,
    286, 46, -14, 40, 36, 39, 118, 10,
    23, 138, 14, 31, 187, -34, 21, 40,
    -34, 37, 53, 32, 85, 41, 117, 40,
    -30, -86, -3, 146, 225, 13, 7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 113, 79, 41, 77, 90, 225, 83,
    213, 147, 166, 8, 61, 145, 147, 198,
    149, 59, 140, 128, 265, -13, 117, 224,
    94, 153, 176, -42, 0, -6, 16, 55,
    -46, -46, -46, -46, -46, -46, -52, 50,
    25, 25, 25, 25, 75, 75, 75, 75,
    14, 17, 39, 39, 39, 39, 39, 68,
    -17, 45, 45, 45, 45, 141, 21, 40,
    46, 46, 46, 46, 46, 46, -24, 40,
    39, 39, 39, 39, 138, 138, 132, 138,
    41, 21, 40, 40, 40, 40, 40, 59,
    9, 41, 41, 41, 41, -86, -35, -86
  },
      10, 2, true,
},
{
  "LetterGothic-Bold",		/* #33 */
  NULL,
  NULL,
  "letter gothic-bold-r-normal",
  "Letter Gothic", "monospace", "normal", "bold", "normal",
  4102, 0, 0, 3, 277,
  988, 308,
  721, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 500, 500,
    500, 500, 500, 500, 500, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 177, 203, -33, 66, 25, 27, 184,
    141, 110, 28, 13, 184, 12, 185, 69,
    59, 87, 41, 29, 18, 45, 45, 63,
    26, 40, 185, 185, 34, 12, 34, 66,
    15, -9, 48, 30, 47, 62, 76, 25,
    46, 111, 37, 43, 80, 37, 45, 24,
    68, 17, 46, 30, 9, 46, 33, 13,
    35, 25, 41, 128, 74, 79, 49, 0,
    184, 68, 44, 56, 44, 42, 86, 50,
    79, 91, 77, 74, 77, 16, 55, 34,
    47, 47, 74, 65, 40, 63, 49, -3,
    14, 11, 55, 71, 225, 71, 11, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 177, 58, 40, 48, 25, 225, 59,
    109, 147, 135, -12, 12, 159, 147, 100,
    108, 13, 132, 107, 146, -30, 117, 177,
    171, 133, 120, -12, 13, 7, -12, 71,
    -9, -9, -9, -9, -9, -9, -3, 30,
    62, 62, 62, 62, 111, 111, 78, 106,
    -12, 45, 24, 24, 24, 24, 24, 15,
    19, 46, 46, 46, 46, 25, 68, 96,
    68, 68, 68, 68, 68, 68, 11, 56,
    42, 42, 42, 42, 91, 91, 83, 91,
    50, 55, 34, 34, 34, 34, 34, 10,
    34, 63, 63, 63, 63, 11, 71, 11
  },
      10, 3, true,
},
{
  "Marigold",			/* #34 */
  NULL,
  NULL,
  "marigold-medium-r-normal",
  "Marigold", NULL, "normal", "normal", "normal",
  4297, 1, 0, 0, 277,
  770, 302,
  450, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 221, 295, 240, 369, 369, 646, 479, 147,
    258, 258, 369, 442, 221, 442, 221, 332, 369, 369,
    369, 369, 369, 369, 369, 369, 369, 369, 221, 221,
    996, 442, 996, 313, 682, 461, 406, 406, 479, 387,
    369, 461, 461, 240, 240, 461, 332, 608, 498, 442,
    369, 442, 442, 369, 387, 479, 461, 608, 461, 406,
    406, 240, 332, 240, 498, 498, 147, 313, 258, 240,
    295, 240, 147, 295, 313, 185, 147, 258, 147, 424,
    295, 258, 295, 276, 240, 203, 203, 295, 276, 369,
    276, 276, 276, 313, 498, 313, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    221, 295, 369, 369, 369, 369, 498, 369, 442, 295,
    240, 351, 442, 258, 295, 442, 295, 442, 276, 276,
    442, 553, 442, 221, 442, 276, 240, 351, 646, 646,
    646, 313, 461, 461, 461, 461, 461, 461, 664, 406,
    387, 387, 387, 387, 240, 240, 240, 240, 479, 498,
    442, 442, 442, 442, 442, 442, 442, 479, 479, 479,
    479, 406, 369, 351, 313, 313, 313, 313, 313, 313,
    406, 240, 240, 240, 240, 240, 185, 185, 185, 185,
    276, 295, 258, 258, 258, 258, 258, 442, 258, 295,
    295, 295, 295, 276, 295, 276
  }, 
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 62, 25, -27, 1, 40, 23, 43,
    68, 9, 63, 48, -24, 48, 47, 40,
    8, 80, 21, 5, 2, -7, 5, 50,
    0, 29, 47, -24, 198, 48, 199, 40,
    35, 4, 13, 24, 12, 5, 25, 21,
    11, 28, -68, 13, 14, 15, 11, 22,
    9, 22, 0, 15, 14, 24, 4, 18,
    11, 0, -2, 45, 26, 24, 47, 0,
    32, 15, 3, 26, 14, 17, -124, -108,
    17, 33, -95, 1, 20, 11, 18, 18,
    -114, 19, 19, -5, 21, 8, 1, 7,
    -8, -54, -5, 66, 223, 27, 187, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 49, 68, -31, 6, -21, 223, 29,
    158, 79, 42, -3, 51, 12, 79, 165,
    42, 47, 31, 30, 228, 7, 73, 49,
    101, 66, 65, -4, 62, 55, 30, -13,
    4, 4, 4, 4, 4, 4, 4, 24,
    5, 5, 5, 5, 28, 28, 28, 28,
    12, 11, 22, 22, 22, 22, 22, 81,
    12, 24, 24, 24, 24, 0, 9, -110,
    15, 15, 15, 15, 15, 15, 11, 0,
    17, 17, 17, 17, 33, 33, 21, 4,
    22, 18, 18, 18, 18, 18, 18, 48,
    19, 8, 8, 8, 8, -54, -114, -54
  },
      11, 1, true,
},
{
  "CGOmega",			/* #35 */
  NULL,
  NULL,
  "cg omega-medium-r-normal",
  "CG Omega", "serif", "normal", "normal", "normal",
  4113, 1, 0, 0, 277,
  895, 250,
  683, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 276, 276, 406, 553, 553, 885, 719, 276,
    276, 276, 553, 885, 276, 885, 276, 276, 553, 553,
    553, 553, 553, 553, 553, 553, 553, 553, 276, 276,
    996, 885, 996, 387, 885, 664, 608, 664, 774, 498,
    498, 774, 774, 276, 276, 608, 498, 885, 774, 830,
    553, 830, 608, 498, 553, 774, 664, 996, 608, 608,
    608, 276, 276, 276, 498, 498, 276, 479, 553, 479,
    553, 498, 276, 498, 553, 276, 276, 498, 276, 830,
    553, 553, 553, 553, 332, 387, 276, 553, 498, 774,
    498, 498, 498, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    276, 276, 553, 553, 553, 553, 498, 553, 553, 498,
    406, 369, 885, 276, 498, 553, 553, 885, 369, 369,
    553, 553, 553, 276, 553, 369, 406, 369, 885, 885,
    885, 387, 664, 664, 664, 664, 664, 664, 812, 664,
    498, 498, 498, 498, 276, 276, 276, 276, 774, 774,
    830, 830, 830, 830, 830, 885, 830, 774, 774, 774,
    774, 608, 553, 553, 479, 479, 479, 479, 479, 479,
    774, 479, 498, 498, 498, 498, 276, 276, 276, 276,
    553, 553, 553, 553, 553, 553, 553, 885, 553, 553,
    553, 553, 553, 498, 553, 498
  }, 
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 84, 81, 25, 74, 98, 83, 75,
    73, 27, 104, 184, 43, 184, 83, -28,
    43, 108, 40, 68, 14, 68, 61, 85,
    50, 57, 82, 43, 201, 191, 201, 89,
    49, 12, 89, 44, 99, 94, 97, 42,
    91, 88, -27, 91, 98, 39, 98, 45,
    86, 44, 88, 45, 21, 103, 10, 17,
    32, 16, 10, 72, -34, 7, 48, 0,
    71, 36, 64, 39, 31, 36, 26, 39,
    73, 90, -3, 69, 94, 70, 73, 40,
    66, 37, 81, 44, 19, 81, 10, 18,
    32, 15, 22, 97, 224, 71, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 84, 76, 33, 77, -10, 224, 88,
    131, 147, 55, 39, 184, 15, 147, 131,
    120, 184, 30, 53, 231, -61, 117, 83,
    161, 70, 33, 21, 108, 87, 118, 60,
    12, 12, 12, 12, 12, 12, -27, 44,
    94, 94, 94, 94, 27, 60, -3, -7,
    31, 98, 45, 45, 45, 45, 45, 185,
    40, 103, 103, 103, 103, 16, 86, 79,
    36, 36, 36, 36, 36, 36, 40, 39,
    36, 36, 36, 36, 22, 59, 1, -6,
    40, 73, 40, 40, 40, 40, 40, 184,
    35, 81, 81, 81, 81, 15, 71, 15
  },
      12, 1, true,
},
{
  "CGOmega-Italic",		/* #36 */
  NULL,
  NULL,
  "cg omega-medium-i-normal",
  "CG Omega", "serif", "oblique", "normal", "normal",
  4113, 1, 1, 0, 277,
  911, 250,
  683, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 276, 276, 406, 553, 553, 885, 664, 276,
    276, 276, 553, 885, 276, 885, 276, 276, 553, 553,
    553, 553, 553, 553, 553, 553, 553, 553, 276, 276,
    996, 885, 996, 387, 885, 664, 608, 664, 774, 498,
    498, 738, 774, 295, 276, 608, 461, 885, 774, 830,
    553, 830, 627, 498, 553, 774, 608, 940, 553, 553,
    608, 276, 276, 276, 498, 498, 276, 498, 553, 479,
    553, 498, 276, 498, 553, 276, 276, 498, 276, 830,
    553, 553, 553, 553, 332, 387, 295, 553, 498, 774,
    442, 498, 498, 442, 498, 442, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    276, 276, 553, 553, 553, 553, 498, 553, 553, 498,
    461, 369, 885, 276, 498, 553, 553, 885, 387, 387,
    553, 553, 553, 276, 553, 387, 461, 369, 885, 885,
    885, 387, 664, 664, 664, 664, 664, 664, 793, 664,
    498, 498, 498, 498, 295, 295, 295, 295, 774, 774,
    830, 830, 830, 830, 830, 885, 830, 774, 774, 774,
    774, 553, 553, 535, 498, 498, 498, 498, 498, 498,
    774, 479, 498, 498, 498, 498, 276, 276, 276, 276,
    553, 553, 553, 553, 553, 553, 553, 885, 553, 553,
    553, 553, 553, 498, 553, 498
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 57, 155, 28, 49, 154, 42, 103,
    61, -37, 131, 194, -18, 194, 59, 4,
    57, 176, 54, 47, 39, 54, 67, 83,
    55, 86, 56, -19, 201, 191, 201, 99,
    46, -22, 63, 65, 64, 54, 54, 75,
    59, 60, -35, 62, 58, 54, 60, 63,
    63, 63, 56, 17, 91, 105, 79, 84,
    -2, 70, 15, 12, 107, -55, 48, 0,
    103, 28, 25, 39, 50, 38, 48, 17,
    37, 61, -9, 41, 54, 34, 39, 37,
    -16, 52, 40, 13, 40, 63, 58, 56,
    -13, 52, 22, 97, 224, -52, 195, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 25, 88, 5, 54, 57, 224, 86,
    191, 147, 114, 38, 198, 5, 147, 191,
    151, 176, 79, 81, 284, -61, 98, 104,
    122, 144, 111, 10, 136, 125, 100, 20,
    -22, -22, -22, -22, -22, -22, -76, 65,
    54, 54, 54, 54, 60, 60, 60, 60,
    14, 60, 63, 63, 63, 63, 63, 193,
    27, 105, 105, 105, 105, 70, 63, 30,
    28, 28, 28, 28, 28, 28, 24, 39,
    38, 38, 38, 38, 61, 61, 61, 51,
    37, 39, 37, 37, 37, 37, 37, 198,
    4, 63, 63, 63, 63, 52, -17, 52
  },
      12, 2, true,
},
{
  "CGOmega-Bold",		/* #37 */
  NULL,
  NULL,
  "cg omega-bold-r-normal",
  "CG Omega", "serif", "normal", "bold", "normal",
  4113, 1, 0, 3, 277,
  924, 250,
  686, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 276, 276, 461, 553, 553, 885, 719, 276,
    276, 276, 553, 885, 276, 885, 276, 276, 553, 553,
    553, 553, 553, 553, 553, 553, 553, 553, 276, 276,
    996, 885, 996, 442, 885, 664, 608, 664, 774, 498,
    498, 774, 774, 332, 332, 627, 498, 885, 774, 830,
    572, 830, 608, 498, 553, 774, 664, 996, 608, 608,
    608, 276, 276, 276, 498, 498, 276, 498, 553, 498,
    553, 498, 332, 498, 553, 276, 276, 498, 276, 830,
    553, 553, 553, 553, 387, 387, 332, 553, 498, 774,
    498, 498, 498, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    276, 276, 553, 553, 553, 553, 498, 553, 553, 498,
    369, 442, 885, 276, 498, 553, 553, 885, 369, 369,
    553, 590, 553, 276, 553, 369, 369, 442, 885, 885,
    885, 442, 664, 664, 664, 664, 664, 664, 867, 664,
    498, 498, 498, 498, 332, 332, 332, 332, 774, 774,
    830, 830, 830, 830, 830, 885, 830, 774, 774, 774,
    774, 608, 572, 553, 498, 498, 498, 498, 498, 498,
    756, 498, 498, 498, 498, 498, 276, 276, 276, 276,
    553, 553, 553, 553, 553, 553, 553, 885, 553, 553,
    553, 553, 553, 498, 553, 498
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 58, 75, 31, 50, 64, 44, 63,
    38, 5, 96, 184, 24, 184, 57, -4,
    41, 87, 49, 47, 34, 32, 49, 76,
    42, 42, 57, 20, 201, 184, 201, 68,
    24, 6, 78, 41, 88, 76, 83, 43,
    83, 85, 12, 82, 88, 36, 86, 42,
    83, 42, 79, 46, 22, 87, 20, 15,
    22, 12, 18, 44, -4, 21, 48, 0,
    53, 23, 46, 33, 30, 34, 29, 32,
    56, 63, -13, 47, 66, 55, 55, 32,
    42, 37, 65, 37, 11, 52, 20, 22,
    28, 20, 29, 79, 224, 60, 188, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 58, 46, 39, 48, -17, 224, 74,
    156, 147, 27, 42, 184, 15, 147, 129,
    113, 184, 42, 43, 235, -61, 117, 57,
    146, 57, 15, 33, 101, 68, 84, 68,
    6, 6, 6, 6, 6, 6, 0, 41,
    76, 76, 76, 76, 52, 85, 9, 22,
    18, 86, 42, 42, 42, 42, 42, 188,
    38, 87, 87, 87, 87, 12, 82, 50,
    23, 23, 23, 23, 23, 23, 19, 33,
    34, 34, 34, 34, 27, 53, -22, -5,
    32, 55, 32, 32, 32, 32, 32, 184,
    26, 52, 52, 52, 52, 20, 42, 20
  },
      12, 3, true,
},
{
  "CGOmega-BoldItalic",		/* #38 */
  NULL,
  NULL,
  "cg omega-bold-i-normal",
  "CG Omega", "serif", "oblique", "bold", "normal",
  4113, 1, 1, 3, 277,
  923, 250,
  686, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 276, 276, 461, 553, 553, 885, 719, 276,
    276, 276, 553, 885, 276, 885, 276, 276, 553, 553,
    553, 553, 553, 553, 553, 553, 553, 553, 276, 276,
    996, 885, 996, 442, 885, 664, 608, 664, 774, 498,
    498, 774, 774, 332, 332, 608, 498, 885, 774, 830,
    553, 830, 608, 498, 553, 774, 664, 940, 608, 608,
    608, 276, 276, 276, 498, 498, 276, 498, 553, 479,
    553, 498, 332, 498, 553, 276, 276, 498, 276, 830,
    553, 553, 553, 553, 387, 387, 332, 553, 498, 774,
    498, 498, 498, 498, 498, 498, 996, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    276, 276, 553, 553, 553, 553, 498, 553, 553, 498,
    369, 424, 885, 276, 498, 553, 553, 885, 351, 351,
    553, 590, 553, 276, 553, 351, 369, 424, 885, 885,
    885, 442, 664, 664, 664, 664, 664, 664, 867, 664,
    498, 498, 498, 498, 332, 332, 332, 332, 774, 774,
    830, 830, 830, 830, 830, 885, 830, 774, 774, 774,
    774, 608, 553, 553, 498, 498, 498, 498, 498, 498,
    756, 479, 498, 498, 498, 498, 276, 276, 276, 276,
    553, 553, 553, 553, 553, 553, 553, 885, 553, 553,
    553, 553, 553, 498, 553, 498
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 21, 148, 41, 23, 128, 42, 70,
    44, -42, 140, 184, -80, 184, 26, -54,
    56, 142, 17, 19, 23, 24, 72, 54,
    43, 65, 26, -80, 201, 204, 201, 100,
    37, -49, 39, 73, 39, 22, 26, 80,
    34, 33, -50, 36, 43, 21, 42, 67,
    30, 64, 35, 17, 90, 90, 104, 110,
    -6, 104, -30, -35, 111, -35, 48, 0,
    70, 14, 5, 43, 27, 32, 12, -13,
    2, 1, -91, -2, 8, 1, 4, 26,
    -40, 28, 8, 3, 57, 34, 79, 86,
    -33, 5, -14, 101, 224, -78, 188, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -20, 93, -4, 48, 55, 224, 85,
    202, 147, 60, 45, 184, 9, 147, 191,
    148, 184, 56, 54, 269, -61, 117, 78,
    92, 105, 53, 19, 131, 117, 83, 48,
    -49, -49, -49, -49, -49, -49, -49, 73,
    22, 22, 22, 22, 33, 33, 33, 33,
    38, 42, 67, 67, 67, 67, 67, 226,
    61, 90, 90, 90, 90, 104, 35, 4,
    14, 14, 14, 14, 14, 14, 14, 43,
    32, 32, 32, 32, 7, 7, 7, 7,
    26, 4, 26, 26, 26, 26, 26, 184,
    3, 34, 34, 34, 34, 5, -40, 5
  },
      12, 4, true,
},
{
  "TimesNewRoman",		/* #39 */
  NULL,
  NULL,
  "times new roman-medium-r-normal",
  "Times New Roman", "serif", "normal", "normal", "normal",
  16901, 1, 0, 0, 277,
  913, 219,
  662, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 408, 500, 500, 833, 778, 333,
    333, 333, 500, 564, 250, 564, 250, 278, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 278, 278,
    564, 564, 564, 444, 921, 722, 667, 667, 722, 611,
    556, 722, 722, 333, 389, 722, 611, 889, 722, 722,
    556, 722, 667, 556, 611, 722, 722, 944, 722, 722,
    611, 333, 278, 333, 469, 500, 333, 444, 500, 444,
    500, 444, 333, 500, 500, 278, 278, 500, 278, 778,
    500, 500, 500, 500, 333, 389, 278, 500, 500, 722,
    500, 500, 444, 480, 200, 480, 541, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 333, 500, 500, 500, 500, 200, 500, 333, 760,
    276, 500, 564, 333, 760, 333, 400, 549, 300, 300,
    333, 576, 453, 250, 333, 300, 310, 500, 750, 750,
    750, 444, 722, 722, 722, 722, 722, 722, 889, 667,
    611, 611, 611, 611, 333, 333, 333, 333, 722, 722,
    722, 722, 722, 722, 722, 564, 722, 722, 722, 722,
    722, 722, 556, 500, 444, 444, 444, 444, 444, 444,
    667, 444, 444, 444, 444, 444, 278, 278, 278, 278,
    500, 500, 500, 500, 500, 500, 500, 549, 500, 500,
    500, 500, 500, 500, 500, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 111, 65, 18, 53, 36, 37, 91,
    41, 22, 70, 18, 54, 18, 71, 1,
    39, 121, 21, 41, 16, 49, 45, 37,
    63, 41, 86, 69, 19, 18, 18, 45,
    61, 8, 17, 36, 18, 21, 17, 36,
    17, 25, 21, 17, 21, 14, -15, 35,
    17, 35, 17, 63, 30, 6, 9, 14,
    -4, 9, 13, 82, 1, 36, 18, -8,
    91, 33, -2, 39, 34, 37, 21, 29,
    2, 27, -77, 8, 29, 9, 3, 30,
    -2, 33, 7, 48, 7, 1, -8, 6,
    13, 6, 20, 138, 80, 86, 15, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 111, 63, 31, 14, 1, 80, 77,
    29, 35, -3, 32, 18, 41, 35, 16,
    48, 8, 10, 22, 131, 65, -7, 71,
    33, 68, 15, 32, 88, 68, 73, 42,
    8, 8, 8, 8, 8, 8, -12, 36,
    21, 21, 21, 21, 25, 25, 25, 25,
    17, -15, 35, 35, 35, 35, 35, 81,
    36, 6, 6, 6, 6, 9, 17, 17,
    33, 33, 33, 33, 33, 33, 37, 39,
    37, 37, 37, 37, 27, 27, -10, -2,
    35, 3, 30, 30, 30, 30, 30, 11,
    21, 1, 1, 1, 1, 6, -2, 6
  },
      13, 1, true,
},
{
  "TimesNewRoman-Italic",	/* #40 */
  NULL,
  NULL,
  "times new roman-medium-i-normal",
  "Times New Roman", "serif", "italic", "normal", "normal",
  16901, 1, 1, 0, 277,
  913, 216,
  662, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 420, 500, 500, 833, 778, 333,
    333, 333, 500, 675, 250, 675, 250, 278, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 333, 333,
    675, 675, 675, 500, 920, 611, 611, 667, 722, 611,
    611, 722, 722, 333, 444, 667, 556, 833, 667, 722,
    611, 722, 611, 500, 556, 722, 611, 833, 611, 556,
    556, 389, 278, 389, 422, 500, 333, 500, 500, 444,
    500, 444, 278, 500, 500, 278, 278, 444, 278, 722,
    500, 500, 500, 500, 389, 389, 278, 500, 444, 667,
    444, 444, 389, 400, 275, 400, 541, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 389, 500, 500, 500, 500, 275, 500, 333, 760,
    276, 500, 675, 333, 760, 333, 400, 549, 300, 300,
    333, 576, 523, 250, 333, 300, 310, 500, 750, 750,
    750, 500, 611, 611, 611, 611, 611, 611, 889, 667,
    611, 611, 611, 611, 333, 333, 333, 333, 722, 667,
    722, 722, 722, 722, 722, 675, 722, 722, 722, 722,
    722, 556, 611, 500, 500, 500, 500, 500, 500, 500,
    667, 444, 444, 444, 444, 444, 278, 278, 278, 278,
    500, 500, 500, 500, 500, 500, 500, 549, 500, 500,
    500, 500, 500, 444, 500, 444
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 75, 144, 45, 42, 70, 48, 195,
    68, -109, 106, 89, -10, 97, 34, -34,
    57, 61, 16, 33, 31, 36, 64, 113,
    34, 30, 60, 17, 91, 92, 91, 97,
    47, -49, -23, 68, -30, -22, -24, 70,
    -26, -31, -34, -27, -32, -32, -28, 49,
    -24, 42, -23, 7, 70, 95, 131, 127,
    -67, 90, -2, 7, 106, -100, 21, -8,
    212, 22, 25, 29, 19, 33, -173, -25,
    21, 42, -166, 10, 39, 18, 20, 28,
    -111, 21, 19, -9, 42, 30, 21, 17,
    -34, -79, -29, 89, 144, -54, 15, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 70, 55, 24, 29, -7, 147, -7,
    128, 52, 69, 41, 91, 26, 52, 124,
    75, 8, 54, 65, 225, -33, 23, 98,
    -9, 80, 94, 18, 80, 80, 100, 36,
    -49, -49, -49, -49, -49, -48, -53, 68,
    -22, -22, -22, -22, -31, -31, -31, -31,
    -30, -28, 49, 49, 49, 49, 49, 155,
    36, 95, 95, 95, 95, 90, -24, -161,
    22, 22, 22, 22, 22, 22, 21, 24,
    33, 33, 33, 33, 42, 42, 42, 42,
    26, 20, 28, 28, 28, 28, 28, 36,
    3, 30, 30, 30, 30, -79, -111, -79
  },
      13, 2, true,
},
{
  "TimesNewRoman-Bold",		/* #41 */
  NULL,
  NULL,
  "times new roman-bold-r-normal",
  "Times New Roman", "serif", "normal", "bold", "normal",
  16901, 1, 0, 3, 277,
  913, 226,
  662, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 555, 500, 500, 1000, 833, 333,
    333, 333, 500, 570, 250, 570, 250, 278, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 333, 333,
    570, 570, 570, 500, 930, 722, 667, 722, 722, 667,
    611, 778, 778, 389, 500, 778, 667, 944, 722, 778,
    611, 778, 722, 556, 667, 722, 722, 1000, 722, 722,
    667, 333, 278, 333, 581, 500, 333, 500, 556, 444,
    556, 444, 333, 500, 556, 278, 333, 556, 278, 833,
    556, 500, 556, 556, 444, 389, 333, 556, 500, 722,
    500, 500, 444, 394, 220, 394, 520, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 333, 500, 500, 500, 500, 220, 500, 333, 747,
    300, 500, 570, 333, 747, 333, 400, 549, 300, 300,
    333, 576, 540, 250, 333, 300, 330, 500, 750, 750,
    750, 500, 722, 722, 722, 722, 722, 722, 1000, 722,
    667, 667, 667, 667, 389, 389, 389, 389, 722, 722,
    778, 778, 778, 778, 778, 570, 778, 722, 722, 722,
    722, 722, 611, 556, 500, 500, 500, 500, 500, 500,
    722, 444, 444, 444, 444, 444, 278, 278, 278, 278,
    500, 556, 500, 500, 500, 500, 500, 549, 500, 556,
    556, 556, 556, 500, 556, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 83, 86, 20, 39, 74, 41, 74,
    46, 12, 56, 20, 32, 19, 44, 1,
    39, 66, 25, 17, 25, 34, 39, 31,
    35, 34, 86, 75, 20, 20, 20, 61,
    48, 5, 19, 40, 14, 26, 23, 41,
    22, 21, 12, 23, 20, 19, 9, 40,
    22, 39, 17, 52, 37, 15, 8, 11,
    7, 9, 16, 104, 1, 33, 71, -9,
    74, 42, 22, 42, 41, 42, 26, 36,
    29, 24, -28, 32, 24, 39, 29, 37,
    21, 42, 36, 47, 19, 26, 8, 9,
    23, 8, 10, 81, 78, 44, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 84, 63, 17, 12, 3, 78, 43,
    3, 30, 21, 18, 20, 24, 30, 0,
    29, 8, 12, 7, 113, 50, -9, 44,
    87, 39, 28, 19, 73, 60, 67, 56,
    5, 5, 5, 5, 5, 8, -11, 40,
    26, 26, 26, 26, 21, 21, 21, 21,
    18, 9, 40, 40, 40, 40, 40, 75,
    40, 15, 15, 15, 15, 9, 17, 26,
    42, 42, 42, 42, 42, 42, 42, 42,
    42, 42, 42, 42, 14, 24, -19, -18,
    36, 29, 37, 37, 37, 37, 37, 8,
    35, 26, 26, 26, 26, 8, 21, 8
  },
  13, 3, true,
},
{
  "TimesNewRoman-BoldItalic",	/* #42 */
  NULL,
  NULL,
  "times new roman-bold-i-normal",
  "Times New Roman", "serif", "italic", "bold", "normal",
  16901, 1, 1, 3, 277,
  913, 216,
  662, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 389, 555, 500, 500, 833, 778, 333,
    333, 333, 500, 570, 250, 606, 250, 278, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 333, 333,
    570, 570, 570, 500, 832, 667, 667, 667, 722, 667,
    667, 722, 778, 389, 500, 667, 611, 889, 722, 722,
    611, 722, 667, 556, 611, 722, 667, 889, 667, 611,
    611, 333, 278, 333, 570, 500, 333, 500, 500, 444,
    500, 444, 333, 500, 556, 278, 278, 500, 278, 778,
    556, 500, 500, 500, 389, 389, 278, 556, 444, 667,
    500, 444, 389, 348, 220, 348, 570, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 389, 500, 500, 500, 500, 220, 500, 333, 747,
    266, 500, 606, 333, 747, 333, 400, 549, 300, 300,
    333, 576, 500, 250, 333, 300, 300, 500, 750, 750,
    750, 500, 667, 667, 667, 667, 667, 667, 944, 667,
    667, 667, 667, 667, 389, 389, 389, 389, 722, 722,
    722, 722, 722, 722, 722, 570, 722, 722, 722, 722,
    722, 611, 611, 500, 500, 500, 500, 500, 500, 500,
    722, 444, 444, 444, 444, 444, 278, 278, 278, 278,
    500, 556, 500, 500, 500, 500, 500, 549, 500, 556,
    556, 556, 556, 444, 500, 444
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 55, 165, 46, 39, 108, 46, 144,
    50, -102, 120, 30, -28, 35, -14, -81,
    52, 23, 4, 12, 18, 38, 63, 118,
    38, 45, 40, 30, 37, 29, 42, 88,
    36, -57, -25, 67, -36, -35, -16, 70,
    -32, -35, -8, -15, -30, -35, -32, 54,
    -30, 53, -32, -22, 80, 94, 118, 126,
    -61, 93, -27, -29, 78, -111, 95, -49,
    142, 20, 10, 28, 20, 26, -160, -54,
    12, 21, -160, 6, 16, 12, 13, 23,
    -122, 20, 18, -1, 20, 33, 29, 28,
    -45, -93, -5, 52, 107, -79, 29, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 20, 53, 36, 22, -9, 107, -13,
    99, 43, 68, 40, 64, 6, 43, 80,
    88, 12, 49, 54, 192, -62, -4, 75,
    -1, 60, 85, 6, 99, 59, 100, 4,
    -57, -57, -57, -57, -57, -57, -56, 67,
    -35, -35, -35, -35, -35, -35, -35, -35,
    -36, -32, 54, 54, 54, 54, 54, 86,
    42, 94, 94, 94, 94, 93, -30, -170,
    20, 20, 20, 20, 20, 20, 19, 22,
    26, 26, 26, 26, 21, 21, 21, 21,
    23, 13, 23, 23, 23, 23, 23, 16,
    14, 33, 33, 33, 33, -93, -122, -93
  },
      13, 4, true,
},
/* note: 31402 below should be replaced by 6826 for LaserJet 4L's and 5L's */
{
  "Wingdings",			/* #43, also called Tidbits */
  "Tidbits",
  "Tidbits",			/* use "Tidbits" in any output PS file */
  "wingdings-medium-r-normal",
  "Wingdings", NULL, "normal", "normal", "normal",
  31402, 1, 0, 0, 18540,	
  895, 210,
  723, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1000, 1030, 1145, 1301, 1344, 894, 1217, 458, 
    1084, 892, 1132, 1132, 1171, 1171, 1431, 1431, 1096, 1343, 
    699, 699, 892, 554, 602, 1072, 948, 1078, 939, 891, 
    892, 892, 891, 910, 910, 587, 793, 674, 674, 942, 
    942, 549, 549, 892, 843, 843, 843, 1111, 660, 849, 
    1089, 888, 880, 650, 813, 747, 747, 723, 693, 794, 
    885, 892, 896, 891, 1156, 1054, 964, 1090, 941, 933, 
    946, 1025, 929, 1096, 1065, 780, 1050, 1271, 747, 953, 
    747, 891, 891, 891, 891, 458, 747, 986, 891, 578, 
    1060, 1060, 891, 892, 892, 530, 530, 1000, 892, 892, 
    892, 892, 892, 892, 892, 892, 892, 892, 892, 892, 
    892, 892, 892, 892, 892, 892, 892, 892, 892, 892, 
    1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 313, 458, 
    313, 891, 891, 891, 891, 891, 953, 458, 891, 891, 
    891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 
    891, 891, 891, 891, 891, 891, 891, 891, 891, 891, 
    891, 891, 891, 891, 891, 891, 891, 891, 891, 1048, 
    1048, 1048, 1048, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 
    1000, 1000, 1000, 1253, 1253, 794, 794, 891, 891, 891, 
    891, 891, 891, 979, 979, 891, 891, 776, 776, 776, 
    776, 1067, 1067, 891, 891, 873, 873, 873, 873, 891, 
    891, 811, 811, 1060, 811, 782, 782, 782, 782, 482, 
    385, 635, 786, 892, 892, 1035,
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    /* printable ASCII range */
    0, 36, 80, 84, 37, 74, 85, 96,
    87, 86, 84, 84, 84, 84, 84, 84,
    84, 84, 84, 84, 84, 84, 84, 85,
    37, 37, 84, 84, 84, 84, 85, 36,
    36, 83, 84, 84, 84, 84, 84, 84,
    84, 84, 43, 43, 43, 84, 81, 84,
    84, 84, 87, 83, 89, 85, 85, 85,
    87, 84, 85, 86, 84, 85, 85, 84,
    85, 84, 84, 84, 85, 84, 85, 84,
    84, 85, 59, 66, 85, 86, 85, 85,
    85, 85, 85, 84, 85, 86, 86, 85,
    86, 86, 84, 86, 86, 37, 37, 139,
    /* following four rows (chars. 128..159) are inaccessible */
    86, 86, 86, 86, 86, 86, 86, 86,
    86, 86, 86, 86, 86, 86, 86, 86,
    86, 86, 86, 86, 86, 86, 35, 35,
    35, 35, 27, 27, 27, 27, 85, 84,
    /* printable 8-bit range */
    85, 85, 85, 85, 85, 85, 86, 85,
    85, 134, 85, 102, 134, 86, 86, 85,
    84, 84, 85, 172, 85, 85, 66, 85,
    85, 85, 85, 85, 85, 85, 85, 85,
    85, 85, 85, 83, 83, 83, 83, 84,
    84, 84, 0, 28, 2, 23, 24, 24,
    24, 23, 24, 24, 24, 85, 85, 85,
    85, 85, 85, 86, 102, 85, 85, 83,
    83, 86, 86, 82, 82, 82, 82, 88,
    88, 86, 86, 89, 89, 89, 89, 86,
    86, 97, 97, 86, 97, 85, 84, 85,
    84, 49, 49, 72, 72, 86, 86, 62
  },
  14, 1, false,
},
{
  "Symbol",			/* #44 */
  NULL,
  NULL,
  "symbol-medium-r-normal",
  "Symbol", NULL, "normal", "normal", "normal",
  16686, 1, 0, 0, 621,
  945, 284,
  685, 0,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 713, 500, 549, 833, 778, 439, 
    333, 333, 500, 549, 250, 549, 250, 278, 500, 500, 
    500, 500, 500, 500, 500, 500, 500, 500, 278, 278,
    549, 549, 549, 444, 549, 722, 667, 722, 612, 611, 
    763, 603, 722, 333, 631, 722, 686, 889, 722, 722, 
    768, 741, 556, 592, 611, 690, 439, 768, 645, 795,
    611, 333, 863, 333, 658, 500, 500, 631, 549, 549, 
    494, 439, 521, 411, 603, 329, 603, 549, 549, 576, 
    521, 549, 549, 521, 549, 603, 439, 576, 713, 686,
    493, 686, 494, 480, 603, 480, 549, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 620, 247, 549, 167, 713, 500, 753, 753, 753, 
    753, 1042, 987, 603, 987, 603, 400, 549, 411, 549, 
    549, 713, 494, 460, 549, 549, 549, 549, 1000, 603,
    1000, 658, 823, 686, 795, 987, 768, 768, 823, 768,
    768, 713, 713, 713, 713, 713, 713, 713, 768, 713, 
    790, 790, 890, 823, 549, 250, 713, 603, 603, 1042,
    987, 603, 987, 603, 494, 329, 790, 790, 786, 713, 
    384, 384, 384, 384, 384, 384, 494, 494, 494, 603, 
    762, 329, 274, 686, 384, 686, 384, 384, 384, 384,
    494, 384, 494, 494, 494, 0
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    /* printable ASCII range */
    0, 108, 55, -2, 66, 149, 46, 13,
    27, 37, 69, 54, 50, 54, 68, -95,
    39, 135, 42, 60, 41, 62, 55, 49,
    68, 52, 82, 64, 72, 55, 72, 39,
    53, -4, 34, 9, -15, 8, 23, 34,
    6, 7, 48, 8, -21, 4, -2, 41,
    19, 52, 11, -2, 12, -8, 36, 26,
    29, 17, 6, 87, 125, 63, 0, 0,
    -27, 54, 85, 16, 27, 29, -17, -6,
    43, 43, 26, 40, 35, 51, 38, 53,
    2, 49, 89, 73, 0, 48, 58, 44,
    58, 40, 40, 114, 305, 114, 54, 0,
    /* following four rows are inaccessible */
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    /* printable 8-bit range */
    0, 0, 55, 43, -46, 13, -34, 31,
    118, 68, 104, 181, 102, 145, 106, 145,
    41, 54, 50, 42, 90, 59, 29, 106,
    54, 55, 54, 54, 193, 305, -108, 14,
    127, 20, 50, 219, 68, 68, 162, 150,
    150, 25, 44, 45, 42, 45, 131, 152,
    54, 36, 42, 42, -31, 47, 96, 73,
    119, 66, 66, 132, 104, 135, 104, 135,
    19, 14, 42, 42, 9, 58, 2, 2,
    2, 2, 2, 2, 233, 51, 233, 272,
    53, -14, -98, 305, 330, 6, -15, 330,
    -15, 46, 233, 46, 51, 233, 51, 0
  },
      2, 0, false,
},
{
  NULL,				/* DUMMY */
  NULL,
  NULL,
  NULL,
  NULL, NULL, NULL, NULL, NULL,
  0, 0, 0, 0, 0,
  0, 0,
  0, 0,
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0},
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0},
  0, 0, false,
}
};

/* Known PCL typefaces.  Each plTypefaceInfoStruct contains the following
   information:
   
   (1) number of valid fonts [should be >= 2, since every typeface
       should include a symbol font (the zeroth font, the 1st listed)]
   (2) a list of fonts (each number is an index into
       the _pl_g_pcl_font_info[] array above).

   The number of valid fonts should be <= PL_MAX_FONTS_PER_TYPEFACE; the
   initializers are filled out with dummy fonts to get arrays of length
   PL_MAX_FONTS_PER_TYPEFACE. */

const struct plTypefaceInfoStruct _pl_g_pcl_typeface_info[] = 
{
  /* Univers, #0 */
  { 5, { 44, 0, 1, 2, 3, 999, 999, 999, 999, 999 } },
  /* Univers Condensed, #1 */
  { 5, { 44, 4, 5, 6, 7, 999, 999, 999, 999, 999  } }, 
  /* CG Times, #2 */
  { 5, { 44, 8, 9, 10, 11, 999, 999, 999, 999, 999  } },
  /* Albertus, #3 */
  { 5, { 44, 12, 12, 13, 13, 999, 999, 999, 999, 999  } }, 
  /* Antique Olive, #4 */
  { 4, { 44, 14, 15, 16, 999, 999, 999, 999, 999, 999  } }, 
  /* Arial, #5 */
  { 5, { 44, 17, 18, 19, 20, 999, 999, 999, 999, 999  } },
  /* Clarendon, #6 */
  { 2, { 44, 21, 999, 999, 999, 999, 999, 999, 999, 999  } }, 
  /* Coronet, #7 */
  { 2, { 44, 22, 999, 999, 999, 999, 999, 999, 999, 999  } },
  /* Courier, #8 */
  { 5, { 44, 23, 24, 25, 26, 999, 999, 999, 999, 999 } },
  /* Garamond, #9 */
  { 5, { 44, 27, 28, 29, 30, 999, 999, 999, 999, 999 } },
  /* Letter Gothic, #10 */
  { 4, { 44, 31, 32, 33, 999, 999, 999, 999, 999, 999 } },
  /* Marigold, #11 */
  { 2, { 44, 34, 999, 999, 999, 999, 999, 999, 999, 999 } },
  /* CG Omega, #12 */
  { 5, { 44, 35, 36, 37, 38, 999, 999, 999, 999, 999 } },
  /* Times New Roman, #13 */
  { 5, { 44, 39, 40, 41, 42, 999, 999, 999, 999, 999 } },
  /* Wingdings, #14 */
  { 2, { 44, 43, 999, 999, 999, 999, 999, 999, 999, 999 } },
};


/* Known Stick fonts (i.e., device-resident HP vector fonts) that are
   supported by HP-GL or HP-GL/2.  These structures, one per font, are
   similar to the ones for the PCL fonts, but units are different, as is
   the interpretation of character `width'.  Each character in any Stick
   font is defined on an abstract raster, of width equal to one-half the
   font size (by definition).  Widths below are measured in terms of raster
   units.  Each width is really the width of a (nominal) bounding box for
   the character.  This is NOT the same as the character cell width, i.e.,
   the logical width of the character in the PS sense.

   The reason that we tabulate bounding box widths here is that HP
   originally had no notion of logical width at all.  For the Stick fonts
   as for the PCL fonts, native HP-GL or HP-GL/2 rendering begins at the
   `first ink' for the character, i.e., at the left edge of the bounding
   box, _not_ at the left edge of the character cell for the character (as
   in PS).  This is an old pen plotter convention.  The bounding box width
   is the distance between first ink and last ink.

   There is a separate `offset' field, measured in the same units, which
   measures the offset from the left edge of the character cell to the left
   edge of the bounding box, and the right edge of the bounding box to the
   right edge of the character cell.  This was a later addition of HP's,
   for the (lamebrained) HP-GL/2 emulation performed by LaserJets.
   Apparently, HP added it to make the device-resident metrics for the
   Stick fonts similar to those for the PCL fonts.  This offset, in
   LaserJets, must be the same for all characters in a character set.

   So relative to PS-style rendering, the `offset' field is the amount in
   abstract raster units by which a LaserJet renderer automatically shifts
   leftwards before rendering the character, to make the first ink appear
   at the current point.  (In a sense, the abstract raster on which each
   character is defined has an unoccupied border to its left, of width
   equal to this offset.)  We undo this leftward shift before rendering any
   string, by shifting rightwards.  This `rightward shift' procedure is the
   same as the one we use for the PCL fonts (see h_text.c, where stick
   fonts as well as PCL fonts are rendered).

   For example, the standard fixed-width Stick font (whose name is also
   `Stick') is defined on a 32x32 abstract raster.  Each character has
   nominal bounding box width of 32.  The abstract raster is effectively
   the left 2/3 of a character cell, and the character cell width of each
   character is 48, in these units.  The `offset' is 8, since 8 + 32 + 8 =
   48.  The nominal font size [measured horizontally] is 64 = 2 * 32, in
   accordance with the HP convention that the nominal font size equals
   twice the raster width.

   Similarly, the variable-width `Arc' font is defined on an abstract
   raster, of notional size 28x36.  Most characters are narrower than 28
   units; some stick out beyond the right edge of the raster.  The offset
   is 5, so by adding 5 + 5 = 10 to the bounding box width for a character,
   you can get its cell width.  These cell widths are character-dependent,
   unlike the case of the `Stick' font.  The nominal font size for the Arc
   font [measured horizontally] is 56 = 2 * 28.  In HP literature a nominal
   character cell width for the Arc font is sometimes given as 42 raster
   units.  This is 2/3 of 56, i.e., 2/3 of the font size, just as for the
   `Stick' font.

   For any font, the abstract raster is mapped to device space by
   appropriate scaling in the x and y directions, the `natural' mapping
   being one where the mapped raster has a height equal to 1.4 = 7/5 (or
   maybe 10/7?) times its width.  The value 1.4 is HP magic; we use it when
   we select a stick font, in h_font.c.

   The preceding explanation is fully valid only for the (lamebrained)
   HP-GL/2 emulation performed by LaserJets.  In genuine HP-GL/2 (and also
   in earlier versions of HP-GL, such as the HP7550A version), Stick fonts
   were handled in a more sophisticated way.  Instead of the distance
   between any two successive characters' bounding boxes being a fixed
   amount, namely 2 * offset, this distance was computed from
   device-resident lookup tables.  I.e., the character sets in HP-GL/2 were
   automatically kerned.

   There were at least three device-resident `spacing tables': 
   (1) a trivial spacing table for the fixed width character sets (which we
   now use in our Stick* fonts), (2) a spacing table used by most
   variable-width character sets (such as those now used in our Arc*
   fonts), (3) a spacing table for the Japanese Katakana character set
   (which we now use as the upper half of our ArcANK* fonts).  Three
   different tables were needed, because these three sorts of character set
   were defined on abstract rasters of different widths: 32, 28, and 30,
   respectively.

   These three spacing tables were indexed by `row class' and `character
   class', i.e., `right edge class' and `left edge class' for the
   character.  For details, see "Firmware Determines Plotter Personality",
   by L. W. Hennessee, A. K. Frankel, M. A. Overton, and R. B. Smith,
   Hewlett-Packard Journal, Nov. 1981, pp. 16-25.

   (There was an additional difference between LaserJet HP-GL/2 emulation
   and true HP-GL[/2].  In true HP-GL[/2], the width of each space
   character [i.e., ASCII SP] was 3/2 times as wide.  Yes, even for the
   fixed-width character sets; the spacing tables compensated for that.)

   Below in this file, after the fonts and the character width information,
   we include the relevant kerning tables and spacing tables.  Each font
   half (i.e., the lower half or upper half of a font) uses a kerning
   table.  A kerning table maps each character in a 7-bit (i.e.,
   128-character) character set to its row class and column class.  The
   kerning table also includes a pointer to the appropriate spacing table,
   which as noted is indexed by row class and column class.  So when
   computing the spacing between two successive characters in a label,
   double indirection must be used. */

/* IMPORTANT: The fonts in this array may be referred to elsewhere in the
   code by number.  If you change the numbering of Stick fonts, i.e., the
   order in which they appear in this array, be sure to update, e.g., the
   definitions PL_DEFAULT_STICK_FONT_INDEX, etc. in extern.h. */

const struct plStickFontInfoStruct _pl_g_stick_font_info[] = {
{
  "Arc",			/* #0 (our numbering) */
  true,				/* basic font */
  49, 1, 0, 0, 277,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0), /* 40 = height of top of parenthesis */
  (int)(1000 * 1.4 * 9.0 / 64.0), /* 9 = depth of descender of `p' and `q' */
  28, 36,			/* raster size = 28x36 (for lower half)*/
  28, 36,			/* raster size = 28x36 (for upper half) */
  10, 17,			/* charset numbers (pre-HP-GL/2) */
  6, 7,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31, 30, 26, 34, 28, 24, 22, 34, 
    26,  1, 18, 26, 21, 34, 27, 34, 
    23, 32, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 20,  9, 16, 54, 
    10, 20, 22, 22, 22, 23, 13, 22, 
    18,  1,  7, 19,  1, 32, 18, 24, 
    22, 22, 11, 19, 12, 18, 20, 32,
    22, 20, 21, 11,  1, 11, 29,  0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 22, 29, 30, 25,  1, 24,
    16, 28, 21, 26, 28, 28, 28, 42,
     6, 26, 28, 28, 10, 26, 23,  2,
    28, 28, 22, 26, 21, 21, 26, 20,
    30, 30, 30, 30, 30, 30, 31, 34,
    24, 24, 24, 24, 10, 10, 16, 16,
    34, 27, 34, 34, 34, 34, 34, 28,
    32, 26, 26, 26, 26, 28, 30, 23,
    20, 20, 20, 20, 20, 20, 28, 22,
    23, 23, 23, 23, 10, 10, 10, 17,
    22, 18, 24, 24, 24, 24, 24, 28,
    24, 18, 18, 18, 18, 20, 22, 20},
  5,				/* offset */
  0, 1, false, true,
},
{
  "Arc-Oblique",		/* #1 */
  true,				/* basic font */
  49, 1, 0, 0, 277,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0),
  (int)(1000 * 1.4 * 9.0 / 64.0), 
  28, 36,			/* raster size = 28x36 (for lower half)*/
  28, 36,			/* raster size = 28x36 (for upper half) */
  10, 17,			/* charset numbers (pre-HP-GL/2) */
  6, 7,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31, 30, 26, 34, 28, 24, 22, 34, 
    26,  1, 18, 26, 21, 34, 27, 34, 
    23, 32, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 20,  9, 16, 54, 
    10, 20, 22, 22, 22, 23, 13, 22, 
    18,  1,  7, 19,  1, 32, 18, 24, 
    22, 22, 11, 19, 12, 18, 20, 32,
    22, 20, 21, 11,  1, 11, 29,  0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 22, 29, 30, 25,  1, 24,
    16, 28, 21, 26, 28, 28, 28, 42,
     6, 26, 28, 28, 10, 26, 23,  2,
    28, 28, 22, 26, 21, 21, 26, 20,
    30, 30, 30, 30, 30, 30, 31, 34,
    24, 24, 24, 24, 10, 10, 16, 16,
    34, 27, 34, 34, 34, 34, 34, 28,
    32, 26, 26, 26, 26, 28, 30, 23,
    20, 20, 20, 20, 20, 20, 28, 22,
    23, 23, 23, 23, 10, 10, 10, 17,
    22, 18, 24, 24, 24, 24, 24, 28,
    24, 18, 18, 18, 18, 20, 22, 20},
  5,				/* offset */
  0, 2, true, true,
},
{
  "Arc-Bold",		/* #2 */
  true,				/* basic font */
  49, 1, 0, 3, 277,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0),
  (int)(1000 * 1.4 * 9.0 / 64.0), 
  28, 36,			/* raster size = 28x36 (for lower half)*/
  28, 36,			/* raster size = 28x36 (for upper half) */
  10, 17,			/* charset numbers (pre-HP-GL/2) */
  6, 7,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31, 30, 26, 34, 28, 24, 22, 34, 
    26,  1, 18, 26, 21, 34, 27, 34, 
    23, 32, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 20,  9, 16, 54, 
    10, 20, 22, 22, 22, 23, 13, 22, 
    18,  1,  7, 19,  1, 32, 18, 24, 
    22, 22, 11, 19, 12, 18, 20, 32,
    22, 20, 21, 11,  1, 11, 29,  0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 22, 29, 30, 25,  1, 24,
    16, 28, 21, 26, 28, 28, 28, 42,
     6, 26, 28, 28, 10, 26, 23,  2,
    28, 28, 22, 26, 21, 21, 26, 20,
    30, 30, 30, 30, 30, 30, 31, 34,
    24, 24, 24, 24, 10, 10, 16, 16,
    34, 27, 34, 34, 34, 34, 34, 28,
    32, 26, 26, 26, 26, 28, 30, 23,
    20, 20, 20, 20, 20, 20, 28, 22,
    23, 23, 23, 23, 10, 10, 10, 17,
    22, 18, 24, 24, 24, 24, 24, 28,
    24, 18, 18, 18, 18, 20, 22, 20},
  5,				/* offset */
  0, 3, false, true,
},
{
  "Arc-BoldOblique",	/* #3 */
  true,				/* basic font */
  49, 1, 0, 3, 277,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0),
  (int)(1000 * 1.4 * 9.0 / 64.0),
  28, 36,			/* raster size = 28x36 (for lower half)*/
  28, 36,			/* raster size = 28x36 (for upper half) */
  10, 17,			/* charset numbers (pre-HP-GL/2) */
  6, 7,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31, 30, 26, 34, 28, 24, 22, 34, 
    26,  1, 18, 26, 21, 34, 27, 34, 
    23, 32, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 20,  9, 16, 54, 
    10, 20, 22, 22, 22, 23, 13, 22, 
    18,  1,  7, 19,  1, 32, 18, 24, 
    22, 22, 11, 19, 12, 18, 20, 32,
    22, 20, 21, 11,  1, 11, 29,  0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 22, 29, 30, 25,  1, 24,
    16, 28, 21, 26, 28, 28, 28, 42,
     6, 26, 28, 28, 10, 26, 23,  2,
    28, 28, 22, 26, 21, 21, 26, 20,
    30, 30, 30, 30, 30, 30, 31, 34,
    24, 24, 24, 24, 10, 10, 16, 16,
    34, 27, 34, 34, 34, 34, 34, 28,
    32, 26, 26, 26, 26, 28, 30, 23,
    20, 20, 20, 20, 20, 20, 28, 22,
    23, 23, 23, 23, 10, 10, 10, 17,
    22, 18, 24, 24, 24, 24, 24, 28,
    24, 18, 18, 18, 18, 20, 22, 20},
  5,				/* offset */
  0, 4, true, true,
},
{
  "ArcANK",			/* #4 (our numbering) */
  false,			/* not basic font */
  49, 1, 0, 0, 11,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0), /* 40 = height of top of parenthesis */
  (int)(1000 * 1.4 * 9.0 / 64.0), /* 9 = depth of descender of `p' and `q' */
  28, 36,			/* raster size = 28x36 (for lower half)*/
  30, 36,			/* raster size = 30x36 (for upper half) */
  16, 18,			/* charset numbers (pre-HP-GL/2) */
  8, 9,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31, 30, 26, 34, 28, 24, 22, 34, 
    26,  1, 18, 26, 21, 34, 27, 34, 
    23, 32, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 25,  9, 16, 54, 
    10, 20, 22, 22, 22, 23, 13, 22, 
    18,  1,  7, 19,  1, 32, 18, 24, 
    22, 22, 11, 19, 12, 18, 20, 32,
    22, 20, 21, 11,  1, 11, 42,  0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    30,  8, 17, 17,  8,  8, 28, 28, 
    23, 26, 26, 27, 29, 30, 23, 27, 
    26, 30, 30, 28, 30, 30, 28, 30, 
    28, 30, 26, 28, 29, 30, 28, 28, 
    28, 28, 28, 30, 21, 30, 30, 26, 
    27, 28, 30, 24, 27, 30, 27, 27, 
    27, 30, 30, 30, 30, 30, 26, 30, 
    17, 30, 21, 22, 26, 28,  7, 10, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0},
  5,				/* offset */
  1, 1, false, false,
},
{
  "ArcANK-Oblique",		/* #5 */
  false,			/* not basic font */
  49, 1, 0, 0, 11,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0),
  (int)(1000 * 1.4 * 9.0 / 64.0), 
  28, 36,			/* raster size = 28x36 (for lower half)*/
  30, 36,			/* raster size = 30x36 (for upper half) */
  16, 18,			/* charset numbers (pre-HP-GL/2) */
  8, 9,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31, 30, 26, 34, 28, 24, 22, 34, 
    26,  1, 18, 26, 21, 34, 27, 34, 
    23, 32, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 25,  9, 16, 54, 
    10, 20, 22, 22, 22, 23, 13, 22, 
    18,  1,  7, 19,  1, 32, 18, 24, 
    22, 22, 11, 19, 12, 18, 20, 32,
    22, 20, 21, 11,  1, 11, 42,  0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    30,  8, 17, 17,  8,  8, 28, 28, 
    23, 26, 26, 27, 29, 30, 23, 27, 
    26, 30, 30, 28, 30, 30, 28, 30, 
    28, 30, 26, 28, 29, 30, 28, 28, 
    28, 28, 28, 30, 21, 30, 30, 26, 
    27, 28, 30, 24, 27, 30, 27, 27, 
    27, 30, 30, 30, 30, 30, 26, 30, 
    17, 30, 21, 22, 26, 28,  7, 10, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0},
  5,				/* offset */
  1, 2, true, false,
},
{
  "ArcANK-Bold",		/* #6 */
  false,			/* not basic font */
  49, 1, 0, 3, 11,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0),
  (int)(1000 * 1.4 * 9.0 / 64.0), 
  28, 36,			/* raster size = 28x36 (for lower half)*/
  30, 36,			/* raster size = 30x36 (for upper half) */
  16, 18,			/* charset numbers (pre-HP-GL/2) */
  8, 9,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31, 30, 26, 34, 28, 24, 22, 34, 
    26,  1, 18, 26, 21, 34, 27, 34, 
    23, 32, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 25,  9, 16, 54, 
    10, 20, 22, 22, 22, 23, 13, 22, 
    18,  1,  7, 19,  1, 32, 18, 24, 
    22, 22, 11, 19, 12, 18, 20, 32,
    22, 20, 21, 11,  1, 11, 42,  0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    30,  8, 17, 17,  8,  8, 28, 28, 
    23, 26, 26, 27, 29, 30, 23, 27, 
    26, 30, 30, 28, 30, 30, 28, 30, 
    28, 30, 26, 28, 29, 30, 28, 28, 
    28, 28, 28, 30, 21, 30, 30, 26, 
    27, 28, 30, 24, 27, 30, 27, 27, 
    27, 30, 30, 30, 30, 30, 26, 30, 
    17, 30, 21, 22, 26, 28,  7, 10, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0},
  5,				/* offset */
  1, 3, false, false,
},
{
  "ArcANK-BoldOblique",	/* #7 */
  false,			/* not basic font */
  49, 1, 0, 3, 11,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0),
  (int)(1000 * 1.4 * 9.0 / 64.0),
  28, 36,			/* raster size = 28x36 (for lower half)*/
  30, 36,			/* raster size = 30x36 (for upper half) */
  16, 18,			/* charset numbers (pre-HP-GL/2) */
  8, 9,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31, 30, 26, 34, 28, 24, 22, 34, 
    26,  1, 18, 26, 21, 34, 27, 34, 
    23, 32, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 25,  9, 16, 54, 
    10, 20, 22, 22, 22, 23, 13, 22, 
    18,  1,  7, 19,  1, 32, 18, 24, 
    22, 22, 11, 19, 12, 18, 20, 32,
    22, 20, 21, 11,  1, 11, 42,  0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    30,  8, 17, 17,  8,  8, 28, 28, 
    23, 26, 26, 27, 29, 30, 23, 27, 
    26, 30, 30, 28, 30, 30, 28, 30, 
    28, 30, 26, 28, 29, 30, 28, 28, 
    28, 28, 28, 30, 21, 30, 30, 26, 
    27, 28, 30, 24, 27, 30, 27, 27, 
    27, 30, 30, 30, 30, 30, 26, 30, 
    17, 30, 21, 22, 26, 28,  7, 10, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0},
  5,				/* offset */
  1, 4, true, false,
},
{
  "ArcSymbol",			/* #8 (our numbering) */
  false,			/* not basic font */
  49, 1, 0, 0, 595,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 40.0 / 64.0), /* 40 = height of top of parenthesis */
  (int)(1000 * 1.4 * 9.0 / 64.0), /* 9 = depth of descender of `p' and `q' */
  28, 36,			/* raster size = 28x36 (for lower half) */
  28, 36,			/* raster size = 28x36 (for upper half) */
  15, -1,			/* charset numbers (pre-HP-GL/2) */
  10, 11,			/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    28,  2, 10, 28, 26, 27, 28,  3, 
     8,  8, 26, 28,  3, 28,  2, 20, 
    26,  9, 22, 24, 29, 23, 25, 23, 
    24, 25,  2,  3, 27, 27, 27, 20, 
    31,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0, 
    21,  1, 25, 26, 28, 26, 26, 42, 
    27, 28, 27,  9, 20,  9, 16, 54, 
    10, 30, 30, 30, 30,  0, 29, 29, 
    29, 29, 27, 27, 27, 27, 27, 27, 
    26, 26, 33, 26, 33, 26, 34, 26, 
    18, 27,  6, 11,  1, 11, 29, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0},
  5,				/* offset */
  2, 1, false, false,
},
{
  "Stick",			/* #9 (our numbering) */
  true,				/* basic font */
  48, 0, 0, 0, 277,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0), /* 36 = height of top of parenthesis */
  (int)(1000 * 1.4 * 8.0 / 64.0), /* 8 = depth of descender of `p' and `q' */
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  0, 7,				/* charset numbers (pre-HP-GL/2) */
  0, 1,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32},
  8,				/* offset */
  3, 1, false, true,
},
{
  "Stick-Oblique",		/* #10 */
  true,				/* basic font */
  48, 0, 0, 0, 277,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0), 
  (int)(1000 * 1.4 * 8.0 / 64.0), 
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  0, 7,				/* charset numbers (pre-HP-GL/2) */
  0, 1,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32},
  8,				/* offset */
  3, 2, true, true,
},
{
  "Stick-Bold",			/* #11 */
  true,				/* basic font */
  48, 0, 0, 3, 277,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0),
  (int)(1000 * 1.4 * 8.0 / 64.0), 
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  0, 7,				/* charset numbers (pre-HP-GL/2) */
  0, 1,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32},
  8,				/* offset */
  3, 3, false, true,
},
{
  "Stick-BoldOblique",		/* #12 */
  true,				/* basic font */
  48, 0, 0, 3, 277,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0),
  (int)(1000 * 1.4 * 8.0 / 64.0), 
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  0, 7,				/* charset numbers (pre-HP-GL/2) */
  0, 1,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32},
  8,				/* offset */
  3, 4, true, true,
},
{
  "StickANK",			/* #13 (our numbering) */
  false,			/* not basic font */
  48, 0, 0, 0, 11,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0), /* 36 = height of top of parenthesis */
  (int)(1000 * 1.4 * 8.0 / 64.0), /* 8 = depth of descender of `p' and `q' */
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  6, 8,				/* charset numbers (pre-HP-GL/2) */
  2, 3,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32},
  8,				/* offset */
  4, 1, false, false,
},
{
  "StickANK-Oblique",		/* #14 */
  false,			/* not basic font */
  48, 0, 0, 0, 11,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0), 
  (int)(1000 * 1.4 * 8.0 / 64.0), 
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  6, 8,				/* charset numbers (pre-HP-GL/2) */
  2, 3,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32},
  8,
  4, 2, true, false,
},
{
  "StickANK-Bold",		/* #15 */
  false,			/* not basic font */
  48, 0, 0, 3, 11,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0),
  (int)(1000 * 1.4 * 8.0 / 64.0), 
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  6, 8,				/* charset numbers (pre-HP-GL/2) */
  2, 3,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32},
  8,
  4, 3, false, false,
},
{
  "StickANK-BoldOblique",	/* #16 */
  false,			/* not basic font */
  48, 0, 0, 3, 11,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0),
  (int)(1000 * 1.4 * 8.0 / 64.0), 
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  6, 8,				/* charset numbers (pre-HP-GL/2) */
  2, 3,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0,
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32},
  8,
  4, 4, true, false,
},
{
  "StickSymbol",		/* #17 (our numbering) */
  false,			/* not basic font */
  48, 0, 0, 0, 595,		/* HP-GL/2 t'face, spacing, italic, wt., symset */
  (int)(1000 * 1.4 * 36.0 / 64.0), /* 36 = height of top of parenthesis */
  (int)(1000 * 1.4 * 8.0 / 64.0), /* 8 = depth of descender of `p' and `q' */
  32, 32,			/* raster size = 32x32 (for lower half) */
  32, 32,			/* raster size = 32x32 (for upper half) */
  5, -1,			/* charset numbers (pre-HP-GL/2) */
  4, 5,				/* kerning tables */
  {
    /* lower half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 
    32, 32, 32, 32, 32, 32, 32, 32, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32,  0,  0,  0,  0,  0,  0,  0,
    0,   0,  0,  0,  0,  0,  0,  0, 
    32, 32, 32, 32, 32, 32, 32, 32, 
    32, 32, 32, 32, 32, 32, 32, 32, 
    32, 32, 32, 32, 32,  0, 32, 32, 
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 0, 
    /* upper half */
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0},
  8,				/* offset */
  5, 1, false, false,
},
{
  NULL,				/* DUMMY */
  false,			
  0, 0, 0, 0, 0,
  0, 0,
  0, 0,
  0, 0,
  0, 0,
  0, 0,				/* kerning tables */
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
  0, 0, 0, 0, 0, 0},
  0,
  0, 0, false, false
}
};

/* Known HP vector typefaces.  Each plTypefaceInfoStruct contains the
   following information:
   
   (1) number of valid fonts [should be >= 2, since every typeface
       should include a symbol font (the zeroth font, the 1st listed)]
   (2) a list of fonts (each number is an index into
       the _pl_g_pcl_font_info[] array above).

   The number of valid fonts should be <= PL_MAX_FONTS_PER_TYPEFACE; the
   initializers are filled out with dummy fonts to get arrays of length
   PL_MAX_FONTS_PER_TYPEFACE. */

const struct plTypefaceInfoStruct _pl_g_stick_typeface_info[] = 
{
  /* Arc, #0 */
  { 5, { 0, 0, 1, 2, 3, 999, 999, 999, 999, 999 } },
  /* ArcANK, #1 */
  { 5, { 4, 4, 5, 6, 7, 999, 999, 999, 999, 999 } },
  /* ArcSymbol, #2 */
  { 2, { 8, 8, 999, 999, 999, 999, 999, 999, 999, 999 } },
  /* Stick, #3 */
  { 5, { 9, 9, 10, 11, 12, 999, 999, 999, 999, 999 } },
  /* StickANK, #4 */
  { 5, { 13, 13, 14, 15, 16, 999, 999, 999, 999, 999 } },
  /* StickSymbol, #5 */
  { 2, { 17, 17, 999, 999, 999, 999, 999, 999, 999, 999 } },
};

/* Kerning information for upper and lower halves of the Stick fonts, in
   HP-GL/2 and pre-HP-GL/2, e.g., in the HP7550A pen plotter.  For
   background info, see "Firmware Determines Plotter Personality", by
   L. W. Hennessee, A. K. Frankel, M. A. Overton, and R. B. Smith,
   Hewlett-Packard Journal, Nov. 1981, pp. 16-25.

   Each kerning table specifies (1) an HP spacing table [see below], and
   (2) a map that takes each character in a 128-character font half to the
   appropriate row class and column class, i.e., to its `right edge class'
   and `left edge class'.  Each of HP's spacing tables is indexed by row
   class and column class.

   The map from characters to row/column classes depends on our reencoding,
   if any.  I.e., HP wouldn't necessarily recognize the kerning tables,
   unlike the underlying spacing tables.  For example, several of the
   kerning tables identified as `upper half' are indexed by characters in
   the upper half of the ISO-Latin-1 encoding.  We elsewhere map our
   ISO-Latin-1 fonts into HP's native Roman-8 encoding (see h_roman8.h),
   which is why we index by ISO-Latin-1 rather than Roman-8 here. */

/* our numbering of HP's spacing tables (see below) */
#define SPACING_FIXED_WIDTH 0
#define SPACING_VARIABLE_WIDTH 1
#define SPACING_VARIABLE_WIDTH_KATAKANA 2

/* kerning tables for 128-character font halves */
const struct plStickFontSpacingTableStruct _pl_g_stick_kerning_tables[] =
{
  /* kerning table #0, used for lower half of our 4 basic Stick fonts
     (ASCII encoding) */
  {
    SPACING_FIXED_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0
    },
  },
  /* kerning table #1, used for upper half of our 4 basic Stick fonts
     (ISO-Latin-1 encoding) */
  {
    SPACING_FIXED_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0
    },
  },
  /* kerning table #2, used for lower half of StickANK (JIS ASCII encoding) */
  {
    SPACING_FIXED_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0
    },
  },
  /* kerning table #3, used for upper half of StickANK (half-width Katakana
     encoding, also called `Kana-7') */
  {
    SPACING_FIXED_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
    },
  },
  /* kerning table #4, used for lower half of StickSymbol (HP's `Special
     Symbols' encoding; same as ASCII except that A..O are centered marker
     symbols; P, Q are misc. chars, a..z are mathematical symbols) */
  {
    SPACING_FIXED_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      1, 1, 1, 1, 1, 1, 1, 0
    },
  },
  /* kerning table #5, used for upper half of StickSymbol (empty) */
  {
    SPACING_FIXED_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0
    },
  },
  /* kerning table #6, used for lower half of our 4 basic Arc fonts (ASCII
     encoding) */
  {
    SPACING_VARIABLE_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 2, 2, 2, 2, 1,
      3, 4, 5, 6, 1, 6, 1, 7,
      6, 8, 9, 2,10,11,12,11,
      2,12, 1, 1, 6, 6, 6,13,
      6,14,13, 4, 4,15,16,15,
      1, 1,15,17, 3, 1, 1, 4,
     16,18,13,13, 7,15, 7, 7,
     17, 7,17, 3, 1, 1,14, 3,
      7,19, 5, 5,20, 5,21,20,
     22,20,20,23,20,22,22, 5,
      5,20,21,19,21,20,23,23,
     23,23,23, 3, 1,13, 6, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 2, 2, 2, 2, 1,
      3, 4, 5, 6, 1, 6, 1, 7,
      6, 8, 9, 2,10, 9, 6, 8,
      2, 2, 1, 1, 6, 6, 6,11,
      6, 7,12, 3,12,12,12, 3,
     12,12, 4,12,12,12,12, 3,
     12, 3,12,11,13,14,13,13,
     15,13,15,12,13,13, 7, 4,
     13,16, 1, 5, 5, 5,17, 5,
      1, 1,18, 1, 1, 1, 1, 5,
      1, 5, 1,16,17,16,19,19,
     20,19,20,11,12,13, 6, 0
    }
  },
  /* kerning table #7, used for upper half of our 4 basic Arc fonts
     (ISO-Latin-1 encoding) */
  {
    SPACING_VARIABLE_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 5, 2,18, 7, 1, 2,
      4, 0,19, 2, 0, 6, 0, 3,
      1, 6, 0, 0, 4, 0, 0, 0,
      0, 0, 5, 2, 2, 2, 0,13,
     14,14,14,14,14,14,15, 4,
     15,15,15,15, 1, 1, 1, 1,
      4, 1, 4, 4, 4, 4, 4, 0,
     18,15,15,15,15, 0,16,13,
     19,19,19,19,19,19, 5, 5,
      5, 5, 5, 5,21,21,21,21,
     21,22, 5, 5, 5, 5, 5, 0,
      5,20,20,20,20, 0, 5,23
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 5, 2, 3,13,12, 2,
      1, 0,16, 2, 0, 6, 0, 4,
      1, 6, 0, 0, 1, 0, 0, 0,
      0, 0, 5, 2, 2, 2, 0,11,
      7, 7, 7, 7, 7, 7, 7, 3,
     12,12,12,12,12,12,12,12,
     13,12, 3, 3, 3, 3, 3, 0,
      3,14,14,14,14, 0,13,12,
     16,16,16,16,16,16,16, 5,
      5, 5, 5, 5,17,17,17,17,
      5, 1, 5, 5, 5, 5, 5, 0,
      5,16,16,16,16, 0, 1,19
    }
  },
  /* kerning table #8, used for lower half of ArcANK (JIS ASCII encoding;
     same as basic lower-half Arc font table above except that \ and ~ are
     different characters (yen and overbar respectively) */
  {
    SPACING_VARIABLE_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 2, 2, 2, 2, 1,
      3, 4, 5, 6, 1, 6, 1, 7,
      6, 8, 9, 2,10,11,12,11,
      2,12, 1, 1, 6, 6, 6,13,
      6,14,13, 4, 4,15,16,15,
      1, 1,15,17, 3, 1, 1, 4,
     16,18,13,13, 7,15, 7, 7,
     17, 7,17, 3, 7, 1,14, 3,
      7,19, 5, 5,20, 5,21,20,
     22,20,20,23,20,22,22, 5,
      5,20,21,19,21,20,23,23,
     23,23,23, 3, 1,13, 3, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 2, 2, 2, 2, 1,
      3, 4, 5, 6, 1, 6, 1, 7,
      6, 8, 9, 2,10, 9, 6, 8,
      2, 2, 1, 1, 6, 6, 6,11,
      6, 7,12, 3,12,12,12, 3,
     12,12, 4,12,12,12,12, 3,
     12, 3,12,11,13,14,13,13,
     15,13,15,12,13,13, 7, 4,
     13,16, 1, 5, 5, 5,17, 5,
      1, 1,18, 1, 1, 1, 1, 5,
      1, 5, 1,16,17,16,19,19,
     20,19,20,11,12,13, 4, 0
    }
  },
  /* kerning table #9, used for upper half of ArcANK (half-width Katakana
     encoding, also called `Kana-7') */
  {
    SPACING_VARIABLE_WIDTH_KATAKANA,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 2, 3, 3,
      3, 3, 4, 3, 3, 4, 4, 3,
      2, 5, 6, 3, 4, 5, 7, 2,
      3, 5, 7, 5, 3, 4, 4, 3,
      3, 2, 3, 2, 8, 5, 4, 4,
      4, 3, 9, 4, 3, 9, 4, 5,
      4, 9, 3, 4, 5, 4, 7, 3,
      7, 4, 3, 7, 3, 3,10,10,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 2, 3, 1, 4, 4, 1,
      1, 1, 1, 1, 1, 1, 1, 1,
      4, 5, 1, 4, 4, 4, 4, 4,
      6, 7, 4, 5, 4, 4, 5, 5,
      6, 4, 5, 4, 2, 5, 4, 4,
      4, 8, 4, 2, 5, 9, 4, 5, 
      4,10, 3, 4, 5, 4, 4, 4,
      2, 4, 2, 2, 4, 4,11,11,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0
    }
  },
  /* kerning table #10, used for lower half of ArcSymbol (HP's `Special
     Symbols' encoding; same as ASCII except that A..O are centered marker
     symbols; P, Q are misc. chars, a..z are mathematical symbols) */
  {
    SPACING_VARIABLE_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 2, 2, 2, 2, 1,
      3, 4, 5, 6, 1, 6, 1, 7,
      6, 8, 9, 2,10,11,12,11,
      2,12, 1, 1, 6, 6, 6,13,
      6, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      3, 1,13,13, 7,15, 7, 7,
     17, 7,17, 3, 1, 1,14, 3,
      7, 2, 2, 2, 2, 0, 6, 6,
      6, 6, 6, 6, 6, 6, 6, 6,
      6, 6, 6, 7, 6, 7, 2, 6,
      5, 6, 1, 3, 1,13, 6, 0
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 2, 2, 2, 2, 1,
      3, 4, 5, 6, 1, 6, 1, 7,
      6, 8, 9, 2,10, 9, 6, 8,
      2, 2, 1, 1, 6, 6, 6,11,
      6, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
     17, 1,12,11,13,14,13,13,
     15,13,15,12,13,13, 7, 4,
     13, 2, 2, 2, 2, 0, 7, 7,
      7, 7, 7, 7, 7, 7, 7, 7,
      7, 7, 7,11, 7,13, 2, 7,
      5, 7, 1,11,12,13, 6, 0
    }
  },
  /* kerning table #11, used for upper half of ArcSymbol font (empty) */
  {
    SPACING_VARIABLE_WIDTH,
    {				/* row classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
    },
    {				/* column classes */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 
    }
  }
};

/* The following are HP's device-resident spacing tables, as used in the
   pre-HP-GL/2 HP7550A pen plotter, and presumably in HP-GL/2 devices as
   well.  Order agrees with the SPACING_* definitions above.  There are
   three, because there are three distinct sorts of old-style 7-bit HP
   character set: (1) fixed width, (2) variable width, and (3) variable
   width Japanese Katakana.  Characters in the three different sorts of
   character set are defined on abstract rasters of different sizes.
   Nominal character cell widths are 48 units, 42 units, and 45 units,
   respectively.  Nominal `raster widths' are 2/3 of these: 32 units, 28
   units, and 30 units, respectively.  Character cell and raster widths are
   to be taken literally only for the fixed-width character sets.  But font
   size, measured horizontally, is always twice the nominal raster width,
   i.e., 4/3 times the nominal character cell width. */

/* 2x2 spacing table for fixed-width character sets, which we use in our
   Stick, StickSymbol, etc. fonts.  In these units, character cell width
   equals 48, and font size (measured horizontally) equals 64.
  
   This spacing table is a kludge.  The width tables for the `fixed width'
   character sets don't list every character as having width 48 (the
   nominal width for the space character is 48, but all other characters
   have width 32).  So this spacing table is employed to fix things up:
   e.g., the spacing between any two non-space characters is made equal to
   16 units. */
const short _pl_g_fixed_width_spacings[] =
{
    0,  8,
    8, 16
};

/* 24x21 spacing table for variable-width character sets (other than
   variable-width Katakana), which we use in our Arc, ArcSymbol, etc.,
   fonts.  In these units, nominal character cell width (see above) equals
   42, and font size (measured horizontally) equals 56. */
const short _pl_g_variable_width_spacings[] =
{
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0,14,13,13,10,11,13,11,12,13,12,13,17,11,14,12,13,11,10,11,11,
  0,12,18,11, 8,10,18,10,18,18,18,11,13, 9,13,10,11, 9, 6, 9, 8,
  0, 8, 8, 6, 6, 8, 6, 7, 8, 8, 7, 8, 9, 3, 9, 7, 8, 3, 3, 3, 8,
  0,12,11,11, 8,10,11, 9, 8,10, 9,11,13, 8,12, 9,11,10, 8, 9, 8,
  0,12,10,10, 9,10,10, 9, 7, 9, 8,10,12, 6,11, 7,11,10, 8,10,10,
  0,12,16,11, 8,10,16, 9,16,16,16,11,13, 8,12, 9,11,10, 8, 9, 8,
  0,10, 9, 8, 3, 6, 8, 6, 8, 8, 6, 9,11, 8,11, 9, 6, 8, 6, 7, 7,
  0,14,33,13,10,11,33,11,33,33,33,13,17,11,14,12,13,11,10,11,11,
  0,10,20,11, 8, 9,20,10,20,20,20,11,13, 8,11, 8,10,10, 7,10, 9,
  0,10,13,10, 8, 9,13,10,13,13,13,11,13, 8,11, 8,10,10, 7,10, 9,
  0,10,19,10, 8, 9,19,10,19,19,19,11,13, 8,11, 8,10,10, 7,10, 9,
  0,12,17,11, 8,10,17, 9,17,17,17,11,13, 8,12, 9,11,10, 8, 9, 8,
  0,12,11,11, 8,10,11,10,10,11,10,11,13, 9,13,10,11, 9, 6, 9, 8,
  0,11, 9, 9, 7,10, 9, 8, 8,10, 7, 9,11, 6,10, 8,11, 8,10, 8, 8,
  0,13,12,12, 9,11,12,11,11,11,11,12,15,11,13,11,11,11,10,11,11,
  0,11,10, 9, 7, 8, 9, 7, 8, 9, 8,10,11, 9,11, 9, 8,10, 6, 9, 9,
  0,11,10, 9, 7, 7, 9, 8, 9, 8, 7,10,11, 8,11, 9, 8, 6, 8, 7, 8,
  0,10,10,11, 9,11,11, 8,10,10,10,10,12, 8,12, 9,11,10, 6, 8, 8,
  0,13,11,11,10,11,11, 9, 8,11, 8,11,11, 8,11, 9,11,10, 9,10,11,
  0,14,11,12,10,12,12, 9,11,12,10,11,14,11,13,11,12,11,10,11,11,
  0,12,10,10, 6, 9,10, 7, 9, 9, 7,10,11, 8,11, 9,10,11, 8,11,10,
  0,13,11,11, 9,11,11,10,10,11, 8,11,13, 8,13,10,12,11,10,11,11,
  0,11, 9, 9, 6,10, 9, 8, 9, 9, 8, 9,11, 8,11, 8, 9,10, 9, 9, 9
};

/* 11x12 spacing table for the variable-width Katakana character set, which
   we use as the upper half of our ArcANK font.  In these units, nominal
   character cell width (see above) equals 45, and font size (measured
   horizontally) equals 60. */
const short _pl_g_variable_width_katakana_spacings[] =
{
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 10,14,10,10,10,10,10,10,10,10,10,
  0, 10,14,6, 10,10,6, 10,2, 10,10,2, 
  0, 10,14,10,10,10,10,10,6, 10,10,0, 
  0, 10,14,10,10,10,10,10,10,6, 10,0, 
  0, 6, 14,2, 10,10,6, 6, 2, 6, 6, 0, 
  0, 10,14,6, 10,10,6, 6, 6, 6, 10,10,
  0, 10,14,10,14,14,10,10,10,10,14,0, 
  0, 10,14,6, 10,10,6, 10,2, 10,10,0, 
  0, 10,14,10,10,6, 10,10,10,6, 10,0, 
  0, 2, 10,2, 10,10,2, 6, 2, 10,2, 10
};

/* array we use to access spacing tables by number */
const struct plStickCharSpacingTableStruct _pl_g_stick_spacing_tables[] =
{
  /* spacing table #0, SPACING_FIXED */
  {
    2, 2,			/* number of rows, cols */
    _pl_g_fixed_width_spacings
  },
  /* spacing table #1, SPACING_VARIABLE_WIDTH */
  {
    24, 21,			/* number of rows, cols */
    _pl_g_variable_width_spacings
  },
  /* spacing table #2, SPACING_VARIABLE_WIDTH_KATAKANA */
  {
    11, 12,			/* number of rows, cols */
    _pl_g_variable_width_katakana_spacings
  }
};
