#
# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001, 2002  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

%.texi: %.texi.m4
	$(M4) -I .. --prefix-builtins $< > $@

texi_m4_files = $(wildcard *.texi.m4)
texi_target = $(basename $(texi_m4_files))

html_target = $(texi_m4_files:.texi.m4=.html) 

# the files that get installed into $(datadir)/$(PACKAGE)/$(VERSION)/$(name)
data-installfiles = $(html_target)

# the files to include in the tarball at "make dist"
dist_files = Makefile $(wildcard *.m4)

# the extra files distributed in solfege-x.y.z-win32.zip
win32_dist_files = $(wildcard *.html)

$(texi_target): ../texidefinitions.m4
$(html_target): ../texidefinitions.m4

all: $(html_target)

dvi: $(texi_target) solfege.texi fdl.texi
	texi2dvi solfege.texi

install: data-install

uninstall: data-uninstall

clean:
	rm -f $(html_target)
	rm -f *.aux *.cp *.dvi *.fn *.ky *.log *.pg *.toc *.tp *.vr *.info *.cps
	rm -f $(texi_target)

distclean: clean

