/*
 * Decompiled with CFR 0.152.
 */
package wb;

import wb.Blink;
import wb.Blk;
import wb.Del;
import wb.Ent;
import wb.Ents;
import wb.Handle;
import wb.Seg;
import wb.Wbdefs;
import wb.Wbsys;

public class Stats {
    public static int nextCt = 0;
    public static int nextFct = 0;
    public static int prevCt = 0;
    public static int prevFct = 0;
    public static int getCt = 0;
    public static int getFct = 0;
    public static int putCt = 0;
    public static int putFct = 0;
    public static int remCt = 0;
    public static int remFct = 0;
    public static int geCt = 0;
    public static int geFct = 0;
    public static int tgeCt = 0;
    public static int tgeFct = 0;
    public static int tceCt = 0;
    public static int tceFct = 0;
    public static int chainsToNext = 0;
    public static int deferredInserts = 0;
    public static int splitIndexInserts = 0;
    public static int indexScrewCase = 0;
    public static int blockSplits = 0;
    public static int blockDeletes = 0;
    public static int deferredDeletes = 0;
    public static int dirDtyCt = 0;
    public static int readCt = 0;
    public static int writeCt = 0;
    public static int readFlCt = 0;
    public static int writeFlCt = 0;
    public static int flushCt = 0;
    public static boolean bufVerbose_P = true;

    public static int clearStats() {
        nextCt = 0;
        nextFct = 0;
        prevCt = 0;
        prevFct = 0;
        getCt = 0;
        getFct = 0;
        putCt = 0;
        putFct = 0;
        remCt = 0;
        remFct = 0;
        geCt = 0;
        geFct = 0;
        tgeCt = 0;
        tgeFct = 0;
        tceCt = 0;
        tceFct = 0;
        chainsToNext = 0;
        deferredInserts = 0;
        splitIndexInserts = 0;
        indexScrewCase = 0;
        blockSplits = 0;
        blockDeletes = 0;
        deferredDeletes = 0;
        dirDtyCt = 0;
        readCt = 0;
        writeCt = 0;
        readFlCt = 0;
        writeFlCt = 0;
        flushCt = 0;
        return 0;
    }

    public static int cstats() {
        Stats.stats();
        return Stats.clearStats();
    }

    public static int stats() {
        System.err.print("\n");
        System.err.print("OPERATIONS SUMMARY:\n");
        System.err.print("            NEXT     PREV      GET      PUT      REM   GETENT   CACHE    CACHE\n");
        System.err.print("                                                                AVAIL?   VALID?\n");
        System.err.print("   succ " + nextCt + " " + prevCt + " " + getCt + " " + putCt + " " + remCt + " " + geCt + " " + tgeCt + " " + tceCt + "\n");
        System.err.print("   fail " + nextFct + " " + prevFct + " " + getFct + " " + putFct + " " + remFct + " " + geFct + " " + tgeFct + " " + tceFct + "\n\n");
        System.err.print("INTERNAL OPERATIONS SUMMARY:\n");
        System.err.print("   chains-to-next = " + chainsToNext + "\n");
        System.err.print("   " + blockSplits + " block splits, " + deferredInserts + " deferred parent updates, " + deferredInserts + " undone\n");
        System.err.print("   " + splitIndexInserts + " split index inserts; " + indexScrewCase + " index-insert screw cases \n");
        System.err.print("   " + blockDeletes + " block deletes; " + deferredDeletes + " deferred block deletes\n\n");
        System.err.print("I/O SUMMARY: " + readCt + " READS, " + writeCt + " WRITES, " + flushCt + " FLUSH (of dirty bufs) calls.\n");
        System.err.print("             " + readFlCt + " FREELIST READS, " + writeFlCt + " FREELIST WRITES.\n");
        System.err.print("             " + dirDtyCt + " DIRS LEFT DTY.\n");
        int n = Math.max(nextFct + prevFct + getFct + putFct + remFct + nextCt + prevCt + getCt + putCt + remCt, 1);
        System.err.print("   AVG BLKS REFERENCED PER OPERATION: " + 100 * (geCt + tceCt) / n + "%\n");
        System.err.print("   AVG DISK I/Os PER OPERATION: " + 100 * (readCt + writeCt + readFlCt + writeFlCt) / n + "%; ");
        System.err.print("   WRITE/READ RATIO: " + 100 * (writeCt + writeFlCt) / Math.max(1, readCt + readFlCt) + "%\n");
        if (putCt > 0) {
            System.err.print("   AVG DISK WRITES PER PUT: " + 100 * writeCt / putCt + "%\n");
        }
        System.err.print("\n");
        System.err.print("MODES IN EFFECT:\n");
        System.err.print("" + Ents.numEntsCt + " buffers [hashed over " + Ents.numBuks + " buckets]; blksize (max)=" + Ents.blkSize + "; FLC-LEN=" + 10 + "\n");
        System.err.print("defer-insert-updates?= " + (Blink.deferInsertUpdates_P ? "#t" : "#f") + "; defer-block-deletes=" + (Del.del_DeferBlockDeletes_P ? "#t" : "#f") + "\n");
        System.err.print("cache-ent-enable?=" + (Ents.cacheEntEnable_P ? "#t" : "#f") + "; clever-cache-enable?=" + (Handle.cleverCacheEnable_P ? "#t" : "#f") + "\n");
        System.err.print("\n");
        return 0;
    }

    public static void showBuffer(Ent ent) {
        System.err.print("SEG = " + Seg.seg_Id(Ent.ent_Seg(ent)) + " ID= " + Ent.ent_Id(ent) + " ACC= " + Ent.ent_Acc(ent) + " REF= " + Ent.ent_Ref(ent) + " DTY= " + Ent.ent_Dty_P(ent) + " AGE= " + Ent.ent_Age(ent) + "\n");
    }

    public static int showBuffer1(Ent ent) {
        if (bufVerbose_P || Seg.seg_Id(Ent.ent_Seg(ent)) > -1) {
            System.err.print(" " + Seg.seg_Id(Ent.ent_Seg(ent)) + ":" + Ent.ent_Id(ent) + " " + Wbdefs.hash2int(Seg.seg_Id(Ent.ent_Seg(ent)), Ent.ent_Id(ent)) + " " + Ent.ent_Acc(ent) + " " + Ent.ent_Ref(ent) + " " + 0 + " " + Ent.ent_Dty_P(ent) + " " + Ent.ent_Age(ent) + "");
            if (Seg.seg_Id(Ent.ent_Seg(ent)) > -1) {
                System.err.print(" " + (Blk.blk_Level(Ent.ent_Blk(ent)) - 48) + " " + Blk.blk_Typ(Ent.ent_Blk(ent)) + "\n");
            } else {
                System.err.print("\n");
            }
        }
        return 0;
    }

    public static int showBuffers() {
        System.err.print("\n");
        System.err.print(" SEG:ID        BUK      ACC    REF READERS DTY  AGE LEVEL TYPE\n");
        return Ents.doSegBuffers(null, Wbsys.getMethod("wb.Stats", "showBuffer1", new Class[]{Ent.class}));
    }

    public static int sb() {
        return Stats.showBuffers();
    }
}

