/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;

namespace LocaleInpector
{

internal sealed class PoToLocale
{

private PoToLocale()
{
}

// scrapbook.xpi|chrome/scrapbook.jar|locale/en-US/captureURL.dtd
//                                ==> locale/en-US/captureURL.dtd

public static void Save(string filePo, string dirOutput, string dirOriginal)
{
    System.Console.WriteLine("Merging {0} (po) and {1} (xpi) to {2} (zip).", filePo, dirOriginal, dirOutput);

    PoFile po = new PoFile(filePo);
    List<PoEntry> poEntries = new List<PoEntry>(po.LoadHashtableII().Values);
    Dictionary<string, Dictionary<string, string>> localeFiles = ArrangeFiles(poEntries);

    //         Hashtable,xpi jar dir, zip
    Merge.SavePo(localeFiles, dirOriginal, dirOutput);
}


private static Dictionary<string, Dictionary<string, string>> ArrangeFiles(List<PoEntry> poEntries)
{
    Dictionary<string, Dictionary<string, string>> localeFiles;
    localeFiles = new Dictionary<string, Dictionary<string, string>>();

    foreach (PoEntry entry in poEntries) {

        if (entry.Fuzzy) {
            continue;
        }

        // trans = "Recort&ar"
        // trans = "Colar"
        string trans = entry.Translated;
        if (trans.Length == 0) {
            continue;
        }


        //  h:bug!!! #: locale/en-US/toolkit/installer/unix/install.it*String Resources->-614
        string[] ownersEntry = entry.References.Split(' ');

        // ownersEntry[0] global/textcontext.dtd*pasteCmd.label*pasteCmd.accesskey
        // ownersEntry[1] messenger/messengercompose/messengercompose.dtd*paste.label*paste.accesskey

        for (int idxOwnersEntry = 0; idxOwnersEntry < ownersEntry.Length; idxOwnersEntry++) {
            // itemsEntry[0] = global/textcontext.dtd
            // itemsEntry[1] = pasteCmd.label
            // itemsEntry[2] = pasteCmd.accesskey
            // itemsEntry[0] = tabmix.xpi|chrome/tabmix.jar|locale/en-US/tabmix/pref-tabmix.ent*tabsList.label*tabsList.accesskey
            string[] itemsEntry = ownersEntry[idxOwnersEntry].Split('*');

            // arr2[0] = global/textcontext.dtd*pasteCmd.label
            // arr2[0] = tabmix.xpi
            // arr2[1] = chrome/tabmix.jar
            // arr2[2] = locale/en-US/tabmix/pref-tabmix.ent
            //string[] arr2 = itemsEntry[0].Split('|');

            string fileName = itemsEntry[0]; //arr2[itemsEntry.Length - 1].Replace('/', System.IO.Path.DirectorySeparatorChar);
            Dictionary<string, string> fileEntries;
            if (localeFiles.ContainsKey(fileName)) {
                fileEntries = localeFiles[fileName];
            } else {
                fileEntries = new Dictionary<string, string>();
                localeFiles.Add(fileName, fileEntries);
            }

            // label = "Colar"
            if (itemsEntry.Length == 2) {
                fileEntries.Add(itemsEntry[1], trans);

            // label + access key = "Recortar" + "a"
            } else if (itemsEntry.Length == 3) {
                int idx = trans.IndexOf('&');
                if (idx > -1) {
                    trans = trans.Remove(idx, 1); // del '&'
                    fileEntries.Add(itemsEntry[2], trans[idx].ToString());
                } else {
                    // accesskey has been removed by user or po editor
                }
                fileEntries.Add(itemsEntry[1], trans);

            } else {
                // bug: key not declared
                throw new System.InvalidOperationException();
            }
        }
    }

    return localeFiles;
}

}//class
}//ns
