/* <!-- ****** BEGIN LICENSE BLOCK *****
Version: MPL 1.1/GPL 2.0/LGPL 2.1

The contents of this file are subject to the Mozilla Public License Version 
1.1 (the "License"); you may not use this file except in compliance with 
the License. You may obtain a copy of the License at 
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is Checky.

The Initial Developer of the Original Code is
Joachim Schreiber (yo@yos.biz).
Portions created by the Initial Developer are Copyright (C) 2002-2003
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

The Checky Plug-in is an simple Interface for Web content and 
resource developers to free and commercial online validation and analysis services. 

We do not provide any support or guarantee. 

Any rights not expressly granted herein are reserved by their owners. 
Please visit the Web Sites of Service owners for more informations 
about terms of usage before using Checky the first time. Hyperlinks are 
located at http://checky.mozdev.org/Services/.

***** END LICENSE BLOCK ***** --> */

/*

----------
 Services
----------


serviceId - Service Name
-----------------------------------------------------
0  - W3C HTML MarkUp Validation Service
1  - W3C CSS Validaton Service
2  - W3C RDF Validation Service
3  - W3C Link Checker
4  - W3C HTML TIDY

5  - WDG HTML Validator
6  - WDG CSSCheck (only CSS files no HTML)
7  - WDG Link Valet

8  - WebThing Page Valet

9  - Delorie Lynx Viewer
10 - Delorie Web Page Purifier
11 - Delorie HTTP Header Viewer

12 - Watchfire Bobby

13 - T.a.w

14 - PIAT WAVE 2.01
15 - PIAT WAVE 2.2
20 - PIAT WAVE 3


16 - Redland RSS 1.0 Validator and Viewer

17 - Mark und Sam RSS Validator

18 - W3C P3P Validator (Integrated Validation)
19 - W3C P3P Validator (Policy File Validation)

21 - Wickline Colorblind Web Page Filter

22 - Cynthia Says Portal
23 - Vischeck
24 - Web Site Optimization Web Page Analyzer 

99 - Checky Agent

*/

var prefService = Components.classes["@mozilla.org/preferences-service;1"]
	                           .getService(Components.interfaces.nsIPrefService);
var pref = prefService.getBranch(null); // preferences root node

netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");




/********************************************
	[0]  - W3C HTML MarkUp Validation Service
********************************************/

serviceUrlW3CMarkup = "http://validator.w3.org/check?";
serviceUrlW3CMarkupUpload = "http://validator.w3.org/file-upload.html";

var charsetListW3CMarkup = [];
charsetListW3CMarkup[0] = "(detect automatically)";
charsetListW3CMarkup[1] = "utf-8 (Unicode, worldwide)";
charsetListW3CMarkup[2] = "utf-16 (Unicode, worldwide)";
charsetListW3CMarkup[3] = "iso-8859-1 (Western Europe)";
charsetListW3CMarkup[4] = "iso-8859-2 (Central Europe)";
charsetListW3CMarkup[5] = "iso-8859-3 (Southern Europe)";
charsetListW3CMarkup[6] = "iso-8859-4 (Baltic Rim)";
charsetListW3CMarkup[7] = "iso-8859-5 (Cyrillic)";
charsetListW3CMarkup[8] = "iso-8859-6-i (Arabic)";
charsetListW3CMarkup[9] = "iso-8859-7 (Greek)";
charsetListW3CMarkup[10] = "iso-8859-8-i (Hebrew)";
charsetListW3CMarkup[11] = "iso-8859-9 (Turkish)";
charsetListW3CMarkup[12] = "iso-8859-10 (Latin 6)";
charsetListW3CMarkup[13] = "iso-8859-13 (Latin 7)";
charsetListW3CMarkup[14] = "iso-8859-14 (Celtic)";
charsetListW3CMarkup[15] = "iso-8859-15 (Latin 9)";
charsetListW3CMarkup[16] = "us-ascii (basic English)";
charsetListW3CMarkup[17] = "euc-jp (Japanese, Unix)";
charsetListW3CMarkup[18] = "shift_jis (Japanese, Win/Mac)";
charsetListW3CMarkup[19] = "iso-2022-jp (Japanese, email)";
charsetListW3CMarkup[20] = "euc-kr (Korean)";
charsetListW3CMarkup[21] = "gb2312 (Chinese, simplified)";
charsetListW3CMarkup[22] = "gb18030 (Chinese, simplified)";
charsetListW3CMarkup[23] = "big5 (Chinese, traditional)";
charsetListW3CMarkup[24] = "tis-620 (Thai)";
charsetListW3CMarkup[25] = "koi8-r (Russian)";
charsetListW3CMarkup[26] = "koi8-u (Ukrainian)";
charsetListW3CMarkup[27] = "macintosh (MacRoman)";
charsetListW3CMarkup[28] = "windows-1250 (Central Europe)";
charsetListW3CMarkup[29] = "windows-1251 (Cyrillic)";
charsetListW3CMarkup[30] = "windows-1252 (Western Europe)";
charsetListW3CMarkup[31] = "windows-1253 (Greek)";
charsetListW3CMarkup[32] = "windows-1254 (Turkish)";
charsetListW3CMarkup[33] = "windows-1255 (Hebrew)";
charsetListW3CMarkup[34] = "windows-1256 (Arabic)";
charsetListW3CMarkup[35] = "windows-1257 (Baltic Rim)";



var doctypeListW3CMarkup = [];
doctypeListW3CMarkup[0] = "(detect automatically)";
doctypeListW3CMarkup[1] = "XHTML 1.1";
doctypeListW3CMarkup[2] = "XHTML Basic 1.0";
doctypeListW3CMarkup[3] = "XHTML 1.0 Strict";
doctypeListW3CMarkup[4] = "XHTML 1.0 Transitional";
doctypeListW3CMarkup[5] = "XHTML 1.0 Frameset";
doctypeListW3CMarkup[6] = "HTML 4.01 Strict";
doctypeListW3CMarkup[7] = "HTML 4.01 Transitional";
doctypeListW3CMarkup[8] = "HTML 4.01 Frameset";
doctypeListW3CMarkup[9] = "HTML 3.2";
doctypeListW3CMarkup[10] = "HTML 2.0";



function checkyW3CMarkup(uri){

	var charsetPref = pref.getIntPref("checky.w3c.markup.charset");
	var doctypePref = pref.getIntPref("checky.w3c.markup.doctype"); 
	var ssPref = pref.getBoolPref("checky.w3c.markup.ss");
	var spPref = pref.getBoolPref("checky.w3c.markup.sp");
	var outlinePref = pref.getBoolPref("checky.w3c.markup.outline");
	var noattPref = pref.getBoolPref("checky.w3c.markup.noatt");
	var No200Pref = pref.getBoolPref("checky.w3c.markup.No200");
	var verbosePref = pref.getBoolPref("checky.w3c.markup.verbose");

	if( isFile(uri) ){
		switch( getAppearType() ){
			case 0 :
				var checkyTab = getBrowser().addTab( serviceUrlW3CMarkupUpload );
				var intervalIDnumber = setInterval( checkyW3CMarkupUploadTab, getPrefTimeout(), checkyTab, uri, charsetPref, doctypePref, ssPref, spPref, outlinePref, noattPref, No200Pref, verbosePref);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
			case 1 :
				var checkyWindow = window.open( serviceUrlW3CMarkupUpload , "checkyWin");
				var aDocument = checkyWindow.document;
				var intervalIDnumber = setInterval(checkyW3CMarkupUploadWin, getPrefTimeout(), checkyWindow, uri, charsetPref, doctypePref, ssPref, spPref, outlinePref, noattPref, No200Pref, verbosePref);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
		}
	}
	else{
		var queryString = serviceUrlW3CMarkup  
			+ "uri=" + prepareBrowserUri(uri)
			+ "&charset=" + charsetListW3CMarkup[charsetPref] 
			+ "&doctype=" + doctypeListW3CMarkup[doctypePref];
		
		if(ssPref)
			queryString += "&ss=1";
		
		if(spPref)
			queryString += "&sp=1";
		
		if(outlinePref)
			queryString += "&outline=1";
		
		if(noattPref)
			queryString += "&noatt=1";
		
		if(No200Pref)
			queryString += "&No200=1";
		
		if(verbosePref)
			queryString += "&verbose=1";

		checkySubmitQuery(queryString);
	}

}


function checkyW3CMarkupUploadWin(checkyWindow, uri, charsetPref, doctypePref, ssPref, spPref, outlinePref, noattPref, No200Pref, verbosePref){
	checkyWindow.document.getElementById("uploaded_file").value=uri;

	checkyWindow.document.getElementById("charset").selectedIndex=charsetPref;
	checkyWindow.document.getElementById("doctype").selectedIndex=doctypePref;

	if(ssPref){
		checkyWindow.document.forms[0].ss.checked = true;
	}
	else{
		checkyWindow.document.forms[0].ss.checked = false;
	}

	if(spPref){
		checkyWindow.document.forms[0].sp.checked = true;
	}
	else{
		checkyWindow.document.forms[0].sp.checked = false;
	}
	
	if(outlinePref){
		checkyWindow.document.forms[0].outline.checked = true;
	}
	else{
		checkyWindow.document.forms[0].outline.checked = false;
	}
	
	if(noattPref){
		checkyWindow.document.forms[0].noatt.checked = true;
	}
	else{
		checkyWindow.document.forms[0].noatt.checked = false;
	}
	
	if(No200Pref){
		checkyWindow.document.forms[0].No200.checked = true;
	}
	else{
		checkyWindow.document.forms[0].No200.checked = false;
	}
	
	if(verbosePref){
		checkyWindow.document.forms[0].verbose.checked = true;
	}
	else{
		//disable default html form 
		checkyWindow.document.forms[0].verbose.checked = false;
	}


	checkyWindow.document.forms[0].submit();
}

function checkyW3CMarkupUploadTab(checkyTab, uri, charsetPref, doctypePref, ssPref, spPref, outlinePref, noattPref, No200Pref, verbosePref){
	var aBrowser = gBrowser.getBrowserForTab(checkyTab);
	aBrowser.contentDocument.getElementById("uploaded_file").value=uri;

	aBrowser.contentDocument.getElementById("charset").selectedIndex=charsetPref;
	aBrowser.contentDocument.getElementById("doctype").selectedIndex=doctypePref;

	if(ssPref){
		aBrowser.contentDocument.forms[0].ss.checked = true;
	}
	else{
		aBrowser.contentDocument.forms[0].ss.checked = false;
	}

	if(spPref){
		aBrowser.contentDocument.forms[0].sp.checked = true;
	}
	else{
		aBrowser.contentDocument.forms[0].sp.checked = false;
	}
	
	if(outlinePref){
		aBrowser.contentDocument.forms[0].outline.checked = true;
	}
	else{
		aBrowser.contentDocument.forms[0].outline.checked = false;
	}
	
	if(noattPref){
		aBrowser.contentDocument.forms[0].noatt.checked = true;
	}
	else{
		aBrowser.contentDocument.forms[0].noatt.checked = false;
	}
	
	if(No200Pref){
		aBrowser.contentDocument.forms[0].No200.checked = true;
	}
	else{
		aBrowser.contentDocument.forms[0].No200.checked = false;
	}
	
	if(verbosePref){
		aBrowser.contentDocument.forms[0].verbose.checked = true;
	}
	else{
		//disable default html form 
		aBrowser.contentDocument.forms[0].verbose.checked = false;
	}

	aBrowser.contentDocument.forms[0].submit();

}


/***********************************************************
	[1]  - W3C CSS Validaton Service - URL / UPLOAD
***********************************************************/

serviceUrlW3CCSS = "http://jigsaw.w3.org/css-validator/validator?";
serviceUrlW3CCSSUpload = "http://jigsaw.w3.org/css-validator/validator-upload.html";

var warningListW3CCSS = [];
warningListW3CCSS[0] = "2";
warningListW3CCSS[1] = "1";
warningListW3CCSS[2] = "0";
warningListW3CCSS[3] = "no";

var profileListW3CCSS = [];
profileListW3CCSS[0] = "none";
profileListW3CCSS[1] = "css1";
profileListW3CCSS[2] = "css2";
profileListW3CCSS[3] = "mobile";

var warningListW3CCSSUpload = [];
warningListW3CCSSUpload[0] = "2";
warningListW3CCSSUpload[1] = "1";
warningListW3CCSSUpload[2] = "0";
warningListW3CCSSUpload[3] = "no";

var profileListW3CCSSUpload = [];
profileListW3CCSSUpload[0] = "none";
profileListW3CCSSUpload[1] = "css1";
profileListW3CCSSUpload[2] = "css2";
profileListW3CCSSUpload[3] = "css3";
profileListW3CCSSUpload[4] = "svg";
profileListW3CCSSUpload[5] = "svgbasic";
profileListW3CCSSUpload[6] = "svgtiny";
profileListW3CCSSUpload[7] = "mobile";
profileListW3CCSSUpload[8] = "atsc-tv";
profileListW3CCSSUpload[9] = "tv";

var usermediumListW3CCSSUpload = [];
usermediumListW3CCSSUpload[0] = "all";
usermediumListW3CCSSUpload[1] = "aural";
usermediumListW3CCSSUpload[2] = "braille";
usermediumListW3CCSSUpload[3] = "embossed";
usermediumListW3CCSSUpload[4] = "handheld";
usermediumListW3CCSSUpload[5] = "print";
usermediumListW3CCSSUpload[6] = "projection";
usermediumListW3CCSSUpload[7] = "screen";
usermediumListW3CCSSUpload[8] = "tty";
usermediumListW3CCSSUpload[9] = "tv";
usermediumListW3CCSSUpload[10] = "presentation";

function checkyQueryW3CCSS(uri){

	var warningPref = pref.getIntPref("checky.w3c.css.warning");
	var profilePref = pref.getIntPref("checky.w3c.css.profile");

	var warningUploadPref = pref.getIntPref("checky.w3c.css.upload.warning");
	var profileUploadPref = pref.getIntPref("checky.w3c.css.upload.profile");
	var usermediumUploadPref = pref.getIntPref("checky.w3c.css.upload.usermedium");

	if( isFile(uri) ){
		switch( getAppearType() ){
			case 0 :
				var checkyTab = getBrowser().addTab( serviceUrlW3CCSSUpload );
				var intervalIDnumber = setInterval( checkyW3CCSSUploadTab, getPrefTimeout(), checkyTab, uri, warningUploadPref, profileUploadPref, usermediumUploadPref);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
			case 1 :
				var checkyWindow = window.open( serviceUrlW3CCSSUpload , "checkyWin");
				var aDocument = checkyWindow.document;
				var intervalIDnumber = setInterval(checkyW3CCSSUploadWin, getPrefTimeout(), checkyWindow, uri, warningUploadPref, profileUploadPref, usermediumUploadPref);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
		}
	}
	else{
		var queryString = serviceUrlW3CCSS 
			+ "uri=" + prepareBrowserUri(uri)
			+ "&warning=" + warningListW3CCSS[warningPref] 
			+ "&profile=" + profileListW3CCSS[profilePref];

		checkySubmitQuery(queryString);
	}

}

function checkyW3CCSSUploadWin(checkyWindow, uri, warningUploadPref, profileUploadPref, usermediumUploadPref){

	checkyWindow.document.forms[0].file.value = uri;

	if(warningUploadPref){
		checkyWindow.document.forms[0].warning.selectedIndex=warningUploadPref;
	}
	else{
		checkyWindow.document.forms[0].warning.selectedIndex = 1;
	}

	if(profileUploadPref){
		checkyWindow.document.forms[0].profile.selectedIndex=profileUploadPref;
	}
	else{
		checkyWindow.document.forms[0].profile.selectedIndex = 2;
	}

	if(usermediumUploadPref){
		checkyWindow.document.forms[0].usermedium.selectedIndex=usermediumUploadPref;
	}
	else{
		checkyWindow.document.forms[0].usermedium.selectedIndex = 0;
	}

	checkyWindow.document.forms[0].submit();

}

function checkyW3CCSSUploadTab(checkyTab, uri, warningUploadPref, profileUploadPref, usermediumUploadPref){
	var aBrowser = gBrowser.getBrowserForTab(checkyTab);
	aBrowser.contentDocument.forms[0].file.value = uri;

	//alert(warningUploadPref);
	//alert(profileUploadPref);
	//alert(usermediumUploadPref);

	if(warningUploadPref){
		aBrowser.contentDocument.forms[0].warning.selectedIndex=warningUploadPref;
	}
	else{
		aBrowser.contentDocument.forms[0].warning.selectedIndex = 1;
	}

	if(profileUploadPref){
		aBrowser.contentDocument.forms[0].profile.selectedIndex=profileUploadPref;
	}
	else{
		aBrowser.contentDocument.forms[0].profile.selectedIndex = 2;
	}

	if(usermediumUploadPref){
		aBrowser.contentDocument.forms[0].usermedium.selectedIndex=usermediumUploadPref;
	}
	else{
		aBrowser.contentDocument.forms[0].usermedium.selectedIndex = 0;
	}

	aBrowser.contentDocument.forms[0].submit();

}

/********************************************
	[2]  - W3C RDF Validation Service
********************************************/
serviceUrlW3CRdf = "http://www.w3.org/RDF/Validator/ARPServlet?";

function checkyW3CRdf(uri){

	var TRIPLES_AND_GRAPHList = [];
	TRIPLES_AND_GRAPHList[0] = "PRINT_BOTH";
	TRIPLES_AND_GRAPHList[1] = "PRINT_TRIPLES";
	TRIPLES_AND_GRAPHList[2] = "PRINT_GRAPH";

	var NODE_COLORList = [];
	NODE_COLORList[0] = "Black";
	NODE_COLORList[1] = "Blue";
	NODE_COLORList[2] = "Darkgreen";
	NODE_COLORList[3] = "Red";

	var NODE_TEXT_COLORList = [];
	NODE_TEXT_COLORList[0] = "Blue";
	NODE_TEXT_COLORList[1] = "Black";
	NODE_TEXT_COLORList[2] = "Darkgreen";
	NODE_TEXT_COLORList[3] = "Red";

	var EDGE_COLORList = [];
	EDGE_COLORList[0] = "Darkgreen";
	EDGE_COLORList[1] = "Black";
	EDGE_COLORList[2] = "Blue";
	EDGE_COLORList[3] = "Red";

	var EDGE_TEXT_COLORList = [];
	EDGE_TEXT_COLORList[0] = "Red";
	EDGE_TEXT_COLORList[1] = "Black";
	EDGE_TEXT_COLORList[2] = "Blue";
	EDGE_TEXT_COLORList[3] = "Darkgreen";

	var FONT_SIZEList = [];
	FONT_SIZEList[0] = "10";
	FONT_SIZEList[1] = "12";
	FONT_SIZEList[2] = "14";
	FONT_SIZEList[3] = "16";
	FONT_SIZEList[4] = "20";

	var ORIENTATIONList = [];
	ORIENTATIONList[0] = "LR";
	ORIENTATIONList[1] = "TB";

	var FORMATList = [];
	FORMATList[0] = "PNG_EMBED";
	FORMATList[1] = "PNG_LINK";
	FORMATList[2] = "GIF_EMBED";
	FORMATList[3] = "GIF_LINK";
	FORMATList[4] = "SVG_LINK";
	FORMATList[5] = "PS_LINK";
	FORMATList[6] = "HP_PCL_LINK";
	FORMATList[7] = "HP_GL_LINK";

	var TRIPLES_AND_GRAPHPref = pref.getIntPref("checky.w3c.rdf.TRIPLES_AND_GRAPH");
	var NODE_COLORPref = pref.getIntPref("checky.w3c.rdf.NODE_COLOR"); 
	var NODE_TEXT_COLORPref = pref.getIntPref("checky.w3c.rdf.NODE_TEXT_COLOR");
	var EDGE_COLORPref = pref.getIntPref("checky.w3c.rdf.EDGE_COLOR");
	var EDGE_TEXT_COLORPref = pref.getIntPref("checky.w3c.rdf.EDGE_TEXT_COLOR");
	var FONT_SIZEPref = pref.getIntPref("checky.w3c.rdf.FONT_SIZE");
	var ORIENTATIONPref = pref.getIntPref("checky.w3c.rdf.ORIENTATION");
	var FORMATPref = pref.getIntPref("checky.w3c.rdf.FORMAT");

	var SAVE_DOT_FILEPref = pref.getBoolPref("checky.w3c.rdf.SAVE_DOT_FILE");
	var NTRIPLESPref = pref.getBoolPref("checky.w3c.rdf.NTRIPLES");
	var EMBEDDED_RDFPref = pref.getBoolPref("checky.w3c.rdf.EMBEDDED_RDF");
	var SAVE_RDFPref = pref.getBoolPref("checky.w3c.rdf.SAVE_RDF");
	var ANON_NODES_EMPTYPref = pref.getBoolPref("checky.w3c.rdf.ANON_NODES_EMPTY");

	var queryString = serviceUrlW3CRdf 
		+ "URI=" + prepareBrowserUri(uri)
		+ "&TRIPLES_AND_GRAPH=" + TRIPLES_AND_GRAPHList[TRIPLES_AND_GRAPHPref] 
		+ "&NODE_COLOR=" + NODE_COLORList[NODE_COLORPref] 
		+ "&NODE_TEXT_COLOR=" + NODE_TEXT_COLORList[NODE_TEXT_COLORPref] 
		+ "&EDGE_COLOR=" + EDGE_COLORList[EDGE_COLORPref] 
		+ "&EDGE_TEXT_COLOR=" + EDGE_TEXT_COLORList[EDGE_TEXT_COLORPref] 
		+ "&FONT_SIZE=" + FONT_SIZEList[FONT_SIZEPref] 
		+ "&ORIENTATION=" + ORIENTATIONList[ORIENTATIONPref] 
		+ "&FORMAT=" + FORMATList[FORMATPref];
	
	if(SAVE_DOT_FILEPref)
		queryString = queryString + "&SAVE_DOT_FILE=1";

	if(NTRIPLESPref)
		queryString = queryString + "&NTRIPLES=1";

	if(EMBEDDED_RDFPref)
		queryString = queryString + "&EMBEDDED_RDF=1";

	if(SAVE_RDFPref)
		queryString = queryString + "&SAVE_RDF=1";

	if(ANON_NODES_EMPTYPref)
		queryString = queryString + "&ANON_NODES_EMPTY=1";

	checkySubmitQuery(queryString);

}






/********************************************
	[3]  - W3C Link Checker
********************************************/
serviceUrlW3CLink = "http://validator.w3.org/checklink?"; 


function checkyW3CLink(uri){

	var hide_typeList = [];
	hide_typeList[0] = "all";
	hide_typeList[1] = "dir";

	var hide_typePref = pref.getIntPref("checky.w3c.link.hide_type");

	var depthPref = pref.getCharPref("checky.w3c.link.depth");

	var summaryPref = pref.getBoolPref("checky.w3c.link.summary");
	var hide_redirectsPref = pref.getBoolPref("checky.w3c.link.hide_redirects");
	var no_accept_languagePref = pref.getBoolPref("checky.w3c.link.no_accept_language");
	var recursivePref = pref.getBoolPref("checky.w3c.link.recursive");
	var cookiePref = pref.getBoolPref("checky.w3c.link.cookie");

	var queryString = serviceUrlW3CLink 
		+ "uri=" + prepareBrowserUri(uri)
		+ "&hide_type=" + hide_typeList[hide_typePref]
		+ "&depth=" + depthPref; 
	
	if(summaryPref)
		queryString = queryString + "&summary=on";

	if(hide_redirectsPref)
		queryString = queryString + "&hide_redirects=on";

	if(no_accept_languagePref)
		queryString = queryString + "&no_accept_language=on";

	if(recursivePref)
		queryString = queryString + "&recursive=on";

	if(cookiePref)
		queryString = queryString + "&cookiePref=set";

	checkySubmitQuery(queryString);

}


/********************************************
	[4]  - W3C HTML TIDY
********************************************/
serviceUrlW3CTidy = "http://cgi.w3.org/cgi-bin/tidy?";

function checkyW3CTidy(uri){

	var indentPref = pref.getBoolPref("checky.w3c.tidy.indent");

	var queryString = serviceUrlW3CTidy 
		+ "docAddr=" + prepareBrowserUri(uri);
	
	if(indentPref)
		queryString = queryString + "&indent=1";

	checkySubmitQuery(queryString);

}


/********************************************
	[5]  - WDG HTML Validator
********************************************/
serviceUrlWDGMarkup = "http://www.htmlhelp.com/cgi-bin/validate.cgi?"; 
serviceUrlWDGMarkupUpload = "http://www.htmlhelp.com/tools/validator/upload.html"; 

function checkyWDGMarkup(uri){

	var warningsPref = pref.getBoolPref("checky.wdg.html.warnings");
	var inputPref = pref.getBoolPref("checky.wdg.html.input");
	var spiderPref = pref.getBoolPref("checky.wdg.html.spider");
	var hidevalidPref = pref.getBoolPref("checky.wdg.html.hidevalid");

	var charsetPrefUpload = pref.getIntPref("checky.wdg.html.upload.charset");

	var warningsPrefUpload = pref.getBoolPref("checky.wdg.html.upload.warnings");
	var inputPrefUpload = pref.getBoolPref("checky.wdg.html.upload.input");


	if( isFile(uri) ){
		switch( getAppearType() ){
			case 0 :
				var checkyTab = getBrowser().addTab( serviceUrlWDGMarkupUpload );
				var intervalIDnumber = setInterval( checkyWDGMarkupUploadTab, getPrefTimeout(), checkyTab, uri, warningsPrefUpload, inputPrefUpload, charsetPrefUpload);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
			case 1 :
				var checkyWindow = window.open( serviceUrlWDGMarkupUpload , "checkyWin");
				var aDocument = checkyWindow.document;
				var intervalIDnumber = setInterval(checkyWDGMarkupUploadWin, getPrefTimeout(), checkyWindow, uri, warningsPrefUpload, inputPrefUpload, charsetPrefUpload);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
		}
	}
	else{
		var queryString = serviceUrlWDGMarkup 
			+ "url=" + prepareBrowserUri(uri);
		
		if(warningsPref)
			queryString = queryString + "&warnings=yes";
	
		if(inputPref)
			queryString = queryString + "&input=yes";
	
		if(spiderPref)
			queryString = queryString + "&spider=yes";
	
		if(hidevalidPref)
			queryString = queryString + "&hidevalid=yes";
	
		checkySubmitQuery(queryString);
	}

}

function checkyWDGMarkupUploadTab(checkyTab, uri, warningsPrefUpload, inputPrefUpload, charsetPrefUpload){

	var aBrowser = gBrowser.getBrowserForTab(checkyTab);
	aBrowser.contentDocument.forms[0].file.value = uri;

	aBrowser.contentDocument.forms[0].charset.selectedIndex=charsetPrefUpload;

	if(warningsPrefUpload){
		aBrowser.contentDocument.forms[0].warnings.checked=warningsPrefUpload;
	}
	else{
		aBrowser.contentDocument.forms[0].warnings.checked = false;
	}

	if(inputPrefUpload){
		aBrowser.contentDocument.forms[0].input.checked=inputPrefUpload;
	}
	else{
		aBrowser.contentDocument.forms[0].input.checked = false;
	}
	
	aBrowser.contentDocument.forms[0].submit();

}

function checkyWDGMarkupUploadWin(checkyWindow, uri, warningsPrefUpload, inputPrefUpload, charsetPrefUpload){

	checkyWindow.document.forms[0].file.value = uri;

	if(warningsPrefUpload){
		checkyWindow.document.forms[0].warnings.checked=warningsPrefUpload;
	}
	else{
		checkyWindow.document.forms[0].warnings.checked = false;
	}

	if(inputPrefUpload){
		checkyWindow.document.forms[0].input.checked=inputPrefUpload;
	}
	else{
		checkyWindow.document.forms[0].input.checked = false;
	}
	
	checkyWindow.document.forms[0].submit();
}




/********************************************
	[6]  - WDG CSSCheck
********************************************/
serviceUrlWDGCSS = "http://www.htmlhelp.com/cgi-bin/csscheck.cgi?"; 
serviceUrlWDGCSSUpload = "http://www.htmlhelp.com/tools/csscheck/upload.html"; 

function checkyWDGCSS(uri){

	var warningsPref = pref.getBoolPref("checky.wdg.css.warnings");
	var inputPref = pref.getBoolPref("checky.wdg.css.input");

	if( isFile(uri) ){
		switch( getAppearType() ){
			case 0 :
				var checkyTab = getBrowser().addTab( serviceUrlWDGCSSUpload );
				var intervalIDnumber = setInterval( checkyWDGCSSUploadTab, getPrefTimeout(), checkyTab, uri, warningsPref, inputPref);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
			case 1 :
				var checkyWindow = window.open( serviceUrlWDGCSSUpload , "checkyWin");
				var aDocument = checkyWindow.document;
				var intervalIDnumber = setInterval(checkyWDGCSSUploadWin, getPrefTimeout(), checkyWindow, uri, warningsPref, inputPref);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
		}
	}
	else{
		var queryString = serviceUrlWDGCSS
			+ "url=" + prepareBrowserUri(uri);
		
		if(warningsPref)
			queryString = queryString + "&warnings=yes";
	
		if(inputPref)
			queryString = queryString + "&input=yes";
	
	
		checkySubmitQuery(queryString);
	}
}


function checkyWDGCSSUploadTab(checkyTab, uri, warningsPref, inputPref){

	var aBrowser = gBrowser.getBrowserForTab(checkyTab);
	aBrowser.contentDocument.forms[0].cssfile.value = uri;

	if(warningsPref){
		aBrowser.contentDocument.forms[0].warnings.checked=warningsPref;
	}
	else{
		aBrowser.contentDocument.forms[0].warnings.checked = false;
	}

	if(inputPref){
		aBrowser.contentDocument.forms[0].input.checked=inputPref;
	}
	else{
		aBrowser.contentDocument.forms[0].input.checked = false;
	}

	aBrowser.contentDocument.forms[0].submit();
}

function checkyWDGCSSUploadWin(checkyWindow, uri, warningsPref, inputPref){

	checkyWindow.document.forms[0].cssfile.value = uri;

	if(warningsPref){
		checkyWindow.document.forms[0].warnings.checked=warningsPref;
	}
	else{
		checkyWindow.document.forms[0].warnings.checked = false;
	}

	if(inputPref){
		checkyWindow.document.forms[0].input.checked=inputPref;
	}
	else{
		checkyWindow.document.forms[0].input.checked = false;
	}

	checkyWindow.document.forms[0].submit();

}


/********************************************
	[7]  - WDG Link Valet
********************************************/
serviceUrlWDGLink = "http://www.htmlhelp.com/tools/valet/linktest.cgi?"; 

function checkyWDGLink(uri){

	var typeList = [];
	typeList[0] = "Full";
	typeList[1] = "Brief";

	var datePref = pref.getCharPref("checky.wdg.link.date");
	var typePref = pref.getIntPref("checky.wdg.link.type");

	var queryString = serviceUrlWDGLink 
		+ "url=" + prepareBrowserUri(uri) 
		+ "&date=" + datePref 
		+ "&type=" + typeList[typePref];
	
	checkySubmitQuery(queryString);

}

/********************************************
	[8]  - WebThing Page Valet
********************************************/
serviceUrlWCAG = "http://valet.webthing.com/page/v3.1?"; 

function checkyWCAG(uri){

	var wcagList = [];
	wcagList[0] = "0";
	wcagList[1] = "1";
	wcagList[2] = "2";
	wcagList[3] = "3";
	wcagList[4] = "508";


	var fmtList = [];
	fmtList[0] = "HTML";
	fmtList[1] = "XML";
	fmtList[2] = "WYSIWYG";

	var xslList = [];
	xslList[0] = "wcag";
	xslList[1] = "wcag2";
	xslList[2] = "earl";

	var parseList = [];
	parseList[0] = "SGML";
	parseList[1] = "XML";
	parseList[2] = "W3C";
	parseList[3] = "HTML";

	var wcagPref = pref.getIntPref("checky.thing.page.wcag");
	var fmtPref = pref.getIntPref("checky.thing.page.fmt");
	var xslPref = pref.getIntPref("checky.thing.page.xsl");
	var parsePref = pref.getIntPref("checky.thing.page.parse");

	var realQuery = "";
	
	if(fmtPref == 2){
		realQuery = "http://valet.webthing.com//page/jim.html?";
	}
	else{
		realQuery = serviceUrlWCAG;
	}


	var queryString = realQuery 
		+ "url=" + prepareBrowserUri(uri) 
		+ "&wcag=" + wcagList[wcagPref]
		+ "&fmt=" + fmtList[fmtPref]
		+ "&xsl=" + xslList[xslPref]
		+ "&parse=" + parseList[parsePref];
	
	checkySubmitQuery(queryString);

}


/********************************************
	[9]  - Delorie Lynx Viewer
********************************************/
serviceUrlDelorieLynx = "http://www.delorie.com/web/lynxview.cgi?"; 

function checkyDelorieLynx(uri){

	var queryString = serviceUrlDelorieLynx 
		+ "url=" + prepareBrowserUri(uri);
	
	checkySubmitQuery(queryString);

}

/********************************************
	[10]  - Delorie Web Page Purifier
********************************************/
serviceUrlDeloriePurity = "http://www.delorie.com/web/purify.cgi?"; 

function checkyDeloriePurity(uri){

	var purityList = [];
	purityList[0] = "html20";
	purityList[1] = "html20t";
	purityList[2] = "html32";
	purityList[3] = "html40l";
	purityList[4] = "html40s";
	purityList[5] = "webtv11";

	var purityPref = pref.getIntPref("checky.del.pur.purity");
	var textPref = pref.getBoolPref("checky.del.pur.text");

	var queryString = serviceUrlDeloriePurity 
		+ "url=" + prepareBrowserUri(uri) 
		+ "&purity=" + purityList[purityPref];

	if(textPref)
		queryString = queryString + "&text=y";
	
	checkySubmitQuery(queryString);

}

/********************************************
	[11]  - Delorie HTTP Header Viewer
********************************************/
serviceUrlDelorieHttp = "http://www.delorie.com/web/headers.cgi?"; 

function checkyDelorieHttp(uri){

	var queryString = serviceUrlDelorieHttp 
		+ "url=" + prepareBrowserUri(uri);
	
	checkySubmitQuery(queryString);

}


/********************************************
	[12]  - Watchfire Bobby
********************************************/
serviceUrlBobby = "http://bobby.watchfire.com/bobby/bobbyServlet?";

function checkyBobby(uri){

	var glList = [];
	glList[0] = "wcag1-a";
	glList[1] = "wcag1-aa";
	glList[2] = "wcag1-aaa";
	glList[3] = "sec508";

	var stealthList = [];
	stealthList[0] = "Bobby/3.3";
	stealthList[1] = "Mozilla/6.0 [en] (WinNT; I)";
	stealthList[2] = "Mozilla/4.7 [en] (WinNT; I)";
	stealthList[3] = "Mozilla/4.02 [en] (WinNT; I)";
	stealthList[4] = "Mozilla/3.0 (Win95; I)";
	stealthList[5] = "Mozilla/2.0 (Win95; I)";
	stealthList[6] = "Mozilla/1.1N (Windows; I; 16bit)";
	stealthList[7] = "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98)";
	stealthList[8] = "Mozilla/4.0 (compatible; MSIE 4.01; Windows NT)";
	stealthList[9] = "Mozilla/2.0 (compatible; MSIE 3.0; Windows 95)";
	stealthList[10] = "Mozilla/1.22 (compatible: MSIE 2.0; Windows 95)";
	stealthList[11] = "Mozilla/4.73 (Windows 98; U) Opera 4.01 [en]";
	stealthList[12] = "Lynx/2.71f libwww-FM/2.14";
	stealthList[13] = "Lynx/2.6 libwww-FM/2.14";
	stealthList[14] = "Lynx/2.5 libwww-FM/2.14";
	stealthList[15] = "Mozilla/2.0 (compatible; AOL 3.0; Windows 95)";
	stealthList[16] = "aolbrowser/1.1 InterCon-Web-Library/1.2 (Macintosh; 68K)";
	stealthList[17] = "IWENG/1.2.003";
	stealthList[18] = "Mozilla/3.0 WebTV/2.5 (Compatible; MSIE 2.0)";
	stealthList[19] = "Mozilla/3.0 WebTV/1.2 (compatible; MSIE 2.0)";

	var glPref = pref.getIntPref("checky.bobby.gl");
	var stealthPref = pref.getIntPref("checky.bobby.stealth");

	var textPref = pref.getBoolPref("checky.bobby.text");
	var linePref = pref.getBoolPref("checky.bobby.line");
	var an_errsPref = pref.getBoolPref("checky.bobby.an_errs");

	var queryString = serviceUrlBobby 
		+ "advanced=true&url=" + prepareBrowserUri(uri) 
		+ "&gl=" + glList[glPref]
		+ "&stealth=" + stealthList[stealthPref];

	if(textPref)
		queryString = queryString + "&Text=text";
	
	if(linePref)
		queryString = queryString + "&line=line";

	if(an_errsPref)
		queryString = queryString + "&an_errs=an_errs";

	checkySubmitQuery(queryString);

}


/********************************************
	[13]  - T.a.w
********************************************/
serviceUrlTaw = "http://www.tawdis.net/servlets/taw?";

function checkyTaw(uri){

	var tipoList = [];
	tipoList[0] = "1";
	tipoList[1] = "2";
	tipoList[2] = "3";


	var tipoPref = pref.getIntPref("checky.taw.tipo");
	var iPref = pref.getBoolPref("checky.taw.i");


	var queryString = serviceUrlTaw 
		+ "url=" + prepareBrowserUri(uri) 
		+ "&tipo=" + tipoList[tipoPref];

	if(iPref)
		queryString = queryString + "&i=1";
	

	checkySubmitQuery(queryString);

}



/********************************************
	[14]  - PIAT WAVE 2.01
********************************************/
serviceUrlWave2 = "http://pa-at-loan.org/cgi-bin/wave/wave.pl?";

function checkyWave2(uri){

	var usestylePref = pref.getBoolPref("checky.piat2.usestyle");
	var is_noframesPref = pref.getBoolPref("checky.piat2.is_noframes");


	var queryString = serviceUrlWave2 
		+ "uri=" + prepareBrowserUri(uri);

	if(usestylePref)
		queryString = queryString + "&usestyle=yes";
	
	if(is_noframesPref)
		queryString = queryString + "&is_noframes=yes";

	checkySubmitQuery(queryString);

}


/********************************************
	[15]  - PIAT PIAT WAVE 2.2
********************************************/
serviceUrlWave22 = "http://pa-at-loan.org/cgi-bin/ywave/wave.pl?";

function checkyWave22(uri){

	var usestylePref = pref.getBoolPref("checky.piat22.usestyle");
	var is_noframesPref = pref.getBoolPref("checky.piat22.is_noframes");


	var queryString = serviceUrlWave22 
		+ "uri=" + prepareBrowserUri(uri);

	if(usestylePref)
		queryString = queryString + "&usestyle=yes";
	
	if(is_noframesPref)
		queryString = queryString + "&is_noframes=yes";

	checkySubmitQuery(queryString);

}

/********************************************
	[16]  - Redland RSS 1.0 Validator and Viewer
********************************************/
serviceUrlRed = "http://www.redland.opensource.ac.uk/rss?";

function checkyRed(uri){

	var boxList = [];
	boxList[0] = "yes";
	boxList[1] = "no";

	var boxPref = pref.getIntPref("checky.red.box");

	var queryString = serviceUrlRed 
		+ "uri=" + prepareBrowserUri(uri)
		+ "&box=" + boxList[boxPref];

	checkySubmitQuery(queryString);

}

/********************************************
	[17]  - Mark und Sam RSS Validator
********************************************/
serviceUrlMark = "http://feeds.archive.org/validator/check?";

function checkyMark7(uri){

	var queryString = serviceUrlMark
		+ "url=" + prepareBrowserUri(uri);
	
	checkySubmitQuery(queryString);

}


/********************************************
	[18]  - W3C P3P Validator (Integrated Validation)
********************************************/

serviceUrlW3CP3PIntegrated = "http://validator.w3.org/p3p/20020128/p3p.pl?";

function checkyW3CP3PIntegrated(uri){

	var queryString = serviceUrlW3CP3PIntegrated 
		+ "uri=" + prepareBrowserUri(uri);
	
	checkySubmitQuery(queryString);

}

/********************************************
	[19]  - W3C P3P Validator (Policy File Validation)
********************************************/

serviceUrlW3CP3PPolicy = "http://validator.w3.org/p3p/20020128/policy.pl?";
serviceUrlW3CP3PPolicyUpload = "http://www.w3.org/P3P/validator.html";

function checkyW3CP3PPolicy(uri){

	if( isFile(uri) ){
		switch( getAppearType() ){
			case 0 :
				var checkyTab = getBrowser().addTab( serviceUrlW3CP3PPolicyUpload );
				var intervalIDnumber = setInterval( checkyW3CP3PPolicyUploadTab, getPrefTimeout(), checkyTab, uri);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
			case 1 :
				var checkyWindow = window.open( serviceUrlW3CP3PPolicyUpload , "checkyWin");
				var aDocument = checkyWindow.document;
				var intervalIDnumber = setInterval(checkyW3CP3PPolicyUploadWin, getPrefTimeout(), checkyWindow, uri);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
		}
	}
	else{
		var queryString = serviceUrlW3CP3PPolicy 
			+ "uri=" + prepareBrowserUri(uri);
		
		checkySubmitQuery(queryString);
	}

}

function checkyW3CP3PPolicyUploadTab(checkyTab, uri){
	var aBrowser = gBrowser.getBrowserForTab(checkyTab);
	aBrowser.contentDocument.forms[2].file.value=uri;
	aBrowser.contentDocument.forms[2].submit();
}

function checkyW3CP3PPolicyUploadWin(checkyWindow, uri){
	checkyWindow.document.forms[2].file.value=uri;
	checkyWindow.document.forms[2].submit();
}


/********************************************
	[20]  - PIAT WAVE 3
********************************************/

serviceUrlWave3 = "http://www.wave.webaim.org/wave/Output.jsp?";
serviceUrlWave3Upload = "http://wave.webaim.org/index.jsp";

function checkyUrlWave3(uri){

	if( isFile(uri) ){
		switch( getAppearType() ){
			case 0 :
				var checkyTab = getBrowser().addTab( serviceUrlWave3Upload );
				var intervalIDnumber = setInterval( checkyWave3UploadTab, getPrefTimeout(), checkyTab, uri);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
			case 1 :
				var checkyWindow = window.open( serviceUrlWave3Upload , "checkyWin");
				var aDocument = checkyWindow.document;
				var intervalIDnumber = setInterval(checkyWave3UploadWin, getPrefTimeout(), checkyWindow, uri);
				setInterval(stopInterval, getPrefTimeout(), intervalIDnumber);
				break;
		}
	}
	else{
		var queryString = serviceUrlWave3 
			+ "InputUrlText=" + prepareBrowserUri(uri);
		
		checkySubmitQuery(queryString);
	}

}

function checkyWave3UploadTab(checkyTab, uri){
	var aBrowser = gBrowser.getBrowserForTab(checkyTab);
	aBrowser.contentDocument.forms[2].upload.value=uri;
	aBrowser.contentDocument.forms[2].submit();
}

function checkyWave3UploadWin(checkyWindow, uri){
	checkyWindow.document.forms[2].upload.value=uri;
	checkyWindow.document.forms[2].submit();
}

/********************************************
	[21]  - Wickline Colorblind Web Page Filter
********************************************/
serviceUrlWickline = "http://colorfilter.wickline.org/index.cgi?";

function checkyWickline(uri){
	var tList = [];
	tList[0] = "p";
	tList[1] = "d";
	tList[2] = "t";
	tList[3] = "m";
	tList[4] = "a";
	tList[5] = "o";
	tList[6] = "c";
	tList[7] = "u";
	tList[8] = "k";
	tList[9] = "q";
	tList[10] = "g";

	var tPref = pref.getIntPref("checky.wickline.t");
	var iPref = pref.getBoolPref("checky.wickline.i");
	var nPref = pref.getBoolPref("checky.wickline.n");
	var jPref = pref.getBoolPref("checky.wickline.j");
	var cPref = pref.getBoolPref("checky.wickline.c");
	var bPref = pref.getBoolPref("checky.wickline.b");

	var queryString = serviceUrlWickline 
		+ "u=" + prepareBrowserUri(uri)
		+ "&t=" + tList[tPref]
		+ "&s=1"
		+ "&r=";

	if(iPref)
		queryString = queryString + "&i=1";

	if(nPref)
		queryString = queryString + "&n=1";

	if(jPref)
		queryString = queryString + "&j=1";

	if(cPref)
		queryString = queryString + "&c=1";

	if(bPref)
		queryString = queryString + "&b=1";

	checkySubmitQuery(queryString);

}


/********************************************
	[22]  - Cynthia Says Portal
********************************************/
serviceUrlCynthia = "http://www.contentquality.com/mynewtester/cynthia.exe?";

function checkyCynthia(uri){

	var rptmodeList = [];
	rptmodeList[0] = "-1";
	rptmodeList[1] = "0";
	rptmodeList[2] = "1";
	rptmodeList[3] = "2";

	var BROWSE_EMULList = [];
	BROWSE_EMULList[0] = "Cynthia 1.0";
	BROWSE_EMULList[1] = "MS Internet Explorer 6.0";
	BROWSE_EMULList[2] = "MS Internet Explorer 5.5";
	BROWSE_EMULList[3] = "MS Internet Explorer 5.01";
	BROWSE_EMULList[4] = "MS Internet Explorer 5.0";
	BROWSE_EMULList[5] = "MS Internet Explorer 4.4";
	BROWSE_EMULList[6] = "MS Internet Explorer 4.01";
	BROWSE_EMULList[7] = "MS Internet Explorer 4.0";
	BROWSE_EMULList[8] = "MS Internet Explorer 4.0 Compatibility Mode";
	BROWSE_EMULList[9] = "MS Internet Explorer 4.0 Solaris";
	BROWSE_EMULList[10] = "Netscape 6.0";
	BROWSE_EMULList[11] = "Netscape 6.1";
	BROWSE_EMULList[12] = "Netscape 4.5";
	BROWSE_EMULList[13] = "Netscape 4.5 Mac PPC";
	BROWSE_EMULList[14] = "Netscape 4.0";
	BROWSE_EMULList[15] = "Netscape 4.0 OS/2";
	BROWSE_EMULList[16] = "Netscape 4.0 Win 3.x";
	BROWSE_EMULList[17] = "Netscape 4.0 Linux";
	BROWSE_EMULList[18] = "Netscape 3.0";
	BROWSE_EMULList[19] = "Netscape 3.0 SunOS";
	BROWSE_EMULList[20] = "Netscape 3.0 OS/2";
	BROWSE_EMULList[21] = "Netscape 2.0";
	BROWSE_EMULList[22] = "Opera 3.0";
	BROWSE_EMULList[23] = "Opera 3.1";
	BROWSE_EMULList[24] = "Opera 3.2";
	BROWSE_EMULList[25] = "Opera 3.21";
	BROWSE_EMULList[26] = "Opera 3.5";
	BROWSE_EMULList[27] = "Opera 3.6";
	BROWSE_EMULList[28] = "Lynx";
	BROWSE_EMULList[29] = "WebTV";


	var rptmodePref = pref.getIntPref("checky.cynthia.rptmode");
	var BROWSE_EMULPref = pref.getIntPref("checky.cynthia.BROWSE_EMUL");

	var warnp2n3ePref = pref.getBoolPref("checky.cynthia.warnp2n3e");
	var runcrPref = pref.getBoolPref("checky.cynthia.runcr");
	var incsrcPref = pref.getBoolPref("checky.cynthia.incsrc");
	var runpmcPref = pref.getBoolPref("checky.cynthia.runpmc");
	var runagcPref = pref.getBoolPref("checky.cynthia.runagc");

	var queryString = serviceUrlCynthia 
		+ "url1=" + prepareBrowserUri(uri)
		+ "&rptmode=" + rptmodeList[rptmodePref]
		+ "&BROWSE_EMUL=" + BROWSE_EMULList[BROWSE_EMULPref];

	if(warnp2n3ePref)
		queryString = queryString + "&warnp2n3ePref=1";

	if(runcrPref)
		queryString = queryString + "&runcrPref=1";

	if(incsrcPref)
		queryString = queryString + "&incsrcPref=1";

	if(runpmcPref)
		queryString = queryString + "&runpmcPref=1";

	if(runagcPref)
		queryString = queryString + "&runagcPref=1";

	checkySubmitQuery(queryString);

}


/********************************************
	[23]  - Vischeck
********************************************/
serviceUrlVischeck = "http://vischeck.homeip.net/vischeck/imageEngine.php?";

function checkyVischeck(uri){

	var sensorTypeList = [];
	sensorTypeList[0] = "deuteranope";
	sensorTypeList[1] = "protanope";
	sensorTypeList[2] = "tritanope";

	var sensorTypePref = pref.getIntPref("checky.vischeck.sensorType");

	var queryString = serviceUrlVischeck 
		+ "url=" + prepareBrowserUri(uri) 
		+ "&returnUrl=http://www.vischeck.com/vischeck/vischeckURL.php"
		+ "&sensorType=" + sensorTypeList[sensorTypePref];

	checkySubmitQuery(queryString);

}

/********************************************
	[23]  - WSO
********************************************/
serviceUrlWSO = "http://www.websiteoptimization.com/cgi-bin/wso/wso.pl?";

function checkyWSO(uri){
	var queryString = serviceUrlWSO 
		+ "url=" + prepareBrowserUri(uri);

	checkySubmitQuery(queryString);
}



function checkySubmitQuery(uri){

	var appearType =  pref.getIntPref("checky.global.appearType");

	switch(appearType){
		case 0 :
			getBrowser().addTab(uri);
			break;
		
		case 1 :
			var checkyWindow;
			checkyWindow = window.open(uri, "checkyWin");
			break;
	}
}


function getPrefTimeout(){
	return pref.getIntPref("checky.global.timeout");
}

function getAppearType(){
	return pref.getIntPref("checky.global.appearType");
}


function prepareBrowserUri(browserUri){
	var tempUri = new String(browserUri);
	var searchIndex = tempUri.indexOf("?");
	var substrUrl;
	var substrQuery;
	var substrQueryEscaped;
	if(searchIndex != -1){
		substrUrl = tempUri.substr(0,(searchIndex+1) );
		substrQuery = tempUri.substr((searchIndex+1), tempUri.length );
		substrQueryEscaped = escape(substrQuery);
		return substrUrl + substrQueryEscaped;
	}
	else{
		return tempUri;
	}

}


function isFile(uri){
	//alert(uri);
	var tempUri = uri;
	var tempRegexp = new RegExp("^file:", "i");
	//alert(tempRegexp + " : " + tempUri);
	if ((tempRegexp.test(tempUri)) == true) {
		//tempUri = "" + tempUri + "";
		//tempRegexp = "" + tempRegexp + "";
		//tempUricnt = tempUri.split("://");
		//tempUri = tempUricnt[1];
		//alert(tempUri);
		return true;
	}
	return false;
}

function stopInterval(intervalIDnumber){
	clearInterval(intervalIDnumber);
}



function checkyServiceDo(browserUri, serviceId){

	switch(serviceId){
		case 0 :
			checkyW3CMarkup(browserUri)
			break;
		case 1 :
			checkyQueryW3CCSS(browserUri)
			break;
		case 2 :
			checkyW3CRdf(browserUri)
			break;
		case 3 :
			checkyW3CLink(browserUri)
			break;
		case 4 :
			checkyW3CTidy(browserUri)
			break;
		case 5 :
			checkyWDGMarkup(browserUri)
			break;
		case 6 :
			checkyWDGCSS(browserUri)
			break;
		case 7 :
			checkyWDGLink(browserUri)
			break;
		case 8 :
			checkyWCAG(browserUri)
			break;
		case 9 :
			checkyDelorieLynx(browserUri)
			break;
		case 10 :
			checkyDeloriePurity(browserUri)
			break;
		case 11 :
			checkyDelorieHttp(browserUri)
			break;
		case 12 :
			checkyBobby(browserUri)
			break;
		case 13 :
			checkyTaw(browserUri)
			break;
		case 14 :
			checkyWave2(browserUri)
			break;
		case 15 :
			checkyWave22(browserUri)
			break;
		case 16 :
			checkyRed(browserUri)
			break;
		case 17 :
			checkyMark7(browserUri)
			break;
		case 18 :
			checkyW3CP3PIntegrated(browserUri)
			break;
		case 19 :
			checkyW3CP3PPolicy(browserUri)
			break;
		case 20 :
			checkyUrlWave3(browserUri)
			break;
		case 21 :
			checkyWickline(browserUri)
			break;
		case 22 :
			checkyCynthia(browserUri)
			break;
		case 23 :
			checkyVischeck(browserUri)
			break;
		case 24 :
			checkyWSO(browserUri)
			break;
		case 99 :
			checkyAgent(browserUri)
			break;
	}
}

function checkyAgent(browserUri){

	var isSet = false;
	
	var Pref0 = pref.getBoolPref("checky.agent.w3c.markup");
	var Pref1 = pref.getBoolPref("checky.agent.w3c.css");
	var Pref2 = pref.getBoolPref("checky.agent.w3c.rdf");
	var Pref3 = pref.getBoolPref("checky.agent.w3c.link");
	var Pref4 = pref.getBoolPref("checky.agent.w3c.tidy");
	var Pref5 = pref.getBoolPref("checky.agent.wdg.html");
	var Pref6 = pref.getBoolPref("checky.agent.wdg.css");
	var Pref7 = pref.getBoolPref("checky.agent.wdg.link");
	var Pref8 = pref.getBoolPref("checky.agent.thing.page");
	var Pref9 = pref.getBoolPref("checky.agent.del.lynx");
	var Pref10 = pref.getBoolPref("checky.agent.del.pur");
	var Pref11 = pref.getBoolPref("checky.agent.del.header");
	var Pref12 = pref.getBoolPref("checky.agent.bobby");
	var Pref13 = pref.getBoolPref("checky.agent.taw");
	var Pref14 = pref.getBoolPref("checky.agent.piat2");
	var Pref15 = pref.getBoolPref("checky.agent.piat22");
	var Pref16 = pref.getBoolPref("checky.agent.red");
	var Pref17 = pref.getBoolPref("checky.agent.mark");
	var Pref18 = pref.getBoolPref("checky.agent.w3c.p3pi");
	var Pref19 = pref.getBoolPref("checky.agent.w3c.p3pp");
	var Pref20 = pref.getBoolPref("checky.agent.piat3");
	var Pref21 = pref.getBoolPref("checky.agent.wickline");
	var Pref22 = pref.getBoolPref("checky.agent.vischeck");
	var Pref23 = pref.getBoolPref("checky.agent.cynthia");
	var Pref24 = pref.getBoolPref("checky.agent.wso");

	if(Pref0){
		checkyW3CMarkup(browserUri);
		isSet = true;
	}
	if(Pref1){
		checkyQueryW3CCSS(browserUri);
		isSet = true;
	}
	if(Pref2){
		checkyW3CRdf(browserUri);
		isSet = true;
	}
	if(Pref3){
		checkyW3CLink(browserUri);
		isSet = true;
	}
	if(Pref4){
		checkyW3CTidy(browserUri);
		isSet = true;
	}
	if(Pref5){
		checkyWDGMarkup(browserUri);
		isSet = true;
	}
	if(Pref6){
		checkyWDGCSS(browserUri);
		isSet = true;
	}
	if(Pref7){
		checkyWDGLink(browserUri);
		isSet = true;
	}
	if(Pref8){
		checkyWCAG(browserUri);
		isSet = true;
	}
	if(Pref9){
		checkyDelorieLynx(browserUri);
		isSet = true;
	}
	if(Pref10){
		checkyDeloriePurity(browserUri);
		isSet = true;
	}
	if(Pref11){
		checkyDelorieHttp(browserUri);
		isSet = true;
	}
	if(Pref12){
		checkyBobby(browserUri);
		isSet = true;
	}
	if(Pref13){
		checkyTaw(browserUri);
		isSet = true;
	}
	if(Pref14){
		checkyWave2(browserUri);
		isSet = true;
	}
	if(Pref15){
		checkyWave22(browserUri);
		isSet = true;
	}
	if(Pref16){
		checkyRed(browserUri);
		isSet = true;
	}
	if(Pref17){
		checkyMark7(browserUri);
		isSet = true;
	}
	if(Pref18){
		checkyW3CP3PIntegrated(browserUri);
		isSet = true;
	}
	if(Pref19){
		checkyW3CP3PPolicy(browserUri);
		isSet = true;
	}
	if(Pref20){
		checkyUrlWave3(browserUri);
		isSet = true;
	}
	if(Pref21){
		checkyWickline(browserUri);
		isSet = true;
	}

	if(Pref22){
		checkyCynthia(browserUri);
		isSet = true;
	}

	if(Pref23){
		checkyVischeck(browserUri);
		isSet = true;
	}

	if(Pref24){
		checkyWSO(browserUri);
		isSet = true;
	}


	if(!isSet){
		var checkyBundle = document.getElementById("bundle_checky");
		alert(checkyBundle.getString("agentMsg"));
	}

}



