/*$Id: fkRuleReference.cpp,v 1.5 2006/10/06 08:01:15 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "nsMemory.h"
#include "nsCRT.h"
#include "fkRuleReference.h"
#include "Error.h"


NS_IMPL_ISUPPORTS1(fkRuleReference, fkIRuleReference)

fkRuleReference::fkRuleReference(const reference *ref)
{
	TRACE("constructor %08x", this);
	this->ref = ref;
}

fkRuleReference::~fkRuleReference()
{
	TRACE("destructor %08x", this);
}

/* attribute string system; */
NS_IMETHODIMP fkRuleReference::GetSystem(char **aSystem)
{
	if (!aSystem)
		return NS_ERROR_NULL_POINTER;
	*aSystem = nsnull;

	if(ref->system){
		*aSystem = nsCRT::strdup(ref->system);	
		if (!*aSystem)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}


/* attribute string refId; */
NS_IMETHODIMP fkRuleReference::GetRefId(char **aRefId)
{
	if (!aRefId)
		return NS_ERROR_NULL_POINTER;
	*aRefId = nsnull;

	if(ref->refId){
		*aRefId = nsCRT::strdup(ref->refId);	
		if (!*aRefId)
			return NS_ERROR_OUT_OF_MEMORY;
	}
	return NS_OK;
}

