/*$Id: fkHttpHandler.h,v 1.13 2006/11/04 21:09:25 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FKHTTPHANDLER_H
#define FKHTTPHANDLER_H

#include "nsIModule.h"
#include "nsIFactory.h"
#include "nsISupports.h"
#include "nsISupportsUtils.h"

#include "nsIObserver.h"
#include "nsIHttpProtocolHandler.h"
#include "nsIProtocolProxyService.h"

#include "nsIComponentManager.h"
#include "nsIComponentRegistrar.h"

#include "nsIGenericFactory.h"
 
#include "nsWeakReference.h"

#define FK_HTTPHANDLER_CID \
  {0x03183b3c, 0x1d91, 0x4a35,\
    { 0x9a, 0x75, 0x1e, 0x4f, 0x87, 0x44, 0x71, 0x5e}}

#define FK_HTTPSHANDLER_CID \
  {0xe3e26915, 0x4963, 0x42ef,\
    { 0xb0, 0x70, 0x47, 0xe0, 0x8b, 0x55, 0x31, 0x42}}

#define HTTPHANDLER_CONTRACTID  "@mozilla.org/network/protocol;1?name=http"
#define HTTPSHANDLER_CONTRACTID "@mozilla.org/network/protocol;1?name=https"

/*
  Firekeeper replaces Mozilla's HTTP and HTTPS handlers with new ones, that
  are auditing traffic and passing it to oryginal handlers.
 */

class fkHttpHandler : public nsIHttpProtocolHandler,
                      public nsIObserver,
                      public nsSupportsWeakReference
{
public:
	NS_DECL_ISUPPORTS
	//NS_DECL_NSISUPPORTSWEAKREFERENCE
	NS_DECL_NSIPROTOCOLHANDLER
	NS_DECL_NSIPROXIEDPROTOCOLHANDLER
	NS_DECL_NSIHTTPPROTOCOLHANDLER
	NS_DECL_NSIOBSERVER
	 
	fkHttpHandler();
	virtual ~fkHttpHandler();
	NS_IMETHODIMP init(nsIHttpProtocolHandler *origHttpHandler);
	
	void enableTracing(PRBool tracingEnabled);
	PRBool isTracingEnabled();
	
 private:
	/*Oryginal handlers that are still responsible for processing 
	  traffic, but after Firekeeper checks that it is not dangerous*/
	nsCOMPtr<nsIProtocolHandler> origHandler;
	nsCOMPtr<nsIHttpProtocolHandler> origHttpHandler;
	nsCOMPtr<nsIProxiedProtocolHandler> origProxiedHandler;
	nsCOMPtr<nsIObserver> origObserver;

	/*When set to false Firekeeper is disabled. (Dissabling Firekeeper
	  does not currently causes unregistration of its HTTP(S) handlers
	  but just disables traffic checks)
	*/
	PRBool tracingEnabled;

	/* These are not supported
	   and are not implemented*/
	fkHttpHandler(const fkHttpHandler& x);
	fkHttpHandler& operator=(const fkHttpHandler& x);

};

#endif
