/*$Id: fkByteArrayInputStream.cpp,v 1.4 2008/05/18 10:29:00 jwrobel Exp $*/

/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  The Original Code is Mozilla Communicator client code, released
 *  March 31, 1998.
 *
 *  The Initial Developer of the Original Code is
 *  Netscape Communications Corporation.
 *  Portions created by the Initial Developer are Copyright (C) 1998-1999
 *  the Initial Developer. All Rights Reserved.
 *
 *  Copyright (C) 2008 Wrobel <wrobel@blues.ath.cx> (Firekeeper version).
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */


/*
 * This file was taken directly from Mozilla's nsByteArrayInpurtStream.
 * Firefox from version 3.0 is not shipped with lib_xpcom_core
 * which includes this class. To support FF 3.0 Firekeeper
 * has to include its own implementation of ByteArrayInpurtStream.
 */


#include "fkByteArrayInputStream.h"
#include "nsMemory.h"

#include "Error.h"

NS_IMPL_THREADSAFE_ISUPPORTS1(fkByteArrayInputStream, nsIInputStream)

fkByteArrayInputStream::fkByteArrayInputStream(char *buffer, PRUint32 bytes)
    : _buffer(buffer), _nbytes(bytes), _pos(0)
{ 
  TRACE("constructor %08x", this);
}

fkByteArrayInputStream::~fkByteArrayInputStream()
{
  TRACE("destructor %08x", this);
  if(_buffer != NULL)
    nsMemory::Free(_buffer);
}

NS_IMETHODIMP
fkByteArrayInputStream::Available(PRUint32 *aResult)
{
  if(aResult == NULL)
    return NS_ERROR_NULL_POINTER;

  if(_nbytes == 0 || _buffer == NULL)
    *aResult = 0;
  else
    *aResult = _nbytes - _pos;

  return NS_OK;
}

NS_IMETHODIMP
fkByteArrayInputStream::Read(char *aBuffer, PRUint32 aCount, PRUint32 *aNumRead)
{
  if(aBuffer == NULL || aNumRead == NULL)
    return NS_ERROR_NULL_POINTER;

  if(_nbytes == 0)
    return NS_ERROR_FAILURE;

  if(aCount == 0 || _pos == _nbytes)
    *aNumRead = 0;
  else{
    FK_ASSERT(_buffer != NULL);//Stream buffer has been released - there's an ownership problem somewhere!
    if(_buffer == NULL)
      *aNumRead = 0;
    else
      if(aCount > _nbytes - _pos){
	memcpy(aBuffer, &_buffer[_pos], *aNumRead = _nbytes - _pos);
	_pos = _nbytes;
      }
      else{
	memcpy(aBuffer, &_buffer[_pos], *aNumRead = aCount);
	_pos += aCount;
      }
  }
  return NS_OK;
}

NS_IMETHODIMP 
fkByteArrayInputStream::ReadSegments(nsWriteSegmentFun writer, void *aClosure, PRUint32 aCount, PRUint32 *aNumRead)
{
  if(aNumRead == NULL)
    return NS_ERROR_NULL_POINTER;

  if(_nbytes == 0)
    return NS_ERROR_FAILURE;

  if(aCount == 0 || _pos == _nbytes)
    *aNumRead = 0;
  else{
    FK_ASSERT(_buffer != NULL); //Stream buffer has been released - there's an ownership problem somewhere!
    PRUint32 readCount = PR_MIN(aCount,(_nbytes - _pos));
    if(_buffer == NULL)
      *aNumRead = 0;
    else{
      nsresult rv = writer(this, aClosure, &_buffer[_pos], 
			   _pos, readCount, aNumRead);
      if(NS_SUCCEEDED(rv))
	_pos += *aNumRead;
    }
  }

  // do not propogate errors returned from writer!
  return NS_OK;
}

NS_IMETHODIMP 
fkByteArrayInputStream::IsNonBlocking(PRBool *aNonBlocking)
{
  *aNonBlocking = PR_TRUE;
  return NS_OK;
}

NS_IMETHODIMP
fkByteArrayInputStream::Close()
{
  if(_buffer != NULL){
    nsMemory::Free(_buffer);
    _buffer = NULL;
    _nbytes = 0;
  }
  else
    return NS_ERROR_FAILURE;
  
  return NS_OK;
}

NS_IMETHODIMP
FK_NewByteArrayInputStream(nsIInputStream **aResult, char *buffer, unsigned long bytes)
{
  if(aResult == NULL)
    return NS_ERROR_NULL_POINTER;

  nsIInputStream *stream = new fkByteArrayInputStream(buffer, bytes);

  if(!stream)
    return NS_ERROR_OUT_OF_MEMORY;

  NS_ADDREF(stream);
  *aResult = stream;
  return NS_OK;
}
