#!/usr/bin/python
"""
 * ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** 
"""

defaultUrl = "www.evil.null"
defaultHeader = """HTTP/1.1 200 OK
Server: Apache/2.0.54 (Unix) mod_python/3.1.4 Python/2.4 PHP/5.0.2
X-Powered-By: PHP/5.0.2
Content-Type: text/html"""


tests = [];
#test: (output file, rule fid, http response url, header, body)

tests.append(("test_sysmspam", 2485, defaultUrl, defaultHeader,
              "clsid: This is Nortan antivirus sysmspam.dll load attempt test 0534CF61-83C5-4765-B19B-45F7A4E135D0 some stuff ..."))


tests.append(("test_nimda", 1290, defaultUrl, defaultHeader,
"""From CERT Advisory:
'The Nimda worm has the potential to affect both user workstations (clients) running Windows 95, 98, ME, NT, or 2000 and servers running Windows NT and 2000.
[...]
 Once running on the server machine, the worm traverses each directory in the system (including all those accessible through file shares) and writes a MIME-encoded copy of itself to disk using file names with .eml or .nws extensions (e.g., readme.eml). 
 [...]'

Snort recognizes this worm by this string: window.open(\"ReADme.EMl\") string"""))

tests.append(("test_domain", 1840, defaultUrl, defaultHeader,
"""From Bugtraq:
'The current specification of the Javascript Same Origin Policy is flawed such that it creates a vulnerability under some circumstances.
Only hostnames are used when evaluating whether access to content by script code should be permitted -- the IP address is not taken into consideration. If the IP address associated with a hostname were to change in DNS records, content served from a second host may be accessed by script code served from the first. This could theoretically be exploited to access content served from behind a firewall (or on an internal network).'
Snort recognizes this bug by this string: document.domain(

junk: alksdjfa;lksjfd;laksjfl;askjflkajdfl;akjdsf.amdsfpoweafkz.cmv"""))

tests.append(("test_jsurlspoof", 1841, defaultUrl, defaultHeader,
"""From Bugtraq:
'It has been reported possible to create a javascript: URL which appears to start with a valid domain. Malicious script code may specify an arbitrary domain, and will be able to access cookie data associated with that domain.
Exploitation of this vulnerability may result in a remote attacker gaining access to sensitive cookie data, including authentication credentials.'
Snort recognizes this bug by this string: javascript://something.something

junk=alksdjfa;lksjfd;laksjfl;askjflkajdfl;akjdsf.amdsfpoweafkz.cmv"""))

tests.append(("test_realplayer", 2437, defaultUrl,
"""HTTP/1.1 200 OK
Server: Apache/2.0.54 (Unix) mod_python/3.1.4 Python/2.4 PHP/5.0.2
X-Powered-By: PHP/5.0.2
Content-Type: application/smi""",              
"""From Bugtraq:
'A vulnerability has been reported in RealOne Player. Script embedded in SMIL presentations may be executed in the context of a domain that is specified by an attacker. In particular, if a URI is opened from within a SMIL file, embedded script code may access the properties of the URI's domain.
[...]
'

Snort recognizes this bug by this string string (ignore case): <area
HREF='file:javaScript:


junk=aadsfasdflksdjfa;lksjfd;laksjfl;askjflkajdfl;akjdsf.amdsfpoweafkz.cmv"""))

tests.append(("test_realplayer_file.ram", 2438, "http://jimi.mus/playlist.ram", defaultHeader,
"""file://It_has_been_reported_that_various_RealPlayer/RealOne_Player_releases_are_prone_to_multiple_exploitable_stack_and_heap_overrun_vulnerabilities._This_is_due_to_insufficient_bounds_checking_when_handling_malformed_files_of_various_supported_file_types._Exploitation_would_permit_execution_of_arbitrary_code_in_the_context_of_the_user_invoking_the_vulnerable_player....ONE_MORE_TIME....It_has_been_reported_that_various_RealPlayer/RealOne_Player_releases_are_prone_to_multiple_exploitable_stack_and_heap_overrun_vulnerabilities._This_is_due_to_insufficient_bounds_checking_when_handling_malformed_files_of_various_supported_file_types._Exploitation_would_permit_execution_of_arbitrary_code_in_the_context_of_the_user_invoking_the_vulnerable_player"""))

tests.append(("test_realplayer_http.smi", 2439, "http://jimi.mus/playlist.smi", "",
"""http://It_has_been_reported_that_various_RealPlayer/RealOne_Player_releases_are_prone_to_multiple_exploitable_stack_and_heap_overrun_vulnerabilities._This_is_due_to_insufficient_bounds_checking_when_handling_malformed_files_of_various_supported_file_types._Exploitation_would_permit_execution_of_arbitrary_code_in_the_context_of_the_user_invoking_the_vulnerable_player....ONE_MORE_TIME....It_has_been_reported_that_various_RealPlayer/RealOne_Player_releases_are_prone_to_multiple_exploitable_stack_and_heap_overrun_vulnerabilities._This_is_due_to_insufficient_bounds_checking_when_handling_malformed_files_of_various_supported_file_types._Exploitation_would_permit_execution_of_arbitrary_code_in_the_context_of_the_user_invoking_the_vulnerable_player"""))

tests.append(("test_realplayer_rtsp.rp", 2440, "http://jimi.mus/playlist.rp", "",
"""rtsp://It_has_been_reported_that_various_RealPlayer/RealOne_Player_releases_are_prone_to_multiple_exploitable_stack_and_heap_overrun_vulnerabilities._This_is_due_to_insufficient_bounds_checking_when_handling_malformed_files_of_various_supported_file_types._Exploitation_would_permit_execution_of_arbitrary_code_in_the_context_of_the_user_invoking_the_vulnerable_player....ONE_MORE_TIME....It_has_been_reported_that_various_RealPlayer/RealOne_Player_releases_are_prone_to_multiple_exploitable_stack_and_heap_overrun_vulnerabilities._This_is_due_to_insufficient_bounds_checking_when_handling_malformed_files_of_various_supported_file_types._Exploitation_would_permit_execution_of_arbitrary_code_in_the_context_of_the_user_invoking_the_vulnerable_player"""))

tests.append(("test_local_redirection", 2577, defaultUrl,
"""HTTP/1.1 302 Object moved
Location: URL:ms-its:C:\WINDOWS\Help\iexplore.chm::/iegetsrt.htm"""
              ,
"""From CERT:
'Microsoft Internet Explorer (IE) does not adequately validate the security context of a frame that has been redirected by a web server. An attacker could exploit this vulnerability to evaluate script in different security domains. By causing script to be evaluated in the Local Machine Zone, the attacker could execute arbitrary code with the privileges of the user running IE.'"""))

tests.append(("test_clsid", 2589, defaultUrl,
"""HTTP/1.1 200 OK
Server: Apache
X-Powered-By: PHP/4.4.1
Content-Disposition: attachment; filename=malware.{3050f4d8-98B5-11CF-BB82-00AA00BDCE0B}fun_ball_gites_pie_throw%2Empeg
Content-Type: text/html"""
,
"""From Bugtraq:
'A vulnerability has been reported in the Windows Shell that may allow files to be misrepresented to client users. The reported vulnerability involves specifying the CLSID for HTML applications in the name of a malicious file, followed by another file name and extension.[...]'"""))

jpeg = open("crash.jpg", "r").read()

tests.append(("test_gdijpeg", 2705, defaultUrl,
"""HTTP/1.1 200 OK
Server: Apache
X-Powered-By: PHP/4.4.1
Content-Type: image/jpeg"""
,jpeg))

tests.append(("test_sysmspam", 2485, defaultUrl, defaultHeader,
              "clsid: This is Nortan antivirus sysmspam.dll load attempt 0534CF61-83C5-4765-B19B-45F7A4E135D0 some stuff ..."))


tests.append(("test_winampcdda", 3088, defaultUrl, defaultHeader,
"""From Bugtraq:
'A remote buffer overflow vulnerability affects the IN_CDDA.dll library of Nullsoft's Winamp. This issue is due to a failure of the application to properly validate the length of user-supplied strings prior to copying them into finite process buffers. The issue would most likely be exposed through a malicious playlist designed to trigger the issue.[...]'
triggering string: \some_looooooooooooooooooooooooooong_stuuuuf.cda"""))


tests.append(("test_object_type", 3149, defaultUrl, defaultHeader,
"""From CERT:
'A remotely exploitable buffer overflow vulnerability has been discovered in Internet Explorer versions 5.1, 5.5 and 6.0. The <object> tag contains a \"type\" field used to determine how Internet Explorer should treat an object. It is possible to bypass the buffer checks on the input to the \"type\" field by using a specific character and cause a buffer overflow.'
trigger:
<object type="[a;sdfk;laskf;aksjflkasjfdlkasfjd////////////////////////////////////////////////////////]asdfasfopiwekrlds0osdaflkv">
hmmmmmmmmmmmmmmmmmmmmmmmm</object>"""
))

tests.append(("test_media_player_content", 3192, defaultUrl,
"""Content-Disposition: filename=%2e%2e%5cjelmer.wmz
Content-Type: application/download""",
"""From CERT:
'Microsoft Media Player contains a vulnerability in the parsing of \"Skin Files\" that may permit a remote attacker to download arbitrary files to a known location on the local system.[...]'"""))

tests.append(("test_winhelp_clsid", 3148, defaultUrl, defaultHeader,
"""From Bugtraq:
'A remotely exploitable has been reported in the WinHlp facility. This is due to insufficient bounds checking of the Item parameter in the WinHlp command. This issue is present in Winhlp32.exe.

It is possible for an attacker to exploit this condition by embedding a call to the vulnerable ActiveX control in a malicious webpage or HTML e-mail. Successful exploitation may allow for execution of arbitrary code on the client system as the Internet Explorer user.
Trigger:
<OBJECT classid=clsid:adb880a6-d8ff-11cf-9377-00aa003b7a11
codeBase=hhctrl.ocx#Version=4,72,8252,0 height=0 id=winhelp
type=application/x-oleobject width=0><PARAM NAME="Width"
VALUE="26"><PARAM NAME="Height" VALUE="26"><PARAM NAME="Command"
VALUE="WinHelp"><PARAM NAME="Item1"
VALUE="XXX"><PARAM
NAME="Item2" VALUE="NGS Software LTD"></OBJECT>
<SCRIPT>winhelp.HHClick()</SCRIPT>
'"""))

tests.append(("test_emf_access.emf", 2435, "www.evil.null/hollow.emf", defaultHeader,
"""From Bugtraq:
'It has been reported that Windows may be prone to a remote buffer overflow vulnerability when rendering WMF/EMF image files. An attacker could create a malicious WMF or EMF file and entice a user to view the file via an application that supports the WMF and EMF formats. Immediate consequences of this attack may result in a denial of service condition, however, it is possible that an attacker could leverage this issue to execute arbitrary code in the context of the vulnerable user.[...]'"""))

tests.append(("test_wmf_access.wmf", 2436, "www.evil.null/hollow.wmf", defaultHeader,
"""From Bugtraq:
'It has been reported that Windows may be prone to a remote buffer overflow vulnerability when rendering WMF/EMF image files. An attacker could create a malicious WMF or EMF file and entice a user to view the file via an application that supports the WMF and EMF formats. Immediate consequences of this attack may result in a denial of service condition, however, it is possible that an attacker could leverage this issue to execute arbitrary code in the context of the vulnerable user.[...]'"""))
             
for test in tests:
    out = open(test[0], "w")
    out.truncate()
    out.write(str(test[1]) + "\n")
    out.write(str(len(test[2])) + "\n")
    out.write(test[2] + "\n")
    out.write(str(len(test[3])) + "\n")
    out.write(test[3] + "\n")
    out.write(str(len(test[4])) + "\n")
    out.write(test[4] + "\n")
