/****************************************************************************
**  LatchWordBB - Vocabulary retention and reinforcement toolbar for Mozilla
**  Copyright (c) 2003  Charles Melhorn
**
**  This file is part of LatchWordBB.
**
**  LatchWordBB is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  LatchWordBB is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**  Or see the GNU web site at: http://www.gnu.org
**
****************************************************************************/ 


function getLWUserPreference(prefName, defValue, prefType, prefNode)
{
  var e, rv;

  switch(prefType)
   {
     case gLWconstants.PT_BOOL:

       try {rv = prefNode.getBoolPref(prefName);}
        catch (e) { rv = defValue; }        

       break;

     case gLWconstants.PT_INT:
       
       try {rv = prefNode.getIntPref(prefName);}
        catch (e) { rv = defValue; }        

       break;

     case gLWconstants.PT_STR:

       try {rv = prefNode.getCharPref(prefName);}
        catch (e) { rv = defValue; }        

       break;

     case gLWconstants.PT_UNICHAR:
     case gLWconstants.PT_UNICHARLOCAL:
     case gLWconstants.PT_FILE:

     default:
       alert("Preference type not implemented"); // DEBUG
   }

  return rv;
}


function setLWUserPreference(prefName, prefValue, prefType, prefNode)
{
  switch(prefType)
   {
     case gLWconstants.PT_BOOL:
       prefNode.setBoolPref(prefName, prefValue);
       break;

     case gLWconstants.PT_INT:
       prefNode.setIntPref(prefName, prefValue);
       break;

     case gLWconstants.PT_STR:
       prefNode.setCharPref(prefName, prefValue);
       break;

     case gLWconstants.PT_UNICHAR:
     case gLWconstants.PT_UNICHARLOCAL:
     case gLWconstants.PT_FILE:

     default:
       alert("Preference type not implemented"); // DEBUG
   }
}


