

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom;

//Java imports
import java.util.*;
import java.util.concurrent.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;
import org.mozilla.dom.events.*;
import org.mozilla.dom.ranges.*;
import org.mozilla.dom.traversal.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;


public class NodeImpl implements org.w3c.dom.Node, org.w3c.dom.events.EventTarget
{

    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMNode getInstance()
    {
	return getInstanceAsnsIDOMNode();
    }

    /***************************************************************
     *
     * Node implementation code
     *
     ***************************************************************/

    protected NodeImpl(nsISupports mozInst)
    {
        moz = mozInst;
        instances.put(mozInst, this);
    }
    public NodeImpl(nsIDOMNode mozInst)
    {
        this( (nsISupports) mozInst );
    }    

    public static NodeImpl getDOMInstance(nsIDOMNode mozInst)
    {
        
        NodeImpl node = (NodeImpl) instances.get(mozInst);
        return node == null ? new NodeImpl(mozInst) : node;
    }

    public nsIDOMNode getInstanceAsnsIDOMNode()
    {
        if (moz==null)
            return null;
        else
            return (nsIDOMNode) moz.queryInterface(nsIDOMNode.NS_IDOMNODE_IID);
    }

    public Node appendChild(final Node newChild)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMNode mozNewchild = newChild!=null ? ((NodeImpl) newChild).getInstance() : null;
        Callable<Node> c = new Callable<Node>() { public Node call() {
            nsIDOMNode result = getInstanceAsnsIDOMNode().appendChild(mozNewchild);
            return (Node) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String lookupPrefix(final String namespaceURI)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        Callable<String> c = new Callable<String>() { public String call() {
            String result = DOM3MozObject.lookupPrefix(namespaceURI);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setNodeValue(final String nodeValue)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMNode().setNodeValue(nodeValue);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public boolean isSameNode(final Node other)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMNode mozOther = other!=null ? ((NodeImpl) other).getInstance() : null;
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        Callable<Boolean> c = new Callable<Boolean>() { public Boolean call() {
            boolean result = DOM3MozObject.isSameNode(mozOther);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Node cloneNode(final boolean deep)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Node> c = new Callable<Node>() { public Node call() {
            nsIDOMNode result = getInstanceAsnsIDOMNode().cloneNode(deep);
            return (Node) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Node getFirstChild()
    {
        //METHOD-BODY-START - autogenerated code
        /* Frame patch */
        final Node[] result = { null };
        final Runnable r = new Runnable() { public void run() {
            nsIDOMNode current = getInstanceAsnsIDOMNode();
            if (NodeFactory.getExpandFrames() && SharedUtils.isFrameNode(current))
                result[0] = SharedUtils.frameNodeToDocument(current);
            else
               result[0] = (Node) NodeFactory.getNodeInstance(current.getFirstChild());
        }};

        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        } else {
            return 
                (Node)
                ThreadProxy.getSingleton().syncExec(new Callable<Node>() { public Node call() {
                    r.run();
                    return result[0];
                }});
        }
        //METHOD-BODY-END - autogenerated code
    }

    public void setTextContent(final String textContent)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        final Runnable r = new Runnable() { public void run() {
            DOM3MozObject.setTextContent(textContent);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public boolean isEqualNode(final Node arg)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMNode mozArg = arg!=null ? ((NodeImpl) arg).getInstance() : null;
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        Callable<Boolean> c = new Callable<Boolean>() { public Boolean call() {
            boolean result = DOM3MozObject.isEqualNode(mozArg);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void normalize()
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMNode().normalize();
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public boolean isSupported(final String feature, final String version)
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Boolean> c = new Callable<Boolean>() { public Boolean call() {
            boolean result = getInstanceAsnsIDOMNode().isSupported(feature, version);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Object getFeature(final String feature, final String version)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        Callable<Object> c = new Callable<Object>() { public Object call() {
            nsISupports result = DOM3MozObject.getFeature(feature, version);
            return result;        

        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Object getUserData(final String key)
    {
        //METHOD-BODY-START - autogenerated code
        return userData.get(key);
        //METHOD-BODY-END - autogenerated code
    }

    public String getPrefix()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMNode().getPrefix();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public short getNodeType()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Short> c = new Callable<Short>() { public Short call() {
            int result = getInstanceAsnsIDOMNode().getNodeType();
            return (short) result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Node getNextSibling()
    {
        //METHOD-BODY-START - autogenerated code
        /* Frame patch */
        final Node[] result = { null };
        final Runnable r = new Runnable() { public void run() {
            nsIDOMNode current = getInstanceAsnsIDOMNode();
            if (NodeFactory.getExpandFrames()) {
                if (SharedUtils.isHTMLNode(current)) {
                    inIDOMUtils utils = (inIDOMUtils)
                        Mozilla.getInstance().getServiceManager().
                        getServiceByContractID("@mozilla.org/inspector/dom-utils;1",
                                               inIDOMUtils.INIDOMUTILS_IID);
                    nsIDOMNode parentNode = utils.getParentForNode(current, false);

                    if (parentNode!=null) {
                        //not toplevel document
                        result[0] = null;
                        return;
                    }
                }
            }

            result[0] = (Node) NodeFactory.getNodeInstance(current.getNextSibling());
        }};

        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        } else {
            return 
                (Node)
                ThreadProxy.getSingleton().syncExec(new Callable<Node>() { public Node call() {
                    r.run();
                    return result[0];
                }});
        }
        //METHOD-BODY-END - autogenerated code
    }

    public Node getLastChild()
    {
        //METHOD-BODY-START - autogenerated code
        /* Frame patch */
        final Node[] result = { null };
        final Runnable r = new Runnable() { public void run() {
            nsIDOMNode current = getInstanceAsnsIDOMNode();
            if (NodeFactory.getExpandFrames() && SharedUtils.isFrameNode(current))
                result[0] = SharedUtils.frameNodeToDocument(current);
            else
               result[0] = (Node) NodeFactory.getNodeInstance(current.getFirstChild());
        }};

        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        } else {
            return 
                (Node)
                ThreadProxy.getSingleton().syncExec(new Callable<Node>() { public Node call() {
                    r.run();
                    return result[0];
                }});
        }
        //METHOD-BODY-END - autogenerated code
    }

    public boolean hasChildNodes()
    {
        //METHOD-BODY-START - autogenerated code
        /* Frame patch */
        final boolean[] result = { false };
        final Runnable r = new Runnable() { public void run() {
            nsIDOMNode current = getInstanceAsnsIDOMNode();
            if (NodeFactory.getExpandFrames() && SharedUtils.isFrameNode(current))
                result[0] = true;
            else
                result[0] = current.hasChildNodes();
        }};

        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        } else {
            return 
                (Boolean)
                ThreadProxy.getSingleton().syncExec(new Callable<Boolean>() { public Boolean call() {
                    r.run();
                    return result[0];
                }});
        }
        //METHOD-BODY-END - autogenerated code
    }

    public short compareDocumentPosition(final Node other)
    {
        //METHOD-BODY-START - autogenerated code
        /* Frame patch */
        final short[] result = { 0 };
        final Runnable r = new Runnable() { public void run() {
            if (NodeFactory.getExpandFrames()) {
                Document startDoc1 = getOwnerDocument();
                Document startDoc2 = other.getOwnerDocument();
                if (startDoc1.isSameNode(startDoc2)) {
                    //the standard case, inside of the same document
                    nsIDOMNode mozOther = ((NodeImpl) other).getInstance();

                    nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
                    int cresult = DOM3MozObject.compareDocumentPosition(mozOther);
                    result[0] = (short) cresult;
                } else {
                    //find the common ancestor document and 
                    //compare position of the ancestor frames

                    Stack/*<Document>*/ docs1 = new Stack/*<Document>*/();
                    {
                        Document d = startDoc1;
                        while (d!=null) {
                            docs1.push(d);
                            Node p = d.getParentNode();
                            if (p==null) d = null;
                            else d = p.getOwnerDocument();
                        }
                    }
    
                    Stack/*<Document>*/ docs2 = new Stack/*<Document>*/();
                    {
                        Document d = startDoc2;
                        while (d!=null) {
                            docs2.push(d);
                            Node p = d.getParentNode();
                            if (p==null) d = null;
                            else d = p.getOwnerDocument();
                        }
                    }
    
                    Document lastCommon = null;
                    Document doc1 = null;
                    Document doc2 = null;
                    while (!docs1.isEmpty() && !docs2.isEmpty()) {
                        doc1 = (Document) docs1.pop();
                        doc2 = (Document) docs2.pop();
                        if (doc1.isSameNode(doc2)) lastCommon = doc1;
                        else break;
                    }
    
                    if (lastCommon==null || doc1==null || doc2==null) {
                        //should not happen
                        result[0] = 33;
                        return;
                    }
    
                    Node frame1 = doc1.getParentNode();
                    if (frame1==null) {
                        if (docs1.isEmpty()) frame1 = NodeImpl.this;
                        else frame1 = ((Document)docs1.peek()).getParentNode();
                    }
                    Node frame2 = doc2.getParentNode();
                    if (frame2==null) {
                        if (docs2.isEmpty()) frame2 = other;
                        else frame2 = ((Document)docs2.peek()).getParentNode();
                    }
                
                    assert frame1!=null && frame2!=null;
                    assert frame1.getOwnerDocument().isSameNode(frame2.getOwnerDocument());
    
                    //compare position of the frames
                    nsIDOM3Node mozFrame1 = (nsIDOM3Node) ((NodeImpl) frame1).getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
                    nsIDOMNode mozFrame2 = ((NodeImpl) frame2).getInstance();
    
                    int cresult = mozFrame1.compareDocumentPosition(mozFrame2);
                    result[0] = (short) cresult;
                }
            } else {
                nsIDOMNode mozOther = ((NodeImpl) other).getInstance();

                nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
                int cresult = DOM3MozObject.compareDocumentPosition(mozOther);
                result[0] = (short) cresult;
            }
        }};

        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        } else {
            return 
                (Short)
                ThreadProxy.getSingleton().syncExec(new Callable<Short>() { public Short call() {
                    r.run();
                    return result[0];
                }});
        }
        //METHOD-BODY-END - autogenerated code
    }

    public String getBaseURI()
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        Callable<String> c = new Callable<String>() { public String call() {
            String result = DOM3MozObject.getBaseURI();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public boolean isDefaultNamespace(final String namespaceURI)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        Callable<Boolean> c = new Callable<Boolean>() { public Boolean call() {
            boolean result = DOM3MozObject.isDefaultNamespace(namespaceURI);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public boolean hasAttributes()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Boolean> c = new Callable<Boolean>() { public Boolean call() {
            boolean result = getInstanceAsnsIDOMNode().hasAttributes();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Node insertBefore(final Node newChild, final Node refChild)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMNode mozNewchild = newChild!=null ? ((NodeImpl) newChild).getInstance() : null;
        final nsIDOMNode mozRefchild = refChild!=null ? ((NodeImpl) refChild).getInstance() : null;
        Callable<Node> c = new Callable<Node>() { public Node call() {
            nsIDOMNode result = getInstanceAsnsIDOMNode().insertBefore(mozNewchild, mozRefchild);
            return (Node) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public NodeList getChildNodes()
    {
        //METHOD-BODY-START - autogenerated code
        /* Frame patch */
        final NodeList[] result = { null };
        final Runnable r = new Runnable() { public void run() {
            nsIDOMNode current = getInstanceAsnsIDOMNode();
            if (NodeFactory.getExpandFrames() && SharedUtils.isFrameNode(current))
                result[0] = new NodeListImpl(((NodeImpl)SharedUtils.frameNodeToDocument(current)).getInstance().getChildNodes());
            else
                result[0] = new NodeListImpl(current.getChildNodes());
        }};

        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        } else {
            return 
                (NodeList)
                ThreadProxy.getSingleton().syncExec(new Callable<NodeList>() { public NodeList call() {
                    r.run();
                    return result[0];
                }});
        }
        //METHOD-BODY-END - autogenerated code
    }

    public Node getParentNode()
    {
        //METHOD-BODY-START - autogenerated code
        /* Frame patch */
        final Node[] result = { null };
        final Runnable r = new Runnable() { public void run() {
            nsIDOMNode currentNode = getInstance();
            if (NodeFactory.getExpandFrames()) {
                if (currentNode.getNodeType() == nsIDOMNode.DOCUMENT_NODE)
                {
                    inIDOMUtils utils = (inIDOMUtils)
                        Mozilla.getInstance().getServiceManager().getServiceByContractID(
                            "@mozilla.org/inspector/dom-utils;1",
                            inIDOMUtils.INIDOMUTILS_IID);
                    nsIDOMNode parentNode = utils.getParentForNode(currentNode, false);

                    if (parentNode == null) {
                        //is toplevel document
                        result[0] = null;
                        return;
                    }

                    result[0] = (Node) NodeFactory.getNodeInstance(parentNode);
                }
                else 
                {
                    nsIDOMNode parentNode = getInstance().getParentNode();
                    if (parentNode != null && parentNode.getNodeType() == nsIDOMNode.DOCUMENT_NODE)
                    {
                        inIDOMUtils utils = (inIDOMUtils)
                            Mozilla.getInstance().getServiceManager().getServiceByContractID(
                               "@mozilla.org/inspector/dom-utils;1",
                                inIDOMUtils.INIDOMUTILS_IID);
                        nsIDOMNode parentParentNode = utils.getParentForNode(parentNode, false);

                        if (parentParentNode == null)
                            result[0] = (Node) NodeFactory.getNodeInstance(parentNode);

                        result[0] = (Node) NodeFactory.getNodeInstance(parentParentNode);    
                    } 
                    else
                        result[0] = (Node) NodeFactory.getNodeInstance(parentNode);
                }
            } else {
                result[0] = (Node) NodeFactory.getNodeInstance(currentNode.getParentNode());
            }
        }};

        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        } else {
            return 
                (Node)
                ThreadProxy.getSingleton().syncExec(new Callable<Node>() { public Node call() {
                    r.run();
                    return result[0];
                }});
        }
        //METHOD-BODY-END - autogenerated code
    }

    public String getNodeName()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMNode().getNodeName();
                                /* Case insensitivity patch */
                    if (result!=null && NodeFactory.getConvertNodeNamesToLowerCase())
                        return result.toLowerCase();
                    else
                        return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Node getPreviousSibling()
    {
        //METHOD-BODY-START - autogenerated code
        /* Frame patch */
        final Node[] result = { null };
        final Runnable r = new Runnable() { public void run() {
            nsIDOMNode current = getInstanceAsnsIDOMNode();
            if (NodeFactory.getExpandFrames()) {
                if (SharedUtils.isHTMLNode(current)) {
                    inIDOMUtils utils = (inIDOMUtils)
                        Mozilla.getInstance().getServiceManager().
                        getServiceByContractID("@mozilla.org/inspector/dom-utils;1",
                                               inIDOMUtils.INIDOMUTILS_IID);
                    nsIDOMNode parentNode = utils.getParentForNode(current, false);

                    if (parentNode!=null) {
                        //not toplevel document
                        result[0] = null;
                        return;
                    }
                }
            }

            result[0] = (Node) NodeFactory.getNodeInstance(current.getPreviousSibling());
        }};

        if (ThreadProxy.getSingleton().isMozillaThread()) {
            r.run();
            return result[0];
        } else {
            return 
                (Node)
                ThreadProxy.getSingleton().syncExec(new Callable<Node>() { public Node call() {
                    r.run();
                    return result[0];
                }});
        }
        //METHOD-BODY-END - autogenerated code
    }

    public Node replaceChild(final Node newChild, final Node oldChild)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMNode mozNewchild = newChild!=null ? ((NodeImpl) newChild).getInstance() : null;
        final nsIDOMNode mozOldchild = oldChild!=null ? ((NodeImpl) oldChild).getInstance() : null;
        Callable<Node> c = new Callable<Node>() { public Node call() {
            nsIDOMNode result = getInstanceAsnsIDOMNode().replaceChild(mozNewchild, mozOldchild);
            return (Node) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Document getOwnerDocument()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<Document> c = new Callable<Document>() { public Document call() {
            nsIDOMDocument result = getInstanceAsnsIDOMNode().getOwnerDocument();
            return (Document) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getLocalName()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMNode().getLocalName();
                                /* Case insensitivity patch */
                    if (result!=null && NodeFactory.getConvertNodeNamesToLowerCase())
                        return result.toLowerCase();
                    else
                        return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Object setUserData(final String key, final Object data, final UserDataHandler handler)
    {
        //METHOD-BODY-START - autogenerated code
        return userData.put(key, data);
        //METHOD-BODY-END - autogenerated code
    }

    public String getTextContent()
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        Callable<String> c = new Callable<String>() { public String call() {
            String result = DOM3MozObject.getTextContent();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String lookupNamespaceURI(final String prefix)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        Callable<String> c = new Callable<String>() { public String call() {
            String result = DOM3MozObject.lookupNamespaceURI(prefix);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getNodeValue()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMNode().getNodeValue();
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public Node removeChild(final Node oldChild)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMNode mozOldchild = oldChild!=null ? ((NodeImpl) oldChild).getInstance() : null;
        Callable<Node> c = new Callable<Node>() { public Node call() {
            nsIDOMNode result = getInstanceAsnsIDOMNode().removeChild(mozOldchild);
            return (Node) NodeFactory.getNodeInstance(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public NamedNodeMap getAttributes()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<NamedNodeMap> c = new Callable<NamedNodeMap>() { public NamedNodeMap call() {
            nsIDOMNamedNodeMap result = getInstanceAsnsIDOMNode().getAttributes();
            return new NamedNodeMapImpl(result);
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public String getNamespaceURI()
    {
        //METHOD-BODY-START - autogenerated code
        Callable<String> c = new Callable<String>() { public String call() {
            String result = getInstanceAsnsIDOMNode().getNamespaceURI();
                                /* Namespace insensitivity patch */
                    if (result ==null)
                        return "";
                    else {
                        String prefix = lookupPrefix(result);
                        if (prefix==null || prefix.equalsIgnoreCase("xmlns"))
                            return "";
                    }                
                    //System.out.println("----- isDefault: " + isDefaultNamespace(result));
                    //System.out.println("----- lookUpPrefix: " + lookupPrefix(result));
                    //System.out.println("----- lookUpNamespaceURI: " + lookupNamespaceURI(result));
                    return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void setPrefix(final String prefix)
    {
        //METHOD-BODY-START - autogenerated code
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMNode().setPrefix(prefix);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    /***************************************************************
     *
     * EventTarget implementation code
     *
     ***************************************************************/

    public NodeImpl(nsIDOMEventTarget mozInst)
    {
        this( (nsISupports) mozInst );
    }    

    public static NodeImpl getDOMInstance(nsIDOMEventTarget mozInst)
    {
        
        NodeImpl node = (NodeImpl) instances.get(mozInst);
        return node == null ? new NodeImpl(mozInst) : node;
    }

    public nsIDOMEventTarget getInstanceAsnsIDOMEventTarget()
    {
        if (moz==null)
            return null;
        else
            return (nsIDOMEventTarget) moz.queryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID);
    }

    public boolean dispatchEvent(final Event evt)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMEvent mozEvt = evt!=null ? ((EventImpl) evt).getInstance() : null;
        Callable<Boolean> c = new Callable<Boolean>() { public Boolean call() {
            boolean result = getInstanceAsnsIDOMEventTarget().dispatchEvent(mozEvt);
            return result;
        }};
        return ThreadProxy.getSingleton().syncExec(c);
        //METHOD-BODY-END - autogenerated code
    }

    public void removeEventListener(final String type, final org.w3c.dom.events.EventListener listener, final boolean useCapture)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMEventListener mozListener = listener!=null ? ((EventListenerImpl) listener).getInstance() : null;
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMEventTarget().removeEventListener(type, mozListener, useCapture);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }

    public void addEventListener(final String type, final org.w3c.dom.events.EventListener listener, final boolean useCapture)
    {
        //METHOD-BODY-START - autogenerated code
        final nsIDOMEventListener mozListener = listener!=null ? ((EventListenerImpl) listener).getInstance() : null;
        final Runnable r = new Runnable() { public void run() {
            getInstanceAsnsIDOMEventTarget().addEventListener(type, mozListener, useCapture);
        }};
        ThreadProxy.getSingleton().syncExec(r);
        //METHOD-BODY-END - autogenerated code
    }


    private HashMap<String, Object> userData = new HashMap<String, Object>();

}
