/*****************************************************************************
 *
 * Original author: Fredrik Hübinette <hubbe@hubbe.net>
 *
 * Current Authors: Louis Bavoil <bavoil@cs.utah.edu>
 *                  Peter Leese <hubbe@hubbe.net>
 *
 * This code is based on and is a branch of plugger written 
 * by Fredrik Hübinette <hubbe@hubbe.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *
 *****************************************************************************/
#ifndef _MOZPLUGGER_H_
#define _MOZPLUGGER_H_


/*****************************************************************************
 * Defines
 *****************************************************************************/

#ifndef MAXINT
#define MAXINT 0x7fffffff
#endif

#define MAX(X,Y) ((X)>(Y)?(X):(Y))

/* Time to wait for a process to exit */
#define KILL_TIMEOUT_USEC 100000

/* Each handler has a list of mime types, and a list of commands. */
#define MAX_NUM_HANDLERS 64
#define MAX_NUM_TYPES_PER_HANDLER 32
#define MAX_NUM_CMDS_PER_HANDLER 32

#define MAX_STATIC_MEMORY_POOL   65536

/* Maximum size of the buffer used for environment variables. */
#define ENV_BUFFER_SIZE 16348

#define LARGE_BUFFER_SIZE 16384
#define LARGE_BUFFER_SIZE_STR "16384"

#define SMALL_BUFFER_SIZE 128
#define SMALL_BUFFER_SIZE_STR "128"
#define FIND_CACHE_SIZE   10

/* Flags */
#define H_LOOP          0x1
#define H_DAEMON        0x2
#define H_STREAM        0x4
#define H_NOISY         0x8
#define H_REPEATCOUNT   0x10
#define H_EMBED         0x20
#define H_NOEMBED       0x40
#define H_IGNORE_ERRORS 0x80
#define H_SWALLOW       0x100
#define H_MAXASPECT     0x200
#define H_FILL          0x400
#define H_HIDDEN        0x800
#define H_CONTROLS      0x1000
#define H_LINKS         0x2000
#define H_FMATCH        0x4000
#define H_AUTOSTART     0x8000

/*****************************************************************************
 * Control use of semaphore in mozplugger-helper, define if one wants
 * semaphores (rare cases doesnt work)
 *****************************************************************************/
#define USE_MUTEX_LOCK


/*****************************************************************************
 * mozplugger-common.c functions
 *****************************************************************************/
#ifdef DEBUG

#define DEBUG_FILENAME "mozdebug"
void close_debug(void);
char * get_debug_path(void);

#endif

#ifdef __GNUC__
void D(char *fmt, ...) __attribute__((format(printf,1,2)));
#else
void D(char *fmt, ...);
#endif

void my_kill(pid_t pid);

#endif
