/***
  * The contents of this file are subject to the Mozilla Public
  * License Version 1.1 (the "License"); you may not use this file
  * except in compliance with the License. You may obtain a copy of
  * the License at http://www.mozilla.org/MPL/
  * 
  * Software distributed under the License is distributed on an "AS
  * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
  * implied. See the License for the specific language governing
  * rights and limitations under the License.
  * 
  * The Original Code in this file as it was released publicly upon
  * October 30, 2004 after being tested for several months by a 
  * bunch of CSS co-workers. Thanks guys ;)
  * 
  * The Initial Developer of the Original Code is HJ van Rantwijk.
  * all Portions created by HJ van Rantwijk are Copyright (C) 2004-2007
  * by HJ van Rantwijk. All Rights Reserved.
  * 
  * Contributors:
  *   Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
  *
  */

var markupFixup = [
	[ /(&#151|&amp;#151|&mdash|&amp;mdash);/g,	"&#8212;",	"mdash" ],
	[ /&quot;/g,					"&#39;",	"&amp;quote;" ],
	[ /&lsquo;/g,					"&#8216;",	"&amp;lsquo;" ],
	[ /&rsquo;/g,					"&#8217;",	"&amp;rsquo;" ],
	[ /&ldquo;/g,					"&#8220;",	"&amp;ldquo;" ],
	[ /&rdquo;/g,					"&#8221;",	"&amp;rdquo;" ],
	[ /&trade;/g,					"&#8482;",	"&amp;trade;" ],
	[ /&nbsp;/g,					"<br />",	"&amp;nbsp;" ],
	[ /(&dagger|&amp;dagger);/g,			"&#8224;",	"dagger"],
        [ /(&bull|&amp;bull);/g,			"&#8226;",	"bull"],
        [ /(&hellip|&amp;hellip);/g,			"&#8230;",	"hellip"], // ...
        [ /\&deg;/g,					"&#176;",	"degree sign"], // degree sign
	[ /\&pound;/g,					"&#8356;",	"pound sign"], // pound sign
	[ /(\n|\t|\r|\f)/g,				" ",		"\\x" ], // white space need special handling!
	[ /\&amp;quot;/g,				"&#39;",	"&amp;#39;" ],
        [ /([ |\w])&((?![#|amp;])[\w| ])/g,		"$1&amp;$2",	"&amp;" ], // "&#151; 123&456 & abc&def 123&abd abc&123 abc&amp;def"
	[ /(src=|src=(?![\"|\']))/g,			"src=\"" ,	"src attribute missing \"" ],
	[ /(href=|href=(?![\"|\']))/g,		"href=\"",	"href attribute missing \"" ],
	[ /(width=?(?![\"|\']))/g,			"width=\"" ,	"width attribute missing \"" ],
	[ /(height=?(?![\"|\']))/g,			"height=\"",	"height attribute missing \"" ],
	[ / *>/g,					"\">",		"missing \"" ],
	[ / *\/>/g,					"\" />",	"missing \"" ],
	/* [ /<[A-Z]\w>/g,				"<$1".toLowerCase() + ">", "uppercase tag" ], */
	[ /<(br|hr)([^>]*[^\/]|)>/g,			"<$1$2 />",	"missing closing /" ],
	[ /<img([^>]*[^\/]|)>(?!<\/img>)/g,		"$1 />",	"img missing closing /" ],
	[ /<img([^\/>]*[^\/])>(<\/img>)/g,		"<img$1 />",	"XHTML" ],
	[ /< *br clear=(left|right|all|none) \/>/g,	"<br clear=\"$1\" />",	"br clear=" ], // temporarily hack!
	[ /<blockquote>/g,				"",	"blockquote order" ],
	[ /<\/blockquote>/g,				"",	"" ]
];

var smileys = [
	[ /\s(&gt;[-^v]?)\)/g,		"alien"],
	[ /\s(&gt;[=:;][-^v]?)[(|]/g,	"angry"],
	[ /\s([:][-]?)[Ss]/g,		"confused"],
	[ /\s([B8][-^v]?)[)\]]/g,	"cool"],
	[ /\s([=:;][~'][-^v]?)\(/g,	"cry"],
	[ /\so[._]O/g,			"dizzy"],
	[ /\sO[._]o/g,			"dizzy-back"],
	[ /\so[._]o|O[._]O/g,		"eek"],
	[ /\s(&gt;[=:;][-^v]?)D/g,	"evil"],
	[ /\s([=:;][-^v]?)DD/g,		"lol"],
	[ /\s([=:;][-^v]?)D/g,		"laugh"],
	[ /\s[xX]?-D/g,			"rofl"],
	[ /\s([=:;][-^v]?)\|/g,		"normal"],
	[ /\s([=:;][-^v]?)\?/g,		"question"],
	[ /\s[=:;]"[)\]]/g,		"red"],
	[ /\s9[._]9/g,			"rolleyes"],
	[ /\s([=:;][-^v]?)[(\[]/g,	"sad"],
	[ /\s([=:][-^v]?)[)\]]/g,	"smile"],
	[ /\s([=:;][-^v]?)[0oO]/g,	"surprised"],
	[ /\s([=:;][-^v]?)[pP]/g,	"tongue"],
	[ /\s;[-]?\)/g,			"wink"]
];

function delayedInsert(aIndex, aLength)
{
  mzFeedViewer.addContentToBoxes(aIndex, aLength);
}

var mzFeedViewer =
{
  XHTML_NS: "http://www.w3.org/1999/xhtml",
  itemList: null,
  keys: null,
  articleIndex: 0,
  isInitialized: false,

  init: function()
  {
    // dump("\nmzFeedViewer.init");
    if (this.isInitialized)
      return;

    var displayMilitaryTime = false;
    this.isInitialized = true;
    this.itemList = new Array();
    this.keys = new Array();

    // Items are build up by <div> elements so get all of them
    var divs = document.getElementsByTagNameNS(this.XHTML_NS, "div");

    // Not all divs are items so we have to check them first
    for (var i = 0; i < divs.length; i++) {
      if (divs[i].getAttribute("class") == "article") {
        // Item found, so lets convert the date in the same run
        var date = divs[i].getAttribute("date");
        // Not all items have a date, so we also have to check the date
        if (date)
          divs[i].childNodes[1].textContent = this.getPrettyDate(date, displayMilitaryTime);
       // Keep this item for further use
       this.itemList.push(divs[i]);
      }
      if (i == 3) {
        var keys = divs[i].getAttribute("keys");

        for (var kIndex = 0; kIndex < keys.length; kIndex++) {
          var key = keys.charCodeAt(kIndex);
          this.keys.push(key);
        }
      }
    }
    var numberOfItems = (this.itemList.length);
    /***
      * By now we have collected all items, converted the dates into a more 
      * readable one and so it is time to initialize the three navigation buttons.
      */
    this.initItemBoxes();
    /***
      * The list with items might be very long, and that might take ages to finish, 
      * so we do an initial run with a only a limited number of items to give people 
      * the 'impression' that it has finished, and fast ;)
      */
    this.markupErrors = 0;
    var items = (numberOfItems < 6) ? numberOfItems : 5;
    this.insertContent(0, items);
    setTimeout(delayedInsert, 0, items, numberOfItems);
  },

  onclick: function(aEvent)
  {
    var target = aEvent.target;
    // dump("\ntarget: " + target.localName)
    if (target.className.match(/^subscribeButton/) || target.className.match(/^favicon/))
       return;
 
    if (target instanceof HTMLAnchorElement) { //  || target instanceof HTMLAreaElement || target instanceof HTMLLinkElement)
      // if (target.href.match(/\.(jar|xpi|exe|doc)\??/i) == null)
      if (target.href.match(/\.(jar|xpi|exe|doc)\?\w*?/i) == null) // make .jar?rev= work
        target.target = "_blank";

      var topNode = target.parentNode.parentNode.parentNode.parentNode;

      if (topNode.className == "article-container")
        topNode.setAttribute("visited", true);
    }
    if (target instanceof HTMLImageElement) {
      if (target.hasAttribute("disabled"))
        return;
      if (target.parentNode.localName == "a") {
        target.parentNode.target = "_blank";        
        return;
      }
      var currentIndex;
      var index = Number(target.parentNode.getAttribute("index"));
      var articles = Number(target.parentNode.getAttribute("articles"));
      var showArticle = (target.className != "toggleButton");

      if (window.location.href.match(/#article-/))
        currentIndex = Number(window.location.href.replace(/.*#article-/, ""));

      var inValidClick = (aEvent.button != 0);

      switch(target.className) {
        case "previous":
          if (inValidClick)
            return;
          /* if (currentIndex && currentIndex > 0)
            index = currentIndex - 1;
          else if (index > 1)
            index--; */
          //go up based on the button index!
          if (index > 1)
            index--;
          if (currentIndex && currentIndex == index)
            if (index > 1)
              index--;
            break;
        case "next":
          if (inValidClick)
            return;
          /* if (currentIndex && currentIndex < articles)
            index = currentIndex + 1;
          else if (index < articles)
            index++; */
          // go down based on the button index!
          if (index < articles)
            index++;
          if (currentIndex && currentIndex == index)
            if (index < articles)
              index = currentIndex + 1;
          break;
        case "top":
          if (inValidClick)
            return;

          index = 1;
          break;
        case "toggleButton":
          if (inValidClick)
            return;

          var type = target.getAttribute("type");
          target.style.display = "none";
          var contentBox = target.parentNode.nextSibling;
          var isText = (type == "text");
          target.setAttribute("type", isText ? "markup" : "text");
          contentBox.textContent = isText ? contentBox.markup : contentBox.text; // markup.replace(/<([^>]*)>/g, "");
          target.style.display = "block";
          break;
      }
      if (showArticle)
        window.location.href = (index == -1) ? window.location.href.replace(/article-\w*/, "#") : "#article-" + String(index);
    }
  },

  onkeydown: function(aEvent)
  {
    aEvent.stopPropagation();
  },

  onkeyup: function(aEvent)
  {
    var key = aEvent.keyCode;
    var refresh = false;
    var currentIndex;
    var keys = mzFeedViewer.keys;
    var index = mzFeedViewer.articleIndex;
    var articles = (mzFeedViewer.itemList.length -1);

    if (window.location.href.match(/#article-/))
      currentIndex = Number(window.location.href.replace(/.*#article-/, ""));

    if (key == keys[0]) { // Previous Article
      if (currentIndex && currentIndex > 0) {
        index = currentIndex - 1;
        refresh = true;
      }
      else if (index > 1) {
        index--;
        refresh = true;
      }
    }
    else if (key == keys[1]) { // Next Article
      if (currentIndex && currentIndex < articles) {
        index = currentIndex + 1;
        refresh = true;
      }
      else if (index < articles) {
        index++;
        refresh = true;
      }
    }
    else if (key == keys[2]) { // First Article
      index = 0;
      refresh = true;
    }
    else if (key == keys[3]) { // Subscribe to Feed
      dump("\nkey S: " + key);
    }
    if (refresh) {
      window.location.href = (index == -1) ? window.location.href.replace(/#article-*/, "") : "#article-" + String(index);
      mzFeedViewer.articleIndex = index;
      refresh = false;
    }
  },

  /***
    * Copied from Mozilla Thunderbird but renamed and slightly modified
    */
  convertDate: function(dateString)
  {  
    var parts = dateString.match(/(\d\d\d\d)(-(\d\d))?(-(\d\d))?(T(\d\d):(\d\d)(:(\d\d)(\.(\d+))?)?(Z|([+-])(\d\d):(\d\d))?)?/);
    var date = new Date(parts[1], parts[3]-1, parts[5], parts[7] || 0, parts[8] || 0, parts[10] || 0, parts[12] || 0);
    var remoteToUTCOffset = 0;

    if (parts[13] && parts[13] != "Z") {
      var direction = (parts[14] == "+" ? 1 : -1);
      if (parts[15])
        remoteToUTCOffset += direction * parts[15] * 3600000;
      if (parts[16])
        remoteToUTCOffset += direction * parts[16] * 60000;
    }
    remoteToUTCOffset = remoteToUTCOffset * -1;
    var UTCToLocalOffset = date.getTimezoneOffset() * 60000;
    UTCToLocalOffset = UTCToLocalOffset * -1;
    date.setTime(date.getTime() + remoteToUTCOffset + UTCToLocalOffset);
    return date.toUTCString();
  },
  
  getPrettyDate: function(aDateString, displayMilitaryTime)
  {
    var aDate;
    var retValue = "";

    if (aDateString.search(/^\d\d\d\d/) != -1) {
      aDate = this.convertDate(aDateString);
      aDateString = aDate;
    }
    aDate = new Date(aDateString.replace(/BST|IST$/, "GMT +0100"));

    if (aDate == "Invalid Date") {
      // This is an experimental code snippet and I still needs to finish it!
      var parts = aDateString.match(/^((Mon|Tue|Wed|Thu|Fri|Sat|Sun), *)?(\d\d)? +(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) +(\d\d|\d\d\d\d)? +(\d\d:\d\d:\d\d)? +([+-]?\d\d\d\d|UT|GMT|EST|EDT|CST|CDT|MST|MDT|PST|PDT|\w)$/);

      if (parts) {
        if (parts[5].length == 2) 
          parts[5] = "20" + parts[5];
        aDate = new Date(parts[3] +" "+ parts[4] +" "+ parts[5] +" "+ parts[6] +" "+ parts[7]);
      }
    }
    if (aDate instanceof Date) {
      var dayString;
      var currentDate = new Date();
      var currentGetTime = currentDate.getTime();
      var currentDayMonth = currentDate.getUTCDate() + ":" + currentDate.getUTCMonth();
      var publishedDate = aDate;
      var publishedGetTime = publishedDate.getTime();
      var publishedDayMonth = publishedDate.getUTCDate() + ":" + publishedDate.getUTCMonth();

      if (currentDayMonth == publishedDayMonth)
        dayString = "Today";
      else if (currentGetTime > publishedGetTime && currentGetTime < (publishedGetTime + 86400000))
        dayString = "Yesterday";
      else {
        dayString = publishedDate.toUTCString();
        dayString = dayString.substring(0, 11);
      }
      var addition = "";
      var timeString = "";
      var hours = publishedDate.getUTCHours();
      var minutes = publishedDate.getUTCMinutes();

      if (!displayMilitaryTime) {
        if (minutes == 0) {
          if (hours == 12)
            timeString = "Noon";
          else if (hours == 0)
            timeString = "Midnight";
        }
        if (timeString == "") {
          if (hours >= 0 && (hours <= 11 && minutes <= 59))
            addition = "AM";
          else {
            addition = "PM";

            if (hours >= 12)
              hours -= 12;
          }
          function padZeros(num) {
            return num < 10 ? "0" + num : num;
          }
          timeString = padZeros(hours) + ":" + padZeros(minutes) + " " + addition;
        }
      }
      retValue = (dayString + " @ " + timeString);
    }
    return retValue;
  },

  isValidRFC822Date: function(aDateString)
  {
    // Date validator for RSS feeds
    const FZ_RFC822_RE = "^(((Mon)|(Tue)|(Wed)|(Thu)|(Fri)|(Sat)|(Sun)), *)?\\d\\d?" + 
                         " +((Jan)|(Feb)|(Mar)|(Apr)|(May)|(Jun)|(Jul)|(Aug)|(Sep)|(Oct)|(Nov)|(Dec))" + 
                         " +\\d\\d(\\d\\d)? +\\d\\d:\\d\\d(:\\d\\d)? +(([+-]?\\d\\d\\d\\d)|(UT)|(GMT)" + 
                         "|(EST)|(EDT)|(CST)|(CDT)|(MST)|(MDT)|(PST)|(PDT)|\\w)$";

    var parts = aDateString.match(/^((Mon|Tue|Wed|Thu|Fri|Sat|Sun), *)?(\d\d)? +(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) +(\d\d|\d\d\d\d)? +(\d\d:\d\d:\d\d)? +([+-]?\d\d\d\d|UT|GMT|EST|EDT|CST|CDT|MST|MDT|PST|PDT|\w)$/);
    // dump("\nparts-1: " + parts)
    var regex = new RegExp(FZ_RFC822_RE);
    return regex.test(aDateString);
  },

  initItemBoxes: function()
  {
    try {

    var articles = this.itemList;
    // We might want to change the XSL to handle most, if not all of this.
    for (var article = 0; article < articles.length; article++) {
      var articleAnchor = articles[article].firstChild;
      var articleID = "article-" + (article + 1);
      articleAnchor.id = articleID;
      articleAnchor.name = articleID;

      var topBox = articles[article].childNodes[2];
      topBox.setAttribute("articles", (articles.length-1));
      topBox.setAttribute("index", (article + 1));
    }
    if (articles.length) {
      topBox = articles[0].childNodes[2];
      // Disable the "Previous Article" link for the first article
      topBox.firstChild.setAttribute("disabled", "true");
      // Disable the "First Article" link for the first article
      topBox.childNodes[2].setAttribute("disabled", "true");
      // Disable the "Next Article" link for the last article
      topBox = articles[articles.length-1].childNodes[2];
      topBox.childNodes[1].setAttribute("disabled", "true")
    }
   } catch(ex) { dump("\nex(initItemBoxes): " + ex) }
  },

  addContentToBoxes: function(aStartIndex, aNumber)
  {
    this.insertContent(aStartIndex, aNumber);

	if (this.markupErrors) {
      var errorSpan = document.getElementById("markupErrors");
      var errorText = (this.markupErrors == 1) ? " unrecoverable markup error" : " unrecoverable markup error(s)";
      errorSpan.textContent = this.markupErrors + errorText;
    }
  },

  /***
    * Michael, this is one of the sections that needs a re-write.
    * See if you can get rid of the first dummyDiv.innerHTML You might 
    * also want to add a new function to handle errors, but make sure 
    * that you test everything 'thoroughly' after you're done!
    */
  insertContent: function(aStartIndex, aNumber)
  {
    var textOrMarkup;
    var articles = this.itemList;
    try {
    for (var article = aStartIndex; article < aNumber; article++) {
      var orgMarkup, textOrErrors = new Array();
      var markupCheckStage = 0;
      var mainDiv = articles[article].childNodes[2].childNodes[3].lastChild; // the <a> link
      var orgTitle = mainDiv.getAttribute("title");
      var newTitle = orgTitle.replace(/([&lt;|<])([^>|&]*)(&gt;|>)/g,""); // .replace(/<([^>]*)>/g, "");
      // dump("\nmarkupCheckStage-0: " + markupCheckStage); 
      if (orgTitle != newTitle) {
        mainDiv.innerHTML = newTitle;
        mainDiv.setAttribute("title", newTitle);
        textOrErrors.push("HTML in &lt;title&gt;");
        markupCheckStage++;

        // dump("\nmarkupCheckStage-1: " + markupCheckStage);
      }
      textOrMarkup = articles[article].getAttribute("description");

      if (!textOrMarkup) {
        var mainLink = mainDiv.getAttribute("href");
        textOrMarkup = (mainLink) ? "<p><a href=\"" + mainLink + "\">Link...</a></p>" : "<p>...</p>";
      }
      if (textOrMarkup) {
        // We have content...add the main container...
        var textContainer = articles[article].childNodes[3]; // document.createElementNS(this.XHTML_NS, "div");
        // articles[article].appendChild(textContainer);
        // and add the text container...
        var displayBox = document.createElementNS(this.XHTML_NS, "div");
        displayBox.className = "textContainer";

        try {
          /*** 
            * This is stage one: here we insert the markup without any modifications 
            * and the markup is OK when we don't end up in the catch (well done chap).
            */
          markupCheckStage++;
          // dump("\nmarkupCheckStage-2: " + markupCheckStage);
          // This is not an error, but we have to replace this IE-ism for Yahoo!
          if (textOrMarkup.indexOf("#151;") >= 0) {
            orgMarkup = textOrMarkup;
            textOrMarkup = textOrMarkup.replace(markupFixup[0][0], markupFixup[0][1]);

            if (orgMarkup != textOrMarkup)
              textOrErrors.push("#151;");
          }
          if (textOrMarkup.indexOf("&quot;") >= 0) {
            orgMarkup = textOrMarkup;
            textOrMarkup = textOrMarkup.replace(markupFixup[1][0], markupFixup[1][1]);

            if (orgMarkup != textOrMarkup) {
              textOrErrors.push(markupFixup[1][2]);
              /* dump("\nQUOTE-1: " + orgMarkup);
              dump("\nQUOTE-2: " + textOrMarkup); */
            }
          }
          // if (textOrMarkup.match(/((^|\s)(?:[&gt;]?[B8=:;(xX][~']?[-^v"]?(?:[)|(PpSs0oO\?\[\]\/\\]|D+)|&gt;[-^v]?\)|[oO9][._][oO9])(\s|$))/))
            textOrMarkup = this.insertSmiley(textOrMarkup);
          displayBox.innerHTML = textOrMarkup;
          textContainer.appendChild(displayBox);
        } catch(ex) {
          // dump("\nex: " + ex);
          /*** 
            * innertHTML failed, so the markup contains errors, but we need to display 
            * the content anyway. Let's call in the troops to 'fix' the markup errors.
            * Yes, this is a dirty way to do it, but it works...most of the times ;)
            */
          for (fIndex in markupFixup) {
            orgMarkup = textOrMarkup;
            textOrMarkup = textOrMarkup.replace(markupFixup[fIndex][0], markupFixup[fIndex][1]);

            if (orgMarkup != textOrMarkup && markupFixup[fIndex][2] != "")
              textOrErrors.push(markupFixup[fIndex][2]);
          }
          /*** 
            * We should have fixed the most common markup errors by now, so let's try again.
            * Note: we might need to extend [markupFixup] to catch other errors as well.
            */
          try {
            markupCheckStage++;
            // dump("\nmarkupCheckStage-3: " + markupCheckStage);
            displayBox.innerHTML = textOrMarkup;
            textContainer.appendChild(displayBox);
          } catch(ex) {
            /*** 
              * Second attempt failed: the markup contains other/unknown and/or 
              * more severe markup errors...now we have to get real dirty (:
              */
            try {
              // XXX: Dad, what is this? Do we (still) need this (at all)?
              // Good question, but I can't remember why!?!
              if (textOrMarkup.indexOf("content-encoded>") >= 0) {
                textOrMarkup = textOrMarkup.replace(/<content-encoded>/g, "");
                textOrMarkup = textOrMarkup.replace(/<\/content-encoded>/g, "");
              }
              var dummyDiv = document.createElementNS(this.XHTML_NS, "div");

              markupCheckStage++;
              // dump("\nmarkupCheckStage-4: " + markupCheckStage);
              dummyDiv.innerHTML = textOrMarkup;
            } catch(ex) {
              // dump("\nStage 2 markup error in article: " + article);
              dummyDiv = null;

              try {
                markupCheckStage++;
                // dump("\nmarkupCheckStage-5: " + markupCheckStage);
                dummyDiv.innerHTML = textOrMarkup;
              } catch(ex) {
                // dump("\nStage 4 markup error in article: " + article);
                // Markup fix failed, split content into paragraphs
                /* replace <div>'s with <p>'s (why?)
                textOrMarkup = textOrMarkup.replace(/<div([^>]*)>/g, "<p>");
                textOrMarkup = textOrMarkup.replace(/<\/div>/g, "</p>"); */
                textOrMarkup = textOrMarkup.replace(/<p(?!re)[^\>]*>/ig, "\n");
                textOrMarkup = textOrMarkup.replace(/<\/p>/ig, "");
              }
              dummyDiv = null;
            }
            var paragraphs = textOrMarkup.split("\n");

            if (paragraphs.length) {

              for (var pIndex = 0; pIndex < paragraphs.length; pIndex++) {
                textOrMarkup = paragraphs[pIndex];
                var dummy = textOrMarkup.replace(/\s*/g, '');

                if (dummy.length) {
                  /* if (dummy != "<p></p>") {
                    // re-insert the stripped paragraph elements
                    textOrMarkup = "<p>" + textOrMarkup + "</p>";
                  } */
                  if (displayBox == undefined) {
                    displayBox = document.createElementNS(this.XHTML_NS, "div");
                    displayBox.className = "textContainer";
                  }
                  try {
                    markupCheckStage++;
                    // dump("\nmarkupCheckStage-6: " + markupCheckStage);
                    displayBox.innerHTML = textOrMarkup;
                  } catch(ex) {
                    this.markupErrors++;
                    // dump("\nmarkupCheckStage-7: " + markupCheckStage);
                    var errorTab = document.createElementNS(this.XHTML_NS, "span");
                    errorTab.textContent = "Markup error detected!";
                    errorTab.className = "paragraphErrorHeader";

                    var toggleButton = document.createElementNS(this.XHTML_NS, "img");
                    toggleButton.setAttribute("type", "text");
                    toggleButton.id = "toggleButton";
                    toggleButton.className = "toggleButton";
                    toggleButton.title = "Click to toggle Text v.s. Markup";
                    errorTab.appendChild(toggleButton);
                    displayBox.appendChild(errorTab);
                    var contentBox = document.createElementNS(this.XHTML_NS, "p");
                    contentBox.className = "contentBox";
                    var text  = textOrMarkup.replace(/&lt;/g, "<").replace(/&gt;/g, ">");
                    text = text.replace(/<(br|hr) *(\/>)/g, "\n");
                    text = text.replace(/<([^>]*)>/g, "");
                    contentBox.text = text;
                    contentBox.textContent = text;
                    contentBox.markup = textOrMarkup;

                    displayBox.className = "paragraphError";
                    displayBox.appendChild(contentBox);
                  }
                  textContainer.appendChild(displayBox);
                  displayBox = undefined;
                }
              }
            }
          }
        }
      }
      var comments = articles[article].getAttribute("comments");

      if (comments) {
        var span = document.createElementNS(this.XHTML_NS, "span");
        span.className = "contentBox";
        span.textContent = "Comments: ";
        var a = document.createElementNS(this.XHTML_NS, "a");
        a.href = comments;
        a.textContent = comments;
        span.appendChild(a);
        articles[article].appendChild(span);
      }

      if (articles[article].childNodes.length == 5) {
        var enclosureBox = articles[article].childNodes[4];
        var enclosure = enclosureBox.firstChild;

        if (enclosure.localName == "enclosure") {
          var url = enclosure.getAttribute("url");

          if (url != "") {
            var size = enclosure.getAttribute("length");
            var type = enclosure.getAttribute("type");
            /***
              * Auto types:
              *   audio/mpeg      -> .mp3
              *   audio/x-m4a     -> .m4a
              * Video types:
              *   video/mp4       -> .mp4
              *   video/x-m4v     -> .m4v
              *   video/quicktime -> .mov
              */
            var isAudio = /\.m(p3|4a)$/.test(url);
            var isVideo = /\.m(p4|4v|ov)$/.test(url);

            enclosureBox.removeChild(enclosure);

            if (isAudio || isVideo) {
              // dump("\nisAudio: " + isAudio + " isVideo: " + isVideo);
              enclosureBox.setAttribute("type", (isAudio) ? "audio" : "video");
              var enclosureImage = document.createElementNS(this.XHTML_NS, "a");
              enclosureImage.className = "enclosureImage";
              enclosureImage.href = url;
              enclosureImage.title = url;
              enclosureImage.type = (isAudio) ? "audio" : "video";
              enclosureImage.target = "_blank";
              enclosureBox.appendChild(enclosureImage);

              var enclosureLink = document.createElementNS(this.XHTML_NS, "a");
              enclosureLink.className = "enclosureLink";
              enclosureLink.href = url;
              enclosureLink.title = url;
              enclosureImage.target = "_blank";
              var linkText = (isAudio) ? "Listen to item" : "Play Video";

              if (size != "")
                linkText += " (" + size + " bytes)";

              enclosureLink.textContent = linkText;
              enclosureBox.appendChild(enclosureLink);
            }
          }
        }
      }
      if (textOrErrors.length > 0) {
        var markupErrorBox = document.createElementNS(this.XHTML_NS, "div");
        markupErrorBox.className = "markupErrorContainer";
        // dump("\ntextOrErrors: " + textOrErrors);
        markupErrorBox.innerHTML = "<p><em style='color:red;'>Markup Errors Fixed by FeedViewer:</em> " + textOrErrors + "</p>";
        articles[article].appendChild(markupErrorBox);
      }
      articles[article].markupCheckStage = markupCheckStage;
      textContainer.setAttribute("markupCheckStage", String(markupCheckStage));
    }
    } catch(ex) {
      dump("\nex-2: " + ex);
    }
  },

  insertSmiley: function(textOrMarkup)
  {
    // dump("\ninsertSmiley();");
    for (i in smileys) {
      if (textOrMarkup.search(smileys[i][0]) != -1) {
        // textOrMarkup = textOrMarkup.replace(smileys[i][0], "<img class=\"emotion\" type=\"face-" + smileys[i][1] + "\"/>");
        textOrMarkup = textOrMarkup.replace(smileys[i][0], "<img class=\"emotion\" src=\"chrome://chatzilla/skin/images/face-" + smileys[i][1] + ".png\"/>");
        // dump("\nmatching: " + smileys[i][1]);
      }
    }
    return(textOrMarkup);
  }
};

addEventListener("click", mzFeedViewer.onclick, false);
addEventListener("keyup", mzFeedViewer.onkeydown, false);
addEventListener("keyup", mzFeedViewer.onkeyup, false);



