/* 
   - The Original Code is this file as it was released on Februari 21, 2005.
   -
   - The Initial Developer of the Original Code is HJ van Rantwijk.
   - Portions created by HJ van Rantwijk are Copyright (C) 2005
   - HJ van Rantwijk.  All Rights Reserved.
   -
*/

var gBimSheetObj, gBrowser, gBundle, gPKIBundle, gHost, gUseStackedWindows;
var gWindowHeight = 400; 
var gWindowWidth = 500;

function startup()
{
  gBimSheetObj = window.arguments[0];
  gBrowser = window.opener.getBrowser();
  document.documentElement.setAttribute("hidechrome", "true");
  gUseStackedWindows = window.opener.gMultiZilla.prefs.readBoolean("multizilla.managers.use-stacked-windows", false);
  repositionDialog();

  if (gUseStackedWindows) {
    document.documentElement.setAttribute("hidechrome", "true");
    window.outerWidth = gWindowWidth;
    window.outerHeight = 0;
    slideOpen(0);
  }
  else {
    window.outerWidth = window.outerWidth;
    window.outerHeight = window.outerHeight;
    document.getElementById("main-box").collapsed = false;
  }
  document.getElementById('mac_button_spring').hidden = !(/Mac/.test(navigator.platform));
  gBundle = window.opener.gMultiZilla.utility.getStringBundle();
  gPKIBundle = window.opener.gMultiZilla.utility.getStringBundle("chrome://pippki/locale/pippki.properties");
  initBIMSheet();
  displayCertDetails();
}

function repositionDialog()
{
  var notificationBoX = gBimSheetObj.notificationBox;
  var screenX = notificationBoX.boxObject.screenX + ((notificationBoX.boxObject.width - gWindowWidth) / 2);
  var screenY = notificationBoX.boxObject.screenY;
  var newHeight = gWindowHeight;

  if (newHeight >= screen.availHeight - screenY - 5)
    newHeight = screen.availHeight - screenY - 5;
  window.resizeTo(gWindowWidth, newHeight);
  screenY = (gUseStackedWindows) ? (screenY - 1) : (screenY - 4);
  window.moveTo(screenX, screenY);
}

function slideOpen(aStep)
{
  if (aStep < gWindowHeight) {
    window.outerHeight += 50;
    setTimeout(slideOpen, 20, aStep += 50);
  }
  else {
    window.outerHeight = gWindowHeight;
    document.getElementById("main-box").collapsed = false;
  }
}

function slideClosed(aStep)
{
  if (gUseStackedWindows) {
    if (aStep < window.outerHeight) {
      window.outerHeight -= 50;
      setTimeout(slideClosed, 20, aStep += 50);
    }
    else
      window.close();
  }
  else
    window.close();
}

function onAccept(aEvent)
{
  if (gHost) {
    window.opener.gMultiZilla.dnp.addHostToIDNHistory(gHost);
    gBimSheetObj.keys = window.opener.gMultiZilla.dnp.doIDNHistory(null);
    gBimSheetObj.notificationBox.removeCurrentNotification();
  }
  document.getElementById("main-box").collapsed = true;
  window.close();
}

function onCancel(aEvent)
{
  slideClosed(1);
}

function purgeSSLHstory()
{
  window.opener.gMultiZilla.dnp.purgeIDNHistory();
  gBimSheetObj.keys = window.opener.gMultiZilla.dnp.doIDNHistory(null);
  slideClosed(1);
}

function resetMasterPassword()
{
  alert("Not Yet Implemented");
}

function addAttributeFromCert(nodeName, value)
{
  var node = document.getElementById(nodeName);

  if (!value)
    value = gPKIBundle.GetStringFromName('notPresent');
  node.setAttribute('value', value);
}

function initBIMSheet()
{
  gHost = gBimSheetObj.host;
  var descriptionText = gBundle.formatStringFromName('newSiteDescription', [gHost], 1);
  var description = document.getElementById("NewSiteDescription");
  description.textContent = descriptionText;

  var keys = gBimSheetObj.keys;
  descriptionText = gBundle.formatStringFromName('privacyProtectionDescription', [keys], 1);
  description = document.getElementById("PrivacyProtectionDescription");
  description.textContent = descriptionText;
}

function displayCertDetails()
{
  var verifystr = "";
  var o1 = {};
  var o2 = {};
  var o3 = {};
  var cert = window.opener.mzGetServerCert();
  cert.getUsagesArray(false, o1, o2, o3);
  var verifystate = o1.value;
  var count = o2.value;
  var usageList = o3.value;

  if (verifystate == cert.VERIFIED_OK) {
    verifystr = gPKIBundle.GetStringFromName('certVerified');
  } else if (verifystate == cert.CERT_REVOKED) {
    verifystr = gPKIBundle.GetStringFromName('certNotVerified_CertRevoked');
  } else if (verifystate == cert.CERT_EXPIRED) {
    verifystr = gPKIBundle.GetStringFromName('certNotVerified_CertExpired');
  } else if (verifystate == cert.CERT_NOT_TRUSTED) {
    verifystr = gPKIBundle.GetStringFromName('certNotVerified_CertNotTrusted');
  } else if (verifystate == cert.ISSUER_NOT_TRUSTED) {
    verifystr = gPKIBundle.GetStringFromName('certNotVerified_IssuerNotTrusted');
  } else if (verifystate == cert.ISSUER_UNKNOWN) {
    verifystr = gPKIBundle.GetStringFromName('certNotVerified_IssuerUnknown');
  } else if (verifystate == cert.INVALID_CA) {
    verifystr = gPKIBundle.GetStringFromName('certNotVerified_CAInvalid');
  } else { /* NOT_VERIFIED_UNKNOWN and USAGE_NOT_ALLOWED) */
    verifystr = gPKIundle.GetStringFromName('certNotVerified_Unknown');
  }
  if (count > 0) {
    document.getElementById("Verified").value = verifystr;
    var text = "";

    for (var i = 0; i < count; i++) {
      text += (i > 0) ? ", " + usageList[i] : usageList[i];
    }
    document.getElementById("VerifiedFor").value = text;
  }

  addAttributeFromCert("CommonName", cert.commonName);
  addAttributeFromCert("Organization", cert.organization);
  addAttributeFromCert("OrganizationUnit", cert.organizationalUnit);

  addAttributeFromCert("IssuerCommonName", cert.issuerCommonName);
  addAttributeFromCert("IssuerOrganization", cert.issuerOrganization);
  addAttributeFromCert("IssuerOrganizationUnit", cert.issuerOrganizationUnit);

  addAttributeFromCert("ValidityStart", cert.validity.notBeforeLocalDay);
  addAttributeFromCert("ValidityEnd", cert.validity.notAfterLocalDay);
}

