/* 
   - The contents of this file are subject to the Mozilla Public
   - License Version 1.1 (the "License"); you may not use this file
   - except in compliance with the License. You may obtain a copy of
   - the License at http://www.mozilla.org/MPL/
   -
   - Software distributed under the License is distributed on an "AS
   - IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
   - implied. See the License for the specific language governing
   - rights and limitations under the License.
   -
   - The Original Code is this file as it was released on
   - March 20, 2001.
   -
   - The Initial Developer of the Original Code is HJ van Rantwijk.
   - Portions created by HJ van Rantwijk are Copyright (C) 2001-2007
   - HJ van Rantwijk.  All Rights Reserved.
   -
   - Contributor(s):
   -  Michael Vincent van Rantwijk <mv_van_rantwijk@yahoo.com>
   -
*/

var gLineNumber = 0;
var gLastLineNumber = 0;
const nsISelectionPrivate = Components.interfaces.nsISelectionPrivate;
const nsISelectionController = Components.interfaces.nsISelectionController;

function BrowserFullScreen()
{
  const PREFBRANCH = "multizilla.fullscreen.";
  var chromeHidden = document.documentElement.getAttribute("chromehidden");

  if (chromeHidden) {
    if (gMultiZilla.prefs.readBoolean(PREFBRANCH + "re-enable-chrome", true)) {
      document.documentElement.removeAttribute("chromehidden");
      return;
    }
    if (gMultiZilla.prefs.readBoolean(PREFBRANCH + "disable.chromeless", true))
      return;
  }
  var fullScreenEnabled = gMultiZilla.prefs.readBoolean(PREFBRANCH + "enabled", true);
  var semiFullScreen = false;

  if (fullScreenEnabled) {
    var firstWindowOnly = gMultiZilla.prefs.readBoolean(PREFBRANCH + "first-browserwindow-only", true);
    var adaptiveModeEnabled = gMultiZilla.prefs.readBoolean(PREFBRANCH + "adaptive-mode.enabled", true);
    FullScreen.adaptiveModeEnabled = adaptiveModeEnabled;

    if (adaptiveModeEnabled) {
      var targetWidth = gMultiZilla.prefs.readInteger(PREFBRANCH + "adaptive-mode.target-width", 1024);
      var windowElement = document.getElementsByTagName("window")[0];
      var targetXPosition = 0;
      var aTargetPosition = gMultiZilla.prefs.readInteger(PREFBRANCH + "adaptive-mode.target-position", 1); // 0 = left / 1 = center / 2 = right

      // Calculate the window target X position
      switch(aTargetPosition) {
        case 0: targetXPosition = 0;
          break;
        case 2: targetXPosition = (window.screen.availWidth - targetWidth);
          break;
        default:
          targetXPosition = (window.screen.availWidth / 2) - (targetWidth / 2);
      }
      // Toggle OS Chrome and resize window (needed to trigger a refresh)
      if (windowElement.hasAttribute("hidechrome")) {
        semiFullScreen = true;
        windowElement.removeAttribute("hidechrome");
        window.moveTo((targetXPosition + 1), 1);
        window.resizeTo((targetWidth - 1), (window.screen.availHeight - 1));
      }
      else {
        semiFullScreen = false;
        windowElement.setAttribute("hidechrome", "true");
        window.moveTo(targetXPosition, 0);
        window.resizeBy(20, 0);
      }
      // Resize window to target width
      window.resizeTo(targetWidth, window.screen.availHeight);
    }
    var isFirstWindow = gMultiZilla.utility.isFirstWindow();

    if (firstWindowOnly && !isFirstWindow || 
        adaptiveModeEnabled && !isFirstWindow)
      return;

    if ((adaptiveModeEnabled && !semiFullScreen) || 
        (!adaptiveModeEnabled && !window.fullScreen)) {
      const MENUBAR = 0;
      const NAVTOOLBAR = 0;
      const PERSONALTOOLBAR = 1;
      const LINKTOOLBAR = 2;
      const TABMODETOOLBAR = 0;
      const SKIPTOOLBARS = 2;
      const STATUSBAR = 0;

      var XULNS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
      // Menubar
      var prefValue = gMultiZilla.prefs.readBoolean(PREFBRANCH + "enable.menubar", false);
      var menubars = document.getElementsByTagNameNS(XULNS, "menubar");
      var currentMenubar = menubars[MENUBAR];
      currentMenubar.setAttribute("fullscreentoolbar", (prefValue ? "true" : "false"));

      var toolbars = document.getElementsByTagNameNS(XULNS, "toolbar");

      // Navigation Toolbar
      prefValue = gMultiZilla.prefs.readBoolean(PREFBRANCH + "enable.nav-bar", false);
      var targetToolbar = toolbars[NAVTOOLBAR];
      targetToolbar.setAttribute("fullscreentoolbar", (prefValue ? "true" : "false"));

      // Personal Toolbar
      prefValue = gMultiZilla.prefs.readBoolean(PREFBRANCH + "enable.personaltoolbar", false);
      dump("\nenable.personaltoolbar: " + prefValue);
      targetToolbar = toolbars[PERSONALTOOLBAR];
      targetToolbar.setAttribute("fullscreentoolbar", (prefValue ? "true" : "false"));

      // Site Navigation Bar
      prefValue = gMultiZilla.prefs.readBoolean(PREFBRANCH + "enable.linktoolbar", false);
      targetToolbar = toolbars[LINKTOOLBAR];
      targetToolbar.setAttribute("fullscreentoolbar", (prefValue ? "true" : "false"));

      // Third Party Toolbars
      if (toolbars.length > SKIPTOOLBARS) {
        for (var i = SKIPTOOLBARS; i < toolbars.length-1; i++) {
          var id = "Toolbar-" + (i - SKIPTOOLBARS + 2);

          if (toolbars[i].hasAttribute("id"))
            id = toolbars[i].getAttribute("id");

          try {
            prefValue = gMultiZilla.prefs.readBoolean(PREFBRANCH + "enable.thirdparty." + id, false);
            toolbars[i].setAttribute("fullscreentoolbar", (prefValue ? "true" : "false"));
          } 
          catch(ex) {
            // Disable Third Party Toolbars by default
            toolbars[i].setAttribute("fullscreentoolbar", "false");

            if (id)
              gMultiZilla.prefs.writeBoolean(PREFBRANCH + "enable.thirdparty." + id, false);
	  }
        }          
      }
      // MultiZilla Toolbar
      prefValue = gMultiZilla.prefs.readBoolean(PREFBRANCH + "enable.tabmodetoolbar", true);
      toolbars = document.getElementsByTagNameNS(XULNS, "tabmodetoolbar");
      targetToolbar = toolbars[TABMODETOOLBAR];
      targetToolbar.setAttribute("fullscreentoolbar", (prefValue ? "true" : "false"));

      // Status Bar
      prefValue = gMultiZilla.prefs.readBoolean(PREFBRANCH + "enable.status-bar", true);
      toolbars = document.getElementsByTagNameNS(XULNS, "statusbar");
      targetToolbar = toolbars[STATUSBAR];
      targetToolbar.setAttribute("fullscreentoolbar", (prefValue ? "true" : "false"));
    }
    if (adaptiveModeEnabled)
      FullScreen.toggle();
    else
      window.fullScreen = !window.fullScreen; // Toggle FullScreen Mode
  }
  else { // Ask users permission to re-enable FullScreen mode
    var aHeader = gMultiZilla.utility.getTextFromBundle("reenableFSHeader");
    var aQuestion = gMultiZilla.utility.getTextFromBundle("reenableFSQuestion");
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                  .getService(Components.interfaces.nsIPromptService);

    if (promptService.confirm(window, aHeader, aQuestion)) {    
       gMultiZilla.prefs.writeBoolean(PREFBRANCH + "enabled", true);
       BrowserFullScreen();
    }
  }
  // Trigger a reflow for the bookmarks chevron on the Personal Toolbar
  function _inner() {
    BookmarksToolbar.resizeFunc(null);
    BookmarksToolbar.updateOverflowMenu(document.getElementById("bookmarks-chevron-popup"));
  }
  setTimeout(_inner, 0);
}

FullScreen.adaptiveModeEnabled = false;

FullScreen.toggle = function() 
{
  var windowElement = document.getElementsByTagName("window")[0];
  var state = ((!this.adaptiveModeEnabled && window.fullScreen) || 
               (this.adaptiveModeEnabled && !windowElement.hasAttribute("hidechrome")));

  this.showXULChrome("menubar", state);
  this.showXULChrome("toolbar", state);
  this.showXULChrome("tabmodetoolbar", state);
  this.showXULChrome("statusbar", state);
}

FullScreen.showXULChrome = function(aTag, aShow)
{
  var XULNS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
  var els = document.getElementsByTagNameNS(XULNS, aTag);

  for (var i = 0; i < els.length; ++i) {
    if (els[i].getAttribute("fullscreentoolbar") == "true") {
      // XXX don't interfere with previously collapsed toolbars
      if (aTag == "toolbar" && els[i].hasAttribute("id")) {
        var id = els[i].getAttribute("id");

        if (id != "nav-bar" && "PersonalToolbar" && "linktoolbar") {
          var collapsed = els[i].getAttribute("moz-collapsed");
          // alert(id+" : "+collapsed);
          continue;
        }
      }
      this.setToolbarButtonMode(els[i], (aShow ? "" : "small"));
    }
    else {
      // use moz-collapsed so it doesn't persist hidden/collapsed,
      // so that new windows don't have missing toolbars
      if (aShow)
        els[i].removeAttribute("moz-collapsed");
      else
        els[i].setAttribute("moz-collapsed", "true");
    }
  }
  // Show window controls (minimize, maximize and close)
  var controls = document.getElementsByAttribute("fullscreencontrol", "true");

  for (i = 0; i < controls.length; ++i)
    controls[i].hidden = aShow;
}

function OpenBookmarkURL(node, datasource, event)
{
  if (node.nodeName == "menu")
    return;

  if (event && (node.id == "bookmarks_groupmark" ||
                node.id == "PT_bookmarks_groupmark" ||
                node.id == "bookmarks_button_groupmark"))
    return;

  var prefValue = gMultiZilla.prefs.readInteger("multizilla.bookmark.groups", 5);
  // XXX: new code for bug 3319
  if (prefValue & 1 && node.parentNode.parentNode.getAttribute("group") && !node.hasAttribute("id"))
    node = node.parentNode.parentNode;
  if (!node.hasChildNodes() && node.getAttribute("group") && node.hasAttribute("id")) {
    var numberOfTabs = gBrowser.mTabContainer.childNodes.length-1;
    var newTabs = gMultiZilla.prefs.readInteger("multizilla.bookmark.groups.behaviour", 2);
    var closeRemaining = gMultiZilla.prefs.readBoolean("multizilla.bookmark.close-remaining", false);
    // open dialog for settings
    if (newTabs == 2) {
      window.openDialog("chrome://multiviews/content/session-manager/miscellaneous/tabBehaviorSelection.xul", 
                        "", "chrome,modal,centerscreen", getBrowser(), closeRemaining,
                        gMultiZilla.utility.getPlatformExtras());

      if (gBrowser.mNewTabs == -1)
        return;

      newTabs = gBrowser.mNewTabs;
      closeRemaining = gBrowser.mRemoveRemaining;
    }
    else {
      newTabs = (newTabs == 1);
    }
    var startTab = newTabs ? (numberOfTabs+1) : 0;
    /***
      * Ask for confirmation to prevent mass opening of (unwanted) tabs/urls
      * See also: http://bugzilla.mozdev.org/show_bug.cgi?id=9746
      */
    if (!gMultiZilla.bookmarks.confirmTabGroupOpen(gMultiZilla.bookmarks.MZ_OPEN_BOOKMARKS_AS_TABS))
      return;

    gMultiZilla.bookmarks.openBookmarkFolder(node, datasource, (numberOfTabs+1), newTabs, false, false);
    gBrowser.selectedTab = gBrowser.mTabContainer.childNodes[startTab];

    if (closeRemaining) {
      if (newTabs) {
        /* startTab = gBrowser.mTabList[startTab].ordinal-1;
        for (i = startTab; i >= 0; i--)
          gBrowser.removeTab(gBrowser.mTabList[i]); */
      }
      else {
        // for (var i = tabCount; i >= tabIndex; i--)
        for (var i = numberOftabs; i >= tabIndex; i--)
          gBrowser.removeTab(gBrowser.mTabs[i]);
      }
    }
    return;
  }
  var allowMiddleClicks = gMultiZilla.prefs.readBoolean("multizilla.bookmark.menuitem.allow-middleclick", false);

  if (node.getAttribute("container") == "true" || (node.nodeName == "menuitem" && 
      event && 'button' in event && event.button == 1 && !allowMiddleClicks) )
    return;

  var url = node.getAttribute("id");

  if (!url)
    return;

  try {
    if (datasource) {
      var src = RDF.GetResource(url);
      var prop = RDF.GetResource("http://home.netscape.com/NC-rdf#URL");
      var target = datasource.GetTarget(src, prop, true);
      if (target) {
        target = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
        if (target)
          url = target;
      }
    }
  } catch (ex) {
    return;
  }
  if (url.substring(0, 3) == "NC:")
    return;
  if (window.content) {
    var shiftKey = false;
    var ctrlKey = false;
    var button = false;
    var backupNode = node; // Keep node for future reference!

    if (event) {
      shiftKey = event.shiftKey;
      ctrlKey = event.ctrlKey;
      button = event.button;
    }
    // Is this URL already loaded in one of the tabs?
    if (gMultiZilla.tabs.preventDuplicate(url)) {
      // Do we need to close menupopups?
      if (allowMiddleClicks && gMultiZilla.prefs.readBoolean("multizilla.bookmark.menuitem.middleclick-closepopups", true)) 
        gMultiZilla.bookmarks.closeMenu(backupNode);
      return;
    }
    while (node.nodeName != "toolbarbutton" && node.nodeName != "menubar")
      node = node.parentNode;

    if ((node.nodeName == "menubar" && pref && pref.getBoolPref("multizilla.newtabfor.bookmarks") && !shiftKey) ||
        (node.nodeName == "toolbarbutton" /* XXX: see bug 2675 && node.id != "bookmarks-button" */ && 
        pref && pref.getBoolPref("multizilla.newtabfor.personal-toolbar") && !shiftKey) || 
        ctrlKey || button == 1) {
      if (url.substring(0,10) == "javascript") {
	    if (url.indexOf("getSelection(") != -1)
          loadURI(url, null);
        else
          setTimeout(function() { loadURI(url, null) }, 0, gBrowser.selectedTab = getBrowser().addTab());
      }
      else {
        if (ctrlKey && shiftKey) { // Do we need to open a new window?
          window.open(url);
          return;
        }
        var tab = null;
        var browser = gMultiZilla.tabs.checkForBlankTab();

        if (browser) {
          browser.loadURI(getShortcutOrURI(url, null));
          tab = document.getAnonymousElementByAttribute(gBrowser, "linkedpanel", browser.parentNode.id);
        }
        else
          tab = gBrowser.addTab(getShortcutOrURI(url));

        var loadInBackground = gMultiZilla.prefs.readBoolean("multizilla.bookmark.loadInBackground", false);
        // Select the new tab, based on the pref setting and shiftKey!
        if (!loadInBackground && !shiftKey || loadInBackground && shiftKey)
          gBrowser.selectedTab = tab;
      }
    }
    else {
      loadURI(url, null);
      window.content.focus();
    }
    // Do we need to close menupopups?
    if (allowMiddleClicks && gMultiZilla.prefs.readBoolean("multizilla.bookmark.menuitem.middleclick-closepopups", true)) 
      gMultiZilla.bookmarks.closeMenu(backupNode);
  }
  else
    openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no", url);
}

function BrowserLoadURL(aTriggeringEvent)
{
  var url = gURLBar.value;

  if (url.match(/^view-source:/)) {
    BrowserViewSourceOfURL(url.replace(/^view-source:/, ""), null, null);
  } else {
    // Check the pressed modifiers: (also see bug 97123)
    // Modifier Mac | Modifier PC | Action
    // -------------+-------------+-----------
    // Command      | Control     | New Window/Tab
    // Shift+Cmd    | Shift+Ctrl  | New Window/Tab behind current one
    // Option       | Shift       | Save URL (show Filepicker)

    // If false, the save modifier is Alt, which is Option on Mac.
    var modifierIsShift = true;

    try {
      modifierIsShift = pref.getBoolPref("ui.key.saveLink.shift");
    }
    catch (ex) {}

    var shiftPressed = false;
    var saveModifier = false; // if the save modifier was pressed

    if (aTriggeringEvent && 'shiftKey' in aTriggeringEvent && 'altKey' in aTriggeringEvent) {
      saveModifier = modifierIsShift ? aTriggeringEvent.shiftKey : aTriggeringEvent.altKey;
      shiftPressed = aTriggeringEvent.shiftKey;
    }
    var tabBrowser = getBrowser();
    url = getShortcutOrURI(url);
    var newTab = gMultiZilla.prefs.readBoolean("multizilla.newtabfor.locationbar", false);
    // Accept both Control and Meta (=Command) as New-Window-Modifiers
    if ((aTriggeringEvent &&
        (('ctrlKey' in aTriggeringEvent && aTriggeringEvent.ctrlKey) ||
         ('metaKey' in aTriggeringEvent && aTriggeringEvent.metaKey) || 
         ('button' in aTriggeringEvent && aTriggeringEvent.button == 1))) || newTab) {
      // Check if user requests Tabs instead of windows
      var openTab = false;

      try {
        openTab = pref.getBoolPref("browser.tabs.opentabfor.urlbar");
      }
      catch (ex) {}

      if (openTab || newTab) {
        var tab = gMultiZilla.tabs.preventDuplicate(url, false)

        if (tab == null) {
          var browser = gMultiZilla.tabs.checkForBlankTab(tabBrowser);
          // Do we have a blank/unused tab available?        
          if (browser) {
            tab = tabBrowser.getTabForBrowser(browser);
            browser.loadURIWithFlags(url, nsIWebNavigation.LOAD_FLAGS_ALLOW_THIRD_PARTY_FIXUP, null, null);
          }
          else // Open link in a new tab when there's no blank tab available
            tab = tabBrowser.addTab(url, null, null, false, nsIWebNavigation.LOAD_FLAGS_ALLOW_THIRD_PARTY_FIXUP);
        }
        // Focus new tab unless shift is pressed
        if (!shiftPressed) {
          tabBrowser.userTypedValue = null;
          tabBrowser.selectedTab = tab;
        }
      } 
      else {
        // Open a new window with the URL
        var newWin = openDialog(getBrowserURL(), "_blank", "all,dialog=no", url, null, null, nsIWebNavigation.LOAD_FLAGS_ALLOW_THIRD_PARTY_FIXUP);
        // Reset url in the urlbar, copied from handleURLBarRevert()
        var oldURL = tabBrowser.currentURI.spec;

        if (oldURL != "about:blank") {
          gURLBar.value = oldURL;
          SetPageProxyState("valid", null);
        } else
          gURLBar.value = "";

        tabBrowser.userTypedValue = null;
        // Focus old window if shift was pressed, as there's no
        // way to open a new window in the background
        // XXX this doesn't seem to work
        if (shiftPressed) {
          //newWin.blur();
          content.focus();
        }
      }
    }
    else if (saveModifier) {
      try {
        // Firstly, fixup the url so that (e.g.) "www.foo.com" works
        const nsIURIFixup = Components.interfaces.nsIURIFixup;

        if (!gURIFixup)
          gURIFixup = Components.classes["@mozilla.org/docshell/urifixup;1"].getService(nsIURIFixup);

        url = gURIFixup.createFixupURI(url, nsIURIFixup.FIXUP_FLAGS_MAKE_ALTERNATE_URI).spec;
        // Open filepicker to save the url
        saveURL(url, "");
      }
      catch(ex) {
        // XXX Do nothing for now.
        // Do we want to put up an alert in the future?  Mmm, l10n...
      }
    } else {
      // No modifier was pressed, load the URL normally and
      // focus the content area
      loadURI(url, null, nsIWebNavigation.LOAD_FLAGS_ALLOW_THIRD_PARTY_FIXUP);
      content.focus();
    }
  }
}

function LoadBookmarksCallback() // for mozilla v1.4+
{
  // BookmarksUtils.isValidTargetContainer = mzIsValidTargetContainer;
  initServices();
  initBMService();
  BMSVC.readBookmarks();
  var bt = document.getElementById("bookmarks-ptf");

  if (bt)
    bt.database.AddObserver(BookmarksToolbarRDFObserver);

  window.addEventListener("resize", BookmarksToolbar.resizeFunc, false);
  controllers.appendController(BookmarksMenuController);

  // The following lines have been added for MultiZilla to fix bug 4327
  var personalToolbar = document.getElementById("bookmarks-ptf");
  personalToolbar.builder.rebuild();
  // mzFeedHandler.init(); moved to startup() in multizilla.js
}

function OpenBookmarkGroup(element, datasource, id)
{
  if (!datasource)
    return;
  if (element)
    id = element.getAttribute("id");
  else {
    id = gMultiZilla.prefs.readString("multizilla.tabs.groupmark", null);
    if (!id)
      return;
  }
  var resource = RDF.GetResource(id, true);
  OpenBookmarkGroupFromResource(resource, datasource);
}

function BrowserViewSourceOfURL(url, charset, pageCookie, aEvent)
{
  /***
    * Don't open the source in a tab when we're being called from the Tidy Validation add-on
    * We can eventually validate the calling ID's by checking them against a preference!
    */
  if (aEvent == undefined && gMultiZilla.prefs.readBoolean("multizilla.newtabfor.view-source", false)) {
    var tab = null;
    var loadFromURL = true;
    url = 'view-source:' + url.replace(/view-source:/ig, '');
    var browser = gMultiZilla.tabs.checkForBlankTab();
    tab = gMultiZilla.tabs.preventDuplicate(url, false, gBrowser);

    if (tab) {
      gBrowser.selectedTab = tab;
      return;
    }
    try {
      if (typeof(pageCookie) == "object" || typeof(pageCookie) == "function") {
        tab = (browser) ? gBrowser.getTabForBrowser(browser)
                        : gBrowser.addTab(null, null, null, false, null); //, "restoreTab");
        gBrowser.selectedTab = tab;
        var pageLoader = getBrowser().webNavigation.QueryInterface(Components.interfaces.nsIWebPageDescriptor);
        
        if ('loadPage' in pageLoader) // For Mozilla builds dated 2004-07-14 15:53 and later
          pageLoader.loadPage(pageCookie, Components.interfaces.nsIWebPageDescriptor.DISPLAY_AS_SOURCE);
        else // For older Mozilla builds work
          pageLoader.LoadPage(pageCookie, Components.interfaces.nsIWebPageDescriptor.DISPLAY_AS_SOURCE);
        loadFromURL = false;
      }
    } catch(ex) { 
    }
    if (loadFromURL) {
      if (!tab) {
        tab = browser ? gBrowser.getTabForBrowser(browser)
                      : gBrowser.addTab(null, null, null, false, null); //, "restoreTab");
      }
      gBrowser.selectedTab = tab;
      loadURI(url);
    }
  }
  else {
    openDialog("chrome://navigator/content/viewSource.xul", "_blank",
               "scrollbars,resizable,chrome,dialog=no", url, charset, pageCookie);
  }
}

function OpenBookmarkGroupFromResource(resource, datasource)
{
  var urlProperty = RDF.GetResource("http://home.netscape.com/NC-rdf#URL");
  var rdfContainer = Components.classes["@mozilla.org/rdf/container;1"].getService(Components.interfaces.nsIRDFContainer);
  rdfContainer.Init(datasource, resource);
  var containerChildren = rdfContainer.GetElements();
  var index = 0;

  while (containerChildren.hasMoreElements()) {
    resource = containerChildren.getNext().QueryInterface(Components.interfaces.nsIRDFResource);
    var target = datasource.GetTarget(resource, urlProperty, true);
    if (target) {
      var URL = target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value;
      if (URL /* && URL != 'about:blank' */ ) {
        if (!gMultiZilla.tabs.preventDuplicate(URL)) {
          if (index == 0)
            gBrowser.loadURI(URL);
          else 
            gBrowser.addTab(URL);
          index++;    
        }
      }
    }
  }  
  if (index == 0)
    return; // If the bookmark group was completely invalid, just bail.

  /* var numberOfTabs = gBrowser.mPanelContainer.childNodes.length-1;
  var inBackground = pref.getBoolPref("browser.tabs.loadInBackground") ? 0 : numberOfTabs;
  var tabs = gBrowser.mTabContainer.childNodes;
  gBrowser.selectedTab = tabs[inBackground]; */
  var numberOfTabs = gBrowser.mTabContainer.childNodes.length-1;
  var activeTab = gMultiZilla.prefs.readBoolean("browser.tabs.loadInBackground", false) ? 0 : numberOfTabs;
  gBrowser.selectedTab = gBrowser.mTabContainer.childNodes[activeTab];
}

function FillInPTTooltip(tipElement) // for mozilla v1.4
{
  var title = tipElement.label;
  var url = tipElement.statusText;

  if (!title && !url)
    return false;

  var tooltipTitle = document.getElementById("ptTitleText");
  var tooltipUrl = document.getElementById("ptUrlText"); 

  if (title && title != url) {
    tooltipTitle.removeAttribute("hidden");
    tooltipTitle.setAttribute("value", title);
  } else  {
    tooltipTitle.setAttribute("hidden", "true");
  }
  if (url) {
    tooltipUrl.removeAttribute("hidden");
    tooltipUrl.setAttribute("value", url);
  } else {
    tooltipUrl.setAttribute("hidden", "true");
  }
  return true;
}

BookmarksToolbar.updateOverflowMenu = function(aMenuPopup) // bookmarksMenu.js
{
   var hbox = document.getElementById("bookmarks-ptf");
   // There will be two menu items missing from the overflow menu, without this modification
   // We replace mozilla's template, this is why we have two extra childnodes,
   // childNodes[0] = tooltip and childNodes[1] = our modified template
   for (var i = 2; i < hbox.childNodes.length; i++) {
     var button = hbox.childNodes[i];
     var menu = aMenuPopup.childNodes[(i-2)];

     if (menu && menu.hidden == button.collapsed)
       menu.hidden = !menu.hidden;
   }
}

BookmarksToolbar.resizeFunc = function(event) 
{
  if (!event) // timer callback case
    BookmarksToolbarRDFObserver._overflowTimerInEffect = false;
  // else if (event.target != window)
    // return; // only interested in chrome resizes

  var buttons = document.getElementById("bookmarks-ptf");

  if (!buttons)
    return;

  var chevron = document.getElementById("bookmarks-chevron");

  if (!buttons.firstChild) {
    // No bookmarks means no chevron
    chevron.collapsed = true;
    return;
  }
  chevron.collapsed = false;
  var chevronWidth = chevron.boxObject.width;
  chevron.collapsed = true;
  var remainingWidth = buttons.boxObject.width;
  var overflowed = false;
  // MultiZilla has two additional childnodes being: childNodes[0] which
  // is our tooltip and childNodes[1] which is our modified template
  // Note: we could remove the tooltip because Mozilla code also supports both 
  // the title and url in tooltips, which btw wasn't the case for a long time!
  for (var i = 2; i < buttons.childNodes.length; i++) {
    var button = buttons.childNodes[i];
    button.collapsed = overflowed;
      
    if (i == (buttons.childNodes.length - 1)) // last ptf item...
      chevronWidth = 0;
    remainingWidth -= button.boxObject.width;

    if (remainingWidth < chevronWidth) {
      overflowed = true;
      // This button doesn't fit. Show it in the menu. Hide it in the toolbar.
      if (!button.collapsed)
        button.collapsed = true;
      if (chevron.collapsed) {
        chevron.collapsed = false;
      }
    }
  }
}

function StatusbarViewPopupManager() // navigator.js
{
  var hostPort = "";
  var sourceURI = getBrowser().selectedBrowser.currentURI;

  try {
    hostPort = (sourceURI.spec.match(/file:/i)) ? "file:" : sourceURI.hostPort;
  }
  catch(ex) { 
    hostPort = sourceURI.spec;
  }
  gMultiZilla.managers.openPermissionManager(hostPort, "PopupsPanel", "PopupsPermissionsTab");
}

function gotoHistoryIndex(aEvent) // navigator.js
{
  var index = aEvent.originalTarget.getAttribute("index");

  if (!index)
    return false;

  if (index == "back")
    gBrowser.goBackGroup();
  else if (index ==  "forward")
    gBrowser.goForwardGroup();
  else {
    var historyEntry;
    var popup = aEvent.originalTarget.parentNode;
    var tabContextMenu = (popup.parentNode.nodeName == "xul:menu") ? true : false; // Called from tab context menu?
    var sourceTab = tabContextMenu ? gBrowser.mContextTab : gBrowser.selectedTab;
    var browser = gBrowser.getBrowserForTab(sourceTab);
    var sessionHistory = browser.sessionHistory;

    if (aEvent && 'button' in aEvent && aEvent.button == 1) { // a middle-click on a history entry will be opened in a new tab!
      /* var popup = aEvent.originalTarget.parentNode;
      var tabContextMenu = (popup.parentNode.nodeName == "xul:menu") ? true : false; // Called from tab context menu?
      var sourceTab = tabContextMenu ? gBrowser.mContextTab : gBrowser.selectedTab;
      var browser = gBrowser.getBrowserForTab(sourceTab);
      var sessionHistory = browser.sessionHistory; */
      var sourceIndex = sessionHistory.index; // Backup index of sourceTab
      var newIndex = aEvent.originalTarget.getAttribute("index"); // Get selected index
      historyEntry = sessionHistory.getEntryAtIndex(newIndex, true); // This also updates the index!
      // Prevent blocked .jar and .xpi files to be loaded from history
      if (gMultiZilla.utility.isBlockedXPInstall(historyEntry.URI.spec))
        return false;
      // Don't allow blank tabs to be duplicated. What the heck is "about://blank/" ??
      if (historyEntry.URI.spec == "about:blank" || historyEntry.URI.spec == "about://blank/") {
        sessionHistory.getEntryAtIndex(sourceIndex, true); // Restore original index
        return false;
      }
      popup.hidePopup(); // Close the popup/menupopup/xul:menupopup

      if (tabContextMenu) {
        // Set menu item 'Tab History' inactive state and close tab context menu
        aEvent.target.parentNode.setAttribute("_moz-menuactive", false);
        popup = document.getElementById("tabContextMenu");
        popup.hidePopup();
      }
      gBrowser.duplicateTab(sourceTab, false);
      sessionHistory.getEntryAtIndex(sourceIndex, true); // Restore original index
      return true;
    }
    try {
      historyEntry = sessionHistory.getEntryAtIndex(index, true);
      // Previously blocked file should not be loaded from Go and Tab History
      if (gMultiZilla.utility.isBlockedXPInstall(historyEntry.URI.spec))
        return false;
      getWebNavigation().gotoIndex(index);
    }
    catch(ex) {
      // dump("\nOOPS: " + ex);
      return false;
    }
  }
  return true;
}

function ViewSourceGoToLine() // viewsource.js
{
  var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                                .getService(Components.interfaces.nsIPromptService);
  var viewSourceBundle = gMultiZilla.utility.getStringBundle("chrome://navigator/locale/viewSource.properties");
  var input = {value:gLastLineNumber};

  for (;;) {
    var ok = promptService.prompt(window, viewSourceBundle.GetStringFromName('goToLineTitle'),
                                  viewSourceBundle.GetStringFromName('goToLineText'), input, 
                                  null, {value:0});

    if (!ok) 
      return;

    var line = parseInt(input.value);

    if (!(line > 0)) {
      promptService.alert(window, viewSourceBundle.GetStringFromName('invalidInputTitle'),
                          viewSourceBundle.GetStringFromName('invalidInputText'));
      continue;
    }
    gLineNumber = line;
    var found = mzGoToLine();

    if (found) {
      break;
    }
    promptService.alert(window, viewSourceBundle.GetStringFromName('outOfRangeTitle'),
                        viewSourceBundle.GetStringFromName('outOfRangeText'));
  }
}

function getBrowserForDocument(aDocument)
{  
  const browsers = gBrowser.browsers;

  for (var i = 0; i < browsers.length; i++) {
    if (gBrowser.browsers[i].contentDocument == aDocument)
      return gBrowser.browsers[i];
    else if (content.frames.length > 0) {
      for (var frame_nr = 0; frame_nr < content.frames.length; frame_nr++) {
        if (content.frames[frame_nr].length > 0) { // deep nested frames
          if (isFrameDocumentContainer(content.frames[frame_nr], aDocument))
            return gBrowser.browsers[i];
        }
        if (content.frames[frame_nr].document == aDocument)
          return gBrowser.browsers[i];
      }
    }
  }
  return null;
}

function isFrameDocumentContainer(aFrame, aDocument)
{
  if (!aFrame || !aDocument)
    return false;

  for (var i = 0; i < aFrame.length; i++) {
    if (aFrame.frames[i].length > 0) {
      if (isFrameDocumentContainer(aFrame[i], aDocument)) // recursive call
        return true;
    }
    if (aFrame.frames[i].document == aDocument)
      return true;
  }
  return false;
}

nsBrowserStatusHandler.prototype.onSecurityChange = function(aWebProgress, aRequest, aState) 
{
  const wpl = Components.interfaces.nsIWebProgressListener;
  var secState = "";

  this.securityButton.removeAttribute("label");
  this.urlBar.removeAttribute("domain");

  switch (aState) {
    case wpl.STATE_IS_SECURE | wpl.STATE_SECURE_HIGH:
      secState = "high";
    case wpl.STATE_IS_SECURE | wpl.STATE_SECURE_LOW:
      if (secState == "") 
        secState = "low";
      this.securityButton.setAttribute("level", secState);

      if (this.urlBar)
        this.urlBar.setAttribute("level", secState);
      try {
        var cert = mzGetServerCert();

        if (cert.organization.indexOf("xn-") != -1)
          this.urlBar.setAttribute("domain", "check");

        if (gMultiZilla.prefs.readBoolean("multizilla.check.domain-names", true)) {
          var browser = getBrowserForDocument(gBrowser.contentWindow.document);
          var host = browser.docShell.currentURI.host;

          if (browser.lastSSLHost != host) {
            var idnService = Components.classes["@mozilla.org/network/idn-service;1"].getService(Components.interfaces.nsIIDNService);
            var isIDN = idnService.isACE(host);
            var ACEhost = isIDN ? host : idnService.convertUTF8toACE(host);
            var UTF8host = isIDN ? idnService.convertACEtoUTF8(host) : host;

            if (browser.lastSSLHost != ACEhost && browser.lastSSLHost != UTF8host) {
              var UTF8hostFound = !gMultiZilla.dnp.doIDNHistory(UTF8host, false, false, false);
              var ACEhostFound = !gMultiZilla.dnp.doIDNHistory(ACEhost, false, false, false);

              if (!isIDN && idnService.isACE(ACEhost))
                isIDN = true;
              if (isIDN)
                host = ACEhost;
              if (!UTF8hostFound && !ACEhostFound) {
                var numberOfKeys = gMultiZilla.dnp.doIDNHistory(null);
                gDomainChecker.onSSLChecked(browser, [host], true, isIDN, cert, numberOfKeys);
              }
              else {
                if (isIDN && !ACEhostFound && UTF8hostFound)
                  gMultiZilla.dnp.displaySSLPrompt(browser, [ACEhost, UTF8host], false, isIDN, cert);
                else if (!isIDN && ACEhostFound && !UTF8hostFound)
                  gMultiZilla.dnp.displaySSLPrompt(browser, [UTF8host, ACEhost], false, isIDN, cert);
              }
            }
            browser.lastSSLHost = host;
          }
        }
        this.securityButton.setAttribute("label", cert.organization);
      } catch(ex) {
        // dump("ex: " + ex);
      }
      break;
    case wpl.STATE_IS_BROKEN:
      this.securityButton.setAttribute("level", "broken");
      this.urlBar.setAttribute("level", "broken");
      break;
    case wpl.STATE_IS_INSECURE:
    default:
      this.securityButton.removeAttribute("level");
      this.urlBar.removeAttribute("level");
      break;
  }
  if (this.mzSecurityIcon == undefined)
    this.mzSecurityIcon = document.getElementById("mzSecurityIcon");

  var securityUI = getBrowser().securityUI;

  if (securityUI){
    if (securityUI.tooltipText) {
      this.securityButton.setAttribute("tooltiptext", securityUI.tooltipText);
      this.mzSecurityIcon.setAttribute("tooltiptext", securityUI.tooltipText);
    }
  }
  else {
    this.securityButton.removeAttribute("tooltiptext");
    this.mzSecurityIcon.removeAttribute("tooltiptext");
  }
}

nsBrowserStatusHandler.prototype.startDocumentLoad = function(aRequest) 
{
  const nsIChannel = Components.interfaces.nsIChannel;
  var urlStr = aRequest.QueryInterface(nsIChannel).URI.spec;
  var observerService = Components.classes["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

  gBrowser = getBrowser();
  gBrowser.userTypedClear++;
  gBrowser.mCurrentBrowser.feeds = null;

  try {
    observerService.notifyObservers(content, "StartDocumentLoad", urlStr);
  } catch(ex) {
  }
}

function mzGetServerCert()
{
  const nsISSLStatusProvider = Components.interfaces.nsISSLStatusProvider;
  const nsISSLStatus = Components.interfaces.nsISSLStatus;

  var sp = null;
  var status = null;
  var ui = gBrowser.securityUI;

  if (ui) {
    sp = ui.QueryInterface(nsISSLStatusProvider);
    if (sp)
      status = sp.SSLStatus;
  }
  if (status)
    status = status.QueryInterface(nsISSLStatus);
  if (status) {
    return status.serverCert;
  }
  return "";
}

function BrowserOpenTab()
{
  if (!gInPrintPreviewMode) {
    var uriToLoad;
    try {
      switch ( pref.getIntPref("browser.tabs.loadOnNewTab") )
      {
        case -1:
          var handler = Components.classes['@mozilla.org/commandlinehandler/general-startup;1?type=browser']
                                  .getService(Components.interfaces.nsICmdLineHandler);
          uriToLoad = handler.defaultArgs.split("\n")[0];
          if (!/\S/.test(uriToLoad))
            uriToLoad = "about:blank";
          break;
        case 1:
          uriToLoad = pref.getCharPref("browser.startup.homepage");
          break;
        case 2:
          uriToLoad = getWebNavigation().currentURI.spec;
          break;
        case 3: // MultiZilla specific code
          uriToLoad = pref.getCharPref("multizilla.preferred.location");
          break;
        default:
          uriToLoad = "about:blank";
          break;
      }
    } catch(ex) {
      uriToLoad = "about:blank";
    }
    gBrowser.selectedTab = gBrowser.addTab(uriToLoad);
    var navBar = document.getElementById("nav-bar");

    if (uriToLoad == "about:blank" && !navBar.hidden && window.locationbar.visible)
      setTimeout("gURLBar.focus();", 0);
    else
      setTimeout("content.focus();", 0);
  }
}

function BrowserSearchInternet()
{
  try {
    var searchEngineURI = pref.getCharPref("browser.search.defaultengine");
    var openNewTab = pref.getBoolPref("multizilla.newtabfor.websearch");

    if (searchEngineURI) {          
      var searchRoot = getSearchUrl("searchForm");

      if (searchRoot) {
        if (openNewTab)
          gBrowser.addOrGetTab(searchRoot);
        else
          loadURI(searchRoot);
        return;
      }
      else {
        // Get a search URL and guess that the front page of the site has a search form.
        var searchDS = Components.classes["@mozilla.org/rdf/datasource;1?name=internetsearch"]
                                 .getService(Components.interfaces.nsIInternetSearchService);
        var searchURL = searchDS.GetInternetSearchURL(searchEngineURI, "ABC", 0, 0, {value:0});

        if (searchURL) {
          searchRoot = searchURL.match(/[a-z]+:\/\/[a-z.-]+/);

          if (searchRoot) {
            if (openNewTab)
              gBrowser.addOrGetTab(searchRoot + "/");
            else
              loadURI(searchRoot + "/");
            return;
          }
        }
      }
    }
  } catch (ex) {
  }
  if (openNewTab)
    gBrowser.addOrGetTab(gNavigatorRegionBundle.getString("otherSearchURL"));
  else 
    loadURI(gNavigatorRegionBundle.getString("otherSearchURL"));
}

const gPopupBlockerObserver =
{
  _blockedWindowButton: null,
  _nsIPermissionManager: Components.interfaces.nsIPermissionManager,
  _multizillaBundle : gMultiZilla.utility.getStringBundle(),
  _popupInfoMessagePrefString : "multizilla.blocked-popup.show-info-message",
  _popupImageURL : "chrome://multiviews/content/images/blocked-window-menu-button.png",

  findChildShell: function(aDocShell, aSoughtURI)
  {
    var webNav = aDocShell.QueryInterface(Components.interfaces.nsIWebNavigation);

    if (webNav.currentURI.spec == aSoughtURI.spec)
      return aDocShell;
      
    var node = aDocShell.QueryInterface(Components.interfaces.nsIDocShellTreeNode);

    for (var i = 0; i < node.childCount; ++i) {
      var docShell = node.getChildAt(i);

      docShell = this.findChildShell(docShell, aSoughtURI);

      if (docShell == aSoughtURI)
        return docShell;
    }
    return null;
  },

  onUpdatePageReport: function(aBrowser)
  {
    if (!this._blockedWindowButton)
      this._blockedWindowButton = document.getElementById("blocked-windows-button");

    // if (gBrowser.mCurrentBrowser.mBlockedWindows)
    if (aBrowser.mBlockedWindows)
    {
      if (aBrowser == gBrowser.mCurrentBrowser)
        this._blockedWindowButton.setAttribute("blocked", "true");

      if (gMultiZilla.prefs.readBoolean(this._popupInfoMessagePrefString, true))
      {
        var messageString, tooltipString;
        // var blockedPopups = gBrowser.selectedBrowser.mNumberOfBlockedWindows;
        var blockedPopups = aBrowser.mNumberOfBlockedWindows;
        // var currentURI = gBrowser.selectedBrowser.webNavigation.currentURI;
        var currentURI = aBrowser.webNavigation.currentURI;
        var host = (currentURI.scheme == "file") ? "file:" : currentURI.hostPort;

        if (blockedPopups == 1) {
          messageString = this._multizillaBundle.formatStringFromName("popupWarning", [host], 1);
          tooltipString = this._multizillaBundle.GetStringFromName("blockedPopupTooltip");
          this._blockedWindowButton.setAttribute("tooltiptext", tooltipString);
        }
        else {
          messageString = this._multizillaBundle.formatStringFromName("popupWarningMultiple", [host, blockedPopups], 2);
          tooltipString = this._multizillaBundle.formatStringFromName("blockedPopupsTooltip", [blockedPopups], 1);
          this._blockedWindowButton.setAttribute("tooltiptext", tooltipString);
        }
        var notificationBox = gBrowser.getNotificationBox(aBrowser);
        var notification = notificationBox.getNotificationWithValue("popup-blocked");

        if (notification)
          notification.label = messageString;
        else {
          var buttons = [{
            label: this._multizillaBundle.GetStringFromName("popupWarningButton"),
            accessKey: this._multizillaBundle.GetStringFromName("popupWarningButton.accesskey"),
            popup: "blockedWindowsPopupmenu",
            callback: null
          }];

          const priority = notificationBox.PRIORITY_INFO_MEDIUM;
          notificationBox.appendNotification(messageString, "popup-blocked", this._popupImageURL, priority, buttons);
        }
      }
    }
    else
      this._blockedWindowButton.removeAttribute("blocked");
  },

  setPopupsPermission: function(aEvent)
  {
    var currentURI = gBrowser.selectedBrowser.webNavigation.currentURI;
    var url = (currentURI.scheme == "file") ? "file:" : currentURI.scheme + "://" + currentURI.hostPort.replace(/^www./, '');
    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                              .getService(Components.interfaces.nsIIOService);
    var uri = ioService.newURI(url, null, null);
    var shouldBlock = (aEvent.target.getAttribute("block") == "true");
    var permission = shouldBlock ? this._nsIPermissionManager.DENY_ACTION : this._nsIPermissionManager.ALLOW_ACTION;
    var pm = Components.classes["@mozilla.org/permissionmanager;1"].getService(this._nsIPermissionManager);
    pm.add(uri, "popup", permission);
    gBrowser.getNotificationBox().removeCurrentNotification();
  },
  
  fillPopupList: function(aEvent)
  {
    var currentURI = gBrowser.selectedBrowser.webNavigation.currentURI;
    var host; // = (currentURI.scheme == "file") ? "file:" : currentURI.hostPort;

    try {
      host = (currentURI.scheme == "file") ? "file:" : currentURI.hostPort;
    } catch(ex) {
      // No hostPort
      var url = currentURI.spec;
      if (url.match(/^javascript:/i))
        host = "javascript:";
    }
    var blockedPopupAllowSite = document.getElementById("blockedPopupAllowSite");

    try {
      blockedPopupAllowSite.removeAttribute("hidden");
      var pm = Components.classes["@mozilla.org/permissionmanager;1"].getService(this._nsIPermissionManager);

      if (pm.testPermission(currentURI, "popup") == this._nsIPermissionManager.ALLOW_ACTION) {
        var blockString = this._multizillaBundle.formatStringFromName("popupBlock", [host], 1);
        blockedPopupAllowSite.setAttribute("label", blockString);
        blockedPopupAllowSite.setAttribute("block", "true");
      }
      else {
        var allowString = this._multizillaBundle.formatStringFromName("popupAllow", [host], 1);
        blockedPopupAllowSite.setAttribute("label", allowString);
        blockedPopupAllowSite.removeAttribute("block");
      }
    }
    catch (ex) {
      blockedPopupAllowSite.setAttribute("hidden", "true");
    }
    var item = aEvent.target.lastChild;

    while (item && item.getAttribute("observes") != "blockedPopupsSeparator") {
      var next = item.previousSibling;
      item.parentNode.removeChild(item);
      item = next;
    }
    var pageReport = gBrowser.mCurrentBrowser.mBlockedWindows;
    var blockedPopupsSeparator;

    if (pageReport && pageReport.length > 0) {
      blockedPopupsSeparator = document.getElementById("blockedPopupsSeparator");
      blockedPopupsSeparator.removeAttribute("hidden");

      for (var i = 0; i < pageReport.length; ++i) {
        var menuitem = document.createElement("menuitem");
        var label = this._multizillaBundle.formatStringFromName("popupShowPopupPrefix", [pageReport[i].popupWindowURI.spec], 1);
        menuitem.setAttribute("label", label);

        if (pageReport[i].requestingWindow instanceof Components.interfaces.nsIURI)
          menuitem.setAttribute("requestingWindowURL", pageReport[i].requestingWindow.spec);
        else 
          menuitem.requestingWindow = pageReport[i].requestingWindow;

        menuitem.requestingDocument = pageReport[i].requestingWindow.document;
        menuitem.setAttribute("popupWindowURI", pageReport[i].popupWindowURI.spec);
        menuitem.setAttribute("popupWindowFeatures", pageReport[i].popupWindowFeatures);
        menuitem.setAttribute("popupWindowName", ('popupWindowName' in pageReport[i]) ? pageReport[i].popupWindowName : "");
        menuitem.setAttribute("oncommand", "gPopupBlockerObserver.showBlockedPopup(event);");
        aEvent.target.appendChild(menuitem);
      }
    }
    else {
      blockedPopupsSeparator = document.getElementById("blockedPopupsSeparator");
      blockedPopupsSeparator.setAttribute("hidden", "true");
    }
    var blockedPopupDontShowMessage = document.getElementById("blockedPopupDontShowMessage");
    var showMessage = gMultiZilla.prefs.readBoolean("privacy.popups.showBrowserMessage", true);
    blockedPopupDontShowMessage.setAttribute("checked", !showMessage);

    if (aEvent.target.localName == "popup")
      blockedPopupDontShowMessage.setAttribute("label", this._multizillaBundle.GetStringFromName("popupWarningDontShowFromMessage"));
    else
      blockedPopupDontShowMessage.setAttribute("label", this._multizillaBundle.GetStringFromName("popupWarningDontShowFromStatusbar"));
  },

  /* Backward compatibility with SeaMonkey v1.1.x versions */
  openBlockedPopup: function(aEvent)
  {
    var requestingWindowURI = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
    requestingWindowURI.spec = aEvent.originalTarget.getAttribute("requestingWindowURL");
    var popupWindowURI = aEvent.originalTarget.getAttribute("popupWindowURI");
    var features = aEvent.originalTarget.getAttribute("popupWindowFeatures");
    var shell = this.findChildShell(gBrowser.selectedBrowser.docShell, requestingWindowURI);
    var regexp = new RegExp();
    var newWinFeatures = features || "";
    var windowFeatures = [ "minimizable", "resizable", "close", "scrollbars" ];

    for (var i in windowFeatures) {
      newWinFeatures = newWinFeatures.replace(regexp.compile(windowFeatures[i]+'=(0|no|false)', 'ig'), windowFeatures[i]);

      if (newWinFeatures.indexOf(windowFeatures[i]) < 0)
        newWinFeatures = newWinFeatures ? newWinFeatures + ',' + windowFeatures[i] : windowFeatures[i];
    }
    if (shell) {
      var ifr = shell.QueryInterface(Components.interfaces.nsIInterfaceRequestor);
      var dwi = ifr.getInterface(Components.interfaces.nsIDOMWindowInternal);
      var notificationBox = gBrowser.getNotificationBox(); // defaults to tabbrowser.mCurrentBrowser
      gBrowser.selectedBrowser.contentDocument.defaultView.mouseClick = notificationBox.currentNotification;
      dwi.open(popupWindowURI, "", newWinFeatures);
    }
    else {
      // shell not found, but we should still be able to open this window!
      window.open(popupWindowURI, "", newWinFeatures);
    }
  },

  showBlockedPopup: function(aEvent)
  {
    var nwrEnabled = gMultiZilla.prefs.readBoolean("multizilla.window-open.redirector", false);

    if (nwrEnabled && Components.interfaces.nsIDOMPopupBlockedEvent.number == "{9e201104-78e9-4cb3-aff5-7f0a9cf446c0}") 
      this.openBlockedPopup(aEvent);
    else {
      var target = aEvent.target;
      var popupWindowURI = target.getAttribute("popupWindowURI");
      var features = target.getAttribute("popupWindowFeatures");
      var name = target.getAttribute("popupWindowName");
      var dwi = target.requestingWindow;

      // If we have a requesting window and the requesting document is
      // still the current document, open the popup.
      if (dwi && dwi.document == target.requestingDocument)
        dwi.open(popupWindowURI, name, features);
    }
  },
  
  editPopupSettings: function()
  {
    var host = "";

    try {
      var uri = gBrowser.selectedBrowser.webNavigation.currentURI;
      host = (uri.scheme == "file") ? "file:" : uri.host;
    }
    catch (ex) {
    }
    gMultiZilla.managers.openPermissionManager(host, "PopupsPrefTab", "PopupsSettingsTab");
  },
  
  dontShowMessage: function()
  {
    var showMessage = gMultiZilla.prefs.readBoolean(this._popupInfoMessagePrefString, true);
    var firstTime = gMultiZilla.prefs.readBoolean("multizilla.blocked-popup.firstTime", true);

    if (showMessage && firstTime)
      this._displayPageReportFirstTime();

    gMultiZilla.prefs.writeBoolean(this._popupInfoMessagePrefString, !showMessage);
    gBrowser.getNotificationBox().removeCurrentNotification();
  },

  _displayPageReportFirstTime: function ()
  {
    window.openDialog("chrome://multiviews/content/multizillaBlockedPopupInfo.xul", "_blank", "dependent");
  }
};
//////////////////////////////////////////////////////////////////////////
// function makeURL(aURL) was changed to makeURI(aURL, aOriginCharset)
// see also: https://bugzilla.mozilla.org/show_bug.cgi?id=160454
//////////////////////////////////////////////////////////////////////////
function makeURI(aURL, aOriginCharset)
{
  var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
  return ioService.newURI(aURL, aOriginCharset, null);
}

function checkForMiddleClick(node, event)
{
  if (event.button == 1) {
    eval(node.getAttribute("oncommand"));
    closeMenus(event.target);
  }
}

function closeMenus(node)
{
  if ("tagName" in node) {
   if (node.namespaceURI == "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul" && (node.tagName == "menupopup" || node.tagName == "popup"))
     node.hidePopup();
   closeMenus(node.parentNode);
  }
}

nsBrowserAccess.prototype =
{
  openURI: function openURI(aURI, aOpener, aWhere, aContext)
  {
    dump("\naOpener: " + aOpener);
    dump("\naWhere: " + aWhere);
    dump("\naContext: " + aContext);
    var loadflags = (aContext == nsIBrowserDOMWindow.OPEN_EXTERNAL) ? nsIWebNavigation.LOAD_FLAGS_FROM_EXTERNAL
                                                                    : nsIWebNavigation.LOAD_FLAGS_NONE;

    if (aWhere == nsIBrowserDOMWindow.OPEN_DEFAULTWINDOW) { // 0
      if (aContext == nsIBrowserDOMWindow.OPEN_EXTERNAL) // 1
        aWhere = pref.getIntPref("browser.link.open_external");
      else
        aWhere = pref.getIntPref("browser.link.open_newwindow");
    }
    var url = aURI ? aURI.spec : "about:blank";
    var referrer = aOpener ? aOpener.QueryInterface(nsIInterfaceRequestor).getInterface(nsIWebNavigation).currentURI : null;

    if (referrer)
      referrer = gMultiZilla.utility.spoofReferrer(url, referrer);

    switch (aWhere)
    {
      case nsIBrowserDOMWindow.OPEN_NEWWINDOW: // 2
        return window.openDialog(getBrowserURL(), "_blank", "all,dialog=no", url, null, referrer);

      case nsIBrowserDOMWindow.OPEN_NEWTAB: // 3
        var browser = null;

        if (pref.getBoolPref("multizilla.tabs.blank-tab-first"))
          browser = gMultiZilla.tabs.checkForBlankTab(gBrowser); // returns tab or null
        if (browser == null) {
          var newTab = gBrowser.addTab("about:blank", null, null, !pref.getBoolPref("browser.tabs.loadDivertedInBackground"));
          browser = newTab.linkedBrowser;
        }
        try {
          browser.loadURIWithFlags(url, loadflags, referrer);
        } catch(ex) {}
        return browser.contentWindow;

      default: // 0 = normal / 1 = current tab/window
        if (!aOpener) {
          gBrowser.loadURIWithFlags(url, loadflags);
          return content;
        }
        aOpener = aOpener.top;
        try {
          aOpener.QueryInterface(nsIInterfaceRequestor).getInterface(nsIWebNavigation).loadURI(url, loadflags, referrer, null, null);
        } catch(ex) {}
        return aOpener;
    }
  },

  isTabContentWindow: function isTabContentWindow(aWindow)
  {
    var browsers = gBrowser.browsers;

    for (var i = 0; browsers.item(i); i++) {
      if (browsers[i].contentWindow == aWindow)
        return true;
    }
    return false;
  }
}

window.browserDOMWindow = new nsBrowserAccess();

//////////////////////////////////////////////////////////////////////////
// This is a replacement for the same function in navigator.js because we 
// are only interested in popup sound and we do not show the popup icon!
//////////////////////////////////////////////////////////////////////////
function onPopupBlocked(aEvent)
{
  var playSound = pref.getBoolPref("privacy.popups.sound_enabled");

  if (playSound) {
    var soundURL = pref.getCharPref("privacy.popups.sound_url");
    mzPlaySound(soundURL);
  }
}

function getReferrer(doc) // contentAreaUtils.js
{
  var spoofing = gMultiZilla.prefs.readInteger("multizilla.refspoof.spoofing", 3);

  if (spoofing == 1)
    return(gMultiZilla.utility.getDocumentReferrer(doc));

  var sourceURL = null;

  if (doc == document)
    sourceURL = getContentFrameURI(document.commandDispatcher.focusedWindow);
  else if (doc)
    sourceURL = doc.location.href;

  return(gMultiZilla.utility.spoofReferrer(sourceURL, gMultiZilla.utility.getDocumentReferrer(doc)));
}

function loadURI(aURL, aReferrer, flags) /* navigator.js */
{
  if (aReferrer)
    aReferrer = gMultiZilla.utility.spoofReferrer(aURL, aReferrer);
  else 
    aReferrer = null;

  if (gMultiZilla.utility.isBlockedXPInstall(aURL))
    return;

  if (!flags)
    flags = nsIWebNavigation.LOAD_FLAGS_NONE;

  try {
    getWebNavigation().loadURI(aURL, flags, aReferrer, null, null);
  } catch (ex) {
    // dump('\nMZ error: loadURI("'+url+'") failed');
  }
}

function WindowIsClosing() // navigator.js
{
  var shouldClose = true;
  var browser = getBrowser();

  if (!browser.mChromeHidden) {
    var confirmForID = (gMultiZilla._closeConfirmationID != -1) ? gMultiZilla._closeConfirmationID
                                                                : 2; // -1 is Composer, Mail, Addressbook or the JS Console
    shouldClose = gMultiZilla.confirmCloseWS(confirmForID);

    if (shouldClose && gMultiZilla.utility.isLastWindow()) {
      gMultiZilla.cleanupOnExit()

      if (shouldClose == 2)
        return false;
    }
  }
  return shouldClose;
}

/***
  * XXX: We must (re)move the following functions from this file!!!
  */

function mzUpdateGroupmarkCommand()
{
  const disabled = (gBrowser.browsers.length == 1);
  document.getElementById("Browser:AddGroupmarkAs").setAttribute("disabled", disabled);
}

function mzFindLocation(pre, line, node, offset, interlinePosition, result) // viewsource.js
{
  if (node && !pre)
    for (pre = node; pre.nodeName != "PRE"; pre = pre.parentNode);

  var curLine = parseInt(pre.id.substring(4));
  var treewalker = window._content.document.createTreeWalker(pre, NodeFilter.SHOW_TEXT, null, false);
  var firstCol = 1;
  var found = false;

  for (var textNode = treewalker.firstChild(); textNode && !found; textNode = treewalker.nextNode()) {
    var lineArray = textNode.data.split(/\n/);
    var lastLineInNode = curLine + lineArray.length - 1;

    if (node ? (textNode != node) : (lastLineInNode < line)) {
      if (lineArray.length > 1)
        firstCol = 1;
      firstCol += lineArray[lineArray.length - 1].length;
      curLine = lastLineInNode;
      continue;
    }
    for (var i = 0, curPos = 0; i < lineArray.length; curPos += lineArray[i++].length + 1) {
      if (i > 0)
        curLine++;
      if (node) {
        if (offset >= curPos && offset <= curPos + lineArray[i].length) {
          if (i > 0 && offset == curPos && !interlinePosition) {
            result.line = curLine - 1;
            var prevPos = curPos - lineArray[i - 1].length;
            result.col = (i == 1 ? firstCol : 1) + offset - prevPos;
          } 
          else {
            result.line = curLine;
            result.col = (i == 0 ? firstCol : 1) + offset - curPos;
          }
          found = true;
          break;
        }
      } 
      else {
        if (curLine == line && !("range" in result)) {
          result.range = document.createRange();
          result.range.setStart(textNode, curPos);
          result.range.setEndAfter(pre.lastChild);
        } 
        else if (curLine == line + 1) {
          result.range.setEnd(textNode, curPos - 1);
          found = true;
          break;
        }
      }
    }
  }
  return found;
}

function mzSelectErrorInSource()
{
  window._content.focus();
  if (gLineNumber > 0)
    getBrowser().addEventListener("load", mzGoToLine, true);
  // We don't want the location bar focused!
  setTimeout(WindowFocusTimerCallback, 0, content);
}

function mzGoToLine() // viewsource.js
{
  var pre;
  var line = parseInt(gLineNumber);
  var viewsource = window._content.document.body;

  for (var lbound = 0, ubound = viewsource.childNodes.length; ; ) {
    var middle = (lbound + ubound) >> 1;
    pre = viewsource.childNodes[middle];
    var firstLine = parseInt(pre.id.substring(4));
    if (lbound == ubound - 1)
      break;
    if (line >= firstLine)
      lbound = middle;
	else
      ubound = middle;
  }
  var result = {};
  var found = mzFindLocation(pre, line, null, -1, false, result);

  if (!found)
    return false;

  var selection = window._content.getSelection();
  selection.removeAllRanges();
  selection.QueryInterface(nsISelectionPrivate).interlinePosition = true;
  selection.addRange(result.range);

  if (!selection.isCollapsed) {
    selection.collapseToEnd();
    var offset = result.range.startOffset;
    var node = result.range.startContainer;
    if (offset < node.data.length)
      selection.extend(node, offset);
    else {
      node = node.nextSibling ? node.nextSibling : node.parentNode.nextSibling;
      selection.extend(node, 0);
    }
  }
  var selCon = getBrowser().docShell
    .QueryInterface(Components.interfaces.nsIInterfaceRequestor)
    .getInterface(Components.interfaces.nsISelectionDisplay)
    .QueryInterface(nsISelectionController);  
  selCon.setDisplaySelection(nsISelectionController.SELECTION_ON);
  selCon.setCaretEnabled(true);
  selCon.setCaretVisibilityDuringSelection(true);
  selCon.scrollSelectionIntoView(nsISelectionController.SELECTION_NORMAL,
                                 nsISelectionController.SELECTION_FOCUS_REGION, true);

  getBrowser().removeEventListener("load", mzGoToLine, true);
  gLastLineNumber = gLineNumber;
  return true;
}

function mzWindowOpen(aURL, aName, aFlags)
{
  // Check type of 'aName' because it must be a string
  if (typeof(aName) == "number")
    aName = String(aName);
  else if (aName == undefined || aName == null || typeof(aName) != "string")
    aName = "";
  // Special case when _top/_self is used (see bug 17746)
  if (aName.match(/_top|_self/)) {
    window.loadURI(aURL);
    return window.gBrowser.selectedTab.linkedBrowser.contentDocument.defaultView;
  }
  return mzNWR(aURL, aName, aFlags, this);
}

function mzNWR(aURL, aName, aFlags, aWindow)
{
  const _ASK_ME = 4;
  var newWin = null;
  var askConfirmation = false;
  var window = aWindow;
  // var opener = new XPCNativeWrapper(window, "opener").opener;

  if (gMultiZilla.utility.isNavigatorWindow() && window.opener == null) {
    var document = window.document; // new XPCNativeWrapper(window, "document").document;
    // var defaultView = new XPCNativeWrapper(document, "defaultView").defaultView;
    var contextWindow = document.defaultView;
    var sourceURL = document.location.href; // new XPCNativeWrapper(document, "location").location.href;

    if (!aURL.match(/^\w+:/))
      aURL = makeURLAbsolute(sourceURL, aURL);

    const nsIScriptSecurityManager = Components.interfaces.nsIScriptSecurityManager;
    var secMan = Components.classes["@mozilla.org/scriptsecuritymanager;1"]
                           .getService(nsIScriptSecurityManager);

    try {
      secMan.checkLoadURIStr(sourceURL, aURL, nsIScriptSecurityManager.STANDARD);
    } catch(ex) {
      dump("\nex: " + ex);
      throw "mzWindowOpen(); Load of " + aURL + " denied.";
    }
    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                              .getService(Components.interfaces.nsIIOService);
    var sourceURI = ioService.newURI(sourceURL, null, null);
    var targetURI = ioService.newURI(aURL, null, null);
    var browser = aName ? mzGetNamedBrowser(aName) : null;

    if (browser) {
      newWin = browser.contentDocument.defaultView;
      // newWin.opener = contextWindow;
      browser.loadURI(aURL, sourceURI); // sourceURI is used as referrer
      gBrowser.selectedTab = gBrowser.getTabForBrowser(browser);
      return newWin;
    }
    var permissionmanager = Components.classes["@mozilla.org/permissionmanager;1"]
                                      .getService(Components.interfaces.nsIPermissionManager);
    var capability = permissionmanager.testPermission(sourceURI, "popup");

    if (capability == nsIPermissionManager.UNKNOWN_ACTION) // 0
      capability = gMultiZilla.prefs.readInteger("multizilla.window-open.behavior", 2);

    var hostPort;

    try {
      hostPort = (sourceURI.spec.match(/^file:/i)) ? "file:" : sourceURI.hostPort;
    } catch(ex) {
      // dump("\nError getting hostPort: " + sourceURI.spec);
      hostPort = sourceURI.spec;
    }
    var tab = null;
    var focusNewTab = !gMultiZilla.prefs.readBoolean("browser.tabs.loadInBackground", false);

    if ('mouseClick' in contextWindow && contextWindow.mouseClick) {
      var sourceElement = contextWindow.mouseClick;

      if (sourceElement.localName == "browser") {
        // dump("\nmouseClick is a 'browser', allow new window");
        browser = sourceElement;
        tab = gBrowser.getTabForBrowser(browser);
        var busy = tab.getAttribute("busy");
        sourceElement = undefined;

        if (busy) // && capability != nsIPermissionManager.ALLOW_ACTION)
          capability = nsIPermissionManager.DENY_ACTION; // ALLOW_ACTION;
      }
      else if (sourceElement.localName == "browsermessage") {
        // dump("\nOpen from a Browser Info Message, allow new window");
        browser = gBrowser.mTopTabs ? sourceElement.nextSibling : sourceElement.previousSibling;
        tab = gBrowser.getTabForBrowser(browser);
        sourceElement = undefined;

        if (capability != nsIPermissionManager.ALLOW_ACTION)
          capability = nsIPermissionManager.ALLOW_ACTION;
      }
      else if (contextWindow.mouseClick == false) {
        // dump("\nmouseClick is 'false', block new window!");
        capability = nsIPermissionManager.DENY_ACTION;
      }
      else if (contextWindow.mouseClick == undefined) {
        // dump("\nmouseClick is 'undefined', allow new window!");
        capability = nsIPermissionManager.ALLOW_ACTION;
      }
    }
    else {
      // Check permissions for targetURI
      // if (permissionmanager.testPermission(sourceURI, "popup") == nsIPermissionManager.ALLOW_ACTION) {
        var targetPM = permissionmanager.testPermission(targetURI, "popup");

        if (targetPM == nsIPermissionManager.UNKNOWN_ACTION)
          capability = gMultiZilla.prefs.readInteger("multizilla.window-open.behavior", 2);
        else
          capability = targetPM;
      /* }
      else
        capability = nsIPermissionManager.DENY_ACTION; */
    }
    if ('clickedOnJSLink' in contextWindow) { // clicked on a javascript: link!
      if (gMultiZilla.prefs.readBoolean("multizilla.window-open.javascript-in-tab", false)) {
        if (contextWindow.clickedOnJSLink) {
          focusNewTab = gMultiZilla.prefs.readBoolean("multizilla.window-open.javascript.loadInBackground", false);
          capability = 3;
        }
      }
      else if (contextWindow.clickedOnJSLink && contextWindow.clickedOnJSLink.localName == "browser") {
        // dump("\nclickedOnJSLink is a 'browser', open in a new tab?");
        browser = contextWindow.clickedOnJSLink;
        tab = gBrowser.getTabForBrowser(browser);
      }
      contextWindow.clickedOnJSLink = undefined;
    }
    // dump("\ncapability: " + capability);
    if (capability == _ASK_ME) { // Open dialog and ask what the user wants to do with this request
      askConfirmation = true;
      var previouslyBlocked = gMultiZilla.utility.isHostBlocked(getBrowserForDocument(contextWindow.document), hostPort);
      var selectionPrefValue = gMultiZilla.prefs.readInteger("multizilla.window-open.selection.behavior", 0);

      if (previouslyBlocked && selectionPrefValue == 1) {
        capability = nsIPermissionManager.DENY_ACTION;
      }
      else {
        if (tab)
          tab.setAttribute("dialog", "true");

        capability = gMultiZilla.confirmWindowOpen(hostPort);

        if (tab)
          tab.removeAttribute("dialog");

        if (capability & _ASK_ME) {
          capability -= _ASK_ME;
          permissionmanager.add(sourceURI, "popup", capability);
        }
      }
    }
    var charset = 'charset=' + window.document.characterSet;
    aName = aName ? aName : '_blank';

    if (capability == 3) { // Redirect this window to a new tab
      // dump("\nREDIRECT_ACTION");
      tab = gMultiZilla.tabs.preventDuplicate(aURL, false, getBrowser());

      if (!tab) {
        tab = gBrowser.addTab(aURL, sourceURI, charset, focusNewTab, null, null, aName, false);
        tab.linkedBrowser.contentWindow.top.opener = window;

        if (askConfirmation)
          tab.setAttribute("redirect-after-ask", "true");
      }
      browser = tab.linkedBrowser;
      return browser.contentDocument.defaultView;
    }
    else if (capability == nsIPermissionManager.DENY_ACTION) { // 2
      // dump("\nDENY_ACTION");
      // Construct popup object with the window properties
      var aPopupObject = new Object();
      aPopupObject.hostPort = hostPort;
      aPopupObject.requestingWindow = window;
      aPopupObject.requestingWindowURI = sourceURI;
      aPopupObject.popupWindowURI = targetURI;
      aPopupObject.popupWindowName = aName;
      aPopupObject.popupWindowFeatures = aFlags ? aFlags.replace(/(scrollbars|resizable|minimizable|close)(=(0|false|no))?,?/ig, '') : "";
      // dump("\npopupWindowFeatures-1: " + aPopupObject.popupWindowFeatures);
      /***
        * This event triggers mzOnPopupBlocked() and that function adds the URL to the
        * blocked popup window menu (right side of the statusbar) and calls mozilla's
        * onPopupBlocked() to play the popup sound
        */
      var URI = ioService.newURI(aURL, null, null);
      event = document.createEvent('PopupBlockedEvents');
      // SeaMonkey v1.1.4 = 9e201104-78e9-4cb3-aff5-7f0a9cf446c0
      // dump("\nNUMBER: " + Components.interfaces.nsIDOMPopupBlockedEvent.number);
      if (Components.interfaces.nsIDOMPopupBlockedEvent.number == "{9e201104-78e9-4cb3-aff5-7f0a9cf446c0}") {
        event.initPopupBlockedEvent('DOMPopupBlocked',
                                    true,
                                    true, 
                                    aPopupObject.requestingWindowURI,
                                    URI,
                                    aPopupObject.popupWindowFeatures);
      }
      else if (Components.interfaces.nsIDOMPopupBlockedEvent.number == "{bb57e9bb-0c89-459c-977d-5cbc1831bdf5}") {
        event.initPopupBlockedEvent('DOMPopupBlocked',
                                    true,
                                    true, 
                                    aPopupObject.requestingWindowURI,
                                    URI,
                                    aPopupObject.popupWindowName,
                                    aPopupObject.popupWindowFeatures);
      }
      else if (Components.interfaces.nsIDOMPopupBlockedEvent.number == "{05be571f-c3ea-4959-a340-c57b1591ae4b}") {
        event.initPopupBlockedEvent('DOMPopupBlocked',
                                    true,
                                    true, 
                                    aPopupObject.requestingWindow,
                                    URI,
                                    aPopupObject.popupWindowName,
                                    aPopupObject.popupWindowFeatures);
      }
      contextWindow.top.document.dispatchEvent(event);
      return this;
    }
    else if (capability == nsIPermissionManager.ALLOW_ACTION) { // 1
      // dump("\nALLOW_ACTION");
      var newWinFeatures = aFlags || "";

      if (gMultiZilla.prefs.readBoolean("multizilla.window-open.override-features", false) == true) {
        var regexp = new RegExp();
        var windowFeatures = [/*"chrome", "extrachrome",*/ "titlebar", "menubar", "toolbar",
                              "location", "personalbar", "directories", "minimizable",
                              "resizable", "close", "scrollbars", "status"];

        var overrideValue = gMultiZilla.prefs.readInteger("multizilla.window-open.features", 1985);
        // Check pref setting, but prevent jokers from disabling chrome and extrachrome!
        for (var i = 0; i < windowFeatures.length; i++) {
          if (/* i < 2 || */ overrideValue & (1 << i)) {
            newWinFeatures = newWinFeatures.replace(regexp.compile(windowFeatures[i]+'=(0|no|false)', 'ig'), windowFeatures[i]);

            if (newWinFeatures.indexOf(windowFeatures[i]) < 0) {
              var feature = windowFeatures[i] + "=yes";
              newWinFeatures = newWinFeatures ? newWinFeatures + ',' +  feature : feature;
            }
          }
        }
        // Make sure we have a minimum window height/width!
        if (newWinFeatures.indexOf("height") < 0) {
          var windowHeight = "height=" + String(window.innerHeight);
          newWinFeatures = newWinFeatures ? newWinFeatures + ',' + windowHeight : windowHeight;
        }
        if (newWinFeatures.indexOf("width") < 0) {
          var windowWidth = "width=" + String(window.innerWidth);
          newWinFeatures = newWinFeatures ? newWinFeatures + ',' + windowWidth : windowWidth;
        }
      }
      dump("\nOpen window: " + newWinFeatures);
      newWin = __mozilla__open(aURL, aName, newWinFeatures);
      newWin.opener = aWindow;
      return newWin;
    }
  }
  dump("\nopening the last resort window: " + aFlags);
  newWin = (aFlags !== void(0)) ? __mozilla__open(aURL, aName, (window.document.defaultView.top == window.top ? aFlags.replace(/(alwaysRaised|alwaysLowered|z-lock)(=(1|0|true|false|yes|no))?,?/ig, '') || void(0) : aFlags)) : __mozilla__open(aURL, aName);
  var notificationBox = gBrowser.getNotificationBox(); // defaults to tabbrowser.mCurrentBrowser
  gBrowser.selectedBrowser.contentDocument.defaultView.mouseClick = notificationBox.currentNotification;
  newWin.opener = aWindow;
  return newWin;
}

window.__mozilla__open = window.open; // called from 'newWindowRedirector' in tabbrowser.xml

if (window.open && gMultiZilla.prefs.readBoolean("multizilla.window-open.redirector", false)) {
  if (!gMultiZilla.utility.isNavigatorWindow())
    window.open = eval(mzWindowOpen.toSource());
}
