/***
  * The Developer of this Code is HJ van Rantwijk. Copyright
  * (C) 2001-2007 by HJ van Rantwijk.  All Rights Reserved.
  */

const uaPrefIdentifier = "multizilla.general.useragent.override";
const NO_ROWS_AVAILABLE      = -1;
const NO_ROWS_SELECTED       = 0;
const SINGLE_ROW_SELECTED    = 1;
const MULTIPLE_ROWS_SELECTED = 2;

var gManager;
var gPreferences;
var activeUserAgent = null;
/***
  * Toolbar button ID arrays that will be replaced with elements in updateToolbarButtons()
  * note: keep the order in-line with the corresponding XUL code!
  */
var toolbarButtons = [ "originalButton", "customButton", "addButton", "propertiesButton", "replaceButton", "modifyButton", "deleteButton", "prefsButton" ];
/***
  * Context Menu ID array that will be replaced with elements in initContextMenu(aEvent)
  * note: keep the order in-line with the corresponding XUL code!
  */
var contextMenuItems = [ "selectAll", "undoSelection", "selectDefaultUA", "selectCustomUA", "addUA", "replaceUA", "editUA", "removeUA" ];
/***
  * Toolbar button arrays, to ease the pain of enabling/disabling the buttons
  */
var defaultEnabledButtons      = [ false, false, false, false, false, false, false, true ];
var selectionEnabledButtons    = [ false, false, false,  true, false,  true,  true, true ];
var multipleRowsEnabledButtons = [ false, false, false, false, false, false,  true, true ];
var modifyEnabledButtons       = [ false, false,  true, false,  true, false, false, false ];

const DEFAULT_BUTTON    = 0;
const CUSTOM_BUTTON     = 1;
const ADD_BUTTON        = 2;
const PROPERTIES_BUTTON = 3;
const REPLACE_BUTTON    = 4;

const CM_SELECT_ALL  = 0;
const CM_SELECT_NONE = 1;
const CM_DEFAULT     = 2;
const CM_CUSTOM      = 3;
const CM_ADD         = 4;
const CM_REPLACE     = 5;
const CM_EDIT        = 6;
const CM_REMOVE      = 7;

function initFrame()
{
  gManager = window.top;
  gManager.selectWindowStyling(document.documentElement);
  var navigatorWindow = gManager.getNavigatorWindow(true);
  gPreferences = navigatorWindow.gMultiZilla.prefs;
}

function updateToolbarButtons()
{
  // Is the toolbar button array initialized?
  if (typeof toolbarButtons[0] == 'string') {
    // Nope, not yet, initialize array now
    for (i in toolbarButtons) {
      toolbarButtons[i] = document.getElementById(toolbarButtons[i]);
    }
  }
  var skipCustomDefault = false;
  var buttons = defaultEnabledButtons;
  var treeState = userAgentManager.getCurrentTreeState();

  if (textField.value != "") {
    skipCustomDefault = true;
    buttons = modifyEnabledButtons;
  }
  else if (treeState > NO_ROWS_SELECTED) {
    if (treeState == SINGLE_ROW_SELECTED)
      buttons = selectionEnabledButtons;
    else if (treeState == MULTIPLE_ROWS_SELECTED)
      buttons = multipleRowsEnabledButtons;
  }
  // Enable/disable the toolbar buttons based on the toolbar array
  for (i in toolbarButtons) {
    toolbarButtons[i].disabled = !buttons[i];
  }
  if (!skipCustomDefault) {
    // Enable/disable the 'Default' button on the toolbar
    toolbarButtons[DEFAULT_BUTTON].disabled = (activeUserAgent == null);
    // Enable/disable the 'Custom' button on the toolbar
    if (tree.treeBoxObject.view.rowCount > 0 && currentRow > -1) {
      var columnID = "UserAgentColumn";
      columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
      var onActiveUA = (tree.builderView.getCellText(currentRow, columnID) == activeUserAgent);
      toolbarButtons[CUSTOM_BUTTON].disabled = onActiveUA || (treeState != SINGLE_ROW_SELECTED);
    }
  }
  var hidden = (skipCustomDefault);
  toolbarButtons[PROPERTIES_BUTTON].hidden = hidden;
  toolbarButtons[REPLACE_BUTTON].hidden = !hidden;
  toolbarButtons[REPLACE_BUTTON].disabled = (!textField.edit);
  // buttons[REPLACE_BUTTON] = skipCustomDefault;

  var disabled = (currentUserAgent == activeUserAgent) || (treeState != SINGLE_ROW_SELECTED);
  gManager.document.documentElement.getButton("accept").disabled = (disabled || skipCustomDefault);
  var cancelButton = gManager.document.documentElement.getButton("cancel");
  cancelButton.label = (skipCustomDefault) ? "Cancel" : "Close";
}

function initContextMenu(aEvent)
{
  // Is the context menu item array initialized?
  if (typeof contextMenuItems[0] == 'string') {
    // Nope, not yet, initialize array now
    for (i in contextMenuItems) {
      contextMenuItems[i] = document.getElementById(contextMenuItems[i]);
    }
  }
  for (i in contextMenuItems) {
    contextMenuItems[i].setAttribute('disabled', 'true');
  }
  var treeState = userAgentManager.getCurrentTreeState();

  if (treeState == NO_ROWS_AVAILABLE)
    return;

  var treeRows = tree.treeBoxObject.view.rowCount;

  if (treeState == MULTIPLE_ROWS_SELECTED) {
    contextMenuItems[CM_SELECT_ALL].setAttribute('disabled', 'true');
    contextMenuItems[CM_SELECT_NONE].removeAttribute('disabled');
  }
  else { // NO_ROWS_SELECTED || SINGLE_ROW_SELECTED
    if (treeRows > 1 && textField.value == "") 
      contextMenuItems[CM_SELECT_ALL].removeAttribute('disabled');
    contextMenuItems[CM_SELECT_NONE].setAttribute('disabled', 'true');
  }
  var overrideUA;

  try {
    overrideUA = pref.getCharPref(uaPrefIdentifier);
  } catch(ex) { } // No User Agent override selected -> default UserAgent

  contextMenuItems[CM_DEFAULT].setAttribute('disabled', (activeUserAgent == null || textField.value != "") ? 'true' : 'false');

  if (treeState == NO_ROWS_SELECTED)
    return;

  contextMenuItems[CM_CUSTOM].setAttribute('disabled', (treeState == MULTIPLE_ROWS_SELECTED || activeUserAgent != null || textField.value != "") ? 'true' : 'false');
  contextMenuItems[CM_ADD].setAttribute('disabled', (textField.value == "") ? 'true' : 'false');
  contextMenuItems[CM_REPLACE].setAttribute('disabled', (textField.value == "" || textField.edit == false) ? 'true' : 'false');
  contextMenuItems[CM_EDIT].setAttribute('disabled', (treeState == MULTIPLE_ROWS_SELECTED || textField.value != "") ? 'true' : 'false');
  contextMenuItems[CM_REMOVE].setAttribute('disabled', (textField.value != "") ? 'true' : 'false');
}

function activatePropertiesFrame()
{
  if (tree.currentIndex > -1)
    gManager.switchPage("propertiesFrame");
}

function activateSettingsFrame()
{
  gManager.switchPage("settingsFrame");
}

function initTreeTooltip(aEvent)
{
  var node = document.tooltipNode;
  var nodeName = node.localName;
  var tooltipNode = aEvent.target;

  if (nodeName == 'tree' || nodeName.match('menu') || nodeName == 'treecol') {
    aEvent.preventDefault();
    return;
  }
  tooltipNode.firstChild.hidden = (nodeName != 'treecols');
  tooltipNode.childNodes[1].hidden = (nodeName != 'splitter');
  tooltipNode.lastChild.hidden = (nodeName != 'treechildren');
}

var userAgentManager = 
{
  tree: null,
  pref: null,
  uaEntries: null,
  uaContainer: null,
  currentRow: null,
  tabbrowser: null,
  textField: null,
  gStringBundle: null,
  currentUserAgent: null,
  /* dragStartRow: null, */
  mzRDF: "http://multizilla.mozdev.org/rdf#",

  initUserAgentManager: function()
  {
    tree = document.getElementById('userAgentManagerTree');
    mzRDFStore = mzGetNewOrCurrentDSByFilename("useragents.rdf", false, null, false);
    tree.database.AddDataSource(mzRDFStore);
    tree.builder.rebuild();
    uaContainer = mzRDFCUtils.MakeSeq(mzRDFStore, RDF.GetResource("urn:useragent-data:root"));
    gStringBundle = gManager.document.getElementById("properties");
    textField = document.getElementById('NewUserAgentField');
    textField.edit = false;
    currentUserAgent = null;
    currentRow = -1;
    /* dragStartRow = null; */
    tabbrowser = gManager.getTabbrowser(true);

    var prefService = Components.classes["@mozilla.org/preferences-service;1"]
                                .getService(Components.interfaces.nsIPrefService);
    pref = prefService.getBranch(null);
    activeUserAgent = gPreferences.readString(uaPrefIdentifier, "");
    setTimeout(userAgentManager.selectRow, 0);
    sizeToContent();
    updateToolbarButtons();

    if (tabbrowser.getPrefInitOnFailure("multizilla.uam.show-help-onstartup", "bool", true)) {
      var helpPages = gStringBundle.getString('helpPages-UserAgentManager');
      tabbrowser.addOrGetTab(helpPages);
    }
  },

  getRowNumber: function(aEvent)
  {
    var X = aEvent.pageX;
    var Y = aEvent.pageY;
    return tree.treeBoxObject.getRowAt(X, Y);
  },

  getSelectedRows: function()
  {
    var rows = -1;
    var selectedRows = new Array();
    // Get and return all selection ranges
    var rangeCount = tree.builderView.selection.getRangeCount();
    // Iterate over all ranges to collect the selected rows
    for (var range = 0; range < rangeCount; range++) {
      var startSelection = {};
      var endSelection = {};
      tree.builderView.selection.getRangeAt(range, startSelection, endSelection);
      // Collect all rows and store them in our array
      for (var row = startSelection.value; row <= endSelection.value; row++) {
        // Check for invalid row numbers
        if (startSelection.value != -1 || endSelection.value != -1)
          selectedRows[++rows] = row;
      }
    }
    return selectedRows;
  },

  getCurrentTreeState: function()
  {
    if (tree.treeBoxObject.view.rowCount < 1)
      return NO_ROWS_AVAILABLE;

    var selectedRows = this.getSelectedRows().length;

    if (selectedRows == 1)
      return SINGLE_ROW_SELECTED;
    else if (selectedRows > 1)
      return MULTIPLE_ROWS_SELECTED;
    return NO_ROWS_SELECTED;
  },

  selectRow: function()
  {
    var rows = tree.treeBoxObject.view.rowCount;

    for (var i = 0; i < rows; i++) {
      var columnID = "UserAgentColumn";
      columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
      var userAgent = tree.builderView.getCellText(i, columnID);

      if (userAgent == navigator.userAgent) {
        currentRow = i;
        tree.builderView.selection.toggleSelect(i);
        tree.treeBoxObject.ensureRowIsVisible(i);
        tree.focus();
        break;
      }
    }
  },
  
 /* moveEntries: function(sourceRow, targetRow)
  {
    if (sourceRow > 0 && targetRow > 0 && (sourceRow != targetRow)) {
      var columnID = "UserAgentColumn";
      columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
      var userAgent = tree.builderView.getCellText(sourceRow, columnID);
      uaEntries.RemoveElementAt(sourceRow, true);
      uaEntries.InsertElementAt(RDF.GetLiteral(userAgent), targetRow, true);
      this.doFlush();
      this.doInit();
    }
  }, */

  doAdd: function(addFlag, enterFlag)
  {
    currentUserAgent = textField.value;

    if (currentUserAgent == "")
      return;

    var targetRow = currentRow;
    // Is this a duplicated entry?
    if (uaContainer.IndexOf(RDF.GetLiteral(currentUserAgent)) > 0) {
      var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
      promptService.alert(window, gStringBundle.getString('uamDuplicatedItemTitle'), gStringBundle.getString('uamDuplicatedItemText'));
      return;
    }
    if (addFlag) {
      var targetPosition = tabbrowser.getPrefInitOnFailure("multizilla.uam.insert-new-items-at", "int", 3);

      switch(targetPosition) {
        case 0: targetRow = 1; // insert new items at start of tree
                break;
        case 1: targetRow = (currentRow > 0) ? (currentRow + 1) : 1; // insert new items before selected item in tree
                break;
        case 2: targetRow++; // insert new items after selected item in tree
                break;
        default: targetRow = (tree.treeBoxObject.view.rowCount + 1); // add new items at end of tree
      }
      this.addUserAgent(targetRow, "", currentUserAgent);

      if (targetRow > 1)
        targetRow--;
    }
    else if ('edit' in textField && textField.edit)
      this.editUserAgent(targetRow, null, currentUserAgent);

    tree.builderView.selection.select(targetRow);
    tree.treeBoxObject.ensureRowIsVisible(targetRow);

    if (!enterFlag) {
      textField.value = "";
      textField.edit = false;
      updateToolbarButtons();
      tree.focus();
    }
  },

  addUserAgent: function(aTargetRow, aShortName, aUserAgent)
  {
    var newNode = RDF.GetAnonymousResource();
    var container = mzRDFCUtils.MakeSeq(mzRDFStore, RDF.GetResource("urn:useragent-data:root"));

    mzRDFStore.Assert(newNode, RDF.GetResource(this.mzRDF + "ShortName"), RDF.GetLiteral(aShortName), true);
    mzRDFStore.Assert(newNode, RDF.GetResource(this.mzRDF + "UserAgent"), RDF.GetLiteral(aUserAgent), true);

    if (aTargetRow)
      container.InsertElementAt(newNode, aTargetRow, true);
    else
      container.AppendElement(newNode, true);
    this.doFlush();
  },

  editUserAgent: function(aTargetRow, aShortName, aUserAgent)
  {
    var property, currentValue, newValue;
    var resource = tree.builderView.getResourceAtIndex(aTargetRow).Value;
    resource = RDF.GetResource(tree.builderView.getResourceAtIndex(aTargetRow).Value);

    if (aShortName) {
      property = RDF.GetResource(this.mzRDF + "ShortName");
      currentValue = mzRDFStore.GetTarget(resource, property, true) || null;
      mzAddOrChangeValue(mzRDFStore, resource, property, currentValue, RDF.GetLiteral(aShortName));
    }
    if (aUserAgent) {
      property = RDF.GetResource(this.mzRDF + "UserAgent")
      currentValue = mzRDFStore.GetTarget(resource, property, true) || null;
      mzAddOrChangeValue(mzRDFStore, resource, property, currentValue, RDF.GetLiteral(aUserAgent));
    }
    this.doFlush();
  },

  removeUserAgent: function(aTargetRow)
  {
    var resource = RDF.GetResource(tree.builderView.getResourceAtIndex(aTargetRow).Value);
    var row = uaContainer.IndexOf(resource);
    uaContainer.RemoveElementAt(row, true);
    var property = RDF.GetResource(this.mzRDF + "ShortName");
    var data = mzRDFStore.GetTarget(resource, property, true);
    mzRDFStore.Unassert(resource, property, data);
    property = RDF.GetResource(this.mzRDF + "UserAgent")
    data = mzRDFStore.GetTarget(resource, property, true);
    mzRDFStore.Unassert(resource, property, data);
  },

  doEdit: function()
  {
    if (currentRow > -1) {
      textField.value = currentUserAgent;
      textField.edit = true;
      updateToolbarButtons();
      textField.focus();
    }
  },

  doRemove: function(skipLastResourceCheck)
  {
    var rows = this.getSelectedRows();

    if (rows.length) {
      var doRemove = -1;
      var confirmActionText = (rows.length > 1) ? 'uamRemoveMultipleItems' : 'uamRemoveSingleItem';
      var removeCurrentCheck = tabbrowser.getPrefInitOnFailure("multizilla.uam.prevent-delete-current", "bool", true);

      if (rows.length == 1 && removeCurrentCheck) {
        doRemove = this.checkCurrentRemoval(rows[0]);

        if (doRemove == false)
          return;
      }
      if (doRemove == -1 && !this.doConfirm(confirmActionText))
        return;

      for (var i = rows.length-1; i > -1; i--) {
        var row = (rows.length > 1) ? rows[i] : currentRow;

        if (removeCurrentCheck && doRemove == -1 && this.checkCurrentRemoval(rows[i]) == false)
          continue;
        try {
          this.removeUserAgent(row);
        } catch(ex) {
          // dump("\nex: " + ex);
          var removeItemFailed = gStringBundle.getString('uamRemoveItemFailed');
          alert(removeItemFailed);
        }
      }
      this.doFlush();
    }
    updateToolbarButtons();
  },

  checkCurrentRemoval: function(aTargetRow)
  {
    var columnID = "UserAgentColumn";
    columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;

    if (tree.builderView.getCellText(aTargetRow, columnID) == activeUserAgent)
      return this.doConfirm('uamRemoveCurrent');
    return -1;
  },

  doFlush: function()
  {
     mzRDFStore.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource).Flush();
     tree.builder.rebuild();
  },

  doSelect: function(aCommand, aRow)
  {
    switch (aCommand) {
      case "all": // Called from the context menu, or Ctrl+A ?
           tree.builderView.selection.selectAll();
           break;
      case "none": // Called from the context menu, or Ctrl+Z ?
           if (aRow == undefined)
             aRow = tree.currentIndex;
      case "row":
           tree.builderView.selection.clearSelection();
           tree.builderView.selection.select(aRow);
           break;
    }
    tree.focus();
  },

  doConfirm: function(additionalText)
  {
    var doAction = false;
    var dialogTitle = gStringBundle.getString('uamConfirmActionTitle');
    var dialogText = gStringBundle.getString('uamConfirmActionText');
    additionalText = gStringBundle.getString(additionalText);
    dialogText = dialogText.replace(/%S/, additionalText);
    var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService();

    promptService = promptService.QueryInterface(Components.interfaces.nsIPromptService);
    doAction = promptService.confirm(window, dialogTitle, dialogText);
    tree.focus();
    return doAction;
  },

  doActivate: function(selectDefault, closeManager)
  {
    if (selectDefault) {
      pref.setCharPref(uaPrefIdentifier, "");
      activeUserAgent = null;
      tree.currentIndex = -1;
      this.doSelect('none');
    }
    else if (currentUserAgent) {
      if (userAgentManager.getSelectedRows().length > 1)
        return;
      pref.setCharPref(uaPrefIdentifier, currentUserAgent);
      activeUserAgent = currentUserAgent;
      // tree.builderView.getResourceAtIndex(tree.currentIndex).Value); //.setAttribute("properties", "activated");
      // tree.contentView.getElementAtIndex(tree.currentIndex);
    }
    textField.value = "";
    updateToolbarButtons();

    tabbrowser = gManager.getTabbrowser(true);
    var aboutShow = tabbrowser.getPrefInitOnFailure("multizilla.uam.show-about-page", "bool", true);
    var aboutClose = tabbrowser.getPrefInitOnFailure("multizilla.uam.close-about-page", "bool", true);

    if (aboutShow && !(closeManager && aboutClose))
      tabbrowser.addOrGetTab("about:");
    if (closeManager)
      this.removeAboutTab();
    tree.focus();
  },

  onTextFieldKeypress: function(aEvent)
  {
    aEvent.stopPropagation();

    if (aEvent.keyCode == 13)
      userAgentManager.doAdd(!textField.edit, true);
    /* else if (aEvent.keyCode == 27) {
      textField.value = "";
      textField.edit = false;
      updateToolbarButtons();
      aEvent.keyCode == 27;
    } */
  },

  onClick: function(aEvent)
  {
    // if (aEvent.button != 2 && !aEvent.ctrlKey)
      // this.onSelect();
  },

  onSelect: function()
  {
    // dump("\nonSelect()");
    if (gManager.gPreloadStatus > 1) {
      var preLoadType = 2;

      if (gManager.gPreloadStatus & preLoadType)
        setTimeout(gManager.preLoad, 0, preLoadType);
    }
    currentRow = tree.currentIndex;

    if (currentRow > -1) {
      var columnID = "UserAgentColumn";
      columnID = ('columns' in tree) ? tree.columns[columnID] : columnID; 
      currentUserAgent = tree.builderView.getCellText(currentRow, columnID);
    }
    textField.value = "";
    textField.edit = false;
    updateToolbarButtons();
  },

  removeAboutTab: function()
  {
     var tabBrowser = gManager.getTabbrowser(true);

     if (tabBrowser.getPrefInitOnFailure("multizilla.uam.close-about-page", "bool", true)) {
       for (var i = 0; i < tabBrowser.mTabs.length; i++) {
         var tab = tabBrowser.mTabs[i];

         if (tab.hasAttribute("busy"))
           continue;
         if (tab.linkedBrowser.webNavigation.currentURI.spec == "about:")
           tabBrowser.removeTab(tab);
       }
     }
  },

  updateTextField: function updateTextField(aFlag)
  {
    if (aFlag) {
      textField.value = "";
      textField.edit = false;
      updateToolbarButtons();
      tree.focus();
    }
  }/* ,

  onDragStart: function(aEvent, aXferData, aDragSession)
  {
    if (tree.treeBoxObject.view.rowCount > 0) {
      // aEvent.target.setAttribute("dragover", "true");
      var X = aEvent.pageX;
      var Y = aEvent.pageY;
      dragStartRow = tree.treeBoxObject.getRowAt(X, Y);
      var columnID = "UserAgentColumn";
      columnID = ('columns' in tree) ? tree.columns[columnID] : columnID;
      currentUserAgent = tree.builderView.getCellText(dragStartRow, columnID);

      if (dragStartRow > -1) {
        aXferData.data = new TransferData();
        aXferData.data.addDataForFlavour("text/unicode", currentUserAgent);
      }
    }
  },

  onDragOver: function(aEvent, aXferData, aDragSession)
  {
    var X = aEvent.pageX;
    var Y = aEvent.pageY;
    var row = tree.treeBoxObject.getRowAt(X, Y);

    if (row > -1)
      aDragSession.canDrop = true;
  },

  onDrop: function(aEvent, aXferData, aDragSession)
  {
  },

  onDragExit: function(aEvent, aXferData, aDragSession)
  {
    var X = aEvent.pageX;
    var Y = aEvent.pageY;
    var row = tree.treeBoxObject.getRowAt(X, Y);

    if (row > -1) {
      this.moveEntries((dragStartRow + 1), (row + 1));
    }
    tree.childNodes[1].removeAttribute("dragover");
  },

  getSupportedFlavours: function ()
  {
    var flavourSet = new FlavourSet();
    flavourSet.appendFlavour("text/unicode");

    return flavourSet;
  },

  canDrop: function (aEvent, aDragSession)
  {
    aDragSession.canDrop = true;
    return true;
    // Allow drops from within User Agent Manager only!
    var doc = aDragSession.sourceNode.ownerDocument;
    var elem = doc.getElementById("userAgentManagerWindow");
    return true; // (elem && (elem.getAttribute("windowtype") == "multizilla:useragent-manager"));
  } */
};

function reFocus()
{
  updateToolbarButtons();
}

function shutdown()
{
  userAgentManager.removeAboutTab();
}

function onCancel(aEvent)
{
  if (textField.edit) {
    userAgentManager.updateTextField(true);
    return false;
  }
  return true;
}

function onAccept(aEvent)
{
  userAgentManager.doActivate(false, false);
  return false;
}

function onPageShow()
{
  userAgentManager.initUserAgentManager();
}

addEventListener("pageshow", onPageShow, true);
// addEventListener("load", userAgentManager.initUserAgentManager, false);
