var XPInstallConfirm = 
{
  _installCountdown: 2,
  _installCountdownInterval: -1,
  _param: null,
  _bundle: null,
  _navigatorWindow : null,
  _XPInstallObserver : null,
  _securityUI: null
};

XPInstallConfirm.init = function ()
{
  this._param = window.arguments[0].QueryInterface(Components.interfaces.nsIDialogParamBlock);
  if (!this._param)
    close();
 
  this._param.SetInt(0, 1); // The default return value is "Cancel"
  this._bundle = document.getElementById("xpinstallConfirmStrings");   
  var itemList = document.getElementById("itemList");
  var numItemsToInstall = this._param.GetInt(1);
  var uri = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService();
  var windowManagerInterface = windowManager.QueryInterface(Components.interfaces.nsIWindowMediator);
  this._navigatorWindow = windowManagerInterface.getMostRecentWindow("navigator:browser");
  this._XPInstallObserver = this._navigatorWindow.gMultiZilla._observer_XPInstall;
  var odd = 1;

  for (var i = 0; i < numItemsToInstall; ++i) {
    var installItem = document.createElement("installitem");
    itemList.appendChild(installItem);
    installItem.name = this._param.GetString(i);
    uri.spec = this._param.GetString(++i);
    installItem.host = (uri.scheme == "file") ? "file:" : uri.scheme + "://" + uri.hostPort;
    installItem.prettyHost = installItem.host.replace(/^\s*([-\w]*:\/+)?/, "");
    installItem.url = uri.spec;
    var iconURL = this._param.GetString(++i);

    var browser = this._navigatorWindow.gBrowser.mCurrentBrowser;

    if (iconURL != "") {
      var saveIconURI = true;
      var iconURI = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
      iconURI.spec = iconURL;

      try {
        const secMan = Components.classes["@mozilla.org/scriptsecuritymanager;1"].getService(Components.interfaces.nsIScriptSecurityManager);
        const nsIScriptSecMan = Components.interfaces.nsIScriptSecurityManager;

        if ('DISALLOW_SCRIPT_OR_DATA' in nsIScriptSecMan)
          secMan.checkLoadURI(uri, iconURI, nsIScriptSecMan.DISALLOW_SCRIPT_OR_DATA);
      } catch(ex) {
        saveIconURI = false;
        var securityWarningTitle = this._bundle.getString("restrictedIconURIWarning.title");
        var securityWarningText = this._bundle.getFormattedString("restrictedIconURIWarning.text", [installItem.name], 1);
        var promptService = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].getService(Components.interfaces.nsIPromptService);
        promptService.alert(window.opener, securityWarningTitle, securityWarningText);
      }
      if (saveIconURI) {
        installItem.icon = iconURI.spec;
      }
    }
    var cert = this._param.GetString(++i);
    installItem.cert = cert || this._bundle.getString("Unsigned");
    installItem.signed = cert ? "true" : "false";
    // Add a bit of additional styling for odd entries
    installItem.odd = (odd & 1) ? "true" : "false";
    odd++;
    var originatingHost;
    // Is this a cross domain installations?
    try {
      if (installItem.prettyHost == "file:") // local files are special
        originatingHost = installItem.prettyHost;
      else 
        originatingHost = browser.currentURI.hostPort;
    } catch(ex) {
      originatingHost = browser.currentURI.scheme;
    }
    if (originatingHost != installItem.prettyHost)
      installItem.check = true;
    // Is this site blocked?
    try {
      if (this._XPInstallObserver.getXPInstallPermission(installItem.prettyHost) == 2)
        installItem.blocked = true;
    } catch(ex) {
      // die silently
    }
  }

  var introString = this._bundle.getString("itemWarningIntroSingle");
  if (numItemsToInstall > 4)
    introString = this._bundle.getFormattedString("itemWarningIntroMultiple", [numItemsToInstall / 4]);
  document.getElementById("itemWarningIntro").setAttribute("value", introString);  
  
  var okButton = document.documentElement.getButton("accept");
  okButton.label = this._bundle.getFormattedString("installButtonDisabledLabel", [this._installCountdown]);
  okButton.disabled = true;
  okButton.focus();
  
  this._installCountdownInterval = setInterval("XPInstallConfirm.okButtonCountdown()", 1000);
}
    
XPInstallConfirm.okButtonCountdown = function ()
{
  var okButton = document.documentElement.getButton("accept");
  var bundle = document.getElementById("xpinstallConfirmStrings");
  if (this._installCountdown-- <= 1) {
    okButton.label = this._bundle.getString("installButtonLabel");
    okButton.disabled = false;
    clearInterval(this._installCountdownInterval);
  }
  else
    okButton.label = this._bundle.getFormattedString("installButtonDisabledLabel", [this._installCountdown]);
}

XPInstallConfirm.onAccept = function ()
{
  this._XPInstallObserver = null;
  this._param.SetInt(0, 0);
  return true;
}

XPInstallConfirm.onCancel = function ()
{
  this._XPInstallObserver = null;
  this._param.SetInt(0, 1);
  return true;
}

XPInstallConfirm.downloadFile = function (aURL)
{
  var sourceURI = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
  sourceURI.spec = aURL;

  var dir = "";
  var prefs = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);

  try {
    var branch = prefs.getBranch("browser.download.");
    dir = branch.getComplexValue("dir", Components.interfaces.nsILocalFile);
  } catch(ex) {
  }
  const nsIFilePicker = Components.interfaces.nsIFilePicker;
  var filePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
  this._bundle = document.getElementById("xpinstallConfirmStrings");  
  filePicker.init(window.opener, this._bundle.getString("filePickerTitle"), nsIFilePicker.modeSave);

  filePicker.appendFilter(this._bundle.getString("extensionFilter"), "*.xpi");
  filePicker.defaultString = aURL.substring(aURL.lastIndexOf('/') + 1, aURL.length);
  filePicker.displayDirectory = dir;

  if (filePicker.show() == nsIFilePicker.returnCancel || !filePicker.file) {
    return;
  }
  // 'C:\downloads\multiviews-v1701.xpi' -> 'file:///C:/downloads/multiviews-v1701.xpi'
  var ioService = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces.nsIIOService);
  var fileHandler = ioService.getProtocolHandler("file").QueryInterface(Components.interfaces.nsIFileProtocolHandler);
  var url = fileHandler.getURLSpecFromFile(filePicker.file);
  var targetURI = ioService.newURI(url, null, null);
  // nsIWebBrowserPersist.idl handles just about anything we need
  var persist = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"].createInstance(Components.interfaces.nsIWebBrowserPersist);
  const nsIWBP = Components.interfaces.nsIWebBrowserPersist;
  persist.persistFlags = nsIWBP.PERSIST_FLAGS_BYPASS_CACHE;
  // Backward compatibility, see also https://bugzilla.mozilla.org/show_bug.cgi?id=160454
  if ('PERSIST_FLAGS_AUTODETECT_APPLY_CONVERSION' in persist)
    persist.persistFlags |= nsIWBP.PERSIST_FLAGS_AUTODETECT_APPLY_CONVERSION;
  persist.persistFlags != nsIWBP.PERSIST_FLAGS_REPLACE_EXISTING_FILES;
  // Backward compatibility, see also https://bugzilla.mozilla.org/show_bug.cgi?id=28113
  const _CONTRACTID = ("@mozilla.org/transfer;1" in Components.classes) ? "@mozilla.org/transfer;1" : "@mozilla.org/download;1";
  var transfer = Components.classes[_CONTRACTID].createInstance(Components.interfaces.nsITransfer);
  /***
    * Initialize the file transfer and save URI to localfile
    * note: nsITransfer.idl needs an extra parameter since revision 1.5 so
    *       we need the following check to maintain backward compatibility
    *       see also https://bugzilla.mozilla.org/show_bug.cgi?id=298842
    */
  if (Components.interfaces.nsITransfer.number == "{23c51569-e9a1-4a92-adeb-3723db82ef7c}")
    transfer.init(sourceURI, targetURI, null, null, null, null, persist);
  else
    transfer.init(sourceURI, targetURI, null, null, null, persist);
  persist.progressListener = transfer;
  persist.saveURI(sourceURI, null, null, null, null, targetURI);
}
