<?
//   XUL Webmail, a web based mailclient
//
//   Copyright (C) 2004 Wouter van Wijk (wvw a@t dds.nl)
//   Copyright (C) 2004-05 Achim J. Latz (xwm a@t latz.org)
//
//   This program is free software; you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation; either version 2 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// session check
include('settings.php');
session_start();
if (!isset($_SESSION['user']))
{
	header("Location: error.php?ec=2");
	exit;
}
   $mailbox=$_GET['mailbox'];
   $internal_id=$_GET['id'];
   $action=$_GET['action'];

   $subject = "";
    $to = "";
    $replyto = "";
    $from = "";
    $cc = "";
    $headers = "";
    $body = "";
	    
    /**
	Gets a message from imap/pop3, not required for composing new messages!
     */
    
    if (($action == "reply") || ($action == "replyall") || ($action == "forward")) {
	$message = New message($_SESSION['server'].$mailbox, $_SESSION['user'], $_SESSION['pass'], $internal_id);

	$subject = $message->getSubject();
	$from = $message->getFrom();
	$replyto = $message->getReplyTo();
	$cc = $message->getTo();
	if ($message->hasCC())  {
		$cc .= $message->getCC();
	}
    }
    
    // if we do not replytoall, delete CC recipients
    if ($action == "reply") {
	    $cc = "";
    }
    
    if (($action == "reply") || ($action == "replyall")) {
	
	$to = $message->getReplyTo();

	$subject = $message->getReSubject();

	$body .= $message->getReplyBody();

    } else if ($action == "forward") {
	    $subject = $message->getForwardSubject();
	    $body = $message->getForwardBody();
	    $cc = "";
	    $to = "";
    }

    // $body = str_replace("\n", "<br />", ($body));
   
header ("Content-type: application/vnd.mozilla.xul+xml; charset=iso-8859-15");
echo '<' . '?xml version="1.0" encoding="iso-8859-15" ?' . '>';
echo '<' . '?xml-stylesheet href="chrome://global/skin/" type="text/css"?' . '>' . "\n";
echo '<' . '?xml-stylesheet href="composemail.css" type="text/css"?' . '>' . "\n";
?>

<window title="Compose Mail - XULWebmail"
		id = "composewindow"
		persist="screenX screenY width height"
        xmlns:html="http://www.w3.org/1999/xhtml"
        xmlns="http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul" onload="init();">

	<script type="application/x-javascript">

<![CDATA[

// Focus the TO text field and insert the original text in case of a reply or forward
	function init() {

		body = '<?  echo sanitizeText($body); ?>';
		// alert(body);
		document.getElementById('message').value = body;

		//document.getElementById('message').value = "1\n2\n3\n4";
		document.getElementById('to').focus();
		document.getElementById('appcontent').addEventListener('keypress',keypress,false);

		document.getElementById('to').focus();
	}
	
	
	// Copyright (c) 2002-2004 Alex King
	// http://www.alexking.org/blog/2003/06/02/inserting-at-the-cursor-using-javascript/
	//
	// Licensed under the LGPL license
	// http://www.gnu.org/copyleft/lesser.html
	function edInsertContent(myField, myValue) {
		if (myField.selectionStart || myField.selectionStart == '0') {
			var startPos = myField.selectionStart;
			var endPos = myField.selectionEnd;
			myField.value = myField.value.substring(0, startPos) + myValue + myField.value.substring(endPos, myField.value.length);
			myField.setSelectionRange( startPos + myValue.length,  startPos + myValue.length );
		} else {
			myField.value += myValue;
		}
	}

	//used in the message text box to avoid that a TAB key takes away the focus
	function keypress(evt) {
		var keyCode = evt.keyCode || evt.which;
		if ((keyCode == 9)) {
			// TAB is pressed, let's check if it is NOT Shift-TAB to navigate BACK
			if (!evt.shiftKey) { 
				// OK, it is tab. 
				// Prevent the focus shift 
				var controller = document.commandDispatcher;
				controller.rewindFocus();
				// insert the actual TAB character in the textbox
				edInsertContent(document.getElementById('message'), "\t");
				return true;
			}
		}
	}

]]>

	</script>

	<script type="application/x-javascript" src="xulwebmail.js" />

<keyset>
  <key id="close_cmd" keycode="VK_ESCAPE" observers="cmd_close"/>
  <key id="delete_cmd" keycode="VK_DELETE" observes="cmd_delete"/>
</keyset>

<commandset>
<command label="Send" id="cmd_send" state="false" oncommand="submitMessage();"  tooltiptext="Send this message" />
<command label="Save" id="cmd_save" state="false" oncommand="saveMessage();" hidden="true" tooltiptext="Save this message" />
<command label="Address" id="cmd_address" state="false" oncommand="showAddresses();" hidden="true" tooltiptext="Show address book" />
<command label="Attach" id="cmd_attach" state="false" oncommand="attachToMessage();" tooltiptext="Attach a file to this message" />
<command label="Delete" id="cmd_delete" state="false" oncommand="deleteAttachment();"/>
<command id="cmd_about" label="About XUL Webmail" state="false" oncommand="showAbout();"/>
</commandset>

<vbox flex="1">
  <toolbox id="non-functioning-toolbox">

    <menubar>
      <menu  id="my-menubar"  label="File" accesskey="F" >
        <menupopup>
<!--
          <menuitem label="New Message" />
           <menuitem label="Save" />
               <menuseparator />
           <menuitem label="Print Preview" />
           <menuitem label="Print" />

           <menuseparator />
-->
           <menuitem observes="cmd_send" />
           <menuseparator />
           <menuitem label="Close" oncommand="window.close();" />
        </menupopup>
      </menu>
<!--      
	<menu label="Edit" accesskey="E">
        <menupopup>
           <menuitem label="Undo" />
           <menuitem label="Redo" />
               <menuseparator />
        <menuitem label="Cut" />
           <menuitem label="Copy" />
           <menuitem label="Paste" />
           <menuitem label="Delete" />
               <menuseparator />
           <menuitem label="Select" />
               <menuseparator />
           <menuitem label="Find" />
        </menupopup>
      </menu>
      <menu label="Options" accesskey="O">
        <menupopup>
           <menuitem label="Priority" />
           <menuitem label="Security" />
           <menuitem label="Return Receipt" />
           <menuitem label="Quote" />
        </menupopup>
      </menu>
      <menu label="Tools" accesskey="T">
        <menupopup>
           <menuitem label="Address Book" />
               <menuseparator />
           <menuitem label="Options" />
        </menupopup>
      </menu>
-->
      <menu label="Help" accesskey="H">
        <menupopup>
		<menuitem observes="cmd_about" />
        </menupopup>
      </menu>

    </menubar>

    <toolbar id="main-toolbar" >
      <toolbarbutton id="button-send" class="toolbarbutton-1"  observes="cmd_send"/>
      <toolbarspacer />
      <toolbarbutton  id="button-address" class="toolbarbutton-1"  observes="cmd_address"/>
      <toolbarspacer />
      <toolbarbutton id="button-save" class="toolbarbutton-1" observes="cmd_save" />
      <toolbarbutton id="button-attach" class="toolbarbutton-1"  observes="cmd_attach" />
      <toolbarspacer />
    </toolbar>

  </toolbox>



    <vbox flex="1">
    <toolbox id="headers-box" class="toolbox-top" mode="icons">
    <toolbar id="MsgHeadersToolbar" persist="collapsed" flex="1"
             tborient="vertical" tbalign="stretch">
      <vbox id="msgheaderstoolbar-box" flex="1">
          <hbox align="center">
            <label value="To" accesskey="T" control="to"/>
            <textbox id="to" flex="1" value="<? echo htmlspecialchars(mime_decode($to)); ?>" 
	    />
          </hbox>
          <hbox align="center">
            <label value="CC" accesskey="C" control="cc"/>
            <textbox id="cc" flex="1" value="<? echo htmlspecialchars(mime_decode($cc)); ?>" />
          </hbox>
          <hbox align="center">
            <label value="BCC" accesskey="B" control="bcc"/>
            <textbox id="bcc" flex="1" value="<? echo htmlspecialchars(mime_decode($bcc)); ?>" />
          </hbox>
          <hbox align="center">
            <label value="Subject" accesskey="S" control="subject"/>
            <textbox id="subject" flex="1" class="toolbar" disableonsend="true" value="<? echo htmlspecialchars(mime_decode($subject)); ?>" />
          </hbox>
        </vbox>
		<splitter state="open" collapse="before" resizebefore="closest" resizeafter="closest" id="attachmentbucket-sizer" hidden="true" />
        <vbox id="attachments-box" align="left" hidden="true" >
    	      <label value="Attachments" accesskey="A" control="attachmentBucket" flex="1" seltype="multiple" />
	    	  <listbox id="attachmentBucket" flex="1" rows="4" seltype="multiple"/>
		</vbox>
    </toolbar>


  </toolbox>

<!--  <splitter id="compose-toolbar-sizer" onmousedown="awSizerListen()" collapse="after"/>  -->

  <!-- The mail message body frame -->
  
  <vbox id="appcontent" flex="1">
       <textbox class="body" id="message" flex="1" multiline="true"/>
  </vbox>
  
  <vbox id="appcontent" flex="1" hidden="true">

  <html:form id="htform" method="POST" enctype="multipart/form-data" action="sendmessage.php">
<html:input type="input" name="subject" id="htsubject" />
<html:input type="input" name="to" id="htto" />
<html:input type="input" name="cc" id="htcc" />
<html:input type="input" name="bcc" id="htbcc" />
<html:textarea name="message" id="htmessage" />
<html:input type="input" name="attachment" id="htattachment" />
<html:input type="submit" value="" />
</html:form>
  </vbox>

  </vbox>

</vbox>

<statusbar>
  <statusbarpanel  id="statusbar" flex="1" label="SESSION: <?=$_SESSION['server'].$mailbox." ".$_SESSION['user']." ".$_SESSION['realname']." ".$_SESSION['email'] ?>" />
  <progressmeter id="uploadprogress" mode="determined" value="100%" />
</statusbar>

</window>

