/* u_1_22.c:    Undefined behaviors on generating invalid pp-token by ##
        operator.   */

#include    <stdio.h>
#define str( a)     # a

main( void)
{

/* u.1.22:  Result of ## operator is not a valid pp-token.  */
#define NUM( dig, exp)  dig ## E+ ## exp
/*
 *   "E+" is a sequence of two pp-tokens "E" and "+", not a single pp-token.
 * The first ## concatenates the last pp-token of first argument with "E",
 * and the second ## concatenates "+" with the first pp-token of the second
 * argument.
 *   While "12E" (one of the sequence generated by the token concatenation)
 * is a valid pp-token, "+34" (the another sequence) is not a valid pp-token
 * and causes an undefined behavior.
 */
    printf( "%e\n", NUM( 12, 34));

    return  0;
}

