'''
Faraday Penetration Test IDE
Copyright (C) 2013  Infobyte LLC (http://www.infobytesec.com/)
See the file 'doc/LICENSE' for the license information

'''

import pytest


@pytest.mark.skip(reason='occassionaly timeouts')
@pytest.mark.usefixtures('logged_user')
class TestGetExploits():
    def test_get_exploit(self, test_client):
        cve_id = "CVE-2018-1999045"
        res = test_client.get(f'v3/vulners/exploits/{cve_id}')
        assert res.status_code == 200

    @pytest.mark.skip()
    def test_key_error(self, test_client):
        cve_id = "CVE-2018-1999035ERROR"
        res = test_client.get(f'v3/vulners/exploits/{cve_id}')
        assert res.status_code == 400

    @pytest.mark.skip()
    def test_get_exploit_with_modules(self, test_client):
        cve_id = "CVE-2016-9299"
        res = test_client.get(f'v3/vulners/exploits/{cve_id}')
        assert res.status_code == 200
        assert res.json.get('metasploit') != []
        assert res.json.get('exploitdb') != []
