/* Small tool to dump information about your Video devices */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include "devices/VideoCollector.h"
#include "devices/VideoAudioInput.h"

int main(int argc, char *argv[])
{
   CVideoCollector *vcoll = CVideoCollector::Instance();
   CVideoDevice *vd;
   CVideoDeviceInput *vdi;
   CVideoDeviceTuner *vdt;
   CVideoAudioInput  *vai;
   int dev, inp, anp, tun;
   int i, j, k;
   QSize sz;

   dev = vcoll->NumberOfVideoDevices();
   printf("Detected %d Video4Linux devices.\n", dev);
   for (i = 0; i < dev; i++) {
      vd = vcoll->GetVideoDevice(i);
      printf("Device node      : %s\n", (const char *)vd->GetNodeName());
      printf("Name of device   : \"%s\"\n", (const char *)vd->GetIntfName());
      sz = vd->GetMinSize();
      printf("Minimum size     : %dx%d\n", sz.width(), sz.height());
      sz = vd->GetSize();
      printf("Current size     : %dx%d\n", sz.width(), sz.height());
      sz = vd->GetMaxSize();
      printf("Maximum size     : %dx%d\n", sz.width(), sz.height());
      
      inp = vd->GetVideoInputs();
      printf("Video inputs     : %d\n", inp);
      
      for (j = 0; j < inp; j++) {
         vdi = vd->GetVideoInput(j);
         printf(" Input %d\n", j);
         printf("  Name             : \"%s\"\n", (const char *)vdi->GetName());
         switch(vdi->GetType()) {
           case CVideoDeviceInput::Unknown: printf("  Type             : Unknown\n"); break;
           case CVideoDeviceInput::TV:      printf("  Type             : TV\n"); break;
           case CVideoDeviceInput::Camera:  printf("  Type             : Camera\n"); break;
         }
         printf("  Audio            : %s\n", vdi->HasAudio() ? "yes" : "no");
         tun = vdi->GetTuners();
         printf("  Tuners           : %d\n", tun);
         for (k = 0; k < tun; k++) {
            vdt = vdi->GetTuner(k);
            printf("    Name             : \"%s\"\n", (const char *)vdt->GetName());
            printf("    Frequency range  : %6.2f-%6.2f MHz\n", vdt->GetLowestFrequency() / 1.0e6, vdt->GetHighestFrequency() / 1.0e6);
            printf("    Current frequency: %6.2f MHz\n", vdt->GetFrequency() / 1.0e6);
            printf("    Norm setting     : %s\n", vdt->HasNorm() ? "yes" : "no");
         }
      }
      anp = vd->GetAudioInputs();
      printf("Audio inputs     : %d\n", anp);
      for (j = 0; j < anp; j++) {
         vai = vd->GetAudioInput(j);
         printf(" Input %d\n", j);
         printf("  Name             : \"%s\"\n", (const char *)vai->GetName());
         printf("  Mutable          : %s\n", vai->IsMutable() ? "yes" : "no");
      }
      
      printf("\n");
   }
   return 0;
}

