/*
    This file is part of KOrganizer.
    Copyright (c) 2004 Lutz Rogowski <rogowski@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

// $Id: ksyncprofile.cpp,v 1.7 2004/08/07 16:10:17 zautrix Exp $

#include <qcolor.h>

#include <kconfig.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <kdebug.h>

#include "ksyncprofile.h"


KSyncProfile::KSyncProfile(): QObject ()
{
    setDefault();
}
KSyncProfile::~KSyncProfile()
{

}


KSyncProfile* KSyncProfile::clone()
{
    KSyncProfile* myClone = new KSyncProfile();
    myClone->setPreSyncCommand( mPreSyncCommand );
    myClone->setPostSyncCommand( mPostSyncCommand );
    myClone->setLocalTempFile( mLocalTempFile);
    myClone->setRemoteFileName( mRemoteFileName );
    myClone->setPreSyncCommandAB( mPreSyncCommandAB );
    myClone->setPostSyncCommandAB( mPostSyncCommandAB );
    myClone->setLocalTempFileAB( mLocalTempFileAB);
    myClone->setRemoteFileNameAB( mRemoteFileNameAB );
    myClone->setShowSummaryAfterSync( mShowSummaryAfterSync );
    myClone->setAskForPreferences( mAskForPreferences);
    myClone->setWriteBackExisting(mWriteBackExisting );
    myClone->setWriteBackFile( mWriteBackFile);
    myClone->setWriteBackFuture( mWriteBackFuture );
    myClone->setWriteBackFutureWeeks( mWriteBackFutureWeeks );
    myClone->setIncludeInRingSync( mIncludeInRingSync );
    myClone->setIncludeInRingSyncAB( mIncludeInRingSyncAB );
    myClone->setSyncPrefs( mSyncPrefs);
    myClone->setIsLocalFileSync( mIsLocalFileSync );
    myClone->setIsPhoneSync( mIsPhoneSync );
    myClone->setName( "noName" );
    //myClone->setIdentifier( "noID" );
    return myClone;
}


void KSyncProfile::setDefault()
{
    mPreSyncCommand = i18n("command for downloading remote file to local device");
    mPostSyncCommand = i18n("command for uploading local temp file to remote device");
    mLocalTempFile = "/tmp/mycalendar.ics";
    mRemoteFileName = "/home/polo/kdepim/apps/korganizer/localfile.ics";
    mPreSyncCommandAB = i18n("command for downloading remote file to local device");
    mPostSyncCommandAB = i18n("command for uploading local temp file to remote device");
    mLocalTempFileAB = "/tmp/std.vcf";
    mRemoteFileNameAB = "/home/polo/kdepim/apps/kabc/localfile.vcf";
    mShowSummaryAfterSync = true;
    mAskForPreferences = true;
    mWriteBackExisting = false;
    mWriteBackFuture = false;
    mWriteBackFutureWeeks = 12;
    mWriteBackFile = true;
    mIncludeInRingSync = false;
    mIncludeInRingSyncAB = false;
    mSyncPrefs = SYNC_PREF_ASK;
    mIsLocalFileSync = true;
    mName = "noName";
    mIsPhoneSync = false;
    mPhoneDevice = "/dev/ircomm";
    mPhoneConnection = "irda";
    mPhoneModel = "6310i";
}
void KSyncProfile::readConfig(KConfig *config )
{
  if (config)
  {

    config->setGroup( mName );

    mName = config->readEntry( "Name", mName );
    mPreSyncCommand = config->readEntry( "PreSyncCommand",mPreSyncCommand  );
    mPostSyncCommand = config->readEntry( "PostSyncCommand", mPostSyncCommand );
    mLocalTempFile = config->readEntry( "LocalTempFile", mLocalTempFile );
    mRemoteFileName = config->readEntry( "RemoteFileName", mRemoteFileName );

    mPreSyncCommandAB = config->readEntry( "PreSyncCommandAB",mPreSyncCommandAB  );
    mPostSyncCommandAB = config->readEntry( "PostSyncCommandAB", mPostSyncCommandAB );
    mLocalTempFileAB = config->readEntry( "LocalTempFileAB", mLocalTempFileAB );
    mRemoteFileNameAB = config->readEntry( "RemoteFileNameAB", mRemoteFileNameAB );

    mPhoneDevice = config->readEntry( "PhoneDevice", mPhoneDevice );
    mPhoneConnection = config->readEntry( "PhoneConnection", mPhoneConnection );
    mPhoneModel = config->readEntry( "PhoneModel", mPhoneModel );

    mIncludeInRingSync = config->readBoolEntry( "IncludeInRingSync",mIncludeInRingSync  );
    mIncludeInRingSyncAB = config->readBoolEntry( "IncludeInRingSyncAB",mIncludeInRingSyncAB  );
    mShowSummaryAfterSync = config->readBoolEntry( "ShowSummaryAfterSync", mShowSummaryAfterSync );
    mAskForPreferences = config->readBoolEntry( "AskForPreferences",mAskForPreferences  );
    mWriteBackExisting = config->readBoolEntry( "WriteBackExisting",mWriteBackExisting  );
    mWriteBackFuture = config->readBoolEntry( "WriteBackFuture",mWriteBackFuture  );
    mSyncPrefs = config->readNumEntry( "SyncPrefs", mSyncPrefs );
    mWriteBackFutureWeeks = config->readNumEntry( "WriteBackFutureWeeks", mWriteBackFutureWeeks );
    mIsLocalFileSync= config->readBoolEntry( "IsLocalFileSync", mIsLocalFileSync );
    mIsPhoneSync= config->readBoolEntry( "IsPhoneSync", mIsPhoneSync );
  }
  else
  {
    setDefault();
  }
}

void KSyncProfile::deleteConfig(KConfig *config )
{
	config->deleteGroup( mName );
}

void KSyncProfile::writeConfig( KConfig * config )
{
    config->setGroup(mName);

    config->writeEntry( "Name", mName );
    config->writeEntry( "PreSyncCommand",mPreSyncCommand  );
    config->writeEntry( "PostSyncCommand", mPostSyncCommand );
    config->writeEntry( "LocalTempFile", mLocalTempFile );
    config->writeEntry( "RemoteFileName", mRemoteFileName );

    config->writeEntry( "PreSyncCommandAB",mPreSyncCommandAB  );
    config->writeEntry( "PostSyncCommandAB", mPostSyncCommandAB );
    config->writeEntry( "LocalTempFileAB", mLocalTempFileAB );
    config->writeEntry( "RemoteFileNameAB", mRemoteFileNameAB );

    config->writeEntry( "PhoneDevice", mPhoneDevice );
    config->writeEntry( "PhoneConnection", mPhoneConnection );
    config->writeEntry( "PhoneModel", mPhoneModel );

    config->writeEntry( "IncludeInRingSync",mIncludeInRingSync  );
    config->writeEntry( "IncludeInRingSyncAB",mIncludeInRingSyncAB  );
    config->writeEntry( "ShowSummaryAfterSync", mShowSummaryAfterSync );
    config->writeEntry( "AskForPreferences",mAskForPreferences  );
    config->writeEntry( "WriteBackExisting",mWriteBackExisting  );
    config->writeEntry( "WriteBackFuture",mWriteBackFuture );
    config->writeEntry( "SyncPrefs", mSyncPrefs );
    config->writeEntry( "WriteBackFutureWeeks", mWriteBackFutureWeeks);
    config->writeEntry( "IsLocalFileSync", mIsLocalFileSync );
    config->writeEntry( "IsPhoneSync", mIsPhoneSync );
}

/*
class KPrefsItemInt : public KPrefsItem {
  public:
    KPrefsItemInt(const QString &group,const QString &name,int *,int defaultValue=0);
    virtual ~KPrefsItemInt() {}

    void setDefault();
    void readConfig(KConfig *);
    void writeConfig(KConfig *);

  private:
    int *mReference;
    int mDefault;
};
*/
