""" Test3 for Chipmunk """

import pygame
from pygame.locals import *
from pygame.color import *

from elements import *

def main():
    # PyGame Init
    pygame.init()
    screen = pygame.display.set_mode((800, 800))
    clock = pygame.time.Clock()

    fps = ShowFPS(3, clock)
    fps.start()

    # Create the Physical Space Class
    world = elements()
    
    # Add A Wall
    world.add_wall((-2000, 800), (2000, 800))
    world.add_wall((0, 800), (0, 750))
    world.add_wall((800, 800), (800, 750))
    
    # Default Settings
    running = True

    # Main Loop
    while running:
        for event in pygame.event.get():
            if event.type == QUIT or (event.type == KEYDOWN and event.key == K_ESCAPE):
                # Bye Bye
                running = False
                fps.running = False
                
            elif event.type == KEYDOWN and event.key == K_SPACE:    
                # Pause with SPACE
                world.run_physics = not world.run_physics

            elif event.type == MOUSEBUTTONDOWN and event.button == 1:
                # Add Ball
                world.add_ball(event.pos)
                
            elif event.type == MOUSEBUTTONDOWN and event.button == 3:
                # Add Square
                world.add_square(event.pos)

            elif event.type == KEYDOWN:
                if event.unicode == "1":
                    # Add many Balls
                    x, y = pygame.mouse.get_pos()
                    for i in range(5):
                        for j in range(5): world.add_ball((x-i,y-j))
                    print "-----", world.element_count, "Elements"

            
        # Clear Display
#        screen.fill((255,255,255))

        # Update & Draw World
        world.update(50.0)
 #       world.draw(screen)

        # Flip Display
#        pygame.display.flip()
        
        # Try to stay at 50 FPS
        clock.tick(50)
        
        # output framerate in caption
#        pygame.display.set_caption("elements: %i | fps: %s" % (world.element_count, str(int(clock.get_fps()))))

if __name__ == "__main__":
    main()
