/*
 * $Id: StringUtils.java,v 1.5 2007-03-02 19:45:53 larry Exp $ 
 */
package com.representqueens.util;

/*
 * 
 * Copyright 2006 Larry Ogrodnek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Some simple String utilities.
 * 
 * @author Larry Ogrodnek <larry@cheesesteak.net>
 * @version $Revision: 1.5 $ $Date: 2007-03-02 19:45:53 $
 */
public final class StringUtils
{
  private StringUtils() { }
  
  public static boolean isEmpty(final String s)
  {
    return (s == null || "".equals(s));
  }
  
  public static List<Integer> toIntList(final String s)
  {
    return toIntList(s, "\\s*,\\s*");
  }
  
  public static List<Integer> toIntList(final String s, final String sep)
  {
    if (isEmpty(s))
    {
      return Collections.emptyList();
    }
    
    final String[] n = s.split(sep);
    
    final List<Integer> ret = new ArrayList<Integer>(n.length);
    
    for (int i=0; i< n.length; i++)
    {
      ret.add(Integer.parseInt(n[i]));
    }
    
    return ret;
  }
  
  public static String toString(final Number[] data)
  {
    return toString(Arrays.asList(data));
  }
  
  public static String toString(final List<? extends Number> data) 
  {
    if (data.size() == 0)
    {
      return "";
    }
    
    if (data.size() == 1)
    {
      return data.get(0).toString();
    }
    
    final StringBuilder sb = new StringBuilder();
    
    for (int i=0; i< data.size() - 1; i++)
    {
      sb.append(data.get(i)).append(",");
    }

    sb.append(data.get(data.size() - 1));
    
    return sb.toString();
  }
}
