/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.pkcs.NetscapeCertList;
import iaik.pkcs.PKCS7CertList;
import iaik.utils.ASN1InputStream;
import iaik.utils.CollectionVector;
import iaik.utils.Util;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;

public class CertificateFactory
extends CertificateFactorySpi {
    private static Collection a(Object[] objectArray) {
        CollectionVector collectionVector = new CollectionVector();
        if (objectArray != null) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                collectionVector.add(objectArray[n2]);
                ++n2;
            }
        }
        return collectionVector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        Collection collection;
        ASN1InputStream aSN1InputStream;
        if (inputStream instanceof ASN1InputStream) {
            aSN1InputStream = (ASN1InputStream)inputStream;
        } else {
            try {
                aSN1InputStream = new ASN1InputStream(inputStream);
            }
            catch (IOException iOException) {
                throw new CertificateException("Error reading certificates: " + iOException.toString());
            }
        }
        ByteArrayInputStream byteArrayInputStream = null;
        Object[] objectArray = null;
        Throwable throwable = null;
        try {
            try {
                Object object;
                byte[] byArray = Util.readStream(aSN1InputStream);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                byteArrayInputStream.mark(byteArrayInputStream.available());
                boolean bl = false;
                try {
                    object = new PKCS7CertList(byteArrayInputStream);
                    objectArray = ((PKCS7CertList)object).getCertificateList();
                    bl = true;
                }
                catch (IOException iOException) {
                    throwable = iOException;
                }
                catch (Exception exception) {}
                if (!bl) {
                    byteArrayInputStream.reset();
                    byteArrayInputStream.mark(byteArrayInputStream.available());
                    try {
                        objectArray = Util.readCertificateChain(byteArrayInputStream);
                        bl = true;
                    }
                    catch (Exception exception) {}
                }
                if (!bl) {
                    byteArrayInputStream.reset();
                    byteArrayInputStream.mark(byteArrayInputStream.available());
                    try {
                        objectArray = Util.decodePkiPath(Util.readStream(byteArrayInputStream));
                        bl = true;
                    }
                    catch (Exception exception) {}
                }
                if (!bl) {
                    byteArrayInputStream.reset();
                    byteArrayInputStream.mark(byteArrayInputStream.available());
                    object = new NetscapeCertList(byteArrayInputStream);
                    objectArray = ((NetscapeCertList)object).getCertificateList();
                }
                collection = CertificateFactory.a(objectArray);
                Object var8_12 = null;
                if (byteArrayInputStream == null) return collection;
            }
            catch (Exception exception) {
                String string;
                StringBuffer stringBuffer = new StringBuffer("Error parsing certificates! ");
                if (throwable == null) {
                    string = "";
                    throw new CertificateException(stringBuffer.append(string).toString());
                }
                string = throwable.toString();
                throw new CertificateException(stringBuffer.append(string).toString());
            }
        }
        catch (Throwable throwable2) {
            Object var8_13 = null;
            if (byteArrayInputStream == null) throw throwable2;
            try {
                ((InputStream)byteArrayInputStream).close();
                throw throwable2;
            }
            catch (IOException iOException) {
                throw throwable2;
            }
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)byteArrayInputStream).close();
        return collection;
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        try {
            return new X509Certificate(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException("Error reading from InputStream: " + iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        Collection collection;
        ByteArrayInputStream byteArrayInputStream = null;
        X509CRL[] x509CRLArray = null;
        try {
            try {
                byte[] byArray = Util.readStream(inputStream);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                byteArrayInputStream.mark(byteArrayInputStream.available());
                boolean bl = false;
                try {
                    PKCS7CertList pKCS7CertList = new PKCS7CertList(byteArrayInputStream);
                    x509CRLArray = pKCS7CertList.getCRLList();
                    bl = true;
                }
                catch (Exception exception) {}
                if (!bl) {
                    byteArrayInputStream.reset();
                    byteArrayInputStream.mark(byteArrayInputStream.available());
                    x509CRLArray = Util.readCRLChain(byteArrayInputStream);
                }
                collection = CertificateFactory.a(x509CRLArray);
                Object var6_9 = null;
                if (byteArrayInputStream == null) return collection;
            }
            catch (IOException iOException) {
                throw new CRLException("Error reading object: " + iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (byteArrayInputStream == null) throw throwable;
            try {
                ((InputStream)byteArrayInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)byteArrayInputStream).close();
        return collection;
    }

    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        try {
            return new X509CRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException("Error reading from InputStream: " + iOException.getMessage());
        }
    }
}

