/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.signature;

import iaik.xml.crypto.XSecProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class ProxySignature
extends SignatureSpi {
    protected Signature signature_;

    protected abstract String getSignatureName();

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.signature_.verify(byArray);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.signature_.update(byArray, n, n2);
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.signature_.update(by);
    }

    protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        return this.signature_.sign(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        return this.signature_.sign();
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.signature_.setParameter(algorithmParameterSpec);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        this.signature_.setParameter(string, object);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.signature_.initVerify(publicKey);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.signature_.initSign(privateKey, secureRandom);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.signature_.initSign(privateKey);
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return this.signature_.getParameter(string);
    }

    public ProxySignature() throws NoSuchProviderException, NoSuchAlgorithmException {
        String string = this.getSignatureName();
        String string2 = XSecProvider.getDelegationProvider("Signature." + string);
        if (string2 != null) {
            try {
                this.signature_ = Signature.getInstance(string, string2);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new NoSuchAlgorithmException("Signature." + string + " delegation provider '" + string2 + "' not registered.");
            }
        } else {
            this.signature_ = Signature.getInstance(string);
        }
    }
}

