/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.controlli;

import finanze.IDTE.studi2002.calcolo.CalcoloAS;
import finanze.IDTE.studi2002.campi.ComboBoxModel;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.controlli.ControlloQuadroMultiplo;
import java.util.Hashtable;

public class ControlloNumeroPosizioni
extends ControlloQuadroMultiplo {
    protected ControlloNumeroPosizioni(String spec_line, Hashtable componentiModel, String nomeQuadro) {
        super(spec_line, componentiModel, nomeQuadro);
    }

    protected void creaMessaggioErrore() {
        this.messaggio = "-- In presenza di piu' di 10 posizioni con ricavi superiori al 20% non e' possibile inserire dati relativi alle posizioini!";
    }

    protected void impostaErrore() {
        this.gravitaErrore = "scarto_confermabile";
        this.errore = String.valueOf(this.codErrore);
    }

    public boolean verifica() {
        this.esito = true;
        ComboBoxModel cbm = (ComboBoxModel)this.listaModel.lastElement();
        if (cbm.getValue().equals("1")) {
            return this.esito;
        }
        int n = this.getNumeroQuadriMultipli();
        double[][] marginali = CalcoloAS.getMarginali(this.getParametriMarginali());
        int i = 0;
        while (i < this.getNumeroQuadriMultipli()) {
            GericoModel gm = this.getGericoModel(i, 2);
            String codiceStudio = gm.getValue();
            if (codiceStudio.equalsIgnoreCase("ricag")) {
                --n;
            }
            ++i;
        }
        if (marginali != null) {
            this.esito = n - marginali.length <= 10;
        } else {
            boolean bl = this.esito = n <= 10;
        }
        if (!this.esito) {
            this.impostaErrore();
            this.creaMessaggioErrore();
        }
        return this.esito;
    }
}

