/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.Media;
import com.sun.media.jfxmedia.MediaError;
import com.sun.media.jfxmedia.MediaException;
import com.sun.media.jfxmedia.MediaPlayer;
import com.sun.media.jfxmedia.MetadataParser;
import com.sun.media.jfxmedia.events.MediaErrorListener;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.HostUtils;
import com.sun.media.jfxmediaimpl.MediaDisposer;
import com.sun.media.jfxmediaimpl.MediaUtils;
import com.sun.media.jfxmediaimpl.NativeLibLoader;
import com.sun.media.jfxmediaimpl.platform.PlatformManager;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeMediaManager {
    private static NativeMediaManager theInstance = null;
    private static boolean isNativeLayerInitialized = false;
    private List<WeakReference<MediaErrorListener>> errorListeners = new ArrayList<WeakReference<MediaErrorListener>>();
    private static NativeMediaPlayerDisposer playerDisposer = new NativeMediaPlayerDisposer();
    private static Map<MediaPlayer, Boolean> allMediaPlayers = new WeakHashMap<MediaPlayer, Boolean>();
    private final List<String> supportedContentTypes = new ArrayList<String>();

    public static synchronized NativeMediaManager getDefaultInstance() {
        if (theInstance == null) {
            theInstance = new NativeMediaManager();
        }
        return theInstance;
    }

    protected NativeMediaManager() {
    }

    static synchronized void initNativeLayer() {
        if (!isNativeLayerInitialized) {
            PlatformManager.getManager().preloadPlatforms();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (HostUtils.isWindows()) {
                            NativeLibLoader.loadLibrary("glib-lite");
                            NativeLibLoader.loadLibrary("gstreamer-lite");
                        }
                        NativeLibLoader.loadLibrary("jfxmedia");
                        return null;
                    }
                });
            }
            catch (Exception e) {
                MediaUtils.error(null, MediaError.ERROR_MANAGER_ENGINEINIT_FAIL.code(), "Unable to load one or more dependent libraries.", e);
                return;
            }
            Logger.initNative();
            PlatformManager.getManager().loadPlatforms();
            isNativeLayerInitialized = true;
        }
    }

    private synchronized void loadContentTypes() {
        if (!this.supportedContentTypes.isEmpty()) {
            return;
        }
        List<String> npt = PlatformManager.getManager().getSupportedContentTypes();
        if (null != npt && !npt.isEmpty()) {
            this.supportedContentTypes.addAll(npt);
        }
        if (Logger.canLog(1)) {
            StringBuilder sb = new StringBuilder("JFXMedia supported content types:\n");
            for (String type : this.supportedContentTypes) {
                sb.append("    ");
                sb.append(type);
                sb.append("\n");
            }
            Logger.logMsg(1, sb.toString());
        }
    }

    public boolean canPlayContentType(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType == null!");
        }
        if (this.supportedContentTypes.isEmpty()) {
            this.loadContentTypes();
        }
        for (String type : this.supportedContentTypes) {
            if (!contentType.equalsIgnoreCase(type)) continue;
            return true;
        }
        return false;
    }

    public String[] getSupportedContentTypes() {
        if (this.supportedContentTypes.isEmpty()) {
            this.loadContentTypes();
        }
        return this.supportedContentTypes.toArray(new String[1]);
    }

    public static MetadataParser getMetadataParser(Locator locator) {
        return PlatformManager.getManager().createMetadataParser(locator);
    }

    public MediaPlayer getPlayer(Locator locator) {
        NativeMediaManager.initNativeLayer();
        MediaPlayer player = PlatformManager.getManager().createMediaPlayer(locator);
        if (null == player) {
            throw new MediaException("Could not create player!");
        }
        allMediaPlayers.put(player, Boolean.TRUE);
        return player;
    }

    public Media getMedia(Locator locator) {
        NativeMediaManager.initNativeLayer();
        return PlatformManager.getManager().createMedia(locator);
    }

    public void addMediaErrorListener(MediaErrorListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<MediaErrorListener>> it = this.errorListeners.listIterator();
            while (it.hasNext()) {
                MediaErrorListener l = (MediaErrorListener)it.next().get();
                if (l != null) continue;
                it.remove();
            }
            this.errorListeners.add(new WeakReference<MediaErrorListener>(listener));
        }
    }

    public void removeMediaErrorListener(MediaErrorListener listener) {
        if (listener != null) {
            ListIterator<WeakReference<MediaErrorListener>> it = this.errorListeners.listIterator();
            while (it.hasNext()) {
                MediaErrorListener l = (MediaErrorListener)it.next().get();
                if (l != null && l != listener) continue;
                it.remove();
            }
        }
    }

    public static void registerMediaPlayerForDispose(Object obj, MediaPlayer player) {
        MediaDisposer.addResourceDisposer(obj, player, playerDisposer);
    }

    public List<MediaPlayer> getAllMediaPlayers() {
        ArrayList<MediaPlayer> allPlayers = null;
        if (!allMediaPlayers.isEmpty()) {
            allPlayers = new ArrayList<MediaPlayer>(allMediaPlayers.keySet());
        }
        return allPlayers;
    }

    List<WeakReference<MediaErrorListener>> getMediaErrorListeners() {
        return this.errorListeners;
    }

    private static class NativeMediaPlayerDisposer
    implements MediaDisposer.ResourceDisposer {
        private NativeMediaPlayerDisposer() {
        }

        public void disposeResource(Object resource) {
            MediaPlayer player = (MediaPlayer)resource;
            if (player != null) {
                player.dispose();
            }
        }
    }
}

