/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.ClipInterpolator;
import com.sun.scenario.animation.shared.InterpolationInterval;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;

class GeneralClipInterpolator
extends ClipInterpolator {
    private static final double EPSILON = 1.0E-12;
    private KeyFrame[] keyFrames;
    private InterpolationInterval[][] interval = new InterpolationInterval[0][];
    private int[] undefinedStartValues = new int[0];
    private boolean invalid = true;

    GeneralClipInterpolator(KeyFrame[] keyFrameArray) {
        this.keyFrames = keyFrameArray;
    }

    @Override
    ClipInterpolator setKeyFrames(KeyFrame[] keyFrameArray) {
        if (ClipInterpolator.getRealKeyFrameCount(keyFrameArray) == 2) {
            return ClipInterpolator.create(keyFrameArray);
        }
        this.keyFrames = keyFrameArray;
        this.invalid = true;
        return this;
    }

    @Override
    void validate(boolean bl) {
        if (this.invalid) {
            int n;
            Object object;
            Object object2;
            double d;
            HashMap<Object, KeyValue> hashMap = new HashMap<Object, KeyValue>();
            int n2 = this.keyFrames.length;
            int n3 = 0;
            for (n3 = 0; n3 < n2 && Math.abs(d = ((KeyFrame)(object2 = this.keyFrames[n3])).getTime().toMillis()) < 1.0E-12; ++n3) {
                for (KeyValue keyValue : ((KeyFrame)object2).getValues()) {
                    hashMap.put(keyValue.getTarget(), keyValue);
                }
            }
            object2 = new HashMap();
            HashSet<Object> hashSet = new HashSet<Object>();
            while (n3 < n2) {
                KeyFrame keyFrame = this.keyFrames[n3];
                double d2 = keyFrame.getTime().toMillis();
                for (KeyValue keyValue : keyFrame.getValues()) {
                    object = keyValue.getTarget();
                    ArrayList<InterpolationInterval> arrayList = (ArrayList<InterpolationInterval>)object2.get(object);
                    KeyValue keyValue2 = (KeyValue)hashMap.get(object);
                    if (arrayList == null) {
                        arrayList = new ArrayList<InterpolationInterval>();
                        object2.put(object, arrayList);
                        if (keyValue2 == null) {
                            arrayList.add(InterpolationInterval.create(keyValue, d2));
                            hashSet.add(object);
                        } else {
                            arrayList.add(InterpolationInterval.create(keyValue, d2, keyValue2, d2));
                        }
                    } else {
                        assert (keyValue2 != null);
                        arrayList.add(InterpolationInterval.create(keyValue, d2, keyValue2, d2 - ((InterpolationInterval)arrayList.get((int)(arrayList.size() - 1))).millis));
                    }
                    hashMap.put(object, keyValue);
                }
                ++n3;
            }
            int n4 = object2.size();
            if (this.interval.length != n4) {
                this.interval = new InterpolationInterval[n4][];
            }
            if (this.undefinedStartValues.length != (n = hashSet.size())) {
                this.undefinedStartValues = new int[n];
            }
            int n5 = 0;
            Iterator<Object> iterator = object2.entrySet().iterator();
            for (int i = 0; i < n4; ++i) {
                object = (Map.Entry)iterator.next();
                this.interval[i] = new InterpolationInterval[((List)object.getValue()).size()];
                ((List)object.getValue()).toArray(this.interval[i]);
                if (!hashSet.contains(object.getKey())) continue;
                this.undefinedStartValues[n5++] = i;
            }
            this.invalid = false;
        } else if (bl) {
            for (int n : this.undefinedStartValues) {
                this.interval[n][0].recalculateStartValue();
            }
        }
    }

    @Override
    void interpolate(double d) {
        block0: for (InterpolationInterval[] interpolationIntervalArray : this.interval) {
            int n = interpolationIntervalArray.length;
            double d2 = 0.0;
            for (int i = 0; i < n - 1; ++i) {
                InterpolationInterval interpolationInterval = interpolationIntervalArray[i];
                double d3 = interpolationInterval.millis;
                if (d <= d3) {
                    double d4 = (d - d2) / (d3 - d2);
                    interpolationInterval.interpolate(d4);
                    continue block0;
                }
                d2 = d3;
            }
            InterpolationInterval interpolationInterval = interpolationIntervalArray[n - 1];
            double d5 = Math.min(1.0, (d - d2) / (interpolationInterval.millis - d2));
            interpolationInterval.interpolate(d5);
        }
    }
}

