/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.DeployCacheRequest;
import com.sun.deploy.cache.DeployCacheResponse;
import com.sun.deploy.cache.DeploySecureCacheResponse;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class DeployCacheHandler
extends ResponseCache {
    private static final HashSet isNotCacheable = new HashSet();
    private final HashMap inProgress = new HashMap();
    private static final ThreadLocal isDeployPackURL = new ThreadLocal();
    private ThreadLocal inCacheHandler = new ThreadLocal();

    public static void setDeployPackURL(URL uRL) {
        isDeployPackURL.set(uRL);
    }

    public static void clearDeployPackURL() {
        isDeployPackURL.set(null);
    }

    public static void reset() {
        ResponseCache.setDefault(new DeployCacheHandler());
        DeployCacheHandler.clearDeployPackURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheResponse get(URI uRI, String string, Map map) throws IOException {
        Object v;
        if (DownloadEngine.haveDownloadInProgress()) {
            return null;
        }
        CacheResponse cacheResponse = null;
        if (!Cache.isCacheEnabled()) return null;
        if (!string.equals("GET")) return null;
        if (this.inCacheHandler.get() != null) {
            return null;
        }
        HashMap hashMap = this.inProgress;
        synchronized (hashMap) {
            if (!this.inProgress.containsKey(uRI)) {
                this.inProgress.put(uRI, new Object());
            }
            v = this.inProgress.get(uRI);
        }
        hashMap = v;
        synchronized (hashMap) {
            try {
                this.inCacheHandler.set(Boolean.TRUE);
                Serializable serializable = null;
                boolean bl = false;
                URL uRL = (URL)isDeployPackURL.get();
                if (uRL != null) {
                    bl = true;
                }
                final URL uRL2 = bl ? uRL : uRI.toURL();
                final URL uRL3 = HttpUtils.removeQueryStringFromURL(uRL2);
                final String string2 = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL3);
                boolean bl2 = false;
                if (!DeployOfflineManager.isGlobalOffline()) {
                    bl2 = DownloadEngine.isUpdateAvailable(uRL2, string2, bl, map);
                }
                if (!bl2) {
                    try {
                        serializable = (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                CacheEntry cacheEntry = Cache.getCacheEntry(string2 == null ? uRL2 : uRL3, null, string2);
                                if (cacheEntry != null) {
                                    return new File(cacheEntry.getResourceFilename());
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Trace.ignoredException(privilegedActionException);
                    }
                }
                if (serializable == null) {
                    CacheResponse privilegedActionException = null;
                    return privilegedActionException;
                }
                InputStream cacheResponse2 = null;
                final File hashMap2 = serializable;
                if (hashMap2 == null) return cacheResponse;
                try {
                    cacheResponse2 = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new FileInputStream(hashMap2);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Trace.ignoredException(privilegedActionException);
                }
                if (cacheResponse2 == null) return cacheResponse;
                Map map2 = DownloadEngine.getCachedHeaders(string2 == null ? uRL2 : uRL3, string2);
                cacheResponse = uRI.getScheme().equals("https") ? new DeploySecureCacheResponse(cacheResponse2, map2) : new DeployCacheResponse(cacheResponse2, map2);
            }
            finally {
                this.inCacheHandler.set(null);
                HashMap hashMap2 = this.inProgress;
                synchronized (hashMap2) {
                    this.inProgress.remove(v);
                }
            }
            return cacheResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isResourceCacheable(String string, URLConnection uRLConnection) {
        if (!Cache.isCacheEnabled() || !uRLConnection.getUseCaches() && !DownloadEngine.isAlwaysCached(string)) {
            return false;
        }
        if (uRLConnection instanceof HttpURLConnection && !((HttpURLConnection)uRLConnection).getRequestMethod().equals("GET")) {
            return false;
        }
        if (uRLConnection.getHeaderField("content-range") != null) {
            return false;
        }
        String string2 = uRLConnection.getHeaderField("cache-control");
        if (string2 != null && string2.toLowerCase().indexOf("no-store") != -1) {
            return false;
        }
        if (uRLConnection.getLastModified() == 0L && uRLConnection.getExpiration() == 0L) {
            HashSet hashSet = isNotCacheable;
            synchronized (hashSet) {
                isNotCacheable.add(string);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resourceNotCached(String string) {
        HashSet hashSet = isNotCacheable;
        synchronized (hashSet) {
            return isNotCacheable.contains(string);
        }
    }

    public CacheRequest put(URI uRI, URLConnection uRLConnection) throws IOException {
        if (DownloadEngine.haveDownloadInProgress()) {
            return null;
        }
        if (!DeployCacheHandler.isResourceCacheable(uRI.toString(), uRLConnection)) {
            return null;
        }
        URL uRL = (URL)isDeployPackURL.get();
        boolean bl = false;
        if (uRL != null) {
            bl = true;
        }
        URL uRL2 = bl ? uRL : uRI.toURL();
        return new DeployCacheRequest(uRL2, uRLConnection, bl);
    }
}

