/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.jaxb;

import com.sun.istack.internal.FragmentContentHandler;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.api.JAXBRIContext;
import com.sun.xml.internal.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.message.AbstractMessageImpl;
import com.sun.xml.internal.ws.message.AttachmentSetImpl;
import com.sun.xml.internal.ws.message.RootElementSniffer;
import com.sun.xml.internal.ws.message.jaxb.AttachmentMarshallerImpl;
import com.sun.xml.internal.ws.message.jaxb.JAXBBridgeSource;
import com.sun.xml.internal.ws.message.jaxb.MarshallerBridge;
import com.sun.xml.internal.ws.message.stream.StreamMessage;
import com.sun.xml.internal.ws.streaming.MtomStreamWriter;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.streaming.XMLStreamWriterUtil;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public final class JAXBMessage
extends AbstractMessageImpl {
    private HeaderList headers;
    private final Object jaxbObject;
    private final Bridge bridge;
    private String nsUri;
    private String localName;
    private XMLStreamBuffer infoset;

    public static Message create(JAXBRIContext jAXBRIContext, Object object, SOAPVersion sOAPVersion, HeaderList headerList, AttachmentSet attachmentSet) {
        if (!jAXBRIContext.hasSwaRef()) {
            return new JAXBMessage(jAXBRIContext, object, sOAPVersion, headerList, attachmentSet);
        }
        try {
            MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
            Marshaller marshaller = jAXBRIContext.createMarshaller();
            AttachmentMarshallerImpl attachmentMarshallerImpl = new AttachmentMarshallerImpl(attachmentSet);
            marshaller.setAttachmentMarshaller(attachmentMarshallerImpl);
            attachmentMarshallerImpl.cleanup();
            marshaller.marshal(object, mutableXMLStreamBuffer.createFromXMLStreamWriter());
            return new StreamMessage(headerList, attachmentSet, mutableXMLStreamBuffer.readAsXMLStreamReader(), sOAPVersion);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    public static Message create(JAXBRIContext jAXBRIContext, Object object, SOAPVersion sOAPVersion) {
        return JAXBMessage.create(jAXBRIContext, object, sOAPVersion, null, null);
    }

    private JAXBMessage(JAXBRIContext jAXBRIContext, Object object, SOAPVersion sOAPVersion, HeaderList headerList, AttachmentSet attachmentSet) {
        super(sOAPVersion);
        this.bridge = new MarshallerBridge(jAXBRIContext);
        this.jaxbObject = object;
        this.headers = headerList;
        this.attachmentSet = attachmentSet;
    }

    public static Message create(Bridge bridge, Object object, SOAPVersion sOAPVersion) {
        if (!bridge.getContext().hasSwaRef()) {
            return new JAXBMessage(bridge, object, sOAPVersion);
        }
        try {
            MutableXMLStreamBuffer mutableXMLStreamBuffer = new MutableXMLStreamBuffer();
            AttachmentSetImpl attachmentSetImpl = new AttachmentSetImpl();
            AttachmentMarshallerImpl attachmentMarshallerImpl = new AttachmentMarshallerImpl(attachmentSetImpl);
            bridge.marshal(object, mutableXMLStreamBuffer.createFromXMLStreamWriter(), (AttachmentMarshaller)attachmentMarshallerImpl);
            attachmentMarshallerImpl.cleanup();
            return new StreamMessage(null, attachmentSetImpl, mutableXMLStreamBuffer.readAsXMLStreamReader(), sOAPVersion);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    private JAXBMessage(Bridge bridge, Object object, SOAPVersion sOAPVersion) {
        super(sOAPVersion);
        this.bridge = bridge;
        this.jaxbObject = object;
        QName qName = bridge.getTypeReference().tagName;
        this.nsUri = qName.getNamespaceURI();
        this.localName = qName.getLocalPart();
        this.attachmentSet = new AttachmentSetImpl();
    }

    public JAXBMessage(JAXBMessage jAXBMessage) {
        super(jAXBMessage);
        this.headers = jAXBMessage.headers;
        if (this.headers != null) {
            this.headers = new HeaderList(this.headers);
        }
        this.attachmentSet = jAXBMessage.attachmentSet;
        this.jaxbObject = jAXBMessage.jaxbObject;
        this.bridge = jAXBMessage.bridge;
    }

    @Override
    public boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public HeaderList getHeaders() {
        if (this.headers == null) {
            this.headers = new HeaderList();
        }
        return this.headers;
    }

    @Override
    public String getPayloadLocalPart() {
        if (this.localName == null) {
            this.sniff();
        }
        return this.localName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        if (this.nsUri == null) {
            this.sniff();
        }
        return this.nsUri;
    }

    @Override
    public boolean hasPayload() {
        return true;
    }

    private void sniff() {
        RootElementSniffer rootElementSniffer = new RootElementSniffer(false);
        try {
            this.bridge.marshal(this.jaxbObject, rootElementSniffer);
        }
        catch (JAXBException jAXBException) {
            this.nsUri = rootElementSniffer.getNsUri();
            this.localName = rootElementSniffer.getLocalName();
        }
    }

    @Override
    public Source readPayloadAsSource() {
        return new JAXBBridgeSource(this.bridge, this.jaxbObject);
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        JAXBResult jAXBResult = new JAXBResult(unmarshaller);
        try {
            jAXBResult.getHandler().startDocument();
            this.bridge.marshal(this.jaxbObject, jAXBResult);
            jAXBResult.getHandler().endDocument();
        }
        catch (SAXException sAXException) {
            throw new JAXBException(sAXException);
        }
        return (T)jAXBResult.getResult();
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        try {
            Object object;
            if (this.infoset == null) {
                object = new XMLStreamBufferResult();
                this.bridge.marshal(this.jaxbObject, (Result)object);
                this.infoset = ((XMLStreamBufferResult)object).getXMLStreamBuffer();
            }
            if ((object = this.infoset.readAsXMLStreamReader()).getEventType() == 7) {
                XMLStreamReaderUtil.nextElementContent((XMLStreamReader)object);
            }
            return object;
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    @Override
    protected void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        try {
            if (bl) {
                contentHandler = new FragmentContentHandler(contentHandler);
            }
            AttachmentMarshallerImpl attachmentMarshallerImpl = new AttachmentMarshallerImpl(this.attachmentSet);
            this.bridge.marshal(this.jaxbObject, contentHandler, (AttachmentMarshaller)attachmentMarshallerImpl);
            attachmentMarshallerImpl.cleanup();
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException.getMessage(), jAXBException);
        }
    }

    @Override
    public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        try {
            AttachmentMarshaller attachmentMarshaller = xMLStreamWriter instanceof MtomStreamWriter ? ((MtomStreamWriter)((Object)xMLStreamWriter)).getAttachmentMarshaller() : new AttachmentMarshallerImpl(this.attachmentSet);
            OutputStream outputStream = XMLStreamWriterUtil.getOutputStream(xMLStreamWriter);
            if (outputStream != null) {
                this.bridge.marshal(this.jaxbObject, outputStream, xMLStreamWriter.getNamespaceContext(), attachmentMarshaller);
            } else {
                this.bridge.marshal(this.jaxbObject, xMLStreamWriter, attachmentMarshaller);
            }
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    @Override
    public Message copy() {
        return new JAXBMessage(this);
    }
}

