/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PrintingStatus {
    private final PrinterJob job;
    private final Component parent;
    private JDialog abortDialog;
    private JButton abortButton;
    private JLabel statusLabel;
    private MessageFormat statusFormat;
    private final AtomicBoolean isAborted = new AtomicBoolean(false);
    private final Action abortAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PrintingStatus.this.isAborted.get()) {
                PrintingStatus.this.isAborted.set(true);
                PrintingStatus.this.abortButton.setEnabled(false);
                PrintingStatus.this.abortDialog.setTitle(UIManager.getString("PrintingDialog.titleAbortingText"));
                PrintingStatus.this.statusLabel.setText(UIManager.getString("PrintingDialog.contentAbortingText"));
                PrintingStatus.this.job.cancel();
            }
        }
    };
    private final WindowAdapter closeListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            PrintingStatus.this.abortAction.actionPerformed(null);
        }
    };

    public static PrintingStatus createPrintingStatus(Component component, PrinterJob printerJob) {
        return new PrintingStatus(component, printerJob);
    }

    protected PrintingStatus(Component component, PrinterJob printerJob) {
        this.job = printerJob;
        this.parent = component;
    }

    private void init() {
        String string = UIManager.getString("PrintingDialog.titleProgressText");
        String string2 = UIManager.getString("PrintingDialog.contentInitialText");
        this.statusFormat = new MessageFormat(UIManager.getString("PrintingDialog.contentProgressText"));
        String string3 = UIManager.getString("PrintingDialog.abortButtonText");
        String string4 = UIManager.getString("PrintingDialog.abortButtonToolTipText");
        int n = PrintingStatus.getInt("PrintingDialog.abortButtonMnemonic", -1);
        int n2 = PrintingStatus.getInt("PrintingDialog.abortButtonDisplayedMnemonicIndex", -1);
        this.abortButton = new JButton(string3);
        this.abortButton.addActionListener(this.abortAction);
        this.abortButton.setToolTipText(string4);
        if (n != -1) {
            this.abortButton.setMnemonic(n);
        }
        if (n2 != -1) {
            this.abortButton.setDisplayedMnemonicIndex(n2);
        }
        this.statusLabel = new JLabel(string2);
        JOptionPane jOptionPane = new JOptionPane(this.statusLabel, 1, -1, null, new Object[]{this.abortButton}, this.abortButton);
        jOptionPane.getActionMap().put("close", this.abortAction);
        this.abortDialog = this.parent != null && this.parent.getParent() instanceof JViewport ? jOptionPane.createDialog(this.parent.getParent(), string) : jOptionPane.createDialog(this.parent, string);
        this.abortDialog.setDefaultCloseOperation(0);
        this.abortDialog.addWindowListener(this.closeListener);
    }

    public void showModal(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showModalOnEDT(bl);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        PrintingStatus.this.showModalOnEDT(bl);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new RuntimeException(throwable);
            }
        }
    }

    private void showModalOnEDT(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        this.init();
        this.abortDialog.setModal(bl);
        this.abortDialog.setVisible(true);
    }

    public void dispose() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.disposeOnEDT();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PrintingStatus.this.disposeOnEDT();
                }
            });
        }
    }

    private void disposeOnEDT() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.abortDialog != null) {
            this.abortDialog.removeWindowListener(this.closeListener);
            this.abortDialog.dispose();
            this.abortDialog = null;
        }
    }

    public boolean isAborted() {
        return this.isAborted.get();
    }

    public Printable createNotificationPrintable(Printable printable) {
        return new NotificationPrintable(printable);
    }

    static int getInt(Object object, int n) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private class NotificationPrintable
    implements Printable {
        private final Printable printDelegatee;

        public NotificationPrintable(Printable printable) {
            if (printable == null) {
                throw new NullPointerException("Printable is null");
            }
            this.printDelegatee = printable;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, final int n) throws PrinterException {
            int n2 = this.printDelegatee.print(graphics, pageFormat, n);
            if (n2 != 1 && !PrintingStatus.this.isAborted()) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.updateStatusOnEDT(n);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NotificationPrintable.this.updateStatusOnEDT(n);
                        }
                    });
                }
            }
            return n2;
        }

        private void updateStatusOnEDT(int n) {
            assert (SwingUtilities.isEventDispatchThread());
            Object[] objectArray = new Object[]{new Integer(n + 1)};
            PrintingStatus.this.statusLabel.setText(PrintingStatus.this.statusFormat.format(objectArray));
        }
    }
}

