/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAPssSaltParameterSpec;
import iaik.security.md.SHA;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class RSAPssParameterSpec
extends RSAPssSaltParameterSpec
implements Cloneable {
    private Boolean f;
    private int a;
    private MaskGenerationAlgorithm b;
    private AlgorithmID c;
    private MessageDigest d;
    private AlgorithmID e;
    public static final int DEFAULT_TRAILER_FIELD;
    public static final AlgorithmID DEFAULT_MASK_GEN_ALGORITHM;
    public static final AlgorithmID DEFAULT_HASH_ALGORITHM;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash algorithm: " + this.e + "\n");
        stringBuffer.append("Mask generation algorithm: " + this.c + "\n");
        stringBuffer.append("Salt length: " + this.saltLength_ + "\n");
        stringBuffer.append("Trailer field: " + this.a + "\n");
        return stringBuffer.toString();
    }

    public void setTrailerField(int n2) {
        this.a = n2;
    }

    public void setMGFEngine(MaskGenerationAlgorithm maskGenerationAlgorithm) {
        this.b = maskGenerationAlgorithm;
    }

    public void setHashEngine(MessageDigest messageDigest) {
        this.d = messageDigest;
    }

    public void setEncodeDefaultValues(Boolean bl) {
        this.f = bl;
    }

    public int hashCode() {
        return this.e.hashCode() ^ this.c.hashCode() ^ this.saltLength_;
    }

    public int getTrailerField() {
        return this.a;
    }

    public AlgorithmID getMaskGenAlgorithm() {
        return this.c;
    }

    public MaskGenerationAlgorithm getMGFEngine() throws NoSuchAlgorithmException {
        if (this.b == null) {
            this.b = this.c.getMaskGenerationAlgorithmInstance();
            AlgorithmParameters algorithmParameters = this.c.getAlgorithmParameters();
            try {
                this.b.setParameters(algorithmParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Cannot init MGF parameters: " + invalidAlgorithmParameterException.getMessage());
            }
        }
        return this.b;
    }

    public MessageDigest getHashEngine() throws NoSuchAlgorithmException {
        if (this.d == null) {
            try {
                this.d = this.e.getMessageDigestInstance("IAIK");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.d = this.e.getMessageDigestInstance();
            }
        } else {
            this.d.reset();
        }
        return this.d;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.e;
    }

    public Boolean getEncodeDefaultValues() {
        return this.f;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAPssParameterSpec) {
            RSAPssParameterSpec rSAPssParameterSpec = (RSAPssParameterSpec)object;
            bl = super.equals(object);
            if (bl) {
                boolean bl2 = this.e.equals(rSAPssParameterSpec.e) && this.c.equals(rSAPssParameterSpec.c, true) && this.a == rSAPssParameterSpec.a;
                bl &= bl2;
            }
        }
        return bl;
    }

    public Object clone() {
        RSAPssParameterSpec rSAPssParameterSpec = null;
        try {
            rSAPssParameterSpec = (RSAPssParameterSpec)super.clone();
            rSAPssParameterSpec.e = (AlgorithmID)this.e.clone();
            rSAPssParameterSpec.c = (AlgorithmID)this.c.clone();
            rSAPssParameterSpec.saltLength_ = this.saltLength_;
            rSAPssParameterSpec.a = this.a;
            if (this.d != null) {
                rSAPssParameterSpec.d = (MessageDigest)this.d.clone();
            }
            if (this.b != null) {
                rSAPssParameterSpec.b = (MaskGenerationAlgorithm)this.b.clone();
            }
            if (this.f != null) {
                rSAPssParameterSpec.f = new Boolean(this.f);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return rSAPssParameterSpec;
    }

    public RSAPssParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, byte[] byArray) {
        super(byArray);
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing hashAlgorithm id!");
        }
        this.e = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing maskGenAlgorithm id!");
        }
        this.c = algorithmID2;
        this.a = DEFAULT_TRAILER_FIELD;
    }

    public RSAPssParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, int n2) {
        super(n2);
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing hashAlgorithm id!");
        }
        this.e = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing maskGenAlgorithm id!");
        }
        this.c = algorithmID2;
        this.a = DEFAULT_TRAILER_FIELD;
    }

    public RSAPssParameterSpec() {
        this.e = (AlgorithmID)DEFAULT_HASH_ALGORITHM.clone();
        this.d = new SHA();
        this.c = (AlgorithmID)AlgorithmID.mgf1.clone();
        this.c.setParameter(this.e.toASN1Object());
        this.b = new MGF1(this.c, this.d);
        this.a = DEFAULT_TRAILER_FIELD;
    }

    static {
        DEFAULT_HASH_ALGORITHM = (AlgorithmID)AlgorithmID.sha1.clone();
        DEFAULT_MASK_GEN_ALGORITHM = (AlgorithmID)AlgorithmID.mgf1.clone();
        DEFAULT_MASK_GEN_ALGORITHM.setParameter(DEFAULT_HASH_ALGORITHM.toASN1Object());
        DEFAULT_TRAILER_FIELD = 1;
    }
}

